/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import org.jboss.pnc.common.json.JsonOutputConverterMapper;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.BuildRecordPushResult;
import org.jboss.pnc.rest.restmodel.GenericRestEntity;
import org.jboss.pnc.rest.restmodel.causeway.ArtifactImportError;
import org.jboss.pnc.rest.validation.groups.WhenCreatingNew;
import org.jboss.pnc.rest.validation.groups.WhenUpdating;

@JsonDeserialize(builder=BuildRecordPushResultRestBuilder.class)
public class BuildRecordPushResultRest
implements GenericRestEntity<Integer> {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    private Integer id;
    @NotNull
    private Integer buildRecordId;
    @NotNull
    private BuildRecordPushResult.Status status;
    @NotNull
    private String log;
    private List<ArtifactImportError> artifactImportErrors;
    private Integer brewBuildId;
    private String brewBuildUrl;

    public BuildRecordPushResultRest(BuildRecordPushResult buildRecordPushResult) {
        this.id = buildRecordPushResult.getId();
        this.buildRecordId = buildRecordPushResult.getBuildRecord().getId();
        this.status = buildRecordPushResult.getStatus();
        this.log = buildRecordPushResult.getLog();
        this.brewBuildId = buildRecordPushResult.getBrewBuildId();
        this.brewBuildUrl = buildRecordPushResult.getBrewBuildUrl();
    }

    public String toString() {
        return JsonOutputConverterMapper.apply((Object)this);
    }

    public BuildRecordPushResult.Builder toDBEntityBuilder() {
        BuildRecord buildRecord = BuildRecord.Builder.newBuilder().id(this.buildRecordId).build();
        BuildRecordPushResult.Builder builder = BuildRecordPushResult.newBuilder().id(this.id).status(this.status).log(this.combineLog()).buildRecord(buildRecord).brewBuildId(this.brewBuildId).brewBuildUrl(this.brewBuildUrl);
        return builder;
    }

    private String combineLog() {
        return ArtifactImportError.combineMessages(this.log, this.artifactImportErrors);
    }

    public static BuildRecordPushResultRestBuilder builder() {
        return new BuildRecordPushResultRestBuilder();
    }

    public BuildRecordPushResultRest(Integer id, Integer buildRecordId, BuildRecordPushResult.Status status, String log, List<ArtifactImportError> artifactImportErrors, Integer brewBuildId, String brewBuildUrl) {
        this.id = id;
        this.buildRecordId = buildRecordId;
        this.status = status;
        this.log = log;
        this.artifactImportErrors = artifactImportErrors;
        this.brewBuildId = brewBuildId;
        this.brewBuildUrl = brewBuildUrl;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    @Deprecated
    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getBuildRecordId() {
        return this.buildRecordId;
    }

    public BuildRecordPushResult.Status getStatus() {
        return this.status;
    }

    public String getLog() {
        return this.log;
    }

    public List<ArtifactImportError> getArtifactImportErrors() {
        return this.artifactImportErrors;
    }

    public Integer getBrewBuildId() {
        return this.brewBuildId;
    }

    public String getBrewBuildUrl() {
        return this.brewBuildUrl;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class BuildRecordPushResultRestBuilder {
        private Integer id;
        private Integer buildRecordId;
        private BuildRecordPushResult.Status status;
        private String log;
        private List<ArtifactImportError> artifactImportErrors;
        private Integer brewBuildId;
        private String brewBuildUrl;

        BuildRecordPushResultRestBuilder() {
        }

        public BuildRecordPushResultRestBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public BuildRecordPushResultRestBuilder buildRecordId(Integer buildRecordId) {
            this.buildRecordId = buildRecordId;
            return this;
        }

        public BuildRecordPushResultRestBuilder status(BuildRecordPushResult.Status status) {
            this.status = status;
            return this;
        }

        public BuildRecordPushResultRestBuilder log(String log) {
            this.log = log;
            return this;
        }

        public BuildRecordPushResultRestBuilder artifactImportErrors(List<ArtifactImportError> artifactImportErrors) {
            this.artifactImportErrors = artifactImportErrors;
            return this;
        }

        public BuildRecordPushResultRestBuilder brewBuildId(Integer brewBuildId) {
            this.brewBuildId = brewBuildId;
            return this;
        }

        public BuildRecordPushResultRestBuilder brewBuildUrl(String brewBuildUrl) {
            this.brewBuildUrl = brewBuildUrl;
            return this;
        }

        public BuildRecordPushResultRest build() {
            return new BuildRecordPushResultRest(this.id, this.buildRecordId, this.status, this.log, this.artifactImportErrors, this.brewBuildId, this.brewBuildUrl);
        }

        public String toString() {
            return "BuildRecordPushResultRest.BuildRecordPushResultRestBuilder(id=" + this.id + ", buildRecordId=" + this.buildRecordId + ", status=" + this.status + ", log=" + this.log + ", artifactImportErrors=" + this.artifactImportErrors + ", brewBuildId=" + this.brewBuildId + ", brewBuildUrl=" + this.brewBuildUrl + ")";
        }
    }
}

