/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.BuildStatus;
import org.jboss.pnc.rest.restmodel.BuildConfigurationAuditedRest;
import org.jboss.pnc.rest.restmodel.GenericRestEntity;
import org.jboss.pnc.rest.restmodel.UserRest;
import org.jboss.pnc.rest.utils.Utility;
import org.jboss.pnc.rest.validation.groups.WhenCreatingNew;
import org.jboss.pnc.rest.validation.groups.WhenUpdating;
import org.jboss.pnc.spi.BuildCoordinationStatus;
import org.jboss.pnc.spi.BuildExecutionStatus;
import org.jboss.pnc.spi.executor.BuildExecutionConfiguration;
import org.jboss.pnc.spi.executor.BuildExecutionSession;

@XmlRootElement(name="BuildRecord")
public class BuildRecordRest
implements GenericRestEntity<Integer> {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    private Integer id;
    private Date submitTime;
    private Date startTime;
    private Date endTime;
    @ApiModelProperty(dataType="string")
    private BuildCoordinationStatus status;
    private Integer buildConfigurationId;
    private String buildConfigurationName;
    private Integer buildConfigurationRev;
    private Integer projectId;
    private String projectName;
    private Integer userId;
    private String username;
    private String scmRepoURL;
    private String scmRevision;
    private String scmTag;
    private Integer buildEnvironmentId;
    private Map<String, String> attributes = new HashMap<String, String>();
    private String liveLogsUri;
    private Integer buildConfigSetRecordId;
    private String buildContentId;
    private Boolean temporaryBuild;
    private Integer productMilestoneId;
    private UserRest user;
    private BuildConfigurationAuditedRest buildConfigurationAudited;
    private String executionRootName;
    private String executionRootVersion;
    private Integer[] dependentBuildRecordIds;
    private Integer[] dependencyBuildRecordIds;

    public BuildRecordRest() {
    }

    public BuildRecordRest(BuildRecord buildRecord) {
        this.id = buildRecord.getId();
        this.submitTime = buildRecord.getSubmitTime();
        this.startTime = buildRecord.getStartTime();
        this.endTime = buildRecord.getEndTime();
        this.scmRepoURL = buildRecord.getScmRepoURL();
        this.scmRevision = buildRecord.getScmRevision();
        this.scmTag = buildRecord.getScmTag();
        this.attributes = buildRecord.getAttributes();
        this.buildConfigurationId = buildRecord.getBuildConfigurationId();
        this.buildConfigurationRev = buildRecord.getBuildConfigurationRev();
        Utility.performIfNotNull(buildRecord.getBuildConfigurationAudited(), () -> {
            this.buildConfigurationName = buildRecord.getBuildConfigurationAudited().getName();
        });
        Utility.performIfNotNull(buildRecord.getBuildConfigurationAudited(), () -> {
            this.projectId = buildRecord.getBuildConfigurationAudited().getProject().getId();
        });
        Utility.performIfNotNull(buildRecord.getBuildConfigurationAudited(), () -> {
            this.projectName = buildRecord.getBuildConfigurationAudited().getProject().getName();
        });
        Utility.performIfNotNull(buildRecord.getUser(), () -> {
            this.userId = buildRecord.getUser().getId();
        });
        Utility.performIfNotNull(buildRecord.getUser(), () -> {
            this.username = buildRecord.getUser().getUsername();
        });
        Utility.performIfNotNull(buildRecord.getBuildEnvironment(), () -> {
            this.buildEnvironmentId = buildRecord.getBuildEnvironment().getId();
        });
        this.status = BuildCoordinationStatus.fromBuildStatus((BuildStatus)buildRecord.getStatus());
        if (buildRecord.getBuildConfigSetRecord() != null) {
            this.buildConfigSetRecordId = buildRecord.getBuildConfigSetRecord().getId();
        }
        this.buildContentId = buildRecord.getBuildContentId();
        this.temporaryBuild = buildRecord.isTemporaryBuild();
        Utility.performIfNotNull(buildRecord.getProductMilestone(), () -> {
            this.productMilestoneId = buildRecord.getProductMilestone().getId();
        });
        Utility.performIfNotNull(buildRecord.getUser(), () -> {
            this.user = new UserRest(buildRecord.getUser());
        });
        Utility.performIfNotNull(buildRecord.getBuildConfigurationAudited(), () -> {
            this.buildConfigurationAudited = new BuildConfigurationAuditedRest(buildRecord.getBuildConfigurationAudited());
        });
        this.executionRootName = buildRecord.getExecutionRootName();
        this.executionRootVersion = buildRecord.getExecutionRootVersion();
        this.dependencyBuildRecordIds = buildRecord.getDependencyBuildRecordIds();
        this.dependentBuildRecordIds = buildRecord.getDependentBuildRecordIds();
    }

    public BuildRecordRest(BuildExecutionSession buildExecutionSession, Date submitTime, UserRest user, BuildConfigurationAuditedRest buildConfigurationAudited, Integer[] dependencyBuildRecordIds, Integer[] dependentBuildRecordIds) {
        this.id = buildExecutionSession.getId();
        this.submitTime = submitTime;
        this.startTime = buildExecutionSession.getStartTime();
        this.endTime = buildExecutionSession.getEndTime();
        BuildExecutionConfiguration buildExecutionConfig = buildExecutionSession.getBuildExecutionConfiguration();
        this.status = BuildCoordinationStatus.fromBuildExecutionStatus((BuildExecutionStatus)buildExecutionSession.getStatus());
        buildExecutionSession.getLiveLogsUri().ifPresent(logsUri -> this.setLiveLogsUri(logsUri.toString()));
        this.userId = user.getId();
        this.username = user.getUsername();
        this.user = user;
        this.buildConfigurationAudited = buildConfigurationAudited;
        this.buildContentId = buildExecutionConfig.getBuildContentId();
        this.buildConfigurationName = buildExecutionConfig.getName();
        this.scmRepoURL = buildExecutionConfig.getScmRepoURL();
        this.scmRevision = buildExecutionConfig.getScmRevision();
        this.scmTag = buildExecutionConfig.getScmTag();
        this.buildConfigurationId = buildConfigurationAudited.getId();
        this.projectId = buildConfigurationAudited.getProjectId();
        Utility.performIfNotNull(buildConfigurationAudited.getProject(), () -> {
            this.projectName = buildConfigurationAudited.getProject().getName();
        });
        this.temporaryBuild = buildExecutionConfig.isTempBuild();
        this.dependencyBuildRecordIds = dependencyBuildRecordIds;
        this.dependentBuildRecordIds = dependentBuildRecordIds;
    }

    public BuildRecordRest(Integer id, BuildCoordinationStatus buildCoordinationStatus, Date submitTime, Date startTime, Date endTime, UserRest user, BuildConfigurationAuditedRest buildConfigurationAudited, boolean temporaryBuild, Integer[] dependencyBuildRecordIds, Integer[] dependentBuildRecordIds) {
        this.id = id;
        this.submitTime = submitTime;
        this.startTime = startTime;
        this.endTime = endTime;
        this.status = buildCoordinationStatus;
        this.userId = user.getId();
        this.username = user.getUsername();
        this.user = user;
        this.buildConfigurationAudited = buildConfigurationAudited;
        this.buildConfigurationId = buildConfigurationAudited.getId();
        this.buildConfigurationName = buildConfigurationAudited.getName();
        this.projectId = buildConfigurationAudited.getProjectId();
        this.temporaryBuild = temporaryBuild;
        Utility.performIfNotNull(buildConfigurationAudited.getProject(), () -> {
            this.projectName = buildConfigurationAudited.getProject().getName();
        });
        this.dependencyBuildRecordIds = dependencyBuildRecordIds;
        this.dependentBuildRecordIds = dependentBuildRecordIds;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public Date getSubmitTime() {
        return this.submitTime;
    }

    public void setSubmitTime(Date submitTime) {
        this.submitTime = submitTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public BuildCoordinationStatus getStatus() {
        return this.status;
    }

    public void setStatus(BuildCoordinationStatus status) {
        this.status = status;
    }

    public Integer getBuildConfigurationId() {
        return this.buildConfigurationId;
    }

    public void setBuildConfigurationId(Integer buildConfigurationId) {
        this.buildConfigurationId = buildConfigurationId;
    }

    public Integer getBuildConfigurationRev() {
        return this.buildConfigurationRev;
    }

    public void setBuildConfigurationRev(Integer buildConfigurationRev) {
        this.buildConfigurationRev = buildConfigurationRev;
    }

    public String getBuildConfigurationName() {
        return this.buildConfigurationName;
    }

    public void setBuildConfigurationName(String buildConfigurationName) {
        this.buildConfigurationName = buildConfigurationName;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getScmRepoURL() {
        return this.scmRepoURL;
    }

    public void setScmRepoURL(String scmRepoURL) {
        this.scmRepoURL = scmRepoURL;
    }

    public String getScmRevision() {
        return this.scmRevision;
    }

    public void setScmRevision(String scmRevision) {
        this.scmRevision = scmRevision;
    }

    public Integer getBuildEnvironmentId() {
        return this.buildEnvironmentId;
    }

    public void setBuildEnvironmentId(Integer buildEnvironmentId) {
        this.buildEnvironmentId = buildEnvironmentId;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public void putAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public String getLiveLogsUri() {
        return this.liveLogsUri;
    }

    public void setLiveLogsUri(String liveLogsUri) {
        this.liveLogsUri = liveLogsUri;
    }

    public Integer getBuildConfigSetRecordId() {
        return this.buildConfigSetRecordId;
    }

    public String getBuildContentId() {
        return this.buildContentId;
    }

    public void setBuildContentId(String buildContentId) {
        this.buildContentId = buildContentId;
    }

    public Integer getProductMilestoneId() {
        return this.productMilestoneId;
    }

    public void setProductMilestoneId(Integer productMilestoneId) {
        this.productMilestoneId = productMilestoneId;
    }

    public UserRest getUser() {
        return this.user;
    }

    public BuildConfigurationAuditedRest getBuildConfigurationAudited() {
        return this.buildConfigurationAudited;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String toString() {
        return "BuildRecordRest(id=" + this.getId() + ", submitTime=" + this.getSubmitTime() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", status=" + this.getStatus() + ", buildConfigurationId=" + this.getBuildConfigurationId() + ", buildConfigurationName=" + this.getBuildConfigurationName() + ", buildConfigurationRev=" + this.getBuildConfigurationRev() + ", projectId=" + this.getProjectId() + ", projectName=" + this.getProjectName() + ", userId=" + this.getUserId() + ", username=" + this.getUsername() + ", scmRepoURL=" + this.getScmRepoURL() + ", scmRevision=" + this.getScmRevision() + ", scmTag=" + this.getScmTag() + ", buildEnvironmentId=" + this.getBuildEnvironmentId() + ", attributes=" + this.getAttributes() + ", liveLogsUri=" + this.getLiveLogsUri() + ", buildConfigSetRecordId=" + this.getBuildConfigSetRecordId() + ", buildContentId=" + this.getBuildContentId() + ", temporaryBuild=" + this.getTemporaryBuild() + ", productMilestoneId=" + this.getProductMilestoneId() + ", user=" + this.getUser() + ", buildConfigurationAudited=" + this.getBuildConfigurationAudited() + ", executionRootName=" + this.getExecutionRootName() + ", executionRootVersion=" + this.getExecutionRootVersion() + ", dependentBuildRecordIds=" + Arrays.deepToString(this.getDependentBuildRecordIds()) + ", dependencyBuildRecordIds=" + Arrays.deepToString(this.getDependencyBuildRecordIds()) + ")";
    }

    public String getScmTag() {
        return this.scmTag;
    }

    public void setScmTag(String scmTag) {
        this.scmTag = scmTag;
    }

    public Boolean getTemporaryBuild() {
        return this.temporaryBuild;
    }

    @Deprecated
    public void setTemporaryBuild(Boolean temporaryBuild) {
        this.temporaryBuild = temporaryBuild;
    }

    public String getExecutionRootName() {
        return this.executionRootName;
    }

    public void setExecutionRootName(String executionRootName) {
        this.executionRootName = executionRootName;
    }

    public String getExecutionRootVersion() {
        return this.executionRootVersion;
    }

    public void setExecutionRootVersion(String executionRootVersion) {
        this.executionRootVersion = executionRootVersion;
    }

    public Integer[] getDependentBuildRecordIds() {
        return this.dependentBuildRecordIds;
    }

    public void setDependentBuildRecordIds(Integer[] dependentBuildRecordIds) {
        this.dependentBuildRecordIds = dependentBuildRecordIds;
    }

    public Integer[] getDependencyBuildRecordIds() {
        return this.dependencyBuildRecordIds;
    }

    public void setDependencyBuildRecordIds(Integer[] dependencyBuildRecordIds) {
        this.dependencyBuildRecordIds = dependencyBuildRecordIds;
    }
}

