/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.xml.bind.annotation.XmlRootElement;
import org.hibernate.validator.constraints.NotBlank;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.model.RepositoryConfiguration;
import org.jboss.pnc.rest.restmodel.GenericRestEntity;
import org.jboss.pnc.rest.validation.exceptions.InvalidEntityException;
import org.jboss.pnc.rest.validation.groups.WhenCreatingNew;
import org.jboss.pnc.rest.validation.groups.WhenUpdating;
import org.jboss.pnc.rest.validation.validators.ScmUrl;

@XmlRootElement(name="RepositoryConfiguration")
public class RepositoryConfigurationRest
implements GenericRestEntity<Integer> {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    private Integer id;
    @NotBlank(groups={WhenUpdating.class, WhenCreatingNew.class})
    @ScmUrl(groups={WhenUpdating.class, WhenCreatingNew.class})
    private String internalUrl;
    @ScmUrl(groups={WhenUpdating.class, WhenCreatingNew.class})
    private String externalUrl;
    private Boolean preBuildSyncEnabled;

    public RepositoryConfigurationRest() {
    }

    public RepositoryConfigurationRest(RepositoryConfiguration repositoryConfiguration) {
        this.id = repositoryConfiguration.getId();
        this.internalUrl = repositoryConfiguration.getInternalUrl();
        this.externalUrl = repositoryConfiguration.getExternalUrl();
        this.preBuildSyncEnabled = repositoryConfiguration.isPreBuildSyncEnabled();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public RepositoryConfiguration.Builder toDBEntityBuilder() {
        RepositoryConfiguration.Builder builder = RepositoryConfiguration.Builder.newBuilder().id(this.id).internalUrl(this.internalUrl).externalUrl(this.externalUrl).preBuildSyncEnabled(Boolean.TRUE.equals(this.preBuildSyncEnabled));
        return builder;
    }

    public void validate() throws InvalidEntityException {
        if (StringUtils.isEmpty((String)this.getExternalUrl()) && Boolean.TRUE.equals(this.getPreBuildSyncEnabled())) {
            throw new InvalidEntityException("Pre-build sync cannot be enabled without external repository url.");
        }
    }

    public static RepositoryConfigurationRestBuilder builder() {
        return new RepositoryConfigurationRestBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepositoryConfigurationRest)) {
            return false;
        }
        RepositoryConfigurationRest other = (RepositoryConfigurationRest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$internalUrl = this.getInternalUrl();
        String other$internalUrl = other.getInternalUrl();
        if (this$internalUrl == null ? other$internalUrl != null : !this$internalUrl.equals(other$internalUrl)) {
            return false;
        }
        String this$externalUrl = this.getExternalUrl();
        String other$externalUrl = other.getExternalUrl();
        if (this$externalUrl == null ? other$externalUrl != null : !this$externalUrl.equals(other$externalUrl)) {
            return false;
        }
        Boolean this$preBuildSyncEnabled = this.getPreBuildSyncEnabled();
        Boolean other$preBuildSyncEnabled = other.getPreBuildSyncEnabled();
        return !(this$preBuildSyncEnabled == null ? other$preBuildSyncEnabled != null : !((Object)this$preBuildSyncEnabled).equals(other$preBuildSyncEnabled));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RepositoryConfigurationRest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $internalUrl = this.getInternalUrl();
        result = result * 59 + ($internalUrl == null ? 43 : $internalUrl.hashCode());
        String $externalUrl = this.getExternalUrl();
        result = result * 59 + ($externalUrl == null ? 43 : $externalUrl.hashCode());
        Boolean $preBuildSyncEnabled = this.getPreBuildSyncEnabled();
        result = result * 59 + ($preBuildSyncEnabled == null ? 43 : ((Object)$preBuildSyncEnabled).hashCode());
        return result;
    }

    public String toString() {
        return "RepositoryConfigurationRest(id=" + this.getId() + ", internalUrl=" + this.getInternalUrl() + ", externalUrl=" + this.getExternalUrl() + ", preBuildSyncEnabled=" + this.getPreBuildSyncEnabled() + ")";
    }

    public RepositoryConfigurationRest(Integer id, String internalUrl, String externalUrl, Boolean preBuildSyncEnabled) {
        this.id = id;
        this.internalUrl = internalUrl;
        this.externalUrl = externalUrl;
        this.preBuildSyncEnabled = preBuildSyncEnabled;
    }

    public String getInternalUrl() {
        return this.internalUrl;
    }

    public void setInternalUrl(String internalUrl) {
        this.internalUrl = internalUrl;
    }

    public String getExternalUrl() {
        return this.externalUrl;
    }

    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    public Boolean getPreBuildSyncEnabled() {
        return this.preBuildSyncEnabled;
    }

    public void setPreBuildSyncEnabled(Boolean preBuildSyncEnabled) {
        this.preBuildSyncEnabled = preBuildSyncEnabled;
    }

    public static class RepositoryConfigurationRestBuilder {
        private Integer id;
        private String internalUrl;
        private String externalUrl;
        private Boolean preBuildSyncEnabled;

        RepositoryConfigurationRestBuilder() {
        }

        public RepositoryConfigurationRestBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public RepositoryConfigurationRestBuilder internalUrl(String internalUrl) {
            this.internalUrl = internalUrl;
            return this;
        }

        public RepositoryConfigurationRestBuilder externalUrl(String externalUrl) {
            this.externalUrl = externalUrl;
            return this;
        }

        public RepositoryConfigurationRestBuilder preBuildSyncEnabled(Boolean preBuildSyncEnabled) {
            this.preBuildSyncEnabled = preBuildSyncEnabled;
            return this;
        }

        public RepositoryConfigurationRest build() {
            return new RepositoryConfigurationRest(this.id, this.internalUrl, this.externalUrl, this.preBuildSyncEnabled);
        }

        public String toString() {
            return "RepositoryConfigurationRest.RepositoryConfigurationRestBuilder(id=" + this.id + ", internalUrl=" + this.internalUrl + ", externalUrl=" + this.externalUrl + ", preBuildSyncEnabled=" + this.preBuildSyncEnabled + ")";
        }
    }
}

