/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel.causeway;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import org.jboss.pnc.rest.restmodel.bpm.BpmNotificationRest;
import org.jboss.pnc.rest.restmodel.causeway.BuildImportResultRest;
import org.jboss.pnc.rest.restmodel.causeway.BuildImportStatus;
import org.jboss.pnc.rest.restmodel.causeway.ReleaseStatus;

public class MilestoneReleaseResultRest
extends BpmNotificationRest {
    private Integer milestoneId;
    private ReleaseStatus releaseStatus;
    private String errorMessage;
    private List<BuildImportResultRest> builds = new ArrayList<BuildImportResultRest>();

    @Override
    public String getEventType() {
        return "BREW_IMPORT_SUCCESS";
    }

    @JsonIgnore
    public boolean isSuccessful() {
        return !this.builds.isEmpty() && this.allBuildsSuccessful();
    }

    private boolean allBuildsSuccessful() {
        return this.builds.stream().allMatch(r -> r.getStatus() == BuildImportStatus.SUCCESSFUL);
    }

    public Integer getMilestoneId() {
        return this.milestoneId;
    }

    public ReleaseStatus getReleaseStatus() {
        return this.releaseStatus;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<BuildImportResultRest> getBuilds() {
        return this.builds;
    }

    public void setMilestoneId(Integer milestoneId) {
        this.milestoneId = milestoneId;
    }

    public void setReleaseStatus(ReleaseStatus releaseStatus) {
        this.releaseStatus = releaseStatus;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setBuilds(List<BuildImportResultRest> builds) {
        this.builds = builds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MilestoneReleaseResultRest)) {
            return false;
        }
        MilestoneReleaseResultRest other = (MilestoneReleaseResultRest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$milestoneId = this.getMilestoneId();
        Integer other$milestoneId = other.getMilestoneId();
        if (this$milestoneId == null ? other$milestoneId != null : !((Object)this$milestoneId).equals(other$milestoneId)) {
            return false;
        }
        ReleaseStatus this$releaseStatus = this.getReleaseStatus();
        ReleaseStatus other$releaseStatus = other.getReleaseStatus();
        if (this$releaseStatus == null ? other$releaseStatus != null : !((Object)((Object)this$releaseStatus)).equals((Object)other$releaseStatus)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        List<BuildImportResultRest> this$builds = this.getBuilds();
        List<BuildImportResultRest> other$builds = other.getBuilds();
        return !(this$builds == null ? other$builds != null : !((Object)this$builds).equals(other$builds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MilestoneReleaseResultRest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $milestoneId = this.getMilestoneId();
        result = result * 59 + ($milestoneId == null ? 43 : ((Object)$milestoneId).hashCode());
        ReleaseStatus $releaseStatus = this.getReleaseStatus();
        result = result * 59 + ($releaseStatus == null ? 43 : ((Object)((Object)$releaseStatus)).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        List<BuildImportResultRest> $builds = this.getBuilds();
        result = result * 59 + ($builds == null ? 43 : ((Object)$builds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MilestoneReleaseResultRest(milestoneId=" + this.getMilestoneId() + ", releaseStatus=" + (Object)((Object)this.getReleaseStatus()) + ", errorMessage=" + this.getErrorMessage() + ", builds=" + this.getBuilds() + ")";
    }
}

