/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.validation.exceptions;

import java.lang.reflect.Field;
import java.util.Optional;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import org.jboss.pnc.rest.validation.exceptions.RestValidationException;
import org.jboss.pnc.rest.validation.exceptions.model.InvalidEntityDetailsRest;

public class InvalidEntityException
extends RestValidationException {
    private final String field;

    public InvalidEntityException(String message) {
        super(message);
        this.field = null;
    }

    public InvalidEntityException(Field field) {
        super("Field validation error occurred. Field: " + field.getName());
        this.field = field.getName();
    }

    public InvalidEntityException(ConstraintViolation<?> validationProblem) {
        super("Field validation error occurred. " + InvalidEntityException.getErrorDescription(validationProblem));
        this.field = InvalidEntityException.getFieldName(validationProblem);
    }

    private static String getErrorDescription(ConstraintViolation<?> validationProblem) {
        String field = InvalidEntityException.getFieldName(validationProblem);
        String message = validationProblem.getMessage();
        return "Field: " + field + ", problem: " + message;
    }

    private static String getFieldName(ConstraintViolation<?> validationProblem) {
        return ((Path.Node)validationProblem.getPropertyPath().iterator().next()).getName();
    }

    public String getField() {
        return this.field;
    }

    @Override
    public Optional<Object> getRestModelForException() {
        return Optional.of(new InvalidEntityDetailsRest(this));
    }
}

