/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.provider.collection;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.jboss.pnc.rest.provider.collection.CollectionInfo;

public class CollectionInfoCollector<T>
implements Collector<T, List<T>, CollectionInfo<T>> {
    private final int pageIndex;
    private final int pageSize;
    private final int totalPages;

    public CollectionInfoCollector(int pageIndex, int pageSize, int totalPages) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.totalPages = totalPages;
    }

    @Override
    public Supplier<List<T>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<List<T>, T> accumulator() {
        return (list, t) -> list.add(t);
    }

    @Override
    public BinaryOperator<List<T>> combiner() {
        return (left, right) -> {
            left.addAll(right);
            return left;
        };
    }

    @Override
    public Function<List<T>, CollectionInfo<T>> finisher() {
        return list -> new CollectionInfo(this.pageIndex, this.pageSize, this.totalPages, list);
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return EnumSet.of(Collector.Characteristics.UNORDERED);
    }
}

