/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.rest.restmodel.GenericRestEntity;
import org.jboss.pnc.rest.restmodel.TargetRepositoryRest;
import org.jboss.pnc.rest.utils.StreamHelper;
import org.jboss.pnc.rest.validation.groups.WhenCreatingNew;
import org.jboss.pnc.rest.validation.groups.WhenUpdating;

@XmlRootElement(name="Artifact")
public class ArtifactRest
implements GenericRestEntity<Integer> {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    private Integer id;
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    private String identifier;
    @ApiModelProperty(dataType="string")
    private Artifact.Quality artifactQuality;
    private TargetRepositoryRest targetRepository;
    private String md5;
    private String sha1;
    private String sha256;
    private String filename;
    private String deployPath;
    private Set<Integer> buildRecordIds;
    private Set<Integer> dependantBuildRecordIds;
    private Date importDate;
    private String originUrl;
    private Long size;
    private String deployUrl;
    private String publicUrl;

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public ArtifactRest() {
    }

    public ArtifactRest(Artifact artifact, String deployUrl, String publicUrl) {
        this.id = artifact.getId();
        this.identifier = artifact.getIdentifier();
        this.md5 = artifact.getMd5();
        this.sha1 = artifact.getSha1();
        this.sha256 = artifact.getSha256();
        this.filename = artifact.getFilename();
        this.deployPath = artifact.getDeployPath();
        this.artifactQuality = artifact.getArtifactQuality();
        this.importDate = artifact.getImportDate();
        this.originUrl = artifact.getOriginUrl();
        this.buildRecordIds = StreamHelper.nullableStreamOf(artifact.getBuildRecords()).map(BuildRecord::getId).collect(Collectors.toSet());
        this.dependantBuildRecordIds = StreamHelper.nullableStreamOf(artifact.getDependantBuildRecords()).map(BuildRecord::getId).collect(Collectors.toSet());
        this.size = artifact.getSize();
        this.deployUrl = deployUrl;
        this.publicUrl = publicUrl;
        this.targetRepository = new TargetRepositoryRest(artifact.getTargetRepository());
    }

    public ArtifactRest(Artifact artifact) {
        this(artifact, "", "");
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public TargetRepositoryRest getTargetRepository() {
        return this.targetRepository;
    }

    public void setTargetRepository(TargetRepositoryRest targetRepository) {
        this.targetRepository = targetRepository;
    }

    public Artifact.Quality getArtifactQuality() {
        return this.artifactQuality;
    }

    public void setArtifactQuality(Artifact.Quality artifactQuality) {
        this.artifactQuality = artifactQuality;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getDeployPath() {
        return this.deployPath;
    }

    public void setDeployPath(String deployPath) {
        this.deployPath = deployPath;
    }

    public Date getImportDate() {
        return this.importDate;
    }

    public void setImportDate(Date importDate) {
        this.importDate = importDate;
    }

    public String getOriginUrl() {
        return this.originUrl;
    }

    public void setOriginUrl(String originUrl) {
        this.originUrl = originUrl;
    }

    @JsonIgnore
    public boolean isImported() {
        return this.originUrl != null && !this.originUrl.isEmpty();
    }

    @Deprecated
    @JsonIgnore
    public String getStatus() {
        if (this.buildRecordIds != null && this.buildRecordIds.size() > 0) {
            return "BINARY_BUILT";
        }
        return "BINARY_IMPORTED";
    }

    public Set<Integer> getBuildRecordIds() {
        return this.buildRecordIds;
    }

    public void setBuildRecordIds(Set<Integer> buildRecordIds) {
        this.buildRecordIds = buildRecordIds;
    }

    @JsonIgnore
    public boolean isBuilt() {
        return this.buildRecordIds != null && this.buildRecordIds.size() > 0;
    }

    public Set<Integer> getDependantBuildRecordIds() {
        return this.dependantBuildRecordIds;
    }

    public void setDependantBuildRecordIds(Set<Integer> dependantBuildRecordIds) {
        this.dependantBuildRecordIds = dependantBuildRecordIds;
    }

    public Artifact.Builder toDBEntityBuilder() {
        Artifact.Builder builder = Artifact.Builder.newBuilder().id(this.getId()).identifier(this.getIdentifier()).md5(this.getMd5()).sha1(this.getSha1()).sha256(this.getSha256()).size(this.getSize()).targetRepository(this.targetRepository.toDBEntityBuilder().build()).artifactQuality(this.getArtifactQuality()).deployPath(this.getDeployPath()).importDate(this.getImportDate()).originUrl(this.getOriginUrl()).filename(this.getFilename());
        StreamHelper.nullableStreamOf(this.getBuildRecordIds()).forEach(buildRecordId -> builder.buildRecord(BuildRecord.Builder.newBuilder().id(buildRecordId).build()));
        StreamHelper.nullableStreamOf(this.getDependantBuildRecordIds()).forEach(depBuildRecordId -> builder.dependantBuildRecord(BuildRecord.Builder.newBuilder().id(depBuildRecordId).build()));
        return builder;
    }

    public String toString() {
        return "ArtifactRest{id=" + this.id + ", identifier='" + this.identifier + '\'' + ", artifactQuality=" + this.artifactQuality + ", targetRepository=" + this.targetRepository.toString() + ", md5='" + this.md5 + '\'' + ", sha1='" + this.sha1 + '\'' + ", sha256='" + this.sha256 + '\'' + ", filename='" + this.filename + '\'' + ", deployPath='" + this.deployPath + '\'' + ", buildRecordIds=" + this.buildRecordIds + ", dependantBuildRecordIds=" + this.dependantBuildRecordIds + ", importDate=" + this.importDate + ", originUrl='" + this.originUrl + '\'' + ", deployUrl='" + this.deployUrl + '\'' + ", publicUrl='" + this.publicUrl + '\'' + '}';
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public String getSha256() {
        return this.sha256;
    }

    public void setSha256(String sha256) {
        this.sha256 = sha256;
    }

    public String getDeployUrl() {
        return this.deployUrl;
    }

    public void setDeployUrl(String deployUrl) {
        this.deployUrl = deployUrl;
    }

    public String getPublicUrl() {
        return this.publicUrl;
    }

    public void setPublicUrl(String publicUrl) {
        this.publicUrl = publicUrl;
    }
}

