/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import io.swagger.annotations.ApiModelProperty;
import java.util.Collections;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.model.BuildEnvironment;
import org.jboss.pnc.model.SystemImageType;
import org.jboss.pnc.rest.restmodel.GenericRestEntity;
import org.jboss.pnc.rest.validation.groups.WhenCreatingNew;
import org.jboss.pnc.rest.validation.groups.WhenUpdating;

@XmlRootElement(name="BuildEnvironment")
public class BuildEnvironmentRest
implements GenericRestEntity<Integer> {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    private Integer id;
    @ApiModelProperty(dataType="string")
    private String name;
    @ApiModelProperty(dataType="string")
    private String description;
    @ApiModelProperty(dataType="string")
    private String systemImageRepositoryUrl;
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    @ApiModelProperty(dataType="string")
    private String systemImageId;
    private Map<String, String> attributes;
    @ApiModelProperty(dataType="string")
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    private SystemImageType systemImageType;
    @ApiModelProperty(dataType="boolean")
    private boolean deprecated;

    public BuildEnvironmentRest() {
    }

    public BuildEnvironmentRest(BuildEnvironment buildEnvironment) {
        this.id = buildEnvironment.getId();
        this.name = buildEnvironment.getName();
        this.description = buildEnvironment.getDescription();
        this.systemImageRepositoryUrl = buildEnvironment.getSystemImageRepositoryUrl();
        this.systemImageId = buildEnvironment.getSystemImageId();
        if (buildEnvironment.getAttributes() != null) {
            this.attributes = Collections.unmodifiableMap(buildEnvironment.getAttributes());
        }
        this.systemImageType = buildEnvironment.getSystemImageType();
        this.deprecated = buildEnvironment.isDeprecated();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public SystemImageType getSystemImageType() {
        return this.systemImageType;
    }

    public void setSystemImageType(SystemImageType systemImageType) {
        this.systemImageType = systemImageType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Deprecated
    public String getImageRepositoryUrl() {
        return this.systemImageRepositoryUrl;
    }

    @Deprecated
    public void setImageRepositoryUrl(String systemImageRepositoryUrl) {
        this.systemImageRepositoryUrl = systemImageRepositoryUrl;
    }

    public String getSystemImageRepositoryUrl() {
        return this.systemImageRepositoryUrl;
    }

    public void setSystemImageRepositoryUrl(String systemImageRepositoryUrl) {
        this.systemImageRepositoryUrl = systemImageRepositoryUrl;
    }

    public String getSystemImageId() {
        return this.systemImageId;
    }

    public void setSystemImageId(String systemImageId) {
        this.systemImageId = systemImageId;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public BuildEnvironment.Builder toDBEntityBuilder() {
        return BuildEnvironment.Builder.newBuilder().id(this.getId()).name(this.getName()).description(this.getDescription()).systemImageRepositoryUrl(this.getSystemImageRepositoryUrl()).systemImageId(this.getSystemImageId()).attributes(this.getAttributes()).systemImageType(this.getSystemImageType()).deprecated(this.isDeprecated());
    }

    public String toString() {
        return "BuildEnvironmentRest(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", systemImageRepositoryUrl=" + this.getSystemImageRepositoryUrl() + ", systemImageId=" + this.getSystemImageId() + ", attributes=" + this.getAttributes() + ", systemImageType=" + this.getSystemImageType() + ", deprecated=" + this.isDeprecated() + ")";
    }
}

