/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildType;
import org.jboss.pnc.model.ProductVersion;
import org.jboss.pnc.rest.restmodel.BuildEnvironmentRest;
import org.jboss.pnc.rest.restmodel.GenericRestEntity;
import org.jboss.pnc.rest.restmodel.ProjectRest;
import org.jboss.pnc.rest.restmodel.RepositoryConfigurationRest;
import org.jboss.pnc.rest.utils.StreamHelper;
import org.jboss.pnc.rest.utils.Utility;
import org.jboss.pnc.rest.validation.groups.WhenCreatingNew;
import org.jboss.pnc.rest.validation.groups.WhenUpdating;

@XmlRootElement(name="Configuration")
public class BuildConfigurationRest
implements GenericRestEntity<Integer> {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    private Integer id;
    @NotNull(groups={WhenCreatingNew.class})
    @Pattern(regexp="^[a-zA-Z0-9_.][a-zA-Z0-9_.-]*(?<!\\.git)$", groups={WhenCreatingNew.class, WhenUpdating.class})
    private @NotNull(groups={WhenCreatingNew.class}) @Pattern(regexp="^[a-zA-Z0-9_.][a-zA-Z0-9_.-]*(?<!\\.git)$", groups={WhenCreatingNew.class, WhenUpdating.class}) String name;
    private String description;
    private String buildScript;
    @NotNull
    private RepositoryConfigurationRest repositoryConfiguration;
    private String scmRevision;
    private Date creationTime;
    private Date lastModificationTime;
    private boolean archived;
    @NotNull(groups={WhenCreatingNew.class})
    private ProjectRest project;
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    private BuildType buildType;
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    private BuildEnvironmentRest environment;
    private Set<Integer> dependencyIds;
    private Integer productVersionId;
    private Set<Integer> buildConfigurationSetIds;
    private Map<String, String> genericParameters;

    public BuildConfigurationRest() {
    }

    public BuildConfigurationRest(BuildConfiguration buildConfiguration) {
        this.id = buildConfiguration.getId();
        this.name = buildConfiguration.getName();
        this.description = buildConfiguration.getDescription();
        this.buildScript = buildConfiguration.getBuildScript();
        this.scmRevision = buildConfiguration.getScmRevision();
        if (buildConfiguration.getCreationTime() != null) {
            this.creationTime = new Date(buildConfiguration.getCreationTime().getTime());
        }
        if (buildConfiguration.getLastModificationTime() != null) {
            this.lastModificationTime = new Date(buildConfiguration.getLastModificationTime().getTime());
        }
        this.archived = buildConfiguration.isArchived();
        if (buildConfiguration.getGenericParameters() != null) {
            this.genericParameters = Collections.unmodifiableMap(buildConfiguration.getGenericParameters());
        }
        Utility.performIfNotNull(buildConfiguration.getRepositoryConfiguration(), () -> {
            this.repositoryConfiguration = new RepositoryConfigurationRest(buildConfiguration.getRepositoryConfiguration());
        });
        Utility.performIfNotNull(buildConfiguration.getProject(), () -> {
            this.project = new ProjectRest(buildConfiguration.getProject());
        });
        Utility.performIfNotNull(buildConfiguration.getBuildEnvironment(), () -> {
            this.environment = new BuildEnvironmentRest(buildConfiguration.getBuildEnvironment());
        });
        this.dependencyIds = StreamHelper.nullableStreamOf(buildConfiguration.getDependencies()).map(dependencyConfig -> dependencyConfig.getId()).collect(Collectors.toSet());
        Utility.performIfNotNull(buildConfiguration.getProductVersion(), () -> {
            this.productVersionId = buildConfiguration.getProductVersion().getId();
        });
        this.buildType = buildConfiguration.getBuildType();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBuildScript() {
        return this.buildScript;
    }

    public void setBuildScript(String buildScript) {
        this.buildScript = buildScript;
    }

    public String getScmRevision() {
        return this.scmRevision;
    }

    public void setScmRevision(String scmRevision) {
        this.scmRevision = scmRevision;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getLastModificationTime() {
        return this.lastModificationTime;
    }

    public void setLastModificationTime(Date lastModificationTime) {
        this.lastModificationTime = lastModificationTime;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public ProjectRest getProject() {
        return this.project;
    }

    public void setProject(ProjectRest project) {
        this.project = project;
    }

    public Integer getProductVersionId() {
        return this.productVersionId;
    }

    public void setProductVersionId(Integer productVersionId) {
        this.productVersionId = productVersionId;
    }

    public Set<Integer> getDependencyIds() {
        return this.dependencyIds;
    }

    public void setDependencyIds(Set<Integer> dependencyIds) {
        this.dependencyIds = dependencyIds;
    }

    public boolean addDependency(Integer dependencyId) {
        return this.dependencyIds.add(dependencyId);
    }

    public boolean removeDependency(Integer dependencyId) {
        return this.dependencyIds.remove(dependencyId);
    }

    public BuildEnvironmentRest getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(BuildEnvironmentRest environment) {
        this.environment = environment;
    }

    public BuildConfiguration.Builder toDBEntityBuilder() {
        BuildConfiguration.Builder builder = BuildConfiguration.Builder.newBuilder().id(this.getId()).name(this.getName()).description(this.getDescription()).buildScript(this.getBuildScript()).scmRevision(this.getScmRevision()).archived(this.isArchived()).genericParameters(this.getGenericParameters()).buildType(this.getBuildType());
        Utility.performIfNotNull(this.getRepositoryConfiguration(), () -> builder.repositoryConfiguration(this.getRepositoryConfiguration().toDBEntityBuilder().build()));
        Utility.performIfNotNull(this.getProject(), () -> builder.project(this.getProject().toDBEntityBuilder().build()));
        Utility.performIfNotNull(this.getEnvironment(), () -> builder.buildEnvironment(this.getEnvironment().toDBEntityBuilder().build()));
        Utility.performIfNotNull(this.getProductVersionId(), () -> builder.productVersion(ProductVersion.Builder.newBuilder().id(this.productVersionId).build()));
        StreamHelper.nullableStreamOf(this.getDependencyIds()).forEach(dependencyId -> {
            BuildConfiguration.Builder buildConfigurationBuilder = BuildConfiguration.Builder.newBuilder().id(dependencyId);
            builder.dependency(buildConfigurationBuilder.build());
        });
        return builder;
    }

    public void setRepositoryConfiguration(RepositoryConfigurationRest repositoryConfiguration) {
        this.repositoryConfiguration = repositoryConfiguration;
    }

    public RepositoryConfigurationRest getRepositoryConfiguration() {
        return this.repositoryConfiguration;
    }

    public BuildType getBuildType() {
        return this.buildType;
    }

    public void setBuildType(BuildType buildType) {
        this.buildType = buildType;
    }

    public Set<Integer> getBuildConfigurationSetIds() {
        return this.buildConfigurationSetIds;
    }

    public void setBuildConfigurationSetIds(Set<Integer> buildConfigurationSetIds) {
        this.buildConfigurationSetIds = buildConfigurationSetIds;
    }

    public Map<String, String> getGenericParameters() {
        return this.genericParameters;
    }

    public void setGenericParameters(Map<String, String> genericParameters) {
        this.genericParameters = genericParameters;
    }
}

