/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.ProductVersion;
import org.jboss.pnc.rest.restmodel.BuildConfigurationRest;
import org.jboss.pnc.rest.restmodel.GenericRestEntity;
import org.jboss.pnc.rest.utils.StreamHelper;
import org.jboss.pnc.rest.utils.Utility;
import org.jboss.pnc.rest.validation.groups.WhenCreatingNew;
import org.jboss.pnc.rest.validation.groups.WhenUpdating;

@XmlRootElement(name="BuildConfigurationSet")
public class BuildConfigurationSetRest
implements GenericRestEntity<Integer> {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    private Integer id;
    private String name;
    private Integer productVersionId;
    private List<Integer> buildConfigurationIds = new LinkedList<Integer>();

    public BuildConfigurationSetRest() {
    }

    public BuildConfigurationSetRest(BuildConfigurationSet buildConfigurationSet) {
        this.id = buildConfigurationSet.getId();
        this.name = buildConfigurationSet.getName();
        Utility.performIfNotNull(buildConfigurationSet.getProductVersion(), () -> {
            this.productVersionId = buildConfigurationSet.getProductVersion().getId();
        });
        buildConfigurationSet.getBuildConfigurations().forEach(bc -> this.buildConfigurationIds.add(bc.getId()));
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getProductVersionId() {
        return this.productVersionId;
    }

    public void setProductVersionId(Integer productVersionId) {
        this.productVersionId = productVersionId;
    }

    public List<Integer> getBuildConfigurationIds() {
        return this.buildConfigurationIds;
    }

    public void setBuildConfigurationIds(List<Integer> buildConfigurationIds) {
        this.buildConfigurationIds = buildConfigurationIds;
    }

    public void addBuildConfiguration(BuildConfigurationRest buildConfigurationRest) {
        this.buildConfigurationIds.add(buildConfigurationRest.getId());
    }

    public void addBuildConfigurations(Collection<BuildConfigurationRest> buildConfigurationRestCollection) {
        this.buildConfigurationIds.addAll(buildConfigurationRestCollection.stream().map(BuildConfigurationRest::getId).collect(Collectors.toList()));
    }

    public BuildConfigurationSet.Builder toDBEntityBuilder() {
        BuildConfigurationSet.Builder builder = BuildConfigurationSet.Builder.newBuilder().id(this.id).name(this.name);
        Utility.performIfNotNull(this.productVersionId, () -> builder.productVersion(ProductVersion.Builder.newBuilder().id(this.productVersionId).build()));
        StreamHelper.nullableStreamOf(this.buildConfigurationIds).forEach(buildConfigurationId -> {
            BuildConfiguration.Builder buildConfigurationBuilder = BuildConfiguration.Builder.newBuilder().id(buildConfigurationId);
            builder.buildConfiguration(buildConfigurationBuilder.build());
        });
        return builder;
    }

    public String toString() {
        return "BuildConfigurationSetRest(id=" + this.getId() + ", name=" + this.getName() + ", productVersionId=" + this.getProductVersionId() + ", buildConfigurationIds=" + this.getBuildConfigurationIds() + ")";
    }
}

