/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.common.json.JsonOutputConverterMapper;
import org.jboss.pnc.model.BuildType;
import org.jboss.pnc.model.SystemImageType;
import org.jboss.pnc.rest.restmodel.ArtifactRepositoryRest;
import org.jboss.pnc.rest.restmodel.BuildConfigurationAuditedRest;
import org.jboss.pnc.rest.restmodel.RepositoryConfigurationRest;
import org.jboss.pnc.rest.restmodel.UserRest;
import org.jboss.pnc.spi.executor.BuildExecutionConfiguration;
import org.jboss.pnc.spi.repositorymanager.ArtifactRepository;

@XmlRootElement(name="buildExecutionConfiguration")
public class BuildExecutionConfigurationRest
implements BuildExecutionConfiguration {
    private int id;
    private String buildContentId;
    private UserRest user;
    private String buildScript;
    private String name;
    private String scmRepoURL;
    private String scmRevision;
    private String scmTag;
    private String originRepoURL;
    private boolean preBuildSyncEnabled;
    private BuildType buildType;
    private String systemImageId;
    private String systemImageRepositoryUrl;
    private SystemImageType systemImageType;
    private boolean podKeptOnFailure = false;
    private List<ArtifactRepository> artifactRepositories;
    private Map<String, String> genericParameters;
    private boolean tempBuild;
    private String tempBuildTimestamp;

    public BuildExecutionConfigurationRest() {
    }

    public BuildExecutionConfigurationRest(String serialized) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        BuildExecutionConfigurationRest buildExecutionConfigurationRestFromJson = (BuildExecutionConfigurationRest)mapper.readValue(serialized, BuildExecutionConfigurationRest.class);
        BuildExecutionConfiguration buildExecutionConfiguration = buildExecutionConfigurationRestFromJson.toBuildExecutionConfiguration();
        this.init(buildExecutionConfiguration);
    }

    public BuildExecutionConfigurationRest(BuildExecutionConfiguration buildExecutionConfiguration) {
        this.init(buildExecutionConfiguration);
    }

    private void init(BuildExecutionConfiguration buildExecutionConfiguration) {
        this.id = buildExecutionConfiguration.getId();
        this.buildContentId = buildExecutionConfiguration.getBuildContentId();
        this.buildScript = buildExecutionConfiguration.getBuildScript();
        this.name = buildExecutionConfiguration.getName();
        this.scmRepoURL = buildExecutionConfiguration.getScmRepoURL();
        this.scmRevision = buildExecutionConfiguration.getScmRevision();
        this.scmTag = buildExecutionConfiguration.getScmTag();
        this.originRepoURL = buildExecutionConfiguration.getOriginRepoURL();
        this.preBuildSyncEnabled = buildExecutionConfiguration.isPreBuildSyncEnabled();
        this.buildType = buildExecutionConfiguration.getBuildType();
        this.systemImageId = buildExecutionConfiguration.getSystemImageId();
        this.systemImageRepositoryUrl = buildExecutionConfiguration.getSystemImageRepositoryUrl();
        this.systemImageType = buildExecutionConfiguration.getSystemImageType();
        this.user = new UserRest(buildExecutionConfiguration.getUserId());
        this.podKeptOnFailure = buildExecutionConfiguration.isPodKeptOnFailure();
        this.genericParameters = buildExecutionConfiguration.getGenericParameters();
        this.tempBuild = buildExecutionConfiguration.isTempBuild();
        this.tempBuildTimestamp = buildExecutionConfiguration.getTempBuildTimestamp();
        if (buildExecutionConfiguration.getArtifactRepositories() != null) {
            this.artifactRepositories = new ArrayList<ArtifactRepository>(buildExecutionConfiguration.getArtifactRepositories().size());
            for (ArtifactRepository artifactRepository : buildExecutionConfiguration.getArtifactRepositories()) {
                this.artifactRepositories.add(new ArtifactRepositoryRest(artifactRepository));
            }
        }
    }

    public BuildExecutionConfiguration toBuildExecutionConfiguration() {
        return BuildExecutionConfiguration.build((int)this.id, (String)this.buildContentId, (Integer)this.user.getId(), (String)this.buildScript, (String)this.name, (String)this.scmRepoURL, (String)this.scmRevision, (String)this.scmTag, (String)this.originRepoURL, (boolean)this.preBuildSyncEnabled, (String)this.systemImageId, (String)this.systemImageRepositoryUrl, (SystemImageType)this.systemImageType, (BuildType)this.buildType, (boolean)this.podKeptOnFailure, this.artifactRepositories, this.genericParameters, (boolean)this.tempBuild, (String)this.tempBuildTimestamp);
    }

    public BuildConfigurationAuditedRest createBuildConfigurationAuditedRest() {
        BuildConfigurationAuditedRest buildConfigAuditedRest = new BuildConfigurationAuditedRest();
        buildConfigAuditedRest.setId(this.id);
        buildConfigAuditedRest.setRev(null);
        buildConfigAuditedRest.setName(this.name);
        buildConfigAuditedRest.setBuildScript(this.buildScript);
        RepositoryConfigurationRest repoConfigRest = new RepositoryConfigurationRest();
        repoConfigRest.setInternalUrl(this.scmRepoURL);
        buildConfigAuditedRest.setRepositoryConfiguration(repoConfigRest);
        buildConfigAuditedRest.setScmRevision(this.scmRevision);
        return buildConfigAuditedRest;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setBuildContentId(String buildContentId) {
        this.buildContentId = buildContentId;
    }

    public void setBuildScript(String buildScript) {
        this.buildScript = buildScript;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setScmRepoURL(String scmRepoURL) {
        this.scmRepoURL = scmRepoURL;
    }

    public void setScmRevision(String scmRevision) {
        this.scmRevision = scmRevision;
    }

    public void setOriginRepoURL(String originRepoURL) {
        this.originRepoURL = originRepoURL;
    }

    public void setPreBuildSyncEnabled(boolean preBuildSyncEnabled) {
        this.preBuildSyncEnabled = preBuildSyncEnabled;
    }

    public int getId() {
        return this.id;
    }

    @JsonIgnore
    public Integer getUserId() {
        return this.user.getId();
    }

    public String getBuildContentId() {
        return this.buildContentId;
    }

    public String getBuildScript() {
        return this.buildScript;
    }

    public String getName() {
        return this.name;
    }

    public String getScmRepoURL() {
        return this.scmRepoURL;
    }

    public String getScmRevision() {
        return this.scmRevision;
    }

    public String getScmTag() {
        return this.scmTag;
    }

    public String getOriginRepoURL() {
        return this.originRepoURL;
    }

    public boolean isPreBuildSyncEnabled() {
        return this.preBuildSyncEnabled;
    }

    public BuildType getBuildType() {
        return this.buildType;
    }

    public UserRest getUser() {
        return this.user;
    }

    public void setUser(UserRest user) {
        this.user = user;
    }

    public void setBuildType(BuildType buildType) {
        this.buildType = buildType;
    }

    public String getSystemImageId() {
        return this.systemImageId;
    }

    public void setSystemImageId(String systemImageId) {
        this.systemImageId = systemImageId;
    }

    public String getSystemImageRepositoryUrl() {
        return this.systemImageRepositoryUrl;
    }

    public void setSystemImageRepositoryUrl(String systemImageRepositoryUrl) {
        this.systemImageRepositoryUrl = systemImageRepositoryUrl;
    }

    public SystemImageType getSystemImageType() {
        return this.systemImageType;
    }

    public boolean isPodKeptOnFailure() {
        return this.podKeptOnFailure;
    }

    public void setPodKeptOnFailure(boolean podKeptOnFailure) {
        this.podKeptOnFailure = podKeptOnFailure;
    }

    public void setSystemImageType(SystemImageType systemImageType) {
        this.systemImageType = systemImageType;
    }

    public List<ArtifactRepository> getArtifactRepositories() {
        return this.artifactRepositories;
    }

    public void setArtifactRepositories(List<ArtifactRepositoryRest> artifactRepositoriesRest) {
        this.artifactRepositories = new ArrayList<ArtifactRepositoryRest>(artifactRepositoriesRest);
    }

    public void setGenericParameters(Map<String, String> genericParameters) {
        this.genericParameters = genericParameters;
    }

    public Map<String, String> getGenericParameters() {
        return this.genericParameters;
    }

    public boolean isTempBuild() {
        return this.tempBuild;
    }

    public String toString() {
        return JsonOutputConverterMapper.apply((Object)this);
    }

    public String getTempBuildTimestamp() {
        return this.tempBuildTimestamp;
    }

    public void setTempBuildTimestamp(String tempBuildTimestamp) {
        this.tempBuildTimestamp = tempBuildTimestamp;
    }
}

