/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Pattern;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.Product;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.ProductVersion;
import org.jboss.pnc.rest.restmodel.BuildConfigurationRest;
import org.jboss.pnc.rest.restmodel.BuildConfigurationSetRest;
import org.jboss.pnc.rest.restmodel.GenericRestEntity;
import org.jboss.pnc.rest.restmodel.ProductMilestoneRest;
import org.jboss.pnc.rest.restmodel.ProductReleaseRest;
import org.jboss.pnc.rest.utils.StreamHelper;
import org.jboss.pnc.rest.utils.Utility;
import org.jboss.pnc.rest.validation.groups.WhenCreatingNew;
import org.jboss.pnc.rest.validation.groups.WhenUpdating;

@XmlRootElement(name="ProductVersion")
public class ProductVersionRest
implements GenericRestEntity<Integer> {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    private Integer id;
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    @Pattern(message="Version doesn't match the required pattern ^[0-9]+\\.[0-9]+$", regexp="^[0-9]+\\.[0-9]+$", groups={WhenCreatingNew.class, WhenUpdating.class})
    private @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class}) @Pattern(message="Version doesn't match the required pattern ^[0-9]+\\.[0-9]+$", regexp="^[0-9]+\\.[0-9]+$", groups={WhenCreatingNew.class, WhenUpdating.class}) String version;
    @NotNull(groups={WhenCreatingNew.class, WhenUpdating.class})
    private Integer productId;
    private String productName;
    private Integer currentProductMilestoneId;
    List<ProductMilestoneRest> productMilestones = new ArrayList<ProductMilestoneRest>();
    List<ProductReleaseRest> productReleases = new ArrayList<ProductReleaseRest>();
    List<BuildConfigurationSetRest> buildConfigurationSets = new ArrayList<BuildConfigurationSetRest>();
    List<BuildConfigurationRest> buildConfigurations = new ArrayList<BuildConfigurationRest>();
    private Map<String, String> attributes = new HashMap<String, String>();

    public ProductVersionRest() {
    }

    public ProductVersionRest(ProductVersion productVersion) {
        this.id = productVersion.getId();
        this.version = productVersion.getVersion();
        this.productId = productVersion.getProduct().getId();
        this.productName = productVersion.getProduct().getName();
        this.currentProductMilestoneId = productVersion.getCurrentProductMilestone() != null ? productVersion.getCurrentProductMilestone().getId() : null;
        for (ProductMilestone milestone : productVersion.getProductMilestones()) {
            this.productMilestones.add(new ProductMilestoneRest(milestone));
            if (milestone.getProductRelease() == null) continue;
            this.productReleases.add(new ProductReleaseRest(milestone.getProductRelease()));
        }
        for (BuildConfiguration buildConfiguration : productVersion.getBuildConfigurations()) {
            this.buildConfigurations.add(new BuildConfigurationRest(buildConfiguration));
        }
        for (BuildConfigurationSet buildConfigurationSet : productVersion.getBuildConfigurationSets()) {
            this.buildConfigurationSets.add(new BuildConfigurationSetRest(buildConfigurationSet));
        }
        this.attributes = productVersion.getAttributes();
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Integer getProductId() {
        return this.productId;
    }

    public void setProductId(Integer productId) {
        this.productId = productId;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public List<ProductMilestoneRest> getProductMilestones() {
        return this.productMilestones;
    }

    public void setProductMilestones(List<ProductMilestoneRest> productMilestones) {
        this.productMilestones = productMilestones;
    }

    public List<ProductReleaseRest> getProductReleases() {
        return this.productReleases;
    }

    public void setProductReleases(List<ProductReleaseRest> productReleases) {
        this.productReleases = productReleases;
    }

    public List<BuildConfigurationSetRest> getBuildConfigurationSets() {
        return this.buildConfigurationSets;
    }

    public void setBuildConfigurationSets(List<BuildConfigurationSetRest> buildConfigurationSets) {
        this.buildConfigurationSets = buildConfigurationSets;
    }

    public List<BuildConfigurationRest> getBuildConfigurations() {
        return this.buildConfigurations;
    }

    public void setBuildConfigurations(List<BuildConfigurationRest> buildConfigurations) {
        this.buildConfigurations = buildConfigurations;
    }

    public Integer getCurrentProductMilestoneId() {
        return this.currentProductMilestoneId;
    }

    public void setCurrentProductMilestoneId(Integer currentProductMilestoneId) {
        this.currentProductMilestoneId = currentProductMilestoneId;
    }

    public ProductVersion.Builder toDBEntityBuilder() {
        ProductVersion.Builder builder = ProductVersion.Builder.newBuilder().id(this.id).version(this.version).attributes(this.attributes);
        Utility.performIfNotNull(this.productId, () -> builder.product(Product.Builder.newBuilder().id(this.productId).build()));
        Utility.performIfNotNull(this.currentProductMilestoneId, () -> builder.currentProductMilestone(ProductMilestone.Builder.newBuilder().id(this.currentProductMilestoneId).build()));
        StreamHelper.nullableStreamOf(this.getProductMilestones()).forEach(milestone -> builder.productMilestone(ProductMilestone.Builder.newBuilder().id(milestone.getId()).build()));
        StreamHelper.nullableStreamOf(this.getBuildConfigurationSets()).forEach(set -> builder.buildConfigurationSet(BuildConfigurationSet.Builder.newBuilder().id(set.getId()).build()));
        return builder;
    }

    public String toString() {
        return "ProductVersionRest(id=" + this.getId() + ", version=" + this.getVersion() + ", productId=" + this.getProductId() + ", productName=" + this.getProductName() + ", currentProductMilestoneId=" + this.getCurrentProductMilestoneId() + ", productMilestones=" + this.getProductMilestones() + ", productReleases=" + this.getProductReleases() + ", buildConfigurationSets=" + this.getBuildConfigurationSets() + ", buildConfigurations=" + this.getBuildConfigurations() + ", attributes=" + this.getAttributes() + ")";
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }
}

