/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.TargetRepository;
import org.jboss.pnc.rest.validation.groups.WhenCreatingNew;
import org.jboss.pnc.rest.validation.groups.WhenUpdating;

@JsonDeserialize(builder=TargetRepositoryRestBuilder.class)
@XmlRootElement(name="TargetRepository")
public class TargetRepositoryRest
implements GenericEntity<Integer> {
    @NotNull(groups={WhenUpdating.class})
    @Null(groups={WhenCreatingNew.class})
    private Integer id;
    @NotNull(groups={WhenUpdating.class, WhenCreatingNew.class})
    private Boolean temporaryRepo;
    @NotNull(groups={WhenUpdating.class, WhenCreatingNew.class})
    private String identifier;
    @NotNull(groups={WhenUpdating.class, WhenCreatingNew.class})
    @ApiModelProperty(dataType="string")
    private TargetRepository.Type repositoryType;
    @NotNull(groups={WhenUpdating.class, WhenCreatingNew.class})
    private String repositoryPath;
    @NotNull(groups={WhenUpdating.class, WhenCreatingNew.class})
    private Set<Integer> artifactIds = new HashSet<Integer>();

    public TargetRepositoryRest(TargetRepository targetRepository) {
        this.id = targetRepository.getId();
        this.identifier = targetRepository.getIdentifier();
        this.repositoryType = targetRepository.getRepositoryType();
        this.repositoryPath = targetRepository.getRepositoryPath();
        this.temporaryRepo = targetRepository.getTemporaryRepo();
    }

    public TargetRepository.Builder toDBEntityBuilder() {
        return TargetRepository.newBuilder().id(this.id).temporaryRepo(this.temporaryRepo).identifier(this.identifier).repositoryType(this.repositoryType).repositoryPath(this.repositoryPath).artifacts(this.artifactIds.stream().map(id -> {
            Artifact artifact = Artifact.Builder.newBuilder().id(id).build();
            return artifact;
        }).collect(Collectors.toSet()));
    }

    public static TargetRepositoryRestBuilder builder() {
        return new TargetRepositoryRestBuilder();
    }

    public TargetRepositoryRest(Integer id, Boolean temporaryRepo, String identifier, TargetRepository.Type repositoryType, String repositoryPath, Set<Integer> artifactIds) {
        this.id = id;
        this.temporaryRepo = temporaryRepo;
        this.identifier = identifier;
        this.repositoryType = repositoryType;
        this.repositoryPath = repositoryPath;
        this.artifactIds = artifactIds;
    }

    public String toString() {
        return "TargetRepositoryRest(id=" + this.getId() + ", temporaryRepo=" + this.getTemporaryRepo() + ", identifier=" + this.getIdentifier() + ", repositoryType=" + this.getRepositoryType() + ", repositoryPath=" + this.getRepositoryPath() + ", artifactIds=" + this.getArtifactIds() + ")";
    }

    public Integer getId() {
        return this.id;
    }

    @Deprecated
    public void setId(Integer id) {
        this.id = id;
    }

    public Boolean getTemporaryRepo() {
        return this.temporaryRepo;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public TargetRepository.Type getRepositoryType() {
        return this.repositoryType;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public Set<Integer> getArtifactIds() {
        return this.artifactIds;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class TargetRepositoryRestBuilder {
        private Integer id;
        private Boolean temporaryRepo;
        private String identifier;
        private TargetRepository.Type repositoryType;
        private String repositoryPath;
        private Set<Integer> artifactIds;

        TargetRepositoryRestBuilder() {
        }

        public TargetRepositoryRestBuilder id(Integer id) {
            this.id = id;
            return this;
        }

        public TargetRepositoryRestBuilder temporaryRepo(Boolean temporaryRepo) {
            this.temporaryRepo = temporaryRepo;
            return this;
        }

        public TargetRepositoryRestBuilder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public TargetRepositoryRestBuilder repositoryType(TargetRepository.Type repositoryType) {
            this.repositoryType = repositoryType;
            return this;
        }

        public TargetRepositoryRestBuilder repositoryPath(String repositoryPath) {
            this.repositoryPath = repositoryPath;
            return this;
        }

        public TargetRepositoryRestBuilder artifactIds(Set<Integer> artifactIds) {
            this.artifactIds = artifactIds;
            return this;
        }

        public TargetRepositoryRest build() {
            return new TargetRepositoryRest(this.id, this.temporaryRepo, this.identifier, this.repositoryType, this.repositoryPath, this.artifactIds);
        }

        public String toString() {
            return "TargetRepositoryRest.TargetRepositoryRestBuilder(id=" + this.id + ", temporaryRepo=" + this.temporaryRepo + ", identifier=" + this.identifier + ", repositoryType=" + this.repositoryType + ", repositoryPath=" + this.repositoryPath + ", artifactIds=" + this.artifactIds + ")";
        }
    }
}

