/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel.causeway;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ArtifactImportError {
    private Integer artifactId;
    private String errorMessage;

    public static String combineMessages(List<ArtifactImportError> artifactImportErrors) {
        if (artifactImportErrors == null || artifactImportErrors.isEmpty()) {
            return "";
        }
        return " --- artifact errors ---\n" + artifactImportErrors.stream().map(e -> e.getArtifactId() + ": " + e.getErrorMessage()).collect(Collectors.joining("\n"));
    }

    public static String combineMessages(String prefix, List<ArtifactImportError> artifactImportErrors) {
        String errors = ArtifactImportError.combineMessages(artifactImportErrors);
        if (!errors.isEmpty()) {
            return prefix + "\n\n" + errors;
        }
        return prefix;
    }

    public Integer getArtifactId() {
        return this.artifactId;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setArtifactId(Integer artifactId) {
        this.artifactId = artifactId;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArtifactImportError)) {
            return false;
        }
        ArtifactImportError other = (ArtifactImportError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$artifactId = this.getArtifactId();
        Integer other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !((Object)this$artifactId).equals(other$artifactId)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArtifactImportError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : ((Object)$artifactId).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    public String toString() {
        return "ArtifactImportError(artifactId=" + this.getArtifactId() + ", errorMessage=" + this.getErrorMessage() + ")";
    }
}

