/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.rest.restmodel.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Collection;
import java.util.Collections;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.pnc.rest.provider.collection.CollectionInfo;

@XmlRootElement
@ApiModel(description="Results with additional Paging information")
public class Page<T> {
    @ApiModelProperty(value="Page index")
    private Integer pageIndex;
    @ApiModelProperty(value="Number of records per page")
    private Integer pageSize;
    @ApiModelProperty(value="Total pages provided by this query or -1 if unknown")
    private Integer totalPages;
    @ApiModelProperty(value="Embedded collection of data")
    private Collection<T> content;

    public Page() {
    }

    public Page(CollectionInfo<T> collectionInfo) {
        this.pageIndex = collectionInfo.getPageIndex();
        this.pageSize = collectionInfo.getPageSize();
        this.totalPages = collectionInfo.getTotalPages();
        this.content = Collections.unmodifiableCollection(collectionInfo.getContent());
    }

    public Integer getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(Integer totalPages) {
        this.totalPages = totalPages;
    }

    public Collection<T> getContent() {
        return this.content;
    }

    public void setContent(Collection<T> content) {
        this.content = content;
    }

    public String toString() {
        return "Page{pageIndex=" + this.pageIndex + ", pageSize=" + this.pageSize + ", totalPages=" + this.totalPages + ", content=" + this.content + '}';
    }
}

