/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.termdbuilddriver;

import java.net.URI;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.common.Configuration;
import org.jboss.pnc.common.json.ConfigurationParseException;
import org.jboss.pnc.common.json.moduleconfig.SystemConfig;
import org.jboss.pnc.common.json.moduleprovider.ConfigProvider;
import org.jboss.pnc.common.json.moduleprovider.PncConfigProvider;
import org.jboss.pnc.spi.builddriver.BuildDriver;
import org.jboss.pnc.spi.builddriver.CompletedBuild;
import org.jboss.pnc.spi.builddriver.RunningBuild;
import org.jboss.pnc.spi.builddriver.exception.BuildDriverException;
import org.jboss.pnc.spi.environment.RunningEnvironment;
import org.jboss.pnc.spi.executor.BuildExecutionSession;
import org.jboss.pnc.termdbuilddriver.TermdRunningBuild;
import org.jboss.pnc.termdbuilddriver.commands.TermdCommandBatchExecutionResult;
import org.jboss.pnc.termdbuilddriver.commands.TermdCommandInvoker;
import org.jboss.pnc.termdbuilddriver.transfer.TermdFileTranser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class TermdBuildDriver
implements BuildDriver {
    public static final String DRIVER_ID = "termd-build-driver";
    private static final Logger logger = LoggerFactory.getLogger(TermdBuildDriver.class);
    private boolean useInternalNetwork = true;
    private ExecutorService executor;

    @Deprecated
    public TermdBuildDriver() {
    }

    @Inject
    public TermdBuildDriver(Configuration configuration) {
        int executorThreadPoolSize = 12;
        try {
            String executorThreadPoolSizeStr = ((SystemConfig)configuration.getModuleConfig((ConfigProvider)new PncConfigProvider(SystemConfig.class))).getBuilderThreadPoolSize();
            if (executorThreadPoolSizeStr != null) {
                executorThreadPoolSize = Integer.parseInt(executorThreadPoolSizeStr);
            }
        }
        catch (ConfigurationParseException e) {
            logger.warn("Unable parse config. Using defaults.");
        }
        this.executor = Executors.newFixedThreadPool(executorThreadPoolSize);
    }

    public String getDriverId() {
        return DRIVER_ID;
    }

    public RunningBuild startProjectBuild(BuildExecutionSession buildExecutionSession, RunningEnvironment runningEnvironment) throws BuildDriverException {
        logger.info("[{}] Starting build for Build Execution Session {}", (Object)runningEnvironment.getId(), (Object)buildExecutionSession.getId());
        TermdRunningBuild termdRunningBuild = new TermdRunningBuild(runningEnvironment, buildExecutionSession.getBuildExecutionConfiguration());
        ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.addScriptDebugOption(termdRunningBuild).thenComposeAsync(returnedBuildScript -> this.changeToWorkingDirectory(termdRunningBuild, returnedBuildScript), (Executor)this.executor)).thenComposeAsync(returnedBuildScript -> this.checkoutSources(termdRunningBuild, returnedBuildScript), (Executor)this.executor)).thenComposeAsync(returnedBuildScript -> this.build(termdRunningBuild, returnedBuildScript), (Executor)this.executor)).thenComposeAsync(returnedBuildScript -> this.uploadScript(termdRunningBuild, returnedBuildScript), (Executor)this.executor)).thenComposeAsync(scriptPath -> this.invokeRemoteScript(termdRunningBuild, scriptPath, buildExecutionSession), (Executor)this.executor)).handle((results, exception) -> this.updateStatus(termdRunningBuild, results, exception));
        return termdRunningBuild;
    }

    protected CompletableFuture<StringBuilder> addScriptDebugOption(TermdRunningBuild termdRunningBuild) {
        return CompletableFuture.supplyAsync(() -> {
            logger.debug("[{}] Adding debug option", (Object)termdRunningBuild.getRunningEnvironment().getId());
            StringBuilder commandAppender = new StringBuilder();
            String debugOption = "set -x";
            commandAppender.append(debugOption).append("\n");
            return commandAppender;
        });
    }

    protected CompletableFuture<StringBuilder> changeToWorkingDirectory(TermdRunningBuild termdRunningBuild, StringBuilder commandAppender) {
        return CompletableFuture.supplyAsync(() -> {
            logger.debug("[{}] Changing current directory", (Object)termdRunningBuild.getRunningEnvironment().getId());
            String cdCommand = "cd " + termdRunningBuild.getRunningEnvironment().getWorkingDirectory().toAbsolutePath().toString();
            commandAppender.append(cdCommand).append("\n");
            return commandAppender;
        });
    }

    protected CompletableFuture<StringBuilder> checkoutSources(TermdRunningBuild termdRunningBuild, StringBuilder commandAppender) {
        return CompletableFuture.supplyAsync(() -> {
            logger.debug("[{}] Checking out sources", (Object)termdRunningBuild.getRunningEnvironment().getId());
            String cloneCommand = "git clone " + termdRunningBuild.getScmRepoURL() + " " + termdRunningBuild.getName();
            commandAppender.append(cloneCommand).append("\n");
            String cdCommand = "cd " + termdRunningBuild.getName();
            commandAppender.append(cdCommand).append("\n");
            String resetCommand = "git reset --hard " + termdRunningBuild.getScmRevision();
            commandAppender.append(resetCommand).append("\n");
            return commandAppender;
        });
    }

    protected CompletableFuture<StringBuilder> build(TermdRunningBuild termdRunningBuild, StringBuilder commandAppender) {
        return CompletableFuture.supplyAsync(() -> {
            logger.debug("[{}] Building", (Object)termdRunningBuild.getRunningEnvironment().getId());
            String buildCommand = termdRunningBuild.getBuildScript();
            commandAppender.append(buildCommand).append("\n");
            return commandAppender;
        });
    }

    protected CompletableFuture<String> uploadScript(TermdRunningBuild termdRunningBuild, StringBuilder commandAppender) {
        return CompletableFuture.supplyAsync(() -> {
            logger.debug("[{}] Uploading script", (Object)termdRunningBuild.getRunningEnvironment().getId());
            logger.debug("[{}] Full script:\n {}", (Object)termdRunningBuild.getRunningEnvironment().getId(), (Object)commandAppender.toString());
            new TermdFileTranser(URI.create(this.getBuildAgentUrl(termdRunningBuild))).uploadScript(commandAppender, Paths.get(termdRunningBuild.getRunningEnvironment().getWorkingDirectory().toAbsolutePath().toString(), "run.sh"));
            return termdRunningBuild.getRunningEnvironment().getWorkingDirectory().toAbsolutePath().toString() + "/run.sh";
        });
    }

    protected CompletableFuture<TermdCommandBatchExecutionResult> invokeRemoteScript(TermdRunningBuild termdRunningBuild, String scriptPath, BuildExecutionSession currentBuildExecution) {
        return CompletableFuture.supplyAsync(() -> {
            logger.debug("[{}] Invoking script from path {}", (Object)termdRunningBuild.getRunningEnvironment().getId(), (Object)scriptPath);
            TermdCommandInvoker termdCommandInvoker = new TermdCommandInvoker(URI.create(this.getBuildAgentUrl(termdRunningBuild)), termdRunningBuild.getRunningEnvironment().getWorkingDirectory());
            termdCommandInvoker.startSession();
            termdCommandInvoker.performCommand("sh " + scriptPath).join();
            currentBuildExecution.setLiveLogsUri(Optional.empty());
            return termdCommandInvoker.closeSession();
        });
    }

    private String getBuildAgentUrl(TermdRunningBuild termdRunningBuild) {
        if (this.useInternalNetwork) {
            return termdRunningBuild.getRunningEnvironment().getInternalBuildAgentUrl();
        }
        return termdRunningBuild.getRunningEnvironment().getBuildAgentUrl();
    }

    protected TermdRunningBuild updateStatus(TermdRunningBuild termdRunningBuild, TermdCommandBatchExecutionResult commandBatchResult, Throwable throwable) {
        logger.debug("[{}] Command result {}", (Object)termdRunningBuild.getRunningEnvironment().getId(), (Object)commandBatchResult);
        if (throwable != null) {
            logger.warn("[{}] Exception {}", (Object)termdRunningBuild.getRunningEnvironment().getId(), (Object)throwable);
            termdRunningBuild.setBuildPromiseError((Exception)throwable);
        } else {
            logger.debug("[{}] No Exceptions.", (Object)termdRunningBuild.getRunningEnvironment().getId());
            AtomicReference<String> aggregatedLogs = new AtomicReference<String>();
            try {
                aggregatedLogs.set(((StringBuffer)this.aggregateLogs(termdRunningBuild, commandBatchResult).get()).toString());
            }
            catch (Exception e) {
                termdRunningBuild.setBuildPromiseError(e);
                return termdRunningBuild;
            }
            termdRunningBuild.setCompletedBuild((CompletedBuild)new /* Unavailable Anonymous Inner Class!! */);
        }
        return termdRunningBuild;
    }

    protected CompletableFuture<StringBuffer> aggregateLogs(TermdRunningBuild termdRunningBuild, TermdCommandBatchExecutionResult allInvokedCommands) {
        logger.debug("[{}] Aggregating logs", (Object)termdRunningBuild.getRunningEnvironment().getId());
        TermdFileTranser transer = new TermdFileTranser();
        return CompletableFuture.supplyAsync(() -> allInvokedCommands.getCommandResults().stream().map(invocationResult -> invocationResult.getLogsUri()).reduce(new StringBuffer(), (stringBuffer, uri) -> transer.downloadFileToStringBuilder(stringBuffer, uri), (builder1, builder2) -> builder1.append((StringBuffer)builder2)));
    }
}

