/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.termdbuilddriver;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.jboss.pnc.spi.builddriver.CompletedBuild;
import org.jboss.pnc.spi.builddriver.RunningBuild;
import org.jboss.pnc.spi.environment.RunningEnvironment;
import org.jboss.pnc.spi.executor.BuildExecutionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermdRunningBuild
implements RunningBuild {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long MAX_TIMEOUT = 2L;
    private static final TimeUnit MAX_TIMEOUT_UNIT = TimeUnit.HOURS;
    private final RunningEnvironment runningEnvironment;
    private final BuildExecutionConfiguration buildExecutionConfiguration;
    private CompletableFuture<CompletedBuild> buildPromise = new CompletableFuture();

    public TermdRunningBuild(RunningEnvironment runningEnvironment, BuildExecutionConfiguration buildExecutionConfiguration) {
        this.runningEnvironment = runningEnvironment;
        this.buildExecutionConfiguration = buildExecutionConfiguration;
    }

    public void monitor(Consumer<CompletedBuild> onComplete, Consumer<Throwable> onError) {
        try {
            logger.debug("[{}] The client started monitoring the build", (Object)this.runningEnvironment.getId());
            onComplete.accept((CompletedBuild)this.buildPromise.get(2L, MAX_TIMEOUT_UNIT));
        }
        catch (InterruptedException | TimeoutException e) {
            onError.accept(e);
        }
        catch (ExecutionException e) {
            onError.accept(e.getCause());
        }
    }

    public void setCompletedBuild(CompletedBuild completedBuild) {
        logger.debug("[{}] Setting completed build {}", (Object)this.runningEnvironment.getId(), (Object)completedBuild);
        this.buildPromise.complete(completedBuild);
    }

    public void setBuildPromiseError(Exception error) {
        this.buildPromise.completeExceptionally(error);
    }

    public RunningEnvironment getRunningEnvironment() {
        return this.runningEnvironment;
    }

    public String getBuildScript() {
        return this.buildExecutionConfiguration.getBuildScript();
    }

    public String getName() {
        return this.buildExecutionConfiguration.getName();
    }

    public String getScmRepoURL() {
        if (this.buildExecutionConfiguration.getScmMirrorRepoURL() != null) {
            return this.buildExecutionConfiguration.getScmMirrorRepoURL();
        }
        return this.buildExecutionConfiguration.getScmRepoURL();
    }

    public String getScmRevision() {
        if (this.buildExecutionConfiguration.getScmMirrorRevision() != null) {
            return this.buildExecutionConfiguration.getScmMirrorRevision();
        }
        return this.buildExecutionConfiguration.getScmRevision();
    }
}

