/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.termdbuilddriver.commands;

import java.net.URI;
import org.jboss.pnc.termdbuilddriver.statusupdates.event.Status;
import org.jboss.pnc.termdbuilddriver.statusupdates.event.UpdateEvent;

public class InvocatedCommandResult {
    private final boolean succeed;
    private final int taskId;
    private final URI baseServerUri;
    private String logsDirectory;

    public InvocatedCommandResult(UpdateEvent event, URI baseServerUri, String logsDirectory) {
        this.baseServerUri = baseServerUri;
        this.succeed = event.getEvent().getNewStatus() == Status.COMPLETED;
        this.taskId = event.getEvent().getTaskId();
        this.logsDirectory = logsDirectory;
    }

    public boolean isSucceed() {
        return this.succeed;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public URI getLogsUri() {
        return this.baseServerUri.resolve("servlet/download" + this.logsDirectory + "/console.log");
    }

    public String toString() {
        return "InvocatedCommandResult{succeed=" + this.succeed + ", taskId=" + this.taskId + ", baseServerUri=" + this.baseServerUri + ", logsDirectory='" + this.logsDirectory + '\'' + '}';
    }
}

