/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.termdbuilddriver.commands;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import org.jboss.pnc.termdbuilddriver.commands.InvocatedCommandResult;
import org.jboss.pnc.termdbuilddriver.commands.TermdCommandBatchExecutionResult;
import org.jboss.pnc.termdbuilddriver.commands.TermdCommandExecutionException;
import org.jboss.pnc.termdbuilddriver.statusupdates.TermdStatusUpdatesConnection;
import org.jboss.pnc.termdbuilddriver.statusupdates.event.Status;
import org.jboss.pnc.termdbuilddriver.statusupdates.event.UpdateEvent;
import org.jboss.pnc.termdbuilddriver.websockets.TermdTerminalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermdCommandInvoker {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private TermdTerminalConnection termdTerminalConnection;
    private TermdStatusUpdatesConnection termdStatusUpdatesConnection;
    private URI baseServerUri;
    private Path workingDirectory;
    private BlockingQueue<UpdateEvent> eventQueue = new LinkedBlockingQueue();
    private Queue<InvocatedCommandResult> invokedCommands = new LinkedList();

    public TermdCommandInvoker(URI serverBaseUri, Path workingDirectory) {
        this.baseServerUri = serverBaseUri;
        this.termdTerminalConnection = new TermdTerminalConnection(serverBaseUri);
        this.termdStatusUpdatesConnection = new TermdStatusUpdatesConnection(serverBaseUri);
        this.workingDirectory = workingDirectory;
    }

    public CompletableFuture<InvocatedCommandResult> performCommand(String command) {
        return CompletableFuture.supplyAsync(() -> {
            logger.debug("Performing command {}", (Object)command);
            try {
                String data = "{\"action\":\"read\",\"data\":\"" + command + "\\n\"}";
                this.termdTerminalConnection.sendAsBinary(ByteBuffer.wrap(data.getBytes()));
                String logsDirectory = this.getLogsDirectory();
                logger.debug("Taking event from queue...");
                UpdateEvent updateEvent = (UpdateEvent)this.eventQueue.take();
                InvocatedCommandResult invocatedCommandResult = new InvocatedCommandResult(updateEvent, this.baseServerUri, logsDirectory);
                logger.debug("Received command result {}", (Object)invocatedCommandResult);
                this.invokedCommands.add(invocatedCommandResult);
                return invocatedCommandResult;
            }
            catch (Exception e) {
                throw new TermdCommandExecutionException("There was a problem when invoking command " + command, e);
            }
        });
    }

    protected String getLogsDirectory() {
        return this.workingDirectory.toAbsolutePath().toString();
    }

    public void startSession() {
        logger.debug("Starting command session");
        this.termdStatusUpdatesConnection.connect();
        this.termdTerminalConnection.connect();
        this.termdStatusUpdatesConnection.addUpdateConsumer(event -> {
            logger.debug("Received event {}.", event);
            if (event.getEvent().getOldStatus() == Status.RUNNING) {
                try {
                    logger.debug("Adding event to queue {}.", event);
                    this.eventQueue.put(event);
                }
                catch (InterruptedException e) {
                    throw new TermdCommandExecutionException("Interrupted while waiting for queue space", (Exception)e);
                }
            }
        });
    }

    public TermdCommandBatchExecutionResult closeSession() {
        logger.debug("Closing command session");
        this.termdTerminalConnection.disconnect();
        this.termdStatusUpdatesConnection.disconnect();
        TermdCommandBatchExecutionResult returnedResults = new TermdCommandBatchExecutionResult((Collection)this.invokedCommands);
        this.invokedCommands.clear();
        return returnedResults;
    }

    public URI getLogsURI() {
        return this.termdTerminalConnection.getLogsURI();
    }
}

