/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.termdbuilddriver.websockets;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Optional;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.Endpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import javax.ws.rs.core.UriBuilder;
import org.jboss.pnc.termdbuilddriver.websockets.AbstractWebSocketsConnection;
import org.jboss.pnc.termdbuilddriver.websockets.ClientEndpoint;
import org.jboss.pnc.termdbuilddriver.websockets.TermdConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebSocketsConnection
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final URI uri;
    protected volatile Optional<Session> session = Optional.empty();

    public AbstractWebSocketsConnection(URI uri) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)uri);
        uriBuilder.scheme("ws");
        this.uri = uriBuilder.build(new Object[0]);
    }

    public void connect() {
        try {
            logger.debug("Connecting to Web Sockets URI {}", (Object)this.uri);
            WebSocketContainer webSocketContainer = new WSContainerProvider(this, null).getContainer();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().build();
            logger.debug("Connecting to WebSocket server using [{}] provider.", webSocketContainer.getClass());
            Session session = webSocketContainer.connectToServer((Endpoint)this.getClientEndpoint(), config, this.uri);
            logger.debug("Connected session [{}] to Web Sockets URI {}", (Object)session.getId(), (Object)this.uri);
        }
        catch (Exception e) {
            throw new TermdConnectionException("Could not connect to Web Sockets " + this.uri, e);
        }
    }

    protected abstract ClientEndpoint getClientEndpoint();

    public void disconnect() {
        logger.debug("Disconnecting from Web Sockets URI {}", (Object)this.uri);
        this.getClientEndpoint().close();
    }

    public void sendAsBinary(ByteBuffer data) throws IOException {
        this.getClientEndpoint().sendBinary(data);
    }

    @Override
    public void close() throws Exception {
        this.disconnect();
    }
}

