/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.termdbuilddriver.websockets;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.jboss.pnc.termdbuilddriver.websockets.ClientMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientEndpoint
extends Endpoint {
    private final Logger logger = LoggerFactory.getLogger(ClientEndpoint.class);
    Session session;
    private ClientMessageHandler messageHandler;

    public ClientEndpoint(ClientMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void onOpen(Session session, EndpointConfig config) {
        this.logger.debug("Client received open.");
        this.session = session;
        session.addMessageHandler((MessageHandler)new /* Unavailable Anonymous Inner Class!! */);
        session.addMessageHandler((MessageHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void close() {
        try {
            this.session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Bye."));
        }
        catch (IOException e) {
            this.logger.error("Cannot close web socket session.", (Throwable)e);
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.logger.debug("Closing client session [{}].", (Object)session.getId());
    }

    public void onError(Session session, Throwable thr) {
        this.logger.error("Error in session " + session.getId(), thr);
    }

    public void sendBinary(ByteBuffer data) throws IOException {
        this.session.getBasicRemote().sendBinary(data);
    }

    static /* synthetic */ Logger access$000(ClientEndpoint x0) {
        return x0.logger;
    }

    static /* synthetic */ ClientMessageHandler access$100(ClientEndpoint x0) {
        return x0.messageHandler;
    }
}

