/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.termdbuilddriver;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.buildagent.api.Status;
import org.jboss.pnc.buildagent.api.TaskStatusUpdateEvent;
import org.jboss.pnc.buildagent.client.BuildAgentClient;
import org.jboss.pnc.buildagent.client.BuildAgentClientException;
import org.jboss.pnc.common.Configuration;
import org.jboss.pnc.common.json.ConfigurationParseException;
import org.jboss.pnc.common.json.moduleconfig.SystemConfig;
import org.jboss.pnc.common.json.moduleprovider.ConfigProvider;
import org.jboss.pnc.common.json.moduleprovider.PncConfigProvider;
import org.jboss.pnc.common.util.NamedThreadFactory;
import org.jboss.pnc.model.BuildStatus;
import org.jboss.pnc.spi.builddriver.BuildDriver;
import org.jboss.pnc.spi.builddriver.CompletedBuild;
import org.jboss.pnc.spi.builddriver.DebugData;
import org.jboss.pnc.spi.builddriver.RunningBuild;
import org.jboss.pnc.spi.builddriver.exception.BuildDriverException;
import org.jboss.pnc.spi.environment.RunningEnvironment;
import org.jboss.pnc.spi.executor.BuildExecutionSession;
import org.jboss.pnc.termdbuilddriver.DefaultCompletedBuild;
import org.jboss.pnc.termdbuilddriver.StatusUpdateEvent;
import org.jboss.pnc.termdbuilddriver.TermdRunningBuild;
import org.jboss.pnc.termdbuilddriver.transfer.TermdFileTranser;
import org.jboss.pnc.termdbuilddriver.transfer.TransferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class TermdBuildDriver
implements BuildDriver {
    public static final String DRIVER_ID = "termd-build-driver";
    private static final Logger logger = LoggerFactory.getLogger(TermdBuildDriver.class);
    private boolean useInternalNetwork = true;
    private ExecutorService executor;
    private Set<Consumer<StatusUpdateEvent>> statusUpdateConsumers = new HashSet();
    private Consumer<StatusUpdateEvent> onStatusUpdate = status -> this.statusUpdateConsumers.forEach(consumer -> consumer.accept(status));

    @Deprecated
    public TermdBuildDriver() {
    }

    @Inject
    public TermdBuildDriver(Configuration configuration) {
        int threadPoolSize = 12;
        try {
            String executorThreadPoolSizeStr = ((SystemConfig)configuration.getModuleConfig((ConfigProvider)new PncConfigProvider(SystemConfig.class))).getBuilderThreadPoolSize();
            if (executorThreadPoolSizeStr != null) {
                threadPoolSize = Integer.parseInt(executorThreadPoolSizeStr);
            }
        }
        catch (ConfigurationParseException e) {
            logger.warn("Unable parse config. Using defaults.");
        }
        this.executor = Executors.newFixedThreadPool(threadPoolSize, (ThreadFactory)new NamedThreadFactory(DRIVER_ID));
    }

    public String getDriverId() {
        return DRIVER_ID;
    }

    public RunningBuild startProjectBuild(BuildExecutionSession buildExecutionSession, RunningEnvironment runningEnvironment, Consumer<CompletedBuild> onComplete, Consumer<Throwable> onError) throws BuildDriverException {
        logger.info("[{}] Starting build for Build Execution Session {}", (Object)runningEnvironment.getId(), (Object)buildExecutionSession.getId());
        TermdRunningBuild termdRunningBuild = new TermdRunningBuild(runningEnvironment, buildExecutionSession.getBuildExecutionConfiguration(), onComplete, onError);
        DebugData debugData = runningEnvironment.getDebugData();
        String buildScript = this.prepareBuildScript(termdRunningBuild, debugData);
        ((CompletableFuture)((CompletableFuture)this.uploadScript(termdRunningBuild, buildScript).thenComposeAsync(scriptPath -> this.invokeRemoteScript(termdRunningBuild, scriptPath, debugData), (Executor)this.executor)).thenComposeAsync(status -> this.collectResults(termdRunningBuild, status), (Executor)this.executor)).handle((completedBuild, exception) -> this.complete(termdRunningBuild, completedBuild, exception));
        return termdRunningBuild;
    }

    private CompletableFuture<String> uploadScript(TermdRunningBuild termdRunningBuild, String command) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        Runnable task = () -> {
            try {
                if (termdRunningBuild.isCanceled()) {
                    logger.debug("Skipping script uploading (cancel flag) ...");
                    result.complete("");
                    return;
                }
                logger.debug("[{}] Uploading script ...", (Object)termdRunningBuild.getRunningEnvironment().getId());
                logger.debug("[{}] Full script:\n {}", (Object)termdRunningBuild.getRunningEnvironment().getId(), (Object)command);
                try {
                    new TermdFileTranser(URI.create(this.getBuildAgentUrl(termdRunningBuild))).uploadScript(command, Paths.get(termdRunningBuild.getRunningEnvironment().getWorkingDirectory().toAbsolutePath().toString(), "run.sh"));
                }
                catch (TransferException e) {
                    result.completeExceptionally(e);
                }
                String scriptPath = termdRunningBuild.getRunningEnvironment().getWorkingDirectory().toAbsolutePath().toString() + "/run.sh";
                result.complete(scriptPath);
            }
            catch (Throwable e) {
                logger.warn("Caught unhandled exception.", e);
            }
        };
        Future<?> taskFuture = this.executor.submit(task);
        Runnable cancel = () -> {
            logger.info("Cancelling script upload ...");
            logger.debug("taskFuture.isDone: {}.", (Object)taskFuture.isDone());
            boolean canceled = taskFuture.cancel(true);
            if (canceled) {
                result.complete("");
            }
            logger.debug("taskFuture.isDone: {}; taskFuture.isCanceled: {}.", (Object)taskFuture.isDone(), (Object)taskFuture.isCancelled());
        };
        termdRunningBuild.setCancelHook(cancel);
        return result;
    }

    private CompletableFuture<Status> invokeRemoteScript(TermdRunningBuild termdRunningBuild, String scriptPath, DebugData debugData) {
        CompletableFuture<Status> invocation = new CompletableFuture<Status>();
        if (termdRunningBuild.isCanceled()) {
            logger.debug("Skipping remote script invocation (cancel flag) ...");
            invocation.complete(Status.INTERRUPTED);
            return invocation;
        }
        logger.debug("Invoking remote script ...");
        Consumer<TaskStatusUpdateEvent> onStatusUpdate = event -> {
            Status newStatus = termdRunningBuild.isCanceled() && event.getNewStatus().equals((Object)Status.FAILED) ? Status.INTERRUPTED : event.getNewStatus();
            logger.debug("Driver received new status update {}.", (Object)newStatus);
            this.statusUpdateConsumers.forEach(consumer -> consumer.accept(new StatusUpdateEvent(termdRunningBuild, newStatus)));
            if (newStatus.isFinal()) {
                logger.debug("Script invocation completed with status {}.", (Object)newStatus);
                if (newStatus == Status.FAILED && debugData.isEnableDebugOnFailure()) {
                    debugData.setDebugEnabled(true);
                    this.enableSsh(termdRunningBuild);
                }
                invocation.complete(newStatus);
            }
        };
        BuildAgentClient buildAgentClient = this.createBuildAgentClient(termdRunningBuild, invocation, onStatusUpdate);
        termdRunningBuild.setBuildAgentClient(buildAgentClient);
        try {
            String command = "sh " + scriptPath;
            logger.info("Invoking remote command {}.", (Object)command);
            buildAgentClient.executeCommand(command);
            logger.debug("Remote command invoked.");
        }
        catch (TimeoutException | BuildAgentClientException e) {
            invocation.completeExceptionally((Throwable)new BuildDriverException("Cannot execute remote script.", (Exception)e));
        }
        termdRunningBuild.setCancelHook(() -> {
            try {
                logger.info("Canceling running build {}.", (Object)termdRunningBuild.getName());
                buildAgentClient.executeNow((Object)3);
            }
            catch (BuildAgentClientException e) {
                invocation.completeExceptionally((Throwable)new BuildDriverException("Cannot cancel remote script.", (Exception)((Object)e)));
            }
        });
        return invocation;
    }

    public boolean addStatusUpdateConsumer(Consumer<StatusUpdateEvent> consumer) {
        return this.statusUpdateConsumers.add(consumer);
    }

    public boolean removeStatusUpdateConsumer(Consumer<StatusUpdateEvent> consumer) {
        return this.statusUpdateConsumers.remove(consumer);
    }

    private void enableSsh(TermdRunningBuild termd) {
        Optional maybeClient = termd.getBuildAgentClient();
        if (maybeClient.isPresent()) {
            BuildAgentClient client = (BuildAgentClient)maybeClient.get();
            try {
                client.executeCommand("/usr/local/bin/startSshd.sh");
            }
            catch (TimeoutException | BuildAgentClientException e) {
                logger.error("Failed to enable ssh access", e);
            }
        } else {
            logger.error("No build agent client present to enable ssh access");
        }
    }

    private BuildAgentClient createBuildAgentClient(TermdRunningBuild termdRunningBuild, CompletableFuture<Status> invocation, Consumer<TaskStatusUpdateEvent> onStatusUpdate) {
        BuildAgentClient buildAgentClient = null;
        try {
            String terminalUrl = this.getBuildAgentUrl(termdRunningBuild);
            buildAgentClient = new BuildAgentClient(terminalUrl.replace("http://", "ws://"), Optional.empty(), onStatusUpdate, "");
        }
        catch (Exception e) {
            invocation.completeExceptionally((Throwable)new BuildDriverException("Cannot connect build agent client.", e));
        }
        return buildAgentClient;
    }

    private CompletableFuture<CompletedBuild> collectResults(TermdRunningBuild termdRunningBuild, Status completionStatus) {
        CompletableFuture<CompletedBuild> future = new CompletableFuture<CompletedBuild>();
        CompletableFuture.runAsync(() -> {
            logger.info("Collecting results ...");
            if (termdRunningBuild.getBuildAgentClient().isPresent()) {
                BuildAgentClient buildAgentClient = (BuildAgentClient)termdRunningBuild.getBuildAgentClient().get();
                try {
                    buildAgentClient.close();
                }
                catch (IOException e) {
                    future.completeExceptionally((Throwable)new BuildDriverException("Cannot close build agent connections.", (Exception)e));
                }
            }
            TermdFileTranser transfer = new TermdFileTranser();
            StringBuffer stringBuffer = new StringBuffer();
            String logsDirectory = termdRunningBuild.getRunningEnvironment().getWorkingDirectory().toString();
            try {
                URI logsUri = new URI(this.getBuildAgentUrl(termdRunningBuild)).resolve("servlet/download" + logsDirectory + "/console.log");
                transfer.downloadFileToStringBuilder(stringBuffer, logsUri);
            }
            catch (URISyntaxException e) {
                future.completeExceptionally((Throwable)new BuildDriverException("Cannot construct logs uri.", (Exception)e));
            }
            catch (TransferException e) {
                future.completeExceptionally((Throwable)new BuildDriverException("Cannot transfer file.", (Exception)((Object)e)));
            }
            DefaultCompletedBuild completedBuild = new DefaultCompletedBuild(termdRunningBuild.getRunningEnvironment(), this.getBuildStatus(completionStatus), stringBuffer.toString());
            future.complete((CompletedBuild)completedBuild);
        }, this.executor);
        return future;
    }

    private BuildStatus getBuildStatus(Status completionStatus) {
        if (Status.COMPLETED.equals((Object)completionStatus)) {
            return BuildStatus.SUCCESS;
        }
        if (Status.INTERRUPTED.equals((Object)completionStatus)) {
            return BuildStatus.CANCELLED;
        }
        return BuildStatus.FAILED;
    }

    private Void complete(TermdRunningBuild termdRunningBuild, CompletedBuild completedBuild, Throwable throwable) {
        logger.debug("[{}] Command result {}", (Object)termdRunningBuild.getRunningEnvironment().getId(), (Object)completedBuild);
        if (throwable != null) {
            logger.warn("[{}] Exception {}", (Object)termdRunningBuild.getRunningEnvironment().getId(), (Object)throwable);
            termdRunningBuild.setBuildError((Exception)throwable);
        } else if (completedBuild == null) {
            termdRunningBuild.setBuildError((Exception)new BuildDriverException("Completed build should not be null."));
        } else {
            termdRunningBuild.setCompletedBuild(completedBuild);
        }
        return null;
    }

    private String prepareBuildScript(TermdRunningBuild termdRunningBuild, DebugData debugData) {
        StringBuilder buildScript = new StringBuilder();
        String workingDirectory = termdRunningBuild.getRunningEnvironment().getWorkingDirectory().toAbsolutePath().toString();
        String name = termdRunningBuild.getName();
        if (debugData.isEnableDebugOnFailure()) {
            String projectDirectory = (workingDirectory.endsWith("/") ? workingDirectory : workingDirectory + "/") + name;
            String enterProjectDirCommand = "echo 'cd " + projectDirectory + "' >> /home/worker/.bashrc";
            buildScript.append(enterProjectDirCommand).append("\n");
        }
        buildScript.append("set -xe\n");
        buildScript.append("cd " + workingDirectory + "\n");
        buildScript.append("git clone " + termdRunningBuild.getScmRepoURL() + " " + name + "\n");
        buildScript.append("cd " + name + "\n");
        buildScript.append("git reset --hard " + termdRunningBuild.getScmRevision() + "\n");
        buildScript.append(termdRunningBuild.getBuildScript() + "\n");
        return buildScript.toString();
    }

    private String getBuildAgentUrl(TermdRunningBuild termdRunningBuild) {
        RunningEnvironment runningEnvironment = termdRunningBuild.getRunningEnvironment();
        if (this.useInternalNetwork) {
            return runningEnvironment.getInternalBuildAgentUrl();
        }
        return runningEnvironment.getBuildAgentUrl();
    }
}

