/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.termdbuilddriver;

import java.net.URI;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.pnc.buildagent.api.ResponseMode;
import org.jboss.pnc.buildagent.api.TaskStatusUpdateEvent;
import org.jboss.pnc.buildagent.client.BuildAgentClient;
import org.jboss.pnc.buildagent.client.BuildAgentClientException;
import org.jboss.pnc.buildagent.client.BuildAgentSocketClient;
import org.jboss.pnc.common.json.moduleconfig.TermdBuildDriverModuleConfig;
import org.jboss.pnc.termdbuilddriver.ClientFactory;
import org.jboss.pnc.termdbuilddriver.transfer.DefaultFileTranser;
import org.jboss.pnc.termdbuilddriver.transfer.FileTranser;

@ApplicationScoped
public class DefaultClientFactory
implements ClientFactory {
    private final Optional<Integer> fileTransferConnectTimeout;
    private final Optional<Integer> fileTransferReadTimeout;

    public DefaultClientFactory() {
        this.fileTransferConnectTimeout = Optional.empty();
        this.fileTransferReadTimeout = Optional.empty();
    }

    public DefaultClientFactory(TermdBuildDriverModuleConfig config) {
        this.fileTransferConnectTimeout = Optional.ofNullable(config.getFileTransferConnectTimeout());
        this.fileTransferReadTimeout = Optional.ofNullable(config.getFileTransferReadTimeout());
    }

    @Override
    public BuildAgentClient createBuildAgentClient(String terminalUrl, Consumer<TaskStatusUpdateEvent> onStatusUpdate) throws TimeoutException, InterruptedException, BuildAgentClientException {
        return new BuildAgentSocketClient(terminalUrl, Optional.empty(), onStatusUpdate, "", ResponseMode.SILENT, false);
    }

    @Override
    public FileTranser getFileTransfer(URI baseServerUri, int maxLogSize) {
        DefaultFileTranser defaultFileTranser = new DefaultFileTranser(baseServerUri, maxLogSize);
        this.fileTransferConnectTimeout.ifPresent(i -> defaultFileTranser.setConnectTimeout((int)i));
        this.fileTransferReadTimeout.ifPresent(i -> defaultFileTranser.setReadTimeout((int)i));
        return defaultFileTranser;
    }
}

