/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.termdbuilddriver;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.jboss.pnc.buildagent.api.Status;
import org.jboss.pnc.buildagent.api.TaskStatusUpdateEvent;
import org.jboss.pnc.buildagent.client.BuildAgentClient;
import org.jboss.pnc.buildagent.client.BuildAgentClientException;
import org.jboss.pnc.common.concurrent.MDCWrappers;
import org.jboss.pnc.spi.builddriver.exception.BuildDriverException;
import org.jboss.pnc.termdbuilddriver.ClientFactory;
import org.jboss.pnc.termdbuilddriver.RemoteInvocationCompletion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoteInvocation
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(RemoteInvocation.class);
    private BuildAgentClient buildAgentClient;
    private String scriptPath;
    private final CompletableFuture<RemoteInvocationCompletion> completionNotifier = new CompletableFuture();
    private boolean canceled = false;
    private Set<Runnable> closeListeners = new HashSet<Runnable>();

    public RemoteInvocation(ClientFactory buildAgentClientFactory, String terminalUrl, Optional<Consumer<Status>> onStatusUpdate) throws BuildDriverException {
        Consumer<TaskStatusUpdateEvent> onStatusUpdateInternal = event -> {
            Status newStatus = this.isCanceled() && event.getNewStatus().equals((Object)Status.FAILED) ? Status.INTERRUPTED : event.getNewStatus();
            logger.debug("Driver received new status update {}.", (Object)newStatus);
            onStatusUpdate.ifPresent(c -> c.accept(newStatus));
            if (newStatus.isFinal()) {
                this.completionNotifier.complete(new RemoteInvocationCompletion(newStatus, Optional.ofNullable(event.getOutputChecksum())));
            }
        };
        try {
            this.buildAgentClient = buildAgentClientFactory.createBuildAgentClient(terminalUrl, MDCWrappers.wrap(onStatusUpdateInternal));
        }
        catch (InterruptedException | TimeoutException | BuildAgentClientException e) {
            throw new BuildDriverException("Cannot create Build Agent Client.", e);
        }
    }

    void invoke() {
        String command = "sh " + this.scriptPath;
        if (this.buildAgentClient != null) {
            try {
                logger.info("Invoking remote command {}.", (Object)command);
                this.buildAgentClient.execute((Object)command);
                logger.debug("Remote command invoked.");
            }
            catch (BuildAgentClientException e) {
                throw new RuntimeException("Cannot execute remote command.", e);
            }
        } else {
            logger.warn("There is no buildAgentClient to invoke command: {}", (Object)command);
        }
    }

    void cancel() {
        this.canceled = true;
        try {
            logger.info("Canceling running build.");
            this.buildAgentClient.cancel();
        }
        catch (BuildAgentClientException e) {
            this.completionNotifier.completeExceptionally((Throwable)new BuildDriverException("Cannot cancel remote script.", (Throwable)e));
        }
    }

    public void enableSsh() {
        try {
            this.buildAgentClient.execute((Object)"/usr/local/bin/startSshd.sh");
        }
        catch (BuildAgentClientException e) {
            logger.error("Failed to enable ssh access", (Throwable)e);
        }
    }

    public void setScriptPath(String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public void notifyCompleted(RemoteInvocationCompletion remoteInvocationCompletion) {
        this.completionNotifier.complete(remoteInvocationCompletion);
    }

    public CompletableFuture<RemoteInvocationCompletion> getCompletionNotifier() {
        return this.completionNotifier;
    }

    @Override
    public void close() {
        if (this.buildAgentClient != null) {
            logger.debug("Closing build agent client.");
            try {
                this.buildAgentClient.close();
                this.buildAgentClient = null;
            }
            catch (IOException e) {
                logger.error("Cannot close buildAgentClient.", (Throwable)e);
            }
        } else {
            logger.debug("There is no buildAgentClient probably cancel has been requested.");
        }
        this.closeListeners.forEach(Runnable::run);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void addOnClose(Runnable task) {
        this.closeListeners.add(task);
    }

    public boolean isAlive() {
        return this.buildAgentClient.isServerAlive();
    }
}

