/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.termdbuilddriver;

import java.lang.invoke.MethodHandles;
import java.util.function.Consumer;
import org.jboss.pnc.spi.builddriver.CompletedBuild;
import org.jboss.pnc.spi.builddriver.RunningBuild;
import org.jboss.pnc.spi.environment.RunningEnvironment;
import org.jboss.pnc.spi.executor.BuildExecutionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermdRunningBuild
implements RunningBuild {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final RunningEnvironment runningEnvironment;
    private final BuildExecutionConfiguration buildExecutionConfiguration;
    private Consumer<CompletedBuild> onComplete;
    private Consumer<Throwable> onError;
    private Runnable cancelHook;
    private boolean cancelRequested = false;

    public TermdRunningBuild(RunningEnvironment runningEnvironment, BuildExecutionConfiguration buildExecutionConfiguration, Consumer<CompletedBuild> onComplete, Consumer<Throwable> onError) {
        this.runningEnvironment = runningEnvironment;
        this.buildExecutionConfiguration = buildExecutionConfiguration;
        this.onComplete = onComplete;
        this.onError = onError;
    }

    public void setCompletedBuild(CompletedBuild completedBuild) {
        logger.debug("[{}] Setting completed build {}", (Object)this.runningEnvironment.getId(), (Object)completedBuild);
        this.onComplete.accept(completedBuild);
    }

    public void setBuildError(Exception error) {
        this.onError.accept(error);
    }

    public RunningEnvironment getRunningEnvironment() {
        return this.runningEnvironment;
    }

    public synchronized void cancel() {
        this.cancelRequested = true;
        if (this.cancelHook != null) {
            this.cancelHook.run();
        } else {
            logger.warn("Trying to cancel operation while no cancel hook is defined.");
        }
    }

    public String getBuildScript() {
        return this.buildExecutionConfiguration.getBuildScript();
    }

    public String getName() {
        return this.buildExecutionConfiguration.getName();
    }

    public String getScmRepoURL() {
        return this.buildExecutionConfiguration.getScmRepoURL();
    }

    public String getScmRevision() {
        return this.buildExecutionConfiguration.getScmRevision();
    }

    public synchronized void setCancelHook(Runnable cancelHook) {
        this.cancelHook = cancelHook;
    }

    public boolean isCanceled() {
        return this.cancelRequested;
    }
}

