/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.termdbuilddriver.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.function.Consumer;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.termdbuilddriver.transfer.FileTranser;
import org.jboss.pnc.termdbuilddriver.transfer.TransferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileTranser
implements FileTranser {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ENCODING = "UTF-8";
    private static final String UPLOAD_PATH = "servlet/upload";
    private final URI baseServerUri;
    private boolean fullyDownloaded = true;
    private int maxDownloadSize;
    private int connectTimeout = 5000;
    private int readTimeout = 30000;

    public DefaultFileTranser(URI baseServerUri, int maxDownloadSize) {
        this.baseServerUri = baseServerUri;
        this.maxDownloadSize = maxDownloadSize;
    }

    @Override
    public StringBuffer downloadFileToStringBuilder(StringBuffer logsAggregate, URI uri) throws TransferException {
        try {
            String line;
            logger.debug("Downloading file to String Buffer from {}", (Object)uri);
            ArrayDeque logLines = new ArrayDeque();
            HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
            connection.setRequestMethod("GET");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setConnectTimeout(this.connectTimeout);
            connection.setReadTimeout(this.readTimeout);
            Consumer<String> removedLines = removedLine -> {
                this.fullyDownloaded = false;
                logger.debug("Dropped log line from URI {}: {}.", (Object)uri, removedLine);
            };
            try (InputStream inputStream = connection.getInputStream();){
                Charset charset = Charset.forName(ENCODING);
                StringUtils.readStream((InputStream)inputStream, (Charset)charset, logLines, (int)this.maxDownloadSize, removedLines);
            }
            logsAggregate.append("==== ").append(uri.toString()).append(" ====\n");
            while ((line = (String)logLines.pollFirst()) != null) {
                logsAggregate.append(line + "\n");
            }
            if (logLines.size() > 0) {
                logger.warn("Log buffer was not fully drained for URI: {}", (Object)uri);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Downloaded log: {}.", (Object)logsAggregate);
            }
            return logsAggregate;
        }
        catch (IOException e) {
            throw new TransferException("Could not obtain log file: " + uri.toString(), e);
        }
    }

    @Override
    public boolean isFullyDownloaded() {
        return this.fullyDownloaded;
    }

    @Override
    public void uploadScript(String script, Path remoteFilePath) throws TransferException {
        logger.debug("Uploading build script to remote path {}, build script {}", (Object)remoteFilePath, (Object)script);
        String scriptPath = UPLOAD_PATH + remoteFilePath.toAbsolutePath().toString();
        logger.debug("Resolving script path {} to base uri {}", (Object)scriptPath, (Object)this.baseServerUri);
        URI uploadUri = this.baseServerUri.resolve(scriptPath);
        try {
            HttpURLConnection connection = (HttpURLConnection)uploadUri.toURL().openConnection();
            connection.setRequestMethod("PUT");
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setConnectTimeout(this.connectTimeout);
            connection.setReadTimeout(this.readTimeout);
            byte[] fileContent = script.getBytes();
            connection.setRequestProperty("Content-Length", "" + Integer.toString(fileContent.length));
            try (OutputStream outputStream = connection.getOutputStream();){
                outputStream.write(fileContent);
            }
            if (200 != connection.getResponseCode()) {
                throw new TransferException("Could not upload script to Build Agent at url " + connection.getURL() + " - Returned status code " + connection.getResponseCode());
            }
            logger.debug("Uploaded successfully");
        }
        catch (IOException e) {
            throw new TransferException("Could not upload build script: " + uploadUri.toString(), e);
        }
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }
}

