/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.termdbuilddriver;

import java.net.URI;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.buildagent.api.Status;
import org.jboss.pnc.common.concurrent.MDCExecutors;
import org.jboss.pnc.common.concurrent.NamedThreadFactory;
import org.jboss.pnc.common.json.moduleconfig.SystemConfig;
import org.jboss.pnc.common.json.moduleconfig.TermdBuildDriverModuleConfig;
import org.jboss.pnc.enums.BuildStatus;
import org.jboss.pnc.spi.builddriver.BuildDriver;
import org.jboss.pnc.spi.builddriver.CompletedBuild;
import org.jboss.pnc.spi.builddriver.DebugData;
import org.jboss.pnc.spi.builddriver.RunningBuild;
import org.jboss.pnc.spi.builddriver.exception.BuildDriverException;
import org.jboss.pnc.spi.environment.RunningEnvironment;
import org.jboss.pnc.spi.executor.BuildExecutionSession;
import org.jboss.pnc.termdbuilddriver.ClientFactory;
import org.jboss.pnc.termdbuilddriver.DefaultCompletedBuild;
import org.jboss.pnc.termdbuilddriver.RemoteInvocation;
import org.jboss.pnc.termdbuilddriver.RemoteInvocationCompletion;
import org.jboss.pnc.termdbuilddriver.TermdRunningBuild;
import org.jboss.pnc.termdbuilddriver.transfer.FileTranser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class TermdBuildDriver
implements BuildDriver {
    public static final String DRIVER_ID = "termd-build-driver";
    private static final int MAX_LOG_SIZE = 0x5A00000;
    private static final Logger logger = LoggerFactory.getLogger(TermdBuildDriver.class);
    private final ClientFactory clientFactory;
    private boolean useInternalNetwork = true;
    private Integer internalCancelTimeoutMillis;
    private long livenessProbeFrequency;
    private long livenessFailTimeout;
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutorService;

    @Deprecated
    public TermdBuildDriver() {
        this.clientFactory = null;
    }

    @Inject
    public TermdBuildDriver(SystemConfig systemConfig, TermdBuildDriverModuleConfig termdBuildDriverModuleConfig, ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
        int threadPoolSize = 12;
        String executorThreadPoolSizeStr = systemConfig.getBuilderThreadPoolSize();
        if (executorThreadPoolSizeStr != null) {
            threadPoolSize = Integer.parseInt(executorThreadPoolSizeStr);
        }
        this.internalCancelTimeoutMillis = termdBuildDriverModuleConfig.getInternalCancelTimeoutMillis();
        this.livenessProbeFrequency = termdBuildDriverModuleConfig.getLivenessProbeFrequencyMillis();
        this.livenessFailTimeout = termdBuildDriverModuleConfig.getLivenessFailTimeoutMillis();
        this.executor = MDCExecutors.newFixedThreadPool((int)threadPoolSize, (ThreadFactory)new NamedThreadFactory(DRIVER_ID));
        this.scheduledExecutorService = MDCExecutors.newScheduledThreadPool((int)1, (NamedThreadFactory)new NamedThreadFactory("build-driver-liveness-cancel"));
    }

    public String getDriverId() {
        return DRIVER_ID;
    }

    public RunningBuild startProjectBuild(BuildExecutionSession buildExecutionSession, RunningEnvironment runningEnvironment, Consumer<CompletedBuild> onComplete, Consumer<Throwable> onError) throws BuildDriverException {
        return this.startProjectBuild(buildExecutionSession, runningEnvironment, onComplete, onError, Optional.empty());
    }

    public RunningBuild startProjectBuild(BuildExecutionSession buildExecutionSession, RunningEnvironment runningEnvironment, Consumer<CompletedBuild> onComplete, Consumer<Throwable> onError, Optional<Consumer<Status>> onStatusUpdate) throws BuildDriverException {
        logger.info("[{}] Starting build for Build Execution Session {}", (Object)runningEnvironment.getId(), (Object)buildExecutionSession.getId());
        TermdRunningBuild termdRunningBuild = new TermdRunningBuild(runningEnvironment, buildExecutionSession.getBuildExecutionConfiguration(), onComplete, onError);
        DebugData debugData = runningEnvironment.getDebugData();
        String buildScript = this.prepareBuildScript(termdRunningBuild, debugData);
        if (!termdRunningBuild.isCanceled()) {
            String terminalUrl = this.getBuildAgentUrl(runningEnvironment);
            RemoteInvocation remoteInvocation = new RemoteInvocation(this.clientFactory, terminalUrl, onStatusUpdate);
            FileTranser fileTransfer = this.clientFactory.getFileTransfer(URI.create(this.getBuildAgentUrl(runningEnvironment)), 0x5A00000);
            CompletionStage prepareBuildFuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                logger.debug("Uploading build script to build environment ...");
                return this.uploadTask(termdRunningBuild.getRunningEnvironment(), buildScript, fileTransfer);
            }, this.executor).thenApplyAsync(scriptPath -> {
                logger.debug("Setting the script path ...");
                remoteInvocation.setScriptPath((String)scriptPath);
                return null;
            }, (Executor)this.executor)).thenRunAsync(() -> {
                logger.debug("Invoking remote script ...");
                this.invokeRemoteScript(remoteInvocation);
            }, this.executor);
            CompletionStage buildLivenessFuture = ((CompletableFuture)prepareBuildFuture).thenComposeAsync(nul -> {
                logger.debug("Starting liveness monitor ...");
                return this.monitorBuildLiveness(remoteInvocation);
            }, (Executor)this.executor);
            CompletionStage buildCompletionFuture = ((CompletableFuture)prepareBuildFuture).thenComposeAsync(nul -> {
                logger.debug("Waiting fo remote script to complete...");
                return remoteInvocation.getCompletionNotifier();
            }, (Executor)this.executor);
            CompletionStage optionallyEnableDebug = ((CompletableFuture)buildCompletionFuture).thenApplyAsync(remoteInvocationCompletion -> {
                Status status = remoteInvocationCompletion.getStatus();
                if (status.isFinal()) {
                    logger.debug("Script completionNotifier completed with status {}.", (Object)status);
                    if (status == Status.FAILED && debugData.isEnableDebugOnFailure()) {
                        debugData.setDebugEnabled(true);
                        remoteInvocation.enableSsh();
                    }
                }
                return remoteInvocationCompletion;
            }, (Executor)this.executor);
            CompletableFuture<Object> buildFuture = CompletableFuture.anyOf(new CompletableFuture[]{buildLivenessFuture, optionallyEnableDebug});
            buildFuture.handle((result, exception) -> {
                RemoteInvocationCompletion completion;
                if (result != null) {
                    RemoteInvocationCompletion remoteInvocationCompletion = (RemoteInvocationCompletion)result;
                    if (remoteInvocationCompletion.getException() != null) {
                        logger.warn("Completing build execution. Exception: {};", (Throwable)remoteInvocationCompletion.getException());
                    } else {
                        logger.debug("Completing build execution. Status: {};", (Object)remoteInvocationCompletion.getStatus());
                    }
                    completion = remoteInvocationCompletion;
                } else if (exception != null && exception.getCause() instanceof CancellationException) {
                    logger.warn("Completing build execution. Cancelled;");
                    completion = new RemoteInvocationCompletion(Status.INTERRUPTED, Optional.empty());
                } else {
                    logger.warn("Completing build execution. System error.", exception);
                    completion = new RemoteInvocationCompletion(new BuildDriverException("System error.", exception));
                }
                termdRunningBuild.setCancelHook(null);
                remoteInvocation.close();
                this.complete(termdRunningBuild, completion, fileTransfer);
                return null;
            });
            termdRunningBuild.setCancelHook(() -> this.lambda$startProjectBuild$9(remoteInvocation, (CompletableFuture)prepareBuildFuture));
        } else {
            logger.debug("Skipping script uploading (cancel flag) ...");
        }
        return termdRunningBuild;
    }

    private CompletionStage<RemoteInvocationCompletion> monitorBuildLiveness(RemoteInvocation remoteInvocation) {
        CompletableFuture<RemoteInvocationCompletion> completableFuture = new CompletableFuture<RemoteInvocationCompletion>();
        AtomicReference<Long> lastSuccess = new AtomicReference<Long>();
        lastSuccess.set(System.currentTimeMillis());
        Runnable isAlive = () -> {
            if (remoteInvocation.isAlive()) {
                lastSuccess.set(System.currentTimeMillis());
            } else {
                Long last = (Long)lastSuccess.get();
                if (System.currentTimeMillis() - last > this.livenessFailTimeout) {
                    logger.warn("Liveness probe failed.");
                    RemoteInvocationCompletion completion = new RemoteInvocationCompletion(new BuildDriverException("Build Agent has gone away."));
                    completableFuture.complete(completion);
                }
            }
        };
        ScheduledFuture<?> livenessMonitor = this.scheduledExecutorService.scheduleWithFixedDelay(isAlive, this.livenessProbeFrequency, this.livenessProbeFrequency, TimeUnit.MILLISECONDS);
        remoteInvocation.addPreClose(() -> livenessMonitor.cancel(false));
        return completableFuture;
    }

    private String uploadTask(RunningEnvironment runningEnvironment, String command, FileTranser fileTranser) {
        try {
            logger.debug("Full script:\n {}", (Object)command);
            fileTranser.uploadScript(command, Paths.get(runningEnvironment.getWorkingDirectory().toAbsolutePath().toString(), "run.sh"));
            String scriptPath = runningEnvironment.getWorkingDirectory().toAbsolutePath().toString() + "/run.sh";
            return scriptPath;
        }
        catch (Throwable e) {
            logger.warn("Caught unhandled exception.", e);
            throw new RuntimeException("Unable to upload script.", e);
        }
    }

    private Void invokeRemoteScript(RemoteInvocation remoteInvocation) {
        remoteInvocation.invoke();
        return null;
    }

    private CompletedBuild collectResults(RunningEnvironment runningEnvironment, RemoteInvocationCompletion remoteInvocationCompletion, FileTranser transfer) {
        logger.info("Collecting results ...");
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String logsDirectory = runningEnvironment.getWorkingDirectory().toString();
            URI logsUri = new URI(this.getBuildAgentUrl(runningEnvironment)).resolve("servlet/download" + logsDirectory + "/console.log");
            transfer.downloadFileToStringBuilder(stringBuffer, logsUri);
            String prependMessage = "";
            BuildStatus buildStatus = this.getBuildStatus(remoteInvocationCompletion.getStatus());
            if (!transfer.isFullyDownloaded()) {
                prependMessage = "----- build log was cut, storing only last part -----\n";
                if (buildStatus.completedSuccessfully()) {
                    prependMessage = "----- build has completed successfully but it is marked as failed due to log overflow. Max log size is 94371840 -----\n";
                    buildStatus = BuildStatus.FAILED;
                }
            }
            return new DefaultCompletedBuild(runningEnvironment, buildStatus, remoteInvocationCompletion.getOutputChecksum(), prependMessage + stringBuffer.toString());
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot collect results.", e);
        }
    }

    private BuildStatus getBuildStatus(Status completionStatus) {
        if (Status.COMPLETED.equals((Object)completionStatus)) {
            return BuildStatus.SUCCESS;
        }
        if (Status.INTERRUPTED.equals((Object)completionStatus)) {
            return BuildStatus.CANCELLED;
        }
        return BuildStatus.FAILED;
    }

    private void complete(TermdRunningBuild termdRunningBuild, RemoteInvocationCompletion completion, FileTranser fileTransfer) {
        if (completion.getException() != null) {
            logger.warn("Completed with exception.", (Throwable)completion.getException());
            termdRunningBuild.setBuildError((Throwable)completion.getException());
            return;
        }
        CompletedBuild completedBuild = this.collectResults(termdRunningBuild.getRunningEnvironment(), completion, fileTransfer);
        logger.debug("Command result {}", (Object)completedBuild);
        if (completedBuild == null) {
            termdRunningBuild.setBuildError((Throwable)new BuildDriverException("Completed build should not be null."));
        } else {
            termdRunningBuild.setCompletedBuild(completedBuild);
        }
    }

    private String prepareBuildScript(TermdRunningBuild termdRunningBuild, DebugData debugData) {
        StringBuilder buildScript = new StringBuilder();
        String workingDirectory = termdRunningBuild.getRunningEnvironment().getWorkingDirectory().toAbsolutePath().toString();
        String name = termdRunningBuild.getName();
        if (debugData.isEnableDebugOnFailure()) {
            String projectDirectory = (workingDirectory.endsWith("/") ? workingDirectory : workingDirectory + "/") + name;
            String enterProjectDirCommand = "echo 'cd " + projectDirectory + "' >> \"${HOME}/.bashrc\"";
            buildScript.append(enterProjectDirCommand).append("\n");
        }
        buildScript.append("set -xe\n");
        buildScript.append("cd " + workingDirectory + "\n");
        buildScript.append("git clone " + termdRunningBuild.getScmRepoURL() + " " + name + "\n");
        buildScript.append("cd " + name + "\n");
        buildScript.append("git reset --hard " + termdRunningBuild.getScmRevision() + "\n");
        buildScript.append(termdRunningBuild.getBuildScript() + "\n");
        return buildScript.toString();
    }

    private String getBuildAgentUrl(RunningEnvironment runningEnvironment) {
        if (this.useInternalNetwork) {
            return runningEnvironment.getInternalBuildAgentUrl();
        }
        return runningEnvironment.getBuildAgentUrl();
    }

    private /* synthetic */ void lambda$startProjectBuild$9(RemoteInvocation remoteInvocation, CompletableFuture prepareBuildFuture) {
        remoteInvocation.cancel();
        ScheduledFuture<?> forceCancel_ = this.scheduledExecutorService.schedule(() -> {
            logger.debug("Force cancelling build ...");
            prepareBuildFuture.cancel(true);
        }, (long)this.internalCancelTimeoutMillis.intValue(), TimeUnit.MILLISECONDS);
        remoteInvocation.addPreClose(() -> forceCancel_.cancel(false));
    }
}

