/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.termdbuilddriver;

import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.buildagent.api.ResponseMode;
import org.jboss.pnc.buildagent.api.TaskStatusUpdateEvent;
import org.jboss.pnc.buildagent.client.BuildAgentClient;
import org.jboss.pnc.buildagent.client.BuildAgentClientException;
import org.jboss.pnc.buildagent.client.BuildAgentSocketClient;
import org.jboss.pnc.buildagent.client.SocketClientConfiguration;
import org.jboss.pnc.buildagent.common.http.HttpClient;
import org.jboss.pnc.common.json.moduleconfig.TermdBuildDriverModuleConfig;
import org.jboss.pnc.termdbuilddriver.ClientFactory;
import org.jboss.pnc.termdbuilddriver.transfer.DefaultFileTranser;
import org.jboss.pnc.termdbuilddriver.transfer.FileTranser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DefaultClientFactory
implements ClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultClientFactory.class);
    private final Optional<Integer> fileTransferConnectTimeout;
    private final Optional<Integer> fileTransferReadTimeout;
    private HttpClient httpClient;

    @Inject
    public DefaultClientFactory(TermdBuildDriverModuleConfig config) {
        this.fileTransferConnectTimeout = Optional.ofNullable(config.getFileTransferConnectTimeout());
        this.fileTransferReadTimeout = Optional.ofNullable(config.getFileTransferReadTimeout());
    }

    @PostConstruct
    public void init() throws IOException {
        this.httpClient = new HttpClient();
        logger.info("DefaultClientFactory initialized.");
    }

    @Override
    public BuildAgentClient createBuildAgentClient(String terminalUrl, Consumer<TaskStatusUpdateEvent> onStatusUpdate) throws TimeoutException, InterruptedException, BuildAgentClientException {
        SocketClientConfiguration configuration = SocketClientConfiguration.newBuilder().termBaseUrl(terminalUrl).responseMode(ResponseMode.SILENT).readOnly(false).build();
        return new BuildAgentSocketClient(this.httpClient, Optional.empty(), onStatusUpdate, configuration);
    }

    @Override
    public FileTranser getFileTransfer(URI baseServerUri, int maxLogSize) {
        DefaultFileTranser defaultFileTranser = new DefaultFileTranser(baseServerUri, maxLogSize);
        this.fileTransferConnectTimeout.ifPresent(defaultFileTranser::setConnectTimeout);
        this.fileTransferReadTimeout.ifPresent(defaultFileTranser::setReadTimeout);
        return defaultFileTranser;
    }

    @PreDestroy
    public void destroy() throws IOException {
        this.httpClient.close();
    }
}

