/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.test.cdi;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.inject.Instance;
import javax.enterprise.util.TypeLiteral;

public class TestInstance<T>
implements Instance<T> {
    Collection<T> objects;

    public TestInstance(T ... objects) {
        this.objects = Arrays.asList(objects);
    }

    public TestInstance(Collection<T> objects) {
        this.objects = new ArrayList<T>(objects);
    }

    public Instance<T> select(Annotation ... qualifiers) {
        List filteredObjects = this.objects.stream().filter(object -> {
            for (Annotation a : qualifiers) {
                if (!object.getClass().isAnnotationPresent(a.annotationType())) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        return new TestInstance(filteredObjects);
    }

    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        throw new UnsupportedOperationException("not implemented");
    }

    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean isUnsatisfied() {
        return this.objects.isEmpty();
    }

    public boolean isAmbiguous() {
        return this.objects.size() > 1;
    }

    public Iterator<T> iterator() {
        return this.objects.iterator();
    }

    public T get() {
        return this.objects.iterator().next();
    }
}

