/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.test.arquillian;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.asset.ZipFileEntryAsset;
import org.jboss.shrinkwrap.impl.base.path.PathUtil;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShrinkwrapDeployerUtils {
    private static Logger logger = LoggerFactory.getLogger(ShrinkwrapDeployerUtils.class);

    public static void addPomLibs(JavaArchive jar, String gav) {
        JavaArchive[] libs;
        for (JavaArchive lib : libs = (JavaArchive[])((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml")).resolve(gav)).withTransitivity()).as(JavaArchive.class)) {
            jar.merge((Archive)lib);
        }
    }

    public static void addManifestDependencies(EnterpriseArchive ear, String ... dependencies) {
        Object existingDependencies;
        Manifest newManifest;
        if (dependencies.length == 0) {
            return;
        }
        Node node = ear.get(PathUtil.composeAbsoluteContext((String)"META-INF", (String)"MANIFEST.MF"));
        if (node != null) {
            ZipFileEntryAsset manifest = (ZipFileEntryAsset)node.getAsset();
            try (InputStream inputStream = manifest.openStream();){
                newManifest = new Manifest(inputStream);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot read MANIFEST.MF", e);
            }
            existingDependencies = newManifest.getMainAttributes().getValue("Dependencies") + ", ";
        } else {
            newManifest = new Manifest();
            String vername = Attributes.Name.MANIFEST_VERSION.toString();
            newManifest.getMainAttributes().putValue(vername, "1.0");
            existingDependencies = "";
        }
        String newDependencies = Arrays.stream(dependencies).collect(Collectors.joining(", "));
        newManifest.getMainAttributes().putValue("Dependencies", (String)existingDependencies + newDependencies);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            newManifest.write(bos);
            String manifestContent = new String(bos.toByteArray(), StandardCharsets.UTF_8);
            logger.debug("MANIFEST.MF: {}", (Object)manifestContent);
            ear.addAsManifestResource((Asset)new StringAsset(manifestContent), "MANIFEST.MF");
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write MANIFEST.MF", e);
        }
    }
}

