!function(){"use strict";var e=angular.module("pnc.build-configs",["ui.router","ui.bootstrap","xeditable","pnc.common.restclient","pnc.common.directives","pnc.build-records","infinite-scroll","pnc.common.authentication"]);angular.module("infinite-scroll").value("THROTTLE_MILLISECONDS",350),e.config(["$stateProvider","$urlRouterProvider",function(e,t){t.when(/^\/configuration\/.*/,["$location",function(e){return e.url().replace("/configuration/","/build-configs/")}]),e.state("projects.detail.build-configs",{abstract:!0,url:"/build-configs",views:{"content@":{templateUrl:"common/templates/two-col-right-sidebar.tmpl.html"}},data:{proxy:"projects.detail.build-configs.detail"}}),e.state("projects.detail.build-configs.detail",{url:"/{configurationId:int}",data:{displayName:"{{ configurationDetail.name }}"},views:{"":{templateUrl:"build-configs/views/build-configs.detail-main.html",controller:"ConfigurationDetailController",controllerAs:"detailCtrl"},sidebar:{templateUrl:"build-configs/views/build-configs.detail-sidebar.html",controller:"ConfigurationSidebarController",controllerAs:"sidebarCtrl"}},resolve:{configurationDetail:["BuildConfigurationDAO","$stateParams",function(e,t){return e.get({configurationId:t.configurationId}).$promise}],linkedProductVersions:["BuildConfigurationDAO","$stateParams",function(e,t){return e.getProductVersions({configurationId:t.configurationId})}],dependencies:["BuildConfigurationDAO","$stateParams",function(e,t){return e.getDependencies({configurationId:t.configurationId})}],linkedConfigurationSetList:["BuildConfigurationDAO","$stateParams",function(e,t){return e.getConfigurationSets({configurationId:t.configurationId})}],environments:["EnvironmentDAO",function(e){return e.getAllNotDeprecated().$promise}],products:["ProductDAO",function(e){return e.getAll().$promise}],configurations:["BuildConfigurationDAO",function(e){return e.getAll().$promise}],configurationSetList:["BuildConfigurationSetDAO",function(e){return e.getAll().$promise}]}}),e.state("build-configs",{abstract:!0,url:"/build-configs",views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}},data:{proxy:"build-configs.list"}}),e.state("build-configs.list",{url:"",templateUrl:"build-configs/views/build-configs.list.html",data:{displayName:"Build Configs"},controller:"ConfigurationListController",controllerAs:"listCtrl",resolve:{configurationList:["BuildConfigurationDAO",function(e){return e.getAll().$promise}]}}),e.state("build-configs.detail",{url:"/{configurationId:int}",resolve:{configurationDetail:["BuildConfigurationDAO","$stateParams",function(e,t){return e.get({configurationId:t.configurationId}).$promise}]},onEnter:["$state","$timeout","configurationDetail",function(e,t,r){t(function(){e.go("projects.detail.build-configs.detail",{projectId:r.project.id,configurationId:r.id})})}]}),e.state("build-configs.create",{url:"/create",templateUrl:"build-configs/views/build-configs.create.html",data:{displayName:"Create Build Config",requireAuth:!0}})}])}(),function(){"use strict";angular.module("pnc.build-groups",["ui.router","xeditable","pnc.common.restclient","pnc.common.events","pnc.common.authentication","pnc.common.pnc-client"]).config(["$stateProvider","$urlRouterProvider",function(e,t){t.when(/^\/configuration-set\/.*/,["$location",function(e){return e.url().replace("/configuration-set/","/build-groups/")}]),e.state("build-groups",{abstract:!0,url:"/build-groups",views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}},data:{proxy:"build-groups.list"}}),e.state("build-groups.list",{url:"",templateUrl:"build-groups/views/build-groups.list.html",data:{displayName:"Build Groups"},controller:"ConfigurationSetListController",controllerAs:"setlistCtrl",resolve:{configurationSetList:["BuildConfigurationSetDAO",function(e){return e.getAll().$promise}]}}),e.state("build-groups.detail",{abstract:!0,url:"/{configurationSetId:int}",templateUrl:"build-groups/views/build-groups.detail.html",data:{displayName:"{{ configurationSetDetail.name }}"},controller:"ConfigurationSetDetailController",controllerAs:"detailSetCtrl",resolve:{configurationSetDetail:["BuildConfigurationSet","$stateParams",function(e,t){return e.get({id:t.configurationSetId}).$promise}],productVersion:["$q","ProductVersion","configurationSetDetail",function(e,t,r){return e.when(r.productVersionId).then(function(e){if(e)return t.get({id:e}).$promise})}],configurations:["BuildConfigurationSetDAO","$stateParams",function(e,t){return e.getConfigurations({configurationSetId:t.configurationSetId})}],previousState:["$state","$q",function(e,t){var r={Name:e.current.name,Params:e.params,URL:e.href(e.current.name,e.params)};return t.when(r)}],buildConfigsPage:["$stateParams","BuildConfigurationSetDAO",function(e,t){return t.getPagedConfigurations({configurationSetId:e.configurationSetId}).$promise}]}}),e.state("build-groups.detail.build-configs",{url:"",component:"pncBuildGroupBuildConfigs",bindings:{buildGroup:"configurationSetDetail",page:"buildConfigsPage"}}),e.state("build-groups.detail.build-history",{url:"/build-history",component:"pncBuildGroupBuildHistory",resolve:{buildGroupRecords:["$stateParams","BuildConfigurationSet",function(e,t){var r=t.queryBuildConfigSetRecords({id:e.configurationSetId});return r.$promise.then(function(){return r})}]}}),e.state("build-groups.create",{url:"/create/:productId/:versionId",templateUrl:"build-groups/views/build-groups.create.html",data:{displayName:"Create Build Group",requireAuth:!0},controller:"ConfigurationSetCreateController",controllerAs:"createSetCtrl",resolve:{products:["ProductDAO",function(e){return e.getAll()}]}}),e.state("build-groups.add-configuration",{url:"/build-groups/{configurationSetId:int}/add-configuration",templateUrl:"build-groups/views/build-groups.add.configuration.html",data:{displayName:"Add Build Config",requireAuth:!0},controller:"ConfigurationSetAddConfigurationController",controllerAs:"addConfigurationSetCtrl",resolve:{configurationSetDetail:["BuildConfigurationSetDAO","$stateParams",function(e,t){return e.get({configurationSetId:t.configurationSetId}).$promise}],projects:["ProjectDAO",function(e){return e.query()}]}})}])}(),function(){"use strict";angular.module("pnc.build-records",["ui.router","angular-websocket","pnc.common.events","pnc.common.directives","pnc.common.restclient"]).config(["$stateProvider","$urlRouterProvider",function(e,t){t.when(/^\/record\/?.*/,["$location",function(e){return e.url().replace("/record","/build-records")}]),e.state("build-records",{abstract:!0,url:"/build-records",views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}},data:{proxy:"build-records.list"}}),e.state("build-records.detail",{abstract:!0,url:"/{recordId:int}",resolve:{recordDetail:["BuildRecord","$stateParams",function(e,t){return e.get({id:t.recordId}).$promise}]}}),e.state("build-records.detail.default",{url:"",onEnter:["$state","$timeout","recordDetail",function(e,t,r){t(function(){e.go("projects.detail.build-configs.detail.build-records.detail.default",{projectId:r.projectId,configurationId:r.buildConfigurationId,recordId:r.id})})}]}),e.state("build-records.list",{url:"",templateUrl:"build-records/views/build-records.list.html",data:{displayName:"Builds"},controller:"RecordListController",controllerAs:"ctrl"}),e.state("projects.detail.build-configs.detail.build-records",{abstract:!0,url:"/build-records",views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}}}),e.state("projects.detail.build-configs.detail.build-records.detail",{abstract:!0,url:"/{recordId:int}",templateUrl:"build-records/views/build-records.detail.html",data:{proxy:"projects.detail.build-configs.detail.build-records.detail.default"},controller:"RecordDetailController",controllerAs:"recordCtrl",resolve:{recordDetail:["BuildRecord","$stateParams",function(e,t){return e.get({id:t.recordId}).$promise}],buildRecordPushResult:["BuildRecord","$stateParams",function(e,t){return e.getLatestPushStatus(t.recordId)}]}}),e.state("projects.detail.build-configs.detail.build-records.detail.default",{url:"",templateUrl:"build-records/views/build-records.detail.default.html",data:{displayName:"Job #{{ recordDetail.id }}"}}),e.state("projects.detail.build-configs.detail.build-records.detail.result",{url:"/result",controller:"RecordResultController",controllerAs:"resultCtrl",templateUrl:"build-records/views/build-records.detail.result.html",data:{displayName:"Log"},resolve:{buildLog:["BuildRecord","recordDetail",function(e,t){return e.getLog({id:t.id}).$promise}],sshCredentials:["BuildRecord","recordDetail",function(e,t){return e.getSshCredentials({recordId:t.id})}]}}),e.state("projects.detail.build-configs.detail.build-records.detail.artifacts",{url:"/artifacts",controller:"RecordArtifactsController",controllerAs:"artifactsCtrl",templateUrl:"build-records/views/build-records.detail.artifacts.html",data:{displayName:"Built Artifacts"},resolve:{artifacts:["recordDetail",function(e){return e.$getBuiltArtifacts({pageSize:10})}]}}),e.state("projects.detail.build-configs.detail.build-records.detail.dependencies",{url:"/dependencies",controller:"RecordArtifactsController",controllerAs:"artifactsCtrl",templateUrl:"build-records/views/build-records.detail.artifacts.html",data:{displayName:"Dependencies"},resolve:{artifacts:["recordDetail",function(e){return e.$getDependencies({pageSize:10})}]}}),e.state("projects.detail.build-configs.detail.build-records.detail.repour-result",{url:"/alignment-log",controller:"RecordRepourResultController",controllerAs:"repourResultCtrl",templateUrl:"build-records/views/build-records.detail.repour-result.html",data:{displayName:"Alignment Log"},resolve:{repourLog:["BuildRecord","recordDetail",function(e,t){return e.getRepourLog({id:t.id}).$promise}]}}),e.state("projects.detail.build-configs.detail.build-records.detail.brew-push",{url:"/brew-push",component:"pncBuildRecordTabBrewPush",bindings:{buildRecord:"recordDetail"},data:{displayName:"Push Results"},resolve:{buildRecordPushResult:["BuildRecord","$stateParams",function(e,t){return e.getLatestPushStatus(t.recordId)}]}})}])}(),function(){"use strict";angular.module("pnc.common.authentication",[]).run(["$log","$window","$transitions","authService",function(e,o,t,i){t.onStart({},function(e){var t=e.to(),r=e.router.stateService;t.data.requireAuth&&!i.isAuthenticated()&&i.login(o.location.origin+"/"+r.href(t))})}])}(),function(){"use strict";angular.module("pnc.common",["pnc.common.authentication","pnc.common.components","pnc.common.da-client","pnc.common.directives","pnc.common.events","pnc.common.notifications","pnc.common.pnc-client","pnc.common.restclient","pnc.common.select-modals","pnc.common.util","pnc-ui-extras.uiBreadcrumbs"])}(),function(){"use strict";angular.module("pnc.common.components",["pnc-ui-extras.combobox"])}(),function(){"use strict";angular.module("pnc.common.da-client",[])}(),function(){"use strict";angular.module("pnc.common.directives",["ui.bootstrap"])}(),function(){"use strict";angular.module("pnc.common.events",["pnc.properties"]).run(["$state","$log","$rootScope","eventTypes","BuildRecordDAO","authService","pncNotify",function(t,r,e,o,i,n,l){var s=e.$new();function a(e){return function(){t.go("build-records.detail.default",{recordId:e})}}s.$on(o.BUILD_STARTED,function(e,t){r.debug("BUILD_STARTED_EVENT: payload=%O",JSON.stringify(t)),n.forUserId(t.userId).then(function(){"NEW"===t.buildCoordinationStatus?l.info("Build "+t.buildConfigurationName+" in new state","Build #"+t.id,a(t.id)):"WAITING_FOR_DEPENDENCIES"===t.buildCoordinationStatus?l.info("Build "+t.buildConfigurationName+" waiting for dependencies","Build #"+t.id,a(t.id)):"ENQUEUED"===t.buildCoordinationStatus?l.info("Build "+t.buildConfigurationName+" was enqueued","Build #"+t.id,a(t.id)):"BUILDING"===t.buildCoordinationStatus&&l.info("Build "+t.buildConfigurationName+" is being built","Build #"+t.id,a(t.id))})}),s.$on(o.BUILD_FINISHED,function(e,t){r.debug("BUILD_FINISHED: payload=%O",JSON.stringify(t)),n.forUserId(t.userId).then(function(){"REJECTED"===t.buildCoordinationStatus?l.warn("Build "+t.buildConfigurationName+"#"+t.id+" rejected.","Build #"+t.id,a(t.id)):"REJECTED_ALREADY_BUILT"===t.buildCoordinationStatus?l.warn("Build "+t.buildConfigurationName+"#"+t.id+" was rejected because already built.","Build #"+t.id,a(t.id)):"SYSTEM_ERROR"===t.buildCoordinationStatus?l.error("A system error prevented the Build "+t.buildConfigurationName+"#"+t.id+" from starting.","Build #"+t.id,a(t.id)):i.get({recordId:t.id}).$promise.then(function(e){"BUILD_COMPLETED"===e.status||"DONE"===e.status||"SUCCESS"===e.status?l.success("Build "+t.buildConfigurationName+"#"+t.id+" completed","Build #"+t.id,a(t.id)):"CANCELLED"===e.status?l.warn("Build "+t.buildConfigurationName+"#"+t.id+" cancelled","Build #"+t.id,a(t.id)):l.warn("Build "+t.buildConfigurationName+"#"+t.id+" failed","Build #"+t.id,a(t.id))})})})}])}(),function(){"use strict";angular.module("pnc.common.notifications",[])}(),function(){"use strict";angular.module("pnc.common.pnc-client.message-bus",["angular-websocket"]).run(["messageBus",function(e){e.registerListener("processProgressUpdateListener"),e.registerListener("buildStatusListener"),e.registerListener("bccListener"),e.registerListener("rcListener"),e.registerListener("brewPushListener")}])}(),function(){"use strict";var a,e=angular.module("pnc.common.pnc-client.pagination",["ngResource"]);e.config(["$provide","$resourceProvider",function(e,s){e.decorator("$resource",["$delegate",function(l){return function(e,t,o,r){var i,n=[];return Object.keys(s.defaults.actions).forEach(function(e){o.hasOwnProperty(e)||(o[e]=s.defaults.actions[e])}),Object.keys(o).forEach(function(e){var t,r=o[e];r.isPaged&&(n.push(e),r.interceptor&&angular.isFunction(r.interceptor.response)&&(t=r.interceptor.response),r.interceptor=r.interceptor||{},r.interceptor.response=function(e){return t&&t.apply(t,arguments),e},r.params=r.params||{},r.params.sort=r.params.sort||"sort=desc=id")}),i=l(e,t,o,r),n.forEach(function(e){var t=i[e];i[e]=function(){var e=t.apply(t,arguments),o=a({Resource:i});return o.$resolved=!1,o.$promise=e.$promise.then(function(e){for(var t=e.data.content||[],r=0;r<t.length;r++)t[r]=new i(t[r]);return o.index=e.data.pageIndex||0,o.size=e.data.pageSize||0,o.total=e.data.totalPages||1,o._config=e.config,o.data=t,o.$resolved=!0,o}),o}}),i}}])}]),e.run(["page",function(e){a=e}])}(),function(){"use strict";angular.module("pnc.common.pnc-client",["pnc.common.pnc-client.pagination","pnc.common.pnc-client.resources","pnc.common.pnc-client.rsql","pnc.common.pnc-client.message-bus"])}(),function(){"use strict";angular.module("pnc.common.pnc-client.resources",["ngResource"])}(),function(){"use strict";angular.module("pnc.common.pnc-client.rsql",[])}(),function(){"use strict";angular.module("pnc.common.restclient",["ngResource","pnc.common.util"]).factory("REST_BASE_URL",["restConfig",function(e){return e.getPncUrl()}])}(),function(){"use strict";angular.module("pnc.common.select-modals",["ui.bootstrap","pnc.common.pnc-client"])}(),function(){"use strict";angular.module("pnc.common.util",[])}(),function(){"use strict";angular.module("pnc.configuration-set-record",["ui.router","pnc.common.restclient"]).config(["$stateProvider","$urlRouterProvider",function(e,t){e.state("configuration-set-record",{abstract:!0,url:"/configuration-set-record",views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}},data:{proxy:"configuration-set-record.list"}}),e.state("configuration-set-record.list",{url:"",templateUrl:"configuration-set-record/views/record.list.html",data:{displayName:"Group Builds"},controller:"CsRecordListController",controllerAs:"ctrl"}),t.when("/configuration-set-record/:recordId","/configuration-set-record/:recordId/info"),e.state("configuration-set-record.detail",{url:"/{recordId:int}",templateUrl:"configuration-set-record/views/record.detail.html",data:{displayName:"# {{ csRecordDetail.id }} — {{ csRecordDetail.configurationSet.name }} "},controller:"CsRecordDetailController",controllerAs:"ctrl",resolve:{csRecordDetail:["BuildConfigurationSetRecordDAO","BuildConfigurationSetDAO","$stateParams",function(e,r,t){return e.get({recordId:t.recordId}).$promise.then(function(t){return r.get({configurationSetId:t.buildConfigurationSetId}).$promise.then(function(e){return t.configurationSet=e,t})})}]}}),e.state("configuration-set-record.detail.info",{url:"/info",templateUrl:"configuration-set-record/views/record.detail.info.html",data:{displayName:"Build Group Info"},controller:"CsRecordInfoController",controllerAs:"ctrl"})}])}(),angular.module("pnc.dashboard",["ui.router","pnc.common.components","patternfly.notification"]).config(["$stateProvider",function(e){e.state("dashboard",{url:"/",views:{"content@":{templateUrl:"dashboard/views/dashboard.html",controller:"DashboardController",controllerAs:"ctrl"}},data:{displayName:"Dashboard"}})}]),function(){"use strict";angular.module("pnc.milestone",["ui.router","ui.bootstrap","patternfly","pnc.product","pnc.common.restclient","pnc.common.util"]).config(["$stateProvider",function(e){e.state("product.detail.version.milestoneDetail",{url:"/milestone/{milestoneId:int}/detail",views:{"content@":{templateUrl:"milestone/views/milestone.detail.html",controller:"MilestoneDetailController",controllerAs:"milestoneDetailCtrl"}},data:{displayName:"{{ milestoneDetail.version }}"},resolve:{milestoneDetail:["ProductMilestoneDAO","$stateParams",function(e,t){return e.get({milestoneId:t.milestoneId}).$promise}],distributedArtifacts:["ProductMilestoneDAO","$stateParams",function(e,t){return e.getPagedDistributedArtifacts({milestoneId:t.milestoneId}).$promise}],performedBuilds:["ProductMilestoneDAO","$stateParams",function(e,t){return e.getPagedPerformedBuilds({milestoneId:t.milestoneId}).$promise}],latestRelease:["ProductMilestoneDAO","$stateParams","$log",function(e,t,r){return e.getLatestRelease({milestoneId:t.milestoneId}).$promise.catch(function(e){return r.error("Error loading release workflow: "+JSON.stringify(e)),{}})}]}}).state("product.detail.version.milestoneDetail.log",{url:"/log",views:{"content@":{templateUrl:"milestone/views/milestone.detail.log.html",controller:"MilestoneLogController",controllerAs:"milestoneLogCtrl"}},data:{displayName:"Workflow Log"}}).state("product.detail.version.milestoneCreate",{url:"/milestone/create",views:{"content@":{templateUrl:"milestone/views/milestone.create-update.html",controller:"MilestoneCreateUpdateController",controllerAs:"milestoneCreateUpdateCtrl"}},data:{displayName:"Create Milestone",requireAuth:!0},resolve:{milestoneDetail:function(){return null}}}).state("product.detail.version.milestoneUpdate",{url:"/milestone/{milestoneId:int}/update",views:{"content@":{templateUrl:"milestone/views/milestone.create-update.html",controller:"MilestoneCreateUpdateController",controllerAs:"milestoneCreateUpdateCtrl"}},data:{displayName:"Update Milestone",requireAuth:!0},resolve:{milestoneDetail:["ProductMilestoneDAO","$stateParams",function(e,t){return e.get({milestoneId:t.milestoneId}).$promise}]}}).state("product.detail.version.milestoneClose",{url:"/milestone/{milestoneId:int}/close",views:{"content@":{templateUrl:"milestone/views/milestone.close.html",controller:"MilestoneCloseController",controllerAs:"milestoneCloseCtrl"}},data:{displayName:"Close Milestone",requireAuth:!0},resolve:{milestoneDetail:["ProductMilestoneDAO","$stateParams",function(e,t){return e.get({milestoneId:t.milestoneId}).$promise}]}})}])}(),function(){"use strict";var e=angular.module("pnc",["ngAnimate","angular-loading-bar","ui.router","ui.bootstrap","patternfly.notification","pnc.common","pnc.dashboard","pnc.product","pnc.projects","pnc.build-configs","pnc.build-records","pnc.build-groups","pnc.milestone","pnc.release","pnc.configuration-set-record","pnc.report","pnc.properties"]);e.config(["$stateProvider","$urlRouterProvider","$locationProvider","$httpProvider","NotificationsProvider","cfpLoadingBarProvider",function(e,t,r,o,i,n){r.html5Mode(!1),t.when("","/"),t.otherwise("/error"),e.state("error",{url:"/error",params:{title:"Error",message:"The requested resource could not be found."},views:{"content@":{templateUrl:"error.html",controller:["$stateParams",function(e){this.title=e.title,this.message=e.message}],controllerAs:"errorCtrl"}}}),i.setDelay(12e3),n.includeSpinner=!1,o.interceptors.push("httpResponseInterceptor"),o.interceptors.push("unwrapPageResponseInterceptor"),o.interceptors.push("httpAuthenticationInterceptor")}]),e.config(["pncProperties","restConfigProvider","daConfigProvider",function(e,t,r){t.setPncUrl(e.pncUrl),t.setPncNotificationsUrl(e.pncNotificationsUrl),t.setDaUrl(e.daUrl),r.setDaUrl(e.daUrl)}]),e.run(["$log","authService","messageBus","restConfig","pncNotify","onBootNotifications",function(t,e,r,o,i,n){Object.keys(n).forEach(function(t){n[t].forEach(function(e){angular.isString(e)?i[t](e):angular.isObject(e)&&i[t](e.message,e.actionTitle,e.actionCallback,e.menuActions)})}),r.registerListener(["$log",function(t){return function(e){t.debug("MessageBus received: %O",e)}}]),r.connect(o.getPncNotificationsUrl()),e.isAuthenticated()&&e.getPncUser().then(function(e){t.info("Authenticated with PNC as: %O",e)})}])}(),function(){"use strict";angular.module("pnc.product",["ui.router","ui.bootstrap","pnc.common.restclient","pnc.common.authentication","pnc.common.pnc-client","pnc.common.select-modals","patternfly","patternfly.views"]).config(["$stateProvider",function(e){e.state("product",{url:"/product",abstract:!0,views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}},data:{proxy:"product.list"}}),e.state("product.list",{url:"/",templateUrl:"product/views/product.list.html",data:{displayName:"Products"},controller:"ProductListController",controllerAs:"listCtrl",resolve:{productList:["ProductDAO",function(e){return e.getAll().$promise}]}}),e.state("product.detail",{url:"/{productId:int}",templateUrl:"product/views/product.detail.html",data:{displayName:"{{ productDetail.name }}"},controller:"ProductDetailController",controllerAs:"detailCtrl",resolve:{productDetail:["ProductDAO","$stateParams",function(e,t){return e.get({productId:t.productId}).$promise}]}}),e.state("product.detail.version",{url:"/version/{versionId:int}",views:{"content@":{templateUrl:"product/views/product.version.html",controller:"ProductVersionController",controllerAs:"versionCtrl"}},data:{displayName:"{{ versionDetail.version }}"},resolve:{productDetail:["ProductDAO","$stateParams",function(e,t){return e.get({productId:t.productId}).$promise}],versionDetail:["ProductVersionDAO","$stateParams",function(e,t){return e.get({productId:t.productId,versionId:t.versionId}).$promise}]}}),e.state("product.create",{url:"/create",templateUrl:"product/views/product.create.html",data:{displayName:"Create Product",requireAuth:!0},controller:"ProductCreateController",controllerAs:"productCreateCtrl"}),e.state("product.detail.createVersion",{url:"/createversion",views:{"content@":{templateUrl:"product/views/product.version.create.html",controller:"ProductVersionCreateController",controllerAs:"productVersionCreateCtrl"}},data:{displayName:"Create Product Version",requireAuth:!0},resolve:{productDetail:["ProductDAO","$stateParams",function(e,t){return e.get({productId:t.productId}).$promise}]}})}])}(),function(){"use strict";angular.module("pnc.projects",["ui.router","pnc.common.restclient","pnc.common.directives","pnc.common.authentication"]).config(["$stateProvider","$urlRouterProvider",function(e,t){t.when(/^\/project\/.*/,["$location",function(e){return e.url().replace("/project/","/projects/")}]),e.state("projects",{abstract:!0,url:"/projects",views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}},data:{proxy:"projects.list"}}),e.state("projects.list",{url:"",templateUrl:"projects/views/projects.list.html",data:{displayName:"Projects"},controller:"ProjectListController",controllerAs:"listCtrl",resolve:{projectList:["ProjectDAO",function(e){return e.getAll().$promise}]}}),e.state("projects.detail",{url:"/{projectId:int}",templateUrl:"projects/views/projects.detail.html",data:{displayName:"{{ projectDetail.name }}"},controller:"ProjectDetailController",controllerAs:"detailCtrl",resolve:{projectDetail:["ProjectDAO","$stateParams",function(e,t){return e.get({projectId:t.projectId}).$promise}]}}),e.state("projects.detail.create-bc",{url:"/create-bc",templateUrl:"projects/views/projects.detail.create-bc.html",data:{displayName:"Create Build Config",requireAuth:!0},controller:"CreateBCController",controllerAs:"ctrl",resolve:{projectDetail:["ProjectDAO","$stateParams",function(e,t){return e.get({projectId:t.projectId}).$promise}]}}),e.state("projects.create",{url:"/create",templateUrl:"projects/views/projects.create.html",data:{displayName:"Create Project",requireAuth:!0},controller:"ProjectCreateController",controllerAs:"createCtrl"})}])}(),function(){"use strict";angular.module("pnc.release",["ui.router","ui.bootstrap","patternfly","pnc.product","pnc.common.restclient","pnc.common.util"]).config(["$stateProvider",function(e){e.state("product.detail.version.releaseCreate",{url:"/release/create",views:{"content@":{templateUrl:"release/views/release.create-update.html",controller:"ReleaseCreateUpdateController",controllerAs:"releaseCreateUpdateCtrl"}},data:{displayName:"Create Release",requireAuth:!0},resolve:{releaseDetail:function(){return null}}}).state("product.detail.version.releaseUpdate",{url:"/release/{releaseId:int}/update",views:{"content@":{templateUrl:"release/views/release.create-update.html",controller:"ReleaseCreateUpdateController",controllerAs:"releaseCreateUpdateCtrl"}},data:{displayName:"Update Release",requireAuth:!0},resolve:{releaseDetail:["ProductReleaseDAO","$stateParams",function(e,t){return e.get({releaseId:t.releaseId}).$promise}]}})}])}(),function(){"use strict";angular.module("pnc.report",["ui.router","ui.bootstrap","pnc.common.restclient","pnc.common.directives","infinite-scroll","angularUtils.directives.dirPagination"]).config(["$stateProvider",function(e){e.state("report",{abstract:!0,views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}}}),e.state("report.product-shipped",{url:"/product-shipped",templateUrl:"report/views/product.shipped.artifacts.html",data:{displayName:"Whitelisted artifacts of products"},controller:"ProductShippedReportController",controllerAs:"productShippedReportCtrl",resolve:{whitelistProducts:["ReportDAO",function(e){return e.getWhitelistProducts()}]}}),e.state("report.products-for-artifact",{url:"/products-for-artifact",templateUrl:"report/views/products.for.artifact.html",data:{displayName:"Products for whitelisted artifacts"},controller:"ProductsForArtifactReportController",controllerAs:"productsForArtifactReportCtrl"}),e.state("report.blacklisted-artifacts-in-project",{url:"/blacklisted-artifacts-in-project",templateUrl:"report/views/blacklisted.artifacts.in.project.html",data:{displayName:"Show blacklisted artifacts in a project"},controller:"BlacklistedArtifactsInProjectReportController",controllerAs:"blacklistedArtifactsInProjectReportCtrl"}),e.state("report.different-artifacts-in-products",{url:"/different-artifacts-in-products",templateUrl:"report/views/different.artifacts.in.products.html",data:{displayName:"Different artifacts between products"},controller:"DifferentArtifactsInProductsReportController",controllerAs:"diffGAVInProdReportCtrl",resolve:{whitelistProducts:["ReportDAO",function(e){return e.getWhitelistProducts()}]}}),e.state("report.built-artifacts-in-project",{url:"/built-artifacts-in-project",templateUrl:"report/views/built.artifacts.in.project.html",data:{displayName:"Show built artifacts in a project"},controller:"BuiltArtifactsInProjectReportController",controllerAs:"builtArtifactsInProjectReportCtrl"}),e.state("report.project-product-diff",{url:"/project-product-diff",templateUrl:"report/views/project.product.diff.html",data:{displayName:"Diff a project against a product"},controller:"ProjectProductDiff",controllerAs:"ctr",resolve:{productList:["ReportDAO",function(e){return e.getWhitelistProducts().then(function(e){return _(e).sortBy(function(e){return e.name+e.version}).value().reverse()})}]}})}])}(),function(){"use strict";var e=angular.module("pnc.build-configs");e.controller("ConfigurationListController",["$log","$state","configurationList",function(e,t,r){this.configurations=r}]),e.controller("ConfigurationDetailController",["$log","$state","$filter","pncNotify","ProductDAO","BuildConfigurationSetDAO","configurationDetail","environments","products","linkedProductVersions","dependencies","configurations","configurationSetList","linkedConfigurationSetList",function(r,o,e,t,i,n,l,s,a,c,d,u,p,m){var f=this;f.configuration=l,f.environment=l.environment,f.environments=s,f.configurations=u,f.configurationSetList=p,f.products=a,f.productVersions={selected:c},f.dependencies={selected:d||[]},f.environmentSelection={selected:[f.environment]},f.buildgroupconfigs={selected:_.clone(m)},f.update=function(){r.debug("Updating configuration: %O",f.configuration),f.configuration.productVersionId=function(e){if(!e||0===e.length)return null;return e[0].id}(f.productVersions.selected),f.configuration.dependencyIds=f.dependencies.selected.map(function(e){return e.id}),f.configuration.environment.id=f.environment.id;var e=_.difference(f.buildgroupconfigs.selected,m),t=_.difference(m,f.buildgroupconfigs.selected);f.configuration.$update().then(function(){_.each(e,function(e){e.buildConfigurationIds.push(f.configuration.id),n.update(e)}),_.each(t,function(e){var t=_.reject(e.buildConfigurationIds,function(e){return e===f.configuration.id});e.buildConfigurationIds=t,n.update(e)}),o.go("projects.detail.build-configs.detail",{configurationId:f.configuration.id,projectId:f.configuration.project.id},{reload:!0})})},f.clone=function(){f.configuration.$clone().then(function(e){o.go("projects.detail.build-configs.detail",{configurationId:e.id,projectId:e.project.id},{reload:!0})})},f.delete=function(){f.configuration.$delete().then(function(){o.go("projects.detail",{projectId:f.configuration.project.id},{reload:!0,inherit:!1,notify:!0})})},f.cancel=function(e){e&&o.go("projects.detail.build-configs.detail",{configurationId:f.configuration.id,projectId:f.configuration.project.id},{reload:!0})}}]),e.controller("ConfigurationSidebarController",["$log","$stateParams","configurationDetail",function(e,t,r){this.buildConfigurationId=t.configurationId,this.buildConfiguration=r,this.filterBy={buildConfigurationId:t.configurationId}}])}(),function(){"use strict";angular.module("pnc.build-configs").factory("buildTypes",[function(){return[{id:"MVN",name:"Maven"},{id:"NPM",name:"Node Package Manager (NPM)"}]}])}(),function(){"use strict";angular.module("pnc.build-configs").component("pncBuildConfigsList",{bindings:{buildConfigs:"<",displayFields:"<",actionsTemplateUrl:"@",actionsData:"<"},templateUrl:"build-configs/directives/pnc-build-configs-list/pnc-build-configs-list.html",controller:["$scope",function(e){var t=this;t.showTable=function(){return t.buildConfigs&&0<t.buildConfigs.length},t.showColumn=function(e){return t.displayFields.includes(e)},t.$onInit=function(){e.actions=t.actionsData}}]})}(),angular.module("pnc.build-configs").directive("pncBuildScriptValidator",function(){return{restrict:"A",require:"ngModel",link:function(e,t,r,o){o.$validators.invalidBuildScript=function(e){return!e||function(e){var t=e.toLowerCase();if(-1<t.indexOf("mvn")){var r=!0;return["deploy"].forEach(function(e){-1!==t.indexOf(e)||(r=!1)}),r}return!0}(e)}}}}),function(){"use strict";angular.module("pnc.build-configs").directive("pncConfigurationCreatePanel",["eventTypes","bccEventHandler",function(e,p){function t(e,t,r,o,i,n,l,s,a,c,d){function u(e){for(var t=[],r=0;r<e.length;r++)t.push(e[r].id);return t}o.productVersions={selected:[]},o.dependencies={selected:[]},o.buildgroupconfigs={selected:[]},o.projectSelection={selected:[]},o.environmentSelection={selected:[]},o.data={},o.environments=n.getAll(),o.products=s.getAll(),o.configurations=a.getAll(),o.configurationSetList=c.getAll(),o.genericParameters={},_.isUndefined(o.fixedProject)?o.projects=l.getAll():(o.projectSelection.selected[0]=JSON.parse(o.fixedProject),o.data.project=o.projectSelection.selected[0]),o.submit=function(){o.data.productVersionId=function(e){if(0<e.length)return e[0].id;return null}(o.productVersions.selected),o.data.dependencyIds=u(o.dependencies.selected),o.data.buildConfigurationSetIds=u(o.buildgroupconfigs.selected),o.data.scmExternal={url:o.data.externalScmUrl,revision:o.data.externalScmRevision},o.data.scmInternal={url:o.data.scmUrl,revision:o.data.scmRevision},o.data.genericParameters=o.genericParameters,d.startBuildConfigurationCreation(o.data).then(function(e){return t.go("projects.detail",{projectId:o.data.project.id}),i.info('Build Configuration "'+o.data.name+'" is being created. Please wait, this may take up to a few minutes. Notifications will inform you about the progress.'),p.register(e.data,o.data.name)}).catch(function(){e.error("Start build configuration creation failed.")})},o.reset=function(e){e&&(o.productVersions.selected=[],o.dependencies.selected=[],o.buildgroupconfigs.selected=[],o.environmentSelection.selected=[],o.data={},o.genericParametersControl.reset(),_.isUndefined(o.fixedProject)&&(o.projectSelection.selected=[]),e.$setPristine(),e.$setUntouched())},o.isCreateEnabled=function(e){return e.$invalid||!o.data.environment.id||!o.data.project.id},o.isProjectSelectable=function(){return _.isUndefined(o.fixedProject)}}return t.$inject=["$log","$state","$filter","$scope","pncNotify","EnvironmentDAO","ProjectDAO","ProductDAO","BuildConfigurationDAO","BuildConfigurationSetDAO","BpmDAO"],{restrict:"E",templateUrl:"build-configs/directives/pnc-configuration-create-panel/pnc-configuration-create-panel.html",scope:{fixedProject:"@"},controller:t}}])}(),function(){"use strict";angular.module("pnc.build-configs").component("pncCreateBuildConfigButton",{bindings:{project:"<"},templateUrl:"build-configs/directives/pnc-create-build-config-button/pnc-create-build-config-button.html",controller:["$log","$uibModal",function(e,t){var r=this;r.openWizardModal=function(){t.open({animation:!0,backdrop:"static",component:"pncCreateBuildConfigWizard",size:"lg",resolve:{project:function(){return r.project}}}).result.then(function(){},function(){})}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncCreateBuildConfigGeneralForm",{templateUrl:"build-configs/directives/pnc-create-build-config-general-form/pnc-create-build-config-general-form.html",require:{ngModel:"ngModel"},controller:["buildTypes",function(e){var t=this;t.buildTypes=e,t.$onInit=function(){t.ngModel.$render=function(){t.data=t.ngModel.$modelValue}},t.$doCheck=function(){t.ngModel.$viewValue!==t.data&&t.ngModel.$setViewValue(t.data)}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncCreateBuildConfigWizard",{templateUrl:"build-configs/directives/pnc-create-build-config-wizard/pnc-create-build-config-wizard.html",controller:["$log","$uibModal","$scope","$timeout","eventTypes","RepositoryConfiguration","BuildConfiguration",function(e,t,r,o,i,n,l){var s=this,a={general:{},buildParameters:{},dependencies:[],repoConfig:{}};s.generalForm={},s.repoForm={},s.nextButtonTitle="Next >",s.reviewPageShown=!1,s.createStatusMessages=[],s.wizardDone=!1,s.createError=!1,s.onStepChange=function(e){switch(e.stepId){case"review-summary":s.nextButtonTitle="Create";break;case"review-create":s.nextButtonTitle="Close";break;default:s.nextButtonTitle="Next >"}},s.onShowReviewSummary=function(){s.reviewPageShown=!0,o(function(){s.reviewPageShown=!1})},s.create=function(){var e=new l(function(e){var t=angular.copy(e.general);t.genericParameters=angular.copy(e.buildParameters),t.dependencyIds=e.dependencies.map(function(e){return e.id}),t.scmRevision=e.repoConfig.revision,t.project=s.wizardData.project,t.buildConfigurationSetIds=[],s.wizardData.productVersion&&(t.productVersionId=s.wizardData.productVersion.id);return t}(s.wizardData));s.wizardData.repoConfig.useExistingRepoConfig?(e.repositoryConfiguration={id:s.wizardData.repoConfig.repoConfig.id},e.$save().then(function(e){s.createdBuildConfigId=e.id}).catch(function(e){s.createStatusMessages.push(e.status+": "+e.statusText),s.createError=!0}).finally(function(){s.wizardDone=!0})):(r.$on(i.RC_BPM_NOTIFICATION,function(e,t){switch(t.eventType){case"RC_REPO_CREATION_SUCCESS":s.createStatusMessages.push(t.data.message);break;case"RC_REPO_CREATION_ERROR":s.createStatusMessages.push("Error creating repository."),s.createStatusMessages.push(t.data.message),s.wizardDone=!0,s.createError=!0;break;case"RC_REPO_CLONE_SUCCESS":s.createStatusMessages.push("Repository successfully cloned.");break;case"RC_REPO_CLONE_ERROR":s.createStatusMessages.push("Error cloning repository."),s.createStatusMessages.push(t.data.message),s.wizardDone=!0,s.createError=!0;break;case"RC_CREATION_SUCCESS":s.createStatusMessages.push("Build Config successfully created."),s.createdBuildConfigId=t.buildConfigurationId,s.createdRepoConfigId=t.repositoryId,s.wizardDone=!0;break;case"RC_CREATION_ERROR":s.wizardDone=!0,s.createError=!0}}),n.autoCreateRepoConfig({url:s.wizardData.repoConfig.scmUrl,preBuildSync:s.wizardData.repoConfig.preBuildSyncEnabled,buildConfiguration:e}).catch(function(){s.wizardDone=!0,s.createError=!0}))},s.closePreviousWizardModal=function(){s.modalInstance.close()},s.$onInit=function(){s.wizardData=angular.extend({},a,s.resolve.initialValues),s.wizardData.project=s.resolve.project}}],bindings:{modalInstance:"<",project:"<",resolve:"<",onClose:"&close"}})}(),angular.module("pnc.build-configs").directive("pncGenericParameters",[function(){function e(e,t,r){var o;t.genericParameter={key:{selected:[],suggestions:{data:(o=[],r.getSupportedGenericParameters().then(function(e){_.forOwn(e,function(e,t){o.push({id:t,displayBoldText:t,displayText:" - "+e,fullDisplayText:t})})}),o)}}},t.control={},t.addGenericParameter=function(){t.genericParameter.key.selectedId&&t.genericParameter.value&&(t.genericParameters[t.genericParameter.key.selectedId]=t.genericParameter.value,t.genericParameter.key.control.reset(),t.genericParameter.value="")},t.removeGenericParameter=function(e){delete t.genericParameters[e]},t.control.reset=function(){t.genericParameter.key.control.reset(),t.genericParameter.value="",t.genericParameters={}}}return e.$inject=["$log","$scope","BuildConfigurationDAO"],{restrict:"E",templateUrl:"build-configs/directives/pnc-generic-parameters/pnc-generic-parameters.html",scope:{genericParameters:"=",control:"="},controller:e}}]),function(){"use strict";angular.module("pnc.build-configs").directive("pncInternalExternalUrl",[function(){function e(e,t){var r="col-sm-";e.sidebarClass=r+e.sidebarCols,e.contentClass=r+(12-e.sidebarCols),e.exactHost=t.internalScmAuthority}return e.$inject=["$scope","pncProperties"],{restrict:"E",templateUrl:"build-configs/directives/pnc-internal-external-url/pnc-internal-external-url.html",scope:{data:"=",form:"=",sidebarCols:"@",singleScm:"@?"},controller:e}}])}(),function(){"use strict";angular.module("pnc.build-configs").component("pncReopenBuildConfigButton",{bindings:{initialValues:"<"},templateUrl:"build-configs/directives/pnc-reopen-build-config-button/pnc-reopen-build-config-button.html",controller:["$log","$uibModal",function(e,t){var r=this;r.reopenWizardModal=function(){t.open({animation:!0,backdrop:"static",component:"pncCreateBuildConfigWizard",size:"lg",resolve:{project:function(){return r.initialValues.project},initialValues:function(){return r.initialValues}}})}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncSelectBuildConfigs",{templateUrl:"build-configs/directives/pnc-select-build-configs/pnc-select-build-configs.html",bindings:{onAdd:"&",onRemove:"&",onChange:"&"},require:{ngModel:"?ngModel"},controller:["utils",function(t){var r,o=this,e=[{name:"Remove",title:"Remove this dependency",actionFn:function(e,t){o.remove(t)}}];function i(t){return o.buildConfigs.findIndex(function(e){return e.id===t.id})}o.buildConfigs=[],o.listConfig={selectItems:!1,multiSelect:!1,dblClick:!1,selectionMatchProp:"id",showSelectBox:!1},o.listActionButtons=e,o.add=function(e){if(-1<i(e))return;o.buildConfigs.push(e),o.buildConfig=void 0,o.onAdd&&o.onAdd({buildConfig:e})},o.remove=function(e){var t=i(e);if(-1===t)return;o.buildConfigs.splice(t,1),o.onRemove&&o.onRemove({buildConfig:e})},o.$onInit=function(){o.ngModel&&(o.ngModel.$render=function(){o.buildConfigs=o.ngModel.$viewValue})},o.$doCheck=function(){var e=t.hashCode(o.buildConfigs);e!==r&&o.buildConfigs.length&&(!function(){o.ngModel&&o.ngModel.$setViewValue(o.buildConfigs);o.onChange&&o.onChange({buildConfigs:o.buildConfigs})}(),r=e)}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncDisplayBuildParameters",{bindings:{params:"<",onEdit:"&",onRemove:"&"},templateUrl:"build-configs/directives/pnc-select-build-parameters/pnc-display-build-parameters.html",controller:[function(){var r=this,t={};function o(e){r.currentParams[e]=angular.copy(r.params[e])}r.$onInit=function(){r.currentParams=angular.copy(r.params)},r.$doCheck=function(){angular.isUndefined(r.currentParams)||Object.keys(r.params).forEach(function(e){r.currentParams.hasOwnProperty(e)||o(e)})},r.cancel=function(e){o(e),r.setEditOff(e)},r.update=function(e,t){r.onEdit({key:e,value:t}),r.setEditOff(e)},r.remove=function(e){r.onRemove({key:e}),delete r.currentParams[e],delete t[e]},r.setEditOn=function(e){t[e]=!0},r.setEditOff=function(e){t[e]=!1},r.toggleEdit=function(e){t[e]=!t[e]},r.isEditOn=function(e){return!!t[e]}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncEnterBuildParameters",{bindings:{onAdd:"&",onRemove:"&",knownKeys:"<"},templateUrl:"build-configs/directives/pnc-select-build-parameters/pnc-enter-build-parameters.html",controller:["$q","$filter","utils",function(r,o,i){var n=this;n.add=function(){n.onAdd({key:n.key,value:n.value}),n.clear()},n.clear=function(){n.key=void 0,n.value=void 0},n.searchKnownKeys=function(t){var e=r.when(n.knownKeys);if(i.isEmpty(t))return e;return e.then(function(e){return o("filter")(e,{name:t})})}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncSelectBuildParameters",{require:{ngModel:"?ngModel"},templateUrl:"build-configs/directives/pnc-select-build-parameters/pnc-select-build-parameters.html",controller:["$scope","$log","utils","BuildConfiguration",function(e,t,r,o){var i=this;i.knownKeys=void 0,i.params={},i.addParam=function(e,t){i.params[e]=t},i.removeParam=function(e){delete i.params[e]},i.hasParams=function(){return 0<Object.keys(i.params).length},i.$onInit=function(){i.knownKeys=o.getSupportedGenericParameters().then(function(e){return t=e,r=[],Object.keys(t).forEach(function(e){r.push({name:e,description:t[e]})}),r;var t,r}),e.$watch(function(){return r.concatStrings(i.params)},function(){i.ngModel.$setViewValue(i.params)}),i.ngModel.$render=function(){i.params=angular.isDefined(i.ngModel.$viewValue)?i.ngModel.$viewValue:{}}}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncSelectRepository",{require:{ngModel:"ngModel"},templateUrl:"build-configs/directives/pnc-select-repository/pnc-select-repository.html",controller:["$log","$q","utils","pncNotify","RepositoryConfiguration","pncProperties",function(e,t,r,o,i,n){var l,s=this,a=!1;s.userData={},s.checkForRepo=function(e){s.userData.selectedRepoConfig=void 0,s.multipleRCError=!1,a=!0,function(e){if(r.isEmpty(e))return t.when();return i.match({search:e}).$promise.then(function(e){var t=e.data;return 1===t.length?t[0]:1<t.length?void(s.multipleRCError=!0):void 0})}(e).then(function(e){e&&e.id&&(s.userData.selectedRepoConfig=e)}).finally(function(){a=!1})},s.isLoading=function(){return a},s.isRepoInternal=function(e){if(e)return e.includes(n.internalScmAuthority)},s.$onInit=function(){s.ngModel.$render=function(){s.userData=s.ngModel.$modelValue,void 0===s.userData.preBuildSyncEnabled&&(s.userData.preBuildSyncEnabled=!0),angular.isDefined(s.userData.scmUrl)&&s.checkForRepo(s.userData.scmUrl)}},s.$doCheck=function(){var e,t=(e=s.userData.selectedRepoConfig?s.userData.selectedRepoConfig.id:void 0,""+s.userData.scmUrl+s.userData.revision+s.userData.preBuildSyncEnabled+e);l===t||angular.equals({},s.userData)||(s.ngModel.$setViewValue(function(){var e={scmUrl:s.userData.scmUrl,revision:s.userData.revision,preBuildSyncEnabled:s.userData.preBuildSyncEnabled,useExistingRepoConfig:angular.isDefined(s.userData.selectedRepoConfig)};angular.isDefined(s.userData.selectedRepoConfig)&&(e.repoConfig=s.userData.selectedRepoConfig);return e}()),l=t)}}]})}(),function(){"use strict";var e=angular.module("pnc.build-groups");e.controller("ConfigurationSetListController",["$log","$state","configurationSetList",function(e,t,r){this.buildconfigurationsets=r}]),e.controller("ConfigurationSetCreateController",["$log","$state","products","BuildConfigurationSetDAO",function(e,t,r,o){var i=this;i.data=new o,i.products=r,i.productVersions={selected:[]},i.submit=function(){i.data.$save().then(function(){if(_.isEmpty(i.productVersions.selected))t.go("build-groups.list");else{var e={productId:parseInt(i.productVersions.selected[0].productId),versionId:parseInt(i.productVersions.selected[0].id)};t.go("product.detail.version",e,{reload:!0,inherit:!1,notify:!0})}})},i.reset=function(e){e&&(i.productVersions.selected=[],i.data=new o,e.$setPristine(),e.$setUntouched())}}]),e.controller("ConfigurationSetAddConfigurationController",["$log","$state","configurationSetDetail","projects","BuildConfigurationDAO","BuildConfigurationSetDAO",function(t,r,e,o,i,n){var l=this;l.configurationSetDetail=e,l.shouldFilter=!1,l.projects=o,l.configurations=[],l.selectedConfiguration={},l.getBuildConfigurations=function(e){t.debug("**Getting build configurations of Project: %0**",e),e?i.getAllForProject({projectId:e}).then(function(e){(l.configurations=e)&&(l.data.configurationId=e[0].id)}):l.configurations=[]},l.reset=function(){l.data=null,l.getBuildConfigurations(null)},l.submit=function(){angular.forEach(l.configurations,function(e){e.id!==parseInt(l.data.configurationId)||(l.selectedConfiguration=e)}),l.selectedConfiguration&&n.addConfiguration({configurationSetId:l.configurationSetDetail.id},l.selectedConfiguration).$promise.then(function(){var e={configurationSetId:l.configurationSetDetail.id};r.go("build-groups.detail.build-configs",e,{reload:!0,inherit:!1,notify:!0})})}}]),e.controller("ConfigurationSetDetailController",["$log","$state","$scope","BuildRecordDAO","ProductVersionDAO","ProductVersion","configurationSetDetail","configurations","productVersion","previousState","modalSelectService",function(e,t,r,o,i,n,l,s,a,c,d){var u=this;u.set=l,u.configurations=s,u.productVersion=a,u.update=function(){e.debug("Updating BuildConfigurationSet: %s",JSON.stringify(u.set)),u.set.$update().then(function(){t.go("build-groups.detail.build-configs",{configurationSetId:u.set.id},{reload:!0})})},u.getProductVersions=function(e){e?i.getAllForProduct({productId:e}).$promise.then(function(e){(u.productVersions=e)&&(u.data.productVersionId=e[0].id)}):u.productVersions=[]},u.delete=function(){u.set.$delete().then(function(){t.go(c.Name,c.Params).catch(function(){t.go("build-groups.list")})})},u.getFullProductVersionName=function(){return _.isEmpty(u.productVersion)?"None":u.productVersion.productName+": "+u.productVersion.version},u.linkWithProductVersion=function(){d.openForProductVersion({title:"Link "+u.set.name+" with a product version"}).result.then(function(e){u.set.productVersionId=e.id,u.set.$update().then(function(){u.productVersion=n.get({id:e.id})})})},u.unlinkFromProductVersion=function(){u.set.productVersionId=null,u.set.$update().then(function(){u.productVersion=null})}}])}(),function(){"use strict";angular.module("pnc.build-groups").component("pncBuildGroupBuildConfigs",{bindings:{page:"<",buildGroup:"<"},templateUrl:"build-groups/directives/pnc-build-group-build-configs/pnc-build-group-build-configs.html",controller:["$scope","modalEditService","BuildConfigurationSet","$q",function(e,t,r,o){var i=this;i.edit=function(){var e;e=1===i.page.getPageCount()?i.page.data:r.queryBuildConfigurations({id:i.buildGroup.id},{pageSize:i.page.getPageCount()*i.page.getPageSize()}).$promise.then(function(e){return e.data});o.when(e).then(function(e){t.editBuildGroupBuildConfigs(i.buildGroup,e).then(function(){s()})})},i.remove=a,i.displayFields=["name","project","buildStatus"],i.actionsData={remove:a};var n=!1,l=e.$watch("$ctrl.page.data",function(){i.page.data&&0<i.page.data.length&&(n=!0,i.showTable=!0,l())});function s(){i.page.reload().then(function(e){i.showTable=!!e.data.length})}function a(e){r.removeBuildConfiguration({id:i.buildGroup.id,configId:e.id}).$promise.then(function(){s()})}i.$onInit=function(){i.showTable=n||i.page&&i.page.data&&0<i.page.data.length}}]})}(),function(){"use strict";angular.module("pnc.build-groups").component("pncBuildGroupBuildHistory",{bindings:{buildGroupRecords:"<"},templateUrl:"build-groups/directives/pnc-build-group-build-history/pnc-build-group-build-history.html",controller:["paginator",function(e){this.page=e(this.buildGroupRecords)}]})}(),function(){"use strict";angular.module("pnc.build-records").directive("pncBuildDetails",[function(){return{restrict:"EA",templateUrl:function(e,t){return t.pncTemplate||"build-records/directives/pnc-build-details/pnc-build-details.html"},scope:{buildRecord:"="},controllerAs:"ctrl",controller:["$scope",function(e){var t=this;t.record=e.buildRecord,t.refresh=function(){t.record.$get()}}]}}])}(),function(){"use strict";angular.module("pnc.build-records").component("pncBuildRecordPushButton",{bindings:{buildRecord:"<?",buildGroupRecord:"<?"},templateUrl:"build-records/directives/pnc-build-record-push-button/pnc-build-record-push-button.html",controller:["$uibModal","pncNotify","BuildRecord","BuildConfigSetRecord","messageBus",function(e,o,i,n,t){var l=this,r=[];function s(){return angular.isDefined(l.buildRecord)}function a(e){e.forEach(function(e){r.push(t.subscribe({topic:"causeway-push",id:e.id}))})}function c(e){switch(e.status){case"ACCEPTED":o.info("Brew push initiated for build: "+e.name+"#"+e.id);break;case"FAILED":case"SYSTEM_ERROR":case"REJECTED":o.error("Brew push failed for build: "+e.name+"#"+e.id);break;case"CANCELED":o.info("Brew push canceled for build: "+e.name+"#"+e.id)}}l.isButtonVisible=function(){{if(s())return l.buildRecord.$isSuccess();if(angular.isDefined(l.buildGroupRecord))return n.isSuccess(l.buildGroupRecord)}},l.openTagNameModal=function(){e.open({animation:!0,backdrop:"static",component:"pncEnterBrewTagNameModal",size:"md"}).result.then(function(e){return s()?(r=e,void i.push(l.buildRecord.id,r.tagName).then(function(e){a(e.data),c(e.data[0])})):(t=e,void n.push(l.buildGroupRecord.id,t.tagName).then(function(e){var t=e.data.filter(function(e){return"ACCEPTED"===e.status}),r=e.data.filter(function(e){return"ACCEPTED"!==e.status});0<t.length&&a(t),0===r.length?o.info("Brew push initiated for group build: "+n.canonicalName(l.buildGroupRecord)):(o.warn("Some Build Records were rejected for brew push of group build: "+n.canonicalName(l.buildGroupRecord)),r.forEach(function(e){c(e)}))}));var t,r})}}]})}(),function(){"use strict";angular.module("pnc.build-records").component("pncBuildRecordTabBrewPush",{bindings:{buildRecord:"<",buildRecordPushResult:"<"},templateUrl:"build-records/directives/pnc-build-record-tab-brew-push/pnc-build-record-tab-brew-push.html",controller:[function(){}]})}(),function(){"use strict";angular.module("pnc.build-records").component("pncBuildRecordsList",{bindings:{buildRecords:"<?",buildGroupRecords:"<?",displayFields:"<?",hideHead:"<?"},templateUrl:"build-records/directives/pnc-build-records-list/pnc-build-records-list.html",controller:[function(){var t=this,e=["status","id","configurationName","startTime","endTime","username"];t.showTable=function(){return t.items&&t.items.length},t.showColumn=function(e){return t.fields.includes(e)},t.$onInit=function(){t.items=t.buildRecords?t.buildRecords:t.buildGroupRecords,t.fields=t.displayFields||e},t.$onChanges=function(e){e.buildRecords?t.items=t.buildRecords:e.buildGroupRecords&&(t.items=t.buildGroupRecords)}}]})}(),function(){"use strict";angular.module("pnc.build-records").directive("pncBuilds",[function(){function e(e,t,r,o){t.page=r.getPaged(),t.page.setUrlParameters([{name:"orFindByBuildConfigurationName",type:"SEARCH"}]),t.$on(o.BUILD_STARTED,t.page.reload),t.$on(o.BUILD_FINISHED,t.page.reload)}return e.$inject=["$log","$scope","BuildsDAO","eventTypes"],{restrict:"E",templateUrl:"build-records/directives/pnc-builds/pnc-builds.html",scope:{},controller:e}}])}(),function(){"use strict";angular.module("pnc.build-records").component("pncEnterBrewTagNameModal",{bindings:{doClose:"&close",doDismiss:"&dismiss"},templateUrl:"build-records/directives/pnc-enter-brew-tag-name-modal/pnc-enter-brew-tag-name-modal.html",controller:[function(){var e=this;e.done=function(){e.doClose({$value:{tagName:e.data.name}})},e.cancel=function(){e.doDismiss()},e.$onInit=function(){e.data={},e.data.tagName=""}}]})}(),function(){"use strict";angular.module("pnc.build-records").component("pncLiveLog",{bindings:{buildRecord:"<"},template:'<pnc-log-canvas get-log-writer-fn="$ctrl.getLogWriter(writer)"></pnc-log-canvas>',controller:["$log","$scope","$websocket",function(l,e,s){var a,t,c="----------------------------------------------------------------------",r="***",d=[],u=!1,o=750;function p(e){t.writeln(e)}function m(e){p(r+" "+e+" "+r)}function f(){d.length?(u=!0,p(d.join("<br>")),d=[],1===a.readyState&&setTimeout(function(){f()},o)):u=!1}function g(e){a&&a.close(!!e)}function i(e,t,r){var o,i,n;o="PROCESS PROGRESS UPDATE: "+t+" "+e,p(c),p(o),p(c),r&&(g(!0),i=r,n=(n=e)||"service",l.debug("Attempting to connect to %s at: %s for updates",n,i),(a=s(i,{autoApply:!1})).onMessage(function(e){d.push(e.data),u||f()}),a.onOpen(function(){l.info("Connected to %s at: %s",n,a.url),m("Connected to "+n),f()}),a.onError(function(){l.error("Connection error to %s at: %s",n,a.url),m("Error connecting to "+n)}),a.onClose(function(){l.info("Disconnected from %s at: %s",n,a.url),m("Connection to "+n+" closed")}))}this.getLogWriter=function(e){t=e},this.$onInit=function(){e.$on("PROCESS_PROGRESS_UPDATE",function(e,t){i(t.taskName,t.bpmTaskStatus,t.detailedNotificationsEndpointUrl)})},this.$onDestroy=function(){g(!0)}}]})}(),function(){"use strict";angular.module("pnc.build-records").component("pncLogCanvas",{bindings:{getLogWriterFn:"&"},template:'<div class="pnc-log-canvas-parent log-console well well-sm"><div class="pnc-log-canvas-content"></div></div>',controller:["$element",function(e){var t,r,o,i=this;function n(e){t.append(e),o&&(r.scrollTop=r.scrollHeight)}function l(e){n(e+"<br>")}i.$postLink=function(){t=e.find(".pnc-log-canvas-content"),r=e.find(".pnc-log-canvas-parent")[0],o=!0,r.onscroll=function(){o=r.scrollTop+r.offsetHeight+10>=r.scrollHeight}},i.$onInit=function(){i.getLogWriterFn({writer:{write:n,writeln:l}})}}]})}(),function(){"use strict";angular.module("pnc.build-records").component("pncStaticLog",{bindings:{log:"<"},templateUrl:"build-records/directives/pnc-static-log/pnc-static-log.html",controller:[function(){var e=this,t="logWrap",r=!0;e.logWrap=function(e){var t=localStorage.getItem(e);if(null===t)return r;return JSON.parse(t)}(t),e.handleModelChange=function(){localStorage.setItem(t,e.logWrap)}}]})}(),function(){"use strict";angular.module("pnc.build-records").controller("RecordArtifactsController",["$log","artifacts","filteringPaginator","pfFilterAdaptor",function(e,t,r,o){this.artifacts=r(t);var i=o(this.artifacts);this.filterConfig={fields:[{id:"identifier",title:"Identifier",placeholder:"Filter by Identifier",filterType:"text"},{id:"filename",title:"Filename",placeholder:"Filter by Filename",filterType:"text"},{id:"repoType",title:"Repo Type",placeholder:"Filter by Repo Type",filterType:"select",filterValues:["MAVEN","GENERIC_PROXY","MAVEN_TEMPORARY"]},{id:"artifactQuality",title:"Quality",placeholder:" Filter by artifact quality",filterType:"select",filterValues:["NEW","VERIFIED","TESTED","DEPRECATED","BLACKLISTED","TEMPORARY"]},{id:"md5",title:"md5",placeholder:"Filter by md5 checksum",filterType:"text"},{id:"sha1",title:"sha1",placeholder:"Filter by sha1 checksum",filterType:"text"},{id:"sha256",title:"sha256",placeholder:"Filter by sha256 checksum",filterType:"text"}],resultsCount:i.resultsCount(),appliedFilters:[],onFilterChange:i.onFilterChange}}])}(),function(){"use strict";angular.module("pnc.build-records").controller("RecordDetailController",["$scope","$state","$log","$uibModal","eventTypes","BuildRecord","recordDetail","buildRecordPushResult","messageBus","utils",function(r,e,t,o,i,n,l,s,a,c){this.record=l,this.buildRecordPushResult=s,this.hasPushResults=function(){return!c.isEmpty(s)},r.$on(i.BUILD_FINISHED,function(e,t){l.id===t.id&&l.$get()}),r.$on(i.BREW_PUSH_RESULT,function(e,t){t.BuildRecordId===l.id&&n.getLatestPushStatus(l.id).then(function(e){r.$applyAsync(function(){this.buildRecordPushResult=e})})});var d=a.subscribe({topic:"component-build",id:l.id});r.$on("$destroy",d)}])}(),function(){"use strict";angular.module("pnc.build-records").controller("RecordListController",["$log",function(e){e.debug("RecordListCtrl")}])}(),function(){"use strict";angular.module("pnc.build-records").controller("RecordRepourResultController",["repourLog","REST_BASE_URL","BUILD_RECORD_ENDPOINT","recordDetail",function(e,t,r,o){this.logUrl=t+r.replace(":recordId",o.id)+"/repour-log",this.logFileName=o.id+"_"+o.buildConfigurationName+"_"+o.status+"_repour-log.txt",this.log=e.payload}])}(),function(){"use strict";angular.module("pnc.build-records").controller("RecordResultController",["buildLog","REST_BASE_URL","BUILD_RECORD_ENDPOINT","recordDetail","sshCredentials",function(e,t,r,o,i){this.logUrl=t+r.replace(":recordId",o.id)+"/log",this.logFileName=o.id+"_"+o.buildConfigurationName+"_"+o.status+".txt",this.log=e.payload,this.sshCredentialsBtn={clicked:!1},this.sshCredentials=i}])}(),function(){"use strict";angular.module("pnc.common.authentication").factory("authService",["$log","$window","$q","keycloak","UserDAO",function(r,o,i,n,l){var s={isAuthenticated:function(){return n.authenticated},getPrinciple:function(){return n.authenticated?n.idTokenParsed.preferred_username:null},getPncUser:function(){var e=i.defer();if(n.authenticated)return l._getAuthenticatedUser().$promise;var t="There is no authenticated user, keycloak.authenticated: "+n.authenticated;return r.info(t),e.reject(t),e.promise},forUserId:function(t){var e=s.getPncUser(),r=i.defer();return e.then(function(e){e.id===t?r.resolve():r.reject("userId: "+e.id+" didn't match: "+t)},function(e){r.reject(e)}),r.promise},logout:function(e){var t=e||o.location.href;r.info("Logout requested with post-logout redirect to: "+t),n.logout(t)},login:function(e){var t=e||o.location.href;r.info("Login requested with post-login redirect to: "+t),n.login(t)}};return s}])}(),function(){"use strict";angular.module("pnc.common.authentication").directive("pncRequiresAuth",["authService",function(o){return{restrict:"A",link:function(e,t,r){o.isAuthenticated()||r.$set("disabled","disabled")}}}])}(),function(){"use strict";angular.module("pnc.common.authentication").factory("httpAuthenticationInterceptor",["$q","$log","keycloak",function(r,o,i){var e={};function n(e,t){e.headers=e.headers||{},e.headers.Authorization="Bearer "+t}return e.request=function(e){if(i&&i.token){if(i.isTokenExpired(82800)){var t=r.defer();return i.updateToken(0).success(function(){n(e,i.token),t.resolve(e)}).error(function(){o.warn("Failed to refresh authentication token"),i.clearToken(),t.resolve(e)}),t.promise}return n(e,i.token),e}return e},e}])}(),function(){"use strict";angular.module("pnc.common.authentication").provider("keycloak",function(){var t,e={setKeycloak:function(e){t=e}};return e.$get=["$log",function(e){return e.debug("keycloak=%O",t),t}],e})}(),function(){"use strict";angular.module("pnc.common.components").component("pncBuildConfigCombobox",{bindings:{modelProperty:"@modelValue"},require:{ngModel:"?ngModel"},templateUrl:"common/components/pnc-build-config-combobox/pnc-build-config-combobox.html",controller:["$log","$scope","$element","BuildConfiguration","utils","rsqlQuery","$timeout",function(e,t,r,o,i,n,l){var s,a=this;a.search=function(e){if(i.isEmpty(e))return s;return t=e,r=n().where("name").like("*"+t+"*").end(),o.query({q:r}).$promise.then(function(e){return e.data});var t,r},a.$onInit=function(){t.$watch(function(){return a.input},function(){a.ngModel.$setViewValue(a.input)}),a.ngModel.$parsers.push(function(e){return angular.isObject(e)&&angular.isDefined(a.modelProperty)?e[a.modelProperty]:e}),a.ngModel.$render=function(){!a.ngModel.$isEmpty(a.ngModel.$viewValue)&&angular.isDefined(a.modelProperty)&&e.warn("pnc-build-config-combobox: programatic changing of the ng-model value is not fully supported when model-value parameter is used. The display value of the combobox will not be correctly mapped"),a.input=a.ngModel.$viewValue},s=o.query({pageSize:20}).$promise.then(function(e){return e.data})},a.$postLink=function(){l(function(){r.find("input").on("blur",function(){a.ngModel.$setTouched()})})},a.$onDestroy=function(){r.find("input").off("blur")}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncBuildStart",{bindings:{buildConfig:"<?",buildGroup:"<?",size:"@?"},templateUrl:"common/components/pnc-build-start/pnc-build-start.html",controller:["$log","BuildConfigurationDAO","BuildConfigurationSetDAO",function(e,t,r){var o=this;o.dropdownMenu=!1,o.params={temporaryBuild:!1,forceRebuild:!1,timestampAlignment:!1},o.buildConfig&&(o.params.keepPodOnFailure=!1,o.params.buildDependencies=!0);o.refreshBuildModes=function(){o.params.temporaryBuild||(o.params.timestampAlignment=!1)},o.build=function(){o.dropdownMenu=!1,o.buildConfig?(e.debug("pncBuildStart: Initiating build of: %O",o.buildConfig),o.params.configurationId=o.buildConfig.id,t.build(o.params,{})):o.buildGroup&&(e.debug("pncBuildStart: Initiating build of: %O",o.buildGroup),o.params.configurationSetId=o.buildGroup.id,r.build(o.params,{}))}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncBuildStatusIcon",{bindings:{buildRecord:"<",noWarnings:"@"},templateUrl:"common/components/pnc-build-status-icon/pnc-build-status-icon.html",controller:[function(){var o=this;o.isCorrupted=!1,o.isTemporary=!1,o.$onChanges=function(e){var t,r;e.buildRecord&&e.buildRecord.currentValue&&(o.isCorrupted=(t=e.buildRecord.currentValue,(r=t.attributes)&&("REPO_SYSTEM_ERROR"===r.POST_BUILD_REPO_VALIDATION||"DISABLED_FIREWALL"===r.PNC_SYSTEM_ERROR)),o.isTemporary=e.buildRecord.currentValue.temporaryBuild)}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncBuildStatus",{bindings:{buildRecord:"<?",buildGroupRecord:"<?",isLoaded:"<"},templateUrl:"common/components/pnc-build-status/pnc-build-status.html",controller:[function(){var t=this;t.$onInit=function(){t.item=t.buildRecord?t.buildRecord:t.buildGroupRecord},t.$onChanges=function(e){e.buildRecord?t.item=t.buildRecord:e.buildGroupRecord&&(t.item=t.buildGroupRecord)}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncBuildsHistory",{bindings:{buildConfig:"<?",buildGroup:"<?"},templateUrl:"common/components/pnc-builds-history/pnc-builds-history.html",controller:["eventTypes","$scope","BuildRecord","BuildConfigurationSet","paginator",function(e,t,r,o,i){var n=this;function l(e,t){(n.buildGroup&&t.buildSetConfigurationId===n.buildGroup.id||n.buildConfig&&t.buildConfigurationId===n.buildConfig.id)&&n.page.refresh()}n.$onInit=function(){(n.buildGroup?o.queryBuildConfigSetRecords({id:n.buildGroup.id,pageSize:10}):r.getByConfiguration({id:n.buildConfig.id,pageSize:10})).$promise.then(function(e){n.page=i(e)}),n.buildGroup?(t.$on(e.BUILD_SET_STARTED,l),t.$on(e.BUILD_SET_FINISHED,l)):(t.$on(e.BUILD_STARTED,l),t.$on(e.BUILD_FINISHED,l))}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncCorruptedBuildRecordLabel",{bindings:{buildRecord:"<"},templateUrl:"common/components/pnc-corrupted-build-record-label/pnc-corrupted-build-record-label.html",controller:[function(){var t=this;t.isCorrupted=function(){var e=t.buildRecord.attributes;return e&&("REPO_SYSTEM_ERROR"===e.POST_BUILD_REPO_VALIDATION||"DISABLED_FIREWALL"===e.PNC_SYSTEM_ERROR)}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncEnvironmentCombobox",{bindings:{modelProperty:"@modelValue"},require:{ngModel:"?ngModel"},templateUrl:"common/components/pnc-environment-combobox/pnc-environment-combobox.html",controller:["$log","$scope","$element","Environment","utils","rsqlQuery","$timeout",function(e,t,r,o,i,n,l){var s,a,c=this;c.search=function(e){if(i.isEmpty(e))return s;return t=e,o.query({q:a+n(!0).and().where("name").like("*"+t+"*").end()}).$promise.then(function(e){return e.data});var t},c.$onInit=function(){a=n().where("deprecated").eq(!1).end(),t.$watch(function(){return c.input},function(){c.ngModel.$setViewValue(c.input)}),c.ngModel.$parsers.push(function(e){return angular.isObject(e)&&angular.isDefined(c.modelProperty)?e[c.modelProperty]:e}),c.ngModel.$render=function(){!c.ngModel.$isEmpty(c.ngModel.$viewValue)&&angular.isDefined(c.modelProperty)&&e.warn("pnc-environment-combobox: programatic changing of the ng-model value is not fully supported when model-value parameter is used. The display value of the combobox will not be correctly mapped"),c.input=c.ngModel.$viewValue},s=o.query({pageSize:20,q:a}).$promise.then(function(e){return e.data})},c.$postLink=function(){l(function(){r.find("input").on("blur",function(){c.ngModel.$setTouched()})})},c.$onDestroy=function(){r.find("input").off("blur")}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncLatestBuild",{bindings:{buildConfig:"<?",buildGroup:"<?"},templateUrl:"common/components/pnc-latest-build/pnc-latest-build.html",controller:["eventTypes","$scope","BuildRecord","BuildConfigurationSetDAO","UserDAO",function(e,t,r,o,n){var l=this;function i(e){l.latestBuild=e,l.isLoaded=!0}function s(){l.buildGroup?o.getLatestBuildConfigSetRecordsForConfigSet({configurationSetId:l.buildGroup.id}).then(function(e){i(_.isArray(e)?e[0]:null)}):r.getLastByConfiguration({id:l.buildConfig.id}).$promise.then(function(e){i(_.isArray(e.content)?e.content[0]:null)})}function a(e,t,r,o,i){l.latestBuild&&e&&t?(l.latestBuild.id=e,l.latestBuild.status=t,l.latestBuild.startTime=r,l.latestBuild.endTime=o,l.latestBuild.userId!==i&&(l.latestBuild.userId=i,n.get({userId:i}).$promise.then(function(e){l.latestBuild.username=e.username}))):s()}function c(e,t){l.buildGroup&&t.buildSetConfigurationId===l.buildGroup.id?a(t.id,t.buildStatus,t.buildSetStartTime,t.buildSetEndTime,t.userId):l.buildConfig&&t.buildConfigurationId===l.buildConfig.id&&a(t.id,t.buildCoordinationStatus,t.buildStartTime,t.buildEndTime,t.userId)}l.isLoaded=!1,l.$onInit=function(){s(),l.buildGroup?(t.$on(e.BUILD_SET_STARTED,c),t.$on(e.BUILD_SET_FINISHED,c)):(t.$on(e.BUILD_STARTED,c),t.$on(e.BUILD_FINISHED,c))}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncProductCombobox",{bindings:{modelProperty:"@modelValue"},require:{ngModel:"?ngModel"},templateUrl:"common/components/pnc-product-combobox/pnc-product-combobox.html",controller:["$log","$scope","$element","Product","utils","rsqlQuery","$timeout",function(e,t,r,o,i,n,l){var s,a=this;a.search=function(e){if(i.isEmpty(e))return s;return t=e,r=n().where("name").like("*"+t+"*").end(),o.query({q:r}).$promise.then(function(e){return e.data});var t,r},a.$onInit=function(){t.$watch(function(){return a.input},function(){a.ngModel.$setViewValue(a.input)}),a.ngModel.$parsers.push(function(e){return angular.isObject(e)&&angular.isDefined(a.modelProperty)?e[a.modelProperty]:e}),a.ngModel.$render=function(){!a.ngModel.$isEmpty(a.ngModel.$viewValue)&&angular.isDefined(a.modelProperty)&&e.warn("pnc-productg-combobox: programatic changing of the ng-model value is not fully supported when model-value parameter is used. The display value of the combobox will not be correctly mapped"),a.input=a.ngModel.$viewValue},s=o.query({pageSize:20}).$promise.then(function(e){return e.data})},a.$postLink=function(){l(function(){r.find("input").on("blur",function(){a.ngModel.$setTouched()})})},a.$onDestroy=function(){r.find("input").off("blur")}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncProductVersionCombobox",{bindings:{modelProperty:"@modelValue"},require:{ngModel:"?ngModel"},templateUrl:"common/components/pnc-product-version-combobox/pnc-product-version-combobox.html",controller:["$log","$scope","$element","ProductVersion","utils","rsqlQuery","$timeout",function(e,t,r,o,i,n,l){var s,a=this;a.search=function(e){if(i.isEmpty(e))return s;return t=e,r=n().where("product.name").like("*"+t+"*").end(),o.query({q:r}).$promise.then(function(e){return e.data});var t,r},a.generateLabel=function(e){var t="";if(!e)return t;return t=e.productName+" / v"+e.version},a.$onInit=function(){t.$watch(function(){return a.input},function(){a.ngModel.$setViewValue(a.input)}),a.ngModel.$parsers.push(function(e){return angular.isObject(e)&&angular.isDefined(a.modelProperty)?e[a.modelProperty]:e}),a.ngModel.$render=function(){!a.ngModel.$isEmpty(a.ngModel.$viewValue)&&angular.isDefined(a.modelProperty)&&e.warn("pnc-product-version-combobox: programatic changing of the ng-model value is not fully supported when model-value parameter is used. The display value of the combobox will not be correctly mapped"),a.input=a.ngModel.$viewValue},s=o.query({pageSize:20}).$promise.then(function(e){return e.data})},a.$postLink=function(){l(function(){r.find("input").on("blur",function(){a.ngModel.$setTouched()})})},a.$onDestroy=function(){r.find("input").off("blur")}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncProjectTypeahead",{bindings:{onSelect:"&",input:"=?ngModel"},require:{ngModel:"?ngModel"},templateUrl:"common/components/pnc-project-typeahead/pnc-project-typeahead.html",controller:["$scope","Project","rsqlQuery",function(e,r,o){var t=this;t.search=function(e){var t;return t=o().where("name").like(e+"%").end(),r.query({q:t}).$promise.then(function(e){return e.data})},t.select=function(e){t.onSelect()(e)},t.setDirty=function(){t.ngModel&&t.ngModel.$setDirty()},t.setTouched=function(){t.ngModel&&t.ngModel.$setTouched()},t.$onInit=function(){t.ngModel&&(t.ngModel.$validators.isValidProject=function(e,t){return!t||angular.isObject(e)&&e.id})}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncPushStatus",{bindings:{buildRecord:"<?"},templateUrl:"common/components/pnc-push-status/pnc-push-status.html",controller:["BuildRecord",function(e){var t=this;t.pushStatus={},t.loading=!0,t.$onInit=function(){e.getLatestPushStatus(t.buildRecord.id).then(function(e){t.loading=!1,t.pushStatus=e})}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncRepositoryConfigurationCombobox",{bindings:{modelProperty:"@modelValue"},require:{ngModel:"?ngModel"},templateUrl:"common/components/pnc-repository-configuration-combobox/pnc-repository-configuration-combobox.html",controller:["$log","$scope","$element","RepositoryConfiguration","utils","rsqlQuery","$timeout",function(e,t,r,o,i,n,l){var s,a=this;a.search=function(e){if(i.isEmpty(e))return s;return t=e,r=n().where("internalUrl").like("*"+t+"*").or().where("externalUrl").like("*"+t+"*").end(),o.query({q:r}).$promise.then(function(e){return e.data});var t,r},a.generateLabel=function(e){var t="";if(!e)return t;t+=e.internalUrl,e.externalUrl&&(t+="\n\t",t+="(external url: "+e.externalUrl+" )");return t},a.$onInit=function(){t.$watch(function(){return a.input},function(){a.ngModel.$setViewValue(a.input)}),a.ngModel.$parsers.push(function(e){return angular.isObject(e)&&angular.isDefined(a.modelProperty)?e[a.modelProperty]:e}),a.ngModel.$render=function(){!a.ngModel.$isEmpty(a.ngModel.$viewValue)&&angular.isDefined(a.modelProperty)&&e.warn("pnc-repository-configuration-combobox: programatic changing of the ng-model value is not fully supported when model-value parameter is used. The display value of the combobox will not be correctly mapped"),a.input=a.ngModel.$viewValue},a.ngModel.$formatters.push(function(e){if(angular.isObject(e))return e}),s=o.query({pageSize:200}).$promise.then(function(e){return e.data})},a.$postLink=function(){l(function(){r.find("input").on("blur",function(){a.ngModel.$setTouched()})})},a.$onDestroy=function(){r.find("input").off("blur")}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncTemporaryBuildRecordLabel",{bindings:{buildRecord:"<?",buildGroupRecord:"<?"},templateUrl:"common/components/pnc-temporary-build-record-label/pnc-temporary-build-record-label.html",controller:[function(){var e=this.buildRecord?this.buildRecord:this.buildGroupRecord;this.isTemporary=function(){return e.temporaryBuild}}]})}(),function(){"use strict";angular.module("pnc.common.da-client").provider("daConfig",function(){var t;this.setDaUrl=function(e){t=e},this.$get=function(){var e={getDaUrl:function(){return t}};return e}})}(),function(){"use strict";var e=angular.module("pnc.common.da-client");e.config(["jsonrpcProvider",function(e){e.interceptors.push("loadingBarInterceptor")}]),e.provider("jsonrpc",function(){this.interceptors=[],this.$get=["$injector","$log","$q","$websocket",function(l,s,a,c){var d=this;return{wsClient:function(t){var o,i={},n={};function r(e){var t,r=a.defer();return e.id=_.uniqueId("request_"),n[e.id]=r,(t=e,i.connect().then(function(){return o.send(t)})).catch(function(){r.reject({code:0,message:"Error connecting to server"})}),s.debug("Making RPC request: "+JSON.stringify(e,null,2)),d.interceptors.forEach(function(t){try{l.get(t).requestStarted(r.promise)}catch(e){throw"Invalid interceptor ("+t+")."}}),r.promise}return i.connect=function(){if(i.isConnected())return a.when();var e=a.defer();return s.debug("Attempting to connect to WebSocket at: "+t),(o=c(t,null,{reconnectIfNotNormalClose:!0})).onMessage(function(e){!function(e){if(s.debug("Received RPC response: "+JSON.stringify(e,null,2)),!n.hasOwnProperty(e.id))throw new Error("Illegal State: Received JSON-RPC response with unknown id: "+e.id);var t=n[e.id];e.hasOwnProperty("error")?t.reject(e.error):t.resolve(e.result)}(JSON.parse(e.data))}),o.onOpen(function(){s.debug("Connected to WebSocket at: "+o.socket.url),e.resolve()}),o.onError(function(){s.error("Error with WebSocket connection to: "+o.socket.url),e.reject()}),o.onClose(function(){s.debug("Disconnected from WebSocket at: "+o.socket.url)}),e.promise},i.disconnect=function(e){o.close(e)},i.isConnected=function(){return!_.isUndefined(o)&&1===o.readyState},i.invoke=function(e,t){return r({jsonrpc:"2.0",method:e,params:t})},i}}}]})}(),function(){"use strict";angular.module("pnc.common.da-client").factory("loadingBarInterceptor",["cfpLoadingBar",function(t){return{requestStarted:function(e){t.start(),e.finally(function(){t.complete()})}}}])}(),function(){"use strict";angular.module("pnc.common.directives").directive("pncConfirmClick",["$uibModal",function(i){return{restrict:"A",link:function(r,e,o){e.bind("click",function(){var e=o.pncConfirmMessage||"Are you sure?",t=o.pncConfirmSkip||"false";r.$eval(t)?r.$evalAsync(o.pncConfirmClick):i.open({templateUrl:"common/directives/pnc-confirm-click/pnc-confirm-click.html",controller:["$scope","message",function(e,t){e.message=t,e.confirm=function(){e.$close(),r.$evalAsync(o.pncConfirmClick)},e.cancel=function(){e.$dismiss(),r.$evalAsync(o.pncCancelClick)}}],resolve:{message:function(){return e}}})})}}}])}(),function(){"use strict";angular.module("pnc.common.directives").directive("pncHeader",function(){return{restrict:"E",templateUrl:"common/directives/pnc-header/pnc-header.html",transclude:!0,link:function(e,t,r,o,i){var n=angular.isDefined(r.subHeader);i(e.$new(),function(e){t.find(".header-title").append(e.filter("pnc-header-title"))}),i(e.$new(),function(e){t.find(".btn-toolbar").append(e.filter("pnc-header-buttons")),t.find("pnc-header-buttons").addClass("btn-group"),t.find("pnc-header-buttons").find("button").removeClass("btn-lg btn-sm").addClass("btn-lg")}),n&&(t.find("h1").replaceWith(function(){return"<h3>"+angular.element(this).html()+"</h3>"}),t.find("pnc-header-buttons").find("button").removeClass("btn-lg btn-sm").addClass("btn"))}}})}(),function(){"use strict";angular.module("pnc.common.directives").directive("pncInfiniteSelectItems",function(){return{restrict:"E",scope:{singleItem:"@",selectedItems:"=",displayProperty:"@",additionalDisplayItemsById:"=",items:"=",itemId:"=",placeholder:"@",infiniteSelectId:"@",infiniteSelectRequired:"@"},templateUrl:"common/directives/pnc-infinite-select-items/pnc-infinite-select-items.html",controller:["$log","$scope",function(e,r){var o=function(e,t){for(var r=0;r<t.length;r++)if(angular.equals(e.id,t[r].id))return r;return-1};r.placeholder=_.isUndefined(r.placeholder)?"Scroll & Filter":r.placeholder,r.infiniteSelectRequired=!_.isUndefined(r.infiniteSelectRequired)&&r.infiniteSelectRequired,r.singleItem=function(e){if(_.isUndefined(e)||"true"!==e)return"false";return"true"}(r.singleItem);r.displayProperty=_.isUndefined(r.displayProperty)?"name":r.displayProperty,"true"!==r.singleItem||_.isUndefined(r.selectedItems)||_.isEmpty(r.selectedItems)||(r.itemId=r.selectedItems[0].id,r.searchText=r.selectedItems[0][r.displayProperty]),r.removeItem=function(e){var t=o(e,r.selectedItems);0<=t&&(r.selectedItems.splice(t,1),"true"===r.singleItem&&(r.itemId=void 0,r.searchText=void 0))},r.shouldShowList=function(){return r.selectedItems&&0<r.selectedItems.length},r.shouldShowSelection=function(){return!("true"===r.singleItem&&r.shouldShowList())},r.loadOptions=function(){r.searchText||r.items.loadMore()},r.selectItem=function(e){"false"===r.singleItem?(r.itemId=void 0,r.searchText=void 0):(r.itemId=e.id,r.searchText=e[r.displayProperty]),r.items.search(void 0),o(e,r.selectedItems)<0&&("true"===r.singleItem&&r.selectedItems.splice(0,r.selectedItems.length),r.selectedItems.push(e))},r.viewDropdown=function(e){r.isDropdown=e},r.search=_.throttle(function(){r.items.search(r.searchText)},1e3),r.$watch("itemId",function(e){_.isUndefined(e)&&(r.searchText=void 0)})}]}})}(),function(){"use strict";angular.module("pnc.common.directives").directive("pncInfiniteSelectProductVersions",function(){return{restrict:"E",scope:{singleItem:"@",selectedItems:"=",items:"=",itemId:"=",placeholder:"@",infiniteSelectId:"@",infiniteSelectRequired:"@"},templateUrl:"common/directives/pnc-infinite-select-product-versions/pnc-infinite-select-product-versions.html",controller:["$log","$scope",function(e,r){var o=function(e,t){for(var r=0;r<t.length;r++)if(angular.equals(e.id,t[r].id))return r;return-1};r.placeholder=_.isUndefined(r.placeholder)?"Scroll & Filter":r.placeholder,r.infiniteSelectRequired=!_.isUndefined(r.infiniteSelectRequired)&&r.infiniteSelectRequired,r.singleItem=function(e){if(_.isUndefined(e)||"true"!==e)return"false";return"true"}(r.singleItem),"true"!==r.singleItem||_.isUndefined(r.selectedItems)||_.isEmpty(r.selectedItems)||(r.itemId=r.selectedItems[0].id,r.searchText=r.selectedItems[0][r.displayProperty]),r.removeItem=function(e){var t=o(e,r.selectedItems);0<=t&&(r.selectedItems.splice(t,1),"true"===r.singleItem&&(r.itemId=void 0,r.searchText=void 0))},r.shouldShowList=function(){return r.selectedItems&&0<r.selectedItems.length},r.shouldShowSelection=function(){return!("true"===r.singleItem&&r.shouldShowList())},r.loadOptions=function(){r.searchText||r.items.loadMore()},r.selectItem=function(e){"false"===r.singleItem?(r.itemId=void 0,r.searchText=void 0):(r.itemId=e.id,r.searchText=e[r.displayProperty]),r.items.search(void 0),o(e,r.selectedItems)<0&&("true"===r.singleItem&&r.selectedItems.splice(0,r.selectedItems.length),r.selectedItems.push(e))},r.viewDropdown=function(e){r.isDropdown=e},r.search=_.throttle(function(){r.items.search(r.searchText)},1e3),r.$watch("itemId",function(e){_.isUndefined(e)&&(r.searchText=void 0)})}]}})}(),function(){"use strict";angular.module("pnc.common.directives").directive("pncInfiniteSelect",function(){return{restrict:"E",scope:{items:"=",itemId:"=",searchText:"@",placeholder:"@",infiniteSelectId:"@",infiniteSelectName:"@",infiniteSelectRequired:"@"},templateUrl:"common/directives/pnc-infinite-select/pnc-infinite-select.html",controller:["$log","$scope",function(e,t){t.placeholder=_.isUndefined(t.placeholder)?"Scroll & Filter":t.placeholder,t.infiniteSelectRequired=!_.isUndefined(t.infiniteSelectRequired)&&t.infiniteSelectRequired,t.loadOptions=function(){t.searchText||t.items.loadMore()},t.selectItem=function(e){t.itemId=e.id,t.searchText=e.name},t.viewDropdown=function(e){t.isDropdown=e},t.search=_.throttle(function(){t.items.search(t.searchText)},1500),t.$watch("itemId",function(e){_.isUndefined(e)&&(t.searchText=void 0)})}]}})}(),function(){"use strict";angular.module("pnc.common.directives").directive("pncLoadingPlaceholder",function(){return{restrict:"A",scope:{columns:"@",page:"="},templateUrl:"common/directives/pnc-loading-placeholder/pnc-loading-placeholder.html",controller:["$scope",function(e){e.columnsIterable=_.range(e.columns)}]}})}(),angular.module("pnc.common.directives").directive("pncMultipleInput",function(){return{restrict:"E",scope:{selectedItems:"=",placeholder:"@",selectId:"@",selectName:"@"},templateUrl:"common/directives/pnc-multiple-input/pnc-multiple-input.html",controller:["$log","$scope",function(e,r){r.removeItem=function(e){var t=function(e,t){for(var r=0;r<t.length;r++)if(e===t[r])return r;return-1}(e,r.selectedItems);0<=t&&r.selectedItems.splice(t,1)},r.shouldShowList=function(){return r.selectedItems&&0<r.selectedItems.length},r.selectItem=function(e){e&&-1===r.selectedItems.indexOf(e)&&(r.selectedItems.push(e),r.inputItem="")}}]}}),function(){"use strict";angular.module("pnc.common.directives").directive("pncSelectItems",["$parse",function(i){var n={};return{restrict:"E",scope:{singleItem:"@",customItem:"@",selectedItems:"=",items:"=",itemId:"=",placeholder:"@",selectId:"@",selectName:"@",selectRequired:"@",control:"="},templateUrl:"common/directives/pnc-select-items/pnc-select-items.html",link:function(e,t,r){var o;o=i(r["control"]),_.isFunction(o.assign)&&(e.control=n)},controller:["$log","$scope",function(e,r){var o=function(e,t){for(var r=0;r<t.length;r++)if(angular.equals(e.id,t[r].id))return r;return-1};r.placeholder=_.isUndefined(r.placeholder)?"Scroll & Filter":r.placeholder,r.selectRequired=!_.isUndefined(r.selectRequired)&&r.selectRequired,r.singleItem=_.isUndefined(r.singleItem)||"true"!==r.singleItem?"false":"true",r.displayProperty="fullDisplayText","true"!==r.singleItem||_.isUndefined(r.selectedItems)||_.isEmpty(r.selectedItems)||(r.itemId=r.selectedItems[0].id,r.searchText=r.selectedItems[0][r.displayProperty]),r.removeItem=function(e){var t=o(e,r.selectedItems);0<=t&&(r.selectedItems.splice(t,1),"true"===r.singleItem&&(r.itemId=void 0,r.searchText=void 0))},r.shouldShowList=function(){return r.selectedItems&&0<r.selectedItems.length},r.shouldShowSelection=function(){return!("true"===r.singleItem&&r.shouldShowList())},r.selectItem=function(e){"false"===r.singleItem?(r.itemId=void 0,r.searchText=void 0):(r.itemId=e.id,r.searchText=e[r.displayProperty]),o(e,r.selectedItems)<0&&("true"===r.singleItem&&r.selectedItems.splice(0,r.selectedItems.length),r.selectedItems.push(e))},r.saveCustomItem=function(e){if(e){var t={fullDisplayText:e};r.selectedItems.push(t),r.itemId=e,r.isDropdown=!1}},r.viewDropdown=function(e){r.searchText&&!r.selectedItems.length?r.isDropdown=!0:r.isDropdown=e},r.$watch("itemId",function(e){_.isUndefined(e)&&(r.searchText=void 0)}),n.reset=function(){r.selectedItems=[],r.itemId=void 0,r.searchText=void 0}}]}}])}(),function(){"use strict";angular.module("pnc.common.directives").directive("pncScmValidator",function(){return{restrict:"A",require:"ngModel",scope:{allowedProtocols:"@pncScmValidator",exactHost:"=pncExactHost"},link:function(i,e,t,r){r.$validators.invalidScmUrl=function(e){return!e||(t=i.allowedProtocols,r=i.exactHost,o=e,t=t.replace("git@","git@[\\w\\.]+").replace("git+ssh","git\\+ssh"),r=r&&r.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&"),new RegExp("^(?:"+t+"):(?:\\/\\/)?"+(r?r+"(\\/[\\w\\.:~_-]+)+\\.git":"[\\w\\.@:\\/~_-]+")+"(?:\\/?|\\#[\\d\\w\\.\\-_]+?)$").test(o));var t,r,o}}}})}(),function(){"use strict";angular.module("pnc.common.directives").directive("pncSelect",function(){return{scope:{selectedItems:"=",query:"&",displayProperty:"@",additionalDisplayItemsById:"=",placeholder:"@"},template:'<ul class="list-group" ng-show="shouldShow()"><li class="list-group-item" ng-repeat="item in selectedItems">{{ additionalDisplayItemsById[item.id] }} {{ item[displayProperty] }}<button type="button" class="close" aria-label="Close" ng-click="removeItem(item)"><span aria-hidden="true">×</span></button></li></ul><div><input type="text" ng-model="selectedItem" placeholder="{{ placeholder }}" typeahead="item as item[displayProperty] for item in query({$viewValue: $viewValue})" typeahead-editable="false" typeahead-loading="loadingLocations" class="form-control" typeahead-on-select="onSelect($item, $model, $label)" typeahead-wait-ms="200"><span ng-show="loadingLocations" class="spinner spinner-xs spinner-inline"></span></div>',controller:["$log","$scope",function(e,r){var o=function(e,t){for(var r=0;r<t.length;r++)if(angular.equals(e,t[r]))return r;return-1};r.removeItem=function(e){var t=o(e,r.selectedItems);0<=t&&r.selectedItems.splice(t,1)},r.onSelect=function(e){o(e,r.selectedItems)<0&&r.selectedItems.push(e),r.selectedItem=null},r.shouldShow=function(){return r.selectedItems&&0<r.selectedItems.length}}]}})}(),angular.module("pnc.common.events").directive("pncListen",function(){return{restrict:"A",scope:{pncCallback:"&"},link:function(r,e,t){t.pncListen.split("|").forEach(function(e){r.$on(e.trim(),function(e,t){r.pncCallback({event:e,payload:t})})})}}}),function(){"use strict";var e=angular.module("pnc.common.events");e.constant("eventTypes",Object.freeze({USER_AUTHENTICATED:"USER_AUTHENTICATED",BUILD_STARTED:"BUILD_STARTED",BUILD_FINISHED:"BUILD_FINISHED",BUILD_SET_STARTED:"BUILD_SET_STARTED",BUILD_SET_FINISHED:"BUILD_SET_FINISHED",BCC_BPM_NOTIFICATION:"BCC_BPM_NOTIFICATION",RC_BPM_NOTIFICATION:"RC_BPM_NOTIFICATION",BREW_PUSH_RESULT:"BREW_PUSH_RESULT"})),e.factory("pncEventAdaptor",["eventTypes",function(o){return{convert:function(t){var e=[];e.push({supports:function(e){return"BUILD_STATUS_CHANGED"===e.eventType},convert:function(e){var t={payload:e.payload};switch(e.payload.buildCoordinationStatus){case"NEW":case"WAITING_FOR_DEPENDENCIES":case"ENQUEUED":case"BUILDING":t.eventType=o.BUILD_STARTED;break;case"DONE":case"REJECTED":case"REJECTED_ALREADY_BUILT":case"REJECTED_FAILED_DEPENDENCIES":case"SYSTEM_ERROR":case"DONE_WITH_ERRORS":case"CANCELLED":t.eventType=o.BUILD_FINISHED}return t}}),e.push({supports:function(t){return"BUILD_SET_STATUS_CHANGED"===t.eventType&&_(["id","buildStatus","userId","buildSetConfigurationId","buildSetConfigurationName"]).every(function(e){return _.has(t.payload,e)})},convert:function(e){var t={payload:e.payload};switch(e.payload.buildStatus){case"NEW":t.eventType=o.BUILD_SET_STARTED;break;case"DONE":case"REJECTED":t.eventType=o.BUILD_SET_FINISHED}return t}}),e.push({supports:function(e){return _.has(e,"eventType")&&e.eventType.startsWith("BCC_")},convert:function(e){return{eventType:o.BCC_BPM_NOTIFICATION,payload:e}}});var r=_(e).find(function(e){return e.supports(t)});if(_.isUndefined(r))throw"Invalid event format: "+JSON.stringify(t);return r.convert(t)}}}]),e.factory("bccEventHandler",["$log","$q","$rootScope","eventTypes","pncNotify","$state","BuildConfigurationDAO",function(c,t,e,r,d,u,p){var o={},i={};e.$on(r.BCC_BPM_NOTIFICATION,function(e,t){_.has(t,"data.taskId")&&_.has(i,t.data.taskId)?i[t.data.taskId].handle(t):c.warn("No handler for ",t)});return o.register=function(e,s){var a=t.defer();return i[e]={handle:function(e){var t,r,o=(t=e.eventType,{BCC_REPO_CREATION_SUCCESS:[0,'Created the repository for "'+(r=s)+'".'],BCC_REPO_CREATION_ERROR:[-1,'Failed to create the repository for "'+r+'".'],BCC_REPO_CLONE_SUCCESS:[0,'Cloned data into internal repository for "'+r+'".'],BCC_REPO_CLONE_ERROR:[-1,'Failed to clone data into internal repository for "'+r+'". Verify that the URL and revision are correct.'],BCC_CREATION_SUCCESS:[1,'Created "'+r+'".'],BCC_CREATION_ERROR:[-1,'Failed to create "'+r+'".']}[t]);if(!_.isUndefined(o)){var i="";if(_.has(e,"data.message")){var n=e.data.message;c.warn("",o[1]+n),i=" "+n.substring(0,125),125<n.length&&(i+="...")}if(1===o[0]){var l=parseInt(e.data.buildConfigurationId);d.success(o[1]+i,"Build Conf. #"+l,function(){p.get({configurationId:l}).$promise.then(function(e){u.go("projects.detail.build-configs.detail",{projectId:e.project.id,configurationId:l})})}),a.resolve(l)}else-1===o[0]?(d.error(o[1]+i),a.reject()):d.info(o[1]+i)}}},a.promise},o}])}(),angular.module("pnc.common.notifications").controller("pncDrawerNotificationController",["$scope","$log","pncNotify",function(e,t,r){e.groups=[{heading:"Events",open:!0,notifications:[]}],e.hideDrawer=!0,e.toggleShowDrawer=function(){e.hideDrawer=!e.hideDrawer,e.hideDrawer||(e.groups[0].notifications=r.drawerNotifications())},e.hasDrawerNotifications=function(){return 0!==r.drawerNotifications().length},e.markAllAsRead=function(e){e.notifications.forEach(function(e){e.unread=!1})},e.customScope={},e.customScope.getNotficationStatusIconClass=function(e){var t="";return e&&e.type&&("info"===e.type?t="pficon pficon-info":"danger"===e.type?t="pficon pficon-error-circle-o":"warning"===e.type?t="pficon pficon-warning-triangle-o":"success"===e.type&&(t="pficon pficon-ok")),t},e.customScope.markRead=function(e){e.unread=!1},e.customScope.clearAll=function(e){e.notifications=[],r.clearDrawerNotifications()}}]),angular.module("pnc.common.notifications").factory("pncNotify",["$log","Notifications",function(e,s){var a=[];function i(e,t,r,o,i){e(t,"",!1,void 0,r,o,i);var n=s.data.length-1,l=s.data[n];l.unread=!0,l.timeStamp=(new Date).getTime(),a.push(l)}return{info:function(e,t,r,o){i(s.info,e,t,r,o)},success:function(e,t,r,o){i(s.success,e,t,r,o)},error:function(e,t,r,o){i(s.error,e,t,r,o)},warn:function(e,t,r,o){i(s.warn,e,t,r,o)},toastNotifications:function(){return s.data},drawerNotifications:function(){return a},clearDrawerNotifications:function(){a=[]},remove:function(e){s.remove(e);var t=a.indexOf(e);-1<t&&(a[t].unread=!1)}}}]),angular.module("pnc.common.notifications").controller("pncToastNotificationController",["$scope","pncNotify",function(e,t){e.notifications=t.toastNotifications(),e.handleClose=function(e){t.remove(e)}}]),function(){"use strict";angular.module("pnc.common.pnc-client.message-bus").factory("bccListener",["$log","$rootScope","pncEventAdaptor",function(e,r,o){return function(e){if(e.eventType&&e.eventType.startsWith("BCC_")){var t=o.convert(e);r.$broadcast(t.eventType,t.payload)}}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.message-bus").factory("brewPushListener",["$rootScope","$state","pncNotify","BuildRecord",function(e,i,n,r){return function(t){"BREW_PUSH_RESULT"===t.eventType&&(e.$broadcast("BREW_PUSH_RESULT",t),t.buildRecordId&&r.get({id:t.buildRecordId}).$promise.then(function(e){!function(e,t){function r(){i.go("projects.detail.build-configs.detail.build-records.detail.brew-push",{recordId:e.id})}function o(e,t){n[e](t,"View Result",r)}switch(t){case"SUCCESS":o("success","Brew push completed for build: "+e.$canonicalName());break;case"FAILED":case"SYSTEM_ERROR":o("error","Brew push failed for build: "+e.$canonicalName());break;case"CANCELED":o("info","Brew push cancelled for build: "+e.$canonicalName())}}(e,t.status)}))}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.message-bus").factory("buildStatusListener",["$log","$rootScope","pncEventAdaptor",function(r,o,i){return function(e){if("BUILD_STATUS_CHANGED"===e.eventType||"BUILD_SET_STATUS_CHANGED"===e.eventType){var t=i.convert(e);r.debug("Following event is broadcasted: %O",t),o.$broadcast(t.eventType,t.payload)}}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.message-bus").factory("messageBus",["$websocket","$injector","$log",function(t,r,o){var i,n=Object.freeze({action:"SUBSCRIBE"}),l=Object.freeze({action:"UNSUBSCRIBE"}),s=[];function a(e){i.send({messageType:"PROCESS_UPDATES",data:angular.merge({},l,e)})}return{connect:function(e){(i=t(e,null,{reconnectIfNotNormalClose:!0})).onOpen(function(){o.info("Connected to PNC messageBus at: %s",i.url)}),i.onClose(function(){o.info("Disconnected from PNC messageBus at: %s",i.url)}),i.onError(function(){o.error("Connection error on PNC messageBus at: %s",i.url)}),i.onMessage(function(e){var t=JSON.parse(e.data);s.forEach(function(e){e(t)})})},disconnect:function(e){i.close(!!e)},subscribe:function(e){return i.send({messageType:"PROCESS_UPDATES",data:angular.merge({},n,e)}),function(){a(e)}},unsubscribe:a,registerListener:function(e){s.push(angular.isString(e)?r.get(e):r.invoke(e))}}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.message-bus").factory("processProgressUpdateListener",["$rootScope",function(t){return function(e){"PROCESS_PROGRESS_UPDATE"===e.eventType&&t.$broadcast("PROCESS_PROGRESS_UPDATE",e)}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.message-bus").factory("rcListener",["$log","$rootScope","eventTypes",function(e,t,r){return function(e){e.eventType&&e.eventType.startsWith("RC_")&&t.$broadcast(r.RC_BPM_NOTIFICATION,e)}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.pagination").directive("pncPageControls",function(){var r=[10,25,50,100,200];return{restrict:"EA",templateUrl:function(e,t){return t.pncTemplate||"common/pnc-client/pagination/directives/pnc-page-controls/pnc-page-controls.html"},scope:{page:"=pncPage"},bindToController:!0,controllerAs:"ctrl",controller:function(){var t=this;function e(){t.index=t.page.index+1,t.size=t.page.size,t.total=t.page.total}t.pageSizes=r,t.getPageIfExists=function(e){t.page.has(e-1)&&t.page.get(e-1)},t.page.onUpdate(function(){e()}),e()}}})}(),function(){"use strict";angular.module("pnc.common.pnc-client.pagination").factory("filteringPaginator",["$log","page","paginator","rsqlQuery",function(e,t,a,c){return function(e,t){var r=a(e),o=Object.create(r),i=[],n=null,l=t||[],s=null;return o.fetch=function(e){var t;return(e=e||{}).q=(t=c(),0<i.length&&i.forEach(function(e){t.where||(t=t.and()),t=t.where(e.field)[e.comparator](e.value)}),!_.isEmpty(s)&&0<l.length&&(t.where||(t=t.and()),l.forEach(function(e){t.where||(t=t.or()),t=t.where(e).like(s)})),t.end?t.end():void 0),_.isEmpty(n)||(e.sort=n),r.fetch.call(this,e)},o.addFilter=function(e){if(_.isUndefined(e))throw new Error("Undefined argument passed to method addFilter");return _.isArray()?1<arguments.length&&(e=arguments):e=[e],e.forEach(function(e){if(!e.field||!e.value)throw new Error("Invalid filter, must contain properties `field` and `value`: "+JSON.stringify(e));e.comparator||(e.comparator="like"),i.push(e)}),this},o.removeFilter=function(t){return i.splice(i.findIndex(function(e){return t.name===e.name&&t.value===e.value}),1),this},o.clearFilters=function(){return i=[],this},o.sortBy=function(e,t){return n="sort="+(t?"desc":"asc")+"="+e,this},o.clearSort=function(){return n=null,this},o.apply=function(){return this.get(0)},o.search=function(e,t){return t&&(e="%"+e+"%"),s=e,this.apply()},o.clearSearch=function(){return s=null,this.apply()},o}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.pagination").factory("page",["$log","$http",function(r,n){var o={};function l(t){t=t||{};var e=Object.create(o,{_config:{get:function(){return angular.copy(t.config)},set:function(e){t.config=angular.copy(e)}}});return e.data=t.data||[],e.index=t.index||0,e.size=t.size||0,e.total=t.total||1,e._Resource=t.Resource,e.$promise=t.promise,e}return o.forEach=function(e){this.data.forEach(function(){e.apply(this.data,arguments)},this)},o.fetch=function(e){r.debug("Fetching page: this=%O, params: %O",this,e);var o=this._Resource,t=this._config;t.params=e;var i=n(t).then(function(e){var t=l({index:e.data.pageIndex,size:e.data.pageSize,total:e.data.totalPages,data:e.data.content,Resource:o,config:e.config,$promise:i});if(o)for(var r=0;r<t.data.length;r++)t.data[r]=new o(t.data[r]);return t});return i},o.has=function(e){return 0<=e&&e<this.total},o.get=function(e){var t;if(!this.has(e))throw new RangeError("Requested page index out of bounds: "+e);return(t=this._config.params||{}).pageIndex=e,this.fetch(t)},o.hasNext=function(){return this.has(this.index+1)},o.hasPrevious=function(){return this.has(this.index-1)},o.first=function(){return this.get(0)},o.last=function(){return this.get(this.total-1)},o.next=function(){return this.get(this.index+1)},o.previous=function(){return this.get(this.index-1)},o.refresh=function(){return this.get(this.index)},o.getWithNewSize=function(e){var t=this._config.params||{};return t.pageSize=e,t.pageIndex=0,this.fetch(t)},l}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.pagination").factory("paginator",["$rootScope",function(n){return function(e){var r=e,o=[],i=Object.create(Object.getPrototypeOf(e),{data:{get:function(){return r.data}},index:{get:function(){return r.index}},size:{get:function(){return r.size}},total:{get:function(){return r.total}},_config:{get:function(){return r._config}},_Resource:{get:function(){return r._Resource}}});return i.isLoaded=!1,i.fetch=function(e){return i.isLoaded=!1,r.fetch(e).then(function(t){n.$applyAsync(function(){r=t,i.isLoaded=!0,o.forEach(function(e){e(t)})})})},i.onUpdate=function(e){if(!_.isFunction(e))throw new TypeError("onUpdate expects a function");o.push(e)},r.$promise.then(function(){i.isLoaded=!0}),i}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.pagination").factory("pfFilterAdaptor",["PF_FILTER_TYPES",function(r){return function(t){var e={onFilterChange:function(e){t.clearFilters(),e.forEach(function(e){t.addFilter({field:e.id,value:e.value,comparator:r[e.type]})}),t.apply()},resultsCount:function(){return 1===t.total?t.data.length:t.total*t.size}};return e}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.pagination").constant("PF_FILTER_TYPES",Object.freeze({text:"like",select:"eq"}))}(),function(){"use strict";var e=angular.module("pnc.common.pnc-client.resources");e.value("BUILD_CONFIG_SET_RECORD_PATH","/build-config-set-records/:id"),e.value("BUILD_CONFIG_SET_RECORD_PUSH_PATH","/build-record-push/record-set"),e.factory("BuildConfigSetRecord",["$resource","$http","restConfig","BUILD_CONFIG_SET_RECORD_PATH","BUILD_CONFIG_SET_RECORD_PUSH_PATH",function(e,r,t,o,i){var n=t.getPncUrl()+o,l=t.getPncUrl()+i;function s(e){return e.buildConfigurationSetName+"#"+e.id}function a(e){return"SUCCESS"===e.status}var c=e(n,{id:"@id"},{getBuildRecords:{url:n+"/build-records",method:"GET",isPaged:!0},getByUser:{method:"GET",isPaged:!0,url:n+"/?q=user.id==:userId"}});return c.push=function(e,t){return r.post(l,{buildConfigSetRecordId:e,tagPrefix:t})},c.prototype.$canonicalName=function(){return s(this)},c.canonicalName=s,c.prototype.$isSuccess=function(){return a(this)},c.isSuccess=a,c}])}(),function(){"use strict";var e=angular.module("pnc.common.pnc-client.resources");e.value("BUILD_CONFIGURATION_PATH","/build-configurations/:id"),e.factory("BuildConfiguration",["$resource","$http","restConfig","BUILD_CONFIGURATION_PATH",function(e,t,r,o){var i=e(r.getPncUrl()+o,{id:"@id"},{query:{method:"GET",isPaged:!0},update:{method:"PUT"}});return i.getSupportedGenericParameters=function(){return t.get(r.getPncUrl()+"/build-configurations/supported-generic-parameters").then(function(e){return e.data})},i}])}(),function(){"use strict";var e=angular.module("pnc.common.pnc-client.resources");e.value("BUILD_CONFIGURATION_SET_PATH","/build-configuration-sets/:id"),e.factory("BuildConfigurationSet",["$resource","restConfig","BUILD_CONFIGURATION_SET_PATH","rsqlQuery",function(e,t,r,o){var i=t.getPncUrl()+r,n=e(i,{id:"@id"},{query:{method:"GET",isPaged:!0},update:{method:"PUT"},queryBuildConfigurations:{url:i+"/build-configurations",method:"GET",isPaged:!0},queryBuildConfigSetRecords:{url:i+"/build-config-set-records",method:"GET",isPaged:!0},updateBuildConfigurations:{url:i+"/build-configurations",method:"PUT"},addBuildConfiguration:{url:i+"/build-configurations",method:"POST"},removeBuildConfiguration:{url:i+"/build-configurations/:configId",method:"DELETE"}});return n.prototype.queryWithNoProductVersion=function(){return n.query({q:o().where("productVersion").isNull().end()})},n}])}(),function(){"use strict";var e=angular.module("pnc.common.pnc-client.resources");e.value("BUILD_RECORD_PATH","/build-records/:id"),e.value("BUILDS_PATH","/builds"),e.value("BUILD_PATH","/builds/:id"),e.value("SSH_CREDENTIALS_PATH","/builds/ssh-credentials/:recordId"),e.value("BUILD_RECORD_PUSH_PATH","/build-record-push"),e.factory("BuildRecord",["$resource","$q","$http","restConfig","BUILD_RECORD_PATH","BUILDS_PATH","BUILD_PATH","SSH_CREDENTIALS_PATH","BUILD_RECORD_PUSH_PATH","rsqlQuery","authService",function(e,r,o,t,i,n,l,s,a,c,d){var u=t.getPncUrl()+i,p=t.getPncUrl()+n,m=t.getPncUrl()+l,f=t.getPncUrl()+s,g=t.getPncUrl()+a,h=["DONE","REJECTED","REJECTED_FAILED_DEPENDENCIES","REJECTED_ALREADY_BUILT","SYSTEM_ERROR","DONE_WITH_ERRORS","CANCELLED"],v=["NEW","ENQUEUED","WAITING_FOR_DEPENDENCIES","BUILDING"];function b(e){return h.includes(e)}function y(e){return"DONE"===e}var C=e(u,{id:"@id"},{query:{method:"GET",isPaged:!0,url:m},get:{method:"GET",url:m},getLastByConfiguration:{method:"GET",url:p+"/?q=buildConfigurationId==:id&pageIndex=0&pageSize=1&sort==desc=id"},getByConfiguration:{method:"GET",isPaged:!0,url:p+"/?q=buildConfigurationId==:id"},getByUser:{method:"GET",isPaged:!0,url:p+"/?q=user.id==:userId"},queryCompleted:{method:"GET",isPaged:!0,url:u},getCompleted:{method:"GET",url:u},getArtifacts:{isPaged:!0,method:"GET",url:u+"/artifacts"},getDependencies:{isPaged:!0,method:"GET",url:u+"/dependency-artifacts"},getBuiltArtifacts:{isPaged:!0,method:"GET",url:u+"/built-artifacts"},doGetSshCredentials:{isPaged:!1,method:"GET",url:f},getLog:{method:"GET",url:u+"/log",cache:!0,transformResponse:function(e){return{payload:e}}},getRepourLog:{method:"GET",url:u+"/repour-log",cache:!0,transformResponse:function(e){return{payload:e}}},cancel:{method:"POST",url:m+"/cancel"}});return C.queryWithUserId=function(e){return C.query({q:c().where("user.id").eq(e.userId).end()})},C.getSshCredentials=function(t){return r.when(d.isAuthenticated()).then(function(e){if(e)return C.doGetSshCredentials(t).$promise})},C.push=function(e,t){return o.post(g,{buildRecordId:e,tagPrefix:t})},C.getLatestPushStatus=function(e){return o.get(g+"/status/"+e).then(function(e){return e.data})},C.prototype.$isCompleted=function(){return b(this.status)},C.prototype.$isSuccess=function(){return y(this.status)},C.prototype.$hasFailed=function(){return b(e=this.status)&&!y(e);var e},C.prototype.$isCancelable=function(){return e=this.status,v.includes(e);var e},C.prototype.$canonicalName=function(){return(e=this).buildConfigurationName+"#"+e.id;var e},C}])}(),function(){"use strict";var e=angular.module("pnc.common.pnc-client.resources");e.value("ENVIRONMENT_PATH","/environments/:id"),e.factory("Environment",["$resource","restConfig","ENVIRONMENT_PATH",function(e,t,r){return e(t.getPncUrl()+r,{id:"@id"},{query:{method:"GET",isPaged:!0}})}])}(),function(){"use strict";var e=angular.module("pnc.common.pnc-client.resources");e.value("PRODUCT_PATH","/products/:id"),e.factory("Product",["$resource","restConfig","PRODUCT_PATH",function(e,t,r){var o=t.getPncUrl()+r;return e(o,{id:"@id"},{query:{method:"GET",isPaged:!0},update:{method:"PUT"},queryProductVersion:{url:o+"product-versions",method:"GET",isPaged:!0}})}])}(),function(){"use strict";var e=angular.module("pnc.common.pnc-client.resources");e.value("PRODUCT_VERSION_PATH","/product-versions/:id"),e.factory("ProductVersion",["$resource","restConfig","PRODUCT_VERSION_PATH",function(e,t,r){var o=t.getPncUrl()+r;return e(o,{id:"@id"},{query:{method:"GET",isPaged:!0},update:{method:"PUT"},queryBuildConfigurationSets:{url:o+"/build-configuration-sets",method:"GET",isPaged:!0},updateBuildConfigurationSets:{url:o+"/build-configuration-sets",method:"PUT"}})}])}(),function(){"use strict";var e=angular.module("pnc.common.pnc-client.resources");e.value("PROJECT_PATH","/projects/:id"),e.factory("Project",["$resource","restConfig","PROJECT_PATH",function(e,t,r){var o=t.getPncUrl()+r;return e(o,{id:"@id"},{query:{method:"GET",isPaged:!0},update:{method:"PUT"},queryBuildConfigurations:{method:"GET",url:o+"/build-configurations",isPaged:!0}})}])}(),function(){"use strict";var e=angular.module("pnc.common.pnc-client.resources");e.value("REPOSITORY_CONFIGURATION_PATH","/repository-configurations/:id"),e.factory("RepositoryConfiguration",["$resource","$http","restConfig","REPOSITORY_CONFIGURATION_PATH",function(e,r,o,t){var i=e(o.getPncUrl()+t,{id:"@id"},{query:{method:"GET",isPaged:!0},update:{method:"PUT"},search:{method:"GET",isPaged:!0,url:o.getPncUrl()+"/repository-configurations/search-by-scm-url"},match:{method:"GET",isPaged:!0,url:o.getPncUrl()+"/repository-configurations/match-by-scm-url"}});return i.autoCreateRepoConfig=function(e){var t={scmUrl:e.url,preBuildSyncEnabled:e.preBuildSync,buildConfigurationRest:e.buildConfiguration};return r.post(o.getPncUrl()+"/bpm/tasks/start-repository-configuration-creation-url-auto",t)},i}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.rsql").factory("comparator",[function(){return function(t){var e={eq:function(e){return t.addToQuery("=="+e),t.next()},neq:function(e){return t.addToQuery("!="+e),t.next()},lt:function(e){return t.addToQuery("=lt="+e),t.next()},le:function(e){return t.addToQuery("=le="+e),t.next()},gt:function(e){return t.addToQuery("=gt="+e),t.next()},ge:function(e){return t.addToQuery("=ge="+e),t.next()},like:function(e){return e=(e=e.replace(/\*/g,"%")).replace(/\?/g,"_"),t.addToQuery('=like="'+e+'"'),t.next()},isNull:function(){return t.addToQuery("=isnull=true"),t.next()},isNotNull:function(){return t.addToQuery("=isnull=false"),t.next()},in:function(e){return 0===e.length?t.abandonClause():t.addToQuery("=in=("+e.join(",")+")"),t.next()},out:function(e){return 0===e.length?t.abandonClause():t.addToQuery("=out=("+e.join(",")+")"),t.next()}};return e}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.rsql").factory("context",["selector","comparator","operator",function(i,n,l){return function(e){var t={},r=[],o={selector:function(){return this.next=this.comparator,i(t)},comparator:function(){return this.next=this.operator,n(t)},operator:function(){return this.next=this.selector,l(t)}};return o.next=e?o.operator.bind(o):o.selector.bind(o),t.addToQuery=function(e){r.push(e)},t.popFromQuery=function(){return r.pop()},t.abandonClause=function(){for(var e;e=r.pop(),angular.isDefined(e)&&","!==e&&";"!==e;);},t.next=function(){return o.next()},t.jumpTo=function(e){if(!o.hasOwnProperty(e))throw new Error("Cannot jump to non-existant node: "+e);return o[e]()},t.end=function(){return r.join("")},t}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.rsql").factory("operator",[function(){return function(e){var t={and:function(){return e.addToQuery(";"),e.next()},or:function(){return e.addToQuery(","),e.next()},end:function(){return e.end()}};return t}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.rsql").factory("rsqlQuery",["context",function(t){return function(e){return t(e).next()}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.rsql").factory("selector",[function(){return function(t){var e={where:function(e){return t.addToQuery(e),t.next()},brackets:function(e){return t.addToQuery("("+e+")"),t.jumpTo("operator")}};return e}}])}(),angular.module("pnc-ui-extras",["pnc-ui-extras.templates","pnc-ui-extras.combobox","pnc-ui-extras.uiBreadcrumbs"]),angular.module("pnc-ui-extras.templates",[]),angular.module("pnc-ui-extras.combobox",["pnc-ui-extras.templates"]);var _createClass=function(){function o(e,t){for(var r=0;r<t.length;r++){var o=t[r];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}return function(e,t,r){return t&&o(e.prototype,t),r&&o(e,r),e}}();function _classCallCheck(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}var ComboboxController=function(){function i(e,t,r,o){_classCallCheck(this,i);this.$log=e,this.$scope=t,this.$element=r,this.$timeout=o,this.options=[],this.showDropDown=!1,this.modelOptions={},this.optionTemplateUrl=this.optionTemplateUrl||"pnc-ui-extras/combobox/combobox-option.template.html"}return _createClass(i,[{key:"$onInit",value:function(){var o=this;if(this.ngModel){var i=!0===this.editable||"true"===this.editable;this.ngModel.$parsers.push(function(e){var t=o.getOptionFromViewValue(e);return angular.isDefined(t)?o.getModelValue(t):i?e:void 0}),this.ngModel.$validators.isValidOption=function(e,t){return angular.isDefined(o.getOptionFromModelValue(e))||i},this.ngModel.$render=function(){return o.inputModel=o.ngModel.$viewValue},this.ngModel.$formatters.push(function(e){var t=o.getViewValue(e);if(angular.isDefined(t))return t;var r=o.getOptionFromModelValue(e);return angular.isDefined(r)?o.getViewValue(r):i?e:void 0}),this.$scope.$watch(function(){return o.inputModel},function(){o.ngModel.$setViewValue(o.inputModel),o.loadOptions(o.inputModel)}),this.debounceMs&&(this.modelOptions.debounce=parseInt(this.debounceMs))}else this.loadOptions()}},{key:"$postLink",value:function(){var e=this;this.ngModel&&this.$timeout(function(){e.$element.find("input").on("blur",function(){e.$scope.$applyAsync(function(){return e.ngModel.$setTouched()})})})}},{key:"$onDestroy",value:function(){this.ngModel&&this.$element.find("input").off("blur")}},{key:"loadOptions",value:function(e){var t=this;return this.pxExpression.getOptions(e).then(function(e){return t.$log.debug("ComboboxController::loadOptions() scopeId = %d | options = %O",t.$scope.$id,e),t.$scope.$applyAsync(function(){return t.options=e}),e})}},{key:"getViewValue",value:function(e){return this.pxExpression.getViewValue(e)}},{key:"getModelValue",value:function(e){return this.pxExpression.getModelValue(e)}},{key:"getOptionFromViewValue",value:function(t){var r=this;if(angular.isArray(this.options))return this.options.find(function(e){return r.getViewValue(e)===t})}},{key:"getOptionFromModelValue",value:function(t){var r=this;if(angular.isArray(this.options))return this.getViewValue(t)?t:this.options.find(function(e){return r.getModelValue(e)===t})}},{key:"setShowDropDown",value:function(e){var t=this;this.$scope.$applyAsync(function(){return t.showDropDown=e}),e||(this.highlighted=void 0)}},{key:"openDropDown",value:function(){this.setShowDropDown(!0)}},{key:"closeDropDown",value:function(){this.setShowDropDown(!1)}},{key:"toggleDropDown",value:function(){this.setShowDropDown(!this.showDropDown)}},{key:"select",value:function(e){this.inputModel=this.getViewValue(e),this.closeDropDown()}},{key:"clear",value:function(){this.inputModel=void 0,this.closeDropDown()}},{key:"setHighlighted",value:function(e){this.highlighted=e}},{key:"isHighlighted",value:function(e){return this.highlighted===e}},{key:"highlightNext",value:function(){if(this.showDropDown&&this.options&&!(this.options.length<1))if(angular.isUndefined(this.highlighted))this.setHighlighted(0);else{if(this.highlighted===this.options.length-1)return;this.setHighlighted(this.highlighted+1)}}},{key:"highlightPrevious",value:function(){!this.showDropDown||!this.options||this.options.length<1||angular.isUndefined(this.highlighted)||0===this.highlighted||this.setHighlighted(this.highlighted-1)}},{key:"onKey",value:function(e){switch(e.stopPropagation(),e.preventDefault(),e.key){case"ArrowDown":this.showDropDown?this.highlightNext():this.openDropDown();break;case"ArrowUp":this.highlightPrevious();break;case"Enter":this.select(this.options[this.highlighted]);break;case"Escape":this.closeDropDown()}}}]),i}();ComboboxController.$inject=["$log","$scope","$element","$timeout"];var pxCombobox={templateUrl:"pnc-ui-extras/combobox/combobox.template.html",controller:ComboboxController,require:{pxExpression:"?pxExpression",ngModel:"?ngModel"},bindings:{placeholder:"@",editable:"<",debounceMs:"@",optionTemplateUrl:"@"}};angular.module("pnc-ui-extras.combobox").component("pxCombobox",pxCombobox);var pxExpressionParser=function(r){var o=/^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w\d]*))\s+in\s+([\s\S]+?)$/;return{parse:function(e){var t=e.match(o);if(!t)throw new Error('Expected typeahead specification in form of "_modelValue_ (as _label_)? for _item_ in _collection_" but got "'+e+'".');return{itemName:t[3],source:r(t[4]),viewMapper:r(t[2]||t[1]),modelMapper:r(t[1])}}}};pxExpressionParser.$inject=["$parse"],angular.module("pnc-ui-extras.combobox").factory("pxExpressionParser",pxExpressionParser);_createClass=function(){function o(e,t){for(var r=0;r<t.length;r++){var o=t[r];o.enumerable=o.enumerable||!1,o.configurable=!0,"value"in o&&(o.writable=!0),Object.defineProperty(e,o.key,o)}}return function(e,t,r){return t&&o(e.prototype,t),r&&o(e,r),e}}();function _classCallCheck(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}var PxExpressionController=function(){function n(e,t,r,o,i){_classCallCheck(this,n),this.$log=e,this.$q=t,this.$scope=r,this.$attrs=o,this.pxExpressionParser=i,this.parsed=i.parse(o.pxExpression),this.$log.debug("PxExpressionController::constructor() with scope id = "+r.$id),this.$log.debug("px-expression = "+o.pxExpression,r)}return n.$inject=["$log","$q","$scope","$attrs","pxExpressionParser"],_createClass(n,[{key:"getViewValue",value:function(e){var t={};return t[this.parsed.itemName]=e,this.parsed.viewMapper(this.$scope,t)}},{key:"getModelValue",value:function(e){var t={};return t[this.parsed.itemName]=e,this.parsed.modelMapper(this.$scope,t)}},{key:"getOptions",value:function(e){return this.$q.when(this.parsed.source(this.$scope,{$viewValue:e}))}}]),n}();PxExpressionController.$inject=["$log","$q","$scope","$attrs","pxExpressionParser"];var pxExpression=function(){return{restrict:"A",scope:!1,controller:PxExpressionController}};angular.module("pnc-ui-extras.combobox").directive("pxExpression",pxExpression),function(){var t,r="pnc-ui-extras.uiBreadcrumbs";try{t=angular.module(r)}catch(e){t=angular.module(r,["ui.router"])}t.directive("uiBreadcrumbs",["$interpolate","$state","$transitions",function(c,d,e){return{restrict:"E",templateUrl:function(e,t){return t.templateUrl||"pnc-ui-extras/ui-breadcrumbs/uiBreadcrumbs.tpl.html"},scope:{displaynameProperty:"@",abstractProxyProperty:"@?"},link:function(i){var o;function t(){for(var e,t,r=[],o=d.$current;o&&""!==o.name;)(e=n(o))&&(!1===(t=l(e))||a(e,r)||r.push({displayName:t,route:e.name})),o=o.parent;r.reverse(),i.breadcrumbs=r}function n(e){var t,r=e;return!0===e.abstract&&(void 0!==i.abstractProxyProperty&&(t=s(i.abstractProxyProperty,e))?(r=angular.copy(d.get(t)))&&(r.locals=e.locals):r=!1),r}function l(e){var t,r;return i.displaynameProperty?!1!==(r=s(i.displaynameProperty,e))&&(void 0===r?e.name:(t={},o.getResolveTokens().forEach(function(e){angular.isString(e)&&!e.startsWith("$")&&(t[e]=o.injector().get(e))}),c(r)(t))):e.name}function s(e,t){var r,o=e.split("."),i=t;for(r=0;r<o.length;r++){if(!angular.isDefined(i[o[r]]))return;i=i[o[r]]}return i}function a(e,t){var r,o=!1;for(r=0;r<t.length;r++)t[r].route===e.name&&(o=!0);return o}i.breadcrumbs=[],""!==d.$current.name&&t(),e.onSuccess({},function(e){o=e,t()})}}}])}(),angular.module("pnc-ui-extras.templates").run(["$templateCache",function(e){e.put("pnc-ui-extras/combobox/combobox-option.template.html",'<a ng-click="$ctrl.select(option)" href>{{ $ctrl.getViewValue(option) }}</a>\n'),e.put("pnc-ui-extras/combobox/combobox.template.html",'<style>\n.px-search-clear {\n  position: absolute;\n  z-index: 100;\n  right: 18px;\n  top: 2px;\n  height: 14px;\n  margin: auto;\n  color: inherit;\n  cursor:  pointer;\n}\n\n.px-search-clear > a:hover {\n  background-color: inherit;\n  color: inherit;\n  cursor:  pointer;\n}\n\n.px-combobox-dropdown {\n  display: block;\n}\n.px-combobox-active a,a:hover {\n  background-color: #def3ff;\n}\n.px-combobox-dropdown > .px-combobox-option a,a:hover {\n  border-width: 0px;\n}\n\n.px-combobox-dropdown > .px-combobobox-option {\n  whitespace: normal !important;\n  overflow-wrap: break-word !important;\n}\n\n</style>\n<div class="combobox-container" ng-keydown="$event.stopPropagation()">\n  <div class="input-group">\n    <input type="text" autocomplete="off" id="combobox-{{::$id}}" ng-keyup="$ctrl.onKey($event)" placeholder="{{ ::$ctrl.placeholder }}" class="combobox form-control" ng-focus="$ctrl.openDropDown()" ng-model="$ctrl.inputModel" ng-model-options="$ctrl.modelOptions" pf-focused="$ctrl.showDropDown">\n    <div class="px-search-clear"><a class="px-search-clear" ng-show="$ctrl.inputModel" ng-click="$ctrl.clear()"><span class="pficon pficon-close"></span></a></div>\n    <ul class="typeahead typeahead-long dropdown-menu px-combobox-dropdown" ng-if="$ctrl.options.length > 0 && $ctrl.showDropDown">\n      <li ng-repeat="option in $ctrl.options" ng-include="$ctrl.optionTemplateUrl" class="px-combobox-option" ng-mouseover="$ctrl.setHighlighted($index)" ng-class="{ \'px-combobox-active\': $ctrl.isHighlighted($index) }">\n      </li>\n      <li data-value="spinner" class="text-center" ng-show="$ctrl.isLoading()">\n        <span class="spinner spinner-xs spinner-inline"></span>\n      </li>\n    </ul>\n    <span class="input-group-addon dropdown-toggle" ng-class="{ \'dropup\': $ctrl.showDropDown }" data-dropdown="dropdown" role="button" ng-click="$ctrl.toggleDropDown()">\n      <span class="caret"></span>\n    </span>\n  </div>\n</div>\n'),e.put("pnc-ui-extras/ui-breadcrumbs/uiBreadcrumbs.tpl.html",'<ol class="breadcrumb">\n  <li ng-repeat="crumb in breadcrumbs"\n      ng-class="{ active: $last }"><a ui-sref="{{ crumb.route }}" ng-if="!$last">{{ crumb.displayName }}&nbsp;</a><span ng-show="$last">{{ crumb.displayName }}</span>\n  </li>\n</ol>')}]),function(){"use strict";angular.module("pnc.common.restclient").directive("pncPager",function(){return{restrict:"E",scope:{page:"=",size:"="},templateUrl:"common/restclient/pagination/directives/pager.html",link:function(i){var n=_.isUndefined(i.size)?8:i.size;n=Math.floor(n/2);var e=function(){var e=i.page.getPageIndex(),t=i.page.getPageCount(),r=Math.max(0,e-n),o=Math.min(e+n+1,t);i.range=_.range(r,o)};i.page.onUpdate(e),e()}}})}(),function(){"use strict";angular.module("pnc.common.restclient").directive("pncSearchField",function(){return{restrict:"E",scope:{page:"=",text:"@"},templateUrl:"common/restclient/pagination/directives/search-field.html",link:function(e){e.inputId=_.uniqueId("search_"),e.search=_.throttle(function(){e.page.search(e.searchText)},1500,{leading:!1})}}})}(),angular.module("pnc.common.restclient").service("PageFactory",[function(){var c=this;c.build=function(i,n,e,t){_.isUndefined(e)&&(e=0),_.isUndefined(t)&&(t=10);var l=[],s={pageIndex:0,pageSize:t,totalPages:0,content:[]},a={_rawData:s,data:[],_onUpdate:[],isLoaded:!1,_searchText:"",_refresh:function(e,t,r,o){return o=void 0!==o&&o,a.isLoaded=!1,n(e,t,r,l).then(function(e){if(c.verifyPageFormat(e)||(e=c._getEmptyPage()),0===e.totalPages)a._rawData=s,a.data=[];else{a._rawData=e;var t=c._convertToResource(e.content,i);a.data=o?a.data.concat(t):t}return a._searchText=r,a._onUpdate.forEach(function(e){e(a)}),a.isLoaded=!0,a})},getPageIndex:function(){return a._rawData.pageIndex},getPageSize:function(){return a._rawData.pageSize},getPageCount:function(){return a._rawData.totalPages},hasPageIndex:function(e){return 0<=e&&e<a.getPageCount()},loadPageIndex:function(e,t){if(t=void 0!==t&&t,a.hasPageIndex(e))return a._refresh(e,a.getPageSize(),a._searchText,t);throw"Error: Invalid page index "+e+". Must be between 0 inclusive and "+a.getPageCount()+" exclusive."},hasNext:function(){return a.hasPageIndex(a.getPageIndex()+1)},next:function(){return a.loadPageIndex(a.getPageIndex()+1)},loadMore:function(){if(a.hasNext())return a.loadPageIndex(a.getPageIndex()+1,!0)},hasPrevious:function(){return a.hasPageIndex(a.getPageIndex()-1)},previous:function(){return a.loadPageIndex(a.getPageIndex()-1)},onUpdate:function(e){a._onUpdate.push(e)},search:function(e){return a._refresh(0,t,e)},setUrlParameters:function(e){l=e},reload:function(){return a._refresh(a.getPageIndex(),a.getPageSize(),a._searchText)},last:function(){return a.loadPageIndex(a.getPageCount()-1)},first:function(){return a.loadPageIndex(0)}},r=a._refresh(e,t,"");return a.$promise=r.then(function(){return a}),a},c.decorate=function(e,t,r){var s=e[t];e[r]=function(l){return c.build(e,function(e,t,r,o){var i={pageIndex:e,pageSize:t,search:r,sort:"sort=desc=id"};o.forEach(function(e){switch(e.type){case"SEARCH":i[e.name]=r?"%"+r+"%":void 0;break;default:throw"Unknown Url Parameter Type: "+e.type}});var n=_(i).extend(l).value();return s(n).$promise})}},c.decorateNonPaged=function(o,i,e){var n=o[i];o[e]=function(e){e=e||{};var t=_(e).extend({pageIndex:0,pageSize:50}).value(),r=n(t);if(_(r).has("$promise"))return r.$promise.then(function(e){return c._maybeTryAgain(e,n,t)}).then(function(e){return c._convertToResource(e.content,o)});throw"Error. Result of call to '"+i+"' does not have $promise property. Make sure that the method belongs to the standard angular resource."}},c.verifyPageFormat=function(e){return!!_(e).has("totalPages")&&(0===e.totalPages?!(_(e).has("pageIndex")&&e.pageSize<0||_(e).has("pageSize")&&e.pageSize<1||_(e).has("content")&&(!_.isArray(e.content)||e.content.length<=0)):_(e).has("pageIndex")&&0<=e.pageIndex&&_(e).has("pageSize")&&0<e.pageSize&&_(e).has("content")&&_.isArray(e.content)&&0<e.content.length)},c._getEmptyPage=_.constant({totalPages:0}),c._maybeTryAgain=function(e,t,r){return c.verifyPageFormat(e)?1<e.totalPages?t(_(r).extend({pageIndex:0,pageSize:e.pageSize*e.totalPages}).value()).$promise:e:c._getEmptyPage()},c._convertToResource=function(e,t){return _(e).map(function(e){return _(e).has("id")?new t(e):e}).value()}}]),function(){"use strict";angular.module("pnc.common.restclient").provider("restConfig",function(){var t,r="/pnc-rest/rest",o="ws://"+window.location.host+"/pnc-rest/ws/build-records/notifications";this.setPncUrl=function(e){r=e},this.setPncNotificationsUrl=function(e){o=e},this.setDaUrl=function(e){t=e},this.$get=function(){var e={getPncUrl:function(){return r},getPncNotificationsUrl:function(){return o},getDaUrl:function(){return t}};return e}})}(),function(){var e=angular.module("pnc.common.restclient");e.value("BPM_ENDPOINT","/bpm/tasks"),e.factory("BpmDAO",["$http","REST_BASE_URL","BPM_ENDPOINT",function(t,e,r){var o=e+r,i={startBuildConfigurationCreation:function(e){return t.post(o+"/start-build-configuration-creation",{name:e.name,description:e.description,buildScript:e.buildScript,scmRepoURL:e.scmInternal.url,scmRevision:e.scmInternal.revision,scmExternalRepoURL:e.scmExternal.url,scmExternalRevision:e.scmExternal.revision,projectId:e.project.id,buildEnvironmentId:e.environment.id,dependencyIds:e.dependencyIds,buildConfigurationSetIds:e.buildConfigurationSetIds,productVersionId:e.productVersionId,genericParameters:e.genericParameters})}};return i}])}(),function(){var e=angular.module("pnc.common.restclient");e.value("BUILD_CONFIGURATION_ENDPOINT","/build-configurations/:configurationId"),e.factory("BuildConfigurationDAO",["$resource","$http","REST_BASE_URL","BUILD_CONFIGURATION_ENDPOINT","ProjectDAO","cachedGetter","PageFactory","QueryHelper",function(e,t,r,o,i,n,l,s){var a=r+o,c=e(a,{configurationId:"@id"},{_getAll:{method:"GET",url:a+s.searchOnly(["name","description","project.name"])},querySearch:{method:"GET",url:a+"/?q=name=like=%25:name%25"},update:{method:"PUT"},clone:{method:"POST",url:a+"/clone"},buildSingle:{method:"POST",url:a+"/build",successNotification:!1,params:{scope:"SINGLE"}},buildAndKeepAliveOnError:{method:"POST",url:a+"/build",successNotification:!1,params:{scope:"REBUILD",keepPodAliveOnFailure:!0}},forceBuild:{method:"POST",url:a+"/build",successNotification:!1,params:{scope:"REBUILD"}},build:{method:"POST",url:a+"/build",successNotification:!1},_getBuildRecords:{method:"GET",url:r+"/build-records?q=buildConfigurationId==:configurationId"},_getProductVersions:{method:"GET",url:a+"/product-versions"},_getDependencies:{method:"GET",url:a+"/dependencies"},_getConfigurationSets:{method:"GET",url:a+"/build-configuration-sets"},_getAllForProduct:{method:"GET",url:r+"/build-configurations/products/:productId"},_getByProductVersion:{method:"GET",url:r+"/build-configurations/products/:productId/product-versions/:versionId"+s.searchOnly(["name"])},_getByProject:{method:"GET",url:r+"/build-configurations/projects/:projectId"}});return c.getSupportedGenericParameters=function(){return t.get(r+"/build-configurations/supported-generic-parameters").then(function(e){return e.data})},l.decorateNonPaged(c,"_getAll","query"),l.decorateNonPaged(c,"_getBuildRecords","getBuildRecords"),l.decorateNonPaged(c,"_getProductVersions","getProductVersions"),l.decorateNonPaged(c,"_getDependencies","getDependencies"),l.decorateNonPaged(c,"_getConfigurationSets","getConfigurationSets"),l.decorateNonPaged(c,"_getAllForProduct","getAllForProduct"),l.decorateNonPaged(c,"_getByProductVersion","getAllForProductVersion"),l.decorateNonPaged(c,"_getByProject","getAllForProject"),l.decorate(c,"_getAll","getAll"),l.decorate(c,"_getByProductVersion","getPagedByProductVersion"),l.decorate(c,"_getByProject","getPagedByProject"),c.prototype.getProject=n(function(e){return i.get({projectId:e.projectId})}),c}])}(),function(){var e=angular.module("pnc.common.restclient");e.value("BUILD_CONFIGURATION_SET_ENDPOINT","/build-configuration-sets/:configurationSetId"),e.factory("BuildConfigurationSetDAO",["$resource","REST_BASE_URL","BUILD_CONFIGURATION_SET_ENDPOINT","PageFactory","QueryHelper",function(e,t,r,o,i){var n=t+r,l=e(n,{configurationSetId:"@id"},{_getAll:{method:"GET",url:n+i.searchOnly(["name"])},update:{method:"PUT"},_getConfigurations:{method:"GET",url:n+"/build-configurations"+i.searchOnly(["name"])},forceBuild:{method:"POST",url:n+"/build",successNotification:!1,params:{rebuildAll:!0}},build:{method:"POST",url:n+"/build",successNotification:!1},removeConfiguration:{method:"DELETE",url:n+"/build-configurations/:configurationId"},addConfiguration:{method:"POST",url:n+"/build-configurations"},_getRecords:{method:"GET",url:n+"/build-records"},_getLatestBuildConfigSetRecordsForConfigSet:{method:"GET",url:n+"/build-config-set-records?pageIndex=0&pageSize=1&sort==desc=id"}});return o.decorateNonPaged(l,"_getAll","query"),o.decorateNonPaged(l,"_getConfigurations","getConfigurations"),o.decorateNonPaged(l,"_getRecords","getRecords"),o.decorateNonPaged(l,"_getLatestBuildConfigSetRecordsForConfigSet","getLatestBuildConfigSetRecordsForConfigSet"),o.decorate(l,"_getAll","getAll"),o.decorate(l,"_getConfigurations","getPagedConfigurations"),l}])}(),function(){var e=angular.module("pnc.common.restclient");e.value("BUILD_CONFIG_SET_RECORD_ENDPOINT","/build-config-set-records/:recordId"),e.factory("BuildConfigurationSetRecordDAO",["$resource","BuildConfigurationSetDAO","UserDAO","cachedGetter","REST_BASE_URL","BUILD_CONFIG_SET_RECORD_ENDPOINT","PageFactory","QueryHelper",function(e,t,r,o,i,n,l,s){var a=i+n,c=e(a,{recordId:"@id"},{_getAll:{method:"GET",url:a+s.searchOnly(["buildConfigurationSet.name"])},_getRunning:{method:"GET",url:i+"/build-config-set-records?q="+s.search(["buildConfigurationSet.name"])+";status=='BUILDING'"},_getFinished:{method:"GET",url:i+"/build-config-set-records?q="+s.search(["buildConfigurationSet.name"])+";status!='BUILDING'"},_getByUser:{method:"GET",url:a+"/?q=user.id==:userId"}});return l.decorateNonPaged(c,"_getAll","query"),l.decorate(c,"_getAll","getPaged"),l.decorate(c,"_getRunning","getPagedRunning"),l.decorate(c,"_getFinished","getPagedFinished"),l.decorate(c,"_getByUser","getPagedByUser"),c.prototype.getConfigurationSet=o(function(e){return t.get({configurationSetId:e.buildConfigurationSetId})}),c.prototype.getUser=o(function(e){return r.get({userId:e.userId})}),c}])}(),function(){var e=angular.module("pnc.common.restclient");e.value("BUILD_RECORD_ENDPOINT","/build-records/:recordId"),e.factory("BuildRecordDAO",["$resource","cachedGetter","REST_BASE_URL","BUILD_RECORD_ENDPOINT","BuildConfigurationDAO","UserDAO","PageFactory","QueryHelper",function(e,t,r,o,i,n,l,s){var a=r+o,c=e(a,{recordId:"@id",q:"@q"},{_getAll:{method:"GET",url:a},getLog:{method:"GET",url:a+"/log",cache:!0,transformResponse:function(e){return{payload:e}}},_getArtifacts:{method:"GET",cache:!0,url:a+"/artifacts"},_getDependencyArtifacts:{method:"GET",cache:!0,url:a+"/dependency-artifacts"+s.searchOnly(["identifier","filename","checksum"])},_getBuiltArtifacts:{method:"GET",cache:!0,url:a+"/built-artifacts"+s.searchOnly(["identifier","filename","checksum"])},_getByConfiguration:{method:"GET",url:r+"/build-records/build-configurations/:configurationId"},_getByUser:{method:"GET",url:a+"/?q=user.id==:userId"},_getAllForProject:{method:"GET",url:r+"record/projects/:projectId"},_getLatestForConfiguration:{method:"GET",url:r+"/build-records/build-configurations/:configurationId?pageIndex=0&pageSize=1&sort==desc=id"},getAuditedBuildConfiguration:{method:"GET",url:a+"/build-configuration-audited"},getCompletedOrRunning:{method:"GET",url:a+"/completed-or-running"},_getByBCSetRecord:{method:"GET",url:r+"/build-records?q="+s.search(["buildConfigSetRecord.buildConfigurationSet.name"])+";buildConfigSetRecord.id==:bcSetRecordId"}});return l.decorateNonPaged(c,"_getAll","query"),l.decorateNonPaged(c,"_getArtifacts","getArtifacts"),l.decorateNonPaged(c,"_getByConfiguration","getByConfiguration"),l.decorateNonPaged(c,"_getAllForProject","getAllForProject"),l.decorateNonPaged(c,"_getLatestForConfiguration","getLatestForConfiguration"),l.decorate(c,"_getAll","getPaged"),l.decorate(c,"_getByConfiguration","getPagedByConfiguration"),l.decorate(c,"_getByBCSetRecord","getPagedByBCSetRecord"),l.decorate(c,"_getByUser","getPagedByUser"),l.decorate(c,"_getDependencyArtifacts","getPagedDependencyArtifacts"),l.decorate(c,"_getBuiltArtifacts","getPagedBuiltArtifacts"),c.prototype.getBuildConfiguration=t(function(e){return i.get({configurationId:e.buildConfigurationId})}),c.prototype.getUser=t(function(e){return n.get({userId:e.userId})}),c}])}(),function(){var e=angular.module("pnc.common.restclient");e.value("BUILD_RECORD_SET_ENDPOINT","/build-record-sets/:recordsetId"),e.factory("BuildRecordSetDAO",["$resource","REST_BASE_URL","BUILD_RECORD_SET_ENDPOINT","PageFactory",function(e,t,r,o){var i=e(t+r,{recordsetId:"@id"},{_getAll:{method:"GET"},_getAllForProductVersion:{method:"GET",url:t+"/build-record-sets/product-versions/:versionId"},_getRecords:{method:"GET",url:t+"/build-record-sets/build-records/:recordId"}});return o.decorateNonPaged(i,"_getAll","query"),o.decorateNonPaged(i,"_getAllForProductVersion","getAllForProductVersion"),o.decorateNonPaged(i,"_getRecords","getRecords"),i}])}(),function(){var e=angular.module("pnc.common.restclient");e.value("BUILDS_ENDPOINT","/builds/:id"),e.factory("BuildsDAO",["$resource","REST_BASE_URL","BUILDS_ENDPOINT","PageFactory","QueryHelper",function(e,t,r,o,i){var n=t+r,l=e(n,{},{_getAll:{method:"GET",url:n+i.searchOnly(["user.username"])},_getByConfiguration:{method:"GET",url:t+"/builds?q=buildConfigurationId==:id"},_getLastByConfiguration:{method:"GET",url:t+"/builds?q=buildConfigurationId==:id&pageIndex=0&pageSize=1&sort==desc=id"}});return o.decorate(l,"_getAll","getPaged"),o.decorate(l,"_getByConfiguration","getByConfiguration"),o.decorate(l,"_getLastByConfiguration","getLastByConfiguration"),l}])}(),angular.module("pnc.common.restclient").factory("cachedGetter",["$http",function(e){var r="_cachedGetterProperties_",o=0;return e.defaults.transformRequest.unshift(function(e){return e&&e.hasOwnProperty(r)&&delete e[r],e}),function(e){var t=o++;return function(){return this[r]||(this[r]={}),angular.isObject(this[r][t])||(this[r][t]=e(this)),this[r][t]}}}]),function(){var e=angular.module("pnc.common.restclient");e.value("ENVIRONMENT_ENDPOINT","/environments/:environmentId"),e.factory("EnvironmentDAO",["$resource","REST_BASE_URL","ENVIRONMENT_ENDPOINT","PageFactory","QueryHelper","rsqlQuery",function(e,t,r,o,i,n){var l=t+r,s=e(l,{environmentId:"@id"},{_getAll:{method:"GET",url:l+i.searchOnly(["name","description"])},_getAllNotDeprecated:{method:"GET",url:l+i.searchOnly(["name","description"],n(!0).and().where("deprecated").eq(!1).end())},update:{method:"PUT"}});return o.decorateNonPaged(s,"_getAll","query"),o.decorate(s,"_getAll","getAll"),o.decorate(s,"_getAllNotDeprecated","getAllNotDeprecated"),s}])}(),function(){var e=angular.module("pnc.common.restclient");e.value("PRODUCT_ENDPOINT","/products/:productId"),e.factory("ProductDAO",["$resource","REST_BASE_URL","PRODUCT_ENDPOINT","PageFactory","QueryHelper",function(e,t,r,o,i){var n=t+r,l=e(n,{productId:"@id"},{_getAll:{method:"GET",url:n+i.searchOnly(["name","description","abbreviation","productCode","pgmSystemName"])},update:{method:"PUT"},_getVersions:{method:"GET",url:n+"/product-versions"}});return o.decorateNonPaged(l,"_getAll","query"),o.decorateNonPaged(l,"_getVersions","getVersions"),o.decorate(l,"_getAll","getAll"),l}])}(),function(){var e=angular.module("pnc.common.restclient");e.value("MILESTONE_ENDPOINT","/product-milestones/:milestoneId"),e.factory("ProductMilestoneDAO",["$resource","REST_BASE_URL","MILESTONE_ENDPOINT","PageFactory",function(e,t,r,o){var i=t+r,n=e(i,{milestoneId:"@id"},{_getAll:{method:"GET",isArray:!1},update:{method:"PUT"},_getByProductVersion:{method:"GET",url:t+"/product-milestones/product-versions/:versionId",cache:!0},_getDistributedArtifacts:{method:"GET",url:t+"/product-milestones/:milestoneId/distributed-artifacts"},_getPerformedBuilds:{method:"GET",url:t+"/product-milestones/:milestoneId/performed-builds"},getLatestRelease:{method:"GET",url:i+"/releases/latest"},closeMilestone:{method:"PUT",url:t+"/product-milestones/:milestoneId/close-milestone"}});return o.decorateNonPaged(n,"_getAll","query"),o.decorateNonPaged(n,"_getByProductVersion","getAllForProductVersion"),o.decorate(n,"_getByProductVersion","getPagedByProductVersion"),o.decorate(n,"_getDistributedArtifacts","getPagedDistributedArtifacts"),o.decorate(n,"_getPerformedBuilds","getPagedPerformedBuilds"),n}])}(),function(){var e=angular.module("pnc.common.restclient");e.value("RELEASE_ENDPOINT","/product-releases/:releaseId"),e.factory("ProductReleaseDAO",["$resource","REST_BASE_URL","RELEASE_ENDPOINT","PageFactory",function(e,t,r,o){var i=e(t+r,{releaseId:"@id"},{_getAll:{method:"GET",isArray:!1},update:{method:"PUT"},_getByProductVersion:{method:"GET",url:t+"/product-releases/product-versions/:versionId",isArray:!1},save:{method:"POST"},_getAllSupportLevel:{method:"GET",url:t+"/product-releases/support-level"}});return o.decorateNonPaged(i,"_getAll","query"),o.decorateNonPaged(i,"_getByProductVersion","getAllForProductVersion"),o.decorateNonPaged(i,"_getAllSupportLevel","getAllSupportLevel"),o.decorate(i,"_getByProductVersion","getPagedByProductVersion"),i}])}(),function(){var e=angular.module("pnc.common.restclient");e.value("PRODUCT_VERSION_ENDPOINT","/product-versions/:versionId"),e.factory("ProductVersionDAO",["$resource","REST_BASE_URL","PRODUCT_VERSION_ENDPOINT","PageFactory","ProductDAO","ProductMilestoneDAO","cachedGetter","ProductReleaseDAO","QueryHelper",function(e,t,r,o,i,n,l,s,a){var c=t+r,d=e(c,{versionId:"@id"},{_getAll:{method:"GET"},update:{method:"PUT"},_getBCSets:{method:"GET",url:c+"/build-configuration-sets"+a.searchOnly(["name"])},_getByProduct:{method:"GET",url:t+"/products/:productId/product-versions"+a.searchOnly(["version"])}});return o.decorateNonPaged(d,"_getAll","query"),o.decorateNonPaged(d,"_getBCSets","getAllBuildConfigurationSets"),o.decorateNonPaged(d,"_getByProduct","getAllForProduct"),o.decorate(d,"_getBCSets","getPagedBCSets"),o.decorate(d,"_getByProduct","getPagedByProduct"),d.prototype.getProduct=l(function(e){return i.get({productId:e.productId})}),d.prototype.getMilestones=l(function(e){return n.getAllForProductVersion({versionId:e.id})}),d.prototype.getReleases=l(function(e){return s.getAllForProductVersion({versionId:e.id})}),d}])}(),function(){var e=angular.module("pnc.common.restclient");e.value("PROJECT_ENDPOINT","/projects/:projectId"),e.factory("ProjectDAO",["$resource","REST_BASE_URL","PROJECT_ENDPOINT","PageFactory","QueryHelper",function(e,t,r,o,i){var n=t+r,l=e(n,{projectId:"@id"},{update:{method:"PUT"},_getAllForProductVersion:{method:"GET",url:t+"/projects/products/:productId/product-versions/:versionId"},_getAll:{method:"GET",url:n+i.searchOnly(["name","description"])}});return o.decorateNonPaged(l,"_getAll","query"),o.decorateNonPaged(l,"_getAllForProductVersion","getAllForProductVersion"),o.decorate(l,"_getAll","getAll"),l}])}(),angular.module("pnc.common.restclient").factory("ReportDAO",["$http","restConfig",function(i,e){var t=e.getDaUrl(),r=t+"/listings/whitelist/products",o=t+"/listings/whitelist/artifacts/product",n=t+"/listings/whitelist/artifacts/gav",l=t+"/reports/align",s=t+"/products/diff",a=t+"/reports/built",c={getWhitelistProducts:function(){return i.get(r).then(function(e){return e.data})},getWhitelistProductArtifacts:function(e){return i.get(o,{params:{name:e.name,version:e.version}}).then(function(e){return e.data})},getProductsByGAV:function(e,t,r){return i.get(n,{params:{groupid:e,artifactid:t,version:r}}).then(function(e){return e.data})},getBlacklistedArtifactsInProject:function(e,t,r,o){return i.post(l,{products:[],searchUnknownProducts:!1,scmUrl:e,revision:t,pomPath:r,additionalRepos:o}).then(function(e){return e.data.blacklisted})},getDifferentArtifactsInProducts:function(e,t){return i.get(s,{params:{leftProduct:e.id,rightProduct:t.id}}).then(function(e){return e.data})},getBuiltArtifactsInProject:function(e,t,r,o){return i.post(a,{scmUrl:e,revision:t,pomPath:r,additionalRepos:o}).then(function(e){return e.data})},diffProjectProduct:function(e){return i.post(l,e).then(function(e){return e.data})}};return c}]),function(){var e=angular.module("pnc.common.restclient");e.value("RUNNING_BUILD_ENDPOINT","/running-build-records/:recordId"),e.factory("RunningBuildRecordDAO",["$resource","REST_BASE_URL","RUNNING_BUILD_ENDPOINT","cachedGetter","BuildConfigurationDAO","UserDAO","PageFactory",function(e,t,r,o,i,n,l){var s=t+r,a=e(s,{recordId:"@id"},{_getAll:{method:"GET",isArray:!1},_getByConfiguration:{method:"GET",url:t+"/running-build-records/build-configurations/:configurationId",isArray:!1},getLog:{method:"GET",url:s+"/log",isArray:!1,transformResponse:function(e){return{payload:e}}},_getByBCSetRecord:{method:"GET",url:t+"/running-build-records/build-config-set-records/:bcSetRecordId",isArray:!1}});return l.decorateNonPaged(a,"_getAll","query"),l.decorateNonPaged(a,"_getByConfiguration","getByConfiguration"),l.decorate(a,"_getAll","getAll"),l.decorate(a,"_getByConfiguration","getPagedByConfiguration"),l.decorate(a,"_getByBCSetRecord","getPagedByBCSetRecord"),a.prototype.getBuildConfiguration=o(function(e){return i.get({configurationId:e.buildConfigurationId})}),a.prototype.getUser=o(function(e){return n.get({userId:e.userId})}),a}])}(),function(){var e=angular.module("pnc.common.restclient");e.value("USER_ENDPOINT","/users/:userId"),e.factory("UserDAO",["$resource","REST_BASE_URL","USER_ENDPOINT","PageFactory",function(e,t,r,o){var i=e(t+r,{userId:"@id"},{_getAll:{method:"GET"},_getAuthenticatedUser:{method:"POST",url:t+"/users/loggedUser",isArray:!1,cache:!0,successNotification:!1}});return o.decorateNonPaged(i,"_getAll","query"),i}])}(),function(){"use strict";angular.module("pnc.common.select-modals").component("addBuildConfigWidget",{bindings:{project:"<",onAdd:"&"},templateUrl:"common/select-modals/build-config-multi-select/add-build-config-widget.html",controller:["Project",function(r){var o=this;o.select=function(e){t=e.id,r.queryBuildConfigurations({id:t}).$promise.then(function(e){o.buildConfigs=e.data||[]});var t},o.add=function(e){o.onAdd({buildConfig:e})},o.buildConfigs=[],o.config={selectItems:!1,multiSelect:!1,dblClick:!1,selectionMatchProp:"id",showSelectBox:!1},o.actionButtons=[{name:"Add",title:"Add this Build Config",include:"button-add-right",actionFn:function(e,t){o.add(t)}}]}]})}(),function(){"use strict";angular.module("pnc.common.select-modals").component("buildConfigMultiSelect",{bindings:{modalCtrl:"<"},templateUrl:"common/select-modals/build-config-multi-select/build-config-multi-select.html",controller:function(){var r=this;function o(t){return r.buildConfigs.findIndex(function(e){return t.id===e.id})}r.save=function(){r.modalCtrl.$close(r.buildConfigs)},r.cancel=function(){r.modalCtrl.$dismiss()},r.onRemove=function(e){var t=o(e);-1<t&&r.buildConfigs.splice(t,1)},r.onAdd=function(e){o(e)<0&&(r.buildConfigs=angular.copy(r.buildConfigs.concat(e)))},r.title=r.modalCtrl.config.title,r.buildConfigs=angular.copy(r.modalCtrl.config.buildConfigs)}})}(),function(){"use strict";angular.module("pnc.common.select-modals").component("removeBuildConfigsWidget",{bindings:{buildConfigs:"<",onRemove:"&"},templateUrl:"common/select-modals/build-config-multi-select/remove-build-configs-widget.html",controller:function(){var r=this;r.remove=function(e){r.onRemove({buildConfig:e})},r.config={selectItems:!1,multiSelect:!1,dblClick:!1,selectionMatchProp:"id",showSelectBox:!1},r.actionButtons=[{name:"Remove",title:"Remove this Build Config",actionFn:function(e,t){r.remove(t)}}]}})}(),function(){"use strict";angular.module("pnc.common.select-modals").controller("BuildGroupMultiSelectController",["$log","modalConfig","BuildConfigurationSet","rsqlQuery",function(e,t,n,l){var s=this;function i(t){return s.selected.findIndex(function(e){return e.id===t.id})}console.log("modalConfig == %O",t),s.title=t.title,s.selected=angular.copy(t.selected),s.removed=[],s.addGroup=function(e){var t,r=i(e),o=(t=e,s.removed.findIndex(function(e){return e.id===t.id}));-1<r||(-1<o&&s.removed.splice(o,1),s.selected.push(e))},s.removeGroup=function(e){s.selected.splice(i(e),1),s.removed.push(e)},s.save=function(){s.$close(s.selected)},s.close=function(){s.$dismiss()},s.onSelect=function(e){s.addGroup(e),s.input=void 0},s.fetchGroups=function(e){function t(e){return e.id}var r=s.selected.map(t),o=s.removed.map(t),i=l().where("name").like(e+"%").and().where("id").out(r).and().brackets(l().where("productVersion").isNull().or().where("id").in(o).end()).end();return n.query({q:i}).$promise.then(function(e){return e.data})},s.config={selectItems:!1,multiSelect:!1,dblClick:!1,selectionMatchProp:"id",showSelectBox:!1},s.actionButtons=[{name:"Remove",title:"Remove this Build Group",actionFn:function(e,t){"Remove"===e.name&&s.removeGroup(t)}}]}])}(),function(){"use strict";angular.module("pnc.common.select-modals").service("modalEditService",["modalSelectService","BuildConfigurationSet",function(r,o){this.editBuildGroupBuildConfigs=function(t,e){return r.openForBuildConfigs({title:"Add / Remove Build Configs from "+t.name,buildConfigs:e}).result.then(function(e){return o.updateBuildConfigurations({id:t.id},e).$promise})}}])}(),function(){"use strict";angular.module("pnc.common.select-modals").service("modalSelectService",["$uibModal","$q","$rootScope",function(t,r,o){function i(){var e=t.open.apply(t,arguments);return e.result.then(function(){o.$evalAsync()}),e}this.openForBuildGroups=function(e){return i({animation:!0,size:"md",templateUrl:"common/select-modals/build-group-multi-select.html",controller:"BuildGroupMultiSelectController",controllerAs:"ctrl",bindToController:!0,resolve:{modalConfig:function(){return r.when(e)}}})},this.openForProductVersion=function(e){return i({animation:!0,size:"md",templateUrl:"common/select-modals/product-version-single-select.html",controller:"ProductVersionSingleSelectController",controllerAs:"ctrl",bindToController:!0,resolve:{modalConfig:function(){return r.when(e)}}})},this.openForBuildConfigs=function(e){return i({animation:!0,size:"xl",template:'<build-config-multi-select modal-ctrl="$ctrl"></build-config-multi-select>',controller:["config",function(e){this.config=e}],controllerAs:"$ctrl",bindToController:!0,resolve:{config:function(){return r.when(e)}}})}}])}(),function(){"use strict";angular.module("pnc.common.select-modals").controller("ProductVersionSingleSelectController",["$log","modalConfig","Product","ProductVersion","rsqlQuery",function(e,t,r,o,i){var n=this;n.title=t.title,n.selectedProduct=angular.copy(t.selected),n.save=function(){n.$close(n.selectedVersion)},n.close=function(){n.$dismiss()},n.onSelectProduct=function(e){n.selectedProduct=e,n.input=void 0},n.onSelectVersion=function(e){n.selectedVersion=e,console.log("selected version: %O",e)},n.fetchProducts=function(e){return r.query({q:i().where("name").like(e+"%").end()}).$promise.then(function(e){return e.data})},n.config={selectItems:!0,multiSelect:!1,dblClick:!1,selectionMatchProp:"id",selectedItems:[],showSelectBox:!1,onSelect:n.onSelectVersion}}])}(),function(){"use strict";angular.module("pnc.common.util").factory("dateUtilConverter",function(){return{convertToTimestampNoon:function(e){return e?(e.setHours(12),e.setMinutes(0),e.setSeconds(0),e.getTime()):null},initDatePicker:function(r){r.opened=[],r.today=function(){r.dt=new Date},r.today(),r.clear=function(){r.dt=null},r.open=function(e,t){e.preventDefault(),e.stopPropagation(),r.opened[t]=!0},r.format="yyyy/MM/dd"}}})}(),function(){"use strict";angular.module("pnc.common.util").factory("QueryHelper",function(){var r={search:function(e){return"("+_(e).reduce(function(e,t,r){return e+(0!==r?" or ":"")+t+"=like=%25:search%25"},"")+")"},searchOnly:function(e,t){return"?q="+(t?"(":"")+r.search(e)+(t?t+")":"")}};return r})}(),function(){"use strict";angular.module("pnc.common.util").factory("utils",[function(){return{isEmpty:function(e){return angular.isUndefined(e)||null===e||angular.isString(e)&&""===e},parseBoolean:function(e){if(angular.isUndefined(e))return!1;if("boolean"==typeof e)return e;if(angular.isString(e))return"true"===e.toLowerCase();throw new Error("Unable to parse as boolean: "+e)},concatStrings:function(o){if(angular.isObject(o))return Object.keys(o).reduce(function(e,t){var r=o[t];return angular.isString(r)?e+r:e},"")},hashCode:function(e,t){var r=angular.isFunction(t)?t:function(e){return e.id};return e.reduce(function(e,t){return 31*e+r(t)},17)},prettyPrint:function(e,t){var r=t||2;JSON.stringify(e,null,r)}}}])}(),function(){var e=angular.module("pnc.configuration-set-record");e.controller("CsRecordDetailController",["$state","csRecordDetail",function(e,t){this.csRecordDetail=t}]),e.controller("CsRecordInfoController",["csRecordDetail",function(e){this.csRecordDetail=e}]),e.controller("CsRecordListController",[_.noop])}(),angular.module("pnc.configuration-set-record").directive("pncGroupBuilds",[function(){function e(e,t,r,o){t.page=r.getPaged(),t.$on(o.BUILD_SET_STARTED,t.page.reload()),t.$on(o.BUILD_SET_FINISHED,t.page.reload())}return e.$inject=["$log","$scope","BuildConfigurationSetRecordDAO","eventTypes"],{restrict:"E",templateUrl:"configuration-set-record/directives/pnc-group-builds/pnc-group-builds.html",scope:{},controller:e}}]),angular.module("pnc.configuration-set-record").directive("pncRecentBuildsForCSSet",["$log","BuildRecordDAO","eventTypes",function(e,r,o){return{restrict:"E",templateUrl:"configuration-set-record/directives/pncRecentBuildsForCSSet/pnc-recent-builds-for-cs-set.html",scope:{bcSetRecordId:"="},link:function(e){e.page=r.getPagedByBCSetRecord({bcSetRecordId:e.bcSetRecordId}),e.columns=["status","id","configurationName","startTime","endTime","username","pushStatus"];var t=function(){e.page.reload()};e.$on(o.BUILD_STARTED,t),e.$on(o.BUILD_FINISHED,t)}}}]),angular.module("pnc.configuration-set-record").directive("pncRunningBuildsForCSSet",["$log","RunningBuildRecordDAO","eventTypes",function(e,t,o){return{restrict:"E",templateUrl:"configuration-set-record/directives/pncRunningBuildsForCSSet/pnc-running-builds-for-cs-set.html",scope:{bcSetRecordId:"="},link:function(r){r.page=t.getPagedByBCSetRecord({bcSetRecordId:r.bcSetRecordId});var e=function(e,t){r.page.reload()};r.$on(o.BUILD_STARTED,e),r.$on(o.BUILD_FINISHED,e)}}}]),function(){var e=angular.module("pnc");e.controller("authenticationController",["authService",function(e){this.username=e.getPrinciple(),this.isAuthenticated=e.isAuthenticated,this.logout=e.logout,this.login=e.login}]),e.controller("menuController",["$state","$scope",function(e,t){t.state=e}]),e.controller("defaultConfigurationController",["pncProperties",function(e){var t="defaultConfigurationModal";this.isDefaultConfiguration=e.isDefaultConfiguration,this.title="No UI configuration provided",e.isDefaultConfiguration&&null===sessionStorage.getItem(t)&&$("#defaultConfigurationModal").modal("show"),$("#defaultConfigurationModal").on("hidden.bs.modal",function(){sessionStorage.setItem(t,"hidden")})}]),e.controller("userGuideController",["pncProperties",function(e){var t="userGuidePopover",r=$("#user-guide .user-guide-link");this.url=e.userGuideUrl,this.url&&null===localStorage.getItem(t)&&(r.popover("show"),r.add("#user-guide .user-guide-close").click(function(){localStorage.setItem(t,"displayed"),r.popover("destroy")}))}])}(),angular.module("pnc.dashboard").controller("DashboardController",["authService",function(e){this.isAuthenticated=e.isAuthenticated,this.login=e.login}]),angular.module("pnc.dashboard").directive("pncMyBuildSetsPanel",["$log","authService","PageFactory","BuildConfigSetRecord","BuildRecordDAO","UserDAO","eventTypes","paginator",function(e,r,t,o,i,n,l,s){return{restrict:"E",templateUrl:"dashboard/directives/pnc-my-build-sets-panel.html",scope:{},link:function(t){t.update=function(){t.page.refresh()},t.show=function(){return r.isAuthenticated()},r.isAuthenticated()&&(r.getPncUser().then(function(e){return o.getByUser({userId:e.id,pageSize:10}).$promise.then(function(e){t.page=s(e)})}),t.displayFields=["status","id","configurationName","startTime","endTime"],t.$on(l.BUILD_SET_STARTED,t.update),t.$on(l.BUILD_SET_FINISHED,t.update))}}}]),angular.module("pnc.dashboard").directive("pncMyBuildsPanel",["$log","authService","PageFactory","BuildConfigurationDAO","BuildRecord","UserDAO","eventTypes","paginator",function(e,r,t,o,i,n,l,s){return{restrict:"E",templateUrl:"dashboard/directives/pnc-my-builds-panel.html",scope:{},link:function(t){t.update=function(){t.page.refresh()},t.show=function(){return r.isAuthenticated()},r.isAuthenticated()&&(r.getPncUser().then(function(e){return i.getByUser({userId:e.id,pageSize:10}).$promise.then(function(e){t.page=s(e)})}),t.displayFields=["status","id","configurationName","startTime","endTime"],t.$on(l.BUILD_STARTED,t.update),t.$on(l.BUILD_FINISHED,t.update))}}}]);var pnc=pnc||{};!function(e){"use strict";var o={error:[],warn:[],info:[],success:[]},t={isDefaultConfiguration:!0,pncUrl:"/pnc-rest/rest",pncNotificationsUrl:"ws://"+window.location.host+"/pnc-rest/ws/build-records/notifications"};function i(e){return e&&e.keycloak&&e.keycloak.url}!function(e,t){if(i(t)){var r=document.createElement("script");r.onload=function(){e(t)},r.addEventListener("error",function(){console.warn("Unable to load keycloak.js, authentication will be disabled"),o.warn.push({message:"Unable to load keycloak.js, authentication disabled. See the user guide for more information",actionTitle:"User Guide",actionCallback:function(){window.open(t.userGuideUrl,"_blank")}}),t.keycloak=!1,e(t)}),r.src=t.keycloak.url+"/js/keycloak.js",document.head.appendChild(r)}else e(t)}(function(e){e||(console.warn("No UI configuration provided: using defaults"),e=t),console.info("Starting UI with configuration: "+JSON.stringify(e,null,2)),angular.element(document).ready(function(){var t;t=i(e)?new Keycloak(e.keycloak):{authenticated:!1,login:function(){console.warn("Authentication is disabled, keycloak.login() ignored")},logout:function(){console.warn("Authentication is disabled, keycloak.logout() ignored")}},angular.module("pnc").config(["keycloakProvider",function(e){e.setKeycloak(t)}]),angular.module("pnc.properties",[]).constant("pncProperties",e).constant("onBootNotifications",o),i(e)?t.init({onLoad:"check-sso",responseMode:"query"}).success(function(){angular.bootstrap(document,["pnc"])}):angular.bootstrap(document,["pnc"])})},e.config)}(pnc),angular.module("pnc.milestone").directive("pncMilestoneArtifacts",[function(){return{restrict:"E",templateUrl:"milestone/directives/milestoneArtifacts/milestoneArtifacts.html",scope:{milestone:"=",distributedArtifacts:"="},link:function(){}}}]),angular.module("pnc.milestone").directive("pncMilestoneBuilds",[function(){return{restrict:"E",templateUrl:"milestone/directives/milestoneBuilds/milestoneBuilds.html",scope:{milestone:"=",performedBuilds:"="},link:function(e){e.displayFields=["status","id","configurationName","endTime"]}}}]),angular.module("pnc.milestone").directive("versionUnique",["$q","versionFactory",function(s,a){return{restrict:"A",require:"ngModel",link:function(e,t,l,r){r.$asyncValidators.unique=function(e,t){var r=s.defer(),o=e||t,i=l.productVersionId,n=l.productVersion;return o&&i&&n?a.checkUniqueValue(i,o,n).then(function(e){e?r.resolve():r.reject()}):r.resolve(),r.promise}}}}]),angular.module("pnc.milestone").factory("versionFactory",["ProductMilestoneDAO",function(t){var e={checkUniqueValue:function(e,r,o){return t.getAllForProductVersion({versionId:e}).then(function(e){for(var t=0;t<e.length;t++)if(e[t].version===o+"."+r)return!1;return!0})}};return e}]),function(){"use strict";var e=angular.module("pnc.milestone");e.controller("MilestoneDetailController",["$scope","$state","$stateParams","productDetail","versionDetail","milestoneDetail","distributedArtifacts","performedBuilds","latestRelease",function(e,t,r,o,i,n,l,s,a){var c=this;c.product=o,c.productVersion=i,c.milestone=n,c.distributedArtifacts=l,c.performedBuilds=s,c.latestRelease=a}]),e.controller("MilestoneLogController",["latestRelease",function(e){this.latestRelease=e}]),e.controller("MilestoneCreateUpdateController",["$scope","$state","$stateParams","$log","ProductMilestoneDAO","productDetail","versionDetail","milestoneDetail","dateUtilConverter",function(e,t,r,o,i,n,l,s,a){var c=this;c.product=n,c.productVersion=l,c.isUpdating=!1,c.data=new i,c.startingDate=null,(c.plannedEndDate=null)!==s&&(c.isUpdating=!0,c.data=s,c.version=c.data.version.substring(l.version.length+1),c.startingDate=new Date(c.data.startingDate),c.plannedEndDate=new Date(c.data.plannedEndDate)),c.setCurrentMilestone=c.productVersion.currentProductMilestoneId===c.data.id,c.setCurrentMilestoneDisabled=c.setCurrentMilestone,c.invalidStartingPlannedEndDates=function(e,t){return void 0!==e&&void 0!==t&&t<=e},c.submit=function(){c.data.version=l.version+"."+c.version,c.data.startingDate=a.convertToTimestampNoon(c.startingDate),c.data.plannedEndDate=a.convertToTimestampNoon(c.plannedEndDate),c.data.productVersionId=l.id,c.isUpdating?(c.setCurrentMilestone&&(c.productVersion.currentProductMilestoneId=c.data.id),c.productVersion.$update().then(function(){c.data.$update().then(function(){t.go("product.detail.version",{productId:n.id,versionId:l.id},{reload:!0})})})):c.data.$save().then(function(){c.setCurrentMilestone?(l.currentProductMilestoneId=c.data.id,l.$update({productId:n.id,versionId:l.id}).then(function(){t.go("product.detail.version",{productId:n.id,versionId:l.id},{reload:!0})},function(){t.go("product.detail.version",{productId:n.id,versionId:l.id},{reload:!0})})):t.go("product.detail.version",{productId:n.id,versionId:l.id},{reload:!0})})},a.initDatePicker(e)}]),e.controller("MilestoneCloseController",["$scope","$state","$stateParams","productDetail","versionDetail","milestoneDetail",function(e,t,r,o,i,n){var l=this;l.product=o,l.productVersion=i,l.data=n,l.submit=function(){l.data.$closeMilestone().then(function(){t.go("product.detail.version",{productId:o.id,versionId:i.id},{reload:!0})})}}])}(),function(){"use strict";angular.module("pnc.product").component("pncLabelLink",{bindings:{item:"<",productId:"<?",currentId:"<?"},templateUrl:"product/directives/pnc-label-link/pnc-label-link.html",controller:["ProductMilestoneDAO",function(e){var t=this;t.$onInit=function(){t.isMilestone=_.has(t.item,"productReleaseId"),t.isRelease=_.has(t.item,"productMilestoneId"),t.isPrimary=t.item.id===t.currentId,t.isRelease&&e.get({milestoneId:t.item.productMilestoneId}).$promise.then(function(e){t.milestone=e})}}]})}(),angular.module("pnc.build-records").directive("pncProductVersionBCs",["$log","$state","eventTypes","BuildConfigurationDAO",function(e,t,r,o){return{restrict:"E",templateUrl:"product/directives/pncProductVersionBCs/pnc-product-version-bcs.html",scope:{version:"="},link:function(e){e.page=o.getPagedByProductVersion({productId:e.version.productId,versionId:e.version.id})}}}]),angular.module("pnc.build-records").directive("pncProductVersionBCSets",["$log","$state","eventTypes","ProductVersionDAO",function(e,t,r,o){return{restrict:"E",templateUrl:"product/directives/pncProductVersionBCSets/pnc-product-version-bcsets.html",scope:{version:"=",product:"="},link:function(e){e.page=o.getPagedBCSets({versionId:e.version.id})},controllerAs:"ctrl",controller:["$scope","modalSelectService","ProductVersion",function(t,e,r){this.edit=function(){e.openForBuildGroups({title:"Add/Remove Build Groups to "+t.product.name+": "+t.version.version,selected:t.version.buildConfigurationSets}).result.then(function(e){r.updateBuildConfigurationSets({id:t.version.id},e).$promise.then(function(){t.page.loadPageIndex(0),t.version=r.get({id:t.version.id}).$promise.then(function(e){t.version=e})})})}}]}}]),angular.module("pnc.build-records").directive("pncProductVersionMilestones",["$log","$state",function(o,i){return{restrict:"E",templateUrl:"product/directives/pncProductVersionMilestones/pnc-product-version-milestones.html",scope:{version:"=",product:"="},link:function(e){var t=e.version,r=e.product;e.markCurrentMilestone=function(e){o.debug("Mark milestone as current: %O",e),t.currentProductMilestoneId=e.id,t.$update({productId:r.id,versionId:t.id}).then(function(){i.go("product.detail.version",{productId:r.id,versionId:t.id},{reload:!0})})}}}}]),angular.module("pnc.build-records").directive("pncProductVersionReleases",[function(){return{restrict:"E",templateUrl:"product/directives/pncProductVersionReleases/pnc-product-version-releases.html",scope:{version:"="},link:function(t){var e=t.version.productMilestones;t.versionMilestoneNames={},angular.forEach(e,function(e){t.versionMilestoneNames[e.id]=e.version})}}}]),angular.module("pnc.build-records").directive("pncProductVersions",["ProductVersionDAO",function(t){return{restrict:"E",templateUrl:"product/directives/pncProductVersions/pnc-product-versions.html",scope:{productId:"="},link:function(e){e.page=t.getPagedByProduct({productId:e.productId})}}}]),function(){var e=angular.module("pnc.product");e.controller("ProductListController",["$log","$state","productList",function(e,t,r){this.products=r}]),e.controller("ProductDetailController",["$log","$state","productDetail",function(e,t,r){var o=this;o.product=r,o.update=function(){e.debug("Updating product: %O",o.product),o.product.$update().then(function(){t.go("product.detail",{productId:o.product.id},{reload:!0})})}}]),e.controller("ProductVersionController",["$log","$state","productDetail","versionDetail",function(e,t,r,o){var i=this;i.product=r,i.version=o,i.update=function(){e.debug("Updating product version: %O",i.version),i.version.$update().then(function(){t.go("product.detail.version",{productId:r.id,versionId:o.id},{reload:!0})})}}]),e.controller("ProductCreateController",["$state","$log","ProductDAO",function(t,e,r){this.data=new r;var o=this;o.submit=function(){o.data.$save().then(function(e){t.go("product.detail",{productId:e.id})})},o.reset=function(e){e&&(e.$setPristine(),e.$setUntouched(),o.data=new r)}}]),e.controller("ProductVersionCreateController",["$state","$log","ProductVersionDAO","productDetail",function(t,e,r,o){this.data=new r,this.product=o;var i=this;i.submit=function(){i.data.productId=i.product.id,i.data.$save().then(function(e){t.go("product.detail",{productId:e.productId},{reload:!0})})},i.reset=function(e){e&&(e.$setPristine(),e.$setUntouched(),i.data=new r)}}])}(),function(){"use strict";angular.module("pnc.projects").directive("pncBuildConfigurations",["BuildConfigurationDAO",function(t){return{restrict:"E",templateUrl:"projects/directives/pnc-build-configurations/pnc-build-configurations.html",scope:{pncProject:"="},controller:["$scope",function(e){e.page=t.getPagedByProject({projectId:e.pncProject.id})}]}}])}(),function(){"use strict";var e=angular.module("pnc.projects");e.controller("ProjectListController",["projectList",function(e){this.projects=e}]),e.controller("ProjectDetailController",["$log","$state","$rootScope","projectDetail",function(e,t,r,o){var i=this;function n(){t.go("projects.detail",{projectId:i.project.id},{reload:!0})}i.project=o,i.update=function(){e.debug("Updating project: %O",i.project),i.project.$update().then(n)},r.$on("BCC_BPM_NOTIFICATION",function(e,t){"BCC_CREATION_SUCCESS"===t.eventType&&n()})}]),e.controller("ProjectCreateController",["$scope","$state","$log","ProjectDAO",function(t,r,e,o){this.create=function(e){new o(angular.copy(e)).$save().then(function(e){r.go("projects.detail",{projectId:e.id})})},this.reset=function(e){e&&(e.$setPristine(),e.$setUntouched(),t.project=new o)}}]),e.controller("ConfigurationListController",["$log","$state","configurationList","ProjectDAO",function(e,t,r,o){var i=this;this.configurations=r,this.projects=[],angular.forEach(this.configurations.data,function(e){o.get({projectId:e.projectId}).$promise.then(function(e){e&&i.projects.push(e)})})}]),e.controller("CreateBCController",["projectDetail",function(e){this.fixedProject=e}])}(),angular.module("pnc.release").controller("ReleaseCreateUpdateController",["$scope","$state","$stateParams","$log","ProductReleaseDAO","ProductMilestoneDAO","productDetail","versionDetail","releaseDetail","dateUtilConverter",function(e,t,r,o,i,n,l,s,a,c){var d=this;d.product=l,d.productVersion=s,d.versionMilestones=[],d.usedVersionMilestoneIds=[],d.supportLevels=[],d.releaseDate=null,d.isUpdating=!1,d.data=new i,null!==a&&(d.isUpdating=!0,d.data=a,d.productMilestoneId=a.productMilestoneId,d.version=d.data.version.substring(s.version.length+1),d.releaseDate=new Date(d.data.releaseDate)),i.getAllForProductVersion({versionId:d.productVersion.id},{}).then(function(e){angular.forEach(e,function(e){d.usedVersionMilestoneIds.push(e.productMilestoneId)}),n.getAllForProductVersion({versionId:d.productVersion.id},{}).then(function(e){angular.forEach(e,function(e){-1===d.usedVersionMilestoneIds.indexOf(e.id)&&d.versionMilestones.push(e),d.productMilestoneId&&e.id===d.productMilestoneId&&(d.productMilestoneVersion=e.version)})})}),i.getAllSupportLevel({versionId:d.productVersion.id},{}).then(function(e){d.supportLevels=e}),d.submit=function(){d.data.version=s.version+"."+d.version,d.data.releaseDate=c.convertToTimestampNoon(d.releaseDate),d.data.productVersionId=s.id,d.data.productMilestoneId=parseInt(d.productMilestoneId),d.isUpdating?d.data.$update().then(function(){t.go("product.detail.version",{productId:l.id,versionId:s.id},{reload:!0})}):d.data.$save().then(function(){t.go("product.detail.version",{productId:l.id,versionId:s.id},{reload:!0})})},c.initDatePicker(e)}]),angular.module("pnc.report").directive("pncProjectRepositoryForm",function(){return{restrict:"E",scope:{searchCallback:"&",resetCallback:"&"},templateUrl:"report/directives/pnc-project-repository-form/pnc-project-repository-form.html",controller:["$scope",function(t){var r=function(){t.scmUrl="",t.revision="",t.pomPath="",t.additionalRepos=[]};r(),t.reset=function(e){e&&(r(),t.resetCallback(),e.$setPristine(),e.$setUntouched())},t.search=function(){t.searchCallback({scmUrl:t.scmUrl,revision:t.revision,pomPath:t.pomPath,additionalRepos:t.additionalRepos})}}]}}),function(){var e=angular.module("pnc.report");e.controller("ProductShippedReportController",["$scope","$state","$log","ReportDAO","whitelistProducts",function(e,t,r,o,i){var n=this;n.reportResults=[],n.products={},n.products.data=_.clone(i),n.defaultPageSize=50,n.defaultSortKey="gav.groupId",n.defaultReverse=!1,n.productSelection={selected:[]},_.each(n.products.data,function(e){e.displayBoldText=e.name,e.displayText=" - "+e.version+" ("+e.supportStatus+")",e.fullDisplayText=e.displayBoldText+e.displayText}),n.isProductSelected=function(){return!_.isUndefined(n.productSelection)&&0<n.productSelection.selected.length},n.isResultNotEmpty=function(){return!_.isUndefined(n.reportResults)&&0<n.reportResults.length},n.reset=function(e){e&&(n.productSelection.selected=[],n.selectedProductId=void 0,n.reportResults=[],n.reportSearchFilter={},e.$setPristine(),e.$setUntouched())},n.search=function(){o.getWhitelistProductArtifacts(n.productSelection.selected[0]).then(function(e){n.reportResults=e,n.reportResults=_.chain(n.reportResults).sortBy(function(e){return e.gav.groupId}).value(),n.reportSearchFilter=n.productSelection.selected[0],n.sortKey=n.defaultSortKey,n.reverse=n.defaultReverse})},n.sort=function(e){n.sortKey=e,n.reverse=!n.reverse}}]),e.controller("ProductsForArtifactReportController",["$scope","$state","$log","ReportDAO",function(e,t,r,o){var i=this;i.reportResults=[],i.gav={},i.afterSearch=!1,i.defaultSortKey="name",i.defaultReverse=!1,i.isResultNotEmpty=function(){return!_.isEmpty(i.reportResults)},i.reset=function(e){e&&(i.gav={},i.reportResults=[],i.afterSearch=!1,e.$setPristine(),e.$setUntouched())},i.search=function(){o.getProductsByGAV(i.gav.groupId,i.gav.artifactId,i.gav.version).then(function(e){i.reportResults=e,i.sortKey=i.defaultSortKey,i.reverse=i.defaultReverse,i.afterSearch=!0,i.reportResults=_.chain(i.reportResults).sortBy(function(e){return e[i.defaultSortKey]}).value()})},i.sort=function(e){i.sortKey=e,i.reverse=!i.reverse}}]),e.controller("BlacklistedArtifactsInProjectReportController",["$scope","$state","$log","ReportDAO",function(e,t,r,i){var n=this;n.afterSearch=!1,n.defaultSortKey="groupId",n.defaultReverse=!1,n.isResultNotEmpty=function(){return!_.isEmpty(n.reportResults)},n.reset=function(){n.reportResults=[],n.afterSearch=!1},n.search=function(e,t,r,o){i.getBlacklistedArtifactsInProject(e,t,r,o).then(function(e){n.reportResults=[],_.forEach(e,function(e){_.forEach(e.gavs,function(e){n.reportResults.push(e)})}),n.reportResults=_(n.reportResults).uniq(function(e){return JSON.stringify(_.pick(e,["groupId","artifactId","version"]))}),n.sortKey=n.defaultSortKey,n.reverse=n.defaultReverse,n.afterSearch=!0,n.reportResults=_.chain(n.reportResults).sortBy(function(e){return e[n.defaultSortKey]}).value()},function(){n.reportResults=[]})},n.sort=function(e){n.sortKey=e,n.reverse=!n.reverse}}]),e.controller("DifferentArtifactsInProductsReportController",["$scope","$state","$log","ReportDAO","whitelistProducts",function(e,t,r,o,i){var n=this;n.afterSearch=!1,n.gavsAdded=[],n.gavsRemoved=[],n.gavsChanged=[],n.gavsUnchanged=[],n.products={},n.products.data=_.clone(i),n.defaultPageSize=50,n.defaultAddedSortKey="groupId",n.defaultRemovedSortKey="groupId",n.defaultChangedSortKey="groupId",n.defaultUnchangedSortKey="groupId",n.defaultAddedReverse=!1,n.defaultRemovedReverse=!1,n.defaultChangedReverse=!1,n.defaultUnchangedReverse=!1,n.productLeftSelection={selected:[]},n.productRightSelection={selected:[]},_.each(n.products.data,function(e){e.displayBoldText=e.name,e.displayText=" - "+e.version+" ("+e.supportStatus+")",e.fullDisplayText=e.displayBoldText+e.displayText}),n.isProductLeftSelected=function(){return!_.isUndefined(n.productLeftSelection)&&0<n.productLeftSelection.selected.length},n.isProductRightSelected=function(){return!_.isUndefined(n.productRightSelection)&&0<n.productRightSelection.selected.length},n.isGavAddedNotEmpty=function(){return!_.isUndefined(n.gavsAdded)&&0<n.gavsAdded.length},n.isGavRemovedNotEmpty=function(){return!_.isUndefined(n.gavsRemoved)&&0<n.gavsRemoved.length},n.isGavChangedNotEmpty=function(){return!_.isUndefined(n.gavsChanged)&&0<n.gavsChanged.length},n.isGavUnchangedNotEmpty=function(){return!_.isUndefined(n.gavsUnchanged)&&0<n.gavsUnchanged.length},n.isFormValid=function(){return!_.isUndefined(n.productLeftSelection)&&0<n.productLeftSelection.selected.length&&!_.isUndefined(n.productRightSelection)&&0<n.productRightSelection.selected.length&&n.productLeftSelection.selected[0].id!==n.productRightSelection.selected[0].id},n.reset=function(e){e&&(n.productLeftSelection.selected=[],n.productRightSelection.selected=[],n.selectedProductLeftId=void 0,n.selectedProductRightId=void 0,n.afterSearch=!1,n.gavsAdded=[],n.gavsRemoved=[],n.gavsChanged=[],n.gavsUnchanged=[],n.reportLeftProductSearchFilter={},n.reportRightProductSearchFilter={},e.$setPristine(),e.$setUntouched())},n.search=function(){o.getDifferentArtifactsInProducts(n.productLeftSelection.selected[0],n.productRightSelection.selected[0]).then(function(e){n.reportLeftProductSearchFilter=n.productLeftSelection.selected[0],n.reportRightProductSearchFilter=n.productRightSelection.selected[0],n.afterSearch=!0,n.gavsAdded=e.added,n.gavsRemoved=e.removed,n.gavsChanged=e.changed,n.gavsUnchanged=e.unchanged,n.gavsAdded=_.chain(n.gavsAdded).sortBy(function(e){return e.groupId}).value(),n.gavsRemoved=_.chain(n.gavsRemoved).sortBy(function(e){return e.groupId}).value(),n.gavsChanged=_.chain(n.gavsChanged).sortBy(function(e){return e.groupId}).value(),n.gavsUnchanged=_.chain(n.gavsUnchanged).sortBy(function(e){return e.groupId}).value(),n.sortKeyAdded=n.defaultAddedSortKey,n.reverseAdded=n.defaultAddedReverse,n.sortKeyRemoved=n.defaultRemovedSortKey,n.reverseRemoved=n.defaultRemovedReverse,n.sortKeyChanged=n.defaultChangedSortKey,n.reverseChanged=n.defaultChangedReverse,n.sortKeyUnchanged=n.defaultUnchangedSortKey,n.reverseUnchanged=n.defaultUnchangedReverse})},n.sortAdded=function(e){n.sortKeyAdded=e,n.reverseAdded=!n.reverseAdded},n.sortRemoved=function(e){n.sortKeyRemoved=e,n.reverseRemoved=!n.reverseRemoved},n.sortChanged=function(e){n.sortKeyChanged=e,n.reverseChanged=!n.reverseChanged},n.sortUnchanged=function(e){n.sortKeyUnchanged=e,n.reverseUnchanged=!n.reverseUnchanged}}]),e.controller("BuiltArtifactsInProjectReportController",["$scope","$state","$log","ReportDAO",function(e,t,r,i){var n=this;n.afterSearch=!1,n.defaultSortKey="groupId",n.defaultReverse=!1,n.pagination={current:1},n.defaultPageSize=30,n.availableVersionsLimits=[],n.expandAll=function(){var e=n.defaultPageSize*(n.pagination.current-1),t=e+n.defaultPageSize;n.reportResults.slice(e,t).forEach(function(e,t){n.availableVersionsLimits[t]=e.availableVersions.length})},n.isResultNotEmpty=function(){return!_.isEmpty(n.reportResults)},n.reset=function(){n.reportResults=[],n.afterSearch=!1},n.search=function(e,t,r,o){i.getBuiltArtifactsInProject(e,t,r,o).then(function(e){n.reportResults=e,n.sortKey=n.defaultSortKey,n.reverse=n.defaultReverse,n.afterSearch=!0,n.reportResults=_.chain(n.reportResults).sortBy(function(e){return e[n.defaultSortKey]}).value()},function(){n.reportResults=[]})},n.sort=function(e){n.sortKey=e,n.reverse=!n.reverse}}]),e.controller("ProjectProductDiff",["$rootScope","$timeout","ReportDAO","productList",function(e,t,r,o){var i=this,n=function(e){return e.name+" "+e.version+" ("+e.supportStatus+")"},l=function(){i.form={scmUrl:{error:!1},productId:{error:!1,productId:null,products:{data:[]},selectedProducts:[]},data:{scmUrl:null,revision:null,pomPath:null,products:[],searchUnknownProducts:!1}},i.form.productId.products.data=_(o).map(function(e){return e.fullDisplayText=e.displayText=n(e),e}).value()};l(),i.reset=function(){l(),i.productSelectControl.reset()},i.validate=function(){return i.form.scmUrl.error=!i.form.data.scmUrl,i.form.productId.error=0===i.form.data.products.length,!i.form.scmUrl.error&&!i.form.productId.error&&(i.form.data.revision||(i.form.data.revision="master"),i.form.data.pomPath||(i.form.data.pomPath="pom.xml"),!0)},i.showTable=!1,i.submitDisabled=!1,i.computeDifference=function(){e.showSpinner=!0,i.submitDisabled=!0,i.form.data.products=_(i.form.productId.selectedProducts).map(function(e){return e.id}).value(),i.validate()&&r.diffProjectProduct(i.form.data).then(function(e){i.tableData=s(e),t(function(){i.collapseAll()}),i.showTable=!0}).catch(function(){i.showTable=!1}).finally(function(){e.showSpinner=!1,i.submitDisabled=!1})};var s=function(t){var i={data:{},productNames:[],moduleNames:[]};return _.forEach({internallyBuilt:"INTERNALLY BUILT",builtInDifferentVersion:"BUILT IN DIFFERENT VERSION",notBuilt:"NOT BUILT",blacklisted:"BLACKLISTED"},function(e,o){_.forEach(t[o],function(e){var t=e.groupId+":"+e.artifactId;-1===i.moduleNames.indexOf(t)&&i.moduleNames.push(t),_(i.data).has(t)||(i.data[t]=[]),"internallyBuilt"!==o&&"builtInDifferentVersion"!==o||_.forEach(e.gavProducts,function(r){r.name=r.groupId+":"+r.artifactId,r._type=o,r.versions={__project:r.version},r.differenceTypes=[],_.forEach(r.gavProducts,function(e){var t=n(e.product);-1===i.productNames.indexOf(t)&&i.productNames.push(t),r.versions[t]=e.version,r.differenceTypes[t]=e.differenceType}),i.data[t].push(r)}),"notBuilt"!==o&&"blacklisted"!==o||_.forEach(e.gavs,function(e){e.name=e.groupId+":"+e.artifactId,e._type=o,e.versions={__project:e.version},i.data[t].push(e)})})}),_.forEach(i.data,function(e){_.forEach(e,function(t){t._latestVersion=_(t.versions).chain().values().sortBy(_.identity).value().reverse()[0],_.forEach(i.productNames,function(e){_.isUndefined(t.versions[e])&&("blacklisted"===t._type&&(t.versions[e]="BLACKLISTED"),"notBuilt"===t._type&&(t.versions[e]="-"))})})}),_.forEach(i.data,function(e,t){i.data[t]=_(e).sortBy(function(e){return e.artifactId}).value()}),i};i.expandAll=function(){$(".collapse").collapse("show")},i.collapseAll=function(){$(".collapse").collapse("hide")}}])}(),function(){"use strict";var e=angular.module("pnc");e.factory("unwrapPageResponseInterceptor",function(){return{response:function(e){return e.data.content&&!_.isArray(e.data.content)&&(e.data=e.data.content),e}}}),e.factory("httpResponseInterceptor",["$q","$log","pncNotify","keycloak",function(t,o,i,r){return{response:function(e){var t,r=e.config.successNotification;return angular.isUndefined(r)?"GET"!==(t=e).config.method&&(o.debug("HTTP response: %O",t),i.success("Request successful")):angular.isFunction(r)?r(e):angular.isString(r)&&i.success(r),e},responseError:function(e){switch(e.status){case 0:i.error("Unable to connect to server");break;case 401:r.login();break;case 404:i.error("Requested resource not found");break;default:!function(e){var t;if(!(e&&e.data&&e.data.errorMessage))return i.error("PNC REST Api returned an error in an invalid format: "+e.status+" "+e.statusText),o.error("PNC REST Api returned an error in an invalid format: response: %O",e);120<(t=e.data).errorMessage.length&&(t.errorMessage=t.errorMessage.substring(0,119)+" ..."),i.error(t.errorMessage),o.error('PNC REST API returned the following error: type: "%s", message: "%s", details: "%s"',t.errorType,t.errorMessage,t.details)}(e)}return t.reject(e)}}}])}(),angular.module("pnc").run(["$templateCache",function(e){"use strict";e.put("build-configs/directives/pnc-build-configs-list/pnc-build-configs-list.html",' <table class="table table-bordered table-striped table-hover" ng-show="$ctrl.showTable()"> <thead> <th ng-if="::$ctrl.showColumn(\'name\')">Name</th> <th ng-if="::$ctrl.showColumn(\'project\')">Project</th> <th ng-if="::$ctrl.showColumn(\'creationTime\')">Created</th> <th ng-if="::$ctrl.showColumn(\'lastModificationTime\')">Modified</th> <th ng-if="::$ctrl.showColumn(\'buildStatus\')">Build Status</th> <th ng-if="::$ctrl.actionsTemplateUrl">Actions</th> </thead> <tbody> <tr ng-repeat="buildConfig in $ctrl.buildConfigs"> <td ng-if="$ctrl.showColumn(\'name\')"> <a ui-sref="projects.detail.build-configs.detail({ projectId: buildConfig.project.id, configurationId: buildConfig.id })" href> {{ buildConfig.name }} </a> </td> <td ng-if="::$ctrl.showColumn(\'project\')"> <a ui-sref="projects.detail({ projectId: buildConfig.project.id })" href> {{ buildConfig.project.name }} </a> </td> <td ng-if="::$ctrl.showColumn(\'creationTime\')">{{ buildConfig.creationTime | date:\'medium\' }}</td> <td ng-if="::$ctrl.showColumn(\'lastModificationTime\')">{{ buildConfig.lastModificationTime | date:\'medium\' }}</td> <td ng-if="::$ctrl.showColumn(\'buildStatus\')"> <pnc-latest-build build-config="buildConfig"></pnc-latest-build> </td> <td class="td-actions" ng-if="::$ctrl.actionsTemplateUrl" ng-include="::$ctrl.actionsTemplateUrl"></td> </tr> </tbody> </table> <p ng-hide="$ctrl.showTable()" class="text-center"><em>There are no Build Configs to display</em></p> '),e.put("build-configs/directives/pnc-configuration-create-panel/pnc-configuration-create-panel.html",' <form class="form-horizontal" name="configurationForm" novalidate> <div class="panel panel-default" ng-show="isProjectSelectable()"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : !data.project.id && configurationForm.projectId.$touched, \'has-success\': data.project.id && configurationForm.projectId.$touched }"> <label for="input-project" class="col-sm-2 control-label"> * Project </label> <div class="col-sm-10"> <pnc-infinite-select-items single-item="true" selected-items="projectSelection.selected" infinite-select-required="true" infinite-select-id="projectId" placeholder="Scroll & Filter Projects..." items="projects" item-id="data.project.id"></pnc-infinite-select-items> <span class="help-block" ng-show="!data.project.id && configurationForm.projectId.$touched">Required field.</span> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : configurationForm.name.$invalid && configurationForm.name.$touched, \'has-success\': configurationForm.name.$valid && configurationForm.name.$touched }"> <label for="input-name" class="col-sm-2 control-label">* Name</label> <div class="col-sm-10"> <input id="input-name" class="form-control" name="name" maxlength="255" ng-model="data.name" pattern="^[a-zA-Z0-9_.][a-zA-Z0-9_.-]*(?!\\.git)+$" spellcheck="false" required> <span class="help-block" ng-show="configurationForm.name.$error.required && configurationForm.name.$touched">Required field.</span> <span class="help-block" ng-show="configurationForm.name.$error.pattern && configurationForm.name.$touched">The name contains not allowed characters (e.g spaces, commas, semicolons, apex, quotes) </span> </div> </div> <div class="form-group"> <label for="input-description" class="col-sm-2 control-label">Description</label> <div class="col-sm-10"> <textarea id="input-description" class="form-control" name="description" ng-model="data.description"></textarea> </div> </div> </div> </div> <pnc-internal-external-url data="data" form="configurationForm" sidebar-cols="2"></pnc-internal-external-url> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\': (configurationForm.buildScript.$invalid || configurationForm.buildScript.$error.invalidBuildScript)\n          && configurationForm.buildScript.$touched, \'has-success\': configurationForm.buildScript.$valid && configurationForm.buildScript.$touched }"> <label for="input-build-script" class="col-sm-2 control-label">* Build Script</label> <div class="col-sm-10"> <textarea id="input-build-script" class="form-control" name="buildScript" spellcheck="false" required ng-model="data.buildScript" pnc-build-script-validator></textarea> <span class="help-block" ng-show="configurationForm.buildScript.$error.required && configurationForm.buildScript.$touched">Required field.</span> <span class="help-block" ng-show="configurationForm.buildScript.$error.invalidBuildScript && configurationForm.buildScript.$touched"> The use of \'deploy\' is mandatory when using Maven. </span> </div> </div> <div class="form-group" ng-class="{ \'has-error\' : !data.environment.id && configurationForm.environmentId.$touched, \'has-success\': data.environment.id && configurationForm.environmentId.$touched }"> <label for="input-environment" class="col-sm-2 control-label"> * Environment </label> <div class="col-sm-10 col-md-7"> <pnc-infinite-select-items single-item="true" selected-items="environmentSelection.selected" infinite-select-required="true" infinite-select-id="environmentId" placeholder="Scroll & Filter Environments..." items="environments" item-id="data.environment.id"></pnc-infinite-select-items> <span class="help-block" ng-show="!data.environment.id && configurationForm.environmentId.$touched">Required field.</span> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group"> <label for="input-product-versions" class="col-sm-2 control-label">Product Versions</label> <div class="col-sm-10 col-md-7"> <pnc-infinite-select-product-versions selected-items="productVersions.selected" single-item="true" infinite-select-required="false" infinite-select-id="input-pv" placeholder="Scroll & Filter Product Versions..." items="products" item-id="product.id"> </pnc-infinite-select-product-versions> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group"> <label for="input-dependencies" class="col-sm-2 control-label">Dependencies</label> <div class="col-sm-10 col-md-7"> <pnc-infinite-select-items selected-items="dependencies.selected" infinite-select-required="false" infinite-select-id="input-dependencies" placeholder="Scroll & Filter Dependencies..." items="configurations"></pnc-infinite-select-items> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group"> <label for="input-build-group-configs" class="col-sm-2 control-label">Build Group Configs</label> <div class="col-sm-10 col-md-7"> <pnc-infinite-select-items selected-items="buildgroupconfigs.selected" infinite-select-required="false" infinite-select-id="input-build-group-configs" placeholder="Scroll & Filter Build Group Configs..." items="configurationSetList"></pnc-infinite-select-items> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-body"> <div class="row"> <div class="col-sm-2 text-right-sm p-b-10"> <strong class="text-uppercase">Generic Parameter</strong> </div> </div> <pnc-generic-parameters generic-parameters="genericParameters" control="genericParametersControl"> </pnc-generic-parameters> </div> </div> <div class="form-group text-right"> <div class="col-sm-offset-2 col-sm-10"> <span class="btn btn-primary" ng-disabled="isCreateEnabled(configurationForm)" ng-click="submit(configurationForm)">Create</span> <input type="reset" class="btn btn-default" value="Clear" ng-click="reset(configurationForm)"> </div> </div> </form> '),e.put("build-configs/directives/pnc-create-build-config-button/pnc-create-build-config-button.html",' <button type="button" class="btn btn-lg btn-default" uib-tooltip="Create a new build configuration" tooltip-popup-delay="3500" tooltip-placement="top" tooltip-append-to-body="true" ng-click="$ctrl.openWizardModal()" pnc-requires-auth> <i class="fa fa-file-text-o"></i> Create </button> '),e.put("build-configs/directives/pnc-create-build-config-general-form/pnc-create-build-config-general-form.html",' <ng-form name="form" novalidate> <div class="form-group" ng-class="{ \'has-error\' : form.name.$invalid && form.name.$touched, \'has-success\': form.name.$valid && form.name.$touched }"> <label class="required control-label" for="build-config-name">Name</label> <input id="build-config-name" name="name" class="form-control" ng-model="$ctrl.data.name" type="text" ng-maxlength="255" ng-pattern="/^[a-zA-Z0-9_.][a-zA-Z0-9_.-]*(?!\\.git)+$/" spellcheck="false" required> <p ng-show="form.name.$invalid && form.name.$touched" class="help-block">Name is a required field.</p> <p ng-show="form.name.$error.pattern && form.name.$touched" class="help-block">Name can contain only alpha-numeric characters, hyphens, underscores and periods and cannot start with a hyphen.</p> <p ng-show="form.name.$error.maxlength && form.name.$touched" class="help-block">The maximum lengh of a name is 255 characters.</p> </div> <div class="form-group"> <label class="control-label" for="build-config-description">Description</label> <textarea id="build-config-description" name="description" class="form-control" ng-model="$ctrl.data.description"></textarea> </div> <div class="form-group" ng-class="{ \'has-error\' : form.environment.$invalid && form.environment.$touched, \'has-success\': form.environment.$valid && form.environment.$touched }"> <label class="control-label required" for="build-config-environment">Environment</label> <pnc-environment-combobox name="environment" ng-model="$ctrl.data.environment" required></pnc-environment-combobox> <p ng-show="form.environment.$invalid && form.environment.$touched" class="help-block">Environment is a required field.</p> </div> <div class="form-group" ng-class="{ \'has-error\' : form.buildType.$invalid && form.buildType.$touched, \'has-success\': form.buildType.$valid && form.buildType.$touched }"> <label class="control-label required" for="build-config-build-type">Build Type</label> <br> <select name="buildType" pf-bootstrap-select="{ noneSelectedText: \'Select Build Type\' }" ng-model="$ctrl.data.buildType" id="build-config-build-type" ng-options="buildType.id as buildType.name for buildType in $ctrl.buildTypes" required></select> <p ng-show="form.buildType.$invalid && form.buildType.$touched" class="help-block">Build Type is a required field.</p> </div> <div class="form-group" ng-class="{ \'has-error\' : form.buildScript.$invalid && form.buildScript.$touched, \'has-success\': form.buildScript.$valid && form.buildScript.$touched }"> <label class="control-label required" for="build-config-build-script">Build Script</label> <textarea id="build-config-build-script" name="buildScript" class="form-control" spellcheck="false" ng-model="$ctrl.data.buildScript" spellcheck="false" pnc-build-script-validator required></textarea> <p ng-show="form.buildScript.$invalid && form.buildScript.$touched" class="help-block">Build Script is a required field.</p> <p class="help-block" ng-show="form.buildScript.$error.invalidBuildScript && form.buildScript.$touched">The \'deploy\' lifecycle is required for maven builds in order to prevent artifact promotion issues.</p> </div> </ng-form> '),e.put("build-configs/directives/pnc-create-build-config-wizard/pnc-create-build-config-wizard.html",' <pf-wizard title="Create Build Config" next-title="$ctrl.nextButtonTitle" on-cancel="$ctrl.onClose()" on-step-changed="$ctrl.onStepChange(step, index)" on-finish="$ctrl.onClose()" wizard-done="$ctrl.wizardDone" content-height="500"> <pf-wizard-step step-title="Project" substeps="true" step-id="project" step-priority="10" substeps="true" wz-disabled="true"> <pf-wizard-substep step-title="Select" step-id="projectSelect" step-priority="0"> <p>Select Project</p> </pf-wizard-substep> </pf-wizard-step> <pf-wizard-step step-title="Build Config" substeps="true" step-id="build-config" step-priority="20" substeps="true" show-review="true" show-review-details="true"> <pf-wizard-substep step-title="General" step-id="general" step-priority="10" next-enabled="$ctrl.generalForm.$valid" show-review="true" show-review-details="true" review-template="build-configs/directives/pnc-create-build-config-wizard/review-build-config-general.html"> <form name="$ctrl.generalForm" novalidate> <pnc-create-build-config-general-form ng-model="$ctrl.wizardData.general"></pnc-create-build-config-general-form> </form> </pf-wizard-substep> <pf-wizard-substep step-title="Product Version" step-id="productVersion" step-priority="15" show-review="true" show-review-details="true" review-template="build-configs/directives/pnc-create-build-config-wizard/review-product-version.html"> <div class="form-group"> <label class="control-label">Product Version</label> <pnc-product-version-combobox ng-model="$ctrl.wizardData.productVersion"></pnc-product-version-combobox> </div> </pf-wizard-substep> <pf-wizard-substep step-title="Build Parameters" next-enabled="true" step-id="parameters" step-priority="20" show-review="true" show-review-details="false" review-template="build-configs/directives/pnc-create-build-config-wizard/review-build-parameters.html"> <pnc-select-build-parameters ng-model="$ctrl.wizardData.buildParameters"></pnc-select-build-parameters> </pf-wizard-substep> <pf-wizard-substep step-title="Dependencies" next-enabled="true" step-id="parameters" step-priority="30" show-review="true" show-review-details="false" review-template="build-configs/directives/pnc-create-build-config-wizard/review-dependencies.html"> <pnc-select-build-configs ng-model="$ctrl.wizardData.dependencies"></pnc-select-build-configs> </pf-wizard-substep> </pf-wizard-step> <pf-wizard-step step-title="Repository" substeps="true" step-id="repository" step-priority="30" next-enabled="$ctrl.repoForm.$valid" substeps="true" show-review="true" show-review-details="false" review-template="build-configs/directives/pnc-create-build-config-wizard/review-repo-config.html"> <pf-wizard-substep step-title="Select" step-id="repositorySelect" step-priority="10"> <form name="$ctrl.repoForm" novalidate> <pnc-select-repository ng-model="$ctrl.wizardData.repoConfig"></pnc-select-repository> </form> </pf-wizard-substep> </pf-wizard-step> <pf-wizard-step step-title="Review" substeps="true" step-id="review" step-priority="40"> <pf-wizard-substep step-title="Summary" step-id="review-summary" step-priority="10" next-enabled="true" prev-enabled="true" ok-to-nav-away="true" wz-disabled="false" on-show="$ctrl.onShowReviewSummary"> <pf-wizard-review-page shown="$ctrl.reviewPageShown" wizard-data="$ctrl.wizardData"></pf-wizard-review-page> </pf-wizard-substep> <pf-wizard-substep step-title="Create" step-id="review-create" step-priority="20" wz-disabled="false" on-show="$ctrl.create"> <div class="wizard-pf-contents" ng-if="!$ctrl.wizardDone && !$ctrl.createError"> <div class="wizard-pf-process blank-slate-pf"> <div class="spinner spinner-lg blank-slate-pf-icon"></div> <h5 class="blank-slate-pf-main-action">Creating Build Config</h5> </div> <ul class="list-unstyled"> <li ng-repeat="message in $ctrl.createStatusMessages">{{ message }}</li> </ul> </div> <div class="wizard-pf-contents" ng-if="$ctrl.wizardDone && !$ctrl.createError"> <div class="wizard-pf-complete blank-slate-pf"> <div class="wizard-pf-success-icon"><span class="glyphicon glyphicon-ok-circle"></span></div> <h5 class="blank-slate-pf-main-action">Build Config Creation Successful</h5> <p class="blank-slate-pf-secondary-action">Your Build Config was created successfully.</p> <a role="button" class="btn btn-lg btn-primary" ui-sref="projects.detail.build-configs.detail({ projectId: $ctrl.wizardData.project.id, configurationId: $ctrl.createdBuildConfigId })" ng-click="$ctrl.onClose()" href>View Build Config</a> </div> </div> <div class="wizard-pf-contents" ng-if="$ctrl.createError"> <div class="wizard-pf-complete blank-slate-pf"> <div class="wizard-pf-error-icon"><span class="glyphicon glyphicon-remove-circle"></span></div> <h5 class="blank-slate-pf-main-action">Error</h5> <pnc-reopen-build-config-button initial-values="$ctrl.wizardData" ng-click="$ctrl.closePreviousWizardModal()"></pnc-reopen-build-config-button> </div> <ul class="list-unstyled"> <li ng-repeat="message in $ctrl.createStatusMessages">{{ message }}</li> </ul> </div> </pf-wizard-substep> </pf-wizard-step> </pf-wizard> '),e.put("build-configs/directives/pnc-create-build-config-wizard/review-build-config-general.html",' <form class="form"> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">Name:</span> <span class="wizard-pf-review-item-value">{{ $ctrl.wizardData.general.name }}</span> </div> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">Description:</span> <span class="wizard-pf-review-item-value">{{ $ctrl.wizardData.general.description }}</span> </div> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">Environment:</span> <span class="wizard-pf-review-item-value">{{ $ctrl.wizardData.general.environment.name }}</span> </div> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">Build Type:</span> <span class="wizard-pf-review-item-value">{{ $ctrl.wizardData.general.buildType }}</span> </div> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">Build Script:</span><br> <span class="wizard-pf-review-item-value"><pre>{{ $ctrl.wizardData.general.buildScript }}</pre></span> </div> </form> '),e.put("build-configs/directives/pnc-create-build-config-wizard/review-build-parameters.html",' <form class="form"> <div class="wizard-pf-review-item" ng-repeat="(key, value) in $ctrl.wizardData.buildParameters"> <span class="wizard-pf-review-item-label">{{ key }}</span><br> <span class="wizard-pf-review-item-value text-monospace"><pre>{{ value }}</pre></span> </div> </form> '),e.put("build-configs/directives/pnc-create-build-config-wizard/review-dependencies.html",' <form class="form"> <div class="wizard-pf-review-item" ng-repeat="dependency in $ctrl.wizardData.dependencies"> <ul> <li><span class="wizard-pf-review-item-value">{{ dependency.name }}</span></li> </ul> </div> </form> '),e.put("build-configs/directives/pnc-create-build-config-wizard/review-product-version.html",' <form class="form"> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">Product Version:</span> <span class="wizard-pf-review-item-value"> <span ng-if="$ctrl.wizardData.productVersion">{{ $ctrl.wizardData.productVersion.productName }} / v{{ $ctrl.wizardData.productVersion.version }}</span> <span ng-if="!$ctrl.wizardData.productVersion">None</span> </span> </div> </form> '),e.put("build-configs/directives/pnc-create-build-config-wizard/review-repo-config.html",' <form class="form"> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">SCM URL:</span> <span class="wizard-pf-review-item-value">{{ $ctrl.wizardData.repoConfig.scmUrl }}</span> </div> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">Revision:</span> <span class="wizard-pf-review-item-value">{{ $ctrl.wizardData.repoConfig.revision }}</span> </div> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">Pre-build sync:</span> <span class="wizard-pf-review-item-value">{{ $ctrl.wizardData.repoConfig.preBuildSyncEnabled }}</span> </div> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">Existing Repo Config:</span> <span class="wizard-pf-review-item-value">{{ $ctrl.wizardData.repoConfig.useExistingRepoConfig }}</span> </div> </form> '),e.put("build-configs/directives/pnc-generic-parameters/pnc-generic-parameters.html",' <div class="form-group"> <label for="input-build-group-configs" class="col-sm-2 control-label">Key</label> <div class="col-sm-10"> <pnc-select-items single-item="true" custom-item="true" selected-items="genericParameter.key.selected" select-id="genericParameterKey" select-name="genericParameterKey" placeholder="Scroll & Filter Keys..." items="genericParameter.key.suggestions" item-id="genericParameter.key.selectedId" control="genericParameter.key.control"> </pnc-select-items> </div> </div> <div class="form-group"> <label for="input-build-group-configs" class="col-sm-2 control-label">Value</label> <div class="col-sm-10"> <textarea name="genericParameterValue" id="genericParameterValue" class="form-control" ng-model="genericParameter.value"></textarea> </div> </div> <div class="form-group"> <label for="input-build-group-configs" class="col-sm-2 control-label"></label> <div class="col-sm-10"> <span class="btn btn-default" ng-click="addGenericParameter()" ng-disabled="!genericParameter.key.selectedId || !genericParameter.value">Add Generic Parameter</span> </div> </div> <div class="form-group"> <label for="input-build-group-configs" class="col-sm-2 control-label">Added Parameters</label> <div class="col-sm-10"> <ul class="reset-style"> <li ng-repeat="(key, value) in genericParameters" class="clearfix"> <button type="button" class="close pull-left m-r-5 p-t-2" aria-label="Close" ng-click="removeGenericParameter(key)" title="Remove parameter"><span aria-hidden="true">×</span></button> <div class="pull-right w-100-20"> <tt>{{key}}</tt> : <pre>{{value}}</pre> </div> </li> </ul> </div> </div>'),e.put("build-configs/directives/pnc-internal-external-url/pnc-internal-external-url.html",' <div class="panel panel-default"> <div class="panel-heading text-center"> <strong>SCM</strong><strong ng-hide="singleScm">s</strong> <small ng-hide="singleScm"><em>(at least of one of them must be specified)</em></small> </div> <div class="list-group"> <div class="list-group-item" ng-hide="singleScm"> <div class="text-center"> When the internal SCM is not specified, it will be cloned from the external one. </div> </div> <div class="list-group-item"> <div class="row" ng-hide="singleScm"> <div class="text-right-sm p-b-10" ng-class="sidebarClass"> <strong class="text-uppercase">Internal</strong> </div> </div> <div class="form-group" ng-class="{ \'has-error\': form.scmUrl.$invalid && form.scmUrl.$touched, \'has-success\': form.scmUrl.$valid && form.scmUrl.$touched }"> <div ng-if="!singleScm"> <label for="input-scm-repo-url" class="control-label" ng-class="sidebarClass">* Url</label> <div ng-class="contentClass"> <input type="text" id="input-scm-repo-url" class="form-control" name="scmUrl" maxlength="255" ng-model="data.scmUrl" ng-required="!data.externalScmUrl" pnc-scm-validator="git+ssh" pnc-exact-host="exactHost"> <span class="help-block" ng-show="form.scmUrl.$error.required && form.scmUrl.$touched">At least one of the SCMs is required.</span> <span class="help-block" ng-show="form.scmUrl.$error.invalidScmUrl"> <span ng-show="exactHost">Only R/W SCM with the following format <code>git+ssh://{{exactHost}}/&lt;repository-name&gt;.git</code> is allowed.</span> <span ng-hide="exactHost">Invalid or unsupported format (only git+ssh:// is supported).</span> </span> </div> </div> <div ng-if="singleScm"> <label for="input-scm-repo-url-single-scm" class="control-label" ng-class="sidebarClass">* Url</label> <div ng-class="contentClass"> <input type="text" id="input-scm-repo-url-single-scm" class="form-control" name="scmUrl" maxlength="255" ng-model="data.scmUrl" pnc-scm-validator="git|ssh|http|https|git+ssh|git@" required> <span class="help-block" ng-show="form.scmUrl.$error.required && form.scmUrl.$touched">Required field.</span> <span class="help-block" ng-show="form.scmUrl.$error.invalidScmUrl">Invalid or unsupported format.</span> </div> </div> </div> <div class="form-group" ng-class="{ \'has-error\': form.scmRevision.$invalid && form.scmRevision.$touched, \'has-success\': form.scmRevision.$valid && form.scmRevision.$touched }"> <label for="input-scm-revision" class="control-label" ng-class="sidebarClass">* Revision</label> <div ng-class="contentClass"> <input id="input-scm-revision" class="form-control" name="scmRevision" maxlength="255" ng-model="data.scmRevision" ng-required="data.scmUrl"> <span class="help-block" ng-show="form.scmRevision.$error.required && form.scmRevision.$touched">Required field.</span> </div> </div> </div> <div class="list-group-item" ng-hide="singleScm"> <div class="row"> <div class="text-right-sm p-b-10" ng-class="sidebarClass"> <strong class="text-uppercase">External</strong> </div> </div> <div class="form-group" ng-class="{ \'has-error\': form.externalScmUrl.$invalid && form.externalScmUrl.$touched, \'has-success\': form.externalScmUrl.$valid && form.externalScmUrl.$touched }"> <label for="input-scm-repo-url-external" class="control-label" ng-class="sidebarClass">* Url</label> <div ng-class="contentClass"> <input type="text" id="input-scm-repo-url-external" class="form-control" name="externalScmUrl" maxlength="255" ng-model="data.externalScmUrl" ng-required="!data.scmUrl" pnc-scm-validator="git|ssh|http|https|git+ssh|git@"> <span class="help-block" ng-show="form.externalScmUrl.$error.required && form.externalScmUrl.$touched">At least one of the SCMs is required.</span> <span class="help-block" ng-show="form.externalScmUrl.$error.invalidScmUrl">Invalid or unsupported format.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': form.externalScmRevision.$invalid && form.externalScmRevision.$touched, \'has-success\': form.externalScmRevision.$valid && form.externalScmRevision.$touched }"> <label for="input-scm-revision-external" class="control-label" ng-class="sidebarClass">* Revision</label> <div ng-class="contentClass"> <input id="input-scm-revision-external" class="form-control" name="externalScmRevision" maxlength="255" ng-model="data.externalScmRevision" ng-required="data.externalScmUrl"> <span class="help-block" ng-show="form.externalScmRevision.$error.required && form.externalScmRevision.$touched">Required field.</span> </div> </div> </div> </div> </div> '),e.put("build-configs/directives/pnc-reopen-build-config-button/pnc-reopen-build-config-button.html",' <button type="button" class="btn btn-lg btn-primary" uib-tooltip="Reopen wizard to correct submitted data" tooltip-popup-delay="3500" tooltip-placement="top" tooltip-append-to-body="true" ng-click="$ctrl.reopenWizardModal()" pnc-requires-auth>Correct Submitted Data</button> '),e.put("build-configs/directives/pnc-select-build-configs/pnc-select-build-configs.html",' <div> <ng-form name="dependenciesForm"> <div class="clearfix"> <div class="form-group"> <label class="control-label">Select dependencies</label> <pnc-build-config-combobox ng-model="$ctrl.buildConfig"></pnc-build-config-combobox> </div> <div class="btn-group pull-right" role="group" aria-label="..."> <button type="button" class="btn btn-primary" ng-click="$ctrl.add($ctrl.buildConfig)" ng-disabled="dependenciesForm.$invalid">Add</button> </div> </div> <div> <pf-list-view class="list-group list-view-pf list-view-pf-view" id="remove-build-groups-{{::$id}}" config="$ctrl.listConfig" items="$ctrl.buildConfigs" action-buttons="$ctrl.listActionButtons" ng-if="$ctrl.buildConfigs.length > 0"> <div class="list-view-pf-description"> <div class="list-group-item-heading"> {{ item.name }} </div> </div> </pf-list-view> <p ng-if="$ctrl.buildConfigs.length === 0"><em>No dependencies selected</em></p> </div> </ng-form> </div> '),e.put("build-configs/directives/pnc-select-build-parameters/pnc-display-build-parameters.html",' <div> <div ng-repeat="(key, value) in $ctrl.currentParams"> <div class="row"> <p> <div class="btn-group pull-right" role="group" aria-label="..."> <button class="btn btn-sm btn-link" ng-click="$ctrl.toggleEdit(key)">Edit</button> <button class="btn btn-sm btn-link" ng-click="$ctrl.remove(key)">Remove</button> </div> <span>{{ key }}</span> <p></p> <div ng-hide="$ctrl.isEditOn(key)"> <pre>{{ value }}</pre> </div> </div> <div ng-show="$ctrl.isEditOn(key)" class="clearfix"> <pf-form-group> <textarea ng-model="$ctrl.currentParams[key]" class="form-control" rows="3"></textarea> </pf-form-group> <div class="pull-right"> <button class="btn btn-primary" ng-click="$ctrl.update(key, $ctrl.currentParams[key])">Update</button> <button class="btn btn-default" ng-click="$ctrl.cancel(key)">Cancel</button> </div> </div> </div> </div> '),e.put("build-configs/directives/pnc-select-build-parameters/pnc-enter-build-parameters.html",' <script type="text/ng-template" id="pnc-enter-build-parameters/combobox-option-template.html"> <a ng-click="$ctrl.select(option)" href><strong>{{ option.name }}</strong> - {{ option.description }}</a> <\/script> <div class="form-group"> <label class="control-label">Key</label> <px-combobox px-expression="key.name for key in $ctrl.searchKnownKeys($viewValue)" ng-model="$ctrl.key" editable="true" placeholder="Select or input parameter key" option-template-url="pnc-enter-build-parameters/combobox-option-template.html"></px-combobox> </div> <div class="form-group"> <label class="control-label">Value</label> <textarea ng-model="$ctrl.value" class="form-control" rows="3"></textarea> </div> <div class="form-group pull-right"> <button type="button" class="btn btn-primary" ng-click="$ctrl.add()">Add</button> <button type="button" class="btn btn-default" ng-click="$ctrl.clear()">Clear</button> </div> '),e.put("build-configs/directives/pnc-select-build-parameters/pnc-select-build-parameters.html",' <form class="form-horizontal"> <div> <pnc-enter-build-parameters class="clearfix" on-add="$ctrl.addParam(key, value)" known-keys="$ctrl.knownKeys"></pnc-enter-build-parameters> </div> <hr ng-if="$ctrl.hasParams()"> <div> <pnc-display-build-parameters params="$ctrl.params" on-edit="$ctrl.addParam(key, value)" on-remove="$ctrl.removeParam(key)"> </pnc-display-build-parameters> </div> </form> '),e.put("build-configs/directives/pnc-select-repository/pnc-select-repository.html",' <ng-form name="form" novalidate> <div class="form-group" ng-class="{ \'has-error\' : form.repositoryUrl.$invalid && form.repositoryUrl.$touched, \'has-success\': form.repositoryUrl.$valid && form.repositoryUrl.$touched }"> <label class="required control-label">Repository URL</label> <input type="text" name="repositoryUrl" class="form-control" ng-model="$ctrl.userData.scmUrl" ng-model-options="{ debounce: 500 }" pnc-scm-validator="git|ssh|http|https|git+ssh" ng-change="$ctrl.checkForRepo($ctrl.userData.scmUrl)" required> <p class="help-block" ng-show="form.repositoryUrl.$invalid && form.repositoryUrl.$touched">Repository URL is a required field.</p> <p class="help-block" ng-show="form.repositoryUrl.$error.invalidScmUrl && form.repositoryUrl.$touched">Invalid Repository URL</p> </div> <div class="form-group" ng-class="{ \'has-error\' : form.revision.$invalid && form.revision.$touched, \'has-success\': form.revision.$valid && form.revision.$touched }"> <label class="required control-label">Revision</label> <input name="revision" type="text" class="form-control" ng-model="$ctrl.userData.revision" required> <p class="help-block" ng-show="form.revision.$invalid && form.revision.$touched">Revision is a required field.</p> </div> <div class="alert alert-danger" ng-if="$ctrl.multipleRCError"> <span class="pficon pficon-error-circle-o"></span> Multiple Repository Configurations were found for this URL. This behaviour is currently unsupported. </div> <div class="row"> <div ng-if="!ctrl.isLoading() && $ctrl.isRepoInternal($ctrl.userData.scmUrl) && !$ctrl.userData.selectedRepoConfig"> <div class="alert alert-info"> <span class="pficon pficon-info"></span> The URL you have entered points to an <strong>internal</strong> repository. The repository will <strong>not</strong> be created if it does not exist. </div> </div> </div> <div class="form-group" ng-if="!$ctrl.isLoading() && !$ctrl.isRepoInternal($ctrl.userData.scmUrl) && !$ctrl.userData.selectedRepoConfig"> <div class="checkbox"> <label> <input type="checkbox" ng-model="$ctrl.userData.preBuildSyncEnabled">Pre-build Sync </label> </div> </div> <div class="row" ng-if="!$ctrl.isLoading() && $ctrl.userData.selectedRepoConfig"> <div class="alert alert-info"> <span class="pficon pficon-info"></span> <p>This {{ $ctrl.isRepoInternal($ctrl.userData.scmUrl) ? \'internal\' : \'external\' }} repository is already synced. </p> <br> <p><strong>Internal URL</strong>: <br>{{ $ctrl.userData.selectedRepoConfig.internalUrl }}</p> <p><strong>External URL</strong>: <br>{{ $ctrl.userData.selectedRepoConfig.externalUrl }}</p> <div class="checkbox"> <label> <input type="checkbox" ng-model="$ctrl.userData.selectedRepoConfig.preBuildSyncEnabled" disabled>Pre-build Sync </label> </div> </div> </div> <div class="row text-center" ng-show="$ctrl.isLoading()"> <span class="spinner spinner-xl spinner-inline"></span> </div> </ng-form> '),e.put("build-configs/views/build-configs.create.html",' <div> <div class="page-header"> <h1>Create Build Configuration</h1> </div> <div class="row"> <div class="col-md-10 col-lg-7"> <pnc-configuration-create-panel></pnc-configuration-create-panel> </div> </div> </div> '),e.put("build-configs/views/build-configs.detail-main.html",' <div> <pnc-header> <pnc-header-title>{{ detailCtrl.configuration.name || \'Empty\' }}</pnc-header-title> <pnc-header-buttons> <pnc-build-start build-config="detailCtrl.configuration"></pnc-build-start> <button type="button" class="btn btn-lg btn-default" uib-tooltip="Clone Build Config" tooltip-placement="top" tooltip-append-to-body="true" tooltip-popup-delay="2500" ng-click="detailCtrl.clone()" pnc-requires-auth><i class="fa fa-files-o"></i> Clone</button> <button type="button" class="btn btn-lg btn-default" uib-tooltip="Edit Build Config" tooltip-placement="top" tooltip-append-to-body="true" tooltip-popup-delay="2500" ng-click="configurationForm.$show()" ng-class="{ \'active\': configurationForm.$visible }" pnc-requires-auth><i class="pficon pficon-edit"></i> Edit</button> <button type="button" class="btn btn-lg btn-danger" uib-tooltip="Delete Build Config" tooltip-placement="top" tooltip-append-to-body="true" tooltip-popup-delay="2500" pnc-confirm-click="detailCtrl.delete()" pnc-confirm-message="{{ \'Confirm the deletion of Build Configuration: \' + detailCtrl.configuration.name + \' ?\'}}" pnc-requires-auth><i class="pficon pficon-delete"></i> Delete</button> </pnc-header-buttons> </pnc-header> <div class="row"> <div class="col-md-12"> <form editable-form class="form-horizontal" name="configurationForm" onbeforesave="detailCtrl.update()" novalidate> <div class="form-group" ng-class="{ \'has-error\' : configurationForm.name.$invalid && configurationForm.name.$touched, \'has-success\': configurationForm.name.$valid && configurationForm.name.$touched }"> <label for="input-name" class="col-sm-2 control-label" ng-class="{ \'required\': configurationForm.$visible }">Name</label> <div class="col-sm-10"> <p id="input-name" class="form-control-static" e-pattern="^[a-zA-Z0-9_.][a-zA-Z0-9_.-]*(?!\\.git)+$" e-class="form-control" editable-text="detailCtrl.configuration.name" e-name="name" e-maxlength="255" e-required>{{ detailCtrl.configuration.name || \'Empty\' }}</p> <span class="help-block" ng-show="configurationForm.name.$error.required && configurationForm.name.$touched">Required field.</span> <span class="help-block" ng-show="configurationForm.name.$error.pattern && configurationForm.name.$touched">The name contains not allowed characters (e.g spaces, commas, semicolons, apex, quotes) </span> </div> </div> <div class="form-group"> <label for="static-project" class="col-sm-2 control-label">Project</label> <div class="col-sm-10"> <p id="static-project" class="form-control-static"> <a ui-sref="projects.detail({projectId: detailCtrl.configuration.project.id})" href> {{ detailCtrl.configuration.project.name }} </a> </p> </div> </div> <div class="form-group"> <label for="static-description" class="col-sm-2 control-label">Description</label> <div class="col-sm-10"> <p id="static-description" class="form-control-static" e-class="form-control" editable-textarea="detailCtrl.configuration.description" e-name="description">{{ detailCtrl.configuration.description || \'Empty\' }}</p> </div> </div> <div class="form-group" ng-hide="configurationForm.$visible"> <label for="input-scm-repo-url" class="col-sm-2 control-label">Internal SCM URL</label> <div class="col-sm-10"> <p id="input-scm-repo-url" class="form-control-static"> <span ng-show="detailCtrl.configuration.repositoryConfiguration.internalUrl">{{ detailCtrl.configuration.repositoryConfiguration.internalUrl }}</span> <span ng-hide="detailCtrl.configuration.repositoryConfiguration.internalUrl">&mdash;</span> </p> </div> </div> <div class="form-group" ng-hide="configurationForm.$visible"> <label for="input-external-scm-repo-url" class="col-sm-2 control-label">External SCM URL</label> <div class="col-sm-10"> <p id="input-external-scm-repo-url" class="form-control-static"> <span ng-show="detailCtrl.configuration.repositoryConfiguration.externalUrl">{{ detailCtrl.configuration.repositoryConfiguration.externalUrl }}</span> <span ng-hide="detailCtrl.configuration.repositoryConfiguration.externalUrl">&mdash;</span> </p> </div> </div> <div class="form-group" ng-hide="configurationForm.$visible"> <label for="input-prebuild-sync" class="col-sm-2 control-label">Pre-build sync</label> <div class="col-sm-10"> <p id="input-prebuild-sync" class="form-control-static">{{ detailCtrl.configuration.repositoryConfiguration.preBuildSyncEnabled ? \'enabled\' : \'disabled\' }}</p> </div> </div> <div class="form-group" ng-if="configurationForm.$visible" ng-class="{ \'has-error\' : configurationForm.repositoryConfiguration.$invalid && configurationForm.repositoryConfiguration.$touched, \'has-success\': configurationForm.repositoryConfiguration.$valid && configurationForm.repositoryConfiguration.$touched }"> <label for="input-repository-configuration-id" class="col-sm-2 control-label required">Repository Configuration</label> <div class="col-sm-10"> <pnc-repository-configuration-combobox name="repositoryConfiguration" ng-model="detailCtrl.configuration.repositoryConfiguration" required></pnc-repository-configuration-combobox> <span class="help-block" ng-show="configurationForm.repositoryConfiguration.$invalid && configurationForm.repositoryConfiguration.$touched">Required field.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': configurationForm.scmRevision.$invalid && configurationForm.scmRevision.$touched, \'has-success\': configurationForm.scmRevision.$valid && configurationForm.scmRevision.$touched }"> <label for="input-scm-revision" class="col-sm-2 control-label" ng-class="{ \'required\': configurationForm.$visible }">SCM Revision</label> <div class="col-sm-10"> <p id="input-scm-revision" class="form-control-static" e-class="form-control" editable-text="detailCtrl.configuration.scmRevision" e-name="scmRevision" e-maxlength="255">{{ detailCtrl.configuration.scmRevision || \'Empty\' }}</p> <span class="help-block" ng-show="configurationForm.scmRevision.$error.required && configurationForm.scmRevision.$touched">Required field.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': configurationForm.buildScript.$invalid && configurationForm.buildScript.$touched, \'has-success\': configurationForm.buildScript.$valid && configurationForm.buildScript.$touched }"> <label for="input-build-script" class="col-sm-2 control-label" ng-class="{ \'required\': configurationForm.$visible }">Build Script</label> <div class="col-sm-10"> <pre e-required id="input-build-script" e-class="form-control" editable-textarea="detailCtrl.configuration.buildScript" e-name="buildScript">{{ detailCtrl.configuration.buildScript || \'Empty\' }}</pre> <span class="help-block" ng-show="configurationForm.buildScript.$error.required && configurationForm.buildScript.$touched">Required field.</span> </div> </div> <div class="form-group"> <label for="static-created" class="col-sm-2 control-label">Created</label> <div class="col-sm-10"> <p id="static-created" class="form-control-static">{{ detailCtrl.configuration.creationTime | date:\'medium\'}}</p> </div> </div> <div class="form-group"> <label for="static-modified" class="col-sm-2 control-label">Modified</label> <div class="col-sm-10"> <p id="static-modified" class="form-control-static">{{ detailCtrl.configuration.lastModificationTime | date:\'medium\'}}</p> </div> </div> <div class="form-group"> <label for="input-product-versions" class="col-sm-2 control-label">Product Versions</label> <div class="col-sm-10"> <ul class="list-inline form-control-static" ng-hide="configurationForm.$visible"> <li ng-repeat="version in detailCtrl.productVersions.selected"> <a href ui-sref="product.detail.version({ productId: version.productId, versionId: version.id })"><span class="text-bold">{{ version.productName }}</span> - {{ version.version }}</a> </li> </ul> <pnc-infinite-select-product-versions ng-show="configurationForm.$visible" single-item="true" selected-items="detailCtrl.productVersions.selected" infinite-select-required="false" infinite-select-id="input-pv" placeholder="Scroll & Filter Product Versions..." items="detailCtrl.products" item-id="product.id"> </pnc-infinite-select-product-versions> </div> </div> <div class="form-group"> <label for="input-dependencies" class="col-sm-2 control-label">Dependencies</label> <div class="col-sm-10"> <ul class="list-unstyled form-control-static" ng-hide="configurationForm.$visible"> <li ng-repeat="dependency in detailCtrl.dependencies.selected"> <a href ui-sref="projects.detail.build-configs.detail({ projectId: dependency.project.id, configurationId: dependency.id })">{{ dependency.name }}</a> </li> </ul> <pnc-infinite-select-items ng-show="configurationForm.$visible" selected-items="detailCtrl.dependencies.selected" infinite-select-required="false" infinite-select-id="input-dependencies" placeholder="Scroll & Filter Dependencies..." items="detailCtrl.configurations"></pnc-infinite-select-items> </div> </div> <div class="form-group" ng-class="{ \'has-error\' : !detailCtrl.environment.id, \'has-success\': detailCtrl.environment.id && configurationForm.environmentId.$touched }"> <label for="input-environment" class="col-sm-2 control-label" ng-class="{ \'required\': configurationForm.$visible }">Environment</label> <div class="col-sm-10"> <p ng-hide="configurationForm.$visible" id="input-environment" class="form-control-static">{{ detailCtrl.environment.name }}</p> <pnc-infinite-select-items ng-show="configurationForm.$visible" single-item="true" selected-items="detailCtrl.environmentSelection.selected" infinite-select-required="true" infinite-select-id="environmentId" placeholder="Scroll & Filter Environments..." items="detailCtrl.environments" item-id="detailCtrl.environment.id"> </pnc-infinite-select-items> <span class="help-block" ng-show="!detailCtrl.environment.id">Required field.</span> </div> </div> <div class="form-group"> <label for="input-build-group-configs" class="col-sm-2 control-label">Build Group Configs</label> <div class="col-sm-10"> <ul class="list-unstyled form-control-static" ng-hide="configurationForm.$visible"> <li ng-repeat="buildgroupconfig in detailCtrl.buildgroupconfigs.selected"> <a href ui-sref="build-groups.detail.build-configs({ configurationSetId: buildgroupconfig.id })">{{ buildgroupconfig.name }}</a> </li> </ul> <pnc-infinite-select-items ng-show="configurationForm.$visible" selected-items="detailCtrl.buildgroupconfigs.selected" infinite-select-required="false" infinite-select-id="input-build-group-configs" placeholder="Scroll & Filter Build Group Configs..." items="detailCtrl.configurationSetList"></pnc-infinite-select-items> </div> </div> <div class="form-group" ng-hide="configurationForm.$visible"> <label for="input-build-group-configs" class="col-sm-2 control-label">Generic Parameters</label> <div class="col-sm-10"> <ul class="list-unstyled form-control-static"> <li ng-repeat="(key, value) in detailCtrl.configuration.genericParameters"> <tt>{{key}}</tt> : <pre>{{value}}</pre> </li> </ul> </div> </div> <div ng-show="configurationForm.$visible"> <hr> <div class="row"> <div class="col-sm-2"> <strong class="text-uppercase">Generic Parameters</strong> </div> </div> <pnc-generic-parameters generic-parameters="detailCtrl.configuration.genericParameters" control="detailCtrl.genericParametersControl"> </pnc-generic-parameters> <hr> </div> <div class="form-group" ng-show="configurationForm.$visible"> <div class="col-sm-offset-2 col-sm-10"> <button type="submit" class="btn btn-primary" ng-disabled="configurationForm.$waiting || configurationForm.$invalid || !detailCtrl.environment.id"> Save </button> <button type="button" class="btn btn-default" ng-disabled="configurationForm.$waiting" ng-click="detailCtrl.cancel(configurationForm)"> Cancel </button> </div> </div> </form> </div> </div> </div> '),e.put("build-configs/views/build-configs.detail-sidebar.html",' <div class="push-down"> <pnc-builds-history build-config="sidebarCtrl.buildConfiguration"></pnc-builds-history> </div> '),e.put("build-configs/views/build-configs.list.html",' <div> <pnc-header> <pnc-header-title>Build Configs</pnc-header-title> </pnc-header> <pnc-search-field class="search" page="listCtrl.configurations" text="build configs"></pnc-search-field> <table class="table table-bordered table-striped table-hover"> <thead> <th>Name</th> <th>Description</th> <th>Project</th> <th>SCM Repository</th> <th>SCM Revision</th> <th>Created</th> <th>Modified</th> </thead> <tbody> <tr ng-repeat="configuration in listCtrl.configurations.data"> <td> <a ui-sref="projects.detail.build-configs.detail({ projectId: configuration.project.id, configurationId: configuration.id })" href> {{ configuration.name }} </a> </td> <td>{{ configuration.description }}</td> <td> <a ui-sref="projects.detail({projectId: configuration.project.id})" href> {{ configuration.project.name }} </a> </td> <td>{{ configuration.scmRepoURL }}</td> <td>{{ configuration.scmRevision }}</td> <td>{{ configuration.creationTime | date:\'medium\'}}</td> <td>{{ configuration.lastModificationTime | date:\'medium\'}}</td> </tr> </tbody> </table> <pnc-pager class="pull-right" page="listCtrl.configurations"></pnc-pager> </div> '),e.put("build-groups/directives/pnc-build-group-build-configs/pnc-build-group-build-configs.html",' <script type="text/ng-template" id="pnc-build-group-build-config-actions-template"> <div class="btn-group" role="group" aria-label="Item Actions">\n    <button class="btn btn-block btn-default" uib-tooltip="Remove Build Configuration from Build Group" tooltip-popup-delay="2500" tooltip-placement="top" tooltip-append-to-body="true" pnc-confirm-click="actions.remove(buildConfig)" pnc-confirm-message="{{ \'Confirm the removal of Build Configuration: \' + buildConfig.name +  \' from this Build Group?\'}}">Remove</button>\n  </div> <\/script> <div ng-show="$ctrl.showTable"> <div> <div class="toolbar-search-right pull-right"> <pnc-search-field page="$ctrl.page" text="build configs"></pnc-search-field> </div> <div class="btn-group pull-right"> <button type="button" class="btn btn-default" uib-tooltip="Add an existing Build Config" tooltip-popup-delay="2500" tooltip-placement="top" tooltip-append-to-body="true" ng-click="$ctrl.edit()"> <i class="pficon pficon-edit"></i> Edit </button> </div> </div> <div class="row"> <div class="col-md-12"> <pnc-build-configs-list build-configs="$ctrl.page.data" display-fields="$ctrl.displayFields" actions-data="$ctrl.actionsData" actions-template-url="pnc-build-group-build-config-actions-template"></pnc-build-configs-list> <pnc-pager class="pull-right" page="$ctrl.page"></pnc-pager> </div> </div> </div> <div ng-hide="$ctrl.showTable"> <div class="blank-slate-pf"> <div class="blank-slate-pf-icon"> <span class="pficon pficon pficon-add-circle-o"></span> </div> <h2>Empty Build Group</h2> <p> This Build Group does not contain any Build Configs, click below to add some. </p> <div class="blank-slate-pf-main-action"> <button class="btn btn-primary btn-lg" ng-click="$ctrl.edit()" pnc-requires-auth><span class="fa fa-plus"></span>&nbsp;Add Build Configs</button> </div> </div> </div> '),e.put("build-groups/directives/pnc-build-group-build-history/pnc-build-group-build-history.html",' <div> <pnc-build-records-list build-group-records="$ctrl.page.data"></pnc-build-records-list> <pnc-page-controls class="pull-right m-t-10" pnc-page="$ctrl.page" ng-if="$ctrl.page"></pnc-page-controls> </div> '),e.put("build-groups/views/build-groups.add.configuration.html",' <div> <div class="page-header"> <h1>Add Build Config to {{ addConfigurationSetCtrl.configurationSetDetail.name }}</h1> </div> <form class="form-horizontal" name="configurationSetAddForm" ng-submit="addConfigurationSetCtrl.submit()"> <div class="form-group"> <label for="input-project" class="col-sm-2 control-label">Project</label> <div class="col-sm-10"> <select id="input-project" ng-model="addConfigurationSetCtrl.data.selectedProjectId" ng-change="addConfigurationSetCtrl.getBuildConfigurations(addConfigurationSetCtrl.data.selectedProjectId)"> <option value=""></option> <option ng-repeat="project in addConfigurationSetCtrl.projects" value="{{ project.id }}"> {{ project.name }} </option> </select> </div> </div> <div class="form-group"> <label for="input-project" class="col-sm-2 control-label">Build Config</label> <div class="col-sm-10"> <select ng-model="addConfigurationSetCtrl.data.configurationId"> <option ng-repeat="configuration in addConfigurationSetCtrl.configurations" value="{{ configuration.id }}"> {{ configuration.name }} </option> </select> </div> </div> <div class="form-group"> <label for="input-project" class="col-sm-2 control-label">Disable Version Filter</label> <div class="col-sm-10"> <input type="checkbox" ng-model="addConfigurationSetCtrl.shouldFilter"> </div> </div> <div class="form-group"> <div class="col-sm-offset-2 col-sm-10"> <input type="submit" class="btn btn-primary" value="Add"> <input type="reset" class="btn btn-default" value="Clear" ng-click="addConfigurationSetCtrl.reset()"> </div> </div> </form> </div> '),e.put("build-groups/views/build-groups.create.html",' <div> <div class="page-header"> <h1>Create Build Group</h1> </div> <div class="row"> <div class="col-md-10 col-lg-7"> <form class="form-horizontal" name="configurationSetForm" ng-submit="createSetCtrl.submit()" novalidate> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\': configurationSetForm.name.$invalid && !configurationSetForm.name.$pristine, \'has-success\': configurationSetForm.name.$valid && configurationSetForm.name.$touched }"> <label for="input-name" class="col-sm-2 control-label"> * Name </label> <div class="col-sm-10"> <input id="input-name" class="form-control" name="name" maxlength="255" ng-model="createSetCtrl.data.name" required> <span class="help-block" ng-show="configurationSetForm.name.$error.required && !configurationSetForm.name.$pristine">Required field.</span> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group"> <label for="input-product-versions" class="col-sm-2 control-label">Product Versions</label> <div class="col-sm-10 col-md-5"> <pnc-infinite-select-product-versions single-item="true" selected-items="createSetCtrl.productVersions.selected" infinite-select-required="false" infinite-select-id="input-pv" placeholder="Scroll & Filter Product Versions..." items="createSetCtrl.products" item-id="createSetCtrl.data.productVersionId"> </pnc-infinite-select-product-versions> </div> </div> </div> </div> <div class="form-group text-right"> <div class="col-sm-offset-2 col-sm-10"> <input type="submit" class="btn btn-primary" value="Create" ng-disabled="configurationSetForm.$invalid"> <input type="reset" class="btn btn-default" value="Clear" ng-click="createSetCtrl.reset(configurationSetForm)"> </div> </div> </form> </div> </div> </div> '),e.put("build-groups/views/build-groups.detail.html",' <div class="row m-b-20"> <div class="col-md-12"> <pnc-header> <pnc-header-title>Build Group</pnc-header-title> <pnc-header-buttons> <div class="btn-group" role="group" aria-label="Build controls"> <pnc-build-start build-group="detailSetCtrl.set"></pnc-build-start> </div> <div class="btn-group" role="group" aria-label="Other controls"> <button type="button" class="btn btn-lg btn-default" uib-tooltip="Edit Build Group" tooltip-popup-delay="2500" tooltip-placement="top" tooltip-append-to-body="true" ng-click="setEditForm.$show()" ng-class="{ \'active\': setEditForm.$visible }" pnc-requires-auth> <i class="pficon pficon-edit"></i> Edit </button> <button type="button" class="btn btn-lg btn-danger" uib-tooltip="Delete Build Group" tooltip-popup-delay="2500" tooltip-placement="top" tooltip-append-to-body="true" pnc-confirm-click="detailSetCtrl.delete()" pnc-confirm-message="{{ \'Confirm the deletion of Build Configuration Set: \' + detailSetCtrl.set.name + \' ?\'}}" pnc-requires-auth> <i class="pficon pficon-delete"></i> Delete </button> <div class="btn-group dropdown dropdown-kebab-pf"> <button class="btn btn-default dropdown-toggle" type="button" id="dropdownKebab" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true" pnc-requires-auth> <span class="fa fa-ellipsis-v"></span> </button> <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownKebab"> <li><a ng-click="detailSetCtrl.linkWithProductVersion()" ng-hide="detailSetCtrl.set.productVersionId" href><i class="fa fa-link" aria-hidden="true"></i> Link With Product Version</a></li> <li><a ng-show="detailSetCtrl.set.productVersionId" pnc-confirm-click="detailSetCtrl.unlinkFromProductVersion()" pnc-confirm-message="{{ \'Are you sure you want to unlink \' + detailSetCtrl.set.name + \' from its product version?\' }}" href><i class="fa fa-chain-broken" aria-hidden="true"></i> Unlink From Product Version</a></li> </ul> </div> </div> </pnc-header-buttons> </pnc-header> <form editable-form class="form-horizontal" name="setEditForm" onbeforesave="detailSetCtrl.update()" novalidate> <div class="form-group" ng-class="{ \'has-error\': setEditForm.name.$invalid && !setEditForm.name.$pristine, \'has-success\': setEditForm.name.$valid && setEditForm.name.$touched }"> <label for="input-name" class="col-sm-1 control-label" ng-class="{ \'required\': setEditForm.$visible }">Name</label> <div class="col-sm-11"> <p id="input-name" class="form-control-static" e-class="form-control" editable-text="detailSetCtrl.set.name" e-name="name" e-maxlength="255" e-required>{{ detailSetCtrl.set.name || \'Empty\' }}</p> <span class="help-block" ng-show="setEditForm.name.$error.required && !setEditForm.name.$pristine">Required field.</span> </div> </div> <div class="form-group"> <label for="product-version-name" class="col-sm-1 control-label">Product Version</label> <div class="col-sm-11"> <p id="product-version-name" class="form-control-static">{{ detailSetCtrl.getFullProductVersionName() }}</p> </div> </div> <div class="form-group" ng-show="setEditForm.$visible"> <div class="col-sm-offset-1 col-sm-11"> <button type="submit" class="btn btn-primary" ng-disabled="setEditForm.$waiting || setEditForm.name.$invalid"> Save </button> <button type="button" class="btn btn-default" ng-disabled="setEditForm.$waiting" ng-click="setEditForm.$cancel(); setEditForm.$setPristine(); setEditForm.$setUntouched();"> Cancel </button> </div> </div> </form> </div> </div> <div class="row"> <div class="col-md-12"> <ul class="nav nav-tabs"> <li role="presentation" ui-sref-active="active"> <a href ui-sref="build-groups.detail.build-configs">Build Configs</a> </li> <li role="presentation" ui-sref-active="active"> <a href ui-sref="build-groups.detail.build-history">Build History</a> </li> </ul> </div> </div> <div class="row"> <div class="col-md-12"> <div class="m-t-20" ui-view></div> </div> </div> '),e.put("build-groups/views/build-groups.list.html",' <div> <pnc-header> <pnc-header-title>Build Groups</pnc-header-title> <pnc-header-buttons> <button type="button" class="btn btn-lg btn-default" uib-tooltip="Create Build Group" tooltip-popup-delay="2500" tooltip-placement="top" tooltip-append-to-body="true" ui-sref="build-groups.create({ productId: -1, versionId: -1 })"> <i class="fa fa-file-text-o"></i> Create </button> </pnc-header-buttons> </pnc-header> <pnc-search-field class="search" page="setlistCtrl.buildconfigurationsets" text="build groups"></pnc-search-field> <table class="table table-bordered table-striped"> <thead> <th>Name</th> </thead> <tbody> <tr ng-repeat="buildconfigurationset in setlistCtrl.buildconfigurationsets.data | filter:searchText"> <td><a href ui-sref="build-groups.detail.build-configs({ configurationSetId: buildconfigurationset.id })">{{ buildconfigurationset.name }}</a></td> </tr> </tbody> </table> <pnc-pager class="pull-right" page="setlistCtrl.buildconfigurationsets"></pnc-pager> </div> '),e.put("build-records/directives/pnc-build-details/pnc-build-details.html",' <div class="pnc-build-details"> <dl class="dl-horizontal"> <dt>Job Id:</dt> <dd>{{ ctrl.record.id }}</dd> <dt>Status:</dt> <dd ng-class="ctrl.record.status === \'SUCCESS\' ? \'text-success\' : \'text-danger\'">{{ ctrl.record.status }}</dd> <dt>Build Config:</dt> <dd><a href ui-sref="build-configs.detail({ configurationId: ctrl.record.buildConfigurationId })">{{ ctrl.record.buildConfigurationName || \'&mdash;\' }}</a></dd> <dt>Started By:</dt> <dd>{{ ctrl.record.username || \'&mdash;\' }}</dd> <dt ng-show="ctrl.record.submitTime">Submitted:</dt> <dd ng-show="ctrl.record.submitTime">{{ (ctrl.record.submitTime | date : \'medium\') }}</dd> <dt ng-show="ctrl.record.startTime">Started:</dt> <dd ng-show="ctrl.record.startTime">{{ (ctrl.record.startTime | date : \'medium\') }}</dd> <dt ng-show="ctrl.record.endTime">Finished:</dt> <dd ng-show="ctrl.record.endTime">{{ (ctrl.record.endTime | date : \'medium\') }}</dd> <dt>SCM URL:</dt> <dd> <span ng-show="ctrl.record.scmRepoURL">{{ ctrl.record.scmRepoURL }}</span> <span ng-hide="ctrl.record.scmRepoURL"> <span class="pficon pficon-warning-triangle-o" ng-if="ctrl.record.status !== \'BUILDING\'" title="Something went wrong, probably during alignment process, you should check logs for more details."></span> Based on {{ ctrl.record.buildConfigurationAudited.repositoryConfiguration.internalUrl }} </span> </dd> <dt>SCM Revision:</dt> <dd> <span ng-show="ctrl.record.scmRevision">{{ ctrl.record.scmRevision }}</span> <span ng-hide="ctrl.record.scmRevision"> <span class="pficon pficon-warning-triangle-o" ng-if="ctrl.record.status !== \'BUILDING\'" title="Something went wrong, probably during alignment process, you should check logs for more details."></span> Based on {{ ctrl.record.buildConfigurationAudited.scmRevision }} </span> </dd> <dt>Environment:</dt> <dd>{{ ctrl.record.buildConfigurationAudited.environment.name || \'&mdash;\' }}</dd> <dt>Script:</dt> <dd><pre class="pre-scrollable">{{ ctrl.record.buildConfigurationAudited.buildScript || \'&mdash;\' }}</pre></dd> <dt ng-repeat-start="(key, value) in ctrl.record.attributes">{{key}}</dt> <dd ng-repeat-end>{{value}}</dd> <dt>Generic Parameters</dt> <dd> <ul class="list-unstyled" ng-show="ctrl.record.buildConfigurationAudited.genericParameters"> <li ng-repeat="(key, value) in ctrl.record.buildConfigurationAudited.genericParameters"> <tt>{{key}}</tt> : <pre>{{value}}</pre> </li> </ul> <span ng-hide="ctrl.record.buildConfigurationAudited.genericParameters">&mdash;</span> </dd> </dl> </div> '),e.put("build-records/directives/pnc-build-record-push-button/pnc-build-record-push-button.html",' <button ng-if="::$ctrl.isButtonVisible()" ng-click="$ctrl.openTagNameModal()" type="button" class="btn btn-default" pnc-requires-auth><i class="pficon pficon-export"></i>&nbsp;Push To Brew</button> '),e.put("build-records/directives/pnc-build-record-tab-brew-push/pnc-build-record-tab-brew-push.html",' <div class="row"> <div class="col-md-12"> <div class="pnc-build-details"> <dl class="dl-horizontal"> <dt>Status</dt> <dd>{{ ::$ctrl.buildRecordPushResult.status }}</dd> <dt>Brew Build Id</dt> <dd>{{ ::$ctrl.buildRecordPushResult.brewBuildId }}</dd> <dt>Brew Build URL</dt> <dd><a target="_blank" href="{{ ::$ctrl.buildRecordPushResult.brewBuildUrl }}">{{ ::$ctrl.buildRecordPushResult.brewBuildUrl }}</a></dd> </dl> </div> </div> </div> <div class="row"> <div class="col-md-12"> <div class="pnc-log-canvas-parent log-console well well-sm pre-wrap push-log"> <div class="pnc-log-canvas-content">{{ ::$ctrl.buildRecordPushResult.log }}</div> </div> </div> </div> '),e.put("build-records/directives/pnc-build-records-list/pnc-build-records-list.html",' <table class="table table-bordered table-striped table-hover pnc-build-records-list" ng-show="$ctrl.showTable()"> <thead ng-hide="::$ctrl.hideHead"> <th ng-if="::$ctrl.showColumn(\'status\')">Status</th> <th ng-if="::$ctrl.showColumn(\'id\')">Id</th> <th ng-if="::$ctrl.showColumn(\'configurationName\')">Build Config</th> <th ng-if="::$ctrl.showColumn(\'startTime\')">Start Time</th> <th ng-if="::$ctrl.showColumn(\'endTime\')">End Time</th> <th ng-if="::$ctrl.showColumn(\'username\')">User</th> <th ng-if="::$ctrl.showColumn(\'pushStatus\')">Brew Push Status</th> </thead> <tbody> <tr ng-repeat="item in $ctrl.items"> <td ng-if="::$ctrl.showColumn(\'status\')"> <pnc-build-status-icon build-record="item"></pnc-build-status-icon> {{ item.status }} </td> <td ng-if="::$ctrl.showColumn(\'id\')"> <a ng-if="::$ctrl.buildRecords" href ui-sref="projects.detail.build-configs.detail.build-records.detail.default({ projectId: item.projectId, configurationId: item.buildConfigurationId, recordId: item.id })"># {{ item.id }}</a> <a ng-if="::$ctrl.buildGroupRecords" href ui-sref="configuration-set-record.detail.info({ recordId: item.id })">#{{ item.id }}</a> </td> <td ng-if="::$ctrl.showColumn(\'configurationName\')"> <a ng-if="::$ctrl.buildRecords" href ui-sref="projects.detail.build-configs.detail({ projectId: item.projectId, configurationId: item.buildConfigurationId })">{{ item.buildConfigurationName }}</a> <a ng-if="::$ctrl.buildGroupRecords" href ui-sref="build-groups.detail.build-configs({ configurationSetId: item.buildConfigurationSetId })">{{ item.buildConfigurationSetName }}</a> </td> <td ng-if="::$ctrl.showColumn(\'startTime\')">{{ item.startTime | date:\'medium\' }}</td> <td ng-if="::$ctrl.showColumn(\'endTime\')">{{ item.endTime | date:\'medium\' }}</td> <td ng-if="::$ctrl.showColumn(\'username\')">{{ item.username }}</td> <td ng-if="::$ctrl.showColumn(\'pushStatus\')" class="push-status"><pnc-push-status build-record="item"></pnc-push-status></td> </tr> </tbody> </table> <div ng-hide="$ctrl.showTable()" class="text-center clear-both"><em>There are no items to display</em></div> '),e.put("build-records/directives/pnc-builds/pnc-builds.html",' <div> <pnc-search-field class="search" page="page" text="recent builds"></pnc-search-field> <pnc-build-records-list build-records="page.data"></pnc-build-records-list> <pnc-pager class="pull-right" page="page"></pnc-pager> </div> '),e.put("build-records/directives/pnc-enter-brew-tag-name-modal/pnc-enter-brew-tag-name-modal.html",' <div> <div class="modal-header"> <button type="button" class="close" aria-label="Close" ng-click="$ctrl.cancel()"><span aria-hidden="true">&times;</span></button> <h3 class="modal-title">Enter Brew Tag Prefix</h3> </div> <div class="modal-body"> <div class="row"> <div class="col-md-12"> <form name="form" novalidate> <div class="form-group"> <label class="control-label" for="brew-tag-name"> Brew Tag Prefix <a uib-popover="The brew tag prefix entered will have \'-candiate\' appended to it, all artifacts pushed to brew will be added to this tag." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> <input id="brew-tag-name" name="name" class="form-control" ng-model="$ctrl.data.name" type="text"> </div> </form> </div> </div> </div> <div class="modal-footer"> <button class="btn btn-primary" type="button" ng-click="$ctrl.done()"><i class="pficon pficon-export"></i>&nbsp;Push</button> <button class="btn btn-default" type="button" ng-click="$ctrl.cancel()">Cancel</button> </div> </div> '),e.put("build-records/directives/pnc-static-log/pnc-static-log.html",' <div> <div class="pull-right"> <script type="text/ng-template" id="logWrapPopoverTemplate.html"> <table class="nowrap">\n        <tbody>\n          <tr>\n            <td>Use <code>shift + mouse wheel</code><br> to scroll horizontally</td>\n          </tr>\n        </tbody>\n      </table> <\/script> <label> <div uib-popover-template="\'logWrapPopoverTemplate.html\'" popover-placement="top-right" popover-is-open="!$ctrl.logWrap"> <span class="inline-block pull-left p-t-2 p-r-5 cursor-pointer">Log Text Wrapping is</span> <div class="btn-group"> <span class="btn btn-sm btn-default" ng-class="{ \'btn-primary\': $ctrl.logWrap }">ON</span> <span class="btn btn-sm btn-default" ng-class="{ \'btn-primary\': !$ctrl.logWrap }">OFF</span> </div> </div> <input ng-model="$ctrl.logWrap" type="checkbox" ng-change="$ctrl.handleModelChange()" class="hide"> </label> </div> <pre class="clear-both" ng-class="{ \'pre-wrap\': $ctrl.logWrap }">\n    {{ ::$ctrl.log || \'Log not available.\' }}\n  </pre> </div>'),e.put("build-records/views/build-records.detail.artifacts.html",' <div> <div class="panel panel-default pnc-data-panel"> <div class="panel-heading clearfix"> <div class="pull-right"> <span class="spinner spinner-sm spinner-inline" ng-hide="artifactsCtrl.artifacts.isLoaded"></span> </div> <pf-filter id="filter" config="artifactsCtrl.filterConfig"></pf-filter> </div> <div class="panel-body" ng-hide="artifactsCtrl.artifacts.data.length > 0"> <strong>No Results</strong> </div> <table class="table table-bordered table-striped table-hover table-responsive" ng-show="artifactsCtrl.artifacts.data.length > 0"> <thead> <th>Identifier</th> <th>Quality</th> <th>File Name</th> <th>Repository Type</th> <th>Checksums</th> <th>Actions</th> </thead> <tbody> <tr ng-repeat="artifact in artifactsCtrl.artifacts.data"> <td>{{ artifact.identifier }}</td> <td>{{ artifact.artifactQuality }}</td> <td>{{ artifact.filename }}</td> <td>{{ artifact.targetRepository.repositoryType }}</td> <td> <div class="checksum checksum-md5"> {{ artifact.md5 }} </div> <div class="checksum checksum-sha1"> {{ artifact.sha1 }} </div> <div class="checksum checksum-sha256"> {{ artifact.sha256 }} </div> </td> <td class="td-actions"> <div class="btn-group" role="group" aria-label="Row Actions"> <a ng-href="{{ artifact.publicUrl }}" target="_self" class="btn btn-default">Download</a> </div> </td> </tr> </tbody> </table> <div class="panel-footer"> <div class="pull-right"> <div pnc-page-controls pnc-page="artifactsCtrl.artifacts"></div> </div> <div class="clearfix"></div> </div> </div> </div> '),e.put("build-records/views/build-records.detail.default.html",' <div class="row push-down"> <div class="col-sm-12 col-md-10 col-lg-8"> <pnc-build-details build-record="recordCtrl.record"></pnc-build-details> </div> </div> <div class="row"> <div class="col-md-12"> <div ng-if="::recordCtrl.record.status===\'BUILDING\'"> <pnc-live-log build-record="recordCtrl.record"></pnc-live-log> </div> </div> </div> '),e.put("build-records/views/build-records.detail.html",' <div class="row margin-bottom-md"> <div class="col-md-12"> <div class="page-header border-none"> <div class="btn-group pull-right" role="group" aria-label="Build Actions"> <pnc-build-record-push-button build-record="recordCtrl.record"></pnc-build-record-push-button> <button ng-if="recordCtrl.record.$isCancelable()" ng-click="recordCtrl.record.$cancel()" type="button" class="btn btn-danger"><i class="fa fa-ban" aria-hidden="true"></i>&nbsp;Abort</button> </div> <h1> <pnc-build-status-icon build-record="recordCtrl.record" no-warnings="true"></pnc-build-status-icon> Build #{{ recordCtrl.record.id }} of {{ recordCtrl.record.buildConfigurationName }} <pnc-corrupted-build-record-label build-record="recordCtrl.record" class="label-sm"></pnc-corrupted-build-record-label> <pnc-temporary-build-record-label build-record="recordCtrl.record" class="label-sm"></pnc-temporary-build-record-label> </h1> </div> </div> </div> <div class="row m-b-20"> <div class="col-md-12"> <ul class="nav nav-tabs"> <li role="presentation" ui-sref-active="active"><a href ui-sref="projects.detail.build-configs.detail.build-records.detail.default">Details</a></li> <li role="presentation" ui-sref-active="active" ng-hide="recordCtrl.record.status === \'BUILDING\'"> <a href ui-sref="projects.detail.build-configs.detail.build-records.detail.result">Build Log</a> </li> <li role="presentation" ui-sref-active="active" ng-hide="recordCtrl.record.status === \'BUILDING\'"> <a href ui-sref="projects.detail.build-configs.detail.build-records.detail.repour-result">Alignment Log</a> </li> <li role="presentation" ui-sref-active="active" ng-hide="recordCtrl.record.status === \'BUILDING\'"> <a href ui-sref="projects.detail.build-configs.detail.build-records.detail.artifacts">Artifacts</a> </li> <li role="presentation" ui-sref-active="active" ng-hide="recordCtrl.record.status === \'BUILDING\'"> <a href ui-sref="projects.detail.build-configs.detail.build-records.detail.dependencies">Dependencies</a> </li> <li role="presentation" ui-sref-active="active" ng-show="recordCtrl.hasPushResults()"> <a href ui-sref="projects.detail.build-configs.detail.build-records.detail.brew-push">Brew Push</a> </li> </ul> </div> </div> <div class="row"> <div class="col-md-12" ui-view> </div> </div> '),e.put("build-records/views/build-records.detail.repour-result.html",' <div class="pull-left"> <a class="btn btn-default btn-sm" href="{{repourResultCtrl.logUrl}}" target="_blank" title="View the log as a plain text"> View <span class="pficon pficon-arrow"></span> </a> <a class="btn btn-default btn-sm" href="{{repourResultCtrl.logUrl}}" target="_blank" title="Download the log as a plain text" download="{{repourResultCtrl.logFileName}}"> Download <span class="fa fa-arrow-circle-o-down"></span> </a> </div> <pnc-static-log log="repourResultCtrl.log"></pnc-static-log>'),e.put("build-records/views/build-records.detail.result.html",' <div class="push-down"> <div class="pull-left"> <a class="btn btn-default btn-sm" href="{{resultCtrl.logUrl}}" target="_blank" title="View the log as a plain text"> View <span class="pficon pficon-arrow"></span> </a> <a class="btn btn-default btn-sm" href="{{resultCtrl.logUrl}}" target="_blank" title="Download the log as a plain text" download="{{resultCtrl.logFileName}}"> Download <span class="fa fa-arrow-circle-o-down"></span> </a> <script type="text/ng-template" id="popoverTemplate.html"> <table class="nowrap">\n        <tbody>\n          <tr>\n            <td class="text-right p-r-10"><strong>command:</strong></td>\n            <td>{{ resultCtrl.sshCredentials.command }}</td>\n          </tr>\n          <tr>\n            <td class="text-right p-r-10"><strong>password:</strong></td>\n            <td>{{ resultCtrl.sshCredentials.password }}</td>\n          </tr>\n        </tbody>\n      </table> <\/script> <button uib-popover-template="\'popoverTemplate.html\'" popover-title="SSH credentials" type="button" class="btn btn-primary btn-sm popover-no-max w-min-130" popover-placement="right" ng-if="resultCtrl.sshCredentials.command" ng-click="resultCtrl.sshCredentialsBtn.clicked = !resultCtrl.sshCredentialsBtn.clicked" ng-class="{\'active\' : resultCtrl.sshCredentialsBtn.clicked }"> <span class="hide-when-active">Show</span> <span class="display-when-active">Hide</span> SSH credentials </button> </div> <pnc-static-log log="resultCtrl.log"></pnc-static-log> </div> '),e.put("build-records/views/build-records.list.html",' <div> <div class="page-header"> <h1>Builds</h1> </div> <pnc-builds></pnc-builds> </div> '),e.put("common/components/pnc-build-config-combobox/pnc-build-config-combobox.html",' <px-combobox px-expression="buildConfig as buildConfig.name for buildConfig in $ctrl.search($viewValue)" ng-model="$ctrl.input" debounce-ms="500" placeholder="Select or search for a Build Config"> </px-combobox> '),e.put("common/components/pnc-build-start/pnc-build-start.html",' <div class="btn-group pnc-build-start"> <button type="button" class="btn btn-{{ $ctrl.size ? $ctrl.size : \'lg\'}} btn-primary" uib-tooltip="Start a build of this configuration" tooltip-popup-delay="2000" tooltip-placement="top" tooltip-append-to-body="true" ng-click="$ctrl.build()" pnc-requires-auth> <i class="pficon pficon-build"></i> Build </button> <button class="btn btn-{{ $ctrl.size ? $ctrl.size : \'lg\'}} btn-default dropdown-btn" ng-click="$ctrl.dropdownMenu = !$ctrl.dropdownMenu" uib-tooltip="Configure a build" tooltip-popup-delay="1500" tooltip-placement="top" tooltip-append-to-body="true" pnc-requires-auth> {{ $ctrl.params.temporaryBuild ? \'Temporary\' : \'Persistent\' }} <span class="fa fa-angle-up" ng-if="$ctrl.dropdownMenu"></span> <span class="fa fa-angle-down" ng-if="!$ctrl.dropdownMenu"></span> </button> <div class="dropdown-menu ng-hide" ng-show="$ctrl.dropdownMenu"> <div class="radio"> <label> <input type="radio" name="buildStartType-{{$id}}" ng-model="$ctrl.params.temporaryBuild" ng-value="false" ng-change="$ctrl.refreshBuildModes()"> persistent <a uib-popover="Standard build, which can be used for product release" popover-placement="top" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> </div> <div class="radio"> <label> <input type="radio" name="buildStartType-{{$id}}" ng-model="$ctrl.params.temporaryBuild" ng-value="true" ng-change="$ctrl.refreshBuildModes()"> temporary <a uib-popover="Test build, which cannot be used for product release and which will be garbage collected" popover-placement="top" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> </div> <hr> <div class="checkbox" ng-if="::$ctrl.buildConfig"> <label> <input type="checkbox" ng-model="$ctrl.params.keepPodOnFailure"> keep pod alive <a uib-popover="The builder container won\'t be destroyed if the build fails and you can use SSH to debug it" popover-placement="top" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> </div> <div class="checkbox"> <label> <input type="checkbox" ng-model="$ctrl.params.forceRebuild"> force rebuild <a uib-popover="Perform the build even if successful build of the same configuration is present" popover-placement="top" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> </div> <div class="checkbox" ng-if="::$ctrl.buildConfig"> <label> <input type="checkbox" ng-model="$ctrl.params.buildDependencies"> with dependencies <a uib-popover="Build also dependencies of this build configuration if they are not built yet" popover-placement="top" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> </div> <div class="checkbox" ng-class="{\'disabled-option\': !$ctrl.params.temporaryBuild}" title="{{ !$ctrl.params.temporaryBuild ? \'Not valid option\' : \'\' }}"> <label> <input type="checkbox" ng-model="$ctrl.params.timestampAlignment"> timestamp alignment <a uib-popover="Append timestamp to the artifact\'s maven version during the alignment phase" popover-placement="top" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> </div> <hr> <div class="text-center"> <small> Press <em>Build</em> button to start {{ $ctrl.params.temporaryBuild ? \'temporary\' : \'persistent\' }} build {{ $ctrl.params.forceRebuild && $ctrl.params.buildDependencies ? \'forcing only build itself, not forcing its dependencies\' : \'\' }} </small> </div> </div> </div>'),e.put("common/components/pnc-build-status-icon/pnc-build-status-icon.html",' <span class="build-status-icon"> <span ng-switch on="$ctrl.buildRecord.status"> <img ng-switch-when="WAITING_FOR_DEPENDENCIES" uib-tooltip="Waiting for dependencies" tooltip-popup-delay="1000" alt="{{ $ctrl.buildRecord.status }}" width="28px" height="28px" src="images/blue.a2d434e8.svg"> <img ng-switch-when="ENQUEUED" uib-tooltip="Enqueued" tooltip-popup-delay="1000" alt="{{ $ctrl.buildRecord.status }}" width="28px" height="28px" src="images/blue.a2d434e8.svg"> <img ng-switch-when="BUILDING" uib-tooltip="Build in progress" tooltip-popup-delay="1000" alt="{{ $ctrl.buildRecord.status }}" width="28px" height="28px" class="animate-flicker" src="images/blue.a2d434e8.svg"> <img ng-switch-when="SUCCESS" uib-tooltip="Build completed successfully" tooltip-popup-delay="1000" alt="{{ $ctrl.buildRecord.status }}" width="28px" height="28px" src="images/green.3973581e.svg"> <img ng-switch-when="DONE" uib-tooltip="Build completed successfully" tooltip-popup-delay="1000" alt="{{ $ctrl.buildRecord.status }}" width="28px" height="28px" src="images/green.3973581e.svg"> <img ng-switch-when="UNSTABLE" uib-tooltip="Unstable build" tooltip-popup-delay="1000" alt="{{ $ctrl.buildRecord.status }}" width="28px" height="28px" src="images/yellow.9d5b17e1.svg"> <img ng-switch-when="FAILED" uib-tooltip="Build Failed" tooltip-popup-delay="1000" alt="{{ $ctrl.buildRecord.status }}" width="28px" height="28px" src="images/red.d2ea28cd.svg"> <img ng-switch-when="DONE_WITH_ERRORS" uib-tooltip="Build Failed" tooltip-popup-delay="1000" alt="{{ $ctrl.buildRecord.status }}" width="28px" height="28px" src="images/red.d2ea28cd.svg"> <img ng-switch-when="REJECTED_ALREADY_BUILT" uib-tooltip="Build rejected: already built" tooltip-popup-delay="1000" alt="{{ $ctrl.buildRecord.status }}" width="28px" height="28px" src="images/red.d2ea28cd.svg"> <img ng-switch-when="REJECTED_FAILED_DEPENDENCIES" uib-tooltip="Build rejected: dependencies failed" tooltip-popup-delay="1000" alt="{{ $ctrl.buildRecord.status }}" width="28px" height="28px" src="images/red.d2ea28cd.svg"> <img ng-switch-when="ABORTED" uib-tooltip="Build aborted" tooltip-popup-delay="1000" alt="{{ $ctrl.buildRecord.status }}" width="28px" height="28px" src="images/grey.c59eafcf.svg"> <img ng-switch-when="CANCELLED" uib-tooltip="Build cancelled" tooltip-popup-delay="1000" alt="{{ $ctrl.buildRecord.status }}" width="28px" height="28px" src="images/grey.c59eafcf.svg"> <img ng-switch-when="NEW" uib-tooltip="New" tooltip-popup-delay="1000" alt="{{ $ctrl.buildRecord.status }}" width="28px" height="28px" src="images/grey.c59eafcf.svg"> <img ng-switch-when="SYSTEM_ERROR" uib-tooltip="A system error occurred" tooltip-popup-delay="1000" alt="{{ $ctrl.buildRecord.status }}" width="28px" height="28px" src="images/error.9fd364ff.svg"> <img ng-switch-default uib-tooltip="Unknown build status: {{ $ctrl.buildRecord.status }}" alt="{{ $ctrl.buildRecord.status }}" tooltip-popup-delay="1000" src="images/unknown_small.png"> </span> <span ng-if="::!$ctrl.noWarnings"> <span ng-if="$ctrl.isCorrupted"> <i class="pficon pficon-warning-triangle-o fa-lg" uib-tooltip="The build may have completed successfully but has since been corrupted by a system error" tooltip-popup-delay="1000" tooltip-placement="right"></i> </span> <span ng-if="$ctrl.isTemporary"> <i class="fa fa-clock-o fa-lg c-info" uib-tooltip="Test build, which cannot be used for product release and which will be garbage collected" tooltip-popup-delay="1000" tooltip-placement="right"></i> </span> </span> </span> '),e.put("common/components/pnc-build-status/pnc-build-status.html",' <div ng-show="$ctrl.item && $ctrl.isLoaded"> <pnc-build-status-icon build-record="$ctrl.item"></pnc-build-status-icon> <a ng-if="$ctrl.buildRecord" ui-sref="build-records.detail.default({ recordId: $ctrl.item.id })"># {{ $ctrl.item.id }}</a> <a ng-if="$ctrl.buildGroupRecord" ui-sref="configuration-set-record.detail.info({ recordId: $ctrl.item.id })"># {{ $ctrl.item.id }}</a> <span title="End Time">{{ $ctrl.item.endTime | date:\'medium\' }}</span> <span title="Start Time" ng-hide="$ctrl.item.endTime">{{ $ctrl.item.startTime | date:\'medium\' }}</span> <span ng-show="$ctrl.item.username">,</span> <span class="text-bold">{{ $ctrl.item.username }}</span> </div> <em ng-show="!$ctrl.item && $ctrl.isLoaded">none</em> <div ng-hide="$ctrl.isLoaded" class="loading-placeholder w-100-20"></div>'),e.put("common/components/pnc-builds-history/pnc-builds-history.html",' <div class="panel panel-default build-panel"> <div class="panel-heading"> <div class="spinner spinner-sm pull-right" ng-hide="$ctrl.page.isLoaded"></div> <h3 class="panel-title">Build History</h3> </div> <table class="table table-striped table-hover" ng-show="$ctrl.page.data.length"> <tbody> <tr ng-repeat="record in $ctrl.page.data"> <td> <pnc-build-status build-record="record" is-loaded="$ctrl.page.isLoaded"></pnc-build-status> </td> </tr> </tbody> </table> <div class="panel-body" ng-hide="$ctrl.page.data.length || !$ctrl.page.isLoaded"> No builds </div> <pnc-page-controls class="pull-right" pnc-page="$ctrl.page" ng-if="$ctrl.page"></pnc-page-controls> </div>'),e.put("common/components/pnc-corrupted-build-record-label/pnc-corrupted-build-record-label.html",' <span ng-if="$ctrl.isCorrupted()"> <span class="label label-warning" uib-tooltip="The build may have completed successfully but has since been corrupted by a system error" tooltip-popup-delay="1000"> CORRUPTED </span> </span> '),e.put("common/components/pnc-environment-combobox/pnc-environment-combobox.html",' <px-combobox px-expression="environment as environment.name for environment in $ctrl.search($viewValue)" ng-model="$ctrl.input" debounce-ms="500"> </px-combobox> '),e.put("common/components/pnc-latest-build/pnc-latest-build.html",' <pnc-build-status ng-if="$ctrl.buildConfig" build-record="$ctrl.latestBuild" is-loaded="$ctrl.isLoaded"></pnc-build-status> <pnc-build-status ng-if="$ctrl.buildGroup" build-group-record="$ctrl.latestBuild" is-loaded="$ctrl.isLoaded"></pnc-build-status>'),e.put("common/components/pnc-product-combobox/pnc-product-combobox.html",' <px-combobox px-expression="product as product.name for product in $ctrl.search($viewValue)" ng-model="$ctrl.input" debounce-ms="500" placeholder="Select or search for a Product"> </px-combobox> '),e.put("common/components/pnc-product-version-combobox/pnc-product-version-combobox.html",' <px-combobox px-expression="productVersion as $ctrl.generateLabel(productVersion) for productVersion in $ctrl.search($viewValue)" ng-model="$ctrl.input" debounce-ms="500" placeholder="Select or search for a Product Version"> </px-combobox> '),e.put("common/components/pnc-project-typeahead/pnc-project-typeahead.html",' <div class="search-pf has-button"> <div class="form-group has-clear"> <div class="search-pf-input-group"> <label for="select-project-{{::$id}}" class="sr-only">Search Projects</label> <input type="text" class="form-control combobox" id="select-project-{{::$id}}" placeholder="Enter project name to search..." autocomplete="off" ng-model="$ctrl.input" uib-typeahead="project as project.name for project in $ctrl.search($viewValue)" typeahead-on-select="$ctrl.select($item, $model, $label)" typeahead-wait-ms="300" typeahead-loading="$ctrl.isLoading" ng-focus="$ctrl.setTouched()" ng-change="$ctrl.setDirty()"> <button ng-if="$ctrl.isLoading" type="button" class="clear" aria-hidden="true"><span class="spinner spinner-xs spinner-inline"></span></button> <button ng-if="!$ctrl.isLoading && $ctrl.input" type="button" class="clear" aria-hidden="true" ng-click="$ctrl.input = \'\'"><span class="pficon pficon-close"></span></button> </div> </div> <div class="form-group"> <button class="btn btn-default" type="button"><span class="fa fa-search"></span></button> </div> </div> '),e.put("common/components/pnc-push-status/pnc-push-status.html",' <div ng-if="$ctrl.loading" class="spinner spinner-sm"></div> <div ng-if="!$ctrl.loading"> <span ng-switch on="$ctrl.pushStatus.status"> <span ng-switch-when="SUCCESS" class="label label-success"> <a ui-sref="projects.detail.build-configs.detail.build-records.detail.brew-push({ projectId: $ctrl.buildRecord.projectId, configurationId: $ctrl.buildRecord.buildConfigurationId, recordId: $ctrl.buildRecord.id })" href> SUCCESS </a> </span> <span ng-switch-when="FAILED" class="label label-danger"> <a ui-sref="projects.detail.build-configs.detail.build-records.detail.brew-push({ projectId: $ctrl.buildRecord.projectId, configurationId: $ctrl.buildRecord.buildConfigurationId, recordId: $ctrl.buildRecord.id })" href> FAILED </a> </span> <span ng-switch-when="SYSTEM_ERROR" class="label label-danger"> <a ui-sref="projects.detail.build-configs.detail.build-records.detail.brew-push({ projectId: $ctrl.buildRecord.projectId, configurationId: $ctrl.buildRecord.buildConfigurationId, recordId: $ctrl.buildRecord.id })" href> ERROR </a> </span> <span ng-switch-when="CANCELED" class="label label-default"> <a ui-sref="projects.detail.build-configs.detail.build-records.detail.brew-push({ projectId: $ctrl.buildRecord.projectId, configurationId: $ctrl.buildRecord.buildConfigurationId, recordId: $ctrl.buildRecord.id })" href> CANCELED </a> </span> <span ng-switch-default> &mdash; </span> </span> </div> '),e.put("common/components/pnc-repository-configuration-combobox/pnc-repository-configuration-combobox.html",' <px-combobox px-expression="repositoryConfiguration \n    as $ctrl.generateLabel(repositoryConfiguration) \n    for repositoryConfiguration \n    in $ctrl.search($viewValue)" ng-model="$ctrl.input" debounce-ms="500" placeholder="Select or search for a Repository Configuration" class="pnc-repository-configuration-combobox"> </px-combobox> '),e.put("common/components/pnc-temporary-build-record-label/pnc-temporary-build-record-label.html",' <span ng-if="$ctrl.isTemporary()"> <span class="label label-info" uib-tooltip="Test build, which cannot be used for product release and which will be garbage colleted" tooltip-popup-delay="1000"> TEMPORARY </span> </span> '),e.put("common/directives/pnc-confirm-click/pnc-confirm-click.html",' <div class="modal-header"> <h3 class="modal-title">{{ message }}</h3> </div> <div class="modal-footer"> <button class="btn btn-default" type="button" ng-click="cancel()">Cancel</button> <button class="btn btn-warning" type="button" ng-click="confirm()">Confirm</button> </div> '),e.put("common/directives/pnc-header/pnc-header.html",' <div class="row"> <div class="col-md-12"> <div class="page-header"> <div class="btn-toolbar pull-right" role="toolbar" aria-label="Context specific actions"></div> <h1 class="header-title"></h1> </div> </div> </div> '),e.put("common/directives/pnc-infinite-select-items/pnc-infinite-select-items.html",' <ul ng-class="{\'list-group\': singleItem === \'false\' , \'list-group-no-bottom-margin\': singleItem === \'true\' }" ng-show="shouldShowList()"> <li class="list-group-item" ng-repeat="item in selectedItems"> {{ additionalDisplayItemsById[item.id] }} {{ item[displayProperty] }} <button type="button" class="close" aria-label="Close" ng-click="removeItem(item)"> <span aria-hidden="true">×</span> </button> </li> </ul> <div class="pnc-infinite-select" ng-show="shouldShowSelection()"> <input ng-required="{{ infiniteSelectRequired }}" id="{{ infiniteSelectId }}" name="{{ infiniteSelectId }}" ng-model="searchText" ng-change="search()" placeholder="{{ placeholder }}" size="{{ text.length + 10 }}" ng-focus="viewDropdown(true)" ng-blur="viewDropdown(false)" class="input-text" autocomplete="off"> <div class="dropdown-wrap" ng-show="isDropdown"> <ul infinite-scroll="loadOptions()" infinite-scroll-distance="0" infinite-scroll-immediate-check="false" infinite-scroll-parent="true" class="dropdown-list"> <li class="dropdown-item" ng-repeat="item in items.data" ng-mousedown="selectItem(item); viewDropdown(false)"> {{ item.name }} </li> </ul> </div> </div> '),e.put("common/directives/pnc-infinite-select-product-versions/pnc-infinite-select-product-versions.html",' <ul ng-class="{\'list-group\': singleItem === \'false\' , \'list-group-no-bottom-margin\': singleItem === \'true\' }" ng-show="shouldShowList()"> <li class="list-group-item" ng-repeat="prodVers in selectedItems"> <span class="text-bold">{{ prodVers[\'productName\'] }}</span> - {{ prodVers[\'version\'] }} <button type="button" class="close" aria-label="Close" ng-click="removeItem(prodVers)"> <span aria-hidden="true">×</span> </button> </li> </ul> <div class="pnc-infinite-select" ng-show="shouldShowSelection()"> <input ng-required="{{ infiniteSelectRequired }}" id="{{ infiniteSelectId }}" name="{{ infiniteSelectId }}" ng-model="searchText" ng-change="search()" placeholder="{{ placeholder }}" size="{{ text.length + 10 }}" ng-focus="viewDropdown(true)" ng-blur="viewDropdown(false)" class="input-text" autocomplete="off"> <div class="dropdown-wrap" ng-show="isDropdown"> <ul infinite-scroll="loadOptions()" infinite-scroll-distance="0" infinite-scroll-immediate-check="false" infinite-scroll-parent="true" class="dropdown-list"> <li class="dropdown-list" ng-repeat="product in items.data"> <span class="text-bold">{{ product.name }}</span> <div class="dropdown-item" ng-repeat="productVersionRef in product.productVersionRefs" ng-mousedown="selectItem(productVersionRef); viewDropdown(false)">{{productVersionRef.version}}</div> <div class="dropdown-item-empty" ng-hide="product.productVersionRefs.length">└ no version available</div> </li> </ul> </div> </div> '),e.put("common/directives/pnc-infinite-select/pnc-infinite-select.html",' <div class="pnc-infinite-select"> <input ng-required="{{ infiniteSelectRequired }}" id="{{ infiniteSelectId }}" name="{{ infiniteSelectName }}" ng-model="searchText" ng-change="search()" placeholder="{{ placeholder }}" size="{{ text.length + 10 }}" ng-focus="viewDropdown(true)" ng-blur="viewDropdown(false)" class="input-text" autocomplete="off"> <div class="dropdown-wrap" ng-show="isDropdown"> <ul infinite-scroll="loadOptions()" infinite-scroll-distance="0" infinite-scroll-immediate-check="false" infinite-scroll-parent="true" class="dropdown-list"> <li class="dropdown-item" ng-repeat="item in items.data" ng-mousedown="selectItem(item); viewDropdown(false)"> {{ item.name }} </li> </ul> </div> </div> '),e.put("common/directives/pnc-loading-placeholder/pnc-loading-placeholder.html",' <tr ng-repeat="tr in [1,2]" ng-hide="page.isLoaded"> <td ng-repeat="td in columnsIterable" class="bg-white"> <div class="loading-placeholder"></div> </td> </tr> <tr ng-show="page.isLoaded && !page.data.length"> <td colspan="{{columns}}" class="text-center">No data available</td> '),e.put("common/directives/pnc-multiple-input/pnc-multiple-input.html",' <div class="pnc-multiple-input"> <ul class="list-group" ng-show="shouldShowList()"> <li class="list-group-item" ng-repeat="item in selectedItems"> {{ item }} <button type="button" class="close" aria-label="Close" ng-click="removeItem(item)"> <span aria-hidden="true">×</span> </button> </li> </ul> <div> <input id="{{ selectId }}" name="{{ selectName }}" ng-model="inputItem" placeholder="{{ placeholder }}" class="input-item" class="input-text"> <button type="button" class="btn-select-item" aria-label="Close" ng-click="selectItem(inputItem)">Add</button> </div> </div>'),e.put("common/directives/pnc-select-items/pnc-select-items.html",' <ul ng-class="{\'list-group\': singleItem === \'false\' , \'list-group-no-bottom-margin\': singleItem === \'true\' }" ng-show="shouldShowList()"> <li class="list-group-item" ng-repeat="item in selectedItems"> {{ item.fullDisplayText }} <button type="button" class="close" aria-label="Close" ng-click="removeItem(item)"> <span aria-hidden="true">×</span> </button> </li> </ul> <div class="pnc-infinite-select" ng-show="shouldShowSelection()"> <input ng-required="{{ selectRequired }}" id="{{ selectId }}" name="{{ selectName }}" ng-model="searchText" placeholder="{{ placeholder }}" size="{{ text.length + 10 }}" ng-focus="viewDropdown(true)" ng-blur="viewDropdown(false)" class="input-text" autocomplete="off"> <div class="dropdown-wrap" ng-show="isDropdown"> <ul class="dropdown-list"> <li class="dropdown-item" ng-repeat="item in filteredItems = (items.data | filter:searchText)" ng-mousedown="selectItem(item); viewDropdown(false)"> <span class="text-bold">{{ item.displayBoldText }}</span><span>{{ item.displayText }}</span> </li> <li class="dropdown-item-empty" ng-show="!items.data.length"><span class="fa fa-angle-double-left"></span> empty <span class="fa fa-angle-double-right"></span></li> <li class="dropdown-item-empty cursor-pointer" ng-show="!filteredItems.length && customItem" ng-click="saveCustomItem(searchText)"> <span class="fa fa-angle-double-left"></span> click here to add custom value <span class="fa fa-angle-double-right"></span> </li> </ul> </div> </div> '),e.put("common/notifications/views/heading.html"," {{notificationGroup.heading}} "),e.put("common/notifications/views/notification-body.html",' <div ng-if="!drawerExpanded"> <div class="dropdown pull-right dropdown-kebab-pf" ng-if="notification.menuActions && notification.menuActions.length > 0"> <button class="btn btn-link dropdown-toggle" type="button" id="dropdownKebabRight" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true"> <span class="fa fa-ellipsis-v"></span> </button> <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownKebabRight"> <li ng-repeat="menuAction in notification.menuActions" role="menuitem" ng-class="{\'divider\': menuAction.isSeparator === true, \'disabled\': menuAction.isDisabled === true}"> <a ng-if="menuAction.isSeparator !== true" class="secondary-action ng-binding ng-scope" title="{{menuAction.title}}" ng-click="menuAction.actionFn()"> {{menuAction.name}} </a> </li> </ul> </div> <div class="pull-right toast-pf-action ng-scope" ng-if="notification.actionTitle"> <a ng-click="notification.actionCallback()" class="ng-binding">{{ notification.actionTitle }}</a> </div> <span ng-if="notification.type" class="{{\'pull-left \' + customScope.getNotficationStatusIconClass(notification)}}" ng-click="customScope.markRead(notification)"> </span> <span class="drawer-pf-notification-message" ng-click="customScope.markRead(notification)"> {{notification.message}} </span> <div class="drawer-pf-notification-info" ng-click="customScope.markRead(notification)"> <span class="date">{{notification.timeStamp | date:\'mediumDate\'}}</span> <span class="time">{{notification.timeStamp | date:\'mediumTime\'}}</span> </div> </div> '),e.put("common/notifications/views/notification-footer-include.html",' <a class="btn btn-link btn-block" role="button" ng-click="customScope.clearAll(notificationGroup)"> <span class="pficon pficon-close"></span> <span>Clear All</span> </a> '),e.put("common/notifications/views/subheading.html"," "),e.put("common/pnc-client/pagination/directives/pnc-page-controls/pnc-page-controls.html",' <div class="form-inline pnc-page-controls" ng-show="ctrl.page.data.length > ctrl.pageSizes[0] || ctrl.page.total > 1"> <div class="form-group pnc-page-controls-size"> <label for="page-size-{{::$id}}">Page Size:&nbsp;</label> <select id="page-size-{{::$id}}" ng-model="ctrl.size" ng-change="ctrl.page.getWithNewSize(ctrl.size)" ng-options="i as i for i in ctrl.pageSizes"> </select> </div> <span class="pnc-page-controls-pager"> <button type="button" class="btn btn-default btn-md" ng-click="ctrl.page.previous()" ng-disabled="!ctrl.page.hasPrevious()"><span class="i fa fa-angle-left"></span> Prev</button> <span style="page-input-wrapper"><input type="text" ng-model="ctrl.index" size="3" ng-keypress="($event.which === 13) ? ctrl.getPageIfExists(ctrl.index) : false"></span><span class="of-x-pages">of {{ ctrl.total }}</span> <button type="button" class="btn btn-default btn-md" ng-click="ctrl.page.next()" ng-disabled="!ctrl.page.hasNext()">Next <span class="i fa fa-angle-right"></span></button> </span> </div> '),e.put("common/restclient/pagination/directives/pager.html",' <div> <div ng-show="page.getPageCount() > 1" class="pull-right">Page {{ page.getPageIndex()+1 }} of {{ page.getPageCount() }}</div> <div class="text-center"> <ul ng-show="page.getPageCount() > 1" class="pagination"> <li ng-show="page.hasPrevious()"> <a ng-click="page.first()" href title="First Page"> <span class="i fa fa-angle-left"></span> <span class="i fa fa-angle-left"></span> </a> </li> <li ng-show="page.hasPrevious()"> <a ng-click="page.previous()" href title="Previous Page"> <span class="i fa fa-angle-left"></span> </a> </li> <li ng-repeat="index in range" ng-class="index === page.getPageIndex() ? \'active\' : \'\'"> <a ng-click="page.loadPageIndex(index)" href>{{ index + 1 }}</a> </li> <li ng-show="page.hasNext()"> <a ng-click="page.next()" href title="Next Page"> <span class="i fa fa-angle-right"></span> </a> </li> <li ng-show="page.hasNext()"> <a ng-click="page.last()" href title="Last Page"> <span class="i fa fa-angle-right"></span> <span class="i fa fa-angle-right"></span> </a> </li> </ul> </div> </div> '),e.put("common/restclient/pagination/directives/search-field.html",' <div class="form-group"> <div class="input-group" role="search"> <label class="sr-only" for="{{ inputId }}">Filter Results</label> <input id="{{ inputId }}" type="search" class="form-control" ng-model="searchText" ng-change="search()" placeholder="{{ \'Search \' + text + \'&hellip;\' }}"> <div class="input-group-addon" ng-class="{\'active\' : page.isLoaded }"> <i class="fa fa-search display-when-active"></i> <div class="spinner spinner-xs pull-right hide-when-active"></div> </div> </div> </div> '),e.put("common/select-modals/build-config-multi-select/add-build-config-widget.html",' <script type="text/ng-template" id="button-add-right"> {{ actionButton.name }}&nbsp;<span class="fa fa-angle-right"></span> <\/script> <div> <div class="row"> <div class="col-xs-12"> <pnc-project-typeahead on-select="$ctrl.select"></pnc-project-typeahead> <span id="helpBlock" class="help-block">Begin typing to select a Project, then select the desired Build Config from the list below.</span> </div> </div> <div class="row"> <div class="col-xs-12"> <pf-list-view class="list-group list-view-pf list-view-pf-view" id="add-build-groups-{{::$id}}" config="$ctrl.config" items="$ctrl.buildConfigs" action-buttons="$ctrl.actionButtons" ng-if="$ctrl.buildConfigs.length > 0"> <div class="list-view-pf-description"> <div class="list-group-item-heading"> {{ item.name }} </div> </div> </pf-list-view> </div> </div> </div> '),e.put("common/select-modals/build-config-multi-select/build-config-multi-select.html",' <div> <div class="modal-header"> <h3 class="modal-title">{{ $ctrl.title }}</h3> </div> <div class="modal-body"> <div class="row"> <div class="col-xs-6"> <h4>Select Build Configs</h4> <add-build-config-widget on-add="$ctrl.onAdd(buildConfig)"></add-build-config-widget> </div> <div class="col-xs-6 border-before"> <h4>Selected Build Configs</h4> <remove-build-configs-widget build-configs="$ctrl.buildConfigs" on-remove="$ctrl.onRemove(buildConfig)"></remove-build-configs-widget> </div> </div> </div> <div class="modal-footer"> <button class="btn btn-primary" type="button" ng-click="$ctrl.save()">Save</button> <button class="btn btn-default" type="button" ng-click="$ctrl.cancel()">Cancel</button> </div> </div> '),e.put("common/select-modals/build-config-multi-select/remove-build-configs-widget.html",' <div> <pf-list-view class="list-group list-view-pf list-view-pf-view" id="remove-build-groups-{{::$id}}" config="$ctrl.config" items="$ctrl.buildConfigs" action-buttons="$ctrl.actionButtons" ng-if="$ctrl.buildConfigs.length > 0"> <div class="list-view-pf-description"> <div class="list-group-item-heading"> {{ item.name }} </div> </div> </pf-list-view> <p ng-if="$ctrl.buildConfigs.length === 0"><em>No Build Configs selected</em></p> </div> '),e.put("common/select-modals/build-group-multi-select.html",' <div> <div class="modal-header"> <h3 class="modal-title">{{ ctrl.title }}</h3> </div> <div class="modal-body"> <div class="row"> <div class="col-md-12"> <form role="form" class="search-pf has-button"> <div class="form-group has-clear"> <div class="search-pf-input-group"> <label for="search1" class="sr-only">Search</label> <input type="text" name="selectGroup" class="form-control combobox" id="select-build-group" placeholder="Enter build group name to search..." autocomplete="off" ng-model="ctrl.input" uib-typeahead="group as group.name for group in ctrl.fetchGroups($viewValue)" typeahead-on-select="ctrl.onSelect($item, $model, $label)" typeahead-wait-ms="300" typeahead-loading="ctrl.isLoading"> <button type="button" class="clear" aria-hidden="true"><span ng-show="ctrl.isLoading" class="spinner spinner-xs spinner-inline"></span></button> </div> </div> <div class="form-group"> <button class="btn btn-default" type="button"><span class="fa fa-search"></span></button> </div> </form> </div> </div> <div class="row"> <div class="col-md-12"> <pf-list-view class="list-group list-view-pf list-view-pf-view" id="build-group-list" config="ctrl.config" items="ctrl.selected" action-buttons="ctrl.actionButtons"> <div class="list-view-pf-description"> <div class="list-group-item-heading"> {{item.name}} </div> </div> </pf-list-view> </div> </div> </div> <div class="modal-footer"> <button class="btn btn-primary" type="button" ng-click="ctrl.save()">Save</button> <button class="btn btn-default" type="button" ng-click="ctrl.close()">Cancel</button> </div> </div> '),e.put("common/select-modals/product-version-single-select.html",' <div> <div class="modal-header"> <h3 class="modal-title">{{ ctrl.title }}</h3> </div> <div class="modal-body"> <div class="row"> <div class="col-md-12"> <form role="form" class="search-pf has-button"> <div class="form-group has-clear"> <div class="search-pf-input-group"> <label for="search1" class="sr-only">Search</label> <input type="text" name="selectGroup" class="form-control combobox" id="select-build-group" placeholder="Enter product name to start..." autocomplete="off" ng-model="ctrl.input" uib-typeahead="product as product.name for product in ctrl.fetchProducts($viewValue)" typeahead-on-select="ctrl.onSelectProduct($item, $model, $label)" typeahead-wait-ms="300" typeahead-loading="ctrl.isLoading"> <button type="button" class="clear" aria-hidden="true"><span ng-show="ctrl.isLoading" class="spinner spinner-xs spinner-inline"></span></button> </div> </div> <div class="form-group"> <button class="btn btn-default" type="button"><span class="fa fa-search"></span></button> </div> </form> <span id="helpBlock" class="help-block">Begin typing to select a product, then select the desired version from the list below. Note: a build group can be associated with <em>only one</em> product version.</span> </div> </div> <div class="row"> <div class="col-md-12"> <pf-list-view class="list-group list-view-pf list-view-pf-view cursor-pointer" id="build-group-list" config="ctrl.config" items="ctrl.selectedProduct.productVersionRefs" action-buttons="ctrl.actionButtons" ng-if="ctrl.selectedProduct.productVersionRefs"> <div class="list-view-pf-description"> <div class="list-group-item-heading"> {{ item.productName }}: {{ item.version }} </div> </div> </pf-list-view> </div> </div> </div> <div class="modal-footer"> <button class="btn btn-primary" type="button" ng-click="ctrl.save()" ng-disabled="!ctrl.selectedVersion">Save</button> <button class="btn btn-default" type="button" ng-click="ctrl.close()">Cancel</button> </div> </div> '),e.put("common/templates/footer.tmpl.html",' <p> <a href="https://github.com/project-ncl/pnc">PNC</a> <span> (Version: @project.version@ @datetime@ Rev: @git.commit.id.abbrev@)</span> <span> | </span> Red Hat, Inc. © 2018 </p> '),e.put("common/templates/single-col-center.tmpl.html",' <div class="row"> <div class="col-md-8 col-md-offset-2" ui-view> </div> </div> '),e.put("common/templates/single-col.tmpl.html",' <div class="row"> <div class="col-md-12" ui-view></div> </div> '),e.put("common/templates/two-col-left-sidebar.tmpl.html",' <div class="row"> <div class="col-sm-9 col-md-10 col-sm-push-3 col-md-push-2" ui-view> </div> <div class="col-sm-3 col-md-2 col-sm-pull-9 col-md-pull-10 sidebar-pf sidebar-pf-left" ui-vew="sidebar"> </div> </div> '),e.put("common/templates/two-col-right-sidebar.tmpl.html",' <div class="row"> <div class="col-sm-8 col-lg-9" ui-view> </div> <div class="col-sm-4 col-lg-3 sidebar sidebar-right" ui-view="sidebar"> </div> </div> '),e.put("common/templates/uiBreadcrumbs.tpl.html",' <ol class="breadcrumb"> <li ng-repeat="crumb in breadcrumbs" ng-class="{ active: $last }"><a ui-sref="{{ crumb.route }}" ng-if="!$last">{{ crumb.displayName }}&nbsp;</a><span ng-show="$last">{{ crumb.displayName }}</span> </li> </ol>'),e.put("configuration-set-record/directives/pnc-group-builds/pnc-group-builds.html",' <div> <pnc-search-field class="search" page="page" text="group builds"></pnc-search-field> <pnc-build-records-list build-group-records="page.data"></pnc-build-records-list> <pnc-pager class="pull-right" page="page"></pnc-pager> </div> '),e.put("configuration-set-record/directives/pncRecentBuildsForCSSet/pnc-recent-builds-for-cs-set.html",' <div class="panel panel-default" ng-show="page.data.length"> <div class="panel-heading"> Finished Builds </div> <pnc-build-records-list build-records="page.data" display-fields="columns" class="inside-panel"></pnc-build-records-list> <pnc-pager class="pull-right" page="page"></pnc-pager> </div> '),e.put("configuration-set-record/directives/pncRunningBuildsForCSSet/pnc-running-builds-for-cs-set.html",' <div class="panel panel-default" ng-show="page.data.length"> <div class="panel-heading"> Running Builds </div> <pnc-build-records-list build-records="page.data"></pnc-build-records-list> <pnc-pager class="pull-right" page="page"></pnc-pager> </div> '),e.put("configuration-set-record/views/record.detail.html",' <div class="row margin-bottom-md"> <div class="col-md-12"> <div class="page-header border-none"> <div class="btn-group pull-right" role="group" aria-label="Build Actions"> <pnc-build-record-push-button build-group-record="ctrl.csRecordDetail"></pnc-build-record-push-button> </div> <h1> <pnc-build-status-icon build-record="ctrl.csRecordDetail" no-warnings="true"></pnc-build-status-icon> Build #{{ ctrl.csRecordDetail.id }} of group {{ ctrl.csRecordDetail.buildConfigurationSetName }} <pnc-temporary-build-record-label build-group-record="ctrl.csRecordDetail" class="label-sm"></pnc-temporary-build-record-label> </h1> </div> </div> </div> <div class="row"> <div class="col-md-12"> <ul class="nav nav-tabs push-down"> <li role="presentation" ui-sref-active="active"><a href ui-sref="configuration-set-record.detail.info">Build Group Info</a></li> </ul> </div> </div> <div class="row"> <div class="col-md-12" ui-view></div> </div> '),e.put("configuration-set-record/views/record.detail.info.html",' <div class="push-down"> <dl class="dl-horizontal"> <dt>Built by:</dt> <dd>{{ ctrl.csRecordDetail.username }}</dd> <div> <pnc-running-builds-for-c-s-set bc-set-record-id="ctrl.csRecordDetail.id"></pnc-running-builds-for-c-s-set> <pnc-recent-builds-for-c-s-set bc-set-record-id="ctrl.csRecordDetail.id"></pnc-recent-builds-for-c-s-set> </div> </dl> </div> '),e.put("configuration-set-record/views/record.detail.output.html",' <div> <h3>Build Artifacts for builds in this group</h3> <div ng-hide="!ctrl.recordsArtifacts.length"> <input ng-model="searchText" placeholder="Filter artifacts..."> <table class="table table-bordered table-striped"> <thead> <th>Identifier</th> <th>File Name</th> <th>Status</th> <th>Actions</th> <th>Build Configuration Name</th> <th>Build Record</th> </thead> <tbody ng-repeat="record in ctrl.recordsArtifacts"> <tr ng-repeat="artifact in record.artifacts | filter:searchText"> <td>{{ artifact.identifier }}</td> <td>{{ artifact.filename }}</td> <td>{{ artifact.status }}</td> <td class="text-center"><a ng-href="{{ artifact.publicUrl }}" target="_self" class="btn btn-primary">Download</a></td> <td>{{ record.getBuildConfiguration().name }}</td> <td><a href ui-sref="build-records.detail.default({recordId: record.id})"># {{ record.id }}</a></td> </tr> </tbody> </table> </div> <p ng-hide="ctrl.recordsArtifacts.length">No build artifacts available. There are probably no successfully finished builds yet.</p> </div> '),e.put("configuration-set-record/views/record.detail.result.html",' <h3>Logs for builds in this group</h3> <div class="panel panel-default" ng-repeat="record in ctrl.recordsLog"> <div class="panel-heading">Record # {{ record.id }}</div> <pre>\n    {{ record.log.payload || \'Zero length log returned.\' }}\n  </pre> </div> <p ng-hide="ctrl.recordsLog.length">No logs available. There are probably no finished builds yet.</p> '),e.put("configuration-set-record/views/record.list.html",' <div> <div class="page-header"> <h1>Group Builds</h1> </div> <pnc-group-builds></pnc-group-builds> </div> '),e.put("dashboard/directives/pnc-my-build-sets-panel.html",' <div class="panel panel-default" ng-if="show()"> <div class="panel-heading"> <div class="spinner spinner-sm pull-right" ng-hide="page.isLoaded"></div> <h3 class="panel-title">My Build Groups</h3> </div> <pnc-build-records-list build-group-records="page.data" display-fields="displayFields"></pnc-build-records-list> <pnc-page-controls class="pull-right m-t-10" pnc-page="page" ng-if="page"></pnc-page-controls> </div> '),e.put("dashboard/directives/pnc-my-builds-panel.html",' <div class="panel panel-default" ng-if="show()"> <div class="panel-heading"> <div class="spinner spinner-sm pull-right" ng-hide="page.isLoaded"></div> <h3 class="panel-title">My Builds</h3> </div> <pnc-build-records-list build-records="page.data" display-fields="displayFields"></pnc-build-records-list> <pnc-page-controls class="pull-right m-t-10" pnc-page="page" ng-if="page"></pnc-page-controls> </div> '),e.put("dashboard/views/dashboard.html",' <div class="page-header"> <h1>Dashboard</h1> </div> <div class="row"> <div class="col-md-12 col-lg-6"> <pnc-my-builds-panel></pnc-my-builds-panel> </div> <div class="col-md-12 col-lg-6"> <pnc-my-build-sets-panel></pnc-my-build-sets-panel> </div> <div class="col-md-12" ng-hide="ctrl.isAuthenticated()"> <p><a href ng-click="ctrl.login()">Log in</a> to see your recent builds.</p> </div> </div> '),e.put("error.html",' <div class="row"> <div class="col-sm-12 col-md-8 col-lg-6"> <h1>{{ errorCtrl.title }}</h1> <p>{{ errorCtrl.message }}</p> <p><a href ui-sref="dashboard" class="alert-link">Return to dashboard</a>.</p> <hr> </div> </div> '),e.put("milestone/directives/milestoneArtifacts/milestoneArtifacts.html",' <pnc-header> <pnc-header-title> <small>Shipped Artifacts</small> </pnc-header-title> </pnc-header> <table class="table table-bordered table-striped" ng-show="distributedArtifacts.data.length"> <thead> <th>Artifact ID</th> <th>Deployed URL</th> <th>Quality</th> </thead> <tbody> <tr ng-repeat="artifact in distributedArtifacts.data"> <td>{{ artifact.identifier }}</td> <td><a href="{{ artifact.publicUrl }}" title="Deployed URL">link</a></td> <td>{{ artifact.artifactQuality }}</td> </tr> </tbody> </table> <pnc-pager class="pull-right" page="distributedArtifacts"></pnc-pager> <div ng-hide="distributedArtifacts.data.length" class="text-center"> There are no results to display. </div> '),e.put("milestone/directives/milestoneBuilds/milestoneBuilds.html",' <pnc-header> <pnc-header-title> <small>Builds Performed</small> </pnc-header-title> </pnc-header> <div> <pnc-build-records-list build-records="performedBuilds.data" display-fields="displayFields"></pnc-build-records-list> <pnc-pager class="pull-right" page="performedBuilds"></pnc-pager> </div>'),e.put("milestone/views/milestone.close.html",' <div> <div class="page-header"> <h1>Close milestone {{ milestoneCloseCtrl.data.version }}</h1> </div> <div class="row"> <div class="col-md-8 col-lg-6"> <form novalidate class="form-horizontal" name="milestoneForm" ng-submit="milestoneCloseCtrl.submit()"> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group"> <label for="input-version" class="col-sm-2 control-label">Version</label> <div class="col-sm-10"> <div class="input-group"> <label for="input-version" class="control-label bigger-text">{{milestoneCloseCtrl.data.version}}</label> </div> </div> </div> <div class="form-group" ng-class="{ \'has-error\' : milestoneForm.downloadurl.$invalid && !milestoneForm.downloadurl.$pristine }"> <label for="input-downloadurl" class="col-sm-2 control-label"> Download URL&nbsp;<a uib-popover="Internal or public location to download the product distribution artifacts" popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <div class="input-group"> <input type="url" name="downloadurl" id="input-downloadurl" class="form-control" name="downloadUrl" ng-model="milestoneCloseCtrl.data.downloadUrl"> </div> <span class="help-block" ng-show="milestoneForm.downloadurl.$invalid && !milestoneForm.downloadurl.$pristine">Required field.</span> </div> </div> </div> </div> <div class="form-group"> <div class="col-sm-offset-2 col-sm-10"> <input type="submit" class="btn btn-primary" value="Close" ng-disabled="milestoneForm.$invalid"> <input type="reset" class="btn btn-default" value="Clear"> </div> </div> </form> </div> </div> </div> '),e.put("milestone/views/milestone.create-update.html",' <div> <div class="page-header"> <h1 ng-if="!milestoneCreateUpdateCtrl.isUpdating">Create milestone for {{ milestoneCreateUpdateCtrl.product.name }} {{ milestoneCreateUpdateCtrl.productVersion.version }}</h1> <h1 ng-if="milestoneCreateUpdateCtrl.isUpdating">Update milestone {{ milestoneCreateUpdateCtrl.data.version }} of {{ milestoneCreateUpdateCtrl.product.name }} {{ milestoneCreateUpdateCtrl.productVersion.version }}</h1> </div> <div class="row"> <div class="col-md-8 col-lg-6"> <form novalidate class="form-horizontal" name="milestoneForm" ng-submit="milestoneCreateUpdateCtrl.submit()"> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : milestoneForm.version.$invalid && !milestoneForm.version.$pristine }"> <label for="input-version" class="col-sm-2 control-label"> * Version&nbsp;<a uib-popover="Release part of the product version, e.g. \'0.ER1\' for product version \'1.0\'." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <div class="input-group"> <span class="input-group-addon">{{ milestoneCreateUpdateCtrl.productVersion.version }}.</span> <input required id="input-version" class="form-control" name="version" maxlength="255" ng-model="milestoneCreateUpdateCtrl.version" pattern="^[0-9]+\\.[\\w]+$" version-unique product-version="{{milestoneCreateUpdateCtrl.productVersion.version}}" product-version-id="{{milestoneCreateUpdateCtrl.productVersion.id}}"> </div> <span class="help-block" ng-show="milestoneForm.version.$error.required && !milestoneForm.version.$pristine">Required field.</span> <span class="help-block" ng-show="milestoneForm.version.$error.pattern && !milestoneForm.version.$pristine">Version must start with a number, followed by a dot and then a qualifier (e.g ER1)</span> <span class="help-block" ng-show="milestoneForm.version.$error.unique">Version is already in use.</span> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : milestoneForm.startingDate.$invalid && !milestoneForm.startingDate.$pristine }"> <label for="input-start-date" class="col-sm-2 control-label"> * Start Date&nbsp;<a uib-popover="Start date, e.g. \'2035/01/15\', time is set to noon UTC." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <div class="input-group"> <input type="text" class="form-control" uib-datepicker-popup="yyyy/MM/dd" ng-model="milestoneCreateUpdateCtrl.startingDate" is-open="milestoneCreateUpdateCtrl.startingDateOpen" ng-required="true"> <span class="input-group-btn"> <button type="button" class="btn btn-default" ng-click="milestoneCreateUpdateCtrl.startingDateOpen = !milestoneCreateUpdateCtrl.startingDateOpen"><i class="glyphicon glyphicon-calendar"></i></button> </span> </div> <span class="help-block" ng-show="milestoneForm.startingDate.$error.required && !milestoneForm.startingDate.$pristine">Required field.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\' : (milestoneForm.plannedEndDate.$invalid || milestoneCreateUpdateCtrl.invalidStartingPlannedEndDates(milestoneCreateUpdateCtrl.startingDate, milestoneCreateUpdateCtrl.plannedEndDate)) && !milestoneForm.plannedEndDate.$pristine }"> <label for="input-end-date" class="col-sm-2 control-label"> * Planned End Date&nbsp;<a uib-popover="Planned handoff date, e.g. \'2035/01/15\', time is set to noon UTC." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <div class="input-group"> <input type="text" class="form-control" uib-datepicker-popup="yyyy/MM/dd" ng-model="milestoneCreateUpdateCtrl.plannedEndDate" is-open="milestoneCreateUpdateCtrl.plannedEndDateOpen" ng-required="true"> <span class="input-group-btn"> <button type="button" class="btn btn-default" ng-click="milestoneCreateUpdateCtrl.plannedEndDateOpen = !milestoneCreateUpdateCtrl.plannedEndDateOpen"><i class="glyphicon glyphicon-calendar"></i></button> </span> </div> <span class="help-block" ng-show="milestoneForm.plannedEndDate.$error.required && !milestoneForm.plannedEndDate.$pristine">Required field.</span> <span class="help-block" ng-show="milestoneCreateUpdateCtrl.invalidStartingPlannedEndDates(milestoneCreateUpdateCtrl.startingDate, milestoneCreateUpdateCtrl.plannedEndDate) && !milestoneForm.plannedEndDate.$pristine">Planned release date must be after start date.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\' : milestoneForm.issuetrackerurl.$invalid && !milestoneForm.issuetrackerurl.$pristine }"> <label for="input-issuetrackerurl" class="col-sm-2 control-label"> * Issue Tracker URL&nbsp;<a uib-popover="Link to issues fixed in this milestone release" popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <div class="input-group"> <input type="url" required name="issuetrackerurl" id="input-issuetrackerurl" class="form-control" name="issueTrackerUrl" maxlength="255" ng-model="milestoneCreateUpdateCtrl.data.issueTrackerUrl"> </div> <span class="help-block" ng-show="milestoneForm.issuetrackerurl.$invalid && !milestoneForm.issuetrackerurl.$pristine">Malformed URL.</span> </div> </div> </div> </div> <div class="form-group"> <div class="col-sm-offset-2 col-sm-10"> <div class="checkbox"> <label> <input type="checkbox" id="input-set-current" name="current" ng-disabled="milestoneCreateUpdateCtrl.setCurrentMilestoneDisabled" ng-model="milestoneCreateUpdateCtrl.setCurrentMilestone"> Set as the current milestone for {{ milestoneCreateUpdateCtrl.product.name }} {{ milestoneCreateUpdateCtrl.productVersion.version }} </label> </div> </div> </div> <div class="form-group"> <div class="col-sm-offset-2 col-sm-10"> <input ng-if="!milestoneCreateUpdateCtrl.isUpdating" type="submit" class="btn btn-primary" value="Create" ng-disabled="milestoneForm.$invalid || (milestoneForm.plannedEndDate.$invalid || milestoneCreateUpdateCtrl.invalidStartingPlannedEndDates(milestoneCreateUpdateCtrl.startingDate, milestoneCreateUpdateCtrl.plannedEndDate))"> <input ng-if="milestoneCreateUpdateCtrl.isUpdating" type="submit" class="btn btn-primary" value="Update" ng-disabled="milestoneForm.$invalid || (milestoneForm.plannedEndDate.$invalid || milestoneCreateUpdateCtrl.invalidStartingPlannedEndDates(milestoneCreateUpdateCtrl.startingDate, milestoneCreateUpdateCtrl.plannedEndDate))"> <input type="reset" class="btn btn-default" value="Clear"> </div> </div> </form> </div> </div> </div> '),e.put("milestone/views/milestone.detail.html",' <div> <div class="row"> <div class="col-md-12"> <div class="page-header"> <h1>Product Milestone {{ milestoneDetailCtrl.data.version }}</h1> </div> <dl class="dl-horizontal"> <dt>Version</dt> <dd>{{ milestoneDetailCtrl.milestone.version }}</dd> <dt>Start Date</dt> <dd>{{ milestoneDetailCtrl.milestone.startingDate | date:\'yyyy/MM/dd\' }}</dd> <dt>Planned End Date</dt> <dd>{{ milestoneDetailCtrl.milestone.plannedEndDate | date:\'yyyy/MM/dd\' }}</dd> <dt>End Date</dt> <dd>{{ milestoneDetailCtrl.milestone.endDate | date:\'yyyy/MM/dd\' }}</dd> <dt>Issue Tracker URL</dt> <dd> <span ng-hide="milestoneDetailCtrl.milestone.issueTrackerUrl">&mdash;</span> <a ng-show="milestoneDetailCtrl.milestone.issueTrackerUrl" href="{{ milestoneDetailCtrl.milestone.issueTrackerUrl }}">{{ milestoneDetailCtrl.milestone.issueTrackerUrl }}</a> </dd> <dt>Status</dt> <dd>{{ milestoneDetailCtrl.latestRelease.status || \'Open\' }} <span ng-if="milestoneDetailCtrl.latestRelease.status">[ <a ui-sref="product.detail.version.milestoneDetail.log({ milestoneId: milestoneDetailCtrl.milestone.id })" href>View Log</a> ]</span></dd> </dl> </div> </div> <div class="row"> <div class="col-sm-6 col-md-6 col-sm-push-6 col-md-push-6"> <div class="row"> <div class="col-md-12" ui-view> <pnc-milestone-builds milestone="milestoneDetailCtrl.milestone" performed-builds="milestoneDetailCtrl.performedBuilds"></pnc-milestone-builds> </div> </div> </div> <div class="col-sm-6 col-md-6 col-sm-pull-6 col-md-pull-6"> <div class="row"> <div class="col-md-12" ui-view="sidebar"> <pnc-milestone-artifacts milestone="milestoneDetailCtrl.milestone" distributed-artifacts="milestoneDetailCtrl.distributedArtifacts"></pnc-milestone-artifacts> </div> </div> </div> </div> </div> '),e.put("milestone/views/milestone.detail.log.html",' <div class="row push-down"> <div class="col-md-12"> <div class="log">{{ milestoneLogCtrl.latestRelease.log }}</div> </div> </div> '),e.put("product/directives/pnc-label-link/pnc-label-link.html",' <script type="text/ng-template" id="tooltipTemplateMilestone.html"> <strong>Start Date: </strong>{{::$ctrl.item.startingDate | date:\'mediumDate\'}}<br>\n  <strong>Planned End Date: </strong>{{::$ctrl.item.plannedEndDate | date:\'mediumDate\'}}<br>\n  <strong>End Date: </strong>{{::$ctrl.item.endDate | date:\'mediumDate\'}}<br> <\/script> <script type="text/ng-template" id="tooltipTemplateRelease.html"> <strong>Release Date: </strong>{{::$ctrl.item.releaseDate | date:\'mediumDate\'}}<br>\n  <strong>Milestone: </strong>{{::$ctrl.milestone.version }}<br>\n  <strong>Support Level: </strong>{{::$ctrl.item.supportLevel }}<br> <\/script> <span class="inline-block m-t-5 m-b-5"> <a ng-if="::$ctrl.isMilestone" class="label label-default" ng-class="{ \'label-primary\' : $ctrl.isPrimary }" ui-sref="product.detail.version.milestoneDetail({milestoneId: $ctrl.item.id, productId: $ctrl.productId, versionId: $ctrl.item.productVersionId})" tooltip-placement="right" uib-tooltip-template="\'tooltipTemplateMilestone.html\'"> {{ ::$ctrl.item.version }} </a> <span ng-if="::$ctrl.isRelease" class="label label-success" tooltip-placement="right" uib-tooltip-template="\'tooltipTemplateRelease.html\'"> {{ ::$ctrl.item.version }} </span> </span>'),e.put("product/directives/pncProductVersionBCs/pnc-product-version-bcs.html",' <pnc-header sub-header="true"> <pnc-header-title>Build Configs</pnc-header-title> </pnc-header> <pnc-search-field class="search" page="page" text="build configs"></pnc-search-field> <br><br> <table class="table table-bordered table-striped"> <thead> <th>Name</th> <th>Description</th> <th>Project</th> <th>Last Executed Build</th> <th>Action</th> </thead> <tbody> <tr ng-repeat="configuration in page.data"> <td> <a ui-sref="build-configs.detail({configurationId: configuration.id})" href>{{ configuration.name }}</a> </td> <td>{{ configuration.description }}</td> <td>{{ configuration.project.name }}</td> <td> <pnc-latest-build build-config="configuration"></pnc-latest-build> </td> <td class="table-data-5-column-even-width"> <pnc-build-start build-config="configuration" size="md"></pnc-build-start> </td> </tr> </tbody> </table> <pnc-pager class="pull-right" page="page"></pnc-pager> '),e.put("product/directives/pncProductVersionBCSets/pnc-product-version-bcsets.html",' <pnc-header sub-header="true"> <pnc-header-title>Build Groups</pnc-header-title> <pnc-header-buttons> <button type="button" class="btn btn-default" uib-tooltip="Create a new build group and add it to this product version" tooltip-popup-delay="2500" tooltip-placement="top" tooltip-append-to-body="true" ui-sref="build-groups.create({ productId: product.id, versionId: version.id })"> <i class="fa fa-file-text-o"></i>&nbsp;Create </button> <button type="button" class="btn btn-default" uib-tooltip="Create a new build group and add it to this product version" tooltip-popup-delay="2500" tooltip-placement="top" tooltip-append-to-body="true" ng-click="ctrl.edit()" pnc-requires-auth> <i class="pficon pficon-edit"></i>&nbsp;Edit </button> </pnc-header-buttons> </pnc-header> <pnc-search-field class="search" page="page" text="build groups"></pnc-search-field> <br><br> <table class="table table-bordered table-striped"> <thead> <th>Name</th> <th>Last Executed Build</th> <th>Actions</th> </thead> <tbody> <tr ng-repeat="buildconfigurationset in page.data"> <td><a href ui-sref="build-groups.detail.build-configs({ configurationSetId: buildconfigurationset.id })">{{ buildconfigurationset.name }}</a></td> <td> <pnc-latest-build build-group="buildconfigurationset"></pnc-latest-build> </td> <td class="table-data-5-column-even-width"> <pnc-build-start build-group="buildconfigurationset" size="md"></pnc-build-start> </td> </tr> </tbody> </table> <pnc-pager class="pull-right" page="page"></pnc-pager> '),e.put("product/directives/pncProductVersionMilestones/pnc-product-version-milestones.html",' <pnc-header sub-header="true"> <pnc-header-title>Milestones</pnc-header-title> <pnc-header-buttons> <button type="button" class="btn btn btn-default" data-toggle="tooltip" title="Create Milestone" ui-sref="product.detail.version.milestoneCreate"> <i class="fa fa-file-text-o"></i> Create </button> </pnc-header-buttons> </pnc-header> <table class="table table-bordered table-striped"> <thead> <th>Name</th> <th>Starting date</th> <th>Planned release date</th> <th>Release date</th> <th>Deliverables</th> <th>Actions</th> </thead> <tbody> <tr ng-repeat="productmilestone in version.productMilestones | orderBy:\'version\'"> <td> <pnc-label-link item="productmilestone" product-id="product.id" current-id="version.currentProductMilestoneId"></pnc-label-link> </td> <td>{{ productmilestone.startingDate | date:\'yyyy/MM/dd\'}}</td> <td>{{ productmilestone.plannedEndDate | date:\'yyyy/MM/dd\'}}</td> <td>{{ productmilestone.endDate | date:\'yyyy/MM/dd\'}}</td> <td class="text-center"> <a ng-show="productmilestone.downloadUrl != undefined" ng-href="{{ productmilestone.downloadUrl }}" target="_self" class="btn btn-default" title="Download Deliverables"> <i class="glyphicon glyphicon-download-alt"></i> </a> </td> <td ng-if="productmilestone.endDate == undefined" class="text-center"> <a pnc-confirm-click="markCurrentMilestone(productmilestone)" pnc-confirm-message="{{ \'Mark Milestone \' + productmilestone.version + \' as current ?\'}}" title="Mark Milestone as current" class="btn btn-default" pnc-requires-auth><i class="fa fa-clock-o"></i></a> <a ui-sref="product.detail.version.milestoneUpdate({ milestoneId: productmilestone.id })" title="Update Milestone" class="btn btn-default"><i class="pficon pficon-edit"></i></a> <a ui-sref="product.detail.version.milestoneClose({ milestoneId: productmilestone.id })" title="Close Milestone" class="btn btn-default"><i class="fa fa-lock"></i></a> </td> <td ng-if="productmilestone.endDate != undefined" class="text-center" title="Milestone is already closed. No more modifications allowed."> Milestone is closed <span class="fa fa-info-circle"></span> </td> </tr> </tbody> </table> '),e.put("product/directives/pncProductVersionReleases/pnc-product-version-releases.html",' <pnc-header sub-header="true"> <pnc-header-title>Releases</pnc-header-title> <pnc-header-buttons> <button type="button" class="btn btn-lg btn-default" data-toggle="tooltip" title="Create Release" ui-sref="product.detail.version.releaseCreate" ng-disabled="version.productMilestones.length < 1"> <i class="fa fa-file-text-o"></i> Create </button> </pnc-header-buttons> </pnc-header> <table class="table table-bordered table-striped"> <thead> <th>Name</th> <th>Release date</th> <th>Deliverables</th> <th>Info</th> <th>Support Level</th> <th>Actions</th> </thead> <tbody> <tr ng-repeat="productrelease in version.productReleases | orderBy:\'version\'"> <td> <pnc-label-link item="productrelease"></pnc-label-link> </td> <td>{{ productrelease.releaseDate | date:\'yyyy/MM/dd\'}}</td> <td class="text-center"> <a ng-show="productrelease.downloadUrl != undefined" ng-href="{{ productrelease.downloadUrl }}" target="_self" class="btn btn-default" title="Download Deliverables"> <i class="glyphicon glyphicon-download-alt"></i> </a> </td> <td>Released from Milestone <strong>{{ versionMilestoneNames[productrelease.productMilestoneId] }}</strong></td> <td>{{ productrelease.supportLevel }}</td> <td> <button type="button" class="btn btn-sm btn-default" data-toggle="tooltip" title="Edit Release" ui-sref="product.detail.version.releaseUpdate({ releaseId: productrelease.id })"> <i class="pficon pficon-edit"></i> </button> <button type="button" class="btn btn-sm btn-danger disabled" data-toggle="tooltip" title="Delete Release"> <i class="pficon pficon-delete"></i> </button> </td> </tr> </tbody> </table> '),e.put("product/directives/pncProductVersions/pnc-product-versions.html",' <script type="text/ng-template" id="milestoneTooltipTemplate.html"> <strong>-- {{milestone.version}} --</strong><br>\n     <strong>Phase: </strong> &lt;tbd&gt; <br>\n     <strong>Starting Date: </strong>{{milestone.startingDate | date:\'mediumDate\'}}<br>\n     <strong>Planned Release Date: </strong>{{milestone.plannedEndDate | date:\'mediumDate\'}}<br>\n     <strong>Release Date: </strong>{{milestone.endDate | date:\'mediumDate\'}}<br> <\/script> <script type="text/ng-template" id="releaseTooltipTemplate.html"> <strong>-- {{release.version}} --</strong><br>\n     <strong>Phase: </strong> &lt;tbd&gt; <br>\n     <strong>Release Date: </strong>{{release.releaseDate | date:\'mediumDate\'}}<br>\n     <strong>Milestone: </strong>{{release.productMilestone.version }}<br>\n     <strong>Support Level: </strong>{{release.supportLevel }}<br> <\/script> <div class="row"> <div class="col-md-12"> <pnc-search-field class="search" page="page" text="product versions"></pnc-search-field> </div> </div> <div class="row"> <div class="col-md-12"> <table class="table table-bordered table-striped"> <thead> <th class="w-1-5">Version</th> <th class="w-2-5">Milestones</th> <th class="w-2-5">Releases</th> </thead> <tbody ng-show="page.isLoaded"> <tr ng-repeat="version in page.data"> <td class="bigger-text"> <a href ui-sref="product.detail.version({ productId: productId, versionId: version.id })"> {{ version.version }} </a> </td> <td> <span ng-repeat="milestone in version.productMilestones | orderBy: \'-milestone.startingDate\'"> <pnc-label-link item="milestone" product-id="productId" current-id="version.currentProductMilestoneId"></pnc-label-link> </span> </td> <td> <span ng-repeat="release in version.productReleases | orderBy: \'-release.releaseDate\'"> <pnc-label-link item="release"></pnc-label-link> </span> </td> </tr> </tbody> <tbody pnc-loading-placeholder columns="3" page="page"></tbody> </table> <pnc-pager class="pull-right" page="page"></pnc-pager> </div> </div> '),e.put("product/views/product.create.html",' <div> <div class="page-header"> <h1>Create Product</h1> </div> <div class="row"> <div class="col-md-10 col-lg-7"> <form class="form-horizontal" name="productForm" ng-submit="productCreateCtrl.submit()" novalidate> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : productForm.name.$invalid && productForm.name.$touched, \'has-success\': productForm.name.$valid && productForm.name.$touched }"> <label for="input-name" class="col-sm-2 control-label required">Name&nbsp; <a uib-popover="The extended name of the Product, e.g. JBoss® Enterprise Application Platform" popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> <div class="col-sm-10"> <input id="input-name" class="form-control" name="name" ng-model="productCreateCtrl.data.name" maxlength="255" required> <span class="help-block" ng-show="productForm.name.$error.required && productForm.name.$touched">Required field.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\' : productForm.description.$invalid && productForm.description.$touched, \'has-success\': productForm.description.$valid && productForm.description.$touched }"> <label for="input-description" class="col-sm-2 control-label">Description&nbsp; <a uib-popover="Description of the Product, e.g. JBoss® Enterprise Application Platform 6 provides an innovative modular, cloud-ready architecture, powerful management and automation, and world class developer productivity..." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> <div class="col-sm-10"> <textarea id="input-description" class="form-control" name="description" ng-model="productCreateCtrl.data.description"></textarea> </div> </div> <div class="form-group" ng-class="{ \'has-error\' : productForm.abbreviation.$invalid && productForm.abbreviation.$touched, \'has-success\': productForm.abbreviation.$valid && productForm.abbreviation.$touched }"> <label for="input-abbreviation" class="col-sm-2 control-label required">Short Name&nbsp; <a uib-popover="The abbreviation of the Product, e.g. EAP" popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> <div class="col-sm-10"> <input id="input-abbreviation" class="form-control" name="abbreviation" maxlength="255" ng-model="productCreateCtrl.data.abbreviation" required pattern="[a-zA-Z0-9-]*"> <span class="help-block" ng-show="productForm.abbreviation.$error.required && productForm.abbreviation.$touched">Required field.</span> <span class="help-block" ng-show="productForm.abbreviation.$error.pattern && productForm.abbreviation.$touched">Only letters, numbers and dashes (-) are allowed.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\' : productForm.productCode.$invalid && productForm.productCode.$touched, \'has-success\': productForm.productCode.$valid && productForm.productCode.$touched }"> <label for="input-productCode" class="col-sm-2 control-label">Product Code&nbsp; <a uib-popover="The official Product code to be used in URLs and filenames etc e.g. eap" popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> <div class="col-sm-10"> <input id="input-productCode" class="form-control" name="productCode" maxlength="255" ng-model="productCreateCtrl.data.productCode"> </div> </div> <div class="form-group" ng-class="{ \'has-error\' : productForm.pgmSystemName.$invalid && productForm.pgmSystemName.$touched, \'has-success\': productForm.pgmSystemName.$valid && productForm.pgmSystemName.$touched }"> <label for="input-pgmSystemName" class="col-sm-2 control-label">System Code&nbsp; <a uib-popover="The eventual code needed to integrate with external systems, portals, etc, i.e. jbosseap" popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> <div class="col-sm-10"> <input id="input-pgmSystemName" class="form-control" name="pgmSystemName" maxlength="255" ng-model="productCreateCtrl.data.pgmSystemName"> </div> </div> </div> </div> <div class="form-group text-right"> <div class="col-sm-offset-2 col-sm-10"> <input type="submit" class="btn btn-primary" value="Create" ng-disabled="productForm.$invalid"> <input type="reset" class="btn btn-default" value="Clear" ng-click="productCreateCtrl.reset(productForm)"> </div> </div> </form> </div> </div> </div> '),e.put("product/views/product.detail.html",' <div> <pnc-header> <pnc-header-title>{{ detailCtrl.product.name || \'Empty\' }}</pnc-header-title> <pnc-header-buttons> <button type="button" class="btn btn-lg btn-default" data-toggle="tooltip" title="Edit Product" ng-click="productForm.$show()" ng-class="{ \'active\': productForm.$visible }" pnc-requires-auth><i class="pficon pficon-edit"></i> Edit </button> <button ng-hide="true" type="button" class="btn btn-lg btn-danger disabled" data-toggle="tooltip" title="Delete Product" pnc-requires-auth> <i class="pficon pficon-delete"></i> Delete </button> </pnc-header-buttons> </pnc-header> <form editable-form class="form-horizontal" name="productForm" onbeforesave="detailCtrl.update()" novalidate> <div class="form-group" ng-class="{ \'has-error\': productForm.name.$invalid && productForm.name.$touched, \'has-success\': productForm.name.$valid && productForm.name.$touched }"> <label for="input-name" class="col-sm-1 control-label" ng-class="{ \'required\': productForm.$visible }">Name</label> <div class="col-sm-11"> <p id="input-name" class="form-control-static" e-class="form-control" editable-text="detailCtrl.product.name" e-name="name" e-maxlength="255" e-required>{{ detailCtrl.product.name || \'Empty\' }}</p> <span class="help-block" ng-show="productForm.name.$error.required && productForm.name.$touched">Required field.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': productForm.description.$invalid && productForm.description.$touched, \'has-success\': productForm.description.$valid && productForm.description.$touched }"> <label for="static-description" class="col-sm-1 control-label">Description</label> <div class="col-sm-11"> <p id="input-description" class="form-control-static" e-class="form-control" editable-textarea="detailCtrl.product.description" e-name="description">{{ detailCtrl.product.description }}</p> </div> </div> <div class="form-group" ng-class="{ \'has-error\': productForm.abbreviation.$invalid && productForm.abbreviation.$touched, \'has-success\': productForm.abbreviation.$valid && productForm.abbreviation.$touched }"> <label for="input-abbreviation" class="col-sm-1 control-label" ng-class="{ \'required\': productForm.$visible }">Short Name</label> <div class="col-sm-11"> <p id="input-abbreviation" class="form-control-static" e-class="form-control" editable-text="detailCtrl.product.abbreviation" e-name="abbreviation" e-maxlength="255" e-pattern="[a-zA-Z0-9-]*" e-required>{{ detailCtrl.product.abbreviation }}</p> <span class="help-block" ng-show="productForm.abbreviation.$error.required && productForm.abbreviation.$touched">Required field.</span> <span class="help-block" ng-show="productForm.abbreviation.$error.pattern && productForm.abbreviation.$touched">Only letters, numbers and dashes (-) are allowed.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': productForm.productCode.$invalid && productForm.productCode.$touched, \'has-success\': productForm.productCode.$valid && productForm.productCode.$touched }"> <label for="input-productCode" class="col-sm-1 control-label">Product Code</label> <div class="col-sm-11"> <p id="input-productCode" class="form-control-static" e-class="form-control" editable-text="detailCtrl.product.productCode" e-name="productCode" e-maxlength="255">{{ detailCtrl.product.productCode }}</p> </div> </div> <div class="form-group" ng-class="{ \'has-error\': productForm.pgmSystemName.$invalid && productForm.pgmSystemName.$touched, \'has-success\': productForm.pgmSystemName.$valid && productForm.pgmSystemName.$touched }"> <label for="input-pgmSystemName" class="col-sm-1 control-label">System Code</label> <div class="col-sm-11"> <p id="input-pgmSystemName" class="form-control-static" e-class="form-control" editable-text="detailCtrl.product.pgmSystemName" e-name="pgmSystemName" e-maxlength="255">{{ detailCtrl.product.pgmSystemName }}</p> </div> </div> <div class="form-group" ng-show="productForm.$visible"> <div class="col-sm-offset-1 col-sm-11"> <button type="submit" class="btn btn-primary" ng-disabled="productForm.$waiting || productForm.$invalid"> Save </button> <button type="button" class="btn btn-default" ng-disabled="productForm.$waiting" ng-click="productForm.$cancel(); productForm.$setPristine(); productForm.$setUntouched();"> Cancel </button> </div> </div> </form> <pnc-header sub-header="true"> <pnc-header-title>Product Versions</pnc-header-title> <pnc-header-buttons> <div class="p-l-10"> <button type="button" class="btn btn-lg btn-default" data-toggle="tooltip" title="Create Product Version" ui-sref="product.detail.createVersion({ productId: detailCtrl.product.id })"> <i class="fa fa-file-text-o"></i> Create </button> </div> </pnc-header-buttons> </pnc-header> <pnc-product-versions product-id="detailCtrl.product.id"></pnc-product-versions> </div> '),e.put("product/views/product.list.html",' <div> <pnc-header> <pnc-header-title>Products</pnc-header-title> <pnc-header-buttons> <button type="button" class="btn btn-lg btn-default" data-toggle="tooltip" title="Create Product" ui-sref="product.create"> <i class="fa fa-file-text-o"></i> Create </button> </pnc-header-buttons> </pnc-header> <pnc-search-field class="search" page="listCtrl.products" text="products"></pnc-search-field> <table class="table table-bordered table-striped push-down"> <thead> <th>Name</th> <th>Short Name</th> <th>Description</th> <th>Product Code</th> <th>System Code</th> </thead> <tbody> <tr ng-repeat="product in listCtrl.products.data | filter:searchText"> <td><a href ui-sref="product.detail({ productId: product.id })">{{ product.name }}</a></td> <td>{{ product.abbreviation }}</td> <td>{{ product.description }}</td> <td>{{ product.productCode }}</td> <td>{{ product.pgmSystemName }}</td> </tr> </tbody> </table> <pnc-pager class="pull-right" page="listCtrl.products"></pnc-pager> </div> '),e.put("product/views/product.version.create.html",' <div> <div class="page-header"> <h1>Create Product Version</h1> </div> <div class="row"> <div class="col-md-8 col-lg-6"> <form class="form-horizontal" name="productVersionForm" ng-submit="productVersionCreateCtrl.submit()" novalidate> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : productVersionForm.version.$invalid && !productVersionForm.version.$pristine, \'has-success\': productVersionForm.version.$valid && productVersionForm.version.$touched }"> <label for="input-version" class="col-sm-2 control-label"> * Version&nbsp; <a uib-popover="This represents a set of milestones and releases which correspond to a major.minor version of a product, e.g 7.0" popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> <div class="col-sm-10"> <input id="input-version" class="form-control" name="version" maxlength="255" ng-model="productVersionCreateCtrl.data.version" required pattern="^[0-9]+\\.[0-9]+$"> <span class="help-block" ng-show="productVersionForm.version.$error.required && !productVersionForm.version.$pristine">Required field.</span> <span class="help-block" ng-show="productVersionForm.version.$error.pattern && !productVersionForm.version.$pristine">The version should consist of two numeric parts separated by a dot (e.g 7.0).</span> </div> </div> </div> </div> <div class="form-group"> <div class="col-sm-offset-2 col-sm-10"> <input type="submit" class="btn btn-primary" value="Create" ng-disabled="productVersionForm.$invalid"> <input type="reset" class="btn btn-default" value="Clear" ng-click="productVersionCreateCtrl.reset(productVersionForm)"> </div> </div> </form> </div> </div> </div> '),e.put("product/views/product.version.html",' <div> <pnc-header> <pnc-header-title>{{ versionCtrl.product.name + \' \' + versionCtrl.version.version || \'Empty\' }}</pnc-header-title> <pnc-header-buttons> <button type="button" class="btn btn-lg btn-default" data-toggle="tooltip" title="Edit Product Version" ng-click="productVersionForm.$show()" ng-class="{ \'active\': productVersionForm.$visible }" pnc-requires-auth><i class="pficon pficon-edit"></i> Edit </button> <button ng-hide="true" type="button" class="btn btn-lg btn-danger disabled" data-toggle="tooltip" title="Delete Version" pnc-requires-auth> <i class="pficon pficon-delete"></i> Delete </button> </pnc-header-buttons> </pnc-header> <form editable-form class="form-horizontal" name="productVersionForm" onbeforesave="versionCtrl.update(productVersionForm)" novalidate> <div class="form-group" ng-class="{ \'has-error\': productVersionForm.version.$invalid && !productVersionForm.version.$pristine, \'has-success\': productVersionForm.version.$valid && productVersionForm.version.$touched }"> <label for="input-version" class="col-sm-1 control-label" ng-class="{ \'required\': productVersionForm.$visible }">Version</label> <div class="col-sm-11"> <p id="input-version" e-pattern="^[0-9]+\\.[0-9]+$" e-class="form-control" editable-text="versionCtrl.version.version" e-name="version" e-maxlength="255" e-required>{{ versionCtrl.version.version || \'Empty\' }} </p> <span class="help-block" ng-show="productVersionForm.version.$error.required && !productVersionForm.version.$pristine">Required field.</span> <span class="help-block" ng-show="productVersionForm.version.$error.pattern && !productVersionForm.version.$pristine">The version should consist of two numeric parts separated by a dot (e.g 7.0).</span> </div> </div> <div class="form-group"> <label for="input-name" class="col-sm-1 control-label">Product Name</label> <div class="col-sm-11"> <a id="input-name" href ui-sref="product.detail({ productId: versionCtrl.product.id})"> {{ versionCtrl.product.name || \'Empty\' }} </a> </div> </div> <div class="form-group"> <label for="static-description" class="col-sm-1 control-label">Product Description</label> <div class="col-sm-11"> <p id="static-description" class="form-control-static">{{ versionCtrl.product.description || \'Empty\' }}</p> </div> </div> <div class="form-group" ng-class="{ \'has-error\': productVersionForm.brewTagPrefix.$invalid && !productVersionForm.brewTagPrefix.$pristine, \'has-success\': productVersionForm.brewTagPrefix.$valid && productVersionForm.brewTagPrefix.$touched }"> <label for="brewTagPrefix" class="col-sm-1 control-label" ng-class="{ \'required\': productVersionForm.$visible }">Brew Tag Prefix</label> <div class="col-sm-11"> <p id="brewTagPrefix" e-class="form-control" editable-text="versionCtrl.version.attributes.BREW_TAG_PREFIX" e-name="brewTagPrefix" e-maxlength="255" e-required>{{ versionCtrl.version.attributes.BREW_TAG_PREFIX || \'Empty\' }}</p> <span class="help-block" ng-show="productVersionForm.brewTagPrefix.$error.required && !productVersionForm.brewTagPrefix.$pristine">Required field.</span> </div> </div> <div class="form-group" ng-show="productVersionForm.$visible"> <div class="col-sm-offset-1 col-sm-11"> <button type="submit" class="btn btn-primary" ng-disabled="productVersionForm.$waiting || productVersionForm.$invalid"> Save </button> <button type="button" class="btn btn-default" ng-disabled="productVersionForm.$waiting" ng-click="productVersionForm.$cancel(); productVersionForm.$setPristine(); productVersionForm.$setUntouched();"> Cancel </button> </div> </div> </form> <div class="row"> <div class="col-sm-6 col-md-6 col-sm-push-6 col-md-push-6"> <div class="row"> <div class="col-md-12" ui-view> <pnc-product-version-releases version="versionCtrl.version"></pnc-product-version-releases> </div> </div> </div> <div class="col-sm-6 col-md-6 col-sm-pull-6 col-md-pull-6"> <div class="row"> <div class="col-md-12" ui-view="sidebar"> <pnc-product-version-milestones version="versionCtrl.version" product="versionCtrl.product"></pnc-product-version-milestones> </div> </div> </div> </div> <pnc-product-version-b-c-sets version="versionCtrl.version" product="versionCtrl.product"></pnc-product-version-b-c-sets> <pnc-product-version-b-cs version="versionCtrl.version"></pnc-product-version-b-cs> </div> '),e.put("projects/directives/pnc-build-configurations/pnc-build-configurations.html",' <pnc-search-field class="search" page="page" text="build configs"></pnc-search-field> <table class="table table-bordered table-striped table-hover push-down"> <thead> <th>Name</th> <th>Description</th> <th>SCM Repository</th> <th>SCM Revision</th> <th>Created</th> <th>Modified</th> </thead> <tbody> <tr ng-repeat="configuration in page.data"> <td> <a ui-sref="projects.detail.build-configs.detail({ projectId: configuration.project.id, configurationId: configuration.id })" href> {{ configuration.name }} </a> </td> <td>{{ configuration.description }}</td> <td>{{ configuration.scmRepoURL }}</td> <td>{{ configuration.scmRevision }}</td> <td>{{ configuration.creationTime | date:\'medium\'}}</td> <td>{{ configuration.lastModificationTime | date:\'medium\'}}</td> </tr> </tbody> </table> <pnc-pager class="pull-right" page="page"></pnc-pager> '),e.put("projects/views/projects.create.html",' <div> <div class="page-header"> <h1>Create Project</h1> </div> <div class="row"> <div class="col-md-10 col-lg-7"> <form name="projectForm" class="form-horizontal" novalidate> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\': projectForm.name.$invalid && projectForm.name.$touched, \'has-success\': projectForm.name.$valid && projectForm.name.$touched }"> <label for="input-name" class="col-sm-2 control-label"> * Name </label> <div class="col-sm-10"> <input type="text" id="input-name" class="form-control" name="name" maxlength="255" ng-model="project.name" required> <span class="help-block" ng-show="projectForm.name.$error.required && projectForm.name.$touched">Required field.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': projectForm.description.$invalid && projectForm.description.$touched, \'has-success\': projectForm.description.$valid && projectForm.description.$touched }"> <label for="input-description" class="col-sm-2 control-label">Description</label> <div class="col-sm-10"> <textarea id="input-description" class="form-control" name="description" ng-model="project.description"></textarea> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\': projectForm.projectUrl.$invalid && projectForm.projectUrl.$touched, \'has-success\': projectForm.projectUrl.$valid && projectForm.projectUrl.$touched }"> <label for="input-url" class="col-sm-2 control-label">Project URL</label> <div class="col-sm-10"> <input type="url" id="input-url" class="form-control" name="projectUrl" maxlength="255" ng-model="project.projectUrl"> <span class="help-block" ng-show="projectForm.projectUrl.$invalid && projectForm.projectUrl.$touched">Malformed URL.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': projectForm.issueTrackerUrl.$invalid && projectForm.issueTrackerUrl.$touched, \'has-success\': projectForm.issueTrackerUrl.$valid && projectForm.issueTrackerUrl.$touched }"> <label for="input-issue-tracker" class="col-sm-2 control-label">Issue Tracker URL</label> <div class="col-sm-10"> <input type="url" id="input-issue-tracker" class="form-control" name="issueTrackerUrl" maxlength="255" ng-model="project.issueTrackerUrl"> <span class="help-block" ng-show="projectForm.issueTrackerUrl.$invalid && projectForm.issueTrackerUrl.$touched">Malformed URL.</span> </div> </div> </div> </div> <div class="form-group text-right"> <div class="col-sm-offset-2 col-sm-10"> <input type="submit" class="btn btn-primary" value="Create" ng-click="createCtrl.create(project)" ng-disabled="projectForm.$invalid"> <input type="reset" class="btn btn-default" value="Clear" ng-click="createCtrl.reset(projectForm)"> </div> </div> </form> </div> </div> </div> '),e.put("projects/views/projects.detail.create-bc.html",' <div> <div class="page-header"> <h1>Create Build Configuration</h1> </div> <div class="row"> <div class="col-md-8 col-lg-6"> <pnc-configuration-create-panel fixed-project="{{ ctrl.fixedProject }}"></pnc-configuration-create-panel> </div> </div> </div> '),e.put("projects/views/projects.detail.html",' <div ui-view> <pnc-header> <pnc-header-title>{{ detailCtrl.project.name || \'Empty\' }}</pnc-header-title> <pnc-header-buttons> <button type="button" class="btn btn-lg btn-default" data-toggle="tooltip" title="Edit Project Metadata" ng-click="projectForm.$show()" pnc-requires-auth> <i class="pficon pficon-edit"></i> Edit </button> <button ng-hide="true" type="button" class="btn btn-lg btn-danger disabled" data-toggle="tooltip" title="Delete Project" pnc-requires-auth> <i class="pficon pficon-delete"></i> Delete </button> </pnc-header-buttons> </pnc-header> <form editable-form name="projectForm" class="form-horizontal" onbeforesave="detailCtrl.update()" novalidate> <div class="form-group" ng-class="{ \'has-error\': projectForm.name.$invalid && projectForm.name.$touched, \'has-success\': projectForm.name.$valid && projectForm.name.$touched }"> <label for="input-name" class="col-sm-1 control-label" ng-class="{ \'required\': projectForm.$visible }">Name</label> <div class="col-sm-11"> <p id="input-name" e-class="form-control" editable-text="detailCtrl.project.name" e-name="name" e-maxlength="255" e-required>{{ detailCtrl.project.name || \'Empty\' }}</p> <span class="help-block" ng-show="projectForm.name.$error.required && projectForm.name.$touched">Required field.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': projectForm.description.$invalid && projectForm.description.$touched, \'has-success\': projectForm.description.$valid && projectForm.description.$touched }"> <label for="input-description" class="col-sm-1 control-label">Description</label> <div class="col-sm-11"> <p id="input-description" e-class="form-control" editable-text="detailCtrl.project.description" e-name="description">{{ detailCtrl.project.description || \'Empty\' }}</p> </div> </div> <div class="form-group" ng-class="{ \'has-error\': projectForm.projectUrl.$invalid && projectForm.projectUrl.$touched, \'has-success\': projectForm.projectUrl.$valid && projectForm.projectUrl.$touched }"> <label for="input-url" class="col-sm-1 control-label">URL</label> <div class="col-sm-11"> <p id="input-url" e-type="url" e-class="form-control" editable-text="detailCtrl.project.projectUrl" e-name="projectUrl" e-maxlength="255">{{ detailCtrl.project.projectUrl || \'Empty\' }}</p> <span class="help-block" ng-show="projectForm.projectUrl.$invalid && projectForm.projectUrl.$touched">Malformed URL.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': projectForm.issueTrackerUrl.$invalid && projectForm.issueTrackerUrl.$touched, \'has-success\': projectForm.issueTrackerUrl.$valid && projectForm.issueTrackerUrl.$touched }"> <label for="input-issue-tracker" class="col-sm-1 control-label">Issue tracker</label> <div class="col-sm-11"> <p id="input-issue-tracker" e-type="url" e-class="form-control" editable-text="detailCtrl.project.issueTrackerUrl" e-name="issueTrackerUrl" e-maxlength="255">{{ detailCtrl.project.issueTrackerUrl || \'Empty\' }}</p> <span class="help-block" ng-show="projectForm.issueTrackerUrl.$invalid && projectForm.issueTrackerUrl.$touched">Malformed URL.</span> </div> </div> <div class="form-group" ng-show="projectForm.$visible"> <div class="col-sm-offset-1 col-sm-11"> <button type="submit" class="btn btn-primary" ng-disabled="projectForm.$waiting || projectForm.$invalid"> Save </button> <button type="button" class="btn btn-default" ng-disabled="projectForm.$waiting" ng-click="projectForm.$cancel(); projectForm.$setPristine(); projectForm.$setUntouched();"> Cancel </button> </div> </div> </form> <pnc-header> <pnc-header-title><small>Build Configs</small></pnc-header-title> <pnc-header-buttons> <pnc-create-build-config-button project="detailCtrl.project"></pnc-create-build-config-button> </pnc-header-buttons> </pnc-header> <pnc-build-configurations pnc-project="detailCtrl.project"></pnc-build-configurations> </div> '),e.put("projects/views/projects.list.html",' <pnc-header> <pnc-header-title>Projects</pnc-header-title> <pnc-header-buttons> <button type="button" ui-sref="projects.create" class="btn btn-lg btn-default" data-toggle="tooltip" title="Create Project Metadata"> <i class="fa fa-file-text-o"></i> Create </button> </pnc-header-buttons> </pnc-header> <div class="row"> <div class="col-md-12"> <pnc-search-field class="search" page="listCtrl.projects" text="projects metadata"></pnc-search-field> <table class="table table-bordered table-striped"> <thead> <th>Name</th> <th>Description</th> </thead> <tbody> <tr ng-repeat="project in listCtrl.projects.data"> <td><a href ui-sref="projects.detail({ projectId: project.id })">{{ project.name }}</a></td> <td>{{ project.description }}</td> </tr> </tbody> </table> <pnc-pager class="pull-right" page="listCtrl.projects"></pnc-pager> </div> </div> '),e.put("release/views/release.create-update.html",' <div> <div class="page-header"> <h1 ng-if="!releaseCreateUpdateCtrl.isUpdating">Create release for {{ releaseCreateUpdateCtrl.product.name }} {{ releaseCreateUpdateCtrl.productVersion.version }}</h1> <h1 ng-if="releaseCreateUpdateCtrl.isUpdating">Update release {{ releaseCreateUpdateCtrl.data.version }} of {{ releaseCreateUpdateCtrl.product.name }} {{ releaseCreateUpdateCtrl.productVersion.version }}</h1> </div> <div class="row"> <div class="col-md-8 col-lg-6"> <form class="form-horizontal" name="releaseForm" novalidate ng-submit="releaseCreateUpdateCtrl.submit()"> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : releaseForm.version.$invalid && !releaseForm.version.$pristine }"> <label for="input-version" class="col-sm-2 control-label"> * Version&nbsp;<a uib-popover="Release part of the product version, e.g. \'0.GA\' for product version \'1.0\'." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <div class="input-group"> <span class="input-group-addon">{{ releaseCreateUpdateCtrl.productVersion.version }}.</span> <input required id="input-version" class="form-control" name="version" maxlength="255" ng-model="releaseCreateUpdateCtrl.version" pattern="^[0-9]+\\.[\\w]+$"> </div> <span class="help-block" ng-show="releaseForm.version.$error.required && !releaseForm.version.$pristine">Required field.</span> <span class="help-block" ng-show="releaseForm.version.$error.pattern && !releaseForm.version.$pristine">Version must start with a number, followed by a dot and then a qualifier (e.g GA)</span> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : releaseForm.releaseDate.$invalid && !releaseForm.releaseDate.$pristine }"> <label for="input-end-date" class="col-sm-2 control-label"> * Release date&nbsp;<a uib-popover="Release date, e.g. \'2035/01/15\', time is set to noon UTC." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <div class="input-group"> <input type="text" class="form-control" uib-datepicker-popup="yyyy/MM/dd" ng-model="releaseCreateUpdateCtrl.releaseDate" is-open="releaseCreateUpdateCtrl.releaseDateOpen" ng-required="true"> <span class="input-group-btn"> <button type="button" class="btn btn-default" ng-click="releaseCreateUpdateCtrl.releaseDateOpen = !releaseCreateUpdateCtrl.releaseDateOpen"><i class="glyphicon glyphicon-calendar"></i></button> </span> </div> <span class="help-block" ng-show="releaseForm.releaseDate.$error.required && !releaseForm.releaseDate.$pristine">Required field.</span> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : releaseForm.milestone.$invalid && !releaseForm.milestone.$pristine }"> <label for="input-milestone" class="col-sm-2 control-label">* From Milestone </label> <div ng-if="!releaseCreateUpdateCtrl.isUpdating" class="col-sm-10"> <select id="input-milestone" required name="milestone" ng-model="releaseCreateUpdateCtrl.productMilestoneId"> <option></option> <option ng-repeat="milestone in releaseCreateUpdateCtrl.versionMilestones" value="{{ milestone.id }}"> {{ milestone.version }} </option> </select> <span class="help-block" ng-show="releaseForm.milestone.$invalid && !releaseForm.milestone.$pristine">Required field.</span> </div> <div ng-if="releaseCreateUpdateCtrl.isUpdating" class="col-sm-10"> <label for="input-milestone" class="control-label bigger-text">{{ releaseCreateUpdateCtrl.productMilestoneVersion }}</label> </div> </div> <div class="form-group" ng-class="{ \'has-error\' : releaseForm.supportlevel.$invalid && !releaseForm.supportlevel.$pristine }"> <label for="input-supportlevel" class="col-sm-2 control-label">* Support Level </label> <div class="col-sm-10"> <select id="input-supportlevel" required name="supportlevel" ng-model="releaseCreateUpdateCtrl.data.supportLevel" ng-options="supportLevel for supportLevel in releaseCreateUpdateCtrl.supportLevels"> <option></option> </select> <span class="help-block" ng-show="releaseForm.supportlevel.$invalid && !releaseForm.supportlevel.$pristine">Required field.</span> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : releaseForm.downloadurl.$invalid && !releaseForm.downloadurl.$pristine }"> <label for="input-downloadurl" class="col-sm-2 control-label"> Download URL&nbsp;<a uib-popover="Internal or public location to download the product distribution artifacts" popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <div class="input-group"> <input type="url" name="downloadurl" id="input-downloadurl" class="form-control" name="downloadUrl" maxlength="255" ng-model="releaseCreateUpdateCtrl.data.downloadUrl"> </div> <span class="help-block" ng-show="releaseForm.downloadurl.$invalid && !releaseForm.downloadurl.$pristine">Malformed URL.</span> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : releaseForm.issuetrackerurl.$invalid && !releaseForm.issuetrackerurl.$pristine }"> <label for="input-issuetrackerurl" class="col-sm-2 control-label"> * Issue Tracker URL&nbsp;<a uib-popover="Link to issues fixed in this release" popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <div class="input-group"> <input type="url" required name="issuetrackerurl" id="input-issuetrackerurl" class="form-control" name="issueTrackerUrl" maxlength="255" ng-model="releaseCreateUpdateCtrl.data.issueTrackerUrl"> </div> <span class="help-block" ng-show="releaseForm.issuetrackerurl.$invalid && !releaseForm.issuetrackerurl.$pristine">Malformed URL.</span> </div> </div> </div> </div> <div class="form-group"> <div class="col-sm-offset-2 col-sm-10"> <input ng-if="!releaseCreateUpdateCtrl.isUpdating" type="submit" class="btn btn-primary" value="Create" ng-disabled="releaseForm.$invalid"> <input ng-if="releaseCreateUpdateCtrl.isUpdating" type="submit" class="btn btn-primary" value="Update" ng-disabled="releaseForm.$invalid"> <input type="reset" class="btn btn-default" value="Clear"> </div> </div> </form> </div> </div> </div> '),e.put("report/directives/pnc-project-repository-form/pnc-project-repository-form.html",' <form class="form-horizontal" name="pncProjectRepositoryForm" novalidate> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : !scmUrl && pncProjectRepositoryForm.scmUrl.$touched, \'has-success\': scmUrl && pncProjectRepositoryForm.scmUrl.$touched }"> <label for="scmUrl" class="col-sm-2 control-label">* SCM Url:</label> <div class="col-sm-10"> <input id="scmUrl" class="form-control" name="scmUrl" ng-model="scmUrl" maxlength="255" placeholder="" required> <span class="help-block" ng-show="pncProjectRepositoryForm.scmUrl.$error.required && pncProjectRepositoryForm.scmUrl.$touched">Required field.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\' : !revision && pncProjectRepositoryForm.revision.$touched, \'has-success\': revision && pncProjectRepositoryForm.revision.$touched }"> <label for="revision" class="col-sm-2 control-label">* Revision:</label> <div class="col-sm-10"> <input id="revision" class="form-control" name="revision" ng-model="revision" maxlength="255" placeholder="master" required> <span class="help-block" ng-show="pncProjectRepositoryForm.revision.$error.required && pncProjectRepositoryForm.revision.$touched">Required field.</span> </div> </div> <div class="form-group"> <label for="pomPath" class="col-sm-2 control-label">Path to POM:</label> <div class="col-sm-10"> <input id="pomPath" class="form-control" name="pomPath" ng-model="pomPath" maxlength="255" placeholder="./pom.xml"> </div> </div> <div class="form-group"> <label for="additionalRepos" class="col-sm-2 control-label">Additional repos:</label> <div class="col-sm-10"> <pnc-multiple-input selected-items="additionalRepos" placeholder="" select-id="additionalRepos" select-name="additionalRepos"> </pnc-multiple-input> </div> </div> </div> </div> <div class="form-group text-right"> <div class="col-sm-offset-2 col-sm-10"> <input type="submit" class="btn btn-primary" value="Search" ng-disabled="pncProjectRepositoryForm.$invalid" ng-click="search()"> <button type="button" class="btn btn-default" ng-click="reset(pncProjectRepositoryForm)">Clear</button> </div> </div> </form>'),e.put("report/views/blacklisted.artifacts.in.project.html",' <div class="row"> <div class="col-lg-7 col-md-10"> <pnc-header> <pnc-header-title>Show blacklisted artifacts in a project</pnc-header-title> </pnc-header> <pnc-project-repository-form search-callback="blacklistedArtifactsInProjectReportCtrl.search(scmUrl, revision, pomPath, additionalRepos)" reset-callback="blacklistedArtifactsInProjectReportCtrl.reset()"></pnc-project-repository-form> </div> </div> <br><br> <div ng-show="blacklistedArtifactsInProjectReportCtrl.isResultNotEmpty()"> <div class="col-md-12"> <div class="search"> <div class="form-group"> <div class="input-group" role="search"> <label class="sr-only" for="{{ inputId }}">Filter Results</label> <input id="{{ inputId }}" type="search" class="form-control" ng-model="searchText" placeholder="Filter"> <div class="input-group-addon"> <i class="fa fa-search"></i> </div> </div> </div> </div> <table class="table table-bordered table-striped table-hover"> <thead> <th style="cursor: pointer" ng-click="blacklistedArtifactsInProjectReportCtrl.sort(\'groupId\')">GroupId <span class="glyphicon sort-icon" ng-show="blacklistedArtifactsInProjectReportCtrl.sortKey==\'groupId\'" ng-class="{\'glyphicon-chevron-up\':blacklistedArtifactsInProjectReportCtrl.reverse,\'glyphicon-chevron-down\':!blacklistedArtifactsInProjectReportCtrl.reverse}"></span> </th> <th style="cursor: pointer" ng-click="blacklistedArtifactsInProjectReportCtrl.sort(\'artifactId\')">ArtifactId <span class="glyphicon sort-icon" ng-show="blacklistedArtifactsInProjectReportCtrl.sortKey==\'artifactId\'" ng-class="{\'glyphicon-chevron-up\':blacklistedArtifactsInProjectReportCtrl.reverse,\'glyphicon-chevron-down\':!blacklistedArtifactsInProjectReportCtrl.reverse}"></span> </th> <th style="cursor: pointer" ng-click="blacklistedArtifactsInProjectReportCtrl.sort(\'version\')">Version <span class="glyphicon sort-icon" ng-show="blacklistedArtifactsInProjectReportCtrl.sortKey==\'version\'" ng-class="{\'glyphicon-chevron-up\':blacklistedArtifactsInProjectReportCtrl.reverse,\'glyphicon-chevron-down\':!blacklistedArtifactsInProjectReportCtrl.reverse}"></span> </th> </thead> <tbody> <tr ng-repeat="result in blacklistedArtifactsInProjectReportCtrl.reportResults | orderBy:blacklistedArtifactsInProjectReportCtrl.sortKey:blacklistedArtifactsInProjectReportCtrl.reverse | filter:searchText"> <td>{{ result.groupId }}</td> <td>{{ result.artifactId }}</td> <td>{{ result.version }}</td> </tr> </tbody> </table> </div> </div> <div ng-hide="blacklistedArtifactsInProjectReportCtrl.isResultNotEmpty() || !blacklistedArtifactsInProjectReportCtrl.afterSearch"> <div class="col-md-12"> <div class="text-center lead"> There are no results to display. </div> </div> </div> '),e.put("report/views/built.artifacts.in.project.html",' <div class="row"> <div class="col-lg-7 col-md-10"> <pnc-header> <pnc-header-title>Show built artifacts in a project</pnc-header-title> </pnc-header> <pnc-project-repository-form search-callback="builtArtifactsInProjectReportCtrl.search(scmUrl, revision, pomPath, additionalRepos)" reset-callback="builtArtifactsInProjectReportCtrl.reset()"></pnc-project-repository-form> </div> </div> <br><br> <div ng-show="builtArtifactsInProjectReportCtrl.isResultNotEmpty()"> <div class="col-md-12"> <div class="search"> <div class="form-group"> <div class="input-group" role="search"> <label class="sr-only" for="{{ inputId }}">Filter Results</label> <input id="{{ inputId }}" type="search" class="form-control" ng-model="searchText" placeholder="Filter"> <div class="input-group-addon"> <i class="fa fa-search"></i> </div> </div> </div> </div> <table class="table table-bordered table-striped table-hover"> <thead> <th class="cursor-pointer" ng-click="builtArtifactsInProjectReportCtrl.sort(\'groupId\')">GroupId <span class="glyphicon sort-icon" ng-show="builtArtifactsInProjectReportCtrl.sortKey==\'groupId\'" ng-class="{\'glyphicon-chevron-up\':builtArtifactsInProjectReportCtrl.reverse,\'glyphicon-chevron-down\':!builtArtifactsInProjectReportCtrl.reverse}"></span> </th> <th class="cursor-pointer" ng-click="builtArtifactsInProjectReportCtrl.sort(\'artifactId\')">ArtifactId <span class="glyphicon sort-icon" ng-show="builtArtifactsInProjectReportCtrl.sortKey==\'artifactId\'" ng-class="{\'glyphicon-chevron-up\':builtArtifactsInProjectReportCtrl.reverse,\'glyphicon-chevron-down\':!builtArtifactsInProjectReportCtrl.reverse}"></span> </th> <th class="cursor-pointer w-min-150" ng-click="builtArtifactsInProjectReportCtrl.sort(\'version\')">Version <span class="glyphicon sort-icon" ng-show="builtArtifactsInProjectReportCtrl.sortKey==\'version\'" ng-class="{\'glyphicon-chevron-up\':builtArtifactsInProjectReportCtrl.reverse,\'glyphicon-chevron-down\':!builtArtifactsInProjectReportCtrl.reverse}"></span> </th> <th class="cursor-pointer w-min-150" ng-click="builtArtifactsInProjectReportCtrl.sort(\'version\')">Built Version <span class="glyphicon sort-icon" ng-show="builtArtifactsInProjectReportCtrl.sortKey==\'version\'" ng-class="{\'glyphicon-chevron-up\':builtArtifactsInProjectReportCtrl.reverse,\'glyphicon-chevron-down\':!builtArtifactsInProjectReportCtrl.reverse}"></span> </th> <th class="cursor-pointer"> All Available Versions <button ng-click="builtArtifactsInProjectReportCtrl.expandAll()" title="Expand All Available Versions" class="btn btn-default btn-xs m-l-10" type="button">Expand all</button> </th> </thead> <tbody> <tr dir-paginate="result in builtArtifactsInProjectReportCtrl.reportResults | orderBy:builtArtifactsInProjectReportCtrl.sortKey:builtArtifactsInProjectReportCtrl.reverse | filter:searchText | itemsPerPage:builtArtifactsInProjectReportCtrl.defaultPageSize" current-page="builtArtifactsInProjectReportCtrl.pagination.current"> <td class="nowrap">{{ result.groupId }}</td> <td class="nowrap">{{ result.artifactId }}</td> <td>{{ result.version }}</td> <td>{{ result.builtVersion }}</td> <td> <div class="available-versions" ng-init="builtArtifactsInProjectReportCtrl.availableVersionsLimits[$index] = 3"> <span ng-repeat="version in result.availableVersions | limitTo: builtArtifactsInProjectReportCtrl.availableVersionsLimits[$index] as results" class="available-versions-item">{{ version }}</span> <span class="available-versions-item" ng-hide="results.length === result.availableVersions.length"> <button ng-click="builtArtifactsInProjectReportCtrl.availableVersionsLimits[$index] = result.availableVersions.length" title="Show All Available Versions" class="btn btn-default btn-xs" type="button">Show all</button> </span> </div> </td> </tr> </tbody> </table> <dir-pagination-controls max-size="builtArtifactsInProjectReportCtrl.defaultPageSize" direction-links="true" boundary-links="true"></dir-pagination-controls> </div> </div> <div ng-hide="builtArtifactsInProjectReportCtrl.isResultNotEmpty() || !builtArtifactsInProjectReportCtrl.afterSearch"> <div class="col-md-12"> <div class="text-center lead"> There are no results to display. </div> </div> </div> '),e.put("report/views/different.artifacts.in.products.html",' <div class="row"> <div class="col-md-10 col-lg-7"> <pnc-header> <pnc-header-title>Analyze the artifacts difference between 2 Products</pnc-header-title> </pnc-header> <form class="form-horizontal" name="differentArtifactsForm" novalidate> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : !diffGAVInProdReportCtrl.selectedProductLeftId && differentArtifactsForm.productLeftId.$touched, \n                \'has-success\': diffGAVInProdReportCtrl.selectedProductLeftId && differentArtifactsForm.productLeftId.$touched }"> <label for="input1" class="col-sm-2 control-label"> * Product 1&nbsp;<a uib-popover="Select the first Product." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <pnc-select-items single-item="true" selected-items="diffGAVInProdReportCtrl.productLeftSelection.selected" select-required="true" select-id="productLeftId" select-name="productLeftId" placeholder="Scroll & Filter Products..." items="diffGAVInProdReportCtrl.products" item-id="diffGAVInProdReportCtrl.selectedProductLeftId"> </pnc-select-items> <span class="help-block" ng-show="!diffGAVInProdReportCtrl.selectedProductLeftId && differentArtifactsForm.productLeftId.$touched">Required field.</span> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : !diffGAVInProdReportCtrl.selectedProductRightId && differentArtifactsForm.productRightId.$touched, \n                \'has-success\': diffGAVInProdReportCtrl.selectedProductRightId && differentArtifactsForm.productRightId.$touched }"> <label for="input2" class="col-sm-2 control-label"> * Product 2&nbsp;<a uib-popover="Select the second Product." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <pnc-select-items single-item="true" selected-items="diffGAVInProdReportCtrl.productRightSelection.selected" select-required="true" select-id="productRightId" select-name="productRightId" placeholder="Scroll & Filter Products..." items="diffGAVInProdReportCtrl.products" item-id="diffGAVInProdReportCtrl.selectedProductRightId"> </pnc-select-items> <span class="help-block" ng-show="!diffGAVInProdReportCtrl.selectedProductRightId && differentArtifactsForm.productRightId.$touched">Required field.</span> </div> </div> </div> </div> <div class="form-group text-right"> <div class="col-sm-offset-2 col-sm-10"> <input type="submit" class="btn btn-primary" value="Search" ng-disabled="!diffGAVInProdReportCtrl.isFormValid()" ng-click="diffGAVInProdReportCtrl.search()"> <button type="button" class="btn btn-default" ng-click="diffGAVInProdReportCtrl.reset(differentArtifactsForm)">Clear</button> </div> </div> </form> </div> </div> <br><br> <div> <div class="col-md-12"> <div style="min-height: 100px !important" ng-show="diffGAVInProdReportCtrl.afterSearch"> <dl class="dl-horizontal"> <dt>Product 1:</dt> <dd>{{ diffGAVInProdReportCtrl.reportLeftProductSearchFilter.name }}</dd> <dt>Version:</dt> <dd>{{ diffGAVInProdReportCtrl.reportLeftProductSearchFilter.version }}</dd> <dt>Support Status:</dt> <dd>{{ diffGAVInProdReportCtrl.reportLeftProductSearchFilter.supportStatus }}</dd> </dl> <dl class="dl-horizontal"> <dt>Product 2:</dt> <dd>{{ diffGAVInProdReportCtrl.reportRightProductSearchFilter.name }}</dd> <dt>Version:</dt> <dd>{{ diffGAVInProdReportCtrl.reportRightProductSearchFilter.version }}</dd> <dt>Support Status:</dt> <dd>{{ diffGAVInProdReportCtrl.reportRightProductSearchFilter.supportStatus }}</dd> </dl> </div> <div ng-show="diffGAVInProdReportCtrl.isGavAddedNotEmpty()"> <pnc-header> <pnc-header-title><small>Artifacts added in {{ diffGAVInProdReportCtrl.reportRightProductSearchFilter.name }}-{{ diffGAVInProdReportCtrl.reportRightProductSearchFilter.version }} from {{ diffGAVInProdReportCtrl.reportLeftProductSearchFilter.name }}-{{ diffGAVInProdReportCtrl.reportLeftProductSearchFilter.version }}</small> </pnc-header-title> </pnc-header> <div class="search"> <div class="form-group"> <div class="input-group" role="search"> <label class="sr-only" for="{{ inputAddedId }}">Filter Results</label> <input id="{{ inputAddedId }}" type="search" class="form-control" ng-model="searchAddedText" placeholder="Filter added artifacts"> <div class="input-group-addon"> <i class="fa fa-search"></i> </div> </div> </div> </div> <table class="table table-bordered table-striped table-hover"> <thead> <th style="cursor: pointer" ng-click="diffGAVInProdReportCtrl.sortAdded(\'groupId\')">GroupId <span class="glyphicon sort-icon" ng-show="diffGAVInProdReportCtrl.sortKeyAdded==\'groupId\'" ng-class="{\'glyphicon-chevron-up\':diffGAVInProdReportCtrl.reverseAdded,\'glyphicon-chevron-down\':!diffGAVInProdReportCtrl.reverseAdded}"></span> </th> <th style="cursor: pointer" ng-click="diffGAVInProdReportCtrl.sortAdded(\'artifactId\')">ArtifactId <span class="glyphicon sort-icon" ng-show="diffGAVInProdReportCtrl.sortKeyAdded==\'artifactId\'" ng-class="{\'glyphicon-chevron-up\':diffGAVInProdReportCtrl.reverseAdded,\'glyphicon-chevron-down\':!diffGAVInProdReportCtrl.reverseAdded}"></span> </th> <th style="cursor: pointer" ng-click="diffGAVInProdReportCtrl.sortAdded(\'version\')">Version <span class="glyphicon sort-icon" ng-show="diffGAVInProdReportCtrl.sortKeyAdded==\'version\'" ng-class="{\'glyphicon-chevron-up\':diffGAVInProdReportCtrl.reverseAdded,\'glyphicon-chevron-down\':!diffGAVInProdReportCtrl.reverseAdded}"></span> </th> </thead> <tbody> <tr pagination-id="added" dir-paginate="result in diffGAVInProdReportCtrl.gavsAdded |orderBy:diffGAVInProdReportCtrl.sortKeyAdded:diffGAVInProdReportCtrl.reverseAdded | filter:searchAddedText | itemsPerPage:diffGAVInProdReportCtrl.defaultPageSize"> <td>{{ result.groupId }}</td> <td>{{ result.artifactId }}</td> <td>{{ result.version }}</td> </tr> </tbody> </table> <dir-pagination-controls pagination-id="added" max-size="diffGAVInProdReportCtrl.defaultPageSize" direction-links="true" boundary-links="true"></dir-pagination-controls> </div> <div ng-show="diffGAVInProdReportCtrl.isGavRemovedNotEmpty()"> <pnc-header> <pnc-header-title><small>Artifacts removed in {{ diffGAVInProdReportCtrl.reportRightProductSearchFilter.name }}-{{ diffGAVInProdReportCtrl.reportRightProductSearchFilter.version }} from {{ diffGAVInProdReportCtrl.reportLeftProductSearchFilter.name }}-{{ diffGAVInProdReportCtrl.reportLeftProductSearchFilter.version }}</small> </pnc-header-title> </pnc-header> <div class="search"> <div class="form-group"> <div class="input-group" role="search"> <label class="sr-only" for="{{ inputRemovedId }}">Filter Results</label> <input id="{{ inputRemovedId }}" type="search" class="form-control" ng-model="searchRemovedText" placeholder="Filter removed artifacts"> <div class="input-group-addon"> <i class="fa fa-search"></i> </div> </div> </div> </div> <table class="table table-bordered table-striped table-hover"> <thead> <th style="cursor: pointer" ng-click="diffGAVInProdReportCtrl.sortRemoved(\'groupId\')">GroupId <span class="glyphicon sort-icon" ng-show="diffGAVInProdReportCtrl.sortKeyRemoved==\'groupId\'" ng-class="{\'glyphicon-chevron-up\':diffGAVInProdReportCtrl.reverseRemoved,\'glyphicon-chevron-down\':!diffGAVInProdReportCtrl.reverseRemoved}"></span> </th> <th style="cursor: pointer" ng-click="diffGAVInProdReportCtrl.sortRemoved(\'artifactId\')">ArtifactId <span class="glyphicon sort-icon" ng-show="diffGAVInProdReportCtrl.sortKeyRemoved==\'artifactId\'" ng-class="{\'glyphicon-chevron-up\':diffGAVInProdReportCtrl.reverseRemoved,\'glyphicon-chevron-down\':!diffGAVInProdReportCtrl.reverseRemoved}"></span> </th> <th style="cursor: pointer" ng-click="diffGAVInProdReportCtrl.sortRemoved(\'version\')">Version <span class="glyphicon sort-icon" ng-show="diffGAVInProdReportCtrl.sortKeyRemoved==\'version\'" ng-class="{\'glyphicon-chevron-up\':diffGAVInProdReportCtrl.reverseRemoved,\'glyphicon-chevron-down\':!diffGAVInProdReportCtrl.reverseRemoved}"></span> </th> </thead> <tbody> <tr pagination-id="removed" dir-paginate="result in diffGAVInProdReportCtrl.gavsRemoved |orderBy:diffGAVInProdReportCtrl.sortKeyRemoved:diffGAVInProdReportCtrl.reverseRemoved | filter:searchRemovedText | itemsPerPage:diffGAVInProdReportCtrl.defaultPageSize"> <td>{{ result.groupId }}</td> <td>{{ result.artifactId }}</td> <td>{{ result.version }}</td> </tr> </tbody> </table> <dir-pagination-controls pagination-id="removed" max-size="diffGAVInProdReportCtrl.defaultPageSize" direction-links="true" boundary-links="true"></dir-pagination-controls> </div> <div ng-show="diffGAVInProdReportCtrl.isGavChangedNotEmpty()"> <pnc-header> <pnc-header-title><small>Artifacts changed in {{ diffGAVInProdReportCtrl.reportRightProductSearchFilter.name }}-{{ diffGAVInProdReportCtrl.reportRightProductSearchFilter.version }} from {{ diffGAVInProdReportCtrl.reportLeftProductSearchFilter.name }}-{{ diffGAVInProdReportCtrl.reportLeftProductSearchFilter.version }}</small> </pnc-header-title> </pnc-header> <div class="search"> <div class="form-group"> <div class="input-group" role="search"> <label class="sr-only" for="{{ inputChangedId }}">Filter Results</label> <input id="{{ inputChangedId }}" type="search" class="form-control" ng-model="searchChangedText" placeholder="Filter changed artifacts"> <div class="input-group-addon"> <i class="fa fa-search"></i> </div> </div> </div> </div> <table class="table table-bordered table-striped table-hover"> <thead> <th style="cursor: pointer" ng-click="diffGAVInProdReportCtrl.sortChanged(\'groupId\')">GroupId <span class="glyphicon sort-icon" ng-show="diffGAVInProdReportCtrl.sortKeyChanged==\'groupId\'" ng-class="{\'glyphicon-chevron-up\':diffGAVInProdReportCtrl.reverseChanged,\'glyphicon-chevron-down\':!diffGAVInProdReportCtrl.reverseChanged}"></span> </th> <th style="cursor: pointer" ng-click="diffGAVInProdReportCtrl.sortChanged(\'artifactId\')">ArtifactId <span class="glyphicon sort-icon" ng-show="diffGAVInProdReportCtrl.sortKeyChanged==\'artifactId\'" ng-class="{\'glyphicon-chevron-up\':diffGAVInProdReportCtrl.reverseChanged,\'glyphicon-chevron-down\':!diffGAVInProdReportCtrl.reverseChanged}"></span> </th> <th style="cursor: pointer" ng-click="diffGAVInProdReportCtrl.sortChanged(\'rightVersion\')">Version <span class="glyphicon sort-icon" ng-show="diffGAVInProdReportCtrl.sortKeyChanged==\'rightVersion\'" ng-class="{\'glyphicon-chevron-up\':diffGAVInProdReportCtrl.reverseChanged,\'glyphicon-chevron-down\':!diffGAVInProdReportCtrl.reverseChanged}"></span> </th> <th style="cursor: pointer" ng-click="diffGAVInProdReportCtrl.sortChanged(\'leftVersion\')">From Version <span class="glyphicon sort-icon" ng-show="diffGAVInProdReportCtrl.sortKeyChanged==\'leftVersion\'" ng-class="{\'glyphicon-chevron-up\':diffGAVInProdReportCtrl.reverseChanged,\'glyphicon-chevron-down\':!diffGAVInProdReportCtrl.reverseChanged}"></span> </th> <th style="cursor: pointer" ng-click="diffGAVInProdReportCtrl.sortChanged(\'differenceType\')">Difference Type <span class="glyphicon sort-icon" ng-show="diffGAVInProdReportCtrl.sortKeyChanged==\'differenceType\'" ng-class="{\'glyphicon-chevron-up\':diffGAVInProdReportCtrl.reverseChanged,\'glyphicon-chevron-down\':!diffGAVInProdReportCtrl.reverseChanged}"></span> </th> </thead> <tbody> <tr pagination-id="changed" dir-paginate="result in diffGAVInProdReportCtrl.gavsChanged |orderBy:diffGAVInProdReportCtrl.sortKeyChanged:diffGAVInProdReportCtrl.reverseChanged | filter:searchChangedText | itemsPerPage:diffGAVInProdReportCtrl.defaultPageSize"> <td>{{ result.groupId }}</td> <td>{{ result.artifactId }}</td> <td>{{ result.rightVersion }}</td> <td>{{ result.leftVersion }}</td> <td>{{ result.differenceType }}</td> </tr> </tbody> </table> <dir-pagination-controls pagination-id="changed" max-size="diffGAVInProdReportCtrl.defaultPageSize" direction-links="true" boundary-links="true"></dir-pagination-controls> </div> <div ng-show="diffGAVInProdReportCtrl.isGavUnchangedNotEmpty()"> <pnc-header> <pnc-header-title><small>Artifacts unchanged between {{ diffGAVInProdReportCtrl.reportRightProductSearchFilter.name }}-{{ diffGAVInProdReportCtrl.reportRightProductSearchFilter.version }} and {{ diffGAVInProdReportCtrl.reportLeftProductSearchFilter.name }}-{{ diffGAVInProdReportCtrl.reportLeftProductSearchFilter.version }}</small></pnc-header-title> </pnc-header> <div class="search"> <div class="form-group"> <div class="input-group" role="search"> <label class="sr-only" for="{{ inputUnchangedId }}">Filter Results</label> <input id="{{ inputUnchangedId }}" type="search" class="form-control" ng-model="searchUnchangedText" placeholder="Filter unchanged artifacts"> <div class="input-group-addon"> <i class="fa fa-search"></i> </div> </div> </div> </div> <table class="table table-bordered table-striped table-hover"> <thead> <th style="cursor: pointer" ng-click="diffGAVInProdReportCtrl.sortUnchanged(\'groupId\')">GroupId <span class="glyphicon sort-icon" ng-show="diffGAVInProdReportCtrl.sortKeyUnchanged==\'groupId\'" ng-class="{\'glyphicon-chevron-up\':diffGAVInProdReportCtrl.reverseUnchanged,\'glyphicon-chevron-down\':!diffGAVInProdReportCtrl.reverseUnchanged}"></span> </th> <th style="cursor: pointer" ng-click="diffGAVInProdReportCtrl.sortUnchanged(\'artifactId\')">ArtifactId <span class="glyphicon sort-icon" ng-show="diffGAVInProdReportCtrl.sortKeyUnchanged==\'artifactId\'" ng-class="{\'glyphicon-chevron-up\':diffGAVInProdReportCtrl.reverseUnchanged,\'glyphicon-chevron-down\':!diffGAVInProdReportCtrl.reverseUnchanged}"></span> </th> <th style="cursor: pointer" ng-click="diffGAVInProdReportCtrl.sortUnchanged(\'version\')">Version <span class="glyphicon sort-icon" ng-show="diffGAVInProdReportCtrl.sortKeyUnchanged==\'version\'" ng-class="{\'glyphicon-chevron-up\':diffGAVInProdReportCtrl.reverseUnchanged,\'glyphicon-chevron-down\':!diffGAVInProdReportCtrl.reverseUnchanged}"></span> </th> </thead> <tbody> <tr pagination-id="unchanged" dir-paginate="result in diffGAVInProdReportCtrl.gavsUnchanged |orderBy:diffGAVInProdReportCtrl.sortKeyUnchanged:diffGAVInProdReportCtrl.reverseUnchanged | filter:searchUnchangedText | itemsPerPage:diffGAVInProdReportCtrl.defaultPageSize"> <td>{{ result.groupId }}</td> <td>{{ result.artifactId }}</td> <td>{{ result.version }}</td> </tr> </tbody> </table> <dir-pagination-controls pagination-id="unchanged" max-size="diffGAVInProdReportCtrl.defaultPageSize" direction-links="true" boundary-links="true"></dir-pagination-controls> </div> </div> </div> '),e.put("report/views/product.shipped.artifacts.html",' <div class="row"> <div class="col-md-10 col-lg-7"> <pnc-header> <pnc-header-title>Find the whitelisted artifacts of a Product</pnc-header-title> </pnc-header> <form class="form-horizontal" name="productShippedArtifactForm" novalidate> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : !productShippedReportCtrl.selectedProductId && productShippedArtifactForm.productId.$touched, \'has-success\': productShippedReportCtrl.selectedProductId && productShippedArtifactForm.productId.$touched }"> <label for="input1" class="col-sm-2 control-label"> * Product&nbsp;<a uib-popover="Select the Product to analyze." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <pnc-select-items single-item="true" selected-items="productShippedReportCtrl.productSelection.selected" select-required="true" select-id="productId" select-name="productId" placeholder="Scroll & Filter Products..." items="productShippedReportCtrl.products" item-id="productShippedReportCtrl.selectedProductId"> </pnc-select-items> <span class="help-block" ng-show="!productShippedReportCtrl.selectedProductId && productShippedArtifactForm.productId.$touched">Required field.</span> </div> </div> </div> </div> <div class="form-group text-right"> <div class="col-sm-offset-2 col-sm-10"> <input type="submit" class="btn btn-primary" value="Search" ng-disabled="productShippedArtifactForm.$invalid" ng-click="productShippedReportCtrl.search()"> <button type="button" class="btn btn-default" ng-click="productShippedReportCtrl.reset(productShippedArtifactForm)">Clear</button> </div> </div> </form> </div> </div> <br><br> <div ng-show="productShippedReportCtrl.isResultNotEmpty()"> <div class="col-md-12"> <div style="min-height: 100px !important"> <dl class="dl-horizontal"> <dt>Product:</dt> <dd>{{ productShippedReportCtrl.reportSearchFilter.name }}</dd> <dt>Version:</dt> <dd>{{ productShippedReportCtrl.reportSearchFilter.version }}</dd> <dt>Support Status:</dt> <dd>{{ productShippedReportCtrl.reportSearchFilter.supportStatus }}</dd> </dl> </div> <div class="search"> <div class="form-group"> <div class="input-group" role="search"> <label class="sr-only" for="{{ inputId }}">Filter Results</label> <input id="{{ inputId }}" type="search" class="form-control" ng-model="searchText" placeholder="Filter gavs"> <div class="input-group-addon"> <i class="fa fa-search"></i> </div> </div> </div> </div> <table class="table table-bordered table-striped table-hover"> <thead> <th style="cursor: pointer" ng-click="productShippedReportCtrl.sort(\'gav.groupId\')">GroupId <span class="glyphicon sort-icon" ng-show="productShippedReportCtrl.sortKey==\'gav.groupId\'" ng-class="{\'glyphicon-chevron-up\':productShippedReportCtrl.reverse,\'glyphicon-chevron-down\':!productShippedReportCtrl.reverse}"></span> </th> <th style="cursor: pointer" ng-click="productShippedReportCtrl.sort(\'gav.artifactId\')">ArtifactId <span class="glyphicon sort-icon" ng-show="productShippedReportCtrl.sortKey==\'gav.artifactId\'" ng-class="{\'glyphicon-chevron-up\':productShippedReportCtrl.reverse,\'glyphicon-chevron-down\':!productShippedReportCtrl.reverse}"></span> </th> <th style="cursor: pointer" ng-click="productShippedReportCtrl.sort(\'gav.version\')">Version <span class="glyphicon sort-icon" ng-show="productShippedReportCtrl.sortKey==\'gav.version\'" ng-class="{\'glyphicon-chevron-up\':productShippedReportCtrl.reverse,\'glyphicon-chevron-down\':!productShippedReportCtrl.reverse}"></span> </th> </thead> <tbody> <tr dir-paginate="result in productShippedReportCtrl.reportResults |orderBy:productShippedReportCtrl.sortKey:productShippedReportCtrl.reverse | filter:searchText | itemsPerPage:productShippedReportCtrl.defaultPageSize"> <td>{{ result.gav.groupId }}</td> <td>{{ result.gav.artifactId }}</td> <td>{{ result.gav.version }}</td> </tr> </tbody> </table> <dir-pagination-controls max-size="productShippedReportCtrl.defaultPageSize" direction-links="true" boundary-links="true"></dir-pagination-controls> </div> </div> '),e.put("report/views/products.for.artifact.html",' <div class="row"> <div class="col-lg-7 col-md-10"> <pnc-header> <pnc-header-title>Find the products for the whitelisted artifacts</pnc-header-title> </pnc-header> <form class="form-horizontal" name="productsForArtifactReportForm" novalidate> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : !productsForArtifactReportCtrl.gav.groupId && productsForArtifactReportForm.gavGroupId.$touched, \'has-success\': productsForArtifactReportCtrl.gav.groupId && productsForArtifactReportForm.gavGroupId.$touched }"> <label for="gavGroupId" class="col-sm-2 control-label">* Group ID:</label> <div class="col-sm-10"> <input id="gavGroupId" class="form-control" name="gavGroupId" ng-model="productsForArtifactReportCtrl.gav.groupId" maxlength="255" placeholder="org.jboss.xnio" required> <span class="help-block" ng-show="productsForArtifactReportForm.gavGroupId.$error.required && productsForArtifactReportForm.gavGroupId.$touched">Required field.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\' : !productsForArtifactReportCtrl.gav.artifactId && productsForArtifactReportForm.gavArtifactId.$touched, \'has-success\': productsForArtifactReportCtrl.gav.artifactId && productsForArtifactReportForm.gavArtifactId.$touched }"> <label for="gavArtifactId" class="col-sm-2 control-label">* Artifact ID:</label> <div class="col-sm-10"> <input id="gavArtifactId" class="form-control" name="gavArtifactId" ng-model="productsForArtifactReportCtrl.gav.artifactId" maxlength="255" placeholder="xnio-api" required> <span class="help-block" ng-show="productsForArtifactReportForm.gavArtifactId.$error.required && productsForArtifactReportForm.gavArtifactId.$touched">Required field.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\' : !productsForArtifactReportCtrl.gav.version && productsForArtifactReportForm.gavVersion.$touched, \'has-success\': productsForArtifactReportCtrl.gav.version && productsForArtifactReportForm.gavVersion.$touched }"> <label for="gavVersion" class="col-sm-2 control-label">* Version:</label> <div class="col-sm-10"> <input id="gavVersion" class="form-control" name="gavVersion" ng-model="productsForArtifactReportCtrl.gav.version" maxlength="255" placeholder="3.0.14.GA-redhat-1" required> <span class="help-block" ng-show="productsForArtifactReportForm.gavVersion.$error.required && productsForArtifactReportForm.gavVersion.$touched">Required field.</span> </div> </div> </div> </div> <div class="form-group text-right"> <div class="col-sm-offset-2 col-sm-10"> <input type="submit" class="btn btn-primary" value="Search" ng-disabled="productsForArtifactReportForm.$invalid" ng-click="productsForArtifactReportCtrl.search()"> <button type="button" class="btn btn-default" ng-click="productsForArtifactReportCtrl.reset(productsForArtifactReportForm)">Clear</button> </div> </div> </form> </div> </div> <br><br> <div ng-show="productsForArtifactReportCtrl.isResultNotEmpty()"> <div class="col-md-12"> <div class="search"> <div class="form-group"> <div class="input-group" role="search"> <label class="sr-only" for="{{ inputId }}">Filter Results</label> <input id="{{ inputId }}" type="search" class="form-control" ng-model="searchText" placeholder="Filter"> <div class="input-group-addon"> <i class="fa fa-search"></i> </div> </div> </div> </div> <table class="table table-bordered table-striped table-hover"> <thead> <th style="cursor: pointer" ng-click="productsForArtifactReportCtrl.sort(\'name\')">Name <span class="glyphicon sort-icon" ng-show="productsForArtifactReportCtrl.sortKey==\'name\'" ng-class="{\'glyphicon-chevron-up\':productsForArtifactReportCtrl.reverse,\'glyphicon-chevron-down\':!productsForArtifactReportCtrl.reverse}"></span> </th> <th style="cursor: pointer" ng-click="productsForArtifactReportCtrl.sort(\'version\')">Version <span class="glyphicon sort-icon" ng-show="productsForArtifactReportCtrl.sortKey==\'version\'" ng-class="{\'glyphicon-chevron-up\':productsForArtifactReportCtrl.reverse,\'glyphicon-chevron-down\':!productsForArtifactReportCtrl.reverse}"></span> </th> <th style="cursor: pointer" ng-click="productsForArtifactReportCtrl.sort(\'supportStatus\')">Support Status <span class="glyphicon sort-icon" ng-show="productsForArtifactReportCtrl.sortKey==\'supportStatus\'" ng-class="{\'glyphicon-chevron-up\':productsForArtifactReportCtrl.reverse,\'glyphicon-chevron-down\':!productsForArtifactReportCtrl.reverse}"></span> </th> </thead> <tbody> <tr ng-repeat="result in productsForArtifactReportCtrl.reportResults | orderBy:productsForArtifactReportCtrl.sortKey:productsForArtifactReportCtrl.reverse | filter:searchText"> <td>{{ result.name }}</td> <td>{{ result.version }}</td> <td>{{ result.supportStatus }}</td> </tr> </tbody> </table> </div> </div> <div ng-hide="productsForArtifactReportCtrl.isResultNotEmpty() || !productsForArtifactReportCtrl.afterSearch"> <div class="col-md-12"> <div class="text-center lead"> There are no results to display. </div> </div> </div> '),e.put("report/views/project.product.diff.html",' <div class="row"> <div class="col-md-10 col-lg-7"> <pnc-header> <pnc-header-title>Diff a project against a product</pnc-header-title> </pnc-header> <form class="form-horizontal" name="diffForm" novalidate> <div class="panel panel-default"> <div class="panel-heading"> <h3 class="panel-title">Project</h3> </div> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : ctr.form.scmUrl.error }"> <label for="scmUrl" class="col-sm-2 control-label"> * SCM Url&nbsp;<a uib-popover="SCM repository URL" popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <input type="text" id="scmUrl" class="form-control" name="scmUrl" ng-model="ctr.form.data.scmUrl" maxlength="255"> <span class="help-block" ng-show="ctr.form.scmUrl.error">Required field.</span> </div> </div> <div class="form-group"> <label for="revision" class="col-sm-2 control-label"> Revision&nbsp;<a uib-popover="SCM branch, tag or commit id" popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <input type="text" id="revision" class="form-control" name="revision" ng-model="ctr.form.data.revision" maxlength="255" placeholder="master"> </div> </div> <div class="form-group"> <label for="pomPath" class="col-sm-2 control-label"> Path to POM&nbsp;<a uib-popover="Location of (parent) pom.xml within the repository." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <input type="text" id="pomPath" class="form-control" name="pomPath" ng-model="ctr.form.data.pomPath" maxlength="255" placeholder="pom.xml"> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-heading"> <h3 class="panel-title">Product</h3> </div> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : ctr.form.productId.error }"> <label for="productId" class="col-sm-2 control-label"> * Product&nbsp;<a uib-popover="Select a product." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <pnc-select-items single-item="false" selected-items="ctr.form.productId.selectedProducts" select-required="true" select-id="productId" select-name="productId" placeholder="Scroll & Filter Products..." items="ctr.form.productId.products" item-id="ctr.form.productId.productId" control="ctr.productSelectControl"> </pnc-select-items> <span class="help-block" ng-show="ctr.form.productId.error">Required field.</span> </div> </div> </div> </div> <div class="form-group text-right"> <div class="col-sm-offset-2 col-sm-10"> <input type="submit" class="btn btn-primary" value="Compute difference" ng-disabled="ctr.submitDisabled" ng-click="ctr.computeDifference()"> <button type="button" class="btn btn-default" ng-disabled="ctr.submitDisabled" ng-click="ctr.reset()">Clear</button> </div> </div> </form> </div> </div> <div class="row" ng-show="ctr.showTable"> <div class="col-md-10"> <h3>Project Modules</h3> <p> <button type="button" class="btn btn-default" ng-click="ctr.expandAll()"><i class="fa fa-plus"></i></button> <button type="button" class="btn btn-default" ng-click="ctr.collapseAll()"><i class="fa fa-minus"></i></button> <input id="searchField" type="search" class="pull-right" ng-model="ctr.searchText" placeholder="Filter Results&hellip;"> </p> <div class="panel-group" id="accordion-markup"> <div ng-repeat="m in ctr.tableData.moduleNames" class="panel panel-default" style="margin-bottom: 20px"> <div class="panel-heading"> <h4 class="panel-title"> <a data-toggle="collapse" href="#collapse-{{ $index }}"> {{ m }} </a> </h4> </div> <div id="collapse-{{ $index }}" class="panel-collapse collapse in"> <div class="panel-body" style="padding: 0px; margin: 0px"> <table class="table table-striped table-hover" style="table-layout: fixed; margin: 0px"> <colgroup> <col style="width: {{ 2 * (100 / (ctr.tableData.productNames.length + 2)) }}%"> <col style="width: {{ 100 / (ctr.tableData.productNames.length + 2) }}%"> <col ng-repeat="_ in ctr.tableData.productNames" style="width: {{ 100 / (ctr.tableData.productNames.length + 2) }}%"> </colgroup> <thead> <tr> <th>Dependency</th> <th>Version in project</th> <th ng-repeat="p in ctr.tableData.productNames">Version in {{ p }}</th> </tr> </thead> <tbody> <tr ng-repeat="d in ctr.tableData.data[m] | filter: ctr.searchText"> <td>{{ d.groupId }}:<strong>{{ d.artifactId }}</strong></td> <td style="{{ d.versions.__project === d._latestVersion ? \'font-weight: bold;\' : \'\' }}">{{ d.versions.__project }}</td> <td style="{{ d.versions[p] === d._latestVersion ? \'font-weight: bold;\' : \'\' }}" ng-repeat="p in ctr.tableData.productNames">{{ d.versions[p] }} <small title="Difference Type" ng-show="d.differenceTypes[p]">({{ d.differenceTypes[p] }})</small></td> </tr> </tbody> </table> </div> </div> </div> </div> </div> </div> ')}]);