!function(){"use strict";angular.module("pnc.artifacts",[]).config(["$stateProvider",function(e){e.state("artifacts",{abstract:!0,url:"/artifacts",views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}},data:{proxy:"artifacts.list"}}),e.state("artifacts.list",{url:"",data:{displayName:"Artifacts",title:"Artifacts"},component:"pncArtifactsListPage",resolve:{artifacts:["ArtifactResource","SortHelper",function(e,t){return e.query(t.getSortQueryString("artifactsList")).$promise}]}}),e.state("artifacts.detail",{url:"/{id}",data:{displayName:"{{ artifact.identifier }}",title:"{{ artifact.identifier }} | Artifacts"},component:"pncArtifactsDetailPage",resolve:{artifact:["$stateParams","ArtifactResource",function(e,t){return t.get({id:e.id}).$promise}],build:["artifact","BuildResource",function(e,t){return e.build?t.get({id:e.build.id}).$promise:null}],usages:["$stateParams","BuildResource",function(e,t){return t.getDependantBuilds({id:e.id,pageSize:10}).$promise}]}})}])}(),function(){"use strict";angular.module("pnc.build-configs",["ui.router","ui.bootstrap","xeditable","pnc.common.directives","pnc.builds","infinite-scroll","pnc.common.authentication"]).config(["$stateProvider",function(e){e.state("build-configs",{abstract:!0,url:"/build-configs",views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}},data:{proxy:"build-configs.list"}}),e.state("build-configs.list",{url:"",component:"pncBuildConfigsListPage",data:{displayName:"Build Configs",title:"Build Configs"},resolve:{buildConfigs:["BuildConfigResource","SortHelper",(e,t)=>e.query(t.getSortQueryString("buildConfigsList")).$promise]}}),e.state("projects.detail.build-configs",{abstract:!0,url:"/build-configs",views:{"content@":{templateUrl:"common/templates/two-col-right-sidebar.tmpl.html"}},data:{proxy:"projects.detail.build-configs.detail"}}),e.state("projects.detail.build-configs.detail",{url:"/{configurationId}",redirectTo:"projects.detail.build-configs.detail.default",data:{displayName:"{{ configurationDetail.name }}",title:"{{ configurationDetail.name }} | Build Config"},views:{"":{component:"pncBuildConfigDetailMain",bindings:{buildConfig:"configurationDetail"}},sidebar:{component:"pncBuildConfigDetailSidebar",bindings:{buildConfig:"configurationDetail"}}},resolve:{configurationDetail:["$stateParams","BuildConfigResource",(e,t)=>t.get({id:e.configurationId}).$promise],builds:["$stateParams","BuildConfigResource",(e,t)=>t.getBuilds({id:e.configurationId,pageSize:10,sort:"=desc=submitTime"}).$promise]}}),e.state("projects.detail.build-configs.detail.default",{url:"",component:"pncBuildConfigDetailsTab",data:{displayName:!1},bindings:{buildConfig:"configurationDetail"}}),e.state("projects.detail.build-configs.detail.dependencies",{url:"/dependencies",component:"pncBuildConfigDependenciesTab",data:{displayName:"Dependencies"},bindings:{buildConfig:"configurationDetail"},resolve:{dependencies:["configurationDetail",e=>e.$getDependencies()]}}),e.state("projects.detail.build-configs.detail.dependants",{url:"/dependendants",component:"pncBuildConfigDependantsTab",data:{displayName:"Dependants"},resolve:{dependants:["configurationDetail",e=>e.$getDependants()]}}),e.state("projects.detail.build-configs.detail.group-configs",{url:"/group-configs",component:"pncBuildConfigGroupConfigsTab",data:{displayName:"Group Configs"},resolve:{groupConfigs:["configurationDetail",e=>e.$getGroupConfigs()]}}),e.state("projects.detail.build-configs.detail.revisions",{url:"/revisions",redirectTo:function(e){return e.injector().getAsync("revisions").then(function(e){var t=e.data[0];return{state:"projects.detail.build-configs.detail.revisions.detail",params:{projectId:t.project.id,configurationId:t.id,revisionId:t.rev}}})},data:{displayName:"Revisions"},component:"pncBuildConfigRevisionsTab",bindings:{buildConfig:"configurationDetail"},resolve:{revisions:["configurationDetail",function(e){return e.$getRevisions()}]}}),e.state("projects.detail.build-configs.detail.revisions.detail",{url:"/{revisionId}",views:{master:{component:"pncRevisionsVerticalNav",bindings:{buildConfig:"configurationDetail",revisions:"revisions"}},detail:{component:"pncRevisionsDetails"}},data:{displayName:"{{ revision.modificationTime | date : 'medium' }}"},resolve:{revision:["configurationDetail","$stateParams",(e,t)=>e.$getRevision({revisionId:t.revisionId})]}}),e.state("projects.detail.build-configs.detail.build-metrics",{url:"/build-metrics",component:"pncBuildConfigBuildMetricsTab",data:{displayName:"Build Metrics"},resolve:{builds:["BuildResource","$stateParams",function(e,t){return e.getByConfiguration({id:t.configurationId,pageSize:200}).$promise}]}})}])}(),function(){"use strict";angular.module("pnc.builds",["ui.router","angular-websocket","bifrost","pnc.common.events","pnc.common.directives","pnc.properties"]).config(["$stateProvider",function(e){e.state("builds",{abstract:!0,url:"/builds",views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}},data:{proxy:"builds.list"}}),e.state("builds.list",{url:"",data:{displayName:"Builds",title:"Builds"},component:"pncBuildsListPage",resolve:{builds:["BuildResource","SortHelper",(e,t)=>e.query(t.getSortQueryString("buildsList")).$promise]}}),e.state("builds.detail",{abstract:!0,url:"/{buildId}",resolve:{build:["BuildResource","$stateParams",function(e,t){return e.get({id:t.buildId}).$promise}]}}),e.state("builds.detail.default",{url:"",onEnter:["$state","$timeout","build",function(e,t,i){t(function(){e.go("projects.detail.build-configs.detail.builds.detail.default",{projectId:i.project.id,configurationId:i.buildConfigRevision.id,buildId:i.id})})}]}),e.state("projects.detail.build-configs.detail.builds",{abstract:!0,url:"/builds",views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}}}),e.state("projects.detail.build-configs.detail.builds.detail",{abstract:!0,url:"/{buildId}",data:{proxy:"projects.detail.build-configs.detail.builds.detail.default",title:"#{{ build.id }} {{ build.buildConfigRevision.name }} | Build"},component:"pncBuildDetailPage",resolve:{build:["BuildResource","$stateParams",function(e,t){return e.get({id:t.buildId}).$promise}],brewPushResult:["BuildResource","$stateParams",function(e,t){return e.getBrewPushResult({id:t.buildId})}],buildConfigRevision:["BuildResource","build",function(e,t){return e.getRevision({id:t.buildConfigRevision.id,revisionId:t.buildConfigRevision.rev}).$promise}]}}),e.state("projects.detail.build-configs.detail.builds.detail.default",{url:"",component:"pncBuildDetailDetailsPage",data:{displayName:"Job #{{ build.id }}"}}),e.state("projects.detail.build-configs.detail.builds.detail.build-metrics",{url:"/build-metrics",component:"pncBuildDetailBuildMetricsPage",data:{displayName:"Build Metrics",title:"#{{ build.id }} {{ build.buildConfigRevision.name }} | Build Metrics"}}),e.state("projects.detail.build-configs.detail.builds.detail.build-log",{url:"/build-log",component:"pncBuildDetailBuildLogPage",data:{displayName:"Build Log",title:"#{{ build.id }} {{ build.buildConfigRevision.name }} | Build Log"},resolve:{buildLog:["BuildResource","build",function(e,t){return e.getLogBuild({id:t.id}).$promise}],sshCredentials:["BuildResource","build",function(e,t){return e.getSshCredentials({id:t.id,buildUser:t.user})}]}}),e.state("projects.detail.build-configs.detail.builds.detail.artifacts",{url:"/artifacts",component:"pncBuildDetailArtifactsPage",data:{displayName:"Build Artifacts",title:"#{{ build.id }} {{ build.buildConfigRevision.name }} | Build Artifacts"},resolve:{artifacts:["build",function(e){return e.$getBuiltArtifacts({pageSize:10})}]}}),e.state("projects.detail.build-configs.detail.builds.detail.dependencies",{url:"/dependencies",component:"pncBuildDetailArtifactsPage",data:{displayName:"Dependencies",title:"#{{ build.id }} {{ build.buildConfigRevision.name }} | Dependencies"},resolve:{artifacts:["build",function(e){return e.$getArtifactsDependencies({pageSize:10})}]}}),e.state("projects.detail.build-configs.detail.builds.detail.alignment-log",{url:"/alignment-log",component:"pncBuildDetailAlignmentLogPage",data:{displayName:"Alignment Log",title:"#{{ build.id }} {{ build.buildConfigRevision.name }} | Alignment Log"},resolve:{alignmentLog:["BuildResource","build",function(e,t){return e.getLogAlign({id:t.id}).$promise}]}}),e.state("projects.detail.build-configs.detail.builds.detail.brew-push",{url:"/brew-push",component:"pncBuildDetailBrewPushPage",data:{displayName:"Brew Push Results",title:"#{{ build.id }} {{ build.buildConfigRevision.name }} | Brew Push"},resolve:{brewPushResult:["BuildResource","build",(e,t)=>e.getBrewPushResult({id:t.id}).$promise]}})}])}(),function(){"use strict";angular.module("pnc.common.authentication",[]).run(["$log","$window","$transitions","authService",function(e,t,i,n){i.onStart({},function(e){var i=e.to(),o=e.router.stateService;i.data&&i.data.requireAuth&&!n.isAuthenticated()&&n.login(t.location.origin+"/"+o.href(i))})}])}(),function(){"use strict";angular.module("pnc.common.bifrost",[])}(),function(){"use strict";angular.module("pnc.common",["pnc.common.authentication","pnc.common.bifrost","pnc.common.components","pnc.common.da-client","pnc.common.directives","pnc.common.events","pnc.common.notifications","pnc.common.pnc-client","pnc.common.select-modals","pnc.common.util","pnc.common.filters","pnc-ui-extras.uiBreadcrumbs"])}(),function(){"use strict";angular.module("pnc.common.components",["pnc-ui-extras.combobox"])}(),function(){"use strict";angular.module("pnc.common.da-client",[])}(),function(){"use strict";angular.module("pnc.common.directives",["ui.bootstrap"])}(),function(){"use strict";angular.module("pnc.common.events",["pnc.properties"]).run(["$state","pncNotifyUser","messageBus",function(e,t,i){function n(e){return`${e.buildConfigRevision.name}#${e.id}`}function o(t){return function(){e.go("projects.detail.build-configs.detail.builds.detail.default",{projectId:t.project.id,configurationId:t.buildConfigRevision.id,buildId:t.id})}}function r(e){return`${e.groupConfig.name}#${e.id}`}function l(t){return()=>e.go("group-configs.detail",{groupConfigId:t.groupConfig.id})}i.onBuildProgress("IN_PROGRESS",e=>{console.log("BUILD STATUS: IN_PROGRESS, %O",e),e.groupBuild||t(e.user).info(`Build ${n(e)} IN PROGRESS`,`Build #${e.id}`,o(e))}),i.onBuildProgress("FINISHED",e=>{if(console.log("BUILD STATUS: FINISHED, %O",e),e.groupBuild)return;const i=t(e.user),r=`Build #${e.id}`,l=o(e);switch(e.status){case"SUCCESS":i.success(`Build ${n(e)} COMPLETED`,r,l);break;case"FAILED":i.warn(`Build ${n(e)} FAILED`,r,l);break;case"SYSTEM_ERROR":i.error(`Build ${n(e)} completed with status SYSTEM_ERROR`,r,l);break;default:i.info(`Build ${n(e)} completed with status ${e.status}`,r,l)}}),i.onGroupBuildProgress("IN_PROGRESS",e=>{console.log("GROUP BUILD STATUS: IN_PROGRESS: %O",e),t(e.user).info(`GroupBuild: ${r(e)} IN PROGRESS`,`GroupBuild #${e.id}`,l(e))}),i.onGroupBuildProgress("FINISHED",e=>{console.log("GROUP BUILD STATUS: FINISHED: %O",e);const i=t(e.user),n=r(e),o=`GroupBuild #${e.id}`,s=l(e);switch(e.status){case"SUCCESS":i.success(`GroupBuild ${n} completed successfully`,o,s);break;case"FAILED":i.warn(`GroupBuild ${n} FAILED`,o,s);break;case"SYSTEM_ERROR":i.error(`GroupBuild ${n} completed with status SYSTEM_ERROR`);break;default:i.info(`GroupBuild ${n} completed with status ${e.status}`)}})}])}(),function(){"use strict";angular.module("pnc.common.filters",[])}(),function(){"use strict";angular.module("pnc.common.notifications",[])}(),function(){"use strict";angular.module("pnc.common.pnc-client.jobs",[])}(),function(){"use strict";angular.module("pnc.common.pnc-client.message-bus",[])}(),function(){"use strict";var e,t=angular.module("pnc.common.pnc-client.pagination",["ngResource"]);t.config(["$provide","$resourceProvider",function(t,i){t.decorator("$resource",["$delegate",function(t){return function(n,o,r,l){var s,a=[];return Object.keys(i.defaults.actions).forEach(function(e){r.hasOwnProperty(e)||(r[e]=i.defaults.actions[e])}),Object.keys(r).forEach(function(e){var t,i=r[e];i.isPaged&&(a.push(e),i.interceptor&&angular.isFunction(i.interceptor.response)&&(t=i.interceptor.response),i.interceptor=i.interceptor||{},i.interceptor.response=function(e){return t&&t.apply(t,arguments),e},i.params=i.params||{},i.params.sort=i.params.sort)}),s=t(n,o,r,l),a.forEach(function(t){var i=s[t];s[t]=function(){var t=i.apply(i,arguments),n=e({Resource:s});return n.$resolved=!1,n.$promise=t.$promise.then(function(e){for(var t=e.data.content||[],i=0;i<t.length;i++)t[i]=new s(t[i]);return n.index=e.data.pageIndex||0,n.size=e.data.pageSize||0,n.total=e.data.totalPages||1,n._config=e.config,n.data=t,n.$resolved=!0,n}),n}}),s}}])}]),t.run(["page",function(t){e=t}])}(),function(){"use strict";angular.module("pnc.common.pnc-client",["pnc.common.pnc-client.pagination","pnc.common.pnc-client.resources","pnc.common.pnc-client.rsql","pnc.common.pnc-client.message-bus","pnc.common.pnc-client.jobs"])}(),function(){"use strict";angular.module("pnc.common.pnc-client.resources",["ngResource"]).config(["$resourceProvider",e=>{e.defaults.actions={query:{method:"GET",isArray:!1,isPaged:!0},get:{method:"GET"},save:{method:"POST"},update:{method:"PUT"},patch:{method:"PATCH",successNotification:!1},delete:{method:"DELETE"}}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.rsql",[])}(),function(){"use strict";angular.module("pnc.common.select-modals",["ui.bootstrap","pnc.common.pnc-client"])}(),function(){"use strict";angular.module("pnc.common.util",[])}(),function(){"use strict";angular.module("pnc.dashboard",["ui.router","pnc.common.components","pnc.properties","patternfly.notification"]).config(["$stateProvider",function(e){e.state("dashboard",{url:"/",views:{"content@":{templateUrl:"dashboard/views/dashboard.html",controller:"DashboardController",controllerAs:"ctrl"}},data:{displayName:"Dashboard",title:"Dashboard"}})}])}(),function(){"use strict";angular.module("pnc.group-builds",[]).config(["$stateProvider",function(e){e.state("group-builds",{abstract:!0,url:"/group-builds",views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}},data:{proxy:"group-builds.list"}}),e.state("group-builds.list",{url:"",data:{displayName:"Group Builds",title:"Group Builds"},component:"pncGroupBuildsListPage",resolve:{groupBuilds:["GroupBuildResource","SortHelper",function(e,t){return e.query(t.getSortQueryString("groupBuildsList")).$promise}]}}),e.state("group-builds.detail",{url:"/{id}?visualization",data:{displayName:"{{ groupBuild.groupConfig.name }} » #{{ groupBuild.id }}",title:"#{{ groupBuild.id }} {{ groupBuild.groupConfig.name }} | Group Build"},params:{visualization:{value:"list",dynamic:!0}},component:"pncGroupBuildDetailPage",resolve:{groupBuild:["GroupBuildResource","$stateParams",function(e,t){return e.get({id:t.id}).$promise}],dependencyGraph:["GroupBuildResource","$stateParams",function(e,t){return e.queryDependencyGraph({id:t.id}).$promise}],builds:["dependencyGraph","BuildResource",function(e,t){return Object.keys(e.vertices).map(function(i){return new t(e.vertices[i].data)})}]}})}])}(),function(){"use strict";angular.module("pnc.group-configs",["ui.router","xeditable","pnc.common.events","pnc.common.authentication","pnc.common.pnc-client"]).config(["$stateProvider","$urlRouterProvider",function(e,t){t.when(/^\/build-groups\/.*/,["$location",function(e){return e.url().replace("/build-groups/","/group-configs/")}]),e.state("group-configs",{abstract:!0,url:"/group-configs",redirectTo:"group-configs.list",views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}},data:{proxy:"group-configs.list"}}),e.state("group-configs.list",{url:"",component:"pncGroupConfigsListPage",resolve:{groupConfigsPage:["GroupConfigResource","SortHelper",(e,t)=>e.query(t.getSortQueryString("groupConfigsList")).$promise]},data:{displayName:"Group Configs",title:"Group Configs"}}),e.state("group-configs.detail",{url:"/{groupConfigId:int}",component:"pncGroupConfigDetailPage",resolve:{groupConfig:["$stateParams","GroupConfigResource",(e,t)=>t.get({id:e.groupConfigId}).$promise],productVersion:["groupConfig","ProductVersionResource",(e,t)=>e.productVersion?t.get({id:e.productVersion.id}).$promise:null],previousState:["$state","$q",(e,t)=>{const i={Name:e.current.name,Params:e.params,URL:e.href(e.current.name,e.params)};return t.when(i)}]},data:{displayName:"{{ groupConfig.name }}",title:"{{ groupConfig.name }} | Group Configs"},redirectTo:"group-configs.detail.build-configs"}),e.state("group-configs.detail.build-configs",{url:"",component:"pncGroupConfigBuildConfigsTab",resolve:{buildConfigs:["groupConfig",e=>e.$queryBuildConfigs()]},data:{displayName:!1}}),e.state("group-configs.detail.build-history",{url:"/build-history",component:"pncGroupConfigBuildHistoryTab",resolve:{groupBuilds:["groupConfig",e=>e.$queryGroupBuilds()]},data:{displayName:!1}}),e.state("group-configs.create",{url:"/create",component:"pncGroupConfigCreatePage",data:{requireAuth:!0,displayName:!1,title:"Create | Group Configs"}})}])}(),function(){"use strict";var e=angular.module("pnc",["ngAnimate","angular-loading-bar","ui.router","ui.bootstrap","patternfly.notification","pnc.common","pnc.dashboard","pnc.products","pnc.product-versions","pnc.projects","pnc.build-configs","pnc.builds","pnc.group-configs","pnc.product-milestones","pnc.product-releases","pnc.group-builds","pnc.report","pnc.properties","pnc.scm-repositories","pnc.artifacts"]);e.config(["$stateProvider","$urlRouterProvider","$locationProvider","$httpProvider","NotificationsProvider","cfpLoadingBarProvider","$animateProvider",function(e,t,i,n,o,r,l){i.html5Mode(!1),i.hashPrefix(""),t.when("","/"),t.otherwise("/error"),e.state("error",{url:"/error",params:{title:"Error",message:"The requested resource could not be found."},data:{displayName:"Error",title:"Error"},views:{"content@":{templateUrl:"error.html",controller:["$stateParams",function(e){this.title=e.title,this.message=e.message}],controllerAs:"errorCtrl"}}}),o.setDelay(12e3),r.includeSpinner=!1,n.interceptors.push("httpResponseInterceptor"),n.interceptors.push("unwrapPageResponseInterceptor"),n.interceptors.push("httpAuthenticationInterceptor"),n.defaults.headers.patch={"Content-Type":"application/json-patch+json; charset=utf-8"},l.classNameFilter(/pnc-animate/)}]),e.config(["pncProperties","restConfigProvider","daConfigProvider","authConfigProvider","bifrostConfigProvider",function(e,t,i,n,o){t.setPncRestUrl(e.externalPncUrl),t.setPncNotificationsUrl(e.pncNotificationsUrl),t.setDaUrl(e.externalDaUrl),t.setKafkaStoreUrl(e.externalKafkaStoreUrl),i.setDaUrl(e.externalDaUrl),n.setSsoTokenLifespan(e.ssoTokenLifespan),o.setBifrostUrl(e.externalBifrostUrl)}]),e.run(["$log","authService","messageBus","restConfig","pncNotify","onBootNotifications",function(e,t,i,n,o,r){t.isAuthenticated()&&t.getPncUser(),Object.keys(r).forEach(function(e){r[e].forEach(function(t){angular.isString(t)?o[e](t):angular.isObject(t)&&o[e](t.message,t.actionTitle,t.actionCallback,t.menuActions,t.persistent)})}),i.connect()}])}(),function(){"use strict";angular.module("pnc.product-milestones",["ui.router","ui.bootstrap","patternfly","pnc.common.util"]).config(["$stateProvider",function(e){e.state("products.detail.product-versions.detail.milestone",{abstract:!0,url:"/milestones",views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}},data:{proxy:"products.detail.product-versions.detail"}}).state("products.detail.product-versions.detail.milestone.detail",{url:"/{productMilestoneId}",component:"pncProductMilestoneDetailPage",data:{displayName:"{{ productMilestone.version }}",title:"{{ productMilestone.version }} | {{ product.name }} | Milestone"},resolve:{productMilestone:["ProductMilestoneResource","$stateParams",(e,t)=>e.get({id:t.productMilestoneId}).$promise],performedBuilds:["ProductMilestoneResource","$stateParams",(e,t)=>e.queryPerformedBuilds({id:t.productMilestoneId}).$promise],closeResults:["ProductMilestoneResource","$stateParams",(e,t)=>e.queryCloseResults({id:t.productMilestoneId}).$promise]}}).state("products.detail.product-versions.detail.milestone.detail.log",{url:"/log",component:"pncProductMilestoneDetailLogPage",data:{displayName:"Workflow Log",title:"{{ productMilestone.version }} | {{ product.name }} | Workflow Log"}}).state("products.detail.product-versions.detail.milestone.create",{url:"/create",component:"pncProductMilestoneCreateUpdatePage",data:{displayName:"Create Milestone",title:"{{ productVersion.version }} | {{ product.name }} | Create Milestone",requireAuth:!0},resolve:{productMilestone:[function(){return null}]}}).state("products.detail.product-versions.detail.milestone.update",{url:"/{productMilestoneId}/update",component:"pncProductMilestoneCreateUpdatePage",data:{displayName:"Update Milestone",title:"{{ productMilestone.version }} | {{ product.name }} | Update Milestone",requireAuth:!0},resolve:{productMilestone:["ProductMilestoneResource","$stateParams",(e,t)=>e.get({id:t.productMilestoneId}).$promise]}}).state("products.detail.product-versions.detail.milestone.close",{url:"/{productMilestoneId}/close",component:"pncProductMilestoneClosePage",data:{displayName:"Close Milestone",title:"{{ productMilestone.version }} | {{ product.name }} | Close Milestone",requireAuth:!0},resolve:{productMilestone:["ProductMilestoneResource","$stateParams",(e,t)=>e.get({id:t.productMilestoneId}).$promise]}}).state("products.detail.product-versions.detail.milestone.detail.close-result",{url:"/close-results/{closeResultId}",views:{"content@":{component:"pncProductMilestoneCloseResultPage"}},data:{displayName:"Close Result",title:"Close Result | {{ productMilestone.version }} | {{ product.name }} "},resolve:{closeResult:["ProductMilestoneResource","$stateParams",(e,t)=>e.queryCloseResults({id:t.productMilestoneId,q:"id=="+t.closeResultId}).$promise]}})}])}(),function(){"use strict";angular.module("pnc.product-releases",["ui.router","ui.bootstrap","patternfly","pnc.common.util"]).config(["$stateProvider",function(e){e.state("products.detail.product-versions.detail.release",{abstract:!0,url:"/releases",views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}},data:{proxy:"products.detail.product-versions.detail"}}).state("products.detail.product-versions.detail.release.create",{url:"/create",component:"pncProductReleaseCreateUpdatePage",data:{displayName:"Create Release",title:"{{ productVersion.version }} | {{ product.name }} | Create Release",requireAuth:!0},resolve:{productRelease:[function(){return null}]}}).state("products.detail.product-versions.detail.release.update",{url:"/{releaseId}/update",component:"pncProductReleaseCreateUpdatePage",data:{displayName:"Update Release",title:"{{ productVersion.version }} | {{ product.name }} | Update Release",requireAuth:!0},resolve:{productRelease:["ProductReleaseResource","$stateParams",(e,t)=>e.get({id:t.releaseId}).$promise]}})}])}(),function(){"use strict";angular.module("pnc.product-versions",[]).config(["$stateProvider",e=>{console.log(e),e.state("products.detail.product-versions",{url:"/versions",abstract:!0,views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}},data:{proxy:"products.detail"}}),e.state("products.detail.product-versions.create",{url:"/create",component:"pncCreateProductVersionPage",data:{displayName:"Create Product Version",title:"Create Product Version | {{ product.name }}",requireAuth:!0}}),e.state("products.detail.product-versions.detail",{url:"/{productVersionId}",component:"pncProductVersionDetailPage",data:{displayName:"{{ productVersion.version }}",title:"{{ productVersion.version }}"},resolve:{productVersion:["$stateParams","ProductVersionResource",(e,t)=>t.get({id:e.productVersionId}).$promise],buildConfigs:["$stateParams","ProductVersionResource",(e,t)=>t.queryBuildConfigs({id:e.productVersionId}).$promise],groupConfigs:["$stateParams","ProductVersionResource",(e,t)=>t.queryGroupConfigs({id:e.productVersionId}).$promise],productReleases:["$stateParams","ProductVersionResource",(e,t)=>t.queryReleases({id:e.productVersionId,pageSize:10}).$promise],productMilestones:["$stateParams","ProductVersionResource",(e,t)=>t.queryMilestones({id:e.productVersionId,pageSize:10}).$promise]}})}])}(),function(){"use strict";angular.module("pnc.products",[]).config(["$stateProvider",e=>{e.state("products",{url:"/products",abstract:!0,views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}},data:{proxy:"products.list"}}),e.state("products.list",{url:"",component:"pncProductsListPage",resolve:{products:["ProductResource","SortHelper",(e,t)=>e.query(t.getSortQueryString("productsList")).$promise]},data:{displayName:"Products",title:"Products"}}),e.state("products.create",{url:"/create",component:"pncCreateProductPage",data:{displayName:"Create Product",title:"Create Product",requireAuth:!0}}),e.state("products.detail",{url:"/{productId}",component:"pncProductDetailPage",data:{displayName:"{{ product.name }}",title:"{{ product.name }}"},resolve:{product:["ProductResource","$stateParams",(e,t)=>e.get({id:t.productId}).$promise],productVersions:["product",e=>e.$queryProductVersions()]}})}])}(),function(){"use strict";angular.module("pnc.projects",["ui.router","pnc.common.directives","pnc.common.authentication"]).config(["$stateProvider",function(e){e.state("projects",{abstract:!0,url:"/projects",views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}},data:{proxy:"projects.list"}}),e.state("projects.list",{url:"",component:"pncProjectsListPage",data:{displayName:"Projects",title:"Projects"},resolve:{projects:["ProjectResource","SortHelper",(e,t)=>e.query(t.getSortQueryString("projectsList")).$promise]}}),e.state("projects.detail",{url:"/{projectId}",component:"pncProjectDetailPage",data:{displayName:"{{ project.name }}",title:"{{ project.name }} | Project"},resolve:{project:["ProjectResource","$stateParams",(e,t)=>e.get({id:t.projectId}).$promise],buildConfigs:["ProjectResource","$stateParams",(e,t)=>e.queryBuildConfigurations({id:t.projectId}).$promise]}}),e.state("projects.create",{url:"/create",component:"pncProjectCreatePage",data:{displayName:"Create Project",title:"Create Project",requireAuth:!0}})}])}(),function(){"use strict";angular.module("pnc.report",["ui.router","ui.bootstrap","pnc.common.directives","infinite-scroll","angularUtils.directives.dirPagination"]).config(["$stateProvider",function(e){e.state("report",{abstract:!0,views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}}}),e.state("report.blacklisted-artifacts-in-project",{url:"/blacklisted-artifacts-in-project",templateUrl:"report/views/blacklisted.artifacts.in.project.html",data:{displayName:"Show blacklisted artifacts in a project",title:"Show blacklisted artifacts in a project | Report"},controller:"BlacklistedArtifactsInProjectReportController",controllerAs:"blacklistedArtifactsInProjectReportCtrl"}),e.state("report.built-artifacts-in-project",{url:"/built-artifacts-in-project",templateUrl:"report/views/built.artifacts.in.project.html",data:{displayName:"Show built artifacts in a project",title:"Show built artifacts in a project | Report"},controller:"BuiltArtifactsInProjectReportController",controllerAs:"builtArtifactsInProjectReportCtrl"})}])}(),function(){"use strict";angular.module("pnc.scm-repositories",["ui.router","ui.bootstrap","pnc.common.authentication","pnc.common.pnc-client"]).config(["$stateProvider",function(e){e.state("scm-repositories",{url:"/scm-repositories",abstract:!0,views:{"content@":{templateUrl:"common/templates/single-col.tmpl.html"}},data:{proxy:"scm-repositories.list"}}),e.state("scm-repositories.list",{url:"",component:"pncScmRepositoriesListPage",data:{displayName:"SCM Repositories",title:"SCM Repositories"},resolve:{scmRepositories:["ScmRepositoryResource","SortHelper",function(e,t){return e.query(t.getSortQueryString("scmRepositoriesList")).$promise}]}}),e.state("scm-repositories.detail",{url:"/{scmRepositoryId}",component:"pncScmRepositoryDetailPage",data:{displayName:"{{ scmRepository.getName() }}",title:"{{ scmRepository.getName() }} | SCM Repository"},resolve:{scmRepository:["ScmRepositoryResource","$stateParams",function(e,t){return e.get({id:t.scmRepositoryId}).$promise}],buildConfigs:["ScmRepositoryResource","$stateParams",function(e,t){return e.queryBuildConfigs({id:t.scmRepositoryId}).$promise}]}}),e.state("scm-repositories.create",{url:"/create",component:"pncScmRepositoryCreatePage",data:{displayName:"Create SCM Repository",title:"Create SCM Repository",requireAuth:!0}})}])}(),function(){"use strict";angular.module("pnc.artifacts").component("pncArtifactLink",{bindings:{artifact:"<"},transclude:!0,templateUrl:"artifacts/components/pnc-artifact-link/pnc-artifact-link.html",controller:[function(){this.$onInit=(()=>{})}]})}(),function(){"use strict";angular.module("pnc.artifacts").component("pncArtifactsDetailPage",{bindings:{artifact:"<",build:"<",usages:"<"},templateUrl:"artifacts/detail/pnc-artifacts-detail-page.html",controller:[function(){this.buildListDisplayFields=["statusIcon","canonicalName","endTime","pushStatus"],this.$onInit=function(){}}]})}(),function(){"use strict";angular.module("pnc.artifacts").component("pncArtifactsDataTable",{bindings:{artifacts:"<"},templateUrl:"artifacts/list/pnc-artifacts-data-table.html",controller:["filteringPaginator","SortHelper",function(e,t){const i=this;i.artifactsFilteringFields=[{id:"identifier",title:"Identifier",placeholder:"Filter by Identifier",filterType:"text"},{id:"filename",title:"File Name",placeholder:"Filter by File Name",filterType:"text"},{id:"targetRepository.repositoryType",title:"Repo Type",placeholder:"Filter by Repo Type",filterType:"select",filterValues:["MAVEN","GENERIC_PROXY","NPM","COCOA_POD"]},{id:"artifactQuality",title:"Quality",placeholder:" Filter by artifact quality",filterType:"select",filterValues:["NEW","VERIFIED","TESTED","DEPRECATED","BLACKLISTED","TEMPORARY"]},{id:"md5",title:"md5",placeholder:"Filter by md5 checksum",filterType:"text"},{id:"sha1",title:"sha1",placeholder:"Filter by sha1 checksum",filterType:"text"},{id:"sha256",title:"sha256",placeholder:"Filter by sha256 checksum",filterType:"text"}],i.artifactsSortingFields=[{id:"identifier",title:"Identifier"},{id:"artifactQuality",title:"Quality"},{id:"filename",title:"File Name"},{id:"targetRepository.repositoryType",title:"Repo Type"}],i.$onInit=(()=>{i.artifactsFilteringPage=e(i.artifacts),i.artifactsSortingConfigs=t.getSortConfig("artifactsList")})}]})}(),function(){"use strict";angular.module("pnc.artifacts").component("pncArtifactsList",{bindings:{artifacts:"<"},templateUrl:"artifacts/list/pnc-artifacts-list.html",controller:[function(){this.$onInit=function(){}}]})}(),function(){"use strict";angular.module("pnc.artifacts").component("pncArtifactsListPage",{bindings:{artifacts:"<"},templateUrl:"artifacts/list/pnc-artifacts-list-page.html",controller:[function(){this.$onInit=(()=>{})}]})}(),function(){"use strict";angular.module("pnc.build-configs").factory("buildTypes",[function(){return[{id:"MVN",name:"Maven"},{id:"NPM",name:"Node Package Manager (NPM)"},{id:"GRADLE",name:"Gradle"}]}])}(),function(){"use strict";angular.module("pnc.build-configs").component("pncBuildConfigBuildMetricsTab",{bindings:{builds:"<"},require:{mainCtrl:"^^pncBuildConfigDetailMain"},templateUrl:"build-configs/detail/build-metrics-tab/pnc-build-config-build-metrics-tab.html",controller:[function(){var e=this;e.$onInit=function(){e.buildsData=e.builds.data}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncBuildConfigDependantsTab",{bindings:{dependants:"<"},require:{mainCtrl:"^^pncBuildConfigDetailMain"},templateUrl:"build-configs/detail/dependants-tab/pnc-build-config-dependants-tab.html",controller:[function(){this.$onInit=(()=>{})}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncBuildConfigDependenciesTab",{bindings:{buildConfig:"<",dependencies:"<"},require:{mainCtrl:"^^pncBuildConfigDetailMain"},templateUrl:"build-configs/detail/dependencies-tab/pnc-build-config-dependencies-tab.html",controller:[function(){const e=this;e.displayFields=["name","project","buildStatus"],e.onRemove=function(t){return console.log("Remove dependency: %O",t),e.buildConfig.$removeDependency({dependencyId:t.id})},e.onEdit=function(t){return console.log("Update dependencies: %O",t),e.buildConfig.dependencies=t.reduce((e,t)=>(e[t.id]=t,e),{}),e.buildConfig.$update()},e.refreshDependencies=function(t){e.dependencies.data=t}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncBuildConfigDetailsEditor",{bindings:{buildConfig:"<",onSuccess:"&",onCancel:"&"},templateUrl:"build-configs/detail/details-tab/pnc-build-config-details-editor.html",controller:["BuildConfigResource","ProductVersionResource",function(e,t){var i=this;i.working=!1,i.submit=function(){i.working=!0;var t=(n=i.formData,i.buildConfig,o=angular.extend({},n.general),o.scmRepository=n.scmRepository,o.parameters=n.parameters,o.productVersion=n.productVersion,o);var n,o;e.safePatchRemovingParameters(i.buildConfig,t).$promise.then(e=>{i.onSuccess({buildConfig:e})}).finally(()=>i.working=!1),console.log("UPDATE BC -> formData: %O | buildConfig: %O",i.formData,t)},i.cancel=function(){i.onCancel()},i.numberOfBuildParameters=function(){return Object.keys(i.formData.parameters).length},i.$onInit=function(){var e,n;i.formData=(e=i.buildConfig,(n={general:{},parameters:{},scmRepository:{}}).general.name=e.name,n.general.description=e.description,n.general.environment=e.environment,n.general.buildType=e.buildType,n.general.buildScript=e.buildScript,n.general.scmRevision=e.scmRevision,n.scmRepository=e.scmRepository,n.productVersion=e.productVersion,n.parameters=e.parameters,n),i.buildConfig=angular.copy(i.buildConfig),i.buildConfig.productVersion&&t.get({id:i.buildConfig.productVersion.id}).$promise.then(function(e){i.formData.productVersion=e,i.formData.product=e?e.product:null})},i.checkVersionData=(()=>{(!i.formData.product||i.formData.productVersion&&i.formData.product.id!==i.formData.productVersion.product.id)&&(i.formData.productVersion=null)})}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncBuildConfigDetailsTab",{bindings:{buildConfig:"<"},require:{mainCtrl:"^^pncBuildConfigDetailMain"},templateUrl:"build-configs/detail/details-tab/pnc-build-config-details-tab.html",controller:["notifyInline",function(e){var t,i=this,n=!1;function o(){n=!n}i.isEditModeActive=function(){return n},i.onCancelEdit=function(){o()},i.onSuccess=function(e){i.buildConfig=e,i.mainCtrl.updateBuildConfig(e),o(),t({type:"success",message:"Update Successful",persistent:!0})},i.toggleEdit=o,i.$onInit=function(){i.mainCtrl.registerOnEdit(o),t=e("edit-build-config")}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncBuildConfigProperties",{bindings:{buildConfig:"<",hideFields:"<"},templateUrl:"build-configs/detail/details-tab/pnc-build-config-properties.html",controller:[function(){var e=this;e.hideField=function(t){return e.hideFields&&e.hideFields.includes(t)},e.$onInit=function(){}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncBuildConfigGroupConfigsTab",{bindings:{groupConfigs:"<"},require:{mainCtrl:"^^pncBuildConfigDetailMain"},templateUrl:"build-configs/detail/group-configs-tab/pnc-build-config-group-configs-tab.html",controller:["filteringPaginator","SortHelper",function(e,t){const i=this;i.groupConfigsSortingFields=[{id:"name",title:"Name"}],i.$onInit=function(){i.groupConfigsFilteringPage=e(i.groupConfigs),i.groupConfigsFilterFields=[{id:"name",title:"Name",placeholder:"Filter by Name",filterType:"text"}],i.groupConfigsSortingConfigs=t.getSortConfig("groupConfigsList")}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncBuildConfigDetailMain",{bindings:{buildConfig:"<"},templateUrl:"build-configs/detail/pnc-build-config-detail-main.html",controller:["$scope","$state",function(e,t){var i,n=this;n.clone=function(){n.buildConfig.$clone().then(function(e){t.go("projects.detail.build-configs.detail",{configurationId:e.id,projectId:e.project.id},{reload:!0})})},n.edit=function(){i()},n.delete=function(){n.buildConfig.$delete().then(function(e){t.go("projects.detail",{configurationId:e.id},{reload:!0})})},n.registerOnEdit=function(e){i=e},n.updateBuildConfig=function(t){e.$applyAsync(function(){n.buildConfig=t})},n.$onInit=function(){}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncBuildConfigRevisionLink",{bindings:{revision:"<"},templateUrl:"build-configs/detail/revisions-tab/pnc-build-config-revision-link.html"})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncBuildConfigRevisionsTab",{bindings:{buildConfig:"<",revisions:"<"},require:{mainCtrl:"^^pncBuildConfigDetailMain"},templateUrl:"build-configs/detail/revisions-tab/pnc-build-config-revisions-tab.html",controller:[function(){this.$onInit=function(){}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncRevisionsDetails",{bindings:{revision:"<"},templateUrl:"build-configs/detail/revisions-tab/pnc-revisions-details.html",controller:["$state","BuildConfigResource","pncNotify",function(e,t,i){const n=this;n.restore=function(){t.restoreRevision({id:n.revision.id,revisionId:n.revision.rev},{}).$promise.then(()=>{e.go("^.^.default",{},{reload:!0}),i.success("Revision: "+n.revision.rev+" of "+n.revision.name+" restored")})},n.$onInit=function(){n.hideFields=["description","productVersion"]}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncRevisionsVerticalNav",{bindings:{revisions:"<"},templateUrl:"build-configs/detail/revisions-tab/pnc-revisions-vertical-nav.html",controller:[function(){this.$onInit=function(){}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncBuildConfigDetailSidebar",{bindings:{buildConfig:"<",builds:"<"},templateUrl:"build-configs/detail/sidebar/pnc-build-config-detail-sidebar.html",controller:[function(){}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncBuildConfigSidebarHistoryWidget",{bindings:{buildConfig:"<",builds:"<"},templateUrl:"build-configs/detail/sidebar/pnc-build-config-sidebar-history-widget.html",controller:["paginator","$scope","events",function(e,t,i){const n=this;n.$onInit=(()=>{n.page=e(n.builds),t.$on(i.BUILD_STATUS_CHANGED,(e,i)=>{i.buildConfigRevision.id===n.buildConfig.id.toString()&&t.$applyAsync(()=>{const e=n.page.data.findIndex(e=>e.id===i.id);e>-1?n.page.data.splice(e,1,i):(n.page.data.unshift(i),n.page.data.sort((e,t)=>e.submitTime-t.submitTime),n.page.data.length>n.page.size&&n.page.data.pop())})})})}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncBuildConfigsDataTable",{bindings:{page:"<",displayFields:"<",hideActions:"@",onRemove:"&",onEdit:"&",refreshBuildConfigs:"&"},templateUrl:"build-configs/directives/pnc-build-configs-data-table/pnc-build-configs-data-table.html",controller:["$scope","$q","modalSelectService","filteringPaginator","SortHelper",function(e,t,i,n,o){var r=this;const l=["name","project","buildStatus"];function s(){t.when().then(function(){return 1===r.page.total?r.page.data:r.page.getWithNewSize(r.page.total*r.page.size).then(function(e){return e.data})}).then(function(e){return i.openForBuildConfigs({title:"Insert / Remove Build Configs",buildConfigs:e}).result}).then(function(e){t.when(r.onEdit()(e)).then(function(){r.refreshBuildConfigs()(e),r.filterPage.refresh()})})}r.actions={remove:function(e){t.when(r.onRemove()(e)).then(()=>{r.refreshBuildConfigs()(r.page.data.filter(t=>t.id!==e.id)),r.filterPage.refresh()})}},r.edit=s,r.$onInit=function(){r.displayFields=r.displayFields||l,r.filterPage=n(r.page),r.filterFields=[{id:"name",title:"Name",placeholder:"Filter by Name",filterType:"text"}],r.sortingFields=[{id:"name",title:"Name"},{id:"project.name",title:"Project"},{id:"creationTime",title:"Created"},{id:"modificationTime",title:"Modified"}],r.sortingConfigs=o.getSortConfig("buildConfigsList"),r.toolbarActions=function(){const e=[];r.onEdit()&&e.push({name:"Edit",title:"Add or remove build configs to the list",actionFn:s});return e.length>0?{primaryActions:e}:void 0}()}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncBuildConfigsList",{bindings:{buildConfigs:"<",displayFields:"<",actionsTemplateUrl:"@",actionsData:"<"},templateUrl:"build-configs/directives/pnc-build-configs-list/pnc-build-configs-list.html",controller:["$scope",function(e){var t=this;t.showTable=function(){return t.buildConfigs&&t.buildConfigs.length>0},t.showColumn=function(e){return t.displayFields.includes(e)},t.$onInit=function(){e.actions=t.actionsData}}]})}(),angular.module("pnc.build-configs").directive("pncBuildScriptValidator",function(){return{restrict:"A",require:"ngModel",link:function(e,t,i,n){n.$validators.invalidBuildScript=function(e){return!e||function(e){var t=e.toLowerCase();if(t.indexOf("mvn")>-1){var i=!0;return["deploy"].forEach(function(e){-1!==t.indexOf(e)||(i=!1)}),i}return!0}(e)}}}}),function(){"use strict";angular.module("pnc.build-configs").component("pncCreateBuildConfigButton",{bindings:{project:"<"},templateUrl:"build-configs/directives/pnc-create-build-config-button/pnc-create-build-config-button.html",controller:["$log","$uibModal",function(e,t){var i=this;i.openWizardModal=function(){t.open({animation:!0,backdrop:"static",component:"pncCreateBuildConfigWizard",size:"lg",resolve:{project:function(){return i.project}}}).result.then(function(){},function(){})}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncCreateBuildConfigGeneralForm",{templateUrl:"build-configs/directives/pnc-create-build-config-general-form/pnc-create-build-config-general-form.html",require:{ngModel:"ngModel"},controller:["buildTypes",function(e){var t=this;t.buildTypes=e,t.$onInit=function(){t.ngModel.$render=function(){t.data=t.ngModel.$modelValue}},t.$doCheck=function(){t.ngModel.$viewValue!==t.data&&t.ngModel.$setViewValue(t.data)}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncCreateBuildConfigProductVersionForm",{templateUrl:"build-configs/directives/pnc-create-build-config-product-version-form/pnc-create-build-config-product-version-form.html",require:{ngModel:"ngModel"},controller:[function(){const e=this;e.$onInit=function(){e.ngModel.$render=function(){e.data=e.ngModel.$modelValue}},e.$doCheck=function(){e.ngModel.$viewValue!==e.data&&e.ngModel.$setViewValue(e.data)},e.checkVersionData=function(){(!e.data.product||e.data.version&&e.data.product.id!==e.data.version.product.id)&&(e.data.version=null)}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncCreateBuildConfigWizard",{templateUrl:"build-configs/directives/pnc-create-build-config-wizard/pnc-create-build-config-wizard.html",controller:["$timeout","BuildConfigResource","buildConfigCreator","utils",function(e,t,i,n){var o=this,r={general:{},buildParameters:{},dependencies:[],repoConfig:{}};function l(e){o.createdBuildConfigId=e.id,o.wizardDone=!0}function s(e){o.createStatusMessages.push(e),o.createError=!0,o.wizardDone=!0}o.generalForm={},o.repoForm={},o.nextButtonTitle="Next >",o.reviewPageShown=!1,o.createStatusMessages=[],o.wizardDone=!1,o.createError=!1,o.onStepChange=function(e){switch(e.stepId){case"review-summary":o.nextButtonTitle="Create";break;case"review-create":o.nextButtonTitle="Close";break;default:o.nextButtonTitle="Next >"}},o.onShowReviewSummary=function(){o.reviewPageShown=!0,e(function(){o.reviewPageShown=!1})},o.create=function(){const e=function(e){const t=angular.copy(e.general);t.environment={id:e.general.environment.id.toString()},t.scmRevision=e.repoConfig.revision,t.project={id:e.project.id.toString()},n.isNotEmpty(e.productVersion)&&(t.productVersion={id:e.productVersion.version.id.toString()});n.isNotEmpty(e.buildParameters)&&(t.parameters=angular.copy(e.buildParameters));n.isNotEmpty(e.dependencies)&&(t.dependencies=e.dependencies.reduce((e,t)=>(e[t.id]={id:t.id},e),{}));return t}(o.wizardData);o.wizardData.repoConfig.useExistingRepoConfig?function(e){e.scmRepository={id:o.wizardData.repoConfig.repoConfig.id},t.save(e).$promise.then(e=>l(e),e=>s(e))}(e):function(e){i.createWithScm({buildConfig:e,scmUrl:o.wizardData.repoConfig.scmUrl,preBuildSyncEnabled:o.wizardData.repoConfig.preBuildSyncEnabled}).then(e=>{console.debug("Received: Create BC success => %O",e),l(e.buildConfig)},e=>{console.debug("Received: Create BC error => %O",e),s(e.message)},e=>{console.debug("Received: Create BC progress update => %O",e)})}(e)},o.closePreviousWizardModal=function(){o.modalInstance.close()},o.$onInit=function(){o.wizardData=angular.extend({},r,o.resolve.initialValues),o.wizardData.project=o.resolve.project}}],bindings:{modalInstance:"<",project:"<",resolve:"<",onClose:"&close"}})}(),function(){"use strict";angular.module("pnc.build-configs").directive("pncInternalExternalUrl",[function(){return{restrict:"E",templateUrl:"build-configs/directives/pnc-internal-external-url/pnc-internal-external-url.html",scope:{data:"=",form:"=",sidebarCols:"@",singleScm:"@?"},controller:["$scope","pncProperties",function(e,t){e.sidebarClass="col-sm-"+e.sidebarCols,e.contentClass="col-sm-"+(12-e.sidebarCols),e.exactHost=t.internalScmAuthority}]}}])}(),function(){"use strict";angular.module("pnc.build-configs").component("pncReopenBuildConfigButton",{bindings:{initialValues:"<"},templateUrl:"build-configs/directives/pnc-reopen-build-config-button/pnc-reopen-build-config-button.html",controller:["$log","$uibModal",function(e,t){var i=this;i.reopenWizardModal=function(){t.open({animation:!0,backdrop:"static",component:"pncCreateBuildConfigWizard",size:"lg",resolve:{project:function(){return i.initialValues.project},initialValues:function(){return i.initialValues}}})}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncSelectBuildConfigs",{templateUrl:"build-configs/directives/pnc-select-build-configs/pnc-select-build-configs.html",bindings:{onAdd:"&",onRemove:"&",onChange:"&"},require:{ngModel:"?ngModel"},controller:["utils",function(e){var t,i=this,n=[{name:"Remove",title:"Remove this dependency",actionFn:function(e,t){i.remove(t)}}];function o(e){return i.buildConfigs.findIndex(function(t){return t.id===e.id})}i.buildConfigs=[],i.listConfig={selectItems:!1,multiSelect:!1,dblClick:!1,selectionMatchProp:"id",showSelectBox:!1},i.listActionButtons=n,i.add=function(e){if(o(e)>-1)return;i.buildConfigs.push(e),i.buildConfig=void 0,i.onAdd&&i.onAdd({buildConfig:e})},i.remove=function(e){var t=o(e);if(-1===t)return;i.buildConfigs.splice(t,1),i.onRemove&&i.onRemove({buildConfig:e})},i.$onInit=function(){i.ngModel&&(i.ngModel.$render=function(){i.buildConfigs=i.ngModel.$viewValue})},i.$doCheck=function(){var n=e.hashCode(i.buildConfigs);n!==t&&i.buildConfigs.length&&(!function(){i.ngModel&&i.ngModel.$setViewValue(i.buildConfigs);i.onChange&&i.onChange({buildConfigs:i.buildConfigs})}(),t=n)}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncDisplayBuildParameters",{bindings:{params:"<",onEdit:"&",onRemove:"&"},templateUrl:"build-configs/directives/pnc-select-build-parameters/pnc-display-build-parameters.html",controller:[function(){var e=this,t={};function i(t){e.currentParams[t]=angular.copy(e.params[t])}e.$onInit=function(){e.currentParams=angular.copy(e.params)},e.$doCheck=function(){angular.isUndefined(e.currentParams)||Object.keys(e.params).forEach(function(t){e.currentParams.hasOwnProperty(t)||i(t)})},e.cancel=function(t){i(t),e.setEditOff(t)},e.update=function(t,i){e.onEdit({key:t,value:i}),e.setEditOff(t)},e.remove=function(i){e.onRemove({key:i}),delete e.currentParams[i],delete t[i]},e.setEditOn=function(e){t[e]=!0},e.setEditOff=function(e){t[e]=!1},e.toggleEdit=function(e){t[e]=!t[e]},e.isEditOn=function(e){return!!t[e]}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncEnterBuildParameters",{bindings:{onAdd:"&",onRemove:"&",knownKeys:"<"},templateUrl:"build-configs/directives/pnc-select-build-parameters/pnc-enter-build-parameters.html",controller:["$q","$filter","utils",function(e,t,i){var n=this;n.add=function(){n.onAdd({key:n.key,value:n.value}),n.clear()},n.clear=function(){n.key=void 0,n.value=void 0},n.searchKnownKeys=function(o){var r=e.when(n.knownKeys);if(i.isEmpty(o))return r;return r.then(function(e){return t("filter")(e,{name:o})})}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncSelectBuildParameters",{require:{ngModel:"?ngModel"},bindings:{buildType:"<"},templateUrl:"build-configs/directives/pnc-select-build-parameters/pnc-select-build-parameters.html",controller:["$scope","utils","BuildConfigResource",function(e,t,i){var n=this;n.knownKeys=void 0,n.params={},n.addParam=function(e,t){n.params[e]=t},n.removeParam=function(e){delete n.params[e]},n.hasParams=function(){return Object.keys(n.params).length>0},n.$onInit=function(){n.knownKeys=i.getSupportedGenericParameters().then(function(e){return function(e){var t=[];return e.forEach(e=>{t.push({name:e.name,description:e.description})}),t}(e)}),e.$watch(function(){return t.concatStrings(n.params)},function(){n.ngModel.$setViewValue(n.params)}),n.ngModel.$render=function(){n.params=angular.isDefined(n.ngModel.$viewValue)?n.ngModel.$viewValue:{}}}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncSelectRepository",{require:{ngModel:"ngModel"},templateUrl:"build-configs/directives/pnc-select-repository/pnc-select-repository.html",controller:["$log","$q","utils","pncNotify","ScmRepositoryResource","pncProperties",function(e,t,i,n,o,r){var l,s=this,a=!1;s.userData={},s.checkForRepo=function(e){s.userData.selectedRepoConfig=void 0,s.multipleRCError=!1,a=!0,function(e){if(i.isEmpty(e))return t.when();return o.query({"search-url":e}).$promise.then(function(e){var t=e.data;return t.length>0?t[0]:void 0})}(e).then(function(e){e&&e.id&&(s.userData.selectedRepoConfig=e)}).finally(function(){a=!1})},s.isLoading=function(){return a},s.isRepoInternal=function(e){if(e)return e.includes(r.internalScmAuthority)},s.$onInit=function(){s.ngModel.$render=function(){s.userData=s.ngModel.$modelValue,void 0===s.userData.preBuildSyncEnabled&&(s.userData.preBuildSyncEnabled=!0),angular.isDefined(s.userData.scmUrl)&&s.checkForRepo(s.userData.scmUrl)}},s.$doCheck=function(){var e,t=(e=s.userData.selectedRepoConfig?s.userData.selectedRepoConfig.id:void 0,""+s.userData.scmUrl+s.userData.revision+s.userData.preBuildSyncEnabled+e);l===t||angular.equals({},s.userData)||(s.ngModel.$setViewValue(function(){var e={scmUrl:s.userData.scmUrl,revision:s.userData.revision,preBuildSyncEnabled:s.userData.preBuildSyncEnabled,useExistingRepoConfig:angular.isDefined(s.userData.selectedRepoConfig)};angular.isDefined(s.userData.selectedRepoConfig)&&(e.repoConfig=s.userData.selectedRepoConfig);return e}()),l=t)}}]})}(),function(){"use strict";angular.module("pnc.build-configs").component("pncBuildConfigsListPage",{bindings:{buildConfigs:"<"},templateUrl:"build-configs/list/pnc-build-configs-list-page.html",controller:[function(){const e=this;e.$onInit=(()=>{e.displayFields=["name","description","project","buildStatus"]})}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncBuildDetailAlignmentLogPage",{bindings:{build:"<",alignmentLog:"<"},templateUrl:"builds/detail/alignment-log/pnc-build-detail-alignment-log-page.html",controller:[function(){const e=this;e.logFileName=null,e.sshCredentialsBtn={clicked:!1},e.$onInit=function(){e.logFileName=e.build.id+"_"+e.build.buildConfigRevision.name+"_"+e.build.status+"_alignment-log.txt"}}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncBuildDetailArtifactsPage",{bindings:{artifacts:"<"},templateUrl:"builds/detail/artifacts/pnc-build-detail-artifacts-page.html",controller:["filteringPaginator",function(e){const t=this;t.artifactsFilteringFields=[{id:"identifier",title:"Identifier",placeholder:"Filter by Identifier",filterType:"text"},{id:"filename",title:"Filename",placeholder:"Filter by Filename",filterType:"text"},{id:"targetRepository.repositoryType",title:"Repo Type",placeholder:"Filter by Repo Type",filterType:"select",filterValues:["MAVEN","GENERIC_PROXY","NPM","COCOA_POD"]},{id:"artifactQuality",title:"Quality",placeholder:" Filter by artifact quality",filterType:"select",filterValues:["NEW","VERIFIED","TESTED","DEPRECATED","BLACKLISTED","TEMPORARY"]},{id:"md5",title:"md5",placeholder:"Filter by md5 checksum",filterType:"text"},{id:"sha1",title:"sha1",placeholder:"Filter by sha1 checksum",filterType:"text"},{id:"sha256",title:"sha256",placeholder:"Filter by sha256 checksum",filterType:"text"}],t.$onInit=function(){t.artifactsFilteringPage=e(t.artifacts)}}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncBuildDetailBrewPushPage",{bindings:{build:"<",brewPushResult:"<"},templateUrl:"builds/detail/brew-push/pnc-build-detail-brew-push-page.html",controller:["$scope",function(e){const t=this;function i(e){e&&(t.data=e,t.prefixFilters="loggerName.keyword:org.jboss.pnc.causeway|org.jboss.pnc._userlog_,level.keyword:INFO|ERROR|WARN",t.matchFilters=`mdc.buildId.keyword:${e.buildId},mdc.processContext.keyword:${e.logContext}`)}t.$onInit=(()=>{i(t.brewPushResult),e.$on("BUILD_PUSH_STATUS_CHANGE",(n,o)=>{o.buildId===t.build.id&&e.$applyAsync(()=>i(o))})})}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncBuildDetailBuildLogPage",{bindings:{build:"<",buildLog:"<",sshCredentials:"<"},templateUrl:"builds/detail/build-log/pnc-build-detail-build-log-page.html",controller:[function(){const e=this;e.logFileName=null,e.sshCredentialsBtn={clicked:!1},e.$onInit=function(){e.logFileName=e.build.id+"_"+e.build.buildConfigRevision.name+"_"+e.build.status+".txt"}}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncBuildDetailBuildMetricsPage",{bindings:{build:"<"},templateUrl:"builds/detail/build-metrics/pnc-build-detail-build-metrics-page.html",controller:[function(){}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncBuildDetailDetailsPage",{bindings:{build:"<",dependencyGraph:"<",buildConfigRevision:"<"},templateUrl:"builds/detail/details/pnc-build-detail-details-page.html",controller:["$scope","events","buildStatusHelper",function(e,t,i){const n=this;n.$onInit=function(){n.buildStatusHelper=i,e.$on(t.BUILD_STATUS_CHANGED,(t,i)=>{n.build.id===i.id&&e.$applyAsync(()=>n.build=i)})}}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncBuildDetailPage",{bindings:{build:"<",dependencyGraph:"<",buildConfigRevision:"<"},templateUrl:"builds/detail/pnc-build-detail-page.html",controller:["$scope","events",function(e,t){const i=this;i.isFinished=!1,i.$onInit=function(){i.isFinished="FINISHED"===i.build.progress,e.$on(t.BUILD_STATUS_CHANGED,(t,n)=>{i.build.id===n.id&&(e.$applyAsync(()=>i.build=n),i.isFinished="FINISHED"===n.progress)})}}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncBrewPushButton",{bindings:{build:"<?",groupBuild:"<?"},templateUrl:"builds/directives/pnc-brew-push-button/pnc-brew-push-button.html",controller:["$state","$uibModal","pncNotify","BuildResource","GroupBuildResource","EntityRecognizer",function(e,t,i,n,o,r){const l=this;function s(){return!angular.isUndefined(l.build)&&r.isBuild(l.build)}function a(){e.go("projects.detail.build-configs.detail.builds.detail.brew-push",{projectId:l.build.project.id,configurationId:l.build.buildConfigRevision.id,buildId:l.build.id},{reload:!0})}l.isButtonVisible=function(){if(s())return l.build.$isSuccess();if(function(){if(angular.isUndefined(l.groupBuild))return!1;return r.isGroupBuild(l.groupBuild)}())return o.isSuccess(l.groupBuild)},l.openTagNameModal=function(){t.open({animation:!0,backdrop:"static",component:"pncEnterBrewTagNameModal",size:"md"}).result.then(function(e){return s()?function(e){n.brewPush({id:l.build.id},{tagPrefix:e.tagName}).$promise.then(e=>{console.info("Initiated brew push of build %s - response: %O",l.build.$canonicalName(),e),a()},e=>{console.error("Brew push error for build %s - response: %O",l.build.$canonicalName(),e),409===e.status&&a()})}(e):function(e){o.brewPush({id:l.groupBuild.id},{tagPrefix:e.tagName}).$promise.then(()=>i.info(`Initiated brew push of GroupBuild: ${l.groupBuild.$canonicalName()}`),e=>console.error("Brew push GroupBuild error: %O",e))}(e)})}}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncBuildConfigHistoryRevision",{bindings:{revision:"<",project:"<"},transclude:!0,templateUrl:"builds/directives/pnc-build-config-history-revision/pnc-build-config-history-revision.html",controller:[function(){this.$onInit=(()=>{})}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncBuildConfigLink",{bindings:{revision:"<"},transclude:!0,templateUrl:"builds/directives/pnc-build-config-link/pnc-build-config-link.html",controller:[function(){this.$onInit=(()=>{})}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncBuildLink",{bindings:{build:"<",shortLink:"@"},transclude:!0,templateUrl:"builds/directives/pnc-build-link/pnc-build-link.html",controller:[function(){const e=this;function t(){e.buildId=e.build.id,e.linkText=function(){angular.isUndefined(e.build)&&console.error("getLinkText() :: $ctrl.build is undefined // $ctrl = %O",e);return"true"===e.shortLink?"#"+e.build.id:e.build.$canonicalName()}()}e.$onInit=(()=>{t()}),e.$onChanges=(e=>{e.build&&t()})}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncBuildTree",{bindings:{build:"<?",groupBuild:"<?",dependencyGraph:"<?"},templateUrl:"builds/directives/pnc-build-tree/pnc-build-tree.html",controller:["BuildResource","GroupBuildResource","$timeout","$scope","$log","$q","EntityRecognizer",function(e,t,i,n,o,r,l){var s=this,a=null,c=n.$id,d=null;function u(e,t){var i="#",n="-",o=[];return l.isBuild(s.buildItem)&&(s.buildItem._dependentBuildIds=e.vertices[s.buildItem.id]._dependentBuildIds||[]),{dependentStructure:s.buildItem._dependentBuildIds,dependencyStructure:function r(s,a,u){u=u||1;var p=l.isBuild(s);var m=a===d;var g="";t&&(t.expandLevel&&u>t.expandLevel||t.expandFailed&&("DONE"===s.status||"REJECTED_ALREADY_BUILT"===s.status)&&!m)&&(g+="collapsed");m&&(g+=" bg-lightblue");var f={id:s.id,attrId:a?a.attrId+n+s.id:c+"-"+s.id,attrParent:a?i+a.attrId:void 0,attrClass:g,tdAttrClass:"level-"+u};p?f.isBuild=!0:(f.isGroupBuild=!0,s._buildIds=(h=(b=e).edges.map(function(e){return e.target}),Object.keys(b.vertices).filter(function(e){var t=h.find(function(t){return t===e});return angular.isUndefined(t)})));var b,h;o.push(f);s._dependencyBuildIds=e.vertices[s.id]._dependencyBuildIds||[];(p?s._dependencyBuildIds:s._buildIds).forEach(function(t){e.vertices[t]&&r(e.vertices[t].data,f,u+1)});return o}(s.buildItem,d),nodes:e.vertices}}s.buildTree=null,s.buildItem=null,s.isLoaded=!1,s.loadingErrorMessage="",s.expandNodes=function(e){if(e>0&&e<=2){var t=$("#"+s.componentIdAttr+" .treegrid-node");t.first().parent().hasClass("collapsed")||t.first().click();for(var n=1;n<=e;n++)t.filter(".level-"+n).click()}else{var o={};e?-1===e?o.expandFailed=!0:e>=1&&(o.expandLevel=e):o=null,s.dependencyStructureIsLoaded=!1,a.then(function(e){s.buildTree.dependencyStructure=u(e,o).dependencyStructure,i(function(){$(".table-treegrid").treegrid(),s.dependencyStructureIsLoaded=!0})})}},s.componentIdAttr="build-tree-"+c,s.$onInit=function(){s.buildItem=s.build?s.build:s.groupBuild,(a=s.dependencyGraph?r.when(s.dependencyGraph):(s.build?e:t).getDependencyGraph({id:s.buildItem.id}).$promise).then(function(e){!function(e){e.edges.forEach(t=>{let i=t.source,n=t.target,o=e.vertices[i],r=e.vertices[n];o._dependencyBuildIds=o._dependencyBuildIds||[],r._dependentBuildIds=r._dependentBuildIds||[],o._dependencyBuildIds.push(n),r._dependentBuildIds.push(i)})}(e),s.buildTree=u(e,{expandLevel:2})}).catch(e=>{s.loadingErrorMessage=e.data.errorMessage}).finally(function(){s.isLoaded=!0})},s.$postLink=function(){a.then(function(){i(function(){$(".table-treegrid").treegrid(),s.dependencyStructureIsLoaded=!0})})}}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncBuildTreeLink",{bindings:{build:"<?",groupBuild:"<?"},templateUrl:"builds/directives/pnc-build-tree/pnc-build-tree-link.html",controller:["$scope","events",function(e,t){var i=this;function n(e){i.buildItem=angular.copy(e)}function o(e,t){t.id===i.buildItem.id&&n(t)}i.$onInit=function(){n(i.build?i.build:i.groupBuild),e.$on(t.BUILD_STATUS_CHANGED,o),e.$on(t.GROUP_BUILD_STATUS_CHANGED,o)},i.$onChanges=function(e){e.build?n(i.build):e.groupBuild&&n(i.groupBuild)}}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncBuildsDataTable",{bindings:{page:"<",displayFields:"<"},templateUrl:"builds/directives/pnc-builds-data-table/pnc-builds-data-table.html",controller:["paginator",function(e){var t=this,i=["status","id","configurationName","startTime","endTime","username"];t.$onInit=function(){t.displayFields=t.displayFields||i,t.paginator=e(t.page)}}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncBuildsList",{bindings:{builds:"<?",groupBuilds:"<?",displayFields:"<?",hideHead:"<?"},templateUrl:"builds/directives/pnc-builds-list/pnc-builds-list.html",controller:[function(){var e=this,t=["status","id","configurationName","submitTime","startTime","endTime","username"];e.showTable=function(){return e.items&&e.items.length},e.showColumn=function(t){return e.fields.includes(t)},e.$onInit=function(){e.items=e.builds?e.builds:e.groupBuilds,e.fields=e.displayFields||t},e.$onChanges=function(t){t.builds?e.items=e.builds:t.groupBuilds&&(e.items=e.groupBuilds)}}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncLiveUpdateBuildsList",{bindings:{builds:"<?",displayFields:"<?",hideHead:"<?"},templateUrl:"builds/directives/pnc-builds-list/pnc-live-update-builds-list.html",controller:["$scope","events",function(e,t){var i=this;function n(t,n){var o;i.builds&&(o=i.builds.find(function(e){return e.id===n.id}))&&e.$applyAsync(function(){Object.assign(o,n)})}i.$onInit=function(){e.$on(t.BUILD_STATUS_CHANGED,n)}}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncEnterBrewTagNameModal",{bindings:{doClose:"&close",doDismiss:"&dismiss"},templateUrl:"builds/directives/pnc-enter-brew-tag-name-modal/pnc-enter-brew-tag-name-modal.html",controller:[function(){var e=this;e.done=function(){e.doClose({$value:{tagName:e.data.name}})},e.cancel=function(){e.doDismiss()},e.$onInit=function(){e.data={},e.data.tagName=""}}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncLogStreamer",{bindings:{build:"<"},templateUrl:"builds/directives/pnc-log-streamer/pnc-log-streamer.html",controller:["pncProperties",function(e){const t=this;t.$onInit=(()=>{const i=new URL(e.externalBifrostUrl);t.bifrostHost=i.host,t.prefixFilters="loggerName.keyword:org.jboss.pnc._userlog_",t.matchFilters=`mdc.processContext.keyword:build-${t.build.id}`})}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncStaticLog",{bindings:{log:"<"},templateUrl:"builds/directives/pnc-static-log/pnc-static-log.html",controller:[function(){var e=this,t="logWrap",i=!0;e.logWrap=function(e){var t=localStorage.getItem(e);if(null===t)return i;return JSON.parse(t)}(t),e.handleModelChange=function(){localStorage.setItem(t,e.logWrap)}}]})}(),function(){"use strict";angular.module("pnc.builds").component("pncBuildsListPage",{bindings:{builds:"<"},templateUrl:"builds/list/pnc-builds-list-page.html",controller:["$scope","events","filteringPaginator","SortHelper",function(e,t,i,n){const o=this;o.buildsFilteringFields=[{id:"user.username",title:"Username",placeholder:"Filter by Username",filterType:"text",filterMethod:"RSQL"},{id:"buildConfigName",title:"Build Config Name",placeholder:"Filter by Build Config name",filterType:"text",filterMethod:"QUERY_PARAM"},{id:"status",title:"Status",placeholder:"Filter by Status",filterType:"select",filterValues:["SUCCESS","REJECTED","FAILED","CANCELLED","BUILDING","NO_REBUILD_REQUIRED","SYSTEM_ERROR"],filterMethod:"RSQL"},{id:"temporaryBuild",title:"Temporary Build",placeholder:"Filter by Temporary Build",filterType:"select",filterValues:["FALSE","TRUE"],filterMethod:"RSQL"}],o.buildsSortingFields=[{id:"status",title:"Status"},{id:"startTime",title:"Start Time"},{id:"submitTime",title:"Submit Time"},{id:"endTime",title:"End Time"},{id:"user.username",title:"Username"}],o.$onInit=function(){o.buildsFilteringPage=i(o.builds),o.buildsSortingConfigs=n.getSortConfig("buildsList"),e.$on(t.BUILD_PROGRESS_CHANGED,()=>o.buildsFilteringPage.refresh())}}]})}(),function(){"use strict";angular.module("pnc.common.authentication").provider("authConfig",function(){var e=864e5;function t(){return e}return{setSsoTokenLifespan:function(t){angular.isNumber(t)?e=t:console.warn("Invalid value for configuration item ssoTokenLifespan: %s, using default of %d",t,e)},getSsoTokenLifespan:t,$get:function(){return{getSsoTokenLifespan:t}}}})}(),function(){"use strict";angular.module("pnc.common.authentication").factory("authService",["$log","$window","$q","$http","$httpParamSerializerJQLike","keycloak","authConfig","UserResource",function(e,t,i,n,o,r,l,s){var a,c={};return c.isAuthenticated=function(){return r.authenticated},c.getPrinciple=function(){return r.authenticated?r.idTokenParsed.preferred_username:null},c.isCurrentUser=function(e){return c.getPrinciple()===e.username},c.verifySsoTokenLifespan=function(){if(r.authenticated)return r.refreshTokenParsed.exp<Date.now()+l.getSsoTokenLifespan()},c.getPncUser=function(){return i((e,t)=>{if(!c.isAuthenticated)return t("User is not authenticated");a||(a=s.getAuthenticatedUser().$promise),e(a)})},c.forUserId=function(e){return c.getPncUser().then(t=>{if(console.log("authService.forUserId -> userId: %s | user: %O",e,t),t.id.toString()!==e)return i.reject()})},c.logout=function(e){a=void 0,r.logout({redirectUri:e||t.location.href})},c.login=function(e){r.login({redirectUri:e||t.location.href})},c.logoutAsync=function(){return n({url:r.tokenParsed.iss+"/protocol/openid-connect/logout",method:"POST",data:o({client_id:r.clientId,client_secret:r.clientSecret,refresh_token:r.refreshToken}),headers:{"Content-Type":"application/x-www-form-urlencoded"},successNotification:!1}).finally(()=>{r.clearToken(),a=void 0})},c.getUserRole=function(){return r.authenticated?r.realmAccess.roles:null},c}])}(),function(){"use strict";angular.module("pnc.common.authentication").directive("pncRequiresAuth",["authService",function(e){return{restrict:"A",link:function(t,i,n){e.isAuthenticated()||n.$set("disabled","disabled")}}}])}(),function(){"use strict";angular.module("pnc.common.authentication").factory("httpAuthenticationInterceptor",["$q","$log","$injector","keycloak",function(e,t,i,n){var o={};function r(e,t){e.headers=e.headers||{},e.headers.Authorization="Bearer "+t}return o.request=function(o){var l;if(n&&(l=i.get("authService"),n.authenticated&&!l.verifySsoTokenLifespan()&&(t.info("SSO token lifespace below threshold, terminating session"),l.logoutAsync(),n.clearToken()),n.token)){if(n.isTokenExpired(82800)){var s=e.defer();return n.updateToken(0).success(function(){r(o,n.token),s.resolve(o)}).error(function(){t.warn("Failed to refresh authentication token"),n.clearToken(),s.resolve(o)}),s.promise}return r(o,n.token),o}return o},o}])}(),function(){"use strict";angular.module("pnc.common.authentication").provider("keycloak",function(){var e,t={setKeycloak:function(t){e=t}};return t.$get=["$log",function(t){return t.debug("keycloak=%O",e),e}],t})}(),function(){"use strict";angular.module("pnc.common.bifrost").provider("bifrostConfig",function(){let e;function t(){return e}function i(){return new URL(e).host}return{setBifrostUrl:function(t){e=t},getBifrostUrl:t,getBifrostHost:i,$get:()=>({getBifrostUrl:t,getBifrostHost:i})}})}(),function(){"use strict";angular.module("pnc.common.bifrost").component("pncBifrostLogViewer",{bindings:{prefixFilters:"<",matchFilters:"<"},templateUrl:"common/bifrost/pnc-bifrost-log-viewer.html",controller:["bifrostConfig",function(e){const t=this;t.$onInit=(()=>{t.bifrostHost=e.getBifrostHost()})}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncAdminPanel",{bindings:{},templateUrl:"common/components/pnc-admin-panel/pnc-admin-panel.html",controller:["GenericSetting","$scope","events",function(e,t,i){var n=this;n.data={reason:null};var o=function(e){$("#"+e).removeClass("has-error"),$("#"+e).find(".help-block").addClass("ng-hide")};n.validateActivateFormGroup=function(){return n.data.reason&&""!==n.data.reason?(o("confirmActivateFormGroup"),!0):(e="confirmActivateFormGroup",$("#"+e).addClass("has-error"),$("#"+e).find(".help-block").removeClass("ng-hide"),!1);var e},n.clearMaintenanceValidation=function(){o("confirmActivateFormGroup")},n.activateMaintenanceMode=function(){n.validateActivateFormGroup()&&e.activateMaintenanceMode(n.data.reason).then(function(e){204===e.status&&(r(!0),n.data.reason=null,$("#activateMaintenance").modal("hide"))})};var r=function(e){$("#maintenance-switch").bootstrapSwitch("state",e,!0)};$("#maintenance-switch").on("switchChange.bootstrapSwitch",function(t,i){r(!i),i?$("#activateMaintenance").modal():e.deactivateMaintenanceMode().then(function(e){204===e.status&&r(!1)})}),document.getElementById("activateReason").addEventListener("keyup",function(e){13===e.keyCode&&(e.preventDefault(),n.clearMaintenanceValidation(),document.getElementById("confirm-maintenance-mode").click())}),n.$onInit=function(){e.inMaintenanceMode().then(function(e){r(e.data)}),t.$on(i.MAINTENANCE_MODE_ON,()=>{r(!0)}),t.$on(i.MAINTENANCE_MODE_OFF,()=>{r(!1)})}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncBrewPushStatusLabel",{bindings:{build:"<?"},templateUrl:"common/components/pnc-brew-push-status-label/pnc-brew-push-status-label.html",controller:["BuildResource",function(e){var t=this;t.pushStatus={},t.loading=!0,t.$onInit=function(){t.build.$isSuccess()?e.getBrewPushResult({id:t.build.id}).$promise.then(function(e){t.pushStatus=e}).catch(function(e){if(404!==e.status)throw e;console.log("No Brew Push Result is available for Build#"+t.build.id)}).finally(function(){t.loading=!1}):t.loading=!1}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncBuildConfigCombobox",{bindings:{modelProperty:"@modelValue"},require:{ngModel:"?ngModel"},templateUrl:"common/components/pnc-build-config-combobox/pnc-build-config-combobox.html",controller:["$log","$scope","$element","BuildConfigResource","utils","rsqlQuery","$timeout",function(e,t,i,n,o,r,l){const s=this;var a;s.search=function(e){if(o.isEmpty(e))return a;return function(e){var t=r().where("name").like("*"+e+"*").end();return n.query({q:t}).$promise.then(e=>e.data)}(e)},s.$onInit=function(){t.$watch(function(){return s.input},function(){s.ngModel.$setViewValue(s.input)}),s.ngModel.$parsers.push(function(e){return angular.isObject(e)&&angular.isDefined(s.modelProperty)?e[s.modelProperty]:e}),s.ngModel.$render=function(){!s.ngModel.$isEmpty(s.ngModel.$viewValue)&&angular.isDefined(s.modelProperty)&&e.warn("pnc-build-config-combobox: programatic changing of the ng-model value is not fully supported when model-value parameter is used. The display value of the combobox will not be correctly mapped"),s.input=s.ngModel.$viewValue},a=n.query({pageSize:20}).$promise.then(e=>e.data)},s.$postLink=function(){l(function(){i.find("input").on("blur",function(){s.ngModel.$setTouched()})})},s.$onDestroy=function(){i.find("input").off("blur")}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncBuildConfigStatusIcon",{bindings:{buildConfig:"<"},templateUrl:"common/components/pnc-build-config-status-icon/pnc-build-config-status-icon.html",controller:["$scope","events","BuildConfigResource",function(e,t,i){const n=this;n.$onInit=(()=>{n.isLoaded=!1,i.getLatestBuild({id:n.buildConfig.id}).$promise.then(e=>n.build=e).finally(()=>n.isLoaded=!0),e.$on(t.BUILD_STATUS_CHANGED,(e,t)=>{n.buildConfig.id===t.buildConfigRevision.id&&(n.build=t)})})}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncBuildMetrics",{bindings:{builds:"<",chartType:"@?",componentId:"@?"},templateUrl:"common/components/pnc-build-metrics/pnc-build-metrics.html",controller:["BuildResource",function(e){var t=this,i=null,n=null,o={};t.BUILDS_DISPLAY_LIMIT=20,t.BUILDS_DISPLAY_LIMIT_EXAMPLE=5,t.metricsTooltip=null,t.navigationOptions=[{id:1,name:"1st"},{id:2,name:"2nd"},{id:3,name:"3rd"},{id:5,name:"5th"},{id:10,name:"10th"}],t.navigationSelected=t.navigationOptions[0];var r=function(e){switch(e){case"WAITING_FOR_DEPENDENCIES":return{color:"#a18fff",label:"Waiting",description:"Waiting for dependencies"};case"ENQUEUED":return{color:"#c8eb79",label:"Enqueued",description:"Waiting to be started, the metric ends with the BPM process being started from PNC Orchestrator"};case"SCM_CLONE":return{color:"#7dbdc3",label:"SCM Clone",description:"Cloning / Syncing from Gerrit"};case"ALIGNMENT_ADJUST":return{color:"#f7bd7f",label:"Alignment",description:"Alignment only"};case"BUILD_ENV_SETTING_UP":return{color:"#7cdbf3",label:"Starting Environment",description:"Requesting to start new Build Environment in OpenShift"};case"REPO_SETTING_UP":return{color:"#00b9e4",label:"Artifact Repos Setup",description:"Creating per build artifact repositories in Indy"};case"BUILD_SETTING_UP":return{color:"#008bad",label:"Building",description:"Uploading the build script, running the build, downloading the results (logs)"};case"COLLECTING_RESULTS_FROM_BUILD_DRIVER":return{color:"black",label:"Collecting Results From Build Driver",description:"",skip:!0};case"COLLECTING_RESULTS_FROM_REPOSITORY_MANAGER":return{color:"#703fec",label:"Promotion",description:"Downloading the list of built artifact and dependencies from Indy, promoting them to shared repository in Indy"};case"FINALIZING_BUILD":return{color:"#3f9c35",label:"Finalizing",description:"Completing all other build execution tasks, destroying build environments, invoking the BPM"};case"OTHER":return{color:"silver",label:"Other",description:"Other tasks from the time when the build was submitted to the time when the build ends"};default:return console.warn('adaptMetric: Unknown metric name: "'+e+'"',e),{color:"gray",label:e}}},l=function(e){if(null===e||"NaN"===e)return"Not Available";var t={milliseconds:e%1e3,seconds:Math.floor(e/1e3%60),minutes:Math.floor(e/6e4%60),hours:Math.floor(e/36e5%24),days:Math.floor(e/864e5)};return e>=864e5?t.days+"d "+(t.hours?t.hours+"h":""):e>=36e5?t.hours+"h "+(t.minutes?t.minutes+"m":""):e>=6e4?t.minutes+"m "+(t.seconds?t.seconds+"s":""):e>=1e3?t.seconds+(t.milliseconds?"."+t.milliseconds+" s":" s"):t.milliseconds+" ms"},s=function(e){return"#"+e},a=function(a,c){t.loadingError=!1,t.noDataAvailable=!1,i||(t.isLoading=!0),function(a){var c=a.map(function(e){return e.id.toString()});return e.getBuildMetrics(c).then(function(e){var d;if(n=document.getElementById(t.componentId),e.data.length){e.data=e.data.filter(function(e){return!r(e.name).skip});for(var u={labels:c,datasets:e.data},p=new Array(c.length).fill(0),m=0;m<u.datasets.length;m++)for(var g=0;g<u.datasets[m].data.length;g++)p[g]+=u.datasets[m].data[g];for(var f=[],b=0;b<a.length;b++){var h=a[b].endTime-a[b].submitTime-p[b];f.push(h>0?h:0)}if(u.datasets.push({name:"OTHER",data:f}),t.metricsTooltip=u.datasets.map(function(e){return{label:(d=r(e.name)).label,description:d.description}}),"line"===t.chartType){for(var v=0;v<u.datasets.length;v++)d=r(u.datasets[v].name),Object.assign(u.datasets[v],{label:d.label,fill:!1,borderColor:d.color,borderWidth:4,pointBackgroundColor:d.color,pointBorderColor:"white",pointBorderWidth:1.5,pointRadius:4});o.options={maintainAspectRatio:!1,spanGaps:!1,scales:{x:{ticks:{callback:s}},y:{type:"logarithmic",ticks:{maxTicksLimit:8,beginAtZero:!0,callback:l},scaleLabel:{display:!0,labelString:"Logarithmic scale"}}}}}else if("horizontalBar"===t.chartType){for(var $=0;$<u.datasets.length;$++)d=r(u.datasets[$].name),Object.assign(u.datasets[$],{label:d.label,backgroundColor:d.color});o.options={tooltips:{position:"nearest"},animation:{duration:0},scales:{x:{position:"bottom",ticks:{min:0,maxTicksLimit:30,callback:l},stacked:!0,scaleLabel:{display:!0,labelString:"Linear scale"}},y:{ticks:{reverse:!1,callback:s},stacked:!0}}}}else console.warn("Unsupported chart type: "+t.chartType);var y=1===u.datasets[0].data.length;Object.assign(o.options,{layout:{padding:{top:20,bottom:20}},maintainAspectRatio:!1,tooltips:{callbacks:{title:function(e){return s(e[0].label)},label:function(e,t){var i=t.datasets[e.datasetIndex].label||"";return i&&(i+=": "+l(e.value)),"NaN"!==e.value&&e.value>1e3&&(i+="  ("+e.value+" ms)"),i}}}}),o.type=t.chartType,o.data=u,o.plugins=[{beforeInit:function(e){e.legend.afterFit=function(){this.height=this.height+25}}}];var C=0;if("horizontalBar"===t.chartType?(C=30*u.datasets[0].data.length,n.parentElement.style.height=(C<290?y?400:290:C)+"px",y&&(o.options.layout.padding.bottom=100)):n.parentElement.style.height="300px",i)i.update();else{var w=n.getContext("2d");i=new Chart(w,o)}}else t.noDataAvailable=!0})}(function(e,i,n){n=void 0!==n?n:t.BUILDS_DISPLAY_LIMIT;for(var o=[],r=0;r<e.length;r+=i)o.push(e[r]);if("line"===t.chartType)return o.slice(0,n).reverse();if("horizontalBar"===t.chartType)return o.slice(0,n)}(a,c)).catch(function(){t.loadingError=!0,t.noDataAvailable=!1}).finally(function(){t.isUpdating=!1,t.isLoading=!1})};t.$onInit=function(){t.navigationSelect=function(e){t.isUpdating=!0,a(t.builds,e.id)},a(t.builds,t.navigationSelected.id)}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncBuildStart",{bindings:{buildConfig:"<?",groupConfig:"<?",size:"@?"},templateUrl:"common/components/pnc-build-start/pnc-build-start.html",controller:["$log","BuildConfigResource","GroupConfigResource",function(e,t,i){const n=this;n.dropdownMenu=!1,n.rebuildModes=[{title:"Explicit",value:"EXPLICIT_DEPENDENCY_CHECK"},{title:"Implicit",value:"IMPLICIT_DEPENDENCY_CHECK"},{title:"Force",value:"FORCE"}],n.$onInit=function(){n.params={temporaryBuild:!1,rebuildMode:n.rebuildModes[1].value,timestampAlignment:!1},n.refreshRebuildModes(1),n.buildConfig&&(n.params.keepPodOnFailure=!1,n.params.buildDependencies=!0)},n.refreshBuildTypes=function(){n.params.temporaryBuild||(n.params.timestampAlignment=!1)},n.refreshRebuildModes=function(e){n.currentRebuildModeTitle=n.rebuildModes[e].title},n.build=function(){n.dropdownMenu=!1,n.buildConfig?(e.debug("pncBuildStart: Initiating build of: %O",n.buildConfig),n.params.id=n.buildConfig.id,t.build(n.params,{})):n.groupConfig&&(e.debug("pncBuildStart: Initiating build of: %O",n.groupConfig),n.params.id=n.groupConfig.id,i.build(n.params,{}))}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncBuildStatusIcon",{bindings:{build:"<",noWarnings:"@"},templateUrl:"common/components/pnc-build-status-icon/pnc-build-status-icon.html",controller:[function(){var e=this;e.isCorrupted=!1,e.isTemporary=!1,e.$onChanges=function(t){var i,n;t.build&&t.build.currentValue&&(e.isCorrupted=(i=t.build.currentValue,(n=i.attributes)&&("REPO_SYSTEM_ERROR"===n.POST_BUILD_REPO_VALIDATION||"DISABLED_FIREWALL"===n.PNC_SYSTEM_ERROR)),e.isTemporary=function(e){return e.temporaryBuild}(t.build.currentValue))}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncBuildStatus",{bindings:{build:"<?",groupBuild:"<?",isLoaded:"<",stopPropagation:"<"},templateUrl:"common/components/pnc-build-status/pnc-build-status.html",controller:["$scope",function(e){var t=this;function i(i){e.$applyAsync(()=>t.item=i)}t.$onInit=function(){t.item=t.build?t.build:t.groupBuild},t.$onChanges=function(e){e.build?i(t.build):e.groupBuild&&i(t.groupBuild)}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncCorruptedBuildLabel",{bindings:{build:"<"},templateUrl:"common/components/pnc-corrupted-build-label/pnc-corrupted-build-label.html",controller:[function(){var e=this;e.isCorrupted=function(){var t=e.build.attributes;return t&&("REPO_SYSTEM_ERROR"===t.POST_BUILD_REPO_VALIDATION||"DISABLED_FIREWALL"===t.PNC_SYSTEM_ERROR||t.BUILD_PROCESS_ISSUE||t.BLACKLIST_REASON||t.DELETE_REASON)}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncEnvironmentCombobox",{bindings:{modelProperty:"@modelValue"},require:{ngModel:"?ngModel"},templateUrl:"common/components/pnc-environment-combobox/pnc-environment-combobox.html",controller:["$log","$scope","$element","EnvironmentResource","utils","rsqlQuery","$timeout",function(e,t,i,n,o,r,l){var s,a,c=this;c.search=function(e){if(o.isEmpty(e))return s;return function(e){return n.query({q:a+r(!0).and().where("name").like("*"+e+"*").end()}).$promise.then(function(e){return e.data})}(e)},c.$onInit=function(){a=r().where("deprecated").eq(!1).end(),t.$watch(function(){return c.input},function(){c.ngModel.$setViewValue(c.input)}),c.ngModel.$parsers.push(function(e){return angular.isObject(e)&&angular.isDefined(c.modelProperty)?e[c.modelProperty]:e}),c.ngModel.$render=function(){!c.ngModel.$isEmpty(c.ngModel.$viewValue)&&angular.isDefined(c.modelProperty)&&e.warn("pnc-environment-combobox: programatic changing of the ng-model value is not fully supported when model-value parameter is used. The display value of the combobox will not be correctly mapped"),c.input=c.ngModel.$viewValue},s=n.query({pageSize:20,q:a}).$promise.then(function(e){return e.data})},c.$postLink=function(){l(function(){i.find("input").on("blur",function(){c.ngModel.$setTouched()})})},c.$onDestroy=function(){i.find("input").off("blur")}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncGlobalAlert",{bindings:{},templateUrl:"common/components/pnc-global-alert/pnc-global-alert.html",controller:["$q","$scope","events","GenericSetting",function(e,t,i,n){var o=this;o.isInMaintenanceMode=!1,o.message=null,o.$onInit=function(){var r=n.getAnnouncementBanner().then(function(e){return e.data}),l=n.inMaintenanceMode().then(function(e){return e.data});e.all([l,r]).then(function(e){let t=e[0],i=e[1];t?(o.isInMaintenanceMode=!0,o.message=i&&i.banner&&""!==i.banner?" Reason: "+e[1].banner:null):(o.isInMaintenanceMode=!1,o.message=null)}),t.$on(i.MAINTENANCE_MODE_ON,()=>{o.isInMaintenanceMode=!0,n.getAnnouncementBanner().then(function(e){o.message=e&&e.data.banner&&""!==e.data.banner?" Reason: "+e.data.banner:null})}),t.$on(i.MAINTENANCE_MODE_OFF,()=>{o.isInMaintenanceMode=!1,o.message=null})}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncGroupConfigStatusIcon",{bindings:{groupConfig:"<"},templateUrl:"common/components/pnc-group-config-status-icon/pnc-group-config-status-icon.html",controller:["$scope","events","GroupConfigResource",function(e,t,i){const n=this;n.$onInit=(()=>{n.isLoaded=!1,i.getLatestBuild({id:n.groupConfig.id}).$promise.then(e=>n.groupBuild=e).finally(()=>n.isLoaded=!0),e.$on(t.GROUP_BUILD_STATUS_CHANGED,(e,t)=>{n.groupConfig.id===t.groupConfig.id&&(n.groupBuild=t)})})}]})}(),function(){"use strict";angular.module("pnc.common.components").factory("notifyInline",[function(){var e={};function t(t){return function(i){var n,o,r,l,s;n=t,o=i.type,r=i.header,l=i.message,s=i.persistent,e[n](o,r,l,s)}}return t.registerComponent=function(t,i){e[t]=i},t}])}(),function(){"use strict";angular.module("pnc.common.components").component("pncInlineNotification",{bindings:{name:"@"},templateUrl:"common/components/pnc-inline-notification/pnc-inline-notification.html",controller:["$log","$scope","notifyInline",function(e,t,i){var n=this;function o(i,o,r,l){e.debug("Inline Notification: %O",arguments),t.$applyAsync(function(){n.notification.type=i,n.notification.header=o,n.notification.message=r,n.notification.persistent=l,n.notification.visible=!0})}n.notification={visible:!1,type:null,message:null,header:null,persistent:!1,remove:function(){n.notification.visible=!1}},n.$postLink=function(){i.registerComponent(n.name,o)}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncProductCombobox",{bindings:{modelProperty:"@modelValue"},require:{ngModel:"?ngModel"},templateUrl:"common/components/pnc-product-combobox/pnc-product-combobox.html",controller:["$log","$scope","$element","ProductResource","utils","rsqlQuery","$timeout",function(e,t,i,n,o,r,l){var s,a=this;a.search=function(e){if(o.isEmpty(e))return s;return function(e){var t=r().where("name").like("*"+e+"*").end();return n.query({q:t}).$promise.then(function(e){return e.data})}(e)},a.$onInit=function(){t.$watch(function(){return a.input},function(){a.ngModel.$setViewValue(a.input)}),a.ngModel.$parsers.push(function(e){return angular.isObject(e)&&angular.isDefined(a.modelProperty)?e[a.modelProperty]:e}),a.ngModel.$render=function(){!a.ngModel.$isEmpty(a.ngModel.$viewValue)&&angular.isDefined(a.modelProperty)&&e.warn("pnc-productg-combobox: programatic changing of the ng-model value is not fully supported when model-value parameter is used. The display value of the combobox will not be correctly mapped"),a.input=a.ngModel.$viewValue},s=n.query({pageSize:20}).$promise.then(function(e){return e.data})},a.$postLink=function(){l(function(){i.find("input").on("blur",function(){a.ngModel.$setTouched()})})},a.$onDestroy=function(){i.find("input").off("blur")}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncProductVersionCombobox",{bindings:{modelProperty:"@modelValue",product:"<"},require:{ngModel:"?ngModel"},templateUrl:"common/components/pnc-product-version-combobox/pnc-product-version-combobox.html",controller:["$log","$scope","$element","ProductResource","utils","rsqlQuery","$timeout",function(e,t,i,n,o,r,l){var s,a=this;a.search=function(e){if(o.isEmpty(e))return s;return function(e){let t=r().where("version").like("*"+e+"*").end();return n.queryProductVersions({id:a.product.id,q:t}).$promise.then(function(e){return e.data})}(e)},a.generateLabel=function(e){var t="";if(!e)return t;return t="v"+e.version},a.showNoVersionScript=!1,a.versionListLength=0,a.$onInit=function(){t.$watch(function(){return a.input},function(){a.ngModel.$setViewValue(a.input)}),a.ngModel.$parsers.push(function(e){return angular.isObject(e)&&angular.isDefined(a.modelProperty)?e[a.modelProperty]:e}),a.ngModel.$render=function(){!a.ngModel.$isEmpty(a.ngModel.$viewValue)&&angular.isDefined(a.modelProperty)&&e.warn("pnc-product-version-combobox: programatic changing of the ng-model value is not fully supported when model-value parameter is used. The display value of the combobox will not be correctly mapped"),a.input=a.ngModel.$viewValue},s=n.queryProductVersions({id:a.product.id}).$promise.then(function(e){return a.versionListLength=e.data.length,a.showNoVersionScript=0===e.data.length,e.data})},a.$postLink=function(){l(function(){i.find("input").on("blur",function(){a.ngModel.$setTouched()})})},a.$onDestroy=function(){i.find("input").off("blur")}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncProjectTypeahead",{bindings:{onSelect:"&",input:"=?ngModel"},require:{ngModel:"?ngModel"},templateUrl:"common/components/pnc-project-typeahead/pnc-project-typeahead.html",controller:["$scope","ProjectResource","rsqlQuery",function(e,t,i){var n=this;n.search=function(e){var n;return n=i().where("name").like(e+"%").end(),t.query({q:n}).$promise.then(function(e){return e.data})},n.select=function(e){n.onSelect()(e)},n.setDirty=function(){n.ngModel&&n.ngModel.$setDirty()},n.setTouched=function(){n.ngModel&&n.ngModel.$setTouched()},n.$onInit=function(){n.ngModel&&(n.ngModel.$validators.isValidProject=function(e,t){return!t||angular.isObject(e)&&e.id})}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncScmRepositoryCombobox",{bindings:{modelProperty:"@modelValue"},require:{ngModel:"?ngModel"},templateUrl:"common/components/pnc-scm-repository-combobox/pnc-scm-repository-combobox.html",controller:["$log","$scope","$element","ScmRepositoryResource","utils","rsqlQuery","$timeout",function(e,t,i,n,o,r,l){var s,a=this;a.search=function(e){if(o.isEmpty(e))return s;return function(e){var t=r().where("internalUrl").like("*"+e+"*").or().where("externalUrl").like("*"+e+"*").end();return n.query({q:t}).$promise.then(function(e){return e.data})}(e)},a.generateLabel=function(e){var t="";if(!e)return t;t+=e.internalUrl,e.externalUrl&&(t+="\n\t",t+="(external url: "+e.externalUrl+" )");return t},a.$onInit=function(){t.$watch(function(){return a.input},function(){a.ngModel.$setViewValue(a.input)}),a.ngModel.$parsers.push(function(e){return angular.isObject(e)&&angular.isDefined(a.modelProperty)?e[a.modelProperty]:e}),a.ngModel.$render=function(){!a.ngModel.$isEmpty(a.ngModel.$viewValue)&&angular.isDefined(a.modelProperty)&&e.warn("pnc-scm-repository-combobox: programatic changing of the ng-model value is not fully supported when model-value parameter is used. The display value of the combobox will not be correctly mapped"),a.input=a.ngModel.$viewValue},a.ngModel.$formatters.push(function(e){if(angular.isObject(e))return e}),s=n.query({pageSize:200}).$promise.then(function(e){return e.data})},a.$postLink=function(){l(function(){i.find("input").on("blur",function(){a.ngModel.$setTouched()})})},a.$onDestroy=function(){i.find("input").off("blur")}}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncServiceNotification",{templateUrl:"common/components/pnc-service-notification/pnc-service-notification.html",controller:[function(){}]})}(),function(){"use strict";angular.module("pnc.common.components").component("pncTemporaryBuildLabel",{bindings:{build:"<?",groupBuild:"<?"},templateUrl:"common/components/pnc-temporary-build-label/pnc-temporary-build-label.html",controller:[function(){var e,t=this;function i(){return e.temporaryBuild}t.$onInit=function(){e=t.build?t.build:t.groupBuild,t.isTemporary=i}}]})}(),function(){"use strict";var e=" | Project Newcastle",t="Project Newcastle";angular.module("pnc.common.components").directive("pncTitleGenerator",["$q","$transitions","$interpolate",function(i,n,o){return{restrict:"A",link:function(i,r){if("TITLE"!==r[0].tagName)throw new Error("pnc-title-generator directive can only be attached to the <title> tag");function l(e){r[0].textContent=e}n.onSuccess({},function(i){var n=i.to().data.title;if(angular.isString(n)){var r={};i.getResolveTokens().forEach(function(e){r[e]=i.injector().get(e)}),l(o(n)(r)+e)}else l(t)})}}}])}(),function(){"use strict";angular.module("pnc.common.components").component("pncToolbar",{bindings:{filteringPage:"<",filteringFields:"<",sortingFields:"<",sortingConfigs:"<",actionsConfig:"<?"},templateUrl:"common/components/pnc-toolbar/pnc-toolbar.html",controller:["pfFilterAdaptor",function(e){var t=this;t.pfToolbarConfig=null,t.$onInit=(()=>{t.adaptor=e(t.filteringPage),t.pfToolbarConfig={isTableView:!0,filterConfig:{fields:t.filteringFields,showTotalCountResults:!1,appliedFilters:[],onFilterChange:t.adaptor.onFilterChange}},t.sortingFields&&(t.pfToolbarConfig.sortConfig={fields:t.sortingFields,onSortChange:t.adaptor.onSortChange,currentField:t.sortingConfigs.field,isAscending:t.sortingConfigs.asc}),t.actionsConfig&&(t.pfToolbarConfig.actionsConfig=t.actionsConfig)})}]})}(),function(){"use strict";angular.module("pnc.common.da-client").provider("daConfig",function(){var e;this.setDaUrl=function(t){e=t},this.$get=function(){var t={getDaUrl:function(){return e}};return t}})}(),function(){"use strict";var e=angular.module("pnc.common.da-client");e.config(["jsonrpcProvider",function(e){e.interceptors.push("loadingBarInterceptor")}]),e.provider("jsonrpc",function(){this.interceptors=[],this.$get=["$injector","$log","$q","$websocket",function(e,t,i,n){var o=this,r="2.0",l="request_";return{wsClient:function(s){var a,c={},d={};function u(n){var r,s=i.defer();return n.id=_.uniqueId(l),d[n.id]=s,(r=n,c.connect().then(function(){return a.send(r)})).catch(function(){s.reject({code:0,message:"Error connecting to server"})}),t.debug("Making RPC request: "+JSON.stringify(n,null,2)),o.interceptors.forEach(function(t){try{e.get(t).requestStarted(s.promise)}catch(e){throw"Invalid interceptor ("+t+")."}}),s.promise}return c.connect=function(){if(c.isConnected())return i.when();var e=i.defer();return t.debug("Attempting to connect to WebSocket at: "+s),(a=n(s,null,{reconnectIfNotNormalClose:!0})).onMessage(function(e){!function(e){if(t.debug("Received RPC response: "+JSON.stringify(e,null,2)),!d.hasOwnProperty(e.id))throw new Error("Illegal State: Received JSON-RPC response with unknown id: "+e.id);var i=d[e.id];e.hasOwnProperty("error")?i.reject(e.error):i.resolve(e.result)}(JSON.parse(e.data))}),a.onOpen(function(){t.debug("Connected to WebSocket at: "+a.socket.url),e.resolve()}),a.onError(function(){t.error("Error with WebSocket connection to: "+a.socket.url),e.reject()}),a.onClose(function(){t.debug("Disconnected from WebSocket at: "+a.socket.url)}),e.promise},c.disconnect=function(e){a.close(e)},c.isConnected=function(){return!_.isUndefined(a)&&1===a.readyState},c.invoke=function(e,t){return u({jsonrpc:r,method:e,params:t})},c}}}]})}(),function(){"use strict";angular.module("pnc.common.da-client").factory("loadingBarInterceptor",["cfpLoadingBar",function(e){return{requestStarted:function(t){e.start(),t.finally(function(){e.complete()})}}}])}(),function(){"use strict";angular.module("pnc.common.directives").directive("pncConfirmClick",["$uibModal",function(e){return{restrict:"A",link:function(t,i,n){i.bind("click",function(){var i=n.pncConfirmMessage||"Are you sure?",o=n.pncConfirmSkip||"false";t.$eval(o)?t.$evalAsync(n.pncConfirmClick):e.open({templateUrl:"common/directives/pnc-confirm-click/pnc-confirm-click.html",controller:["$scope","message",function(e,i){e.message=i,e.confirm=function(){e.$close(),t.$evalAsync(n.pncConfirmClick)},e.cancel=function(){e.$dismiss(),t.$evalAsync(n.pncCancelClick)}}],resolve:{message:function(){return i}}}).result.then(function(){},function(){})})}}}])}(),function(){"use strict";angular.module("pnc.common.directives").directive("pncHeader",function(){return{restrict:"E",templateUrl:"common/directives/pnc-header/pnc-header.html",transclude:!0,link:function(e,t,i,n,o){var r=angular.isDefined(i.subHeader);o(e.$new(),function(e){t.find(".header-title").append(e.filter("pnc-header-title"))}),o(e.$new(),function(e){t.find(".btn-toolbar").append(e.filter("pnc-header-buttons")),t.find("pnc-header-buttons").addClass("btn-group"),t.find("pnc-header-buttons").find("button").removeClass("btn-lg btn-sm").addClass("btn-lg")}),r&&(t.find("h1").replaceWith(function(){return"<h3>"+angular.element(this).html()+"</h3>"}),t.find("pnc-header-buttons").find("button").removeClass("btn-lg btn-sm").addClass("btn"))}}})}(),function(){"use strict";angular.module("pnc.common.directives").directive("pncInfiniteSelectItems",function(){return{restrict:"E",scope:{singleItem:"@",selectedItems:"=",displayProperty:"@",additionalDisplayItemsById:"=",items:"=",itemId:"=",placeholder:"@",infiniteSelectId:"@",infiniteSelectRequired:"@"},templateUrl:"common/directives/pnc-infinite-select-items/pnc-infinite-select-items.html",controller:["$log","$scope",function(e,t){var i=function(e,t){for(var i=0;i<t.length;i++)if(angular.equals(e.id,t[i].id))return i;return-1};t.placeholder=_.isUndefined(t.placeholder)?"Scroll & Filter":t.placeholder,t.infiniteSelectRequired=!_.isUndefined(t.infiniteSelectRequired)&&t.infiniteSelectRequired,t.singleItem=function(e){if(_.isUndefined(e)||"true"!==e)return"false";return"true"}(t.singleItem);t.displayProperty=_.isUndefined(t.displayProperty)?"name":t.displayProperty,"true"!==t.singleItem||_.isUndefined(t.selectedItems)||_.isEmpty(t.selectedItems)||(t.itemId=t.selectedItems[0].id,t.searchText=t.selectedItems[0][t.displayProperty]),t.removeItem=function(e){var n=i(e,t.selectedItems);n>=0&&(t.selectedItems.splice(n,1),"true"===t.singleItem&&(t.itemId=void 0,t.searchText=void 0))},t.shouldShowList=function(){return t.selectedItems&&t.selectedItems.length>0},t.shouldShowSelection=function(){return!("true"===t.singleItem&&t.shouldShowList())},t.loadOptions=function(){t.searchText||t.items.loadMore()},t.selectItem=function(e){"false"===t.singleItem?(t.itemId=void 0,t.searchText=void 0):(t.itemId=e.id,t.searchText=e[t.displayProperty]),t.items.search(void 0),i(e,t.selectedItems)<0&&("true"===t.singleItem&&t.selectedItems.splice(0,t.selectedItems.length),t.selectedItems.push(e))},t.viewDropdown=function(e){t.isDropdown=e},t.search=_.throttle(function(){t.items.search(t.searchText)},1e3),t.$watch("itemId",function(e){_.isUndefined(e)&&(t.searchText=void 0)})}]}})}(),function(){"use strict";angular.module("pnc.common.directives").directive("pncInfiniteSelectProductVersions",function(){return{restrict:"E",scope:{singleItem:"@",selectedItems:"=",items:"=",itemId:"=",placeholder:"@",infiniteSelectId:"@",infiniteSelectRequired:"@"},templateUrl:"common/directives/pnc-infinite-select-product-versions/pnc-infinite-select-product-versions.html",controller:["$log","$scope",function(e,t){var i=function(e,t){for(var i=0;i<t.length;i++)if(angular.equals(e.id,t[i].id))return i;return-1};t.placeholder=_.isUndefined(t.placeholder)?"Scroll & Filter":t.placeholder,t.infiniteSelectRequired=!_.isUndefined(t.infiniteSelectRequired)&&t.infiniteSelectRequired,t.singleItem=function(e){if(_.isUndefined(e)||"true"!==e)return"false";return"true"}(t.singleItem),"true"!==t.singleItem||_.isUndefined(t.selectedItems)||_.isEmpty(t.selectedItems)||(t.itemId=t.selectedItems[0].id,t.searchText=t.selectedItems[0][t.displayProperty]),t.removeItem=function(e){var n=i(e,t.selectedItems);n>=0&&(t.selectedItems.splice(n,1),"true"===t.singleItem&&(t.itemId=void 0,t.searchText=void 0))},t.shouldShowList=function(){return t.selectedItems&&t.selectedItems.length>0},t.shouldShowSelection=function(){return!("true"===t.singleItem&&t.shouldShowList())},t.loadOptions=function(){t.searchText||t.items.loadMore()},t.selectItem=function(e){"false"===t.singleItem?(t.itemId=void 0,t.searchText=void 0):(t.itemId=e.id,t.searchText=e[t.displayProperty]),t.items.search(void 0),i(e,t.selectedItems)<0&&("true"===t.singleItem&&t.selectedItems.splice(0,t.selectedItems.length),t.selectedItems.push(e))},t.viewDropdown=function(e){t.isDropdown=e},t.search=_.throttle(function(){t.items.search(t.searchText)},1e3),t.$watch("itemId",function(e){_.isUndefined(e)&&(t.searchText=void 0)})}]}})}(),function(){"use strict";angular.module("pnc.common.directives").directive("pncInfiniteSelect",function(){return{restrict:"E",scope:{items:"=",itemId:"=",searchText:"@",placeholder:"@",infiniteSelectId:"@",infiniteSelectName:"@",infiniteSelectRequired:"@"},templateUrl:"common/directives/pnc-infinite-select/pnc-infinite-select.html",controller:["$log","$scope",function(e,t){t.placeholder=_.isUndefined(t.placeholder)?"Scroll & Filter":t.placeholder,t.infiniteSelectRequired=!_.isUndefined(t.infiniteSelectRequired)&&t.infiniteSelectRequired,t.loadOptions=function(){t.searchText||t.items.loadMore()},t.selectItem=function(e){t.itemId=e.id,t.searchText=e.name},t.viewDropdown=function(e){t.isDropdown=e},t.search=_.throttle(function(){t.items.search(t.searchText)},1500),t.$watch("itemId",function(e){_.isUndefined(e)&&(t.searchText=void 0)})}]}})}(),function(){"use strict";angular.module("pnc.common.directives").directive("pncLoadingPlaceholder",function(){return{restrict:"A",scope:{columns:"@",page:"="},templateUrl:"common/directives/pnc-loading-placeholder/pnc-loading-placeholder.html",controller:["$scope",function(e){e.columnsIterable=_.range(e.columns)}]}})}(),angular.module("pnc.common.directives").directive("pncMultipleInput",function(){return{restrict:"E",scope:{selectedItems:"=",placeholder:"@",selectId:"@",selectName:"@"},templateUrl:"common/directives/pnc-multiple-input/pnc-multiple-input.html",controller:["$log","$scope",function(e,t){t.removeItem=function(e){var i=function(e,t){for(var i=0;i<t.length;i++)if(e===t[i])return i;return-1}(e,t.selectedItems);i>=0&&t.selectedItems.splice(i,1)},t.shouldShowList=function(){return t.selectedItems&&t.selectedItems.length>0},t.selectItem=function(e){e&&-1===t.selectedItems.indexOf(e)&&(t.selectedItems.push(e),t.inputItem="")}}]}}),function(){"use strict";angular.module("pnc.common.directives").directive("pncRoleControl",["authService",function(e){return{restrict:"A",link:function(t,i,n){let o=n.role;null===o||function(t){let i=e.getUserRole();return null!==i&&i.includes(t)}(o)?i.removeClass("ng-hide"):i.addClass("ng-hide")}}}])}(),function(){"use strict";angular.module("pnc.common.directives").directive("pncSelectItems",["$parse",function(e){var t={};return{restrict:"E",scope:{singleItem:"@",customItem:"@",selectedItems:"=",items:"=",itemId:"=",placeholder:"@",selectId:"@",selectName:"@",selectRequired:"@",control:"="},templateUrl:"common/directives/pnc-select-items/pnc-select-items.html",link:function(i,n,o){(function(t,i){var n=e(t[i]);return _.isFunction(n.assign)})(o,"control")&&(i.control=t)},controller:["$log","$scope",function(e,i){var n=function(e,t){for(var i=0;i<t.length;i++)if(angular.equals(e.id,t[i].id))return i;return-1};i.placeholder=_.isUndefined(i.placeholder)?"Scroll & Filter":i.placeholder,i.selectRequired=!_.isUndefined(i.selectRequired)&&i.selectRequired,i.singleItem=_.isUndefined(i.singleItem)||"true"!==i.singleItem?"false":"true",i.displayProperty="fullDisplayText","true"!==i.singleItem||_.isUndefined(i.selectedItems)||_.isEmpty(i.selectedItems)||(i.itemId=i.selectedItems[0].id,i.searchText=i.selectedItems[0][i.displayProperty]),i.removeItem=function(e){var t=n(e,i.selectedItems);t>=0&&(i.selectedItems.splice(t,1),"true"===i.singleItem&&(i.itemId=void 0,i.searchText=void 0))},i.shouldShowList=function(){return i.selectedItems&&i.selectedItems.length>0},i.shouldShowSelection=function(){return!("true"===i.singleItem&&i.shouldShowList())},i.selectItem=function(e){"false"===i.singleItem?(i.itemId=void 0,i.searchText=void 0):(i.itemId=e.id,i.searchText=e[i.displayProperty]),n(e,i.selectedItems)<0&&("true"===i.singleItem&&i.selectedItems.splice(0,i.selectedItems.length),i.selectedItems.push(e))},i.saveCustomItem=function(e){if(e){var t={fullDisplayText:e};i.selectedItems.push(t),i.itemId=e,i.isDropdown=!1}},i.viewDropdown=function(e){i.searchText&&!i.selectedItems.length?i.isDropdown=!0:i.isDropdown=e},i.$watch("itemId",function(e){_.isUndefined(e)&&(i.searchText=void 0)}),t.reset=function(){i.selectedItems=[],i.itemId=void 0,i.searchText=void 0}}]}}])}(),function(){"use strict";angular.module("pnc.common.directives").directive("pncScmValidator",function(){return{restrict:"A",require:"ngModel",scope:{allowedProtocols:"@pncScmValidator",exactHost:"=pncExactHost"},link:function(e,t,i,n){n.$validators.invalidScmUrl=function(t){return!t||(i=e.allowedProtocols,n=e.exactHost,o=t,i=i.replace("git@","git@[\\w\\.]+").replace("git+ssh","git\\+ssh"),n=n&&n.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&"),new RegExp("^(?:"+i+"):(?:\\/\\/)?"+(n?n+"(\\/[\\w\\.:~_-]+)+\\.git":"[\\w\\.@:\\/~_-]+")+"(?:\\/?|\\#[\\d\\w\\.\\-_]+?)$").test(o));var i,n,o}}}})}(),function(){"use strict";angular.module("pnc.common.directives").directive("pncSelect",function(){return{scope:{selectedItems:"=",query:"&",displayProperty:"@",additionalDisplayItemsById:"=",placeholder:"@"},template:'<ul class="list-group" ng-show="shouldShow()"><li class="list-group-item" ng-repeat="item in selectedItems">{{ additionalDisplayItemsById[item.id] }} {{ item[displayProperty] }}<button type="button" class="close" aria-label="Close" ng-click="removeItem(item)"><span aria-hidden="true">×</span></button></li></ul><div><input type="text" ng-model="selectedItem" placeholder="{{ placeholder }}" typeahead="item as item[displayProperty] for item in query({$viewValue: $viewValue})" typeahead-editable="false" typeahead-loading="loadingLocations" class="form-control" typeahead-on-select="onSelect($item, $model, $label)" typeahead-wait-ms="200"><span ng-show="loadingLocations" class="spinner spinner-xs spinner-inline"></span></div>',controller:["$log","$scope",function(e,t){var i=function(e,t){for(var i=0;i<t.length;i++)if(angular.equals(e,t[i]))return i;return-1};t.removeItem=function(e){var n=i(e,t.selectedItems);n>=0&&t.selectedItems.splice(n,1)},t.onSelect=function(e){i(e,t.selectedItems)<0&&t.selectedItems.push(e),t.selectedItem=null},t.shouldShow=function(){return t.selectedItems&&t.selectedItems.length>0}}]}})}(),function(){"use strict";angular.module("pnc.common.events").constant("events",Object.freeze({BUILD_PENDING:"BUILD_PENDING",BUILD_IN_PROGRESS:"BUILD_IN_PROGRESS",BUILD_FINISHED:"BUILD_FINISHED",BUILD_PROGRESS_CHANGED:"BUILD_PROGRESS_CHANGED",BUILD_STATUS_CHANGED:"BUILD_STATUS_CHANGED",GROUP_BUILD_IN_PROGRESS:"GROUP_BUILD_IN_PROGRESS",GROUP_BUILD_FINISHED:"GROUP_BUILD_FINISHED",GROUP_BUILD_PROGRESS_CHANGED:"GROUP_BUILD_PROGRESS_CHANGED",GROUP_BUILD_STATUS_CHANGED:"GROUP_BUILD_STATUS_CHANGED",SCM_REPOSITORY_CREATION_SUCCESS:"SCM_REPOSITORY_CREATION_SUCCESS",NEW_ANNOUNCEMENT:"NEW_ANNOUNCEMENT",MAINTENANCE_MODE_ON:"MAINTENANCE_MODE_ON",MAINTENANCE_MODE_OFF:"MAINTENANCE_MODE_OFF",BUILD_PUSH_STATUS_CHANGE:"BUILD_PUSH_STATUS_CHANGE"}))}(),function(){"use strict";const e=Math.pow(2,10),t=["B","KiB","MiB","GiB","TiB"];angular.module("pnc.common.filters").filter("fileSize",[function(){return function(i){if(0===i)return"0 "+t[0];const n=Math.floor(Math.log(i)/Math.log(e),t.length);return 0===n?i+" "+t[n]:(i/Math.pow(e,n)).toFixed(2)+" "+t[n]}}])}(),angular.module("pnc.common.notifications").controller("pncDrawerNotificationController",["$scope","$log","pncNotify",function(e,t,i){e.groups=[{heading:"Events",open:!0,notifications:[]}],e.hideDrawer=!0,e.toggleShowDrawer=function(){e.hideDrawer=!e.hideDrawer,e.hideDrawer||(e.groups[0].notifications=i.drawerNotifications())},e.hasDrawerNotifications=function(){return 0!==i.drawerNotifications().length},e.markAllAsRead=function(e){e.notifications.forEach(function(e){e.unread=!1})},e.customScope={},e.customScope.getNotficationStatusIconClass=function(e){var t="";return e&&e.type&&("info"===e.type?t="pficon pficon-info":"danger"===e.type?t="pficon pficon-error-circle-o":"warning"===e.type?t="pficon pficon-warning-triangle-o":"success"===e.type&&(t="pficon pficon-ok")),t},e.customScope.markRead=function(e){e.unread=!1},e.customScope.clearAll=function(e){e.notifications=[],i.clearDrawerNotifications()}}]),angular.module("pnc.common.notifications").factory("pncNotify",["$log","Notifications",function(e,t){var i=[];function n(e,n,o,r,l,s=!1){e(n,"",s,void 0,o,r,l);var a=t.data.length-1,c=t.data[a];c.unread=!0,c.timeStamp=(new Date).getTime(),i.push(c)}return{info:function(e,i,o,r,l){n(t.info,e,i,o,r,l)},success:function(e,i,o,r,l){n(t.success,e,i,o,r,l)},error:function(e,i,o,r,l){n(t.error,e,i,o,r,l)},warn:function(e,i,o,r,l){n(t.warn,e,i,o,r,l)},toastNotifications:function(){return t.data},drawerNotifications:function(){return i},clearDrawerNotifications:function(){i=[]},remove:function(e){t.remove(e);var n=i.indexOf(e);n>-1&&(i[n].unread=!1)}}}]),function(){"use strict";angular.module("pnc.common.notifications").factory("pncNotifyUser",["pncNotify","authService",function(e,t){function i(i,n){return(...o)=>{t.forUserId(i).then(()=>e[n](...o),()=>{})}}return e=>{const t=angular.isDefined(e.id)?e.id:e;return{info:i(t,"info"),success:i(t,"success"),error:i(t,"error"),warn:i(t,"warn")}}}])}(),angular.module("pnc.common.notifications").controller("pncToastNotificationController",["$scope","pncNotify",function(e,t){e.notifications=t.toastNotifications(),e.handleClose=function(e){t.remove(e)}}]),function(){"use strict";angular.module("pnc.common.pnc-client.jobs").factory("buildConfigCreator",["$http","$q","restConfig","messageBus",function(e,t,i,n){const o=`${i.getPncRestUrl()}/build-configs/create-with-scm`;function r(e){let t={response:e};return e.status&&e.statusText&&(t.source="http",t.message=e.data.errorMessage),"BUILD_CONFIG_CREATION"===e.job&&(t.source="ws",t.message=e.data.message),t}return Object.freeze({createWithScm:function(i){!function(e){const t=[];if(angular.isString(e.scmUrl)||t.push("[scmUrl: string]"),angular.isObject(e.buildConfig)||t.push("[buildConfig: object]"),"boolean"!=typeof e.preBuildSyncEnabled&&t.push("[preBuildSyncEnabled: boolean]"),t.length>0)throw new TypeError(`buildConfigCreator.createWithScm() invoked without required params: ${t.join()}`)}(i);const l=t.defer();return e({method:"POST",url:o,data:i,successNotification:!1}).then(e=>{if(201!==e.status){if(202===e.status){const t=e.data.taskId;if(null===t)return void l.resolve(e.data);l.notify({job:"BUILD_CONFIG_CREATION",progress:"IN_PROGRESS",oldProgress:"PENDING",taskId:t});const i=n.onMessage(e=>{"BUILD_CONFIG_CREATION"===e.job&&e.taskId===t&&("FINISHED"===e.progress?("BC_CREATION_SUCCESS"===e.notificationType?l.resolve(e):l.reject(r(e)),i()):l.notify(e))})}}else l.resolve(e.data.buildConfig)},e=>{l.reject(r(e))}),l.promise}})}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.message-bus").factory("bccListener",["$log","$rootScope","pncEventAdaptor",function(e,t,i){return function(e){if(e.eventType&&e.eventType.startsWith("BCC_")){var n=i.convert(e);t.$broadcast(n.eventType,n.payload)}}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.message-bus").factory("bcListener",["$log","$rootScope","eventTypes",function(e,t,i){return function(e){e.eventType&&e.eventType.startsWith("BC_")&&t.$broadcast(i.BC_NOTIFICATION,e)}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.message-bus").factory("brewPushListener",["$rootScope","$state","pncNotify","BuildResource",function(e,t,i,n){return function(o){"BREW_PUSH_RESULT"===o.eventType&&(e.$broadcast("BREW_PUSH_RESULT",o),o.buildId&&n.get({id:o.buildId}).$promise.then(function(e){!function(e,n){function o(){t.go("projects.detail.build-configs.detail.builds.detail.brew-push",{buildId:e.id})}function r(e,t){i[e](t,"View Result",o)}switch(n){case"SUCCESS":r("success","Brew push completed for build: "+e.$canonicalName());break;case"FAILED":case"SYSTEM_ERROR":r("error","Brew push failed for build: "+e.$canonicalName());break;case"CANCELED":r("info","Brew push cancelled for build: "+e.$canonicalName())}}(e,o.status)}))}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.message-bus").factory("buildSetStatusListener",["$rootScope","pncNotify","authService","pncEventAdaptor","eventTypes",function(e,t,i,n,o){return function(r){if("BUILD_SET_STATUS_CHANGED"===r.eventType){var l=r.payload,s=n.convert(r);e.$broadcast(s.eventType,s.payload),e.$broadcast(o.BUILD_SET_STATUS_CHANGED,{id:r.payload.id,status:r.payload.buildStatus,userId:r.payload.userId,buildConfigurationSetId:r.payload.buildSetConfigurationId,buildConfigurationSetName:r.payload.buildSetConfigurationName,startTime:r.payload.buildSetStartTime,endTime:r.payload.buildSetEndTime}),i.forUserId(l.userId).then(function(){switch(l.buildStatus){case"REJECTED":t.warn("Build of group: "+l.buildSetConfigurationName+" was rejected: "+l.description)}})}}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.message-bus").factory("buildStatusListener",["$log","$rootScope","eventTypes","pncEventAdaptor",function(e,t,i,n){return function(e){if(e.eventType===i.BUILD_STATUS_CHANGED){var o=n.convert(e);t.$broadcast(o.eventType,o.payload),t.$broadcast(i.BUILD_STATUS_CHANGED,{id:e.payload.id,status:e.payload.buildCoordinationStatus,userId:e.payload.userId,buildConfigurationId:e.payload.buildConfigurationId,buildConfigurationName:e.payload.buildConfigurationName,startTime:e.payload.buildStartTime,endTime:e.payload.buildEndTime})}}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.message-bus").factory("processProgressUpdateListener",["$rootScope",function(e){return function(t){"PROCESS_PROGRESS_UPDATE"===t.eventType&&e.$broadcast("PROCESS_PROGRESS_UPDATE",t)}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.message-bus").factory("rcListener",["$log","$rootScope","eventTypes",function(e,t,i){return function(e){e.eventType&&e.eventType.startsWith("RC_")&&t.$broadcast(i.RC_BPM_NOTIFICATION,e)}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.message-bus").factory("messageBus",["restConfig","$rootScope","events","BuildResource","GroupBuildResource",function(e,t,i,n,o){const r=new PncJsLibs.MessageBus(e.getPncNotificationsUrl());function l(e){return(i,o)=>t.$broadcast(e,new n(i),o)}function s(e){return(i,n)=>t.$broadcast(e,new o(i),n)}return r.onBuildProgress("PENDING",l(i.BUILD_PENDING)),r.onBuildProgress("IN_PROGRESS",l(i.BUILD_IN_PROGRESS)),r.onBuildProgress("FINISHED",l(i.BUILD_FINISHED)),r.onBuildProgressChange(l(i.BUILD_PROGRESS_CHANGED)),r.onBuildStatusChange(l(i.BUILD_STATUS_CHANGED)),r.onGroupBuildProgress("IN_PROGRESS",s(i.GROUP_BUILD_IN_PROGRESS)),r.onGroupBuildProgress("FINISHED",s(i.GROUP_BUILD_FINISHED)),r.onGroupBuildProgressChange(s(i.GROUP_BUILD_PROGRESS_CHANGED)),r.onGroupBuildStatusChange(s(i.GROUP_BUILD_STATUS_CHANGED)),r.onGenericSettingMaintenanceChanged(e=>{if(e.message){JSON.parse(e.message).maintenanceModeEnabled?t.$broadcast(i.MAINTENANCE_MODE_ON):t.$broadcast(i.MAINTENANCE_MODE_OFF)}}),r.onScmRepositoryCreationSuccess(e=>{e.scmRepository&&t.$broadcast(i.SCM_REPOSITORY_CREATION_SUCCESS,e.scmRepository)}),r.onBuildPushStatusChange((e,n)=>{t.$broadcast(i.BUILD_PUSH_STATUS_CHANGE,e,n)}),r}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.pagination").directive("pncPageControls",function(){var e=[10,25,50,100,200];return{restrict:"EA",templateUrl:function(e,t){return t.pncTemplate||"common/pnc-client/pagination/directives/pnc-page-controls/pnc-page-controls.html"},scope:{page:"=pncPage"},bindToController:!0,controllerAs:"ctrl",controller:function(){var t=this;function i(){t.index=t.page.index+1,t.size=t.page.size,t.total=t.page.total}t.pageSizes=e,t.getPageIfExists=function(e){t.page.has(e-1)&&t.page.get(e-1)},t.$onInit=function(){t.page.onUpdate(function(){i()}),i()}}}})}(),function(){"use strict";angular.module("pnc.common.pnc-client.pagination").factory("filteringPaginator",["$log","page","paginator","rsqlQuery",function(e,t,i,n){var o="*";return function(e,t){var r=i(e),l=Object.create(r),s=[],a=null,c=t||[],d=null,u=[];function p(e){u.forEach(t=>{t(e)})}return l.fetch=function(e){return(e=e||{}).q=(t=n(),s.length>0&&s.filter(e=>"RSQL"===e.method).forEach(function(e){t.where||(t=t.and()),t=t.where(e.field)[e.comparator](e.value)}),!_.isEmpty(d)&&c.length>0&&(t.where||(t=t.and()),c.forEach(function(e){t.where||(t=t.or()),t=t.where(e).like(d)})),t.end?t.end():void 0),_.isEmpty(a)||(e.sort=a),s.filter(e=>"QUERY_PARAM"===e.method).forEach(t=>e[t.field]=t.value),r.fetch.call(this,e);var t},l.addFilter=function(e){if(_.isUndefined(e))throw new Error("Undefined argument passed to method addFilter");return _.isArray()?arguments.length>1&&(e=arguments):e=[e],e.forEach(function(e){if(!e.field||!e.value)throw new Error("Invalid filter, must contain properties `field` and `value`: "+JSON.stringify(e));e.comparator||(e.comparator="like"),e.method||(e.method="RSQL"),s.push(e)}),this},l.removeFilter=function(e){return s.splice(s.findIndex(function(t){return e.name===t.name&&e.value===t.value}),1),this},l.clearFilters=function(){return s=[],this},l.sortBy=function(e,t){return e&&e.id&&(a="="+(t?"desc":"asc")+"="+e.id),p({field:e,asc:!t}),this},l.clearSort=function(){return a=null,p(),this},l.addSortChangeListener=function(e){u.push(e)},l.apply=function(){return this.get(0)},l.search=function(e,t){return t&&(e=o+e+o),d=e,this.apply()},l.clearSearch=function(){return d=null,this.apply()},l}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.pagination").factory("page",["$log","$http",function(e,t){var i={};function n(e){e=e||{};var t=Object.create(i,{_config:{get:function(){return angular.copy(e.config)},set:function(t){e.config=angular.copy(t)}}});return t.data=e.data||[],t.index=e.index||0,t.size=e.size||0,t.total=e.total||1,t._Resource=e.Resource,t.$promise=e.promise,t}return i.forEach=function(e){this.data.forEach(function(){e.apply(this.data,arguments)},this)},i.fetch=function(i){e.debug("Fetching page: this=%O, params: %O",this,i);var o=this._Resource,r=this._config;r.params=i;var l=t(r).then(function(e){var t=n({index:e.data.pageIndex,size:e.data.pageSize,total:e.data.totalPages,data:e.data.content,Resource:o,config:e.config,$promise:l});if(o)for(var i=0;i<t.data.length;i++)t.data[i]=new o(t.data[i]);return t});return l},i.has=function(e){return e>=0&&e<this.total},i.get=function(e){var t;if(!this.has(e))throw new RangeError("Requested page index out of bounds: "+e);return(t=this._config.params||{}).pageIndex=e,this.fetch(t)},i.hasNext=function(){return this.has(this.index+1)},i.hasPrevious=function(){return this.has(this.index-1)},i.first=function(){return this.get(0)},i.last=function(){return this.get(this.total-1)},i.next=function(){return this.get(this.index+1)},i.previous=function(){return this.get(this.index-1)},i.refresh=function(){return this.get(this.index)},i.getWithNewSize=function(e){var t=this._config.params||{};return t.pageSize=e,t.pageIndex=0,this.fetch(t)},n}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.pagination").factory("paginator",["$rootScope",function(e){return function(t){var i=t,n=[],o=Object.create(Object.getPrototypeOf(t),{data:{get:function(){return i.data}},index:{get:function(){return i.index}},size:{get:function(){return i.size}},total:{get:function(){return i.total}},_config:{get:function(){return i._config}},_Resource:{get:function(){return i._Resource}}});return o.isLoaded=!1,o.fetch=function(t){return o.isLoaded=!1,i.fetch(t).then(function(t){e.$applyAsync(function(){i=t,o.isLoaded=!0,n.forEach(function(e){e(t)})})})},o.onUpdate=function(e){if(!_.isFunction(e))throw new TypeError("onUpdate expects a function");n.push(e)},i.$promise.then(function(){o.isLoaded=!0}),o}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.pagination").factory("pfFilterAdaptor",["PF_FILTER_TYPES",function(e){return function(t){var i={onFilterChange:function(i){const n=this.fields;t.clearFilters(),i.forEach(i=>{const o=n.find(e=>e.id===i.id);t.addFilter({field:i.id,value:i.value,comparator:e[o.filterType],method:o.filterMethod||"RSQL"})}),t.apply()},onSortChange:function(e,i){t.sortBy(e,!i),t.apply()},resultsCount:function(){return 1===t.total?t.data.length:t.total*t.size}};return i}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.pagination").constant("PF_FILTER_TYPES",Object.freeze({text:"like",select:"eq"}))}(),function(){"use strict";const e=angular.module("pnc.common.pnc-client.resources");e.value("ARTIFACT_PATH","/artifacts/:id"),e.factory("ArtifactResource",["$resource","restConfig","ARTIFACT_PATH",function(e,t,i){const n=t.getPncRestUrl()+i;return e(n,{id:"@id"},{query:{url:n,method:"GET",isPaged:!0}})}])}(),function(){"use strict";const e=angular.module("pnc.common.pnc-client.resources");e.value("BUILD_CONFIG_PATH","/build-configs/:id"),e.factory("BuildConfigResource",["$log","$resource","$http","restConfig","patchHelper","BUILD_CONFIG_PATH","BuildResource",(e,t,i,n,o,r,l)=>{const s=n.getPncRestUrl()+r,a=t(s,{id:"@id"},{query:{method:"GET",isPaged:!0},save:{method:"POST",successNotification:!1},update:{method:"PUT",successNotification:!1},delete:{method:"DELETE",successNotification:"Build Config successfully deleted"},clone:{method:"POST",url:s+"/clone",successNotification:"Build Config successfully cloned"},build:{method:"POST",url:s+"/build",successNotification:!1},getBuilds:{method:"GET",url:s+"/builds",isPaged:!0},getLatestBuild:{method:"GET",url:s+"/builds",params:{latest:!0},interceptor:{response:e=>new l(e.resource.content[0])}},getDependencies:{method:"GET",url:s+"/dependencies",isPaged:!0},removeDependency:{method:"DELETE",url:s+"/dependencies/:dependencyId"},getGroupConfigs:{method:"GET",url:s+"/group-configs",isPaged:!0},getDependants:{method:"GET",url:s+"/dependants",isPaged:!0},getRevisions:{method:"GET",url:s+"/revisions",isPaged:!0},getRevision:{method:"GET",url:s+"/revisions/:revisionId"},restoreRevision:{method:"POST",url:s+"/revisions/:revisionId/restore",successNotification:!1}});return a.getAlignmentParameters=function(e){return i.get(n.getPncRestUrl()+"/build-configs/default-alignment-parameters/"+e).then(function(e){return e.data.parameters})},a.safePatchRemovingParameters=function(t,i){let n=o.createJsonPatch(t,i,!1);return n=function(t,i,n){for(let e in t.parameters)if(!(e in i.parameters)){let t={op:"remove"};t.path="/parameters/"+e,n.push(t)}return e.debug("updatePatchRemovedParameters -> patch: %O",n),n}(t,i,n),a.patch({id:t.id},n)},a.getSupportedGenericParameters=function(){return i.get(n.getPncRestUrl()+"/build-configs/supported-parameters").then(function(e){return e.data})},o.assignPatchMethods(a),a}])}(),function(){"use strict";const e=angular.module("pnc.common.pnc-client.resources");e.value("BUILD_PATH","/builds/:id"),e.value("BUILD_SSH_CREDENTIALS_PATH","/builds/ssh-credentials/:id"),e.value("KAFKA_STORE_BUILDS","/builds"),e.factory("BuildResource",["$resource","$q","$http","restConfig","authService","BUILD_PATH","BUILD_SSH_CREDENTIALS_PATH","buildStatusHelper","ARTIFACT_PATH","BUILD_CONFIG_PATH","KAFKA_STORE_BUILDS",(e,t,i,n,o,r,l,s,a,c,d)=>{const u=n.getPncRestUrl()+r,p=n.getPncRestUrl()+l,m=n.getPncRestUrl()+a,g=n.getPncRestUrl()+c,f=n.getKafkaStoreUrl()+d,b=["NEW","ENQUEUED","WAITING_FOR_DEPENDENCIES","BUILDING"],h=e(u,{id:"@id"},{query:{method:"GET",isPaged:!0,url:u,params:{sort:"=desc=submitTime"}},getByConfiguration:{method:"GET",isPaged:!0,url:g+"/builds",params:{sort:"=desc=submitTime"}},getLatestByConfig:{method:"GET",url:g+"/builds",params:{latest:!0}},queryByUser:{method:"GET",isPaged:!0,url:u+"/?q=user.id==:userId"},getArtifactsDependencies:{isPaged:!0,method:"GET",url:u+"/artifacts/dependencies"},getDependencyGraph:{method:"GET",url:u+"/dependency-graph"},getBuiltArtifacts:{isPaged:!0,method:"GET",url:u+"/artifacts/built"},_getSshCredentials:{isPaged:!1,method:"GET",url:p},getLogBuild:{method:"GET",url:u+"/logs/build",cache:!0,transformResponse:function(e){return{payload:e}}},getLogAlign:{method:"GET",url:u+"/logs/align",cache:!0,transformResponse:function(e){return{payload:e}}},cancel:{method:"POST",url:u+"/cancel"},getBrewPushResult:{method:"GET",url:u+"/brew-push",error404Notification:!1,interceptor:{responseError:e=>{if(404===e.status)return t.when(null)}}},brewPush:{method:"POST",url:u+"/brew-push"},brewPushCancel:{method:"DELETE",url:u+"/brew-push"},getDependantBuilds:{method:"GET",url:m+"/dependant-builds",isPaged:!0},getRevision:{method:"GET",isPaged:!1,url:g+"/revisions/:revisionId"}});return h.getSshCredentials=(e=>o.isAuthenticated()?t.when(o.getPncUser()).then(i=>i.id===e.buildUser.id?h._getSshCredentials(e):(console.info("SSH Credentials: not available for current user"),t.when(null))):(console.info("SSH Credentials: user is not authenticated"),t.when(null))),h.getBuildMetrics=function(e){return i.post(f,{buildIds:e},{successNotification:!1})},h.prototype.$isSuccess=function(){return s.isSuccess(this)},h.prototype.$isCancelable=function(){return e=this.status,b.includes(e);var e},h.prototype.$canonicalName=function(){return(e=this).buildConfigRevision.name+"#"+e.id;var e},h.prototype.$buildLogUrl=function(){return e=this,u.replace(":id",e.id)+"/logs/build";var e},h.prototype.$alignLogUrl=function(){return e=this,u.replace(":id",e.id)+"/logs/align";var e},h.prototype.$scmArchive=function(){return e=this,u.replace(":id",e.id)+"/scm-archive";var e},h}])}(),function(){"use strict";var e=angular.module("pnc.common.pnc-client.resources");e.value("ENVIRONMENT_PATH","/environments/:id"),e.factory("EnvironmentResource",["$resource","restConfig","ENVIRONMENT_PATH",function(e,t,i){return e(t.getPncRestUrl()+i,{id:"@id"},{query:{method:"GET",isPaged:!0}})}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.resources").factory("GenericSetting",["$http","restConfig",function(e,t){var i=t.getPncRestUrl()+"/generic-setting";return{inMaintenanceMode:function(){return e.get(i+"/in-maintenance-mode")},activateMaintenanceMode:function(t){return e.post(i+"/activate-maintenance-mode",t)},deactivateMaintenanceMode:function(){return e.post(i+"/deactivate-maintenance-mode")},getAnnouncementBanner:function(){return e.get(i+"/announcement-banner")}}}])}(),function(){"use strict";const e=angular.module("pnc.common.pnc-client.resources");e.value("GROUP_BUILD_PATH","/group-builds/:id"),e.factory("GroupBuildResource",["$resource","restConfig","GROUP_BUILD_PATH","GROUP_CONFIG_PATH",(e,t,i,n)=>{const o=t.getPncRestUrl()+i,r=e(o,{id:"@id"},{query:{method:"GET",isPaged:!0},cancel:{method:"POST",url:o+"/cancel"},queryDependencyGraph:{method:"GET",url:o+"/dependency-graph"},queryBuilds:{method:"GET",url:o+"/builds",isPaged:!0},removeBuild:{method:"DELETE",successNotification:!1},brewPush:{method:"POST",url:o+"/brew-push",successNotification:!1},queryByUser:{method:"GET",isPaged:!0,url:o+"/?q=user.id==:userId"},getLatestByGroupConfig:{method:"GET",url:t.getPncRestUrl()+n+"/group-builds",params:{latest:!0}}});function l(e){return e.groupConfig.name+"#"+e.id}function s(e){return"SUCCESS"===e.status}r.prototype.$canonicalName=function(){return l(this)},r.canonicalName=l,r.prototype.$isSuccess=function(){return s(this)},r.isSuccess=s;const a=["NEW","ENQUEUED","WAITING_FOR_DEPENDENCIES","BUILDING"];return r.prototype.$isCancelable=function(){return e=this.status,a.includes(e);var e},r}])}(),function(){"use strict";const e=angular.module("pnc.common.pnc-client.resources");e.value("GROUP_CONFIG_PATH","/group-configs/:id"),e.factory("GroupConfigResource",["$resource","restConfig","GROUP_CONFIG_PATH","patchHelper",(e,t,i,n)=>{const o=t.getPncRestUrl()+i,r=e(o,{id:"@id"},{query:{method:"GET",isPaged:!0},save:{method:"POST",successNotification:!1},update:{method:"PUT",successNotification:!1},build:{method:"POST",url:o+"/build",successNotification:!1},queryGroupBuilds:{method:"GET",url:o+"/group-builds",isPaged:!0},queryBuildConfigs:{method:"GET",url:o+"/build-configs",isPaged:!0},addBuildConfig:{method:"POST",url:o+"build-configs",successNotification:!1},removeBuildConfig:{method:"DELETE",url:o+"/build-configs/:buildConfigId",successNotification:!1},queryBuilds:{method:"GET",url:o+"/builds"},getLatestBuild:{method:"GET",url:o+"/builds",params:{latest:!0}}});return n.assignPatchMethods(r),r.linkWithProductVersion=function(e,t){return r.safePatch(e,{productVersion:{id:t.id}}).$promise},r.unlinkFromProductVersion=function(e){return r.safePatch(e,{productVersion:null}).$promise},r}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.resources").factory("buildStatusHelper",[function(){var e="PENDING",t="IN_PROGRESS",i="FINISHED",n=Object.freeze({NEW:{progress:e,failed:!1},ENQUEUED:{progress:e,failed:!1},WAITING_FOR_DEPENDENCIES:{progress:e,failed:!1},BUILDING:{progress:t,failed:!1},BUILD_COMPLETED:{progress:t,failed:!1},DONE:{progress:i,failed:!1},REJECTED:{progress:i,failed:!0},REJECTED_FAILED_DEPENDENCIES:{progress:i,failed:!0},REJECTED_ALREADY_BUILT:{progress:i,failed:!1},SYSTEM_ERROR:{progress:i,failed:!0},FAILED:{progress:i,failed:!0},NO_REBUILD_REQUIRED:{progress:i,failed:!1},DONE_WITH_ERRORS:{progress:i,failed:!0},CANCELLED:{progress:i,failed:!0},SUCCESS:{progress:i,failed:!1}});function o(e){return angular.isString(e)?e:angular.isObject(e)?e.status:void console.error("Status was not recognized: "+e)}function r(e){var t=o(e);return n[t].failed}return Object.freeze({isPending:function(t){var i=o(t);return n[i].progress===e},isInProgress:function(e){var i=o(e);return n[i].progress===t},isFinished:function(e){var t=o(e);return n[t].progress===i},isFailed:r,isSuccess:function(e){return!r(e)}})}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.resources").factory("patchHelper",["$log","resourceHelper",function(e,t){const{normalize:i}=t;function n(t,n,o=!1){e.debug("createJsonPatch -> destructive: %s | original: %O | modified: %O",o,t,n);const r=i(t),l=i(n);let s;return s=o?jsonpatch.compare(r,l):jsonpatch.compare(r,_.merge({},r,l)),e.debug("createJsonPatch -> patch: %O",s),s}function o(e,t,i,o){const r=n(t,i,o);return e.patch({id:t.id},r)}return Object.freeze({assignPatchMethods:function(e){e.safePatch=function(t,i){return o(e,t,i,!1)},e.destructivePatch=function(t,i){return o(e,t,i,!0)},e.arrayPatch=function(t,i,o,r){return function(e,t,i,o,r){let l={[o]:{}},s={[o]:{}};for(const e of t.map(e=>e.id))l[o][e]={id:e};for(const e of i.map(e=>e.id))s[o][e]={id:e};let a=n(l,s,!0);return e.patch({id:r},a)}(e,t,i,o,r)}},createJsonPatch:n})}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.resources").factory("resourceHelper",[function(){function e(e){return e.hasOwnProperty("$promise")&&e.hasOwnProperty("$resolved")&&angular.isFunction(e.toJSON)}return Object.freeze({normalize:function(t){return e(t)?t.toJSON():t},isResource:e})}])}(),function(){"use strict";var e=angular.module("pnc.common.pnc-client.resources");e.value("PRODUCT_MILESTONES_PATH","/product-milestones/:id"),e.factory("ProductMilestoneResource",["$resource","restConfig","PRODUCT_MILESTONES_PATH","patchHelper",(e,t,i,n)=>{const o=t.getPncRestUrl()+i,r=e(o,{id:"@id"},{query:{method:"GET",isPaged:!0},save:{method:"POST",successNotification:"Product Milestone created"},update:{method:"PUT",successNotification:"Product Milestone updated"},queryPerformedBuilds:{method:"GET",url:o+"/builds",isPaged:!0},queryCloseResults:{method:"GET",url:o+"/close-results",isPaged:!0,params:{sort:"=desc=startingDate"}},getLatestCloseResult:{method:"GET",url:o+"/close-results?latest=true"},close:{method:"POST",url:o+"/close",successNotification:"Product Milestone close process started",interceptor:{response:e=>e.data}},validateVersion:{method:"POST",url:o+"/validate-version",successNotification:!1}});return n.assignPatchMethods(r),r}])}(),function(){"use strict";var e=angular.module("pnc.common.pnc-client.resources");e.value("PRODUCT_RELEASES_PATH","/product-releases/:id"),e.factory("ProductReleaseResource",["$resource","restConfig","PRODUCT_RELEASES_PATH","patchHelper",(e,t,i,n)=>{const o=t.getPncRestUrl()+i,r=e(o,{id:"@id"},{query:{method:"GET",isPaged:!0},save:{method:"POST",successNotification:"Product Release created"},update:{method:"PUT",successNotification:"Product Release updated"},querySupportLevels:{method:"GET",url:o+"/support-levels",isArray:!0}});return n.assignPatchMethods(r),r}])}(),function(){"use strict";var e=angular.module("pnc.common.pnc-client.resources");e.value("PRODUCTS_PATH","/products/:id"),e.factory("ProductResource",["$resource","restConfig","PRODUCTS_PATH","patchHelper",(e,t,i,n)=>{const o=t.getPncRestUrl()+i,r=e(o,{id:"@id"},{query:{method:"GET",isPaged:!0},save:{method:"POST",successNotification:"Product created"},update:{method:"PUT"},queryProductVersions:{url:o+"/versions",method:"GET",isPaged:!0}});return n.assignPatchMethods(r),r}])}(),function(){"use strict";var e=angular.module("pnc.common.pnc-client.resources");e.value("PRODUCT_VERSIONS_PATH","/product-versions/:id"),e.factory("ProductVersionResource",["$resource","restConfig","PRODUCT_VERSIONS_PATH","patchHelper",(e,t,i,n)=>{const o=t.getPncRestUrl()+i,r=e(o,{id:"@id"},{save:{method:"POST",successNotification:"Product Version created"},update:{method:"PUT",successNotification:"Product Version updated"},queryBuildConfigs:{method:"GET",url:o+"/build-configs",isPaged:!0},queryGroupConfigs:{method:"GET",url:o+"/group-configs",isPaged:!0},queryMilestones:{method:"GET",url:o+"/milestones",isPaged:!0},queryReleases:{method:"GET",url:o+"/releases",isPaged:!0}});return n.assignPatchMethods(r),r}])}(),function(){"use strict";var e=angular.module("pnc.common.pnc-client.resources");e.value("PROJECT_PATH","/projects/:id"),e.factory("ProjectResource",["$resource","restConfig","PROJECT_PATH",function(e,t,i){var n=t.getPncRestUrl()+i;return e(n,{id:"@id"},{query:{method:"GET",isPaged:!0},update:{method:"PUT"},queryBuildConfigurations:{method:"GET",url:n+"/build-configs",isPaged:!0}})}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.resources").factory("ReportResource",["$http","restConfig",function(e,t){var i=t.getDaUrl(),n={getBlacklistedArtifactsInProject:function(t,n,o,r){return e.post(i+"/reports/align",{products:[],searchUnknownProducts:!1,scmUrl:t,revision:n,pomPath:o,additionalRepos:r}).then(function(e){return e.data.blacklisted})},getBuiltArtifactsInProject:function(t,n,o,r){return e.post(i+"/reports/built",{scmUrl:t,revision:n,pomPath:o,additionalRepos:r}).then(function(e){return e.data})}};return n}])}(),function(){"use strict";var e=angular.module("pnc.common.pnc-client.resources");e.value("SCM_REPOSITORY_PATH","/scm-repositories/:id"),e.factory("ScmRepositoryResource",["$resource","$http","restConfig","SCM_REPOSITORY_PATH",function(e,t,i,n){var o=i.getPncRestUrl()+n,r=e(o,{id:"@id"},{query:{method:"GET",isPaged:!0},get:{method:"GET"},update:{method:"PUT",transformRequest:function(e){return""===e.externalUrl&&(e.externalUrl=null),angular.toJson(e)}},queryBuildConfigs:{method:"GET",url:o+"/build-configs",isPaged:!0}});return r.prototype.getName=function(){return this.internalUrl.split("/").splice(3).join("/")},r.createAndSync=function(e){return t.post(i.getPncRestUrl()+"/scm-repositories/create-and-sync",e)},r}])}(),function(){"use strict";var e=angular.module("pnc.common.pnc-client.resources");e.value("USER_PATH","/users/:id"),e.factory("UserResource",["$resource","restConfig","USER_PATH",function(e,t,i){return e(t.getPncRestUrl()+i,{id:"@id"},{getAuthenticatedUser:{method:"GET",url:t.getPncRestUrl()+"/users/current",isArray:!1,cache:!0,successNotification:!1}})}])}(),function(){"use strict";angular.module("pnc.common.pnc-client").provider("restConfig",function(){var e,t,i="/pnc-rest/v2",n="ws://"+window.location.host+"/pnc-rest/notifications";this.setPncRestUrl=function(e){i=e},this.setPncNotificationsUrl=function(e){n=e},this.setDaUrl=function(t){e=t},this.setKafkaStoreUrl=function(e){t=e},this.$get=function(){var o={getPncRestUrl:function(){return i},getPncNotificationsUrl:function(){return n},getDaUrl:function(){return e},getKafkaStoreUrl:function(){return t}};return o}})}(),function(){"use strict";angular.module("pnc.common.pnc-client.rsql").factory("comparator",[function(){return function(e){var t={eq:function(t){return e.addToQuery("=="+t),e.next()},neq:function(t){return e.addToQuery("!="+t),e.next()},lt:function(t){return e.addToQuery("=lt="+t),e.next()},le:function(t){return e.addToQuery("=le="+t),e.next()},gt:function(t){return e.addToQuery("=gt="+t),e.next()},ge:function(t){return e.addToQuery("=ge="+t),e.next()},like:function(t){return t=(t=t.replace(/\*/g,"%")).replace(/\?/g,"_"),e.addToQuery('=like="'+t+'"'),e.next()},isNull:function(){return e.addToQuery("=isnull=true"),e.next()},isNotNull:function(){return e.addToQuery("=isnull=false"),e.next()},in:function(t){return 0===t.length?e.abandonClause():e.addToQuery("=in=("+t.join(",")+")"),e.next()},out:function(t){return 0===t.length?e.abandonClause():e.addToQuery("=out=("+t.join(",")+")"),e.next()}};return t}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.rsql").factory("context",["selector","comparator","operator",function(e,t,i){return function(n){var o={},r=[],l={selector:function(){return this.next=this.comparator,e(o)},comparator:function(){return this.next=this.operator,t(o)},operator:function(){return this.next=this.selector,i(o)}};return l.next=n?l.operator.bind(l):l.selector.bind(l),o.addToQuery=function(e){r.push(e)},o.popFromQuery=function(){return r.pop()},o.abandonClause=function(){var e;do{e=r.pop()}while(angular.isDefined(e)&&","!==e&&";"!==e)},o.next=function(){return l.next()},o.jumpTo=function(e){if(!l.hasOwnProperty(e))throw new Error("Cannot jump to non-existant node: "+e);return l[e]()},o.end=function(){return r.join("")},o}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.rsql").factory("operator",[function(){return function(e){var t={and:function(){return e.addToQuery(";"),e.next()},or:function(){return e.addToQuery(","),e.next()},end:function(){return e.end()}};return t}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.rsql").factory("rsqlQuery",["context",function(e){return function(t){return e(t).next()}}])}(),function(){"use strict";angular.module("pnc.common.pnc-client.rsql").factory("selector",[function(){return function(e){var t={where:function(t){return e.addToQuery(t),e.next()},brackets:function(t){return e.addToQuery("("+t+")"),e.jumpTo("operator")}};return t}}])}(),angular.module("pnc-ui-extras",["pnc-ui-extras.templates","pnc-ui-extras.combobox","pnc-ui-extras.uiBreadcrumbs"]),angular.module("pnc-ui-extras.templates",[]),angular.module("pnc-ui-extras.combobox",["pnc-ui-extras.templates"]);var _createClass=function(){function e(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}return function(t,i,n){return i&&e(t.prototype,i),n&&e(t,n),t}}();function _classCallCheck(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}var ComboboxController=function(){function e(t,i,n,o){_classCallCheck(this,e),this.$log=t,this.$scope=i,this.$element=n,this.$timeout=o,this.options=[],this.showDropDown=!1,this.modelOptions={}}return _createClass(e,[{key:"$onInit",value:function(){var e=this;if(!this.optionTemplateUrl){this.optionTemplateUrl="pnc-ui-extras/combobox/combobox-option.template.html"}if(this.ngModel){var t=!0===this.editable||"true"===this.editable;this.ngModel.$parsers.push(function(i){var n=e.getOptionFromViewValue(i);return angular.isDefined(n)?e.getModelValue(n):t?i:void 0}),this.ngModel.$validators.isValidOption=function(i,n){return angular.isDefined(e.getOptionFromModelValue(i))||t},this.ngModel.$render=function(){return e.inputModel=e.ngModel.$viewValue},this.ngModel.$formatters.push(function(i){var n=e.getViewValue(i);if(angular.isDefined(n))return n;var o=e.getOptionFromModelValue(i);return angular.isDefined(o)?e.getViewValue(o):t?i:void 0}),this.$scope.$watch(function(){return e.inputModel},function(){e.ngModel.$setViewValue(e.inputModel),e.loadOptions(e.inputModel)}),this.debounceMs&&(this.modelOptions.debounce=parseInt(this.debounceMs))}else this.loadOptions()}},{key:"$postLink",value:function(){var e=this;this.ngModel&&this.$timeout(function(){e.$element.find("input").on("blur",function(){e.$scope.$applyAsync(function(){return e.ngModel.$setTouched()})})})}},{key:"$onDestroy",value:function(){this.ngModel&&this.$element.find("input").off("blur")}},{key:"loadOptions",value:function(e){var t=this;return this.pxExpression.getOptions(e).then(function(e){return t.$log.debug("ComboboxController::loadOptions() scopeId = %d | options = %O",t.$scope.$id,e),t.$scope.$applyAsync(function(){return t.options=e}),e})}},{key:"getViewValue",value:function(e){return this.pxExpression.getViewValue(e)}},{key:"getModelValue",value:function(e){return this.pxExpression.getModelValue(e)}},{key:"getOptionFromViewValue",value:function(e){var t=this;if(angular.isArray(this.options))return this.options.find(function(i){return t.getViewValue(i)===e})}},{key:"getOptionFromModelValue",value:function(e){var t=this;if(angular.isArray(this.options))return this.getViewValue(e)?e:this.options.find(function(i){return t.getModelValue(i)===e})}},{key:"setShowDropDown",value:function(e){var t=this;this.$scope.$applyAsync(function(){return t.showDropDown=e}),e||(this.highlighted=void 0)}},{key:"openDropDown",value:function(){this.setShowDropDown(!0)}},{key:"closeDropDown",value:function(){this.setShowDropDown(!1)}},{key:"toggleDropDown",value:function(){this.setShowDropDown(!this.showDropDown)}},{key:"select",value:function(e){this.inputModel=this.getViewValue(e),this.closeDropDown()}},{key:"clear",value:function(){this.inputModel=void 0,this.closeDropDown()}},{key:"setHighlighted",value:function(e){this.highlighted=e}},{key:"isHighlighted",value:function(e){return this.highlighted===e}},{key:"highlightNext",value:function(){if(this.showDropDown&&this.options&&!(this.options.length<1))if(angular.isUndefined(this.highlighted))this.setHighlighted(0);else{if(this.highlighted===this.options.length-1)return;this.setHighlighted(this.highlighted+1)}}},{key:"highlightPrevious",value:function(){!this.showDropDown||!this.options||this.options.length<1||angular.isUndefined(this.highlighted)||0===this.highlighted||this.setHighlighted(this.highlighted-1)}},{key:"onKey",value:function(e){switch(e.stopPropagation(),e.preventDefault(),e.key){case"ArrowDown":this.showDropDown?this.highlightNext():this.openDropDown();break;case"ArrowUp":this.highlightPrevious();break;case"Enter":this.select(this.options[this.highlighted]);break;case"Escape":this.closeDropDown()}}}]),e}();ComboboxController.$inject=["$log","$scope","$element","$timeout"];var pxCombobox={templateUrl:"pnc-ui-extras/combobox/combobox.template.html",controller:ComboboxController,require:{pxExpression:"?pxExpression",ngModel:"?ngModel"},bindings:{placeholder:"@",editable:"<",debounceMs:"@",optionTemplateUrl:"@"}};angular.module("pnc-ui-extras.combobox").component("pxCombobox",pxCombobox);var pxExpressionParser=function(e){var t=/^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w\d]*))\s+in\s+([\s\S]+?)$/;return{parse:function(i){var n=i.match(t);if(!n)throw new Error('Expected typeahead specification in form of "_modelValue_ (as _label_)? for _item_ in _collection_" but got "'+i+'".');return{itemName:n[3],source:e(n[4]),viewMapper:e(n[2]||n[1]),modelMapper:e(n[1])}}}};pxExpressionParser.$inject=["$parse"],angular.module("pnc-ui-extras.combobox").factory("pxExpressionParser",pxExpressionParser);_createClass=function(){function e(e,t){for(var i=0;i<t.length;i++){var n=t[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}return function(t,i,n){return i&&e(t.prototype,i),n&&e(t,n),t}}();function _classCallCheck(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}var PxExpressionController=function(){function e(t,i,n,o,r){_classCallCheck(this,e),this.$log=t,this.$q=i,this.$scope=n,this.$attrs=o,this.pxExpressionParser=r,this.parsed=r.parse(o.pxExpression),this.$log.debug("PxExpressionController::constructor() with scope id = "+n.$id),this.$log.debug("px-expression = "+o.pxExpression,n)}return _createClass(e,[{key:"getViewValue",value:function(e){var t={};return t[this.parsed.itemName]=e,this.parsed.viewMapper(this.$scope,t)}},{key:"getModelValue",value:function(e){var t={};return t[this.parsed.itemName]=e,this.parsed.modelMapper(this.$scope,t)}},{key:"getOptions",value:function(e){return this.$q.when(this.parsed.source(this.$scope,{$viewValue:e}))}}]),e}();PxExpressionController.$inject=["$log","$q","$scope","$attrs","pxExpressionParser"];var pxExpression=function(){return{restrict:"A",scope:!1,controller:PxExpressionController}};angular.module("pnc-ui-extras.combobox").directive("pxExpression",pxExpression),function(){var e;try{e=angular.module("pnc-ui-extras.uiBreadcrumbs")}catch(t){e=angular.module("pnc-ui-extras.uiBreadcrumbs",["ui.router"])}e.directive("uiBreadcrumbs",["$interpolate","$state","$transitions",function(e,t,i){return{restrict:"E",templateUrl:function(e,t){return t.templateUrl||"pnc-ui-extras/ui-breadcrumbs/uiBreadcrumbs.tpl.html"},scope:{displaynameProperty:"@",abstractProxyProperty:"@?"},link:function(n){var o;function r(){for(var e,i,o=[],r=t.$current;r&&""!==r.name;)(e=l(r))&&(!1===(i=s(e))||c(e,o)||o.push({displayName:i,route:e.name})),r=r.parent;o.reverse(),n.breadcrumbs=o}function l(e){var i,o=e;return!0===e.abstract&&(void 0!==n.abstractProxyProperty&&(i=a(n.abstractProxyProperty,e))?(o=angular.copy(t.get(i)))&&(o.locals=e.locals):o=!1),o}function s(t){var i,r;return n.displaynameProperty?!1!==(r=a(n.displaynameProperty,t))&&(void 0===r?t.name:(i={},o.getResolveTokens().forEach(function(e){angular.isString(e)&&!e.startsWith("$")&&(i[e]=o.injector().get(e))}),e(r)(i))):t.name}function a(e,t){var i,n=e.split("."),o=t;for(i=0;i<n.length;i++){if(!angular.isDefined(o[n[i]]))return;o=o[n[i]]}return o}function c(e,t){var i,n=!1;for(i=0;i<t.length;i++)t[i].route===e.name&&(n=!0);return n}n.breadcrumbs=[],""!==t.$current.name&&r(),i.onSuccess({},function(e){o=e,r()})}}}])}(),angular.module("pnc-ui-extras.templates").run(["$templateCache",function(e){e.put("pnc-ui-extras/combobox/combobox-option.template.html",'<a ng-click="$ctrl.select(option)" href>{{ $ctrl.getViewValue(option) }}</a>\n'),e.put("pnc-ui-extras/combobox/combobox.template.html",'<style>\n.px-search-clear {\n  position: absolute;\n  z-index: 100;\n  right: 18px;\n  top: 2px;\n  height: 14px;\n  margin: auto;\n  color: inherit;\n  cursor:  pointer;\n}\n\n.px-search-clear > a:hover {\n  background-color: inherit;\n  color: inherit;\n  cursor:  pointer;\n}\n\n.px-combobox-dropdown {\n  display: block;\n}\n.px-combobox-active a,a:hover {\n  background-color: #def3ff;\n}\n.px-combobox-dropdown > .px-combobox-option a,a:hover {\n  border-width: 0px;\n}\n\n.px-combobox-dropdown > .px-combobobox-option {\n  whitespace: normal !important;\n  overflow-wrap: break-word !important;\n}\n\n</style>\n<div class="combobox-container" ng-keydown="$event.stopPropagation()">\n  <div class="input-group">\n    <input type="text" autocomplete="off" id="combobox-{{::$id}}" ng-keyup="$ctrl.onKey($event)" placeholder="{{ ::$ctrl.placeholder }}" class="combobox form-control" ng-focus="$ctrl.openDropDown()" ng-model="$ctrl.inputModel" ng-model-options="$ctrl.modelOptions" pf-focused="$ctrl.showDropDown">\n    <div class="px-search-clear"><a class="px-search-clear" ng-show="$ctrl.inputModel" ng-click="$ctrl.clear()"><span class="pficon pficon-close"></span></a></div>\n    <ul class="typeahead typeahead-long dropdown-menu px-combobox-dropdown" ng-if="$ctrl.options.length > 0 && $ctrl.showDropDown">\n      <li ng-repeat="option in $ctrl.options" ng-include="$ctrl.optionTemplateUrl" class="px-combobox-option" ng-mouseover="$ctrl.setHighlighted($index)" ng-class="{ \'px-combobox-active\': $ctrl.isHighlighted($index) }">\n      </li>\n      <li data-value="spinner" class="text-center" ng-show="$ctrl.isLoading()">\n        <span class="spinner spinner-xs spinner-inline"></span>\n      </li>\n    </ul>\n    <span class="input-group-addon dropdown-toggle" ng-class="{ \'dropup\': $ctrl.showDropDown }" data-dropdown="dropdown" role="button" ng-click="$ctrl.toggleDropDown()">\n      <span class="caret"></span>\n    </span>\n  </div>\n</div>\n'),e.put("pnc-ui-extras/ui-breadcrumbs/uiBreadcrumbs.tpl.html",'<ol class="breadcrumb">\n  <li ng-repeat="crumb in breadcrumbs"\n      ng-class="{ active: $last }"><a ui-sref="{{ crumb.route }}" ng-if="!$last">{{ crumb.displayName }}&nbsp;</a><span ng-show="$last">{{ crumb.displayName }}</span>\n  </li>\n</ol>')}]),function(){"use strict";angular.module("pnc.common.select-modals").component("addBuildConfigWidget",{bindings:{project:"<",onAdd:"&"},templateUrl:"common/select-modals/build-config-multi-select/add-build-config-widget.html",controller:["ProjectResource","$scope",function(e,t){var i=this;i.select=function(t){n=t.id,e.queryBuildConfigurations({id:n}).$promise.then(function(e){i.items=[],i.selectAllState=!0;for(var t=0;t<e.data.length;t++)i.items.push({buildConfig:e.data[t]})});var n},i.add=function(e){i.onAdd(e)},i.addSelected=function(){for(var e=0;e<i.checkedItems.length;e++)i.onAdd(i.checkedItems[e])},i.selectAll=function(e){$("#build-configs-"+t.$id+" .list-view-pf-checkbox input").each(function(){var t=$(this);(e&&!t.is(":checked")||!e&&t.is(":checked"))&&setTimeout(function(){t.click()},0)}),i.selectAllState=!i.selectAllState},i.selectAllState=!0,i.items=[],i.checkedItems=[],i.config={selectItems:!1,multiSelect:!1,dblClick:!1,selectionMatchProp:"buildConfig.id",showSelectBox:!0,onCheckBoxChange:function(e){if(e.selected)i.checkedItems.push(e);else{var t=i.checkedItems.findIndex(function(t){return e.buildConfig.id===t.buildConfig.id});t>-1&&i.checkedItems.splice(t,1)}}},i.actionButtons=[{name:"Add",title:"Add this Build Config",include:"button-add-right",actionFn:function(e,t){i.add(t)}}]}]})}(),function(){"use strict";angular.module("pnc.common.select-modals").component("buildConfigMultiSelect",{bindings:{modalCtrl:"<"},templateUrl:"common/select-modals/build-config-multi-select/build-config-multi-select.html",controller:function(){var e=this;function t(t){return e.buildConfigs.findIndex(function(e){return t.id===e.id})}e.save=function(){e.modalCtrl.$close(e.buildConfigs)},e.cancel=function(){e.modalCtrl.$dismiss()},e.onRemove=function(i){var n=t(i);n>-1&&e.buildConfigs.splice(n,1)},e.onAdd=function(i){t(i)<0&&(e.buildConfigs=angular.copy(e.buildConfigs.concat(i)))},e.$onInit=function(){e.title=e.modalCtrl.config.title,e.buildConfigs=angular.copy(e.modalCtrl.config.buildConfigs)}}})}(),function(){"use strict";angular.module("pnc.common.select-modals").component("removeBuildConfigsWidget",{bindings:{buildConfigs:"<",onRemove:"&"},templateUrl:"common/select-modals/build-config-multi-select/remove-build-configs-widget.html",controller:function(){var e=this;e.remove=function(t){e.onRemove({buildConfig:t})},e.config={selectItems:!1,multiSelect:!1,dblClick:!1,selectionMatchProp:"id",showSelectBox:!1},e.actionButtons=[{name:"Remove",title:"Remove this Build Config",actionFn:function(t,i){e.remove(i)}}]}})}(),function(){"use strict";angular.module("pnc.common.select-modals").controller("BuildGroupMultiSelectController",["$log","modalConfig","GroupConfigResource","rsqlQuery",function(e,t,i,n){var o=this;function r(e){return o.selected.findIndex(function(t){return t.id===e.id})}console.log("modalConfig == %O",t),o.title=t.title,o.selected=angular.copy(t.selected),o.removed=[],o.addGroup=function(e){var t,i=r(e),n=(t=e,o.removed.findIndex(function(e){return e.id===t.id}));i>-1||(n>-1&&o.removed.splice(n,1),o.selected.push(e))},o.removeGroup=function(e){o.selected.splice(r(e),1),o.removed.push(e)},o.save=function(){o.$close(o.selected)},o.close=function(){o.$dismiss()},o.onSelect=function(e){o.addGroup(e),o.input=void 0},o.fetchGroups=function(e){function t(e){return e.id}var r=o.selected.map(t),l=o.removed.map(t),s=n().where("name").like(e+"%").and().where("id").out(r).and().brackets(n().where("productVersion").isNull().or().where("id").in(l).end()).end();return i.query({q:s}).$promise.then(e=>e.data)},o.config={selectItems:!1,multiSelect:!1,dblClick:!1,selectionMatchProp:"id",showSelectBox:!1},o.actionButtons=[{name:"Remove",title:"Remove this Group Config",actionFn:function(e,t){"Remove"===e.name&&o.removeGroup(t)}}]}])}(),function(){"use strict";angular.module("pnc.common.select-modals").service("modalSelectService",["$uibModal","$q","$rootScope",function(e,t,i){function n(){var t=e.open.apply(e,arguments);return t.result.then(function(){i.$evalAsync()}),t}this.openForBuildGroups=function(e){return n({animation:!0,size:"md",templateUrl:"common/select-modals/build-group-multi-select.html",controller:"BuildGroupMultiSelectController",controllerAs:"ctrl",bindToController:!0,resolve:{modalConfig:function(){return t.when(e)}}})},this.openForGroupConfigsMap=function(i){Object.assign({},i).selected=Object.values(i.selected);const n=e.open({animation:!0,size:"md",templateUrl:"common/select-modals/build-group-multi-select.html",controller:"BuildGroupMultiSelectController",controllerAs:"ctrl",bindToController:!0,resolve:{modalConfig:function(){return t.when(i)}}});return n.result=n.result.then(e=>_.keyBy(e,"id")),n},this.openForProductVersion=function(e){return n({animation:!0,size:"md",templateUrl:"common/select-modals/product-version-single-select.html",controller:"ProductVersionSingleSelectController",controllerAs:"ctrl",bindToController:!0,resolve:{modalConfig:function(){return t.when(e)}}})},this.openForBuildConfigs=function(e){return n({animation:!0,size:"xl",template:'<build-config-multi-select modal-ctrl="$ctrl"></build-config-multi-select>',controller:["config",function(e){this.config=e}],controllerAs:"$ctrl",bindToController:!0,resolve:{config:function(){return t.when(e)}}})}}])}(),function(){"use strict";angular.module("pnc.common.select-modals").controller("ProductVersionSingleSelectController",["$log","modalConfig","ProductResource","rsqlQuery",function(e,t,i,n){var o=this;o.title=t.title,o.selectedProduct=angular.copy(t.selected),o.save=function(){o.$close(o.selectedVersion)},o.close=function(){o.$dismiss()},o.onSelectProduct=function(e){o.selectedProduct=e,o.selectedProduct._productVersions=Object.values(o.selectedProduct.productVersions),o.selectedProduct._productVersions.forEach(e=>{e._productName=o.selectedProduct.name}),o.input=void 0,console.log("selected product: %O",e)},o.onSelectVersion=function(e){o.selectedVersion=e,console.log("selected version: %O",e)},o.fetchProducts=function(e){return i.query({q:n().where("name").like(e+"%").end()}).$promise.then(e=>e.data)},o.config={selectItems:!0,multiSelect:!1,dblClick:!1,selectionMatchProp:"id",selectedItems:[],showSelectBox:!1,onSelect:o.onSelectVersion}}])}(),function(){"use strict";angular.module("pnc.common.util").factory("dateUtilConverter",function(){return{convertToTimestampNoon:function(e){return e?(e.setHours(12),e.setMinutes(0),e.setSeconds(0),e.getTime()):null},convertToUTCNoon:function(e){return e?(e.setUTCHours(12),e.setUTCMinutes(0),e.setUTCSeconds(0),e):null},initDatePicker:function(e){e.opened=[],e.today=function(){e.dt=new Date},e.today(),e.clear=function(){e.dt=null},e.open=function(t,i){t.preventDefault(),t.stopPropagation(),e.opened[i]=!0},e.format="yyyy/MM/dd"}}})}(),function(){"use strict";var e=angular.module("pnc.common.util");e.constant("entityTypes",Object.freeze({BUILD:"BUILD",GROUP_BUILD:"GROUP_BUILD"})),e.factory("EntityRecognizer",["entityTypes","$log",function(e,t){function i(i){var n=null;function o(i){null!==n?t.error(e.GROUP_BUILD+" entity recognition was not successful"):n=i}return void 0!==i.buildConfigRevision&&o(e.BUILD),void 0!==i.groupConfig&&o(e.GROUP_BUILD),n}return{isBuild:t=>i(t)===e.BUILD,isGroupBuild:t=>i(t)===e.GROUP_BUILD}}])}(),function(){"use strict";angular.module("pnc.common.util").factory("QueryHelper",function(){var e={search:function(e){return"("+_(e).reduce(function(e,t,i){return e+(0!==i?" or ":"")+t+"=like=%25:search%25"},"")+")"},searchOnly:function(t,i){return"?q="+(i?"(":"")+e.search(t)+(i?i+")":"")}};return e})}(),function(){"use strict";angular.module("pnc.common.util").factory("SortHelper",function(){const e={projectsList:{field:{id:"name",title:"Name"},asc:!0},productsList:{field:{id:"name",title:"Name"},asc:!0},buildConfigsList:{field:{id:"name",title:"Name"},asc:!0},groupConfigsList:{field:{id:"name",title:"Name"},asc:!0},groupConfigsDataTable:{field:{id:"name",title:"Name"},asc:!0},scmRepositoriesList:{field:{id:"internalUrl",title:"Internal URL"},asc:!0},artifactsList:{field:{id:"identifier",title:"Identifier"},asc:!0},buildsList:{field:{id:"submitTime",title:"Submit Time"},asc:!1},groupBuildsList:{field:{id:"startTime",title:"Start Time"},asc:!1}};var t={getSortConfig:function(t){return e[t]},getSortQueryString:function(t){let i=e[t];return{sort:"="+(i.asc?"asc":"desc")+"="+i.field.id}}};return t})}(),function(){"use strict";angular.module("pnc.common.util").factory("utils",["$q",function(e){function t(e){return void 0===e||(null===e||(("string"==typeof e||e instanceof String)&&0===e.length||(!(!Array.isArray(e)||0!==e.length)||"object"==typeof e&&e.constructor===Object&&0===Object.keys(e).length)))}return{isEmpty:t,isNotEmpty:function(e){return!t(e)},parseBoolean:function(e){if(angular.isUndefined(e))return!1;if("boolean"==typeof e)return e;if(angular.isString(e))return"true"===e.toLowerCase();throw new Error("Unable to parse as boolean: "+e)},concatStrings:function(e){if(angular.isObject(e))return Object.keys(e).reduce(function(t,i){var n=e[i];return angular.isString(n)?t+n:t},"")},hashCode:function(e,t){var i=angular.isFunction(t)?t:function(e){return e.id};return e.reduce(function(e,t){return 31*e+i(t)},17)},prettyPrint:function(e,t){var i=t||2;JSON.stringify(e,null,i)},dePaginate:function(t){return e.when(t).then(e=>1===e.total?e.data:e.getWithNewSize(e.total*e.count).then(e=>e.data))}}}])}(),function(){var e=angular.module("pnc");e.controller("authenticationController",["authService",function(e){this.username=e.getPrinciple(),this.isAuthenticated=e.isAuthenticated,this.logout=e.logout,this.login=e.login}]),e.controller("menuController",["$state","$scope",function(e,t){t.state=e}]),e.controller("defaultConfigurationController",["pncProperties",function(e){this.isDefaultConfiguration=e.isDefaultConfiguration,this.title="No UI configuration provided",e.isDefaultConfiguration&&null===sessionStorage.getItem("defaultConfigurationModal")&&$("#defaultConfigurationModal").modal("show"),$("#defaultConfigurationModal").on("hidden.bs.modal",function(){sessionStorage.setItem("defaultConfigurationModal","hidden")})}]),e.controller("userGuideController",["pncProperties",function(e){var t=$("#user-guide .user-guide-link");this.url=e.userGuideUrl,this.url&&null===localStorage.getItem("userGuidePopover")&&(t.popover("show"),t.add("#user-guide .user-guide-close").click(function(){localStorage.setItem("userGuidePopover","displayed"),t.popover("destroy")}))}])}(),angular.module("pnc.dashboard").controller("DashboardController",["authService",function(e){this.isAuthenticated=e.isAuthenticated,this.login=e.login}]),angular.module("pnc.dashboard").directive("pncMyBuildsPanel",["authService","BuildResource","events","paginator",function(e,t,i,n){return{restrict:"E",templateUrl:"dashboard/directives/pnc-my-builds-panel/pnc-my-builds-panel.html",scope:{},link:function(o){o.show=function(){return e.isAuthenticated()},e.isAuthenticated()&&(e.getPncUser().then(function(e){return t.queryByUser({userId:e.id,pageSize:10,sort:"=desc=submitTime"}).$promise.then(function(e){o.page=n(e)})}),o.displayFields=["status","id","configurationName","startTime","endTime"],o.$on(i.BUILD_PROGRESS_CHANGED,(t,i)=>{e.isCurrentUser(i.user)&&o.page.refresh()}))}}}]),angular.module("pnc.dashboard").directive("pncMyGroupBuildsPanel",["authService","GroupBuildResource","events","paginator",function(e,t,i,n){return{restrict:"E",templateUrl:"dashboard/directives/pnc-my-group-builds-panel/pnc-my-group-builds-panel.html",scope:{},link:function(o){o.show=function(){return e.isAuthenticated()},e.isAuthenticated()&&(e.getPncUser().then(function(e){return t.queryByUser({userId:e.id,pageSize:10,sort:"=desc=startTime"}).$promise.then(function(e){o.page=n(e)})}),o.displayFields=["status","id","configurationName","startTime","endTime"],o.$on(i.GROUP_BUILD_PROGRESS_CHANGED,(t,i)=>{e.isCurrentUser(i.user)&&o.page.refresh()}))}}}]),function(){"use strict";angular.module("pnc.dashboard").component("pncDashboardWidget",{transclude:{title:"widgetTitle",body:"widgetBody"},templateUrl:"dashboard/widgets/pnc-dashboard-widget/pnc-dashboard-widget.html",controller:["$window","$element",function(e,t){const i=[];let n,o;function r(){n||(n=!0,e.requestAnimationFrame(()=>{i.forEach(e=>e({width:o.clientWidth})),n=!1}))}this.registerOnResize=function(e){i.push(e),r()},this.$onInit=(()=>{o=t[0].firstElementChild}),this.$postLink=(()=>{e.addEventListener("resize",r)}),this.$onDestroy=(()=>{e.removeEventListener("resize",r)})}]})}(),function(){"use strict";angular.module("pnc.dashboard").component("pncGrafanaWidget",{bindings:{widgetType:"@"},templateUrl:"dashboard/widgets/pnc-grafana-widget/pnc-grafana-widget.html",controller:["pncProperties",function(e){const t=this,i={TRAFFIC_LIGHTS:{title:"Service Status",url:e.grafana.trafficLightsUrl},STATUS_MAP:{title:"Service Status Timeline",url:e.grafana.statusMapUrl}};function n(e){return i[t.widgetType][e]}t.$onInit=(()=>{if(!i[t.widgetType])throw new Error(`<pnc-grafana-widget>: Invalid property for binding 'widget-type': '${t.widgetType}', valid types are: ${Object.keys(i)}`);t.title=n("title"),t.url=n("url")})}]})}(),function(){"use strict";angular.module("pnc.dashboard").component("pncGrafanaWidgetBody",{bindings:{url:"<"},require:{widget:"^pncDashboardWidget"},templateUrl:"dashboard/widgets/pnc-grafana-widget/pnc-grafana-widget-body.html",controller:["$element","$sce",function(e,t){const i=this;let n;function o(e){n.width=e.width}i.$onInit=(()=>{i.iFrameUrl=t.trustAsResourceUrl(i.url)}),i.$postLink=(()=>{n=e[0].firstElementChild,i.widget.registerOnResize(o)})}]})}(),function(){"use strict";angular.module("pnc.group-configs").component("pncGroupBuildLink",{bindings:{groupBuild:"<"},transclude:!0,templateUrl:"group-builds/components/pnc-group-build-link/pnc-group-build-link.html",controller:[function(){this.$onInit=(()=>{})}]})}(),function(){"use strict";angular.module("pnc.group-builds").component("pncGroupBuildValuesList",{bindings:{groupBuild:"<"},templateUrl:"group-builds/components/pnc-group-build-values-list/pnc-group-build-values-list.html",controller:[function(){this.$onInit=function(){}}]})}(),function(){"use strict";angular.module("pnc.group-builds").component("pncGroupBuildVisualization",{bindings:{groupBuild:"<",dependencyGraph:"<",builds:"<",visualization:"<?"},templateUrl:"group-builds/components/pnc-group-build-visualization/pnc-group-build-visualization.html",controller:["$scope","$state","$stateParams",function(e,t,i){var n=this;n.buildColumns=["status","id","configurationName","startTime","endTime","username","pushStatus"],n.changeVisualization=function(e){n.visualization=e,t.go(".",{visualization:e})},n.$onInit=function(){n.visualization=i.visualization}}]})}(),function(){"use strict";angular.module("pnc.group-builds").component("pncGroupBuildDetailPage",{bindings:{groupBuild:"<",dependencyGraph:"<",builds:"<"},templateUrl:"group-builds/detail/pnc-group-build-detail-page.html",controller:["$scope","events",function(e,t){var i=this;i.hasBuilds=function(){return i.builds&&i.builds.length>0},i.$onInit=function(){e.$on(t.GROUP_BUILD_STATUS_CHANGED,function(t,n){n.id===i.groupBuild.id&&e.$applyAsync(function(){Object.assign(i.groupBuild,n)})})}}]})}(),function(){"use strict";angular.module("pnc.group-builds").component("pncGroupBuildsListPage",{bindings:{groupBuilds:"<"},templateUrl:"group-builds/list/pnc-group-builds-list-page.html",controller:["filteringPaginator","SortHelper",function(e,t){const i=this;i.displayFields=["status","id","configurationName","startTime","endTime","username"],i.groupBuildsFilteringFields=[{id:"user.username",title:"Username",placeholder:"Filter by Username",filterType:"text"},{id:"groupConfig.name",title:"Group Config name",placeholder:"Filter by Group Config name",filterType:"text"},{id:"status",title:"Status",placeholder:"Filter by Status",filterType:"select",filterValues:["SUCCESS","REJECTED","FAILED","CANCELLED","BUILDING"]},{id:"temporaryBuild",title:"Temporary Build",placeholder:"Filter by Temporary Build",filterType:"select",filterValues:["FALSE","TRUE"]}],i.groupBuildsSortingFields=[{id:"status",title:"Status"},{id:"groupConfig.name",title:"Build Config"},{id:"startTime",title:"Start Time"},{id:"endTime",title:"End Time"},{id:"user.username",title:"User"}],i.$onInit=function(){i.groupBuildsFilteringPage=e(i.groupBuilds),i.groupBuildsSortingConfigs=t.getSortConfig("groupBuildsList")}}]})}(),function(){"use strict";angular.module("pnc.group-configs").component("pncGroupConfigLink",{bindings:{groupConfig:"<"},transclude:!0,templateUrl:"group-configs/components/pnc-group-config-link/pnc-group-config-link.html",controller:[function(){this.$onInit=(()=>{})}]})}(),function(){"use strict";angular.module("pnc.group-configs").component("pncGroupConfigsDataTable",{bindings:{page:"<",fetchSelected:"&",onEdit:"&"},templateUrl:"group-configs/components/pnc-group-configs-data-table/pnc-group-configs-data-table.html",controller:["$q","filteringPaginator","SortHelper","modalSelectService",function(e,t,i,n){const o=this;function r(){o.fetchSelected().then(e=>{n.openForBuildGroups({title:"Add or Remove Group Configs from Product Version",selected:e}).result.then(e=>console.log("Modal Result: %O",e))})}o.edit=r,o.$onInit=function(){o.filterPage=t(o.page),o.displayFields=["name","buildStatus"],o.filterFields=[{id:"name",title:"Name",placeholder:"Filter by Name",filterType:"text"}],o.sortingFields=[{id:"name",title:"Name"}],o.sortingConfigs=i.getSortConfig("groupConfigsDataTable"),o.toolbarActions=function(){const e=[];o.onEdit()&&e.push({name:"Edit",title:"Add or remove Group Configs to the list",actionFn:r});return e.length>0?{primaryActions:e}:void 0}()}}]})}(),function(){"use strict";angular.module("pnc.group-configs").component("pncGroupConfigsList",{bindings:{groupConfigs:"<",displayFields:"<",actionsTemplateUrl:"@",actionsData:"<"},templateUrl:"group-configs/components/pnc-group-configs-list/pnc-group-configs-list.html",controller:["$scope",function(e){const t=this;let i;t.showTable=function(){return t.groupConfigs&&t.groupConfigs.length>0},t.showColumn=function(e){return i.includes(e)},t.$onInit=function(){i=t.displayFields||["name"],e.actions=t.actionsData}}]})}(),function(){"use strict";angular.module("pnc.group-configs").component("pncGroupConfigCreatePage",{bindings:{productVersion:"<"},templateUrl:"group-configs/create/pnc-group-config-create-page.html",controller:["$log","$state","GroupConfigResource",function(e,t,i){const n=this;n.create=function(e){console.log("create -> %O",e);let o=new i(e),r=n.productVersion||e.version;r&&(o.productVersion={id:r.id});o.$save().then(()=>t.go("group-configs.detail",{groupConfigId:o.id}))},n.$onInit=(()=>{e.debug("pncGroupConfigCreatePage::$onInit [productVersion: %O]",n.productVersion)}),n.checkVersionData=(e=>{(!e.product||e.version&&e.product.id!==e.version.product.id)&&(e.version=null)}),n.reset=(()=>{n.data.groupConfig=null})}]})}(),function(){"use strict";angular.module("pnc.group-configs").component("pncGroupConfigBuildConfigsTab",{bindings:{groupConfig:"<",buildConfigs:"<"},templateUrl:"group-configs/detail/build-configs-tab/pnc-group-config-build-configs-tab.html",controller:["$log","paginator","GroupConfigResource",function(e,t,i){const n=this;n.onEdit=function(t){return e.info("Edit Build Configs: %O",t),i.arrayPatch(n.buildConfigs.data,t,"buildConfigs",n.groupConfig.id).$promise},n.onRemove=function(t){return e.info("remove BuildConfig: %O",t),n.groupConfig.$removeBuildConfig({buildConfigId:t.id})},n.refreshBuildConfigs=function(e){n.buildConfigs.data=e},n.$onInit=(()=>{n.paginator=t(n.buildConfigs)})}]})}(),function(){"use strict";angular.module("pnc.group-configs").component("pncGroupConfigBuildHistoryTab",{bindings:{groupConfig:"<",groupBuilds:"<"},templateUrl:"group-configs/detail/build-history-tab/pnc-group-config-build-history-tab.html",controller:["$log","paginator",function(e,t){const i=this;i.$onInit=(()=>{i.paginator=t(i.groupBuilds),e.debug("pncGroupConfigBuildHistoryTab::$onInit [groupConfig: %O | groupBuilds: %O]",i.groupConfig,i.groupBuilds)})}]})}(),function(){"use strict";angular.module("pnc.group-configs").component("pncGroupConfigDetailPage",{bindings:{groupConfig:"<",productVersion:"<"},templateUrl:"group-configs/detail/pnc-group-config-detail-page.html",controller:["$log","$state","modalSelectService","GroupConfigResource",function(e,t,i,n){const o=this;function r(t,i){e.debug("pncGroupConfigDetailPage::resetState [groupConfig: %O | productVersion: %O]",t,i),o.groupConfig=t,o.productVersion=i,o.formModel=t.toJSON()}o.update=function(e){return n.safePatch(o.groupConfig,e).$promise.catch(e=>e.data.errorMessage)},o.delete=function(){o.groupConfig.$delete().then(()=>t.go("group-configs.list"))},o.linkWithProductVersion=function(){i.openForProductVersion({title:"Link "+o.groupConfig.name+" with a product version"}).result.then(e=>{n.linkWithProductVersion(o.groupConfig,e).then(t=>r(t,e))})},o.unlinkFromProductVersion=function(){n.unlinkFromProductVersion(o.groupConfig).then(e=>r(e,null))},o.$onInit=(()=>{o.formModel=o.groupConfig.toJSON()})}]})}(),function(){"use strict";angular.module("pnc.group-configs").component("pncGroupConfigsListPage",{bindings:{groupConfigsPage:"<"},templateUrl:"group-configs/list/pnc-group-configs-list-page.html",controller:["filteringPaginator","SortHelper",function(e,t){const i=this;i.groupConfigsSortingFields=[{id:"name",title:"Name"}],i.$onInit=(()=>{i.paginator=e(i.groupConfigsPage),i.filterFields=[{id:"name",title:"Name",placeholder:"Filter by Name",filterType:"text"}],i.groupConfigsSortingConfigs=t.getSortConfig("groupConfigsList")})}]})}(),angular.isUndefined(window.pnc)&&(window.pnc={}),function(e){"use strict";var t={error:[],warn:[],info:[],success:[]},i={isDefaultConfiguration:!0,externalLegacyPncUrl:"/pnc-rest/rest",externalPncUrl:"/pnc-rest/v2",pncNotificationsUrl:"ws://"+window.location.host+"/pnc-rest/notifications"};function n(e){return e&&e.keycloak&&e.keycloak.url}!function(e,i){if(n(i)){var o=document.createElement("script");o.onload=function(){e(i)},o.addEventListener("error",function(){t.warn.push({message:"Unable to load Keycloak: authentication disabled, check your certificates are installed properly or visit User Guide FAQ section.",actionTitle:"User Guide",actionCallback:function(){window.open(i.userGuideUrl,"_blank")},persistent:!0}),t.info.push({message:"Unable to load Keycloak: as a workaround, you can visit Keycloak Server directly and reload this page.",actionTitle:"Keycloak Server",actionCallback:function(){window.open(o.src,"_blank")},persistent:!0}),i.keycloak=!1,e(i)}),o.src=i.keycloak.url+"/js/keycloak.min.js",document.head.appendChild(o)}else e(i)}(function(e){e||(console.warn("No UI configuration provided: using defaults"),e=i),console.info("Starting UI with configuration: "+JSON.stringify(e,null,2)),window.jQuery.fn.sidebar=angular.noop,angular.element(document).ready(function(){var i;i=n(e)?new Keycloak(e.keycloak):{authenticated:!1,login:function(){console.warn("Authentication is disabled, keycloak.login() ignored")},logout:function(){console.warn("Authentication is disabled, keycloak.logout() ignored")}},angular.module("pnc").config(["keycloakProvider",function(e){e.setKeycloak(i)}]),angular.module("pnc.properties",[]).constant("pncProperties",e).constant("onBootNotifications",t),n(e)?i.init({onLoad:"check-sso",responseMode:"fragment"}).success(function(){angular.bootstrap(document,["pnc"],{strictDi:!0})}):angular.bootstrap(document,["pnc"],{strictDi:!0})})},e.config)}(window.pnc),function(){"use strict";angular.module("pnc.product-milestones").component("pncProductMilestoneCloseResultPage",{bindings:{closeResult:"<"},templateUrl:"product-milestones/close-result/pnc-product-milestone-close-result-page.html",controller:[function(){const e=this;e.$onInit=(()=>{e.data=e.closeResult.data[0],e.prefixFilters="loggerName.keyword:org.jboss.pnc.causeway|org.jboss.pnc._userlog_,level.keyword:INFO|ERROR|WARN",e.matchFilters=`mdc.processContext.keyword:${e.data.id}`})}]})}(),function(){"use strict";angular.module("pnc.product-milestones").component("pncProductMilestoneClosePage",{bindings:{product:"<",productVersion:"<",productMilestone:"<"},templateUrl:"product-milestones/close/pnc-product-milestone-close-page.html",controller:["$state",function(e){const t=this;t.submit=function(){t.data.$close().then(t=>{e.go("products.detail.product-versions.detail.milestone.detail.close-result",{productMilestoneId:t.milestone.id,closeResultId:t.id})})},t.$onInit=(()=>{t.data=t.productMilestone})}]})}(),function(){"use strict";angular.module("pnc.product-milestones").component("pncMilestoneCloseStatusLabel",{bindings:{closeResult:"<"},templateUrl:"product-milestones/components/pnc-milestone-close-status-label/pnc-milestone-close-status-label.html",controller:[function(){const e=this;e.getStatus=i;const t={IN_PROGRESS:{text:"IN PROGRESS",class:"label label-primary"},FAILED:{text:"FAILED",class:"label label-danger"},SUCCEEDED:{text:"SUCCEEDED",class:"label label-success"},CANCELED:{text:"CANCELLED",class:"label label-default"},SYSTEM_ERROR:{text:"SYSTEM ERROR",class:"label label-danger"}};function i(){return angular.isUndefined(e.closeResult)?null:t[e.closeResult.status]}e.$onInit=(()=>{e.closeStatus=i()})}]})}(),function(){"use strict";angular.module("pnc.product-milestones").component("pncProductMilestoneActions",{bindings:{productMilestone:"<",product:"<",productVersion:"<",size:"@?"},templateUrl:"product-milestones/components/pnc-product-milestone-actions/pnc-product-milestone-actions.html",controller:["$state",function(e){const t=this;t.markMilestoneAsCurrent=function(i){const n=angular.copy(t.productVersion);n.currentProductMilestone={id:i.id},n.$update({productId:t.product.id,versionId:t.productVersion.id}).then(function(){e.go("products.detail.product-versions.detail",{productId:t.product.id,productVersionId:t.productVersion.id},{reload:!0})})}}]})}(),function(){"use strict";angular.module("pnc.product-milestones").component("pncProductMilestoneBuilds",{bindings:{productMilestone:"<",performedBuilds:"<"},templateUrl:"product-milestones/components/pnc-product-milestone-builds/pnc-product-milestone-builds.html",controller:["SortHelper","filteringPaginator",function(e,t){const i=this;i.displayFields=["status","id","configurationName","endTime"],i.performedBuildsFilteringFields=[{id:"user.username",title:"Username",placeholder:"Filter by Username",filterType:"text"},{id:"buildConfig.name",title:"Build Config name",placeholder:"Filter by Build Config name",filterType:"text"},{id:"status",title:"Status",placeholder:"Filter by Status",filterType:"select",filterValues:["SUCCESS","REJECTED","FAILED","CANCELLED","BUILDING","NO_REBUILD_REQUIRED","SYSTEM_ERROR"]},{id:"temporaryBuild",title:"Temporary Build",placeholder:"Filter by Temporary Build",filterType:"select",filterValues:["FALSE","TRUE"]}],i.performedBuildsSortingFields=[{id:"status",title:"Status"},{id:"startTime",title:"Start Time"},{id:"submitTime",title:"Submit Time"},{id:"endTime",title:"End Time"},{id:"user.username",title:"Username"}],i.$onInit=(()=>{i.performedBuildsFilteringPage=t(i.performedBuilds),i.performedBuildsSortingConfigs=e.getSortConfig("buildsList")})}]})}(),function(){"use strict";angular.module("pnc.product-milestones").component("pncProductMilestoneCloseResultsDataTable",{bindings:{closeResults:"<"},templateUrl:"product-milestones/components/pnc-product-milestone-close-results-data-table/pnc-product-milestone-close-results-data-table.html",controller:["filteringPaginator",function(e){const t=this;t.$onInit=(()=>{t.filterPage=e(t.closeResults)})}]})}(),function(){"use strict";angular.module("pnc.product-milestones").component("pncProductMilestoneCloseResultsList",{bindings:{closeResults:"<"},templateUrl:"product-milestones/components/pnc-product-milestone-close-results-data-table/pnc-product-milestone-close-results-list.html",controller:[function(){const e=this;e.showTable=function(){return e.items&&e.items.length},e.showColumn=function(e){if(e)return!0;return!1},e.$onInit=(()=>{e.items=e.closeResults})}]})}(),function(){"use strict";angular.module("pnc.product-milestones").component("pncProductMilestoneLink",{bindings:{productVersion:"<",productMilestone:"<"},templateUrl:"product-milestones/components/pnc-product-milestone-link/pnc-product-milestone-link.html",controller:[function(){const e=this;e.isCurrentProductMilestone=function(){return e.productVersion.currentProductMilestone&&e.productMilestone.id===e.productVersion.currentProductMilestone.id},e.$onInit=(()=>{})}]})}(),function(){"use strict";angular.module("pnc.product-milestones").component("pncProductMilestonesList",{bindings:{productVersion:"<",product:"<",productMilestones:"<"},templateUrl:"product-milestones/components/pnc-product-milestones-list/pnc-product-milestones-list.html",controller:[function(){this.$onInit=(()=>{})}]})}(),function(){"use strict";angular.module("pnc.product-milestones").directive("productMilestoneVersionValidator",["$timeout","$q","ProductMilestoneResource",function(e,t,i){return{restrict:"A",require:"ngModel",scope:{errorMessages:"="},link:function(n,o,r,l){let s;l.$asyncValidators.productMilestoneVersionValidator=function(o,l){let a=t.defer();return s&&e.cancel(s),s=e(()=>{let e=o||l,t=r.productVersionId,s=r.productVersion;return e&&t&&s&&i.validateVersion({productVersionId:t,version:s+"."+e}).$promise.then(e=>{e.isValid?a.resolve():(n.errorMessages=e.hints,a.reject())}).catch(()=>{n.errorMessages=["An unexpected error occurred, please try again later"],a.reject()}),a.promise},500)}}}}])}(),function(){"use strict";angular.module("pnc.product-milestones").component("pncProductMilestoneCreateUpdatePage",{bindings:{product:"<",productVersion:"<",productMilestone:"<"},templateUrl:"product-milestones/create-update/pnc-product-milestone-create-update-page.html",controller:["$state","ProductMilestoneResource","dateUtilConverter",function(e,t,i){const n=this;function o(t,i){e.go("products.detail.product-versions.detail",{productId:t,productVersionId:i},{reload:!0})}n.isUpdating=!1,n.data=new t,n.startingDate=null,n.plannedEndDate=null,n.invalidStartingPlannedEndDates=function(e,t){if(void 0===e||void 0===t)return!1;return e>=t},n.submit=function(){n.data.version=n.productVersion.version+"."+n.version,n.data.startingDate=i.convertToUTCNoon(n.startingDate),n.data.plannedEndDate=i.convertToUTCNoon(n.plannedEndDate),n.data.productVersion={id:n.productVersion.id},n.isUpdating?(n.setCurrentMilestone&&(n.productVersion.currentProductMilestone={id:n.data.id}),n.productVersion.$update().then(()=>{n.data.$update().then(()=>{o(n.product.id,n.productVersion.id)})})):n.data.$save().then(()=>{n.setCurrentMilestone?(n.productVersion.currentProductMilestone={id:n.data.id},n.productVersion.$update().finally(()=>{o(n.product.id,n.productVersion.id)})):o(n.product.id,n.productVersion.id)})},n.productMilestoneVersionErrorMessages=[],n.$onInit=(()=>{null!==n.productMilestone&&(n.isUpdating=!0,n.data=n.productMilestone,n.version=n.data.version.substring(n.productVersion.version.length+1),n.startingDate=new Date(n.data.startingDate),n.plannedEndDate=new Date(n.data.plannedEndDate)),n.setCurrentMilestone=n.productVersion.currentProductMilestone.id===n.data.id,n.setCurrentMilestoneDisabled=n.setCurrentMilestone})}]})}(),function(){"use strict";angular.module("pnc.product-milestones").component("pncProductMilestoneDetailPage",{bindings:{productMilestone:"<",performedBuilds:"<",closeResults:"<",product:"<",productVersion:"<"},templateUrl:"product-milestones/detail/pnc-product-milestone-detail-page.html",controller:[function(){const e=this;e.$onInit=(()=>{e.closeStatus=e.productMilestone.endDate?"CLOSED":"OPEN",e.latestCloseResult=e.closeResults.data[0]})}]})}(),function(){"use strict";angular.module("pnc.product-releases").component("pncProductReleaseLabel",{bindings:{productRelease:"<"},templateUrl:"product-releases/components/pnc-product-release-label/pnc-product-release-label.html",controller:[function(){this.$onInit=(()=>{})}]})}(),function(){"use strict";angular.module("pnc.product-releases").component("pncProductReleasesList",{bindings:{productReleases:"<"},templateUrl:"product-releases/components/pnc-product-releases-list/pnc-product-releases-list.html",controller:[function(){this.$onInit=(()=>{})}]})}(),function(){"use strict";angular.module("pnc.product-releases").component("pncProductReleaseCreateUpdatePage",{bindings:{product:"<",productRelease:"<",productVersion:"<"},templateUrl:"product-releases/create-update/pnc-product-release-create-update-page.html",controller:["ProductVersionResource","ProductReleaseResource","dateUtilConverter","$state",function(e,t,i,n){const o=this;function r(e,t){n.go("products.detail.product-versions.detail",{productId:e,productVersionId:t},{reload:!0})}o.isUpdating=!1,o.isLoaded=!1,o.productMilestonesWithoutProductRelease=[],o.supportLevels=[],o.releaseDate=null,o.data=new t,o.$onInit=(()=>{null!==o.productRelease&&(o.isUpdating=!0,o.data=o.productRelease,o.productMilestoneId=o.productRelease.productMilestone.id,o.version=o.data.version.substring(o.productVersion.version.length+1),o.releaseDate=new Date(o.data.releaseDate)),e.queryMilestones({id:o.productVersion.id,pageSize:200}).$promise.then(e=>{o.productMilestonesWithoutProductRelease=e.data.filter(e=>!e.productRelease),o.isLoaded=!0}),t.querySupportLevels().$promise.then(e=>{o.supportLevels=e})}),o.submit=(()=>{o.data.version=o.productVersion.version+"."+o.version,o.data.releaseDate=i.convertToUTCNoon(o.releaseDate),o.data.productVersion={id:o.productVersion.id},o.data.productMilestone={id:parseInt(o.productMilestoneId)},o.isUpdating?o.data.$update().then(()=>{r(o.product.id,o.productVersion.id)}):o.data.$save().then(()=>{r(o.product.id,o.productVersion.id)})})}]})}(),function(){"use strict";angular.module("pnc.product-versions").component("pncProductVersionLink",{bindings:{productVersion:"<"},templateUrl:"product-versions/components/pnc-product-version-link/pnc-product-version-link.html",controller:["ProductVersionResource",function(e){var t=this;t.isProductVersionLoading=!0,t.$onInit=function(){t.productVersion?e.get({id:t.productVersion.id}).$promise.then(function(e){t.isProductVersionLoading=!1,t.productVersionData=e}):t.isProductVersionLoading=!1}}]})}(),function(){"use strict";angular.module("pnc.product-versions").component("pncProductVersionsDataTable",{bindings:{page:"<",displayFields:"<",onEdit:"&",onRemove:"&"},templateUrl:"product-versions/components/pnc-product-versions-data-table/pnc-product-versions-data-table.html",controller:["paginator",function(e){const t=this;t.$onInit=function(){t.paginator=e(t.page)}}]})}(),function(){"use strict";angular.module("pnc.product-versions").component("pncProductVersionsList",{bindings:{productVersions:"<",displayFields:"<",actionsTemplateUrl:"@",actionsData:"<"},templateUrl:"product-versions/components/pnc-product-versions-data-table/pnc-product-versions-list.html",controller:["$scope",function(e){const t=this,i=["name","version"];let n;t.showTable=function(){return t.productVersions&&t.productVersions.length>0},t.showColumn=function(e){return n.includes(e)},t.$onInit=function(){n=t.displayFields||i,e.actions=t.actionsData}}]})}(),function(){"use strict";angular.module("pnc.product-versions").component("pncCreateProductVersionForm",{bindings:{product:"<"},templateUrl:"product-versions/create/pnc-create-product-version-form.html",controller:["$state","ProductVersionResource",function(e,t){const i=this;i.submit=function(){const n=new t(i.formData);n.product=i.product,n.$save().then(t=>e.go("products.detail.product-versions.detail",{productId:t.product.id,productVersionId:t.id}))},i.reset=function(e){i.formData={},e.$setPristine(),e.$setUntouched()},i.$onInit=(()=>{i.formData={}})}]})}(),function(){"use strict";angular.module("pnc.product-versions").component("pncCreateProductVersionPage",{bindings:{product:"<"},templateUrl:"product-versions/create/pnc-create-product-version-page.html",controller:[function(){this.$onInit=(()=>{})}]})}(),function(){"use strict";angular.module("pnc.product-versions").component("pncProductVersionDetailPage",{bindings:{productVersion:"<",buildConfigs:"<",groupConfigs:"<",productReleases:"<",productMilestones:"<"},templateUrl:"product-versions/detail/pnc-product-version-detail-page.html",controller:["ProductVersionResource","BuildConfigResource","paginator",function(e,t,i){const n=this;n.getFullName=function(){return`${n.productVersion.product.name} ${n.productVersion.version}`},n.save=function(t){return t.attributes={},t.attributes.BREW_TAG_PREFIX=t.brewTagPrefix,delete t.brewTagPrefix,e.safePatch(n.productVersion,t).$promise.catch(e=>e.data.errorMessage||"Unrecognised error from PNC REST API")},n.editBuildConfigs=function(t){return console.log("EDIT BCs: %O",t),e.arrayPatch(n.buildConfigs.data,t,"buildConfigs",n.productVersion.id).$promise},n.editGroupConfigs=function(t){console.log("EDIT GCs: %O",t);const i={groupConfigs:_.keyBy(t,"id")};e.safePatch(n.productVersion,i)},n.editGroupConfigs=null,n.fetchGroupConfigRefs=function(){return n.productVersion.$get().then(e=>Object.values(e.groupConfigs))},n.refreshBuildConfigs=function(e){n.buildConfigs.data=e},n.removeBuildConfig=function(e){return console.log("REMOVE BC: %O",e),e.productVersion=null,t.update(e).$promise},n.$onInit=(()=>{n.productReleasesPage=i(n.productReleases),n.productMilestonesPage=i(n.productMilestones)})}]})}(),function(){"use strict";angular.module("pnc.products").component("pncProductLink",{bindings:{product:"<"},transclude:!0,templateUrl:"products/components/pnc-product-link/pnc-product-link.html",controller:[function(){this.$onInit=(()=>{})}]})}(),function(){"use strict";angular.module("pnc.products").component("pncProductsDataTable",{bindings:{products:"<"},templateUrl:"products/components/pnc-products-data-table/pnc-products-data-table.html",controller:["filteringPaginator","SortHelper",function(e,t){const i=this;i.$onInit=(()=>{i.filterPage=e(i.products),i.filterFields=[{id:"name",title:"Name",placeholder:"Filter by Name",filterType:"text"}],i.productsSortingFields=[{id:"name",title:"Name"},{id:"abbreviation",title:"Abbreviation"}],i.productsSortingConfigs=t.getSortConfig("productsList")})}]})}(),function(){"use strict";angular.module("pnc.products").component("pncProductsList",{bindings:{products:"<",displayFields:"<?"},templateUrl:"products/components/pnc-products-data-table/pnc-products-list.html",controller:[function(){const e=this,t=["name","abbreviation"];let i;e.showTable=function(){return e.products&&e.products.length},e.showColumn=function(e){return i.includes(e)},e.$onInit=(()=>{i=e.displayFields||t})}]})}(),function(){"use strict";angular.module("pnc.products").component("pncCreateProductForm",{templateUrl:"products/create/pnc-create-product-form.html",controller:["$state","ProductResource",function(e,t){const i=this;i.create=function(i){t.save(i).$promise.then(t=>e.go("products.detail",{productId:t.id}),e=>console.error("Error creating product: %O",e))},i.reset=function(e){i.formData=void 0,e.$setPristine(),e.$setUntouched()},i.$onInit=(()=>{})}]})}(),function(){"use strict";angular.module("pnc.products").component("pncCreateProductPage",{templateUrl:"products/create/pnc-create-product-page.html",controller:[function(){this.$onInit=(()=>{})}]})}(),function(){"use strict";angular.module("pnc.products").component("pncProductDetailPage",{bindings:{product:"<",productVersions:"<"},templateUrl:"products/detail/pnc-product-detail-page.html",controller:["ProductResource",function(e){const t=this;t.update=function(i){return e.safePatch(t.product,i).$promise.then(e=>console.log(e),e=>e.data.errorMessage||"Unrecognised error from PNC REST API")},t.$onInit=(()=>{t.displayFields=["version","milestones","releases"]})}]})}(),function(){"use strict";angular.module("pnc.products").component("pncProductsListPage",{bindings:{products:"<"},templateUrl:"products/list/pnc-products-list-page.html",controller:[function(){this.$onInit=(()=>{})}]})}(),function(){"use strict";angular.module("pnc.projects").component("pncProjectLink",{bindings:{project:"<"},templateUrl:"projects/components/pnc-project-link/pnc-project-link.html",controller:[function(){this.$onInit=(()=>{})}]})}(),function(){"use strict";angular.module("pnc.projects").component("pncProjectsList",{bindings:{projects:"<",displayFields:"<?",hideHead:"<?"},templateUrl:"projects/components/pnc-projects-list/pnc-projects-list.html",controller:[function(){const e=this,t=["name","description"];e.showTable=function(){return e.items&&e.items.length},e.showColumn=function(t){return e.fields.includes(t)},e.$onInit=(()=>{e.items=e.projects,e.fields=e.displayFields||t}),e.$onChanges=(t=>{t.projects&&(e.items=e.projects)})}]})}(),function(){"use strict";angular.module("pnc.projects").component("pncProjectCreatePage",{bindings:{},templateUrl:"projects/create/pnc-project-create-page.html",controller:["$state","ProjectResource",function(e,t){this.create=function(i){new t(angular.copy(i)).$save().then(function(t){e.go("projects.detail",{projectId:t.id})})},this.reset=function(e){e.$setPristine(),e.$setUntouched()}}]})}(),function(){"use strict";angular.module("pnc.projects").component("pncProjectDetailPage",{bindings:{project:"<",buildConfigs:"<"},templateUrl:"projects/detail/pnc-project-detail-page.html",controller:["$state","ProjectResource","filteringPaginator","$rootScope",function(e,t,i,n){const o=this;function r(){e.go("projects.detail",{projectId:o.project.id},{reload:!0})}o.cancel=function(){r()},o.update=function(){o.project.$update().finally(r)},o.buildConfigsFilteringFields=[{id:"name",title:"Name",placeholder:"Filter by Name",filterType:"text"},{id:"description",title:"Description",placeholder:"Filter by Description",filterType:"text"}],o.buildConfigsDisplayFields=["name","project","buildStatus"],o.$onInit=(()=>{o.buildConfigsFilteringPage=i(o.buildConfigs)}),n.$on("BCC_BPM_NOTIFICATION",(e,t)=>{"BCC_CREATION_SUCCESS"===t.eventType&&r()})}]})}(),function(){"use strict";angular.module("pnc.projects").component("pncProjectsListPage",{bindings:{projects:"<"},templateUrl:"projects/list/pnc-projects-list-page.html",controller:["filteringPaginator","SortHelper",function(e,t){const i=this;i.projectsFilteringFields=[{id:"name",title:"Name",placeholder:"Filter by Name",filterType:"text"},{id:"description",title:"Description",placeholder:"Filter by Description",filterType:"text"}],i.projectsSortingFields=[{id:"name",title:"Name"},{id:"description",title:"Description"}],i.$onInit=(()=>{i.projectsFilteringPage=e(i.projects),i.projectsSortingConfigs=t.getSortConfig("projectsList")})}]})}(),angular.module("pnc.report").directive("pncProjectRepositoryForm",function(){return{restrict:"E",scope:{searchCallback:"&",resetCallback:"&"},templateUrl:"report/directives/pnc-project-repository-form/pnc-project-repository-form.html",controller:["$scope",function(e){var t=function(){e.scmUrl="",e.revision="",e.pomPath="",e.additionalRepos=[]};t(),e.reset=function(i){i&&(t(),e.resetCallback(),i.$setPristine(),i.$setUntouched())},e.search=function(){e.searchCallback({scmUrl:e.scmUrl,revision:e.revision,pomPath:e.pomPath,additionalRepos:e.additionalRepos})}}]}}),function(){"use strict";var e=angular.module("pnc.report");e.controller("BlacklistedArtifactsInProjectReportController",["ReportResource",function(e){var t=this;t.afterSearch=!1,t.defaultSortKey="groupId",t.defaultReverse=!1,t.isResultNotEmpty=function(){return!_.isEmpty(t.reportResults)},t.reset=function(){t.reportResults=[],t.afterSearch=!1},t.search=function(i,n,o,r){e.getBlacklistedArtifactsInProject(i,n,o,r).then(function(e){t.reportResults=[],_.forEach(e,function(e){_.forEach(e.gavs,function(e){t.reportResults.push(e)})}),t.reportResults=_(t.reportResults).uniq(function(e){return JSON.stringify(_.pick(e,["groupId","artifactId","version"]))}),t.sortKey=t.defaultSortKey,t.reverse=t.defaultReverse,t.afterSearch=!0,t.reportResults=_.chain(t.reportResults).sortBy(function(e){return e[t.defaultSortKey]}).value()},function(){t.reportResults=[]})},t.sort=function(e){t.sortKey=e,t.reverse=!t.reverse}}]),e.controller("BuiltArtifactsInProjectReportController",["ReportResource",function(e){var t=this;t.afterSearch=!1,t.defaultSortKey="groupId",t.defaultReverse=!1,t.pagination={current:1},t.defaultPageSize=30,t.availableVersionsLimits=[],t.expandAll=function(){var e=t.defaultPageSize*(t.pagination.current-1),i=e+t.defaultPageSize;t.reportResults.slice(e,i).forEach(function(e,i){t.availableVersionsLimits[i]=e.availableVersions.length})},t.isResultNotEmpty=function(){return!_.isEmpty(t.reportResults)},t.reset=function(){t.reportResults=[],t.afterSearch=!1},t.search=function(i,n,o,r){e.getBuiltArtifactsInProject(i,n,o,r).then(function(e){t.reportResults=e,t.sortKey=t.defaultSortKey,t.reverse=t.defaultReverse,t.afterSearch=!0,t.reportResults=_.chain(t.reportResults).sortBy(function(e){return e[t.defaultSortKey]}).value()},function(){t.reportResults=[]})},t.sort=function(e){t.sortKey=e,t.reverse=!t.reverse}}])}(),function(){"use strict";angular.module("pnc.scm-repositories").component("pncScmRepositoriesList",{bindings:{scmRepositories:"<",displayFields:"<?",hideHead:"<?"},templateUrl:"scm-repositories/components/pnc-scm-repositories-list/pnc-scm-repositories-list.html",controller:[function(){var e=this,t=["name","internalScmUrl","externalScmUrl","preBuildSync"];e.showTable=function(){return e.items&&e.items.length},e.showColumn=function(t){return e.fields.includes(t)},e.$onInit=function(){e.items=e.scmRepositories,e.fields=e.displayFields||t},e.$onChanges=function(t){t.scmRepositories&&(e.items=e.scmRepositories)}}]})}(),function(){"use strict";angular.module("pnc.scm-repositories").component("pncScmRepositoryLink",{bindings:{scmRepository:"<"},templateUrl:"scm-repositories/components/pnc-scm-repository-link/pnc-scm-repository-link.html",controller:["ScmRepositoryResource",function(e){var t=this;t.$onInit=function(){angular.isFunction(t.scmRepository.getName)||(t.scmRepository=new e(t.scmRepository))}}]})}(),function(){"use strict";angular.module("pnc.scm-repositories").component("pncScmRepositoryCreatePage",{bindings:{},templateUrl:"scm-repositories/create/pnc-scm-repository-create-page.html",controller:["$state","ScmRepositoryResource","$scope","events",function(e,t,i,n){const o=this;o.startCreating=function(l){o.isCreatingInProgress=!0,function(l){t.createAndSync(l).then(function(t){let o=t.data.repository;o&&o.id?r(o.id):i.$on(n.SCM_REPOSITORY_CREATION_SUCCESS,function(t,i){"scm-repositories.create"===e.$current.name&&r(i.id)})}).catch(function(){o.isCreatingInProgress=!1})}(l)},o.reset=function(e){e&&(e.$setPristine(),e.$setUntouched(),o.scmRepository=new t)},o.scmRepository={},o.isCreatingInProgress=!1,void 0===o.scmRepository.preBuildSyncEnabled&&(o.scmRepository.preBuildSyncEnabled=!0);function r(t){e.go("scm-repositories.detail",{scmRepositoryId:t})}}]})}(),function(){"use strict";angular.module("pnc.scm-repositories").component("pncScmRepositoryDetailPage",{bindings:{scmRepository:"<",buildConfigs:"<"},templateUrl:"scm-repositories/detail/pnc-scm-repository-detail-page.html",controller:["$state","paginator",function(e,t){const i=this;function n(){e.go("scm-repositories.detail",{scmRepositoryId:i.scmRepository.id},{reload:!0})}i.cancel=function(){n()},i.update=function(){i.scmRepository.$update().finally(n)},i.buildConfigurations={page:null,displayFields:["name","project","buildStatus"]},i.$onInit=function(){i.buildConfigurations.page=t(i.buildConfigs)}}]})}(),function(){"use strict";angular.module("pnc.scm-repositories").component("pncScmRepositoriesListPage",{bindings:{scmRepositories:"<"},templateUrl:"scm-repositories/list/pnc-scm-repositories-list-page.html",controller:["filteringPaginator","SortHelper",function(e,t){var i=this;i.scmRepositoriesFilteringFields=[{id:"internalUrl",title:"Internal URL",placeholder:"Filter by Internal URL",filterType:"text"},{id:"externalUrl",title:"External URL",placeholder:"Filter by External URL",filterType:"text"}],i.scmRepositoriesSortingFields=[{id:"internalUrl",title:"Internal URL"},{id:"externalUrl",title:"External URL"}],i.$onInit=function(){i.scmRepositoriesFilteringPage=e(i.scmRepositories),i.scmRepositoriesSortingConfigs=t.getSortConfig("scmRepositoriesList")}}]})}(),function(){"use strict";var e=angular.module("pnc");e.factory("unwrapPageResponseInterceptor",function(){return{response:function(e){return e.data.content&&!_.isArray(e.data.content)&&(e.data=e.data.content),e}}}),e.factory("httpResponseInterceptor",["$q","$log","pncNotify","keycloak",function(e,t,i,n){return{response:function(e){var n=e.config.successNotification;return angular.isUndefined(n)?function(e){"GET"!==e.config.method&&(t.debug("HTTP response: %O",e),i.success("Request successful"))}(e):angular.isFunction(n)?n(e):angular.isString(n)&&i.success(n),e},responseError:function(o){switch(o.status){case 0:i.error("Unable to connect to server");break;case 401:n.login();break;case 404:var r=o.config.error404Notification;(angular.isUndefined(r)||r)&&i.error("Requested resource not found");break;default:!function(e){var n;if(!(e&&e.data&&e.data.errorMessage))return i.error("PNC REST Api returned an error in an invalid format: "+e.status+" "+e.statusText),t.error("PNC REST Api returned an error in an invalid format: response: %O",e),e;(n=e.data).errorMessage.length>120&&(n.errorMessage=n.errorMessage.substring(0,119)+" ..."),i.error(n.errorMessage),t.error('PNC REST API returned the following error: type: "%s", message: "%s", details: "%s"',n.errorType,n.errorMessage,n.details)}(o)}return e.reject(o)}}}])}(),angular.module("pnc").run(["$templateCache",function(e){"use strict";e.put("artifacts/components/pnc-artifact-link/pnc-artifact-link.html",' <a ui-sref="artifacts.detail({ id: $ctrl.artifact.id })" href ng-transclude>{{ ::$ctrl.artifact.identifier }}</a>'),e.put("artifacts/detail/pnc-artifacts-detail-page.html",' <div class="resource-details"> <div class="row"> <div class="col-md-12"> <pnc-header> <pnc-header-title>{{ $ctrl.artifact.identifier }}</pnc-header-title> </pnc-header> </div> </div> <div class="row"> <div class="col-lg-6"> <h3 class="hidden visible-lg visible-xl">Details</h3> <dl class="dl-horizontal properties-list artifact-properties"> <dt>Filename</dt> <dd>{{ $ctrl.artifact.filename }}</dd> <dt>Size</dt> <dd> {{ $ctrl.artifact.size | fileSize }}</dd> <dt>Quality</dt> <dd>{{ $ctrl.artifact.artifactQuality }}</dd> <dt>Import Date</dt> <dd>{{ ($ctrl.artifact.importDate | date : \'short\') || \'n/a\'}}</dd> <dt>Build</dt> <dd> <span ng-if="$ctrl.build"><pnc-build-link build="$ctrl.build" short-link="false"></pnc-build-link></span> <span ng-if="!$ctrl.build">n/a</span> </dd> </dl> </div> <div class="col-lg-6"> <h3>Checksums</h3> <dl class="dl-horizontal properties-list artifact-properties"> <dt>md5</dt> <dd>{{ $ctrl.artifact.md5 }}</dd> <dt>sha1</dt> <dd> {{ $ctrl.artifact.sha1 }}</dd> <dt>sha256</dt> <dd>{{ $ctrl.artifact.sha256 }}</dd> </dl> </div> <div class="col-md-12"> <h3>Locations</h3> <dl class="dl-horizontal properties-list artifact-properties"> <dt>Public URL</dt> <dd><a ng-href="{{ $ctrl.artifact.publicUrl }}" ng-bind="$ctrl.artifact.publicUrl"></a></dd> <dt>Origin URL</dt> <dd><a ng-href="{{ $ctrl.artifact.originUrl }}" ng-bind="$ctrl.artifact.originUrl"></a></dd> <dt>Deploy URL</dt> <dd><a ng-href="{{ $ctrl.artifact.deployUrl }}" ng-bind="$ctrl.artifact.deployUrl"></a></dd> </dl> </div> <div class="col-lg-6"> <h3>Target Repository</h3> <dl class="dl-horizontal properties-list artifact-properties"> <dt>Identifier</dt> <dd>{{ $ctrl.artifact.targetRepository.identifier }}</dd> <dt>Type</dt> <dd>{{ $ctrl.artifact.targetRepository.repositoryType }}</dd> <dt>Temporary</dt> <dd>{{ $ctrl.artifact.targetRepository.temporaryRepo }}</dd> <dt>Path</dt> <dd>{{ $ctrl.artifact.targetRepository.repositoryPath }}</dd> </dl> </div> <div class="col-lg-6"> <h3>Usages</h3> <pnc-builds-data-table page="$ctrl.usages" display-fields="$ctrl.buildListDisplayFields"></pnc-builds-data-table> </div> </div> </div>'),e.put("artifacts/list/pnc-artifacts-data-table.html",' <div class="row"> <pnc-toolbar filtering-page="$ctrl.artifactsFilteringPage" filtering-fields="$ctrl.artifactsFilteringFields" sorting-fields="$ctrl.artifactsSortingFields" sorting-configs="$ctrl.artifactsSortingConfigs"></pnc-toolbar> </div> <div> <pnc-artifacts-list artifacts="$ctrl.artifactsFilteringPage.data"></pnc-artifacts-list> <pnc-page-controls pnc-page="$ctrl.artifactsFilteringPage" class="pull-right"></pnc-page-controls> </div> '),e.put("artifacts/list/pnc-artifacts-list-page.html",' <div class="m-t-20"> <pnc-artifacts-data-table artifacts="$ctrl.artifacts"></pnc-artifacts-data-table> </div>'),e.put("artifacts/list/pnc-artifacts-list.html",' <table class="table table-bordered table-striped table-hover"> <thead> <th>Identifier</th> <th>Quality</th> <th>File Name</th> <th>Repository Type</th> <th>Checksums</th> <th>Actions</th> </thead> <tbody> <tr ng-repeat="artifact in $ctrl.artifacts"> <td><pnc-artifact-link artifact="artifact"></pnc-artifact-link></td> <td>{{ artifact.artifactQuality }}</td> <td>{{ artifact.filename }}</td> <td>{{ artifact.targetRepository.repositoryType }}</td> <td> <div class="checksum checksum-md5"> {{ artifact.md5 }} </div> <div class="checksum checksum-sha1"> {{ artifact.sha1 }} </div> <div class="checksum checksum-sha256"> {{ artifact.sha256 }} </div> </td> <td class="td-actions"> <div class="btn-group" role="group" aria-label="Row Actions"> <a ng-href="{{ artifact.publicUrl }}" target="_self" class="btn btn-default">Download</a> </div> </td> </tr> </tbody> </table>'),e.put("build-configs/detail/build-metrics-tab/pnc-build-config-build-metrics-tab.html",' <div class="row"> <div class="col-md-12"> <pnc-build-metrics builds="$ctrl.buildsData" chart-type="line" component-id="line1"></pnc-build-metrics> <pnc-build-metrics builds="$ctrl.buildsData" chart-type="horizontalBar" component-id="horizontalBar1"></pnc-build-metrics> </div> </div> '),e.put("build-configs/detail/dependants-tab/pnc-build-config-dependants-tab.html",' <div class="row"> <div class="col-md-12"> <pnc-build-configs-data-table page="$ctrl.dependants" hide-actions="true" on-remove="$ctrl.onRemove"></pnc-build-configs-data-table> </div> </div>'),e.put("build-configs/detail/dependencies-tab/pnc-build-config-dependencies-tab.html",' <div class="row"> <div class="col-md-12"> <pnc-build-configs-data-table page="$ctrl.dependencies" on-remove="$ctrl.onRemove" on-edit="$ctrl.onEdit" refresh-build-configs="$ctrl.refreshDependencies"></pnc-build-configs-data-table> </div> </div> '),e.put("build-configs/detail/details-tab/pnc-build-config-details-editor.html",' <form name="editBuildConfigForm" class="build-config-edit-form"> <div class="row"> <div class="col-md-12"> <div class="row"> <div class="col-md-12"> <pnc-create-build-config-general-form ng-model="$ctrl.formData.general"></pnc-create-build-config-general-form> <div class="form-group" ng-class="{ \'has-error\' : editBuildConfigForm.scmRepository.$invalid && editBuildConfigForm.scmRepository.$touched, \'has-success\': editBuildConfigForm.scmRepository.$valid && editBuildConfigForm.scmRepository.$touched }"> <label class="control-label required">SCM Repository</label> <pnc-scm-repository-combobox name="scmRepository" ng-model="$ctrl.formData.scmRepository" required></pnc-scm-repository-combobox> <span class="help-block" ng-show="editBuildConfigForm.scmRepository.$invalid && editBuildConfigForm.scmRepository.$touched">Required field.</span> </div> <div class="form-group" ng-class="{ \'has-error\' : editBuildConfigForm.scmRevision.$invalid && editBuildConfigForm.scmRevision.$touched, \'has-success\': editBuildConfigForm.scmRevision.$valid && editBuildConfigForm.scmRevision.$touched }"> <label for="scm-revision" class="control-label required">SCM Revision</label> <input type="text" id="scm-revision" class="form-control" name="scmRevision" maxlength="255" ng-model="$ctrl.formData.general.scmRevision" required> <span class="help-block" ng-show="editBuildConfigForm.scmRevision.$invalid && editBuildConfigForm.scmRevision.$touched">Required field.</span> </div> <div class="form-group" ng-class="{ \'has-error\': editBuildConfigForm.product.$invalid && editBuildConfigForm.product.$touched, \'has-success\': editBuildConfigForm.product.$touched && editBuildConfigForm.version.$touched }"> <label class="control-label">Product</label> <pnc-product-combobox name="product" ng-change="$ctrl.checkVersionData()" ng-model="$ctrl.formData.product"> </pnc-product-combobox> </div> <div class="form-group" ng-if="$ctrl.formData.product && $ctrl.formData.product.id" ng-class="{ \'has-error\' : editBuildConfigForm.version.$invalid && editBuildConfigForm.version.$touched, \'has-success\': editBuildConfigForm.product.$touched && editBuildConfigForm.version.$touched }"> <label class="control-label required">Version</label> <pnc-product-version-combobox name="version" product="$ctrl.formData.product" ng-model="$ctrl.formData.productVersion"> </pnc-product-version-combobox> <p ng-show="editBuildConfigForm.version.$invalid && editBuildConfigForm.version.$touched" class="help-block"> Version is a required field if you selected any product.</p> </div> </div> </div> <div class="row"> <div class="col-md-12"> <label class="text-divider">Build Parameters</label> <pnc-select-build-parameters ng-model="$ctrl.formData.parameters"></pnc-select-build-parameters> <hr class="m-t-20" ng-if="$ctrl.numberOfBuildParameters() > 0"> </div> </div> <div class="row"> <div class="col-md-12"> <pf-form-buttons pf-on-cancel="$ctrl.cancel()" pf-on-save="$ctrl.submit($ctrl.formData)" pf-working="$ctrl.working"></pf-form-buttons> </div> </div> </div> </div> </form> '),e.put("build-configs/detail/details-tab/pnc-build-config-details-tab.html",' <div class="row"> <div class="col-md-12 edit-container"> <div class="btn-toolbar pull-right" role="toolbar" aria-label="..."> <div class="btn-group" role="group" aria-label="..."> <button type="button" class="btn btn-default" uib-tooltip="Edit Build Config" tooltip-placement="top" tooltip-append-to-body="true" tooltip-popup-delay="2500" ng-click="$ctrl.toggleEdit()" pnc-requires-auth><i class="pficon pficon-edit"></i> Edit</button> </div> </div> <pnc-inline-notification name="edit-build-config"></pnc-inline-notification> <div ng-if="!$ctrl.isEditModeActive()"> <pnc-build-config-properties build-config="$ctrl.buildConfig"></pnc-build-config-properties> </div> <div ng-if="$ctrl.isEditModeActive()"> <div> <pnc-build-config-details-editor build-config="$ctrl.buildConfig" on-success="$ctrl.onSuccess(buildConfig)" on-cancel="$ctrl.onCancelEdit()"></pnc-build-config-details-editor> </div> </div> </div> </div> '),e.put("build-configs/detail/details-tab/pnc-build-config-properties.html",' <div> <dl class="dl-horizontal"> <dt>Project</dt> <dd> <a ui-sref="projects.detail({projectId: $ctrl.buildConfig.project.id})" ng-bind="$ctrl.buildConfig.project.name" href></a> </dd> <dt ng-hide="$ctrl.hideField(\'creationTime\')">Created</dt> <dd ng-hide="$ctrl.hideField(\'creationTime\')">{{ $ctrl.buildConfig.creationTime | date : \'medium\' }}</dd> <dt ng-hide="$ctrl.hideField(\'creationUser\')">Created by</dt> <dd ng-hide="$ctrl.hideField(\'creationUser\')"> <span ng-if="$ctrl.buildConfig.creationUser">{{ $ctrl.buildConfig.creationUser.username }}</span> <span ng-if="!$ctrl.buildConfig.creationUser">&mdash;</span> </dd> <dt ng-hide="$ctrl.hideField(\'modificationTime\')">Modified</dt> <dd ng-hide="$ctrl.hideField(\'modificationTime\')">{{ $ctrl.buildConfig.modificationTime | date : \'medium\' }}</dd> <dt ng-hide="$ctrl.hideField(\'modificationUser\')">Modified by</dt> <dd ng-hide="$ctrl.hideField(\'modificationUser\')"> <span ng-if="$ctrl.buildConfig.modificationUser">{{ $ctrl.buildConfig.modificationUser.username }}</span> <span ng-if="!$ctrl.buildConfig.modificationUser">&mdash;</span> </dd> <dt ng-hide="$ctrl.hideField(\'description\')">Description</dt> <dd ng-hide="$ctrl.hideField(\'description\')">{{ $ctrl.buildConfig.description }}</dd> <dt ng-hide="$ctrl.hideField(\'buildType\')">Build Type</dt> <dd ng-hide="$ctrl.hideField(\'buildType\')">{{ $ctrl.buildConfig.buildType }}</dd> <dt ng-hide="$ctrl.hideField(\'environment\')">Environment</dt> <dd ng-hide="$ctrl.hideField(\'environment\')">{{ $ctrl.buildConfig.environment.name }}</dd> <dt ng-hide="$ctrl.hideField(\'scmRepository\')">SCM Repository</dt> <dd ng-hide="$ctrl.hideField(\'scmRepository\')"> <pnc-scm-repository-link scm-repository="$ctrl.buildConfig.scmRepository"></pnc-scm-repository-link> </dd> <dt ng-hide="$ctrl.hideField(\'scmRevision\')">Revision</dt> <dd ng-hide="$ctrl.hideField(\'scmRevision\')">{{ $ctrl.buildConfig.scmRevision }}</dd> <dt ng-hide="$ctrl.hideField(\'buildScript\')">Build Script</dt> <dd ng-hide="$ctrl.hideField(\'buildScript\')"> <pre class="build-script" id="input-build-script">{{ $ctrl.buildConfig.buildScript || \'Empty\' }}</pre> </dd> <dt ng-hide="$ctrl.hideField(\'productVersion\')">Product Version</dt> <dd ng-hide="$ctrl.hideField(\'productVersion\')"> <pnc-product-version-link product-version="$ctrl.buildConfig.productVersion"></pnc-product-version-link> </dd> <dt ng-hide="$ctrl.hideField(\'parameters\')">Parameters</dt> <dd ng-hide="$ctrl.hideField(\'parameters\')"> <div ng-repeat="(key, value) in $ctrl.buildConfig.parameters"> <span>{{ key }}</span><br> <span class="text-monospace"> <pre class="build-script">{{ value }}</pre> </span> </div> </dd> </dl> </div> '),e.put("build-configs/detail/group-configs-tab/pnc-build-config-group-configs-tab.html",' <div class="row"> <pnc-toolbar filtering-page="$ctrl.groupConfigsFilteringPage" filtering-fields="$ctrl.groupConfigsFilterFields" sorting-fields="$ctrl.groupConfigsSortingFields" sorting-configs="$ctrl.groupConfigsSortingConfigs"></pnc-toolbar> </div> <div> <pnc-group-configs-list group-configs="$ctrl.groupConfigsFilteringPage.data"></pnc-group-configs-list> <pnc-page-controls class="pull-right m-b-10" pnc-page="$ctrl.groupConfigsFilteringPage" ng-if="$ctrl.groupConfigsFilteringPage"></pnc-page-controls> </div>'),e.put("build-configs/detail/pnc-build-config-detail-main.html",' <div class="row"> <div class="col-md-12"> <pnc-header class="no-divider-header"> <pnc-header-title>{{ $ctrl.buildConfig.name }}</pnc-header-title> <pnc-header-buttons> <pnc-build-start build-config="$ctrl.buildConfig"></pnc-build-start> <button type="button" class="btn btn-lg btn-default" uib-tooltip="Clone Build Config" tooltip-placement="top" tooltip-append-to-body="true" tooltip-popup-delay="2500" ng-click="$ctrl.clone()" pnc-requires-auth><i class="fa fa-files-o"></i> Clone</button> <button ng-if="false" type="button" class="btn btn-lg btn-default" uib-tooltip="Edit Build Config" tooltip-placement="top" tooltip-append-to-body="true" tooltip-popup-delay="2500" ng-click="$ctrl.edit()" pnc-requires-auth><i class="pficon pficon-edit"></i> Edit</button> </pnc-header-buttons> </pnc-header> </div> </div> <div class="row"> <div class="col-md-12"> <ul class="nav nav-tabs nav-tabs-pf"> <li ui-sref-active="active"><a href ui-sref="projects.detail.build-configs.detail.default" ui-sref-opts="{reload:true}">Details</a></li> <li ui-sref-active="active"><a href ui-sref="projects.detail.build-configs.detail.dependencies">Dependencies</a></li> <li ui-sref-active="active"><a href ui-sref="projects.detail.build-configs.detail.dependants">Dependants</a></li> <li ui-sref-active="active"><a href ui-sref="projects.detail.build-configs.detail.group-configs">Group Configs</a></li> <li ui-sref-active="active"><a href ui-sref="projects.detail.build-configs.detail.revisions">Revisions</a></li> <li ui-sref-active="active"><a href ui-sref="projects.detail.build-configs.detail.build-metrics">Build Metrics</a></li> </ul> <div class="m-t-20" ui-view></div> </div> </div> '),e.put("build-configs/detail/revisions-tab/pnc-build-config-revision-link.html",' <a href ui-sref="projects.detail.build-configs.detail.revisions.detail({ projectId: $ctrl.revision.project.id, configurationId: $ctrl.revision.id, revisionId: $ctrl.revision.rev  })" ng-bind="($ctrl.revision.modificationTime | date : \'medium\')|| $ctrl.revision.rev"></a> '),e.put("build-configs/detail/revisions-tab/pnc-build-config-revisions-tab.html",' <section class="master-detail revisions-tab"> <nav class="master" ui-view="master"> </nav> <main class="detail" ui-view="detail"> </main> </section> '),e.put("build-configs/detail/revisions-tab/pnc-revisions-details.html",' <div> <div class="btn-toolbar pull-right" role="toolbar" aria-label="Revisions toolbar"> <div class="btn-group" role="group" aria-label="revisions buttons"> <button type="button" class="btn btn-default" uib-tooltip="Restore current revision" tooltip-placement="top" tooltip-append-to-body="true" tooltip-popup-delay="2500" ng-click="$ctrl.restore()" pnc-requires-auth><i class="pficon pficon-restart"></i> Restore</button> </div> </div> <pnc-build-config-properties hide-fields="$ctrl.hideFields" build-config="$ctrl.revision"></pnc-build-config-properties> </div>'),e.put("build-configs/detail/revisions-tab/pnc-revisions-vertical-nav.html",' <nav> <ul class="list-unstyled"> <li ng-repeat="revision in $ctrl.revisions.data" ui-sref-active="active"><pnc-build-config-revision-link revision="revision"></pnc-build-config-revision-link></li> </ul> </nav>'),e.put("build-configs/detail/sidebar/pnc-build-config-detail-sidebar.html",' <div class="push-down"> <pnc-build-config-sidebar-history-widget builds="$ctrl.builds" build-config="$ctrl.buildConfig"></pnc-build-config-sidebar-history-widget> </div> '),e.put("build-configs/detail/sidebar/pnc-build-config-sidebar-history-widget.html",' <div class="panel panel-default build-panel"> <div class="panel-heading"> <div class="spinner spinner-sm pull-right" ng-hide="$ctrl.page.isLoaded"></div> <h3 class="panel-title">Build History</h3> </div> <table class="table table-striped table-hover" ng-show="$ctrl.page.data.length"> <tbody> <tr ng-repeat="build in $ctrl.page.data"> <td> <pnc-build-status build="build" is-loaded="$ctrl.page.isLoaded"></pnc-build-status> </td> </tr> </tbody> </table> <div class="panel-body" ng-hide="$ctrl.page.data.length || !$ctrl.page.isLoaded"> No builds </div> <pnc-page-controls class="pull-right" pnc-page="$ctrl.page" ng-if="$ctrl.page"></pnc-page-controls> </div> '),e.put("build-configs/directives/pnc-build-configs-data-table/pnc-build-configs-data-table.html",' <script type="text/ng-template" id="pnc-build-configs-data-table-actions.html"> <div class="btn-group" role="group" aria-label="Item Actions">\n    <button class="btn btn-block btn-default" uib-tooltip="Remove Build Configuration" tooltip-popup-delay="2500" tooltip-placement="top" tooltip-append-to-body="true" pnc-confirm-click="actions.remove(buildConfig)" pnc-confirm-message="{{ \'Confirm the removal of Build Configuration: \' + buildConfig.name +  \' ?\'}}">Remove</button>\n  </div> <\/script> <div class="row"> <pnc-toolbar filtering-page="$ctrl.filterPage" filtering-fields="$ctrl.filterFields" sorting-fields="$ctrl.sortingFields" sorting-configs="$ctrl.sortingConfigs" actions-config="$ctrl.toolbarActions"></pnc-toolbar> </div> <div> <pnc-build-configs-list build-configs="$ctrl.filterPage.data" display-fields="$ctrl.displayFields" ng-attr-actions-template-url="{{ !$ctrl.hideActions && \'pnc-build-configs-data-table-actions.html\' || undefined }}" actions-data="$ctrl.actions"></pnc-build-configs-list> <pnc-page-controls class="pull-right m-t-10 m-b-10" pnc-page="$ctrl.filterPage" ng-if="$ctrl.filterPage"></pnc-page-controls> </div> '),e.put("build-configs/directives/pnc-build-configs-list/pnc-build-configs-list.html",' <table class="table table-bordered table-striped table-hover build-status-table actions-table" ng-show="$ctrl.showTable()"> <thead> <th ng-if="::$ctrl.showColumn(\'name\')">Name</th> <th ng-if="::$ctrl.showColumn(\'description\')">Description</th> <th ng-if="::$ctrl.showColumn(\'project\')">Project</th> <th ng-if="::$ctrl.showColumn(\'creationTime\')">Created</th> <th ng-if="::$ctrl.showColumn(\'modificationTime\')">Modified</th> <th ng-if="::$ctrl.showColumn(\'buildStatus\')">Build Status</th> <th ng-if="::$ctrl.actionsTemplateUrl">Actions</th> </thead> <tbody> <tr ng-repeat="buildConfig in $ctrl.buildConfigs"> <td ng-if="$ctrl.showColumn(\'name\')"> <a ui-sref="projects.detail.build-configs.detail({ projectId: buildConfig.project.id, configurationId: buildConfig.id })" href> {{ buildConfig.name }} </a> </td> <td ng-if="::$ctrl.showColumn(\'description\')" title="{{ buildConfig.description }}">{{ buildConfig.description | limitTo: 100 }}{{ buildConfig.description.length &gt; 100 ? \'…\' : \'\' }}</td> <td ng-if="::$ctrl.showColumn(\'project\')"> <a ui-sref="projects.detail({ projectId: buildConfig.project.id })" href> {{ buildConfig.project.name }} </a> </td> <td ng-if="::$ctrl.showColumn(\'creationTime\')">{{ buildConfig.creationTime | date:\'medium\' }}</td> <td ng-if="::$ctrl.showColumn(\'modificationTime\')">{{ buildConfig.modificationTime | date:\'medium\' }}</td> <td ng-if="::$ctrl.showColumn(\'buildStatus\')"> <pnc-build-config-status-icon build-config="buildConfig"></pnc-build-config-status-icon> </td> <td ng-if="::$ctrl.actionsTemplateUrl" ng-include="::$ctrl.actionsTemplateUrl"></td> </tr> </tbody> </table> <table ng-hide="$ctrl.showTable()" class="table table-bordered table-striped table-hover build-status-table actions-table"> <tbody> <tr> <td class="text-center p-t-10 p-b-10"><em>There are no Build Configs to display</em></td> </tr> </tbody> </table> '),e.put("build-configs/directives/pnc-create-build-config-button/pnc-create-build-config-button.html",' <button type="button" class="btn btn-lg btn-default" uib-tooltip="Create a new build configuration" tooltip-popup-delay="3500" tooltip-placement="top" tooltip-append-to-body="true" ng-click="$ctrl.openWizardModal()" pnc-requires-auth> <i class="fa fa-file-text-o"></i> Create </button> '),e.put("build-configs/directives/pnc-create-build-config-general-form/pnc-create-build-config-general-form.html",' <ng-form name="form" novalidate> <div class="form-group" ng-class="{ \'has-error\' : form.name.$invalid && form.name.$touched, \'has-success\': form.name.$valid && form.name.$touched }"> <label class="required control-label" for="build-config-name">Name</label> <input id="build-config-name" name="name" class="form-control" ng-model="$ctrl.data.name" type="text" ng-maxlength="255" ng-pattern="/^[a-zA-Z0-9_.][a-zA-Z0-9_.-]*(?!\\.git)+$/" spellcheck="false" required> <p ng-show="form.name.$invalid && form.name.$touched" class="help-block">Name is a required field.</p> <p ng-show="form.name.$error.pattern && form.name.$touched" class="help-block">Name can contain only alpha-numeric characters, hyphens, underscores and periods and cannot start with a hyphen.</p> <p ng-show="form.name.$error.maxlength && form.name.$touched" class="help-block">The maximum lengh of a name is 255 characters.</p> </div> <div class="form-group"> <label class="control-label" for="build-config-description">Description</label> <textarea id="build-config-description" name="description" class="form-control" ng-model="$ctrl.data.description"></textarea> </div> <div class="form-group" ng-class="{ \'has-error\' : form.environment.$invalid && form.environment.$touched, \'has-success\': form.environment.$valid && form.environment.$touched }"> <label class="control-label required" for="build-config-environment">Environment</label> <pnc-environment-combobox name="environment" ng-model="$ctrl.data.environment" required></pnc-environment-combobox> <p ng-show="form.environment.$invalid && form.environment.$touched" class="help-block">Environment is a required field.</p> </div> <div class="form-group" ng-class="{ \'has-error\' : form.buildType.$invalid && form.buildType.$touched, \'has-success\': form.buildType.$valid && form.buildType.$touched }"> <label class="control-label required" for="build-config-build-type">Build Type</label> <br> <select name="buildType" pf-bootstrap-select="{ noneSelectedText: \'Select Build Type\' }" ng-model="$ctrl.data.buildType" id="build-config-build-type" ng-options="buildType.id as buildType.name for buildType in $ctrl.buildTypes" required></select> <p ng-show="form.buildType.$invalid && form.buildType.$touched" class="help-block">Build Type is a required field.</p> </div> <div class="form-group" ng-class="{ \'has-error\' : form.buildScript.$invalid && form.buildScript.$touched, \'has-success\': form.buildScript.$valid && form.buildScript.$touched }"> <label class="control-label required" for="build-config-build-script">Build Script</label> <textarea id="build-config-build-script" name="buildScript" class="form-control" spellcheck="false" ng-model="$ctrl.data.buildScript" spellcheck="false" pnc-build-script-validator required></textarea> <p ng-show="form.buildScript.$invalid && form.buildScript.$touched" class="help-block">Build Script is a required field.</p> <p class="help-block" ng-show="form.buildScript.$error.invalidBuildScript && form.buildScript.$touched">The \'deploy\' goal is required for maven builds in order to prevent artifact promotion issues.</p> </div> </ng-form> '),e.put("build-configs/directives/pnc-create-build-config-product-version-form/pnc-create-build-config-product-version-form.html",' <ng-form name="$ctrl.productVersionForm" novalidate> <div class="form-group"> <label class="control-label">Product</label> <pnc-product-combobox name="product" ng-change="$ctrl.checkVersionData()" ng-model="$ctrl.data.product"> </pnc-product-combobox> </div> <div class="form-group" ng-if="$ctrl.data.product && $ctrl.data.product.id" ng-class="{ \'has-error\' : $ctrl.productVersionForm.version.$invalid && $ctrl.productVersionForm.version.$touched, \'has-success\': $ctrl.productVersionForm.version.$touched && $ctrl.productVersionForm.version.$touched }"> <label class="control-label required">Version</label> <pnc-product-version-combobox name="version" product="$ctrl.data.product" ng-model="$ctrl.data.version" required> </pnc-product-version-combobox> <p ng-show="$ctrl.productVersionForm.$invalid && $ctrl.productVersionForm.version.$touched" class="help-block"> Version is a required field if you selected any product.</p> </div> </ng-form> '),e.put("build-configs/directives/pnc-create-build-config-wizard/pnc-create-build-config-wizard.html",' <pf-wizard title="Create Build Config" next-title="$ctrl.nextButtonTitle" on-cancel="$ctrl.onClose()" on-step-changed="$ctrl.onStepChange(step, index)" on-finish="$ctrl.onClose()" wizard-done="$ctrl.wizardDone" content-height="500"> <pf-wizard-step step-title="Project" substeps="true" step-id="project" step-priority="10" substeps="true" wz-disabled="true"> <pf-wizard-substep step-title="Select" step-id="projectSelect" step-priority="0"> <p>Select Project</p> </pf-wizard-substep> </pf-wizard-step> <pf-wizard-step step-title="Build Config" substeps="true" step-id="build-config" step-priority="20" substeps="true" show-review="true" show-review-details="true"> <pf-wizard-substep step-title="General" step-id="general" step-priority="10" next-enabled="$ctrl.generalForm.$valid" show-review="true" show-review-details="true" review-template="build-configs/directives/pnc-create-build-config-wizard/review-build-config-general.html"> <form name="$ctrl.generalForm" novalidate> <pnc-create-build-config-general-form ng-model="$ctrl.wizardData.general"></pnc-create-build-config-general-form> </form> </pf-wizard-substep> <pf-wizard-substep step-title="Product Version" step-id="productVersion" next-enabled="!$ctrl.wizardData.productVersion.product || $ctrl.productVersionForm.$valid" step-priority="15" show-review="true" show-review-details="true" review-template="build-configs/directives/pnc-create-build-config-wizard/review-product-version.html"> <form name="$ctrl.productVersionForm" novalidate> <pnc-create-build-config-product-version-form ng-model="$ctrl.wizardData.productVersion"> </pnc-create-build-config-product-version-form> </form> </pf-wizard-substep> <pf-wizard-substep step-title="Build Parameters" next-enabled="true" step-id="parameters" step-priority="20" show-review="true" show-review-details="false" review-template="build-configs/directives/pnc-create-build-config-wizard/review-build-parameters.html"> <pnc-select-build-parameters ng-model="$ctrl.wizardData.buildParameters"></pnc-select-build-parameters> </pf-wizard-substep> <pf-wizard-substep step-title="Dependencies" next-enabled="true" step-id="parameters" step-priority="30" show-review="true" show-review-details="false" review-template="build-configs/directives/pnc-create-build-config-wizard/review-dependencies.html"> <pnc-select-build-configs ng-model="$ctrl.wizardData.dependencies"></pnc-select-build-configs> </pf-wizard-substep> </pf-wizard-step> <pf-wizard-step step-title="Repository" substeps="true" step-id="repository" step-priority="30" next-enabled="$ctrl.repoForm.$valid" substeps="true" show-review="true" show-review-details="false" review-template="build-configs/directives/pnc-create-build-config-wizard/review-repo-config.html"> <pf-wizard-substep step-title="Select" step-id="repositorySelect" step-priority="10"> <form name="$ctrl.repoForm" novalidate> <pnc-select-repository ng-model="$ctrl.wizardData.repoConfig"></pnc-select-repository> </form> </pf-wizard-substep> </pf-wizard-step> <pf-wizard-step step-title="Review" substeps="true" step-id="review" step-priority="40"> <pf-wizard-substep step-title="Summary" step-id="review-summary" step-priority="10" next-enabled="true" prev-enabled="true" ok-to-nav-away="true" wz-disabled="false" on-show="$ctrl.onShowReviewSummary"> <pf-wizard-review-page shown="$ctrl.reviewPageShown" wizard-data="$ctrl.wizardData"></pf-wizard-review-page> </pf-wizard-substep> <pf-wizard-substep step-title="Create" step-id="review-create" step-priority="20" wz-disabled="false" on-show="$ctrl.create"> <div class="wizard-pf-contents" ng-if="!$ctrl.wizardDone && !$ctrl.createError"> <div class="wizard-pf-process blank-slate-pf"> <div class="spinner spinner-lg blank-slate-pf-icon"></div> <h5 class="blank-slate-pf-main-action">Creating Build Config<span ng-hide="$ctrl.wizardData.repoConfig.useExistingRepoConfig"> and SCM Repository, this may take several minutes.</span></h5> </div> <ul class="list-unstyled"> <li ng-repeat="message in $ctrl.createStatusMessages">{{ message }}</li> </ul> </div> <div class="wizard-pf-contents" ng-if="$ctrl.wizardDone && !$ctrl.createError"> <div class="wizard-pf-complete blank-slate-pf"> <div class="wizard-pf-success-icon"><span class="glyphicon glyphicon-ok-circle"></span></div> <h5 class="blank-slate-pf-main-action">Build Config Creation Successful</h5> <a role="button" class="btn btn-lg btn-primary" ui-sref="projects.detail.build-configs.detail({ projectId: $ctrl.wizardData.project.id, configurationId: $ctrl.createdBuildConfigId })" ng-click="$ctrl.onClose()" href>View Build Config</a> </div> </div> <div class="wizard-pf-contents" ng-if="$ctrl.createError"> <div class="wizard-pf-complete blank-slate-pf"> <div class="wizard-pf-error-icon"><span class="glyphicon glyphicon-remove-circle"></span></div> <h5 class="blank-slate-pf-main-action">Error</h5> <pnc-reopen-build-config-button initial-values="$ctrl.wizardData" ng-click="$ctrl.closePreviousWizardModal()"></pnc-reopen-build-config-button> </div> <ul class="list-unstyled"> <li ng-repeat="message in $ctrl.createStatusMessages">{{ message }}</li> </ul> </div> </pf-wizard-substep> </pf-wizard-step> </pf-wizard> '),e.put("build-configs/directives/pnc-create-build-config-wizard/review-build-config-general.html",' <form class="form"> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">Name:</span> <span class="wizard-pf-review-item-value">{{ $ctrl.wizardData.general.name }}</span> </div> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">Description:</span> <span class="wizard-pf-review-item-value">{{ $ctrl.wizardData.general.description }}</span> </div> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">Environment:</span> <span class="wizard-pf-review-item-value">{{ $ctrl.wizardData.general.environment.name }}</span> </div> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">Build Type:</span> <span class="wizard-pf-review-item-value">{{ $ctrl.wizardData.general.buildType }}</span> </div> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">Build Script:</span><br> <span class="wizard-pf-review-item-value"><pre>{{ $ctrl.wizardData.general.buildScript }}</pre></span> </div> </form> '),e.put("build-configs/directives/pnc-create-build-config-wizard/review-build-parameters.html",' <form class="form"> <div class="wizard-pf-review-item" ng-repeat="(key, value) in $ctrl.wizardData.buildParameters"> <span class="wizard-pf-review-item-label">{{ key }}</span><br> <span class="wizard-pf-review-item-value text-monospace"><pre>{{ value }}</pre></span> </div> </form> '),e.put("build-configs/directives/pnc-create-build-config-wizard/review-dependencies.html",' <form class="form"> <div class="wizard-pf-review-item" ng-repeat="dependency in $ctrl.wizardData.dependencies"> <ul> <li><span class="wizard-pf-review-item-value">{{ dependency.name }}</span></li> </ul> </div> </form> '),e.put("build-configs/directives/pnc-create-build-config-wizard/review-product-version.html",' <form class="form"> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">Product Version:</span> <span class="wizard-pf-review-item-value"> <span ng-if="$ctrl.wizardData.productVersion">{{ $ctrl.wizardData.productVersion.version.product.name }} / v{{ $ctrl.wizardData.productVersion.version.version }}</span> <span ng-if="!$ctrl.wizardData.productVersion">None</span> </span> </div> </form> '),e.put("build-configs/directives/pnc-create-build-config-wizard/review-repo-config.html",' <form class="form"> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">SCM URL:</span> <span class="wizard-pf-review-item-value">{{ $ctrl.wizardData.repoConfig.scmUrl }}</span> </div> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">Revision:</span> <span class="wizard-pf-review-item-value">{{ $ctrl.wizardData.repoConfig.revision }}</span> </div> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">Pre-build sync:</span> <span class="wizard-pf-review-item-value">{{ $ctrl.wizardData.repoConfig.preBuildSyncEnabled }}</span> </div> <div class="wizard-pf-review-item"> <span class="wizard-pf-review-item-label">Existing Repo Config:</span> <span class="wizard-pf-review-item-value">{{ $ctrl.wizardData.repoConfig.useExistingRepoConfig }}</span> </div> </form> '),e.put("build-configs/directives/pnc-internal-external-url/pnc-internal-external-url.html",' <div class="panel panel-default"> <div class="panel-heading text-center"> <strong>SCM</strong><strong ng-hide="singleScm">s</strong> <small ng-hide="singleScm"><em>(at least of one of them must be specified)</em></small> </div> <div class="list-group"> <div class="list-group-item" ng-hide="singleScm"> <div class="text-center"> When the internal SCM is not specified, it will be cloned from the external one. </div> </div> <div class="list-group-item"> <div class="row" ng-hide="singleScm"> <div class="text-right-sm p-b-10" ng-class="sidebarClass"> <strong class="text-uppercase">Internal</strong> </div> </div> <div class="form-group" ng-class="{ \'has-error\': form.scmUrl.$invalid && form.scmUrl.$touched, \'has-success\': form.scmUrl.$valid && form.scmUrl.$touched }"> <div ng-if="!singleScm"> <label for="input-scm-repo-url" class="control-label" ng-class="sidebarClass">* Url</label> <div ng-class="contentClass"> <input type="text" id="input-scm-repo-url" class="form-control" name="scmUrl" maxlength="255" ng-model="data.scmUrl" ng-required="!data.externalScmUrl" pnc-scm-validator="git+ssh" pnc-exact-host="exactHost"> <span class="help-block" ng-show="form.scmUrl.$error.required && form.scmUrl.$touched">At least one of the SCMs is required.</span> <span class="help-block" ng-show="form.scmUrl.$error.invalidScmUrl"> <span ng-show="exactHost">Only R/W SCM with the following format <code>git+ssh://{{exactHost}}/&lt;repository-name&gt;.git</code> is allowed.</span> <span ng-hide="exactHost">Invalid or unsupported format (only git+ssh:// is supported).</span> </span> </div> </div> <div ng-if="singleScm"> <label for="input-scm-repo-url-single-scm" class="control-label" ng-class="sidebarClass">* Url</label> <div ng-class="contentClass"> <input type="text" id="input-scm-repo-url-single-scm" class="form-control" name="scmUrl" maxlength="255" ng-model="data.scmUrl" pnc-scm-validator="git|ssh|http|https|git+ssh|git@" required> <span class="help-block" ng-show="form.scmUrl.$error.required && form.scmUrl.$touched">Required field.</span> <span class="help-block" ng-show="form.scmUrl.$error.invalidScmUrl">Invalid or unsupported format.</span> </div> </div> </div> <div class="form-group" ng-class="{ \'has-error\': form.scmRevision.$invalid && form.scmRevision.$touched, \'has-success\': form.scmRevision.$valid && form.scmRevision.$touched }"> <label for="input-scm-revision" class="control-label" ng-class="sidebarClass">* Revision</label> <div ng-class="contentClass"> <input id="input-scm-revision" class="form-control" name="scmRevision" maxlength="255" ng-model="data.scmRevision" ng-required="data.scmUrl"> <span class="help-block" ng-show="form.scmRevision.$error.required && form.scmRevision.$touched">Required field.</span> </div> </div> </div> <div class="list-group-item" ng-hide="singleScm"> <div class="row"> <div class="text-right-sm p-b-10" ng-class="sidebarClass"> <strong class="text-uppercase">External</strong> </div> </div> <div class="form-group" ng-class="{ \'has-error\': form.externalScmUrl.$invalid && form.externalScmUrl.$touched, \'has-success\': form.externalScmUrl.$valid && form.externalScmUrl.$touched }"> <label for="input-scm-repo-url-external" class="control-label" ng-class="sidebarClass">* Url</label> <div ng-class="contentClass"> <input type="text" id="input-scm-repo-url-external" class="form-control" name="externalScmUrl" maxlength="255" ng-model="data.externalScmUrl" ng-required="!data.scmUrl" pnc-scm-validator="git|ssh|http|https|git+ssh|git@"> <span class="help-block" ng-show="form.externalScmUrl.$error.required && form.externalScmUrl.$touched">At least one of the SCMs is required.</span> <span class="help-block" ng-show="form.externalScmUrl.$error.invalidScmUrl">Invalid or unsupported format.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': form.externalScmRevision.$invalid && form.externalScmRevision.$touched, \'has-success\': form.externalScmRevision.$valid && form.externalScmRevision.$touched }"> <label for="input-scm-revision-external" class="control-label" ng-class="sidebarClass">* Revision</label> <div ng-class="contentClass"> <input id="input-scm-revision-external" class="form-control" name="externalScmRevision" maxlength="255" ng-model="data.externalScmRevision" ng-required="data.externalScmUrl"> <span class="help-block" ng-show="form.externalScmRevision.$error.required && form.externalScmRevision.$touched">Required field.</span> </div> </div> </div> </div> </div> '),e.put("build-configs/directives/pnc-reopen-build-config-button/pnc-reopen-build-config-button.html",' <button type="button" class="btn btn-lg btn-primary" uib-tooltip="Reopen wizard to correct submitted data" tooltip-popup-delay="3500" tooltip-placement="top" tooltip-append-to-body="true" ng-click="$ctrl.reopenWizardModal()" pnc-requires-auth>Correct Submitted Data</button> '),e.put("build-configs/directives/pnc-select-build-configs/pnc-select-build-configs.html",' <div> <ng-form name="dependenciesForm"> <div class="clearfix"> <div class="form-group"> <label class="control-label">Select dependencies</label> <pnc-build-config-combobox ng-model="$ctrl.buildConfig"></pnc-build-config-combobox> </div> <div class="btn-group pull-right" role="group" aria-label="..."> <button type="button" class="btn btn-primary" ng-click="$ctrl.add($ctrl.buildConfig)" ng-disabled="dependenciesForm.$invalid">Add</button> </div> </div> <div> <pf-list-view class="list-group list-view-pf list-view-pf-view" id="remove-build-groups-{{::$id}}" config="$ctrl.listConfig" items="$ctrl.buildConfigs" action-buttons="$ctrl.listActionButtons" ng-if="$ctrl.buildConfigs.length > 0"> <div class="list-view-pf-description"> <div class="list-group-item-heading"> {{ item.name }} </div> </div> </pf-list-view> <p ng-if="$ctrl.buildConfigs.length === 0"><em>No dependencies selected</em></p> </div> </ng-form> </div> '),e.put("build-configs/directives/pnc-select-build-parameters/pnc-display-build-parameters.html",' <div> <div ng-repeat="(key, value) in $ctrl.currentParams"> <p> <div class="btn-group pull-right" role="group" aria-label="..."> <button class="btn btn-sm btn-link" ng-click="$ctrl.toggleEdit(key)">Edit</button> <button class="btn btn-sm btn-link" ng-click="$ctrl.remove(key)">Remove</button> </div> <label>{{ key }}</label> <p></p> <div ng-hide="$ctrl.isEditOn(key)"> <pre>{{ value }}</pre> </div> <div ng-show="$ctrl.isEditOn(key)" class="clearfix"> <pf-form-group> <textarea ng-model="$ctrl.currentParams[key]" class="form-control" rows="3"></textarea> </pf-form-group> <div class="pull-right"> <button class="btn btn-default" ng-click="$ctrl.cancel(key)">Cancel</button> <button class="btn btn-primary" ng-click="$ctrl.update(key, $ctrl.currentParams[key])">Update</button> </div> </div> </div> </div> '),e.put("build-configs/directives/pnc-select-build-parameters/pnc-enter-build-parameters.html",' <script type="text/ng-template" id="pnc-enter-build-parameters/combobox-option-template.html"> <a ng-click="$ctrl.select(option)" href><strong>{{ option.name }}</strong> - {{ option.description }}</a> <\/script> <div class="form-group"> <label class="control-label">Key</label> <px-combobox px-expression="key.name for key in $ctrl.searchKnownKeys($viewValue)" ng-model="$ctrl.key" editable="true" placeholder="Select or input parameter key" option-template-url="pnc-enter-build-parameters/combobox-option-template.html"></px-combobox> </div> <div class="form-group"> <label class="control-label">Value</label> <textarea ng-model="$ctrl.value" class="form-control" rows="3"></textarea> </div> <div class="form-group pull-left"> <span class="help-block" ng-show="$ctrl.key && $ctrl.value">A new item needs to be submitted</span> </div> <div class="form-group pull-right"> <button type="button" class="btn btn-default" ng-click="$ctrl.clear()">Clear</button> <button type="button" class="btn btn-primary" ng-click="$ctrl.add()" ng-disabled="!$ctrl.key || !$ctrl.value" uib-tooltip="Submit&nbsp;a&nbsp;new&nbsp;item" tooltip-is-open="$ctrl.key && $ctrl.value" tooltip-placement="top" tooltip-popup-delay="500">Add</button> </div> '),e.put("build-configs/directives/pnc-select-build-parameters/pnc-select-build-parameters.html",' <form class="form-horizontal"> <div> <pnc-enter-build-parameters class="clearfix" on-add="$ctrl.addParam(key, value)" known-keys="$ctrl.knownKeys"></pnc-enter-build-parameters> </div> <hr ng-if="$ctrl.hasParams()"> <div> <pnc-display-build-parameters params="$ctrl.params" on-edit="$ctrl.addParam(key, value)" on-remove="$ctrl.removeParam(key)"></pnc-display-build-parameters> </div> </form> '),e.put("build-configs/directives/pnc-select-repository/pnc-select-repository.html",' <ng-form name="form" novalidate> <div class="form-group" ng-class="{ \'has-error\' : form.repositoryUrl.$invalid && form.repositoryUrl.$touched, \'has-success\': form.repositoryUrl.$valid && form.repositoryUrl.$touched }"> <label class="required control-label">Repository URL</label> <input type="text" name="repositoryUrl" class="form-control" ng-model="$ctrl.userData.scmUrl" ng-model-options="{ debounce: 500 }" pnc-scm-validator="git|ssh|http|https|git+ssh" ng-change="$ctrl.checkForRepo($ctrl.userData.scmUrl)" required> <p class="help-block" ng-show="form.repositoryUrl.$invalid && form.repositoryUrl.$touched">Repository URL is a required field.</p> <p class="help-block" ng-show="form.repositoryUrl.$error.invalidScmUrl && form.repositoryUrl.$touched">Invalid Repository URL</p> </div> <div class="form-group" ng-class="{ \'has-error\' : form.revision.$invalid && form.revision.$touched, \'has-success\': form.revision.$valid && form.revision.$touched }"> <label class="required control-label">Revision</label> <input name="revision" type="text" class="form-control" ng-model="$ctrl.userData.revision" required> <p class="help-block" ng-show="form.revision.$invalid && form.revision.$touched">Revision is a required field.</p> </div> <div class="alert alert-danger" ng-if="$ctrl.multipleRCError"> <span class="pficon pficon-error-circle-o"></span> Multiple SCM Repositories were found for this URL. This behaviour is currently unsupported. </div> <div class="row"> <div ng-if="!ctrl.isLoading() && $ctrl.isRepoInternal($ctrl.userData.scmUrl) && !$ctrl.userData.selectedRepoConfig"> <div class="alert alert-info"> <span class="pficon pficon-info"></span> The URL you have entered points to an <strong>internal</strong> repository. The repository will <strong>not</strong> be created if it does not exist. </div> </div> </div> <div class="form-group" ng-if="!$ctrl.isLoading() && !$ctrl.isRepoInternal($ctrl.userData.scmUrl) && !$ctrl.userData.selectedRepoConfig"> <div class="checkbox"> <label> <input type="checkbox" ng-model="$ctrl.userData.preBuildSyncEnabled">Pre-build Sync </label> </div> </div> <div class="row" ng-if="!$ctrl.isLoading() && $ctrl.userData.selectedRepoConfig"> <div class="alert alert-info"> <span class="pficon pficon-info"></span> <p>This {{ $ctrl.isRepoInternal($ctrl.userData.scmUrl) ? \'internal\' : \'external\' }} repository is already synced. </p> <br> <p><strong>Internal URL</strong>: <br>{{ $ctrl.userData.selectedRepoConfig.internalUrl }}</p> <p><strong>External URL</strong>: <br>{{ $ctrl.userData.selectedRepoConfig.externalUrl }}</p> <div class="checkbox"> <label> <input type="checkbox" ng-model="$ctrl.userData.selectedRepoConfig.preBuildSyncEnabled" disabled>Pre-build Sync </label> </div> </div> </div> <div class="row text-center" ng-show="$ctrl.isLoading()"> <span class="spinner spinner-xl spinner-inline"></span> </div> </ng-form> '),e.put("build-configs/list/pnc-build-configs-list-page.html",' <pnc-header> <pnc-header-title>Build Configs</pnc-header-title> </pnc-header> <div> <pnc-build-configs-data-table page="$ctrl.buildConfigs" hide-actions="true" display-fields="$ctrl.displayFields"></pnc-build-configs-data-table> </div> '),e.put("builds/detail/alignment-log/pnc-build-detail-alignment-log-page.html",' <div class="pull-left"> <a class="btn btn-default btn-sm" href="{{$ctrl.build.$alignLogUrl()}}" target="_blank" title="View the log as a plain text"> View <span class="pficon pficon-arrow"></span> </a> <a class="btn btn-default btn-sm" href="{{$ctrl.build.$alignLogUrl()}}" target="_blank" title="Download the log as a plain text" download="{{$ctrl.logFileName}}"> Download <span class="fa fa-arrow-circle-o-down"></span> </a> </div> <pnc-static-log log="$ctrl.alignmentLog.payload"></pnc-static-log> '),e.put("builds/detail/artifacts/pnc-build-detail-artifacts-page.html",' <div class="row"> <pnc-toolbar filtering-page="$ctrl.artifactsFilteringPage" filtering-fields="$ctrl.artifactsFilteringFields"></pnc-toolbar> </div> <div> <pnc-artifacts-list artifacts="$ctrl.artifactsFilteringPage.data"></pnc-artifacts-list> <pnc-page-controls pnc-page="$ctrl.artifactsFilteringPage" class="pull-right"></pnc-page-controls> </div>'),e.put("builds/detail/brew-push/pnc-build-detail-brew-push-page.html",' <div ng-if="$ctrl.data"> <div class="pnc-build-details"> <dl class="dl-horizontal"> <dt>Status</dt> <dd>{{ $ctrl.data.status || \'&mdash;\' }}</dd> <dt>Brew Build Id</dt> <dd>{{ $ctrl.data.brewBuildId || \'&mdash;\' }}</dd> <dt>Brew Build URL</dt> <dd> <a ng-if="$ctrl.data.brewBuildUrl" target="_blank" href="{{ ::$ctrl.data.brewBuildUrl }}">{{ ::$ctrl.data.brewBuildUrl }}</a> <span ng-if="!$ctrl.data.brewBuildUrl">&mdash;</span> </dd> </dl> </div> <div class="page-header"> <h3>Log</h3> </div> <pnc-bifrost-log-viewer match-filters="::$ctrl.matchFilters" prefix-filters="::$ctrl.prefixFilters"></pnc-bifrost-log-viewer> </div> <div ng-if="!$ctrl.data"> <p class="text-center"><em>There are no brew push records for this build.</em></p> </div> '),e.put("builds/detail/build-log/pnc-build-detail-build-log-page.html",' <div class="push-down"> <div class="pull-left"> <a class="btn btn-default btn-sm" href="{{$ctrl.build.$buildLogUrl()}}" target="_blank" title="View the log as a plain text"> View <span class="pficon pficon-arrow"></span> </a> <a class="btn btn-default btn-sm" href="{{$ctrl.build.$buildLogUrl()}}" target="_blank" title="Download the log as a plain text" download="{{$ctrl.logFileName}}"> Download <span class="fa fa-arrow-circle-o-down"></span> </a> <script type="text/ng-template" id="popoverTemplate.html"> <table class="nowrap">\n        <tbody>\n          <tr>\n            <td class="text-right p-r-10"><strong>command:</strong></td>\n            <td>{{ $ctrl.sshCredentials.command }}</td>\n          </tr>\n          <tr>\n            <td class="text-right p-r-10"><strong>password:</strong></td>\n            <td>{{ $ctrl.sshCredentials.password }}</td>\n          </tr>\n        </tbody>\n      </table> <\/script> <button uib-popover-template="\'popoverTemplate.html\'" popover-title="SSH credentials" type="button" class="btn btn-primary btn-sm popover-no-max w-min-130" popover-placement="right" ng-if="$ctrl.sshCredentials.command" ng-click="$ctrl.sshCredentialsBtn.clicked = !$ctrl.sshCredentialsBtn.clicked" ng-class="{\'active\' : $ctrl.sshCredentialsBtn.clicked }"> <span class="hide-when-active">Show</span> <span class="display-when-active">Hide</span> SSH credentials </button> </div> <pnc-static-log log="$ctrl.buildLog.payload"></pnc-static-log> </div> '),e.put("builds/detail/build-metrics/pnc-build-detail-build-metrics-page.html",' <div class="row"> <div class="col-md-12"> <pnc-build-metrics builds="[$ctrl.build]" chart-type="horizontalBar" component-id="horizontalBar1"></pnc-build-metrics> </div> </div> '),e.put("builds/detail/details/pnc-build-detail-details-page.html",' <div class="row push-down"> <div class="col-sm-12 col-md-10 col-lg-8"> <div class="pnc-build-details"> <dl class="dl-horizontal"> <dt>Job Id:</dt> <dd>{{ $ctrl.build.id }}</dd> <dt>Status:</dt> <dd ng-class="$ctrl.buildStatusHelper.isSuccess($ctrl.build.status) ? \'text-success\' : \'text-danger\'">{{ $ctrl.build.status }} <span ng-show="$ctrl.buildStatusHelper.isFinished($ctrl.build.status)" class="m-l-20">[ <a ng-href="{{ $ctrl.build.$buildLogUrl() }}">Plain Text Log</a> ]</span></dd> <dt>Build Config:</dt> <dd> <pnc-build-config-link revision="$ctrl.build.buildConfigRevision"></pnc-build-config-link> <pnc-build-config-history-revision revision="$ctrl.build.buildConfigRevision" project="$ctrl.build.project"></pnc-build-config-history-revision> </dd> <dt>Started By:</dt> <dd>{{ $ctrl.build.user.username || \'&mdash;\' }}</dd> <dt ng-show="$ctrl.build.submitTime">Submitted:</dt> <dd ng-show="$ctrl.build.submitTime">{{ ($ctrl.build.submitTime | date : \'medium\') }}</dd> <dt ng-show="$ctrl.build.startTime">Started:</dt> <dd ng-show="$ctrl.build.startTime">{{ ($ctrl.build.startTime | date : \'medium\') }}</dd> <dt ng-show="$ctrl.build.endTime">Finished:</dt> <dd ng-show="$ctrl.build.endTime">{{ ($ctrl.build.endTime | date : \'medium\') }}</dd> <dt>SCM URL:</dt> <dd> <span ng-show="$ctrl.build.scmUrl">{{ $ctrl.build.scmUrl }}</span> <span ng-hide="$ctrl.build.scmUrl"> <span class="pficon pficon-warning-triangle-o" ng-if="$ctrl.buildStatusHelper.isFailed($ctrl.build.status)" title="Something went wrong, probably during alignment process, you should check alignment logs for more details."></span> Not available, based on <code>{{ $ctrl.build.scmRepository.internalUrl }}</code> </span> </dd> <dt class="lh-1-5 m-t-10"> Pre-alignment<br>SCM Revision <a uib-popover="SCM Revision before Alignment is executed" popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> : </dt> <dd class="m-t-10"> <span ng-show="$ctrl.build.buildConfigRevision.scmRevision">{{ $ctrl.build.buildConfigRevision.scmRevision }}</span> </dd> <dt class="lh-1-5 m-t-10"> Post-alignment<br>SCM Revision <a uib-popover="SCM Revision after Alignment is executed" popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> : </dt> <dd class="m-t-10"> <span ng-show="$ctrl.build.scmRevision">{{ $ctrl.build.scmRevision }} [ <a ng-href="{{ $ctrl.build.$scmArchive() }}">Download Source Code Tarball</a> ]</span> <span ng-hide="$ctrl.build.scmRevision"> <span class="pficon pficon-warning-triangle-o" ng-if="$ctrl.buildStatusHelper.isFailed($ctrl.build.status)" title="Something went wrong, probably during alignment process, you should check logs for more details."></span> Not available, based on <code>{{ $ctrl.build.buildConfigRevision.scmRevision }}</code> </span> </dd> <dt class="lh-1-5 m-t-10 m-b-5"> Post-alignment<br>SCM Tag <a uib-popover="SCM Tag after Alignment is executed" popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> : </dt> <dd class="m-t-10 m-b-5"> <span ng-show="$ctrl.build.scmTag">{{ $ctrl.build.scmTag }}</span> <span ng-hide="$ctrl.build.scmTag"> Not available </span> </dd> <dt>Environment:</dt> <dd>{{ $ctrl.build.environment.name || \'&mdash;\' }}</dd> <dt>Script:</dt> <dd><pre class="pre-scrollable">{{ $ctrl.build.buildConfigRevision.buildScript || \'&mdash;\' }}</pre></dd> <dt ng-repeat-start="(key, value) in $ctrl.build.attributes">{{key}}</dt> <dd ng-repeat-end>{{value}}</dd> <dt>Parameters</dt> <dd> <ul class="list-unstyled" ng-show="$ctrl.buildConfigRevision.parameters"> <li ng-repeat="(key, value) in $ctrl.buildConfigRevision.parameters"> <span>{{ key }}</span><br> <span class="text-monospace"> <pre class="pre-scrollable">{{ value }}</pre> </span> </li> </ul> <span ng-hide="$ctrl.buildConfigRevision.parameters">&mdash;</span> </dd> </dl> </div> </div> </div> <pnc-build-tree build="$ctrl.build"></pnc-build-tree> <div class="p-b-40"> <pnc-log-streamer build="$ctrl.build" ng-if="$ctrl.buildStatusHelper.isInProgress($ctrl.build)"></pnc-log-streamer> </div> '),e.put("builds/detail/pnc-build-detail-page.html",' <div class="row margin-bottom-md"> <div class="col-md-12"> <div class="page-header border-none"> <div class="btn-group pull-right" role="group" aria-label="Build Actions"> <pnc-brew-push-button build="$ctrl.build"></pnc-brew-push-button> <button ng-if="$ctrl.build.$isCancelable()" ng-click="$ctrl.build.$cancel()" type="button" class="btn btn-danger"><i class="fa fa-ban" aria-hidden="true"></i>&nbsp;Abort</button> </div> <h1> <pnc-build-status-icon build="$ctrl.build" no-warnings="true"></pnc-build-status-icon> Build #{{ $ctrl.build.id }} of {{ $ctrl.build.buildConfigRevision.name }} <pnc-corrupted-build-label build="$ctrl.build" class="label-sm"></pnc-corrupted-build-label> <pnc-temporary-build-label build="$ctrl.build" class="label-sm"></pnc-temporary-build-label> </h1> </div> </div> </div> <div class="row m-b-20"> <div class="col-md-12"> <ul class="nav nav-tabs"> <li role="presentation" ui-sref-active="active"> <a href ui-sref="projects.detail.build-configs.detail.builds.detail.default">Details</a> </li> <li role="presentation" ui-sref-active="active" ng-show="$ctrl.isFinished"> <a href ui-sref="projects.detail.build-configs.detail.builds.detail.build-log">Build Log</a> </li> <li role="presentation" ui-sref-active="active" ng-show="$ctrl.isFinished"> <a href ui-sref="projects.detail.build-configs.detail.builds.detail.alignment-log">Alignment Log</a> </li> <li role="presentation" ui-sref-active="active" ng-show="$ctrl.isFinished"> <a href ui-sref="projects.detail.build-configs.detail.builds.detail.artifacts">Artifacts</a> </li> <li role="presentation" ui-sref-active="active" ng-show="$ctrl.isFinished"> <a href ui-sref="projects.detail.build-configs.detail.builds.detail.dependencies">Dependencies</a> </li> <li role="presentation" ui-sref-active="active" ng-show="$ctrl.isFinished"> <a href ui-sref="projects.detail.build-configs.detail.builds.detail.brew-push">Brew Push</a> </li> <li role="presentation" ui-sref-active="active"> <a href ui-sref="projects.detail.build-configs.detail.builds.detail.build-metrics">Build Metrics</a> </li> </ul> </div> </div> <div class="row"> <div class="col-md-12" ui-view> </div> </div> '),e.put("builds/directives/pnc-brew-push-button/pnc-brew-push-button.html",' <button ng-if="::$ctrl.isButtonVisible" ng-click="$ctrl.openTagNameModal()" type="button" class="btn btn-default" pnc-requires-auth><i class="pficon pficon-export"></i>&nbsp;Push To Brew</button> '),e.put("builds/directives/pnc-build-config-history-revision/pnc-build-config-history-revision.html",' <a href ui-sref="projects.detail.build-configs.detail.revisions.detail(\n    { projectId: $ctrl.project.id,\n      configurationId: $ctrl.revision.id,\n      revisionId: $ctrl.revision.rev  })"> <i class="fa fa-clock-o fa-lg c-info" uib-tooltip="Go to specific revision of the build-config that was used for this build" tooltip-popup-delay="1000" tooltip-placement="right"></i> </a> '),e.put("builds/directives/pnc-build-config-link/pnc-build-config-link.html"," <a href ui-sref=\"projects.detail.build-configs.detail({ configurationId:$ctrl.revision.id })\" ng-transclude>{{ $ctrl.revision.name || '&mdash;' }}</a> "),e.put("builds/directives/pnc-build-link/pnc-build-link.html",' <a ui-sref="projects.detail.build-configs.detail.builds.detail.default({ projectId: $ctrl.build.project.id, configurationId: $ctrl.build.buildConfigRevision.id, buildId: $ctrl.build.id })" ng-transclude href>{{ $ctrl.linkText }}</a> '),e.put("builds/directives/pnc-build-tree/pnc-build-tree-link.html",' <div> <pnc-build-status-icon build="$ctrl.buildItem"></pnc-build-status-icon> <a ng-if="$ctrl.build" ui-sref="projects.detail.build-configs.detail({ projectId: $ctrl.build.project.id,  configurationId: $ctrl.build.buildConfigRevision.id })" ng-click="$event.stopPropagation()">{{$ctrl.build.buildConfigRevision.name}}</a> <pnc-group-config-link group-config="$ctrl.groupBuild.groupConfig" ng-if="$ctrl.groupBuild"></pnc-group-config-link> <span class="fa fa-angle-double-right"></span> <a ng-if="$ctrl.build" ui-sref="projects.detail.build-configs.detail.builds.detail.default({ projectId: $ctrl.build.project.id, configurationId: $ctrl.build.buildConfigRevision.id, buildId: $ctrl.build.id })" ng-click="$event.stopPropagation()"># {{ $ctrl.build.id }}</a> <a ng-if="$ctrl.groupBuild" ui-sref="group-builds.detail({ id: $ctrl.groupBuild.id })" ng-click="$event.stopPropagation()"># {{ $ctrl.groupBuild.id }}</a> </div> '),e.put("builds/directives/pnc-build-tree/pnc-build-tree.html",' <div id="{{$ctrl.componentIdAttr}}"> <table class="table table-bordered table-hover table-treegrid"> <thead> <tr> <th>Dependency Tree</th> </tr> </thead> <tbody ng-if="$ctrl.buildTree.dependentStructure" class="border-t-w-1"> <tr class="bg-white"> <td> <strong>Direct Parents</strong> </td> </tr> <tr ng-if="!$ctrl.buildTree.dependentStructure.length"> <td>No builds are directly dependent on the current build</td> </tr> <tr ng-if="$ctrl.buildTree.dependentStructure.length" ng-repeat="itemId in $ctrl.buildTree.dependentStructure"> <td> <pnc-build-tree-link build="$ctrl.buildTree.nodes[itemId].data"></pnc-build-tree-link> </td> </tr> </tbody> <tbody ng-if="$ctrl.buildTree.dependencyStructure" class="border-t-w-1"> <tr class="bg-white"> <td> <strong>Dependencies</strong> <button class="btn btn-default btn-xs m-l-20" ng-click="$ctrl.expandNodes(1)">Expand 1 Level</button> <button class="btn btn-default btn-xs" ng-click="$ctrl.expandNodes(2)">Expand 2 Levels</button> <button class="btn btn-default btn-xs" ng-click="$ctrl.expandNodes()">Expand All</button> <button class="btn btn-default btn-xs" ng-click="$ctrl.expandNodes(-1)">Expand All Failed</button> </td> </tr> <tr ng-hide="$ctrl.dependencyStructureIsLoaded"> <td> <div class="loading-placeholder w-100-20"></div> </td> </tr> <tr ng-show="$ctrl.dependencyStructureIsLoaded" ng-repeat="item in $ctrl.buildTree.dependencyStructure" id="{{item.attrId}}" ng-attr-data-parent="{{item.attrParent}}" class="{{item.attrClass}}"> <td class="treegrid-node {{ item.tdAttrClass}}"> <pnc-build-tree-link ng-if="item.isBuild" class="inline-block" build="$ctrl.buildTree.nodes[item.id].data"></pnc-build-tree-link> <pnc-build-tree-link ng-if="item.isGroupBuild" class="inline-block" group-build="$ctrl.buildItem"></pnc-build-tree-link> </td> </tr> </tbody> <tbody ng-if="!$ctrl.buildTree.dependencyStructure" class="border-t-w-1"> <tr> <td class="text-center"> <span ng-show="$ctrl.isLoaded">Build Tree could not be displayed properly<span ng-if="$ctrl.loadingErrorMessage">: <span class="info-warning">{{$ctrl.loadingErrorMessage}}</span></span></span> <div ng-hide="$ctrl.isLoaded" class="loading-placeholder w-100-20"></div> </td> </tr> </tbody> </table> </div> '),e.put("builds/directives/pnc-builds-data-table/pnc-builds-data-table.html",' <div> <pnc-builds-list builds="$ctrl.paginator.data" display-fields="$ctrl.displayFields"></pnc-builds-list> <pnc-page-controls class="pull-right m-t-10" pnc-page="$ctrl.paginator" ng-if="$ctrl.paginator.data"></pnc-page-controls> </div> '),e.put("builds/directives/pnc-builds-list/pnc-builds-list.html",' <table class="table table-bordered table-striped table-hover pnc-builds-list" ng-show="$ctrl.showTable()"> <thead ng-hide="::$ctrl.hideHead"> <th ng-if="::$ctrl.showColumn(\'status\')">Status</th> <th ng-if="::$ctrl.showColumn(\'statusIcon\')">&nbsp;</th> <th ng-if="::$ctrl.showColumn(\'id\')">Id</th> <th ng-if="::$ctrl.showColumn(\'configurationName\')">{{ $ctrl.builds ? \'Build\' : \'Group\' }} Config</th> <th ng-if="::$ctrl.showColumn(\'canonicalName\')">Build</th> <th ng-if="::$ctrl.showColumn(\'submitTime\')">Submit Time</th> <th ng-if="::$ctrl.showColumn(\'startTime\')">Start Time</th> <th ng-if="::$ctrl.showColumn(\'endTime\')">End Time</th> <th ng-if="::$ctrl.showColumn(\'username\')">User</th> <th ng-if="::$ctrl.showColumn(\'pushStatus\')">Brew Push Status</th> </thead> <tbody> <tr ng-repeat="item in $ctrl.items"> <td ng-if="::$ctrl.showColumn(\'status\')"> <pnc-build-status-icon build="item"></pnc-build-status-icon> {{ item.status }} </td> <td ng-if="::$ctrl.showColumn(\'statusIcon\')" class="status-icon"> <pnc-build-status-icon build="item"></pnc-build-status-icon> </td> <td ng-if="::$ctrl.showColumn(\'id\')"> <pnc-build-link ng-if="::$ctrl.builds" build="item" short-link="true"></pnc-build-link> <pnc-group-build-link ng-if="::$ctrl.groupBuilds" group-build="item"></pnc-group-build-link> </td> <td ng-if="::$ctrl.showColumn(\'configurationName\')"> <a ng-if="::$ctrl.builds" href ui-sref="projects.detail.build-configs.detail({ projectId: item.project.id, configurationId: item.buildConfigRevision.id })">{{ item.buildConfigRevision.name }}</a> <pnc-group-config-link ng-if="::$ctrl.groupBuilds" group-config="item.groupConfig"></pnc-group-config-link> </td> <td ng-if="::$ctrl.showColumn(\'canonicalName\')"><pnc-build-link build="item"></pnc-build-link></td> <td ng-if="::$ctrl.showColumn(\'submitTime\')">{{ item.submitTime | date:\'medium\' }}</td> <td ng-if="::$ctrl.showColumn(\'startTime\')">{{ item.startTime | date:\'medium\' }}</td> <td ng-if="::$ctrl.showColumn(\'endTime\')">{{ item.endTime | date:\'medium\' }}</td> <td ng-if="::$ctrl.showColumn(\'username\')">{{ item.user.username }}</td> <td ng-if="::$ctrl.showColumn(\'pushStatus\')" class="push-status"> <pnc-brew-push-status-label build="item"></pnc-brew-push-status-label> </td> </tr> </tbody> </table> <table ng-hide="$ctrl.showTable()" class="table table-bordered table-striped table-hover build-status-table actions-table"> <tbody> <tr> <td class="text-center p-t-10 p-b-10"><em>There are no Builds to display</em></td> </tr> </tbody> </table> '),e.put("builds/directives/pnc-builds-list/pnc-live-update-builds-list.html",' <pnc-builds-list builds="$ctrl.builds" display-fields="$ctrl.displayFields" hide-head="$ctrl.hideHead"> </pnc-builds-list> '),e.put("builds/directives/pnc-enter-brew-tag-name-modal/pnc-enter-brew-tag-name-modal.html",' <div> <div class="modal-header"> <button type="button" class="close" aria-label="Close" ng-click="$ctrl.cancel()"><span aria-hidden="true">&times;</span></button> <h3 class="modal-title">Enter Brew Tag Prefix</h3> </div> <div class="modal-body"> <div class="row"> <div class="col-md-12"> <form name="form" novalidate> <div class="form-group"> <label class="control-label" for="brew-tag-name"> Brew Tag Prefix <a uib-popover="The brew tag prefix entered will have \'-candidate\' appended to it, all artifacts pushed to brew will be added to this tag." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> <input id="brew-tag-name" name="name" class="form-control" ng-model="$ctrl.data.name" type="text"> </div> </form> </div> </div> </div> <div class="modal-footer"> <button class="btn btn-primary" type="button" ng-click="$ctrl.done()"><i class="pficon pficon-export"></i>&nbsp;Push</button> <button class="btn btn-default" type="button" ng-click="$ctrl.cancel()">Cancel</button> </div> </div> '),e.put("builds/directives/pnc-log-streamer/pnc-log-streamer.html",' <ng-bifrost-log-viewer bifrost-host="$ctrl.bifrostHost" match-filters="$ctrl.matchFilters" prefix-filters="$ctrl.prefixFilters"> </ng-bifrost-log-viewer> '),e.put("builds/directives/pnc-static-log/pnc-static-log.html",' <div> <div class="pull-right"> <script type="text/ng-template" id="logWrapPopoverTemplate.html"> <table class="nowrap">\n        <tbody>\n          <tr>\n            <td>Use <code>shift + mouse wheel</code><br> to scroll horizontally</td>\n          </tr>\n        </tbody>\n      </table> <\/script> <label> <div uib-popover-template="\'logWrapPopoverTemplate.html\'" popover-placement="top-right" popover-is-open="!$ctrl.logWrap"> <span class="inline-block pull-left p-t-2 p-r-5 cursor-pointer">Log Text Wrapping is</span> <div class="btn-group"> <span class="btn btn-sm btn-default" ng-class="{ \'btn-primary\': $ctrl.logWrap }">ON</span> <span class="btn btn-sm btn-default" ng-class="{ \'btn-primary\': !$ctrl.logWrap }">OFF</span> </div> </div> <input ng-model="$ctrl.logWrap" type="checkbox" ng-change="$ctrl.handleModelChange()" class="hide"> </label> </div> <pre class="clear-both" ng-class="{ \'pre-wrap\': $ctrl.logWrap }">\n    {{ ::$ctrl.log || \'Log not available.\' }}\n  </pre> </div> '),e.put("builds/list/pnc-builds-list-page.html",' <pnc-header> <pnc-header-title>Builds</pnc-header-title> </pnc-header> <div class="row"> <pnc-toolbar filtering-page="$ctrl.buildsFilteringPage" filtering-fields="$ctrl.buildsFilteringFields" sorting-fields="$ctrl.buildsSortingFields" sorting-configs="$ctrl.buildsSortingConfigs"></pnc-toolbar> </div> <div> <pnc-builds-list builds="$ctrl.buildsFilteringPage.data"></pnc-builds-list> <pnc-page-controls class="pull-right m-b-10" pnc-page="$ctrl.buildsFilteringPage" ng-if="$ctrl.buildsFilteringPage"></pnc-page-controls> </div> '),e.put("common/bifrost/pnc-bifrost-log-viewer.html",' <ng-bifrost-log-viewer bifrost-host="$ctrl.bifrostHost" match-filters="$ctrl.matchFilters" prefix-filters="$ctrl.prefixFilters"> </ng-bifrost-log-viewer> '),e.put("common/components/pnc-admin-panel/pnc-admin-panel.html",' <div class="modal fade" id="adminPanelModal" tabindex="-1" role="dialog" aria-labelledby="adminPanelLabel" aria-hidden="true"> <div class="modal-dialog"> <div class="modal-content"> <div class="modal-header"> <button type="button" class="close" data-dismiss="modal" aria-hidden="true"> <span class="pficon pficon-close"></span> </button> <h4 class="modal-title" id="adminPanelLabel">Admin Panel</h4> </div> <div class="modal-body"> <form class="form-horizontal"> <div class="form-group"> <label class="col-sm-3 control-label" for="maintenance-switch">Maintenance Mode</label> <div class="col-sm-3"> <input class="bootstrap-switch" id="maintenance-switch" type="checkbox"> </div> </div> </form> </div> </div> </div> </div> <div class="modal fade" id="activateMaintenance" tabindex="-1" role="dialog" aria-labelledby="activateMaintenanceLabel" aria-hidden="true"> <div class="modal-dialog"> <div class="modal-content"> <div class="modal-header"> <button type="button" class="close" data-dismiss="modal" aria-hidden="true" ng-click="$ctrl.clearMaintenanceValidation()"> <span class="pficon pficon-close"></span> </button> <h4 class="modal-title" id="activateMaintenanceLabel">Activate Maintenance Mode</h4> </div> <div class="modal-body"> <form class="form-horizontal"> <div id="confirmActivateFormGroup" class="form-group"> <label class="col-sm-2 control-label" for="activateReason" title="Reason to activate Maintenance Mode">* Reason:</label> <div class="col-sm-8"> <input type="text" id="activateReason" ng-model="$ctrl.data.reason" class="form-control" placeholder="Provide your reason to activate Maintenance Mode" ng-change="$ctrl.validateActivateFormGroup()" ng-blur="$ctrl.validateActivateFormGroup()" required> <span class="help-block" ng-show="false">Required field.</span> </div> </div> </form> </div> <div class="modal-footer"> <button type="button" class="btn btn-default" ng-click="$ctrl.clearMaintenanceValidation()" data-dismiss="modal">Cancel</button> <button id="confirm-maintenance-mode" type="button" class="btn btn-primary" ng-click="$ctrl.activateMaintenanceMode()">Confirm</button> </div> </div> </div> </div> '),e.put("common/components/pnc-brew-push-status-label/pnc-brew-push-status-label.html",' <div ng-if="$ctrl.loading" class="spinner spinner-sm"></div> <div ng-if="!$ctrl.loading"> <span ng-switch on="$ctrl.pushStatus.status"> <span ng-switch-when="SUCCESS" class="label label-success"> <a ui-sref="projects.detail.build-configs.detail.builds.detail.brew-push({ projectId: $ctrl.build.project.id, configurationId: $ctrl.build.buildConfigRevision.id, buildId: $ctrl.build.id })" href> SUCCESS </a> </span> <span ng-switch-when="FAILED" class="label label-danger"> <a ui-sref="projects.detail.build-configs.detail.builds.detail.brew-push({ projectId: $ctrl.build.project.id, configurationId: $ctrl.build.buildConfigRevision.id, buildId: $ctrl.build.id })" href> FAILED </a> </span> <span ng-switch-when="SYSTEM_ERROR" class="label label-danger"> <a ui-sref="projects.detail.build-configs.detail.builds.detail.brew-push({ projectId: $ctrl.build.project.id, configurationId: $ctrl.build.buildConfigRevision.id, buildId: $ctrl.build.id })" href> ERROR </a> </span> <span ng-switch-when="CANCELED" class="label label-default"> <a ui-sref="projects.detail.build-configs.detail.builds.detail.brew-push({ projectId: $ctrl.build.project.id, configurationId: $ctrl.build.buildConfigRevision.id, buildId: $ctrl.build.id })" href> CANCELED </a> </span> <span ng-switch-default> &mdash; </span> </span> </div> '),e.put("common/components/pnc-build-config-combobox/pnc-build-config-combobox.html",' <px-combobox px-expression="buildConfig as buildConfig.name for buildConfig in $ctrl.search($viewValue)" ng-model="$ctrl.input" debounce-ms="500" placeholder="Select or search for a Build Config"> </px-combobox> '),e.put("common/components/pnc-build-config-status-icon/pnc-build-config-status-icon.html",' <pnc-build-status ng-if="$ctrl.buildConfig" build="$ctrl.build" is-loaded="$ctrl.isLoaded"></pnc-build-status> '),e.put("common/components/pnc-build-metrics/pnc-build-metrics.html",' <div class="pnc-build-metrics"> <script type="text/ng-template" id="metricsDescriptionsTooltipTemplate.html"><div>\n    Each metric consists of several subtasks:\n    <dl class="m-t-10" ng-repeat="metric in $ctrl.metricsTooltip">\n      <dt>{{ metric.label }}</dt>\n      <dd>\n        {{ metric.description }}\n      </dd>\n    </dl>\n  </div><\/script> <div class="pnc-build-metrics-body" ng-class="{\'status-visible\' : $ctrl.isLoading || $ctrl.loadingError || $ctrl.noDataAvailable}"> <div class="pnc-build-metrics-help"> <small>Select specific metric in the chart legend to filter it out:</small> </div> <div class="pnc-build-metrics-help pnc-build-metrics-help--right"> <small>Metrics Descriptions <a uib-popover-template="\'metricsDescriptionsTooltipTemplate.html\'" popover-trigger="\'outsideClick\'" popover-placement="left" popover-class="popover-info-tip" href> <span class="fa fa-info-circle"></span> </a> </small> </div> <div class="loading-status" ng-class="{ \'opacity-50\' : $ctrl.isUpdating }"> <div ng-if="$ctrl.isLoading"> <div class="spinner spinner-lg"></div> </div> <div ng-if="$ctrl.loadingError">Error when loading data</div> <div ng-if="$ctrl.noDataAvailable">No data available on Kafka Store service</div> </div> <div class="canvas-wrapper" ng-class="{ \'opacity-50\' : $ctrl.isUpdating }"> <canvas id="{{$ctrl.componentId}}"></canvas> </div> </div> <form class="pnc-build-metric-navigation clearfix"> <div class="pull-left"> </div> <div class="pull-right" ng-if="$ctrl.builds.length > 1"> <div ng-if="$ctrl.isUpdating" class="spinner spinner-sm pull-left m-t-3 m-r-8"></div> Display every <select id="{{$ctrl.componentId}}-select" ng-model="$ctrl.navigationSelected" ng-change="$ctrl.navigationSelect($ctrl.navigationSelected)" ng-options="option.name for option in $ctrl.navigationOptions"></select> build <a uib-popover="Always a maximum of {{::$ctrl.BUILDS_DISPLAY_LIMIT}} builds will be displayed if they are available, eg. if every {{::$ctrl.BUILDS_DISPLAY_LIMIT_EXAMPLE}}th build is displayed, {{::$ctrl.BUILDS_DISPLAY_LIMIT}} builds will cover last {{$ctrl.BUILDS_DISPLAY_LIMIT * $ctrl.BUILDS_DISPLAY_LIMIT_EXAMPLE}} builds." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" popover-trigger="\'outsideClick\'" href> <span class="fa fa-info-circle"></span> </a> </div> </form> </div>'),e.put("common/components/pnc-build-start/pnc-build-start.html",' <div class="btn-group pnc-build-start"> <button type="button" class="btn btn-{{ $ctrl.size ? $ctrl.size : \'lg\'}} btn-primary" uib-tooltip="Start a build of this configuration" tooltip-popup-delay="2000" tooltip-placement="top" tooltip-append-to-body="true" ng-click="$ctrl.build()" pnc-requires-auth> <i class="pficon pficon-build"></i> Build </button> <button class="btn btn-{{ $ctrl.size ? $ctrl.size : \'lg\'}} btn-default dropdown-btn" ng-click="$ctrl.dropdownMenu = !$ctrl.dropdownMenu" uib-tooltip="Configure a build" tooltip-popup-delay="1500" tooltip-placement="top" tooltip-append-to-body="true" pnc-requires-auth> {{ $ctrl.params.temporaryBuild ? \'Temporary\' : \'Persistent\' }} <span class="fa fa-angle-up" ng-if="$ctrl.dropdownMenu"></span> <span class="fa fa-angle-down" ng-if="!$ctrl.dropdownMenu"></span> </button> <div class="dropdown-menu ng-hide" ng-show="$ctrl.dropdownMenu"> <div class="radio"> <label> <input type="radio" name="buildStartType-{{$id}}" ng-model="$ctrl.params.temporaryBuild" ng-value="false" ng-change="$ctrl.refreshBuildTypes()"> Persistent <a uib-popover="Standard build, which can be used for product release" popover-trigger="\'outsideClick\'" popover-placement="top" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> </div> <div class="radio"> <label> <input type="radio" name="buildStartType-{{$id}}" ng-model="$ctrl.params.temporaryBuild" ng-value="true" ng-change="$ctrl.refreshBuildTypes()"> Temporary <a uib-popover="Test build, which cannot be used for product release and which will be garbage collected" popover-trigger="\'outsideClick\'" popover-placement="top" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> </div> <hr> Rebuild Mode <script type="text/ng-template" id="rebuildModeTooltipTemplate.html"><div>\n      Rebuild a previously <em>successful</em> build config when:\n      <dl class="m-t-10">\n        <dt>{{ $ctrl.rebuildModes[0].title }}</dt>\n        <dd>\n          <ul>\n              <li>The build config has been modified since the last successful build</li>\n              <li>A build config, explicitly defined as a dependency of this one, has been modified<br>since the last successful build</li>\n              <li>There exists a newer, successful build of a build config explicitly defined as a dependency of this one</li>\n          </ul>\n        </dd>\n\n        <dt>{{ $ctrl.rebuildModes[1].title }}</dt>\n        <dd>\n          <ul>\n            <li><strong>Explicit</strong> criteria plus:</li>\n            <li>There exists a newer version of an implicit dependency (automatically<br>captured from sources such as Indy, MRRC or Maven Central)</li>\n          </ul>\n        </dd>\n\n        <dt>{{ $ctrl.rebuildModes[2].title }}</dt>\n        <dd>\n          <ul>\n            <li>Always</li>\n          </ul>\n        </dd>\n      </dl>\n    </div><\/script> <a uib-popover-template="\'rebuildModeTooltipTemplate.html\'" popover-trigger="\'outsideClick\'" popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> <div class="radio" ng-repeat="rebuildMode in $ctrl.rebuildModes"> <label> <input type="radio" name="rebuildModeName" ng-model="$ctrl.params.rebuildMode" value="{{ rebuildMode.value }}" ng-change="$ctrl.refreshRebuildModes($index)"> {{ rebuildMode.title }} </label> </div> <hr> <div class="checkbox" ng-if="::$ctrl.buildConfig"> <label> <input type="checkbox" ng-model="$ctrl.params.keepPodOnFailure"> keep pod alive <a uib-popover="The builder container won\'t be destroyed if the build fails and you can use SSH to debug it" popover-trigger="\'outsideClick\'" popover-placement="top" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> </div> <div class="checkbox" ng-if="::$ctrl.buildConfig"> <label> <input type="checkbox" ng-model="$ctrl.params.buildDependencies"> with dependencies <a uib-popover="Build also dependencies of this build configuration if they are not built yet" popover-trigger="\'outsideClick\'" popover-placement="top" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> </div> <div class="checkbox" ng-class="{\'disabled-option\': !$ctrl.params.temporaryBuild}" title="{{ !$ctrl.params.temporaryBuild ? \'Not valid option\' : \'\' }}"> <label> <input type="checkbox" ng-model="$ctrl.params.timestampAlignment"> timestamp alignment <a uib-popover="Append timestamp to the artifact\'s maven version during the alignment phase" popover-trigger="\'outsideClick\'" popover-placement="top" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> </div> <hr> <div class="text-center"> <small> Press <em>Build</em> button to start {{ $ctrl.params.temporaryBuild ? \'Temporary\' : \'Persistent\' }} {{ $ctrl.currentRebuildModeTitle }} build <span ng-show="$ctrl.params.buildDependencies"> applying the same Rebuild Mode also to explicitly defined dependencies <a uib-popover="Not implicit (automatically captured) ones - those are used only to determine if the rebuild is required" popover-trigger="\'outsideClick\'" popover-placement="bottom" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </span> </small> </div> </div> </div> '),e.put("common/components/pnc-build-status-icon/pnc-build-status-icon.html",' <span class="build-status-icon"> <span ng-switch on="$ctrl.build.status"> <img ng-switch-when="WAITING_FOR_DEPENDENCIES" uib-tooltip="Waiting for dependencies" tooltip-popup-delay="1000" alt="{{ $ctrl.build.status }}" width="28px" height="28px" src="images/blue.1d354bbb.svg"> <img ng-switch-when="ENQUEUED" uib-tooltip="Enqueued" tooltip-popup-delay="1000" alt="{{ $ctrl.build.status }}" width="28px" height="28px" src="images/blue.1d354bbb.svg"> <img ng-switch-when="BUILDING" uib-tooltip="Build in progress" tooltip-popup-delay="1000" alt="{{ $ctrl.build.status }}" width="28px" height="28px" class="animate-flicker" src="images/blue.1d354bbb.svg"> <img ng-switch-when="SUCCESS" uib-tooltip="Build completed successfully" tooltip-popup-delay="1000" alt="{{ $ctrl.build.status }}" width="28px" height="28px" src="images/green.180d8c78.svg"> <img ng-switch-when="DONE" uib-tooltip="Build completed successfully" tooltip-popup-delay="1000" alt="{{ $ctrl.build.status }}" width="28px" height="28px" src="images/green.180d8c78.svg"> <img ng-switch-when="UNSTABLE" uib-tooltip="Unstable build" tooltip-popup-delay="1000" alt="{{ $ctrl.build.status }}" width="28px" height="28px" src="images/yellow.7d85293a.svg"> <img ng-switch-when="FAILED" uib-tooltip="Build Failed" tooltip-popup-delay="1000" alt="{{ $ctrl.build.status }}" width="28px" height="28px" src="images/red.a59b0104.svg"> <img ng-switch-when="DONE_WITH_ERRORS" uib-tooltip="Build Failed" tooltip-popup-delay="1000" alt="{{ $ctrl.build.status }}" width="28px" height="28px" src="images/red.a59b0104.svg"> <img ng-switch-when="REJECTED_ALREADY_BUILT" uib-tooltip="Build rejected: already built" tooltip-popup-delay="1000" alt="{{ $ctrl.build.status }}" width="28px" height="28px" src="images/green.180d8c78.svg" style="filter: brightness(125%) opacity(50%)"> <img ng-switch-when="NO_REBUILD_REQUIRED" uib-tooltip="No rebuild required" tooltip-popup-delay="1000" alt="{{ $ctrl.build.status }}" width="28px" height="28px" src="images/green.180d8c78.svg" style="filter: brightness(125%) opacity(50%)"> <img ng-switch-when="REJECTED_FAILED_DEPENDENCIES" uib-tooltip="Build rejected: dependencies failed" tooltip-popup-delay="1000" alt="{{ $ctrl.build.status }}" width="28px" height="28px" src="images/orange.f64e7f28.svg"> <img ng-switch-when="REJECTED" uib-tooltip="Build rejected" tooltip-popup-delay="1000" alt="{{ $ctrl.build.status }}" width="28px" height="28px" src="images/red.a59b0104.svg"> <img ng-switch-when="ABORTED" uib-tooltip="Build aborted" tooltip-popup-delay="1000" alt="{{ $ctrl.build.status }}" width="28px" height="28px" src="images/grey.cdfd423b.svg"> <img ng-switch-when="CANCELLED" uib-tooltip="Build cancelled" tooltip-popup-delay="1000" alt="{{ $ctrl.build.status }}" width="28px" height="28px" src="images/grey.cdfd423b.svg"> <img ng-switch-when="NEW" uib-tooltip="New" tooltip-popup-delay="1000" alt="{{ $ctrl.build.status }}" width="28px" height="28px" src="images/grey.cdfd423b.svg"> <img ng-switch-when="SYSTEM_ERROR" uib-tooltip="A system error occurred" tooltip-popup-delay="1000" alt="{{ $ctrl.build.status }}" width="28px" height="28px" src="images/error.a0c1e13e.svg"> <img ng-switch-default uib-tooltip="Unknown build status: {{ $ctrl.build.status }}" alt="{{ $ctrl.build.status }}" tooltip-popup-delay="1000" width="28px" height="28px" src="images/no-builds.93f6ce13.svg"> </span> <span ng-if="::!$ctrl.noWarnings"> <span ng-if="$ctrl.isCorrupted"> <i class="pficon pficon-warning-triangle-o fa-lg" uib-tooltip="The build may have completed successfully but has since been corrupted by a system error" tooltip-popup-delay="1000" tooltip-placement="right"></i> </span> <span ng-if="$ctrl.isTemporary"> <i class="fa fa-clock-o fa-lg c-info" uib-tooltip="Temporary build; this will be garbage collected" tooltip-popup-delay="1000" tooltip-placement="right"></i> </span> </span> </span> '),e.put("common/components/pnc-build-status/pnc-build-status.html",' <div class="pnc-build-status"> <div ng-show="$ctrl.item && $ctrl.isLoaded && $ctrl.item.status"> <pnc-build-status-icon build="$ctrl.item"></pnc-build-status-icon> <pnc-build-link ng-if="::$ctrl.build" build="$ctrl.build" short-link="true"></pnc-build-link> <pnc-group-build-link ng-if="::$ctrl.groupBuild" group-build="$ctrl.groupBuild" short-link="true"></pnc-group-build-link> <span title="End Time">{{ $ctrl.item.endTime | date:\'medium\' }}</span> <span title="Start Time" ng-hide="$ctrl.item.endTime">{{ $ctrl.item.startTime | date:\'medium\' }}</span> <span title="Submit Time" ng-hide="$ctrl.item.endTime || $ctrl.item.startTime">{{ $ctrl.item.submitTime | date:\'medium\' }}</span> <span ng-show="$ctrl.item.username">,</span> <span class="text-bold">{{ $ctrl.item.user.username }}</span> </div> <em ng-show="!$ctrl.item && $ctrl.isLoaded">none</em> <div ng-hide="$ctrl.isLoaded" class="loading-placeholder w-100-20"></div> </div> '),e.put("common/components/pnc-corrupted-build-label/pnc-corrupted-build-label.html",' <span ng-if="$ctrl.isCorrupted()"> <span class="label label-warning" uib-tooltip="The build may have completed successfully but has since been corrupted by a system error" tooltip-popup-delay="1000"> CORRUPTED </span> </span> '),e.put("common/components/pnc-environment-combobox/pnc-environment-combobox.html",' <px-combobox px-expression="environment as environment.name for environment in $ctrl.search($viewValue)" ng-model="$ctrl.input" debounce-ms="500"> </px-combobox> '),e.put("common/components/pnc-global-alert/pnc-global-alert.html",' <div id="maintenanceAlert" class="alert alert-warning alert-dismissable" style="margin-bottom:0px" ng-show="$ctrl.isInMaintenanceMode"> <span class="pficon pficon-warning-triangle-o"></span> <strong>Maintenance Mode </strong>- PNC system is in the maintenance mode, no new build requests are accepted.{{$ctrl.message}} <button type="button" class="close" data-dismiss="alert" aria-hidden="true"> <span class="pficon pficon-close"></span> </button> </div> '),e.put("common/components/pnc-group-config-status-icon/pnc-group-config-status-icon.html",' <pnc-build-status group-build="$ctrl.groupBuild" is-loaded="$ctrl.isLoaded"></pnc-build-status> '),e.put("common/components/pnc-inline-notification/pnc-inline-notification.html",' <pf-inline-notification ng-if="$ctrl.notification.visible" pf-notification-type="$ctrl.notification.type" pf-notification-header="$ctrl.notification.header" pf-notification-message="$ctrl.notification.message" pf-notification-persistent="$ctrl.notification.persistent" pf-notification-remove="$ctrl.notification.remove()"> </pf-inline-notification> '),e.put("common/components/pnc-product-combobox/pnc-product-combobox.html",' <px-combobox px-expression="product as product.name for product in $ctrl.search($viewValue)" ng-model="$ctrl.input" debounce-ms="500" placeholder="Select or search for a Product" editable="true"> </px-combobox> '),e.put("common/components/pnc-product-version-combobox/pnc-product-version-combobox.html",' <px-combobox name="version" px-expression="productVersion as $ctrl.generateLabel(productVersion) for productVersion in $ctrl.search($viewValue)" ng-model="$ctrl.input" debounce-ms="500" placeholder="Select or search for a Product Version" ng-show="$ctrl.versionListLength != 0"> </px-combobox> <p ng-show="$ctrl.showNoVersionScript" class="help-block has-error">No version available for the product you selected.</p> '),e.put("common/components/pnc-project-typeahead/pnc-project-typeahead.html",' <div class="search-pf has-button"> <div class="form-group has-clear"> <div class="search-pf-input-group"> <label for="select-project-{{::$id}}" class="sr-only">Search Projects</label> <input type="text" class="form-control combobox" id="select-project-{{::$id}}" placeholder="Enter project name to search..." autocomplete="off" ng-model="$ctrl.input" uib-typeahead="project as project.name for project in $ctrl.search($viewValue)" typeahead-on-select="$ctrl.select($item, $model, $label)" typeahead-wait-ms="300" typeahead-loading="$ctrl.isLoading" ng-focus="$ctrl.setTouched()" ng-change="$ctrl.setDirty()"> <button ng-if="$ctrl.isLoading" type="button" class="clear" aria-hidden="true"><span class="spinner spinner-xs spinner-inline"></span></button> <button ng-if="!$ctrl.isLoading && $ctrl.input" type="button" class="clear" aria-hidden="true" ng-click="$ctrl.input = \'\'"><span class="pficon pficon-close"></span></button> </div> </div> <div class="form-group"> <button class="btn btn-default" type="button"><span class="fa fa-search"></span></button> </div> </div> '),e.put("common/components/pnc-scm-repository-combobox/pnc-scm-repository-combobox.html",' <px-combobox px-expression="scmRepository \n    as $ctrl.generateLabel(scmRepository) \n    for scmRepository \n    in $ctrl.search($viewValue)" ng-model="$ctrl.input" debounce-ms="500" placeholder="Select or search for a SCM Repository" class="pnc-scm-repository-combobox"> </px-combobox> '),e.put("common/components/pnc-service-notification/pnc-service-notification.html",' <div ng-show="$ctrl.notification" class="alert alert-neon service-notice" ng-class="{ \'alert-dismissable\': $ctrl.notification.dismissable }"> <button type="button" class="close" data-dismiss="alert" aria-hidden="true" ng-show="$ctrl.notification.dismissable"> <span class="pficon pficon-close"></span> </button> <span class="pficon pficon-info"></span> <strong>{{ $ctrl.notification.title }}</strong> {{ $ctrl.notification.message }} <a ng-show="$ctrl.notification.link" class="alert-link" ng-href="{{ $ctrl.notification.link.href }}" ng-bind="$ctrl.notification.link.title"></a>. </div> '),e.put("common/components/pnc-temporary-build-label/pnc-temporary-build-label.html",' <span ng-if="$ctrl.isTemporary()"> <span class="label label-info" uib-tooltip="Test build, which cannot be used for product release and which will be garbage colleted" tooltip-popup-delay="1000"> TEMPORARY </span> </span> '),e.put("common/components/pnc-toolbar/pnc-toolbar.html",' <pf-toolbar class="hide-result-count" config="$ctrl.pfToolbarConfig"></pf-toolbar>'),e.put("common/directives/pnc-confirm-click/pnc-confirm-click.html",' <div class="modal-header"> <h3 class="modal-title">{{ message }}</h3> </div> <div class="modal-footer"> <button class="btn btn-default" type="button" ng-click="cancel()">Cancel</button> <button class="btn btn-warning" type="button" ng-click="confirm()">Confirm</button> </div> '),e.put("common/directives/pnc-header/pnc-header.html",' <div class="row"> <div class="col-md-12"> <div class="page-header"> <div class="btn-toolbar pull-right" role="toolbar" aria-label="Context specific actions"></div> <h1 class="header-title"></h1> </div> </div> </div> '),e.put("common/directives/pnc-infinite-select-items/pnc-infinite-select-items.html",' <ul ng-class="{\'list-group\': singleItem === \'false\' , \'list-group-no-bottom-margin\': singleItem === \'true\' }" ng-show="shouldShowList()"> <li class="list-group-item" ng-repeat="item in selectedItems"> {{ additionalDisplayItemsById[item.id] }} {{ item[displayProperty] }} <button type="button" class="close" aria-label="Close" ng-click="removeItem(item)"> <span aria-hidden="true">×</span> </button> </li> </ul> <div class="pnc-infinite-select" ng-show="shouldShowSelection()"> <input ng-required="{{ infiniteSelectRequired }}" id="{{ infiniteSelectId }}" name="{{ infiniteSelectId }}" ng-model="searchText" ng-change="search()" placeholder="{{ placeholder }}" size="{{ text.length + 10 }}" ng-focus="viewDropdown(true)" ng-blur="viewDropdown(false)" class="input-text" autocomplete="off"> <div class="dropdown-wrap" ng-show="isDropdown"> <ul infinite-scroll="loadOptions()" infinite-scroll-distance="0" infinite-scroll-immediate-check="false" infinite-scroll-parent="true" class="dropdown-list"> <li class="dropdown-item" ng-repeat="item in items.data" ng-mousedown="selectItem(item); viewDropdown(false)"> {{ item.name }} </li> </ul> </div> </div> '),e.put("common/directives/pnc-infinite-select-product-versions/pnc-infinite-select-product-versions.html",' <ul ng-class="{\'list-group\': singleItem === \'false\' , \'list-group-no-bottom-margin\': singleItem === \'true\' }" ng-show="shouldShowList()"> <li class="list-group-item" ng-repeat="prodVers in selectedItems"> <span class="text-bold">{{ prodVers[\'productName\'] }}</span> - {{ prodVers[\'version\'] }} <button type="button" class="close" aria-label="Close" ng-click="removeItem(prodVers)"> <span aria-hidden="true">×</span> </button> </li> </ul> <div class="pnc-infinite-select" ng-show="shouldShowSelection()"> <input ng-required="{{ infiniteSelectRequired }}" id="{{ infiniteSelectId }}" name="{{ infiniteSelectId }}" ng-model="searchText" ng-change="search()" placeholder="{{ placeholder }}" size="{{ text.length + 10 }}" ng-focus="viewDropdown(true)" ng-blur="viewDropdown(false)" class="input-text" autocomplete="off"> <div class="dropdown-wrap" ng-show="isDropdown"> <ul infinite-scroll="loadOptions()" infinite-scroll-distance="0" infinite-scroll-immediate-check="false" infinite-scroll-parent="true" class="dropdown-list"> <li class="dropdown-list" ng-repeat="product in items.data"> <span class="text-bold">{{ product.name }}</span> <div class="dropdown-item" ng-repeat="productVersionRef in product.productVersionRefs" ng-mousedown="selectItem(productVersionRef); viewDropdown(false)">{{productVersionRef.version}}</div> <div class="dropdown-item-empty" ng-hide="product.productVersionRefs.length">└ no version available</div> </li> </ul> </div> </div> '),e.put("common/directives/pnc-infinite-select/pnc-infinite-select.html",' <div class="pnc-infinite-select"> <input ng-required="{{ infiniteSelectRequired }}" id="{{ infiniteSelectId }}" name="{{ infiniteSelectName }}" ng-model="searchText" ng-change="search()" placeholder="{{ placeholder }}" size="{{ text.length + 10 }}" ng-focus="viewDropdown(true)" ng-blur="viewDropdown(false)" class="input-text" autocomplete="off"> <div class="dropdown-wrap" ng-show="isDropdown"> <ul infinite-scroll="loadOptions()" infinite-scroll-distance="0" infinite-scroll-immediate-check="false" infinite-scroll-parent="true" class="dropdown-list"> <li class="dropdown-item" ng-repeat="item in items.data" ng-mousedown="selectItem(item); viewDropdown(false)"> {{ item.name }} </li> </ul> </div> </div> '),e.put("common/directives/pnc-loading-placeholder/pnc-loading-placeholder.html",' <tr ng-repeat="tr in [1,2]" ng-hide="page.isLoaded"> <td ng-repeat="td in columnsIterable" class="bg-white"> <div class="loading-placeholder"></div> </td> </tr> <tr ng-show="page.isLoaded && !page.data.length"> <td colspan="{{columns}}" class="text-center">No data available</td> </tr> '),e.put("common/directives/pnc-multiple-input/pnc-multiple-input.html",' <div class="pnc-multiple-input"> <ul class="list-group" ng-show="shouldShowList()"> <li class="list-group-item" ng-repeat="item in selectedItems"> {{ item }} <button type="button" class="close" aria-label="Close" ng-click="removeItem(item)"> <span aria-hidden="true">×</span> </button> </li> </ul> <div> <input id="{{ selectId }}" name="{{ selectName }}" ng-model="inputItem" placeholder="{{ placeholder }}" class="input-item" class="input-text"> <button type="button" class="btn-select-item" aria-label="Close" ng-click="selectItem(inputItem)">Add</button> </div> </div> '),e.put("common/directives/pnc-select-items/pnc-select-items.html",' <ul ng-class="{\'list-group\': singleItem === \'false\' , \'list-group-no-bottom-margin\': singleItem === \'true\' }" ng-show="shouldShowList()"> <li class="list-group-item" ng-repeat="item in selectedItems"> {{ item.fullDisplayText }} <button type="button" class="close" aria-label="Close" ng-click="removeItem(item)"> <span aria-hidden="true">×</span> </button> </li> </ul> <div class="pnc-infinite-select" ng-show="shouldShowSelection()"> <input ng-required="{{ selectRequired }}" id="{{ selectId }}" name="{{ selectName }}" ng-model="searchText" placeholder="{{ placeholder }}" size="{{ text.length + 10 }}" ng-focus="viewDropdown(true)" ng-blur="viewDropdown(false)" class="input-text" autocomplete="off"> <div class="dropdown-wrap" ng-show="isDropdown"> <ul class="dropdown-list"> <li class="dropdown-item" ng-repeat="item in filteredItems = (items.data | filter:searchText)" ng-mousedown="selectItem(item); viewDropdown(false)"> <span class="text-bold">{{ item.displayBoldText }}</span><span>{{ item.displayText }}</span> </li> <li class="dropdown-item-empty" ng-show="!items.data.length"><span class="fa fa-angle-double-left"></span> empty <span class="fa fa-angle-double-right"></span></li> <li class="dropdown-item-empty cursor-pointer" ng-show="!filteredItems.length && customItem" ng-click="saveCustomItem(searchText)"> <span class="fa fa-angle-double-left"></span> click here to add custom value <span class="fa fa-angle-double-right"></span> </li> </ul> </div> </div> '),e.put("common/notifications/views/heading.html"," {{notificationGroup.heading}} "),e.put("common/notifications/views/notification-body.html",' <div ng-if="!drawerExpanded"> <div class="dropdown pull-right dropdown-kebab-pf" ng-if="notification.menuActions && notification.menuActions.length > 0"> <button class="btn btn-link dropdown-toggle" type="button" id="dropdownKebabRight" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true"> <span class="fa fa-ellipsis-v"></span> </button> <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownKebabRight"> <li ng-repeat="menuAction in notification.menuActions" role="menuitem" ng-class="{\'divider\': menuAction.isSeparator === true, \'disabled\': menuAction.isDisabled === true}"> <a ng-if="menuAction.isSeparator !== true" class="secondary-action ng-binding ng-scope" title="{{menuAction.title}}" ng-click="menuAction.actionFn()"> {{menuAction.name}} </a> </li> </ul> </div> <div class="pull-right toast-pf-action ng-scope" ng-if="notification.actionTitle"> <a ng-click="notification.actionCallback()" class="ng-binding">{{ notification.actionTitle }}</a> </div> <span ng-if="notification.type" class="{{\'pull-left \' + $ctrl.customScope.getNotficationStatusIconClass(notification)}}" ng-click="$ctrl.customScope.markRead(notification)"> </span> <span class="drawer-pf-notification-message" ng-click="$ctrl.customScope.markRead(notification)"> {{notification.message}} </span> <div class="drawer-pf-notification-info" ng-click="$ctrl.customScope.markRead(notification)"> <span class="date">{{notification.timeStamp | date:\'mediumDate\'}}</span> <span class="time">{{notification.timeStamp | date:\'mediumTime\'}}</span> </div> </div> '),e.put("common/notifications/views/notification-footer-include.html",' <a class="btn btn-link btn-block" role="button" ng-click="$ctrl.customScope.clearAll(notificationGroup)"> <span class="pficon pficon-close"></span> <span>Clear All</span> </a> '),e.put("common/notifications/views/subheading.html"," "),e.put("common/pnc-client/pagination/directives/pnc-page-controls/pnc-page-controls.html",' <div class="form-inline pnc-page-controls" ng-show="ctrl.page.data.length > ctrl.pageSizes[0] || ctrl.page.total > 1"> <div class="pnc-page-controls-size"> <label for="page-size-{{::$id}}">Size:&nbsp;</label> <select id="page-size-{{::$id}}" ng-model="ctrl.size" ng-change="ctrl.page.getWithNewSize(ctrl.size)" ng-options="i as i for i in ctrl.pageSizes"> </select> </div> <div class="pnc-page-controls-pager"> <button type="button" class="btn btn-default btn-sm" ng-click="ctrl.page.previous()" ng-disabled="!ctrl.page.hasPrevious()"><span class="i fa fa-angle-left"></span> Prev</button> <span><input type="text" ng-model="ctrl.index" size="3" ng-keypress="($event.which === 13) ? ctrl.getPageIfExists(ctrl.index) : false"></span><span class="of-x-pages">of {{ ctrl.total }}</span> <button type="button" class="btn btn-default btn-sm" ng-click="ctrl.page.next()" ng-disabled="!ctrl.page.hasNext()">Next <span class="i fa fa-angle-right"></span></button> </div> </div> '),e.put("common/select-modals/build-config-multi-select/add-build-config-widget.html",' <script type="text/ng-template" id="button-add-right"> {{ actionButton.name }}&nbsp;<span class="fa fa-angle-right"></span> <\/script> <div> <div class="row"> <div class="col-xs-12"> <pnc-project-typeahead on-select="$ctrl.select"></pnc-project-typeahead> <span id="helpBlock" class="help-block">Begin typing to select a Project, then select the desired Build Config from the list below.</span> </div> </div> <div class="row" ng-if="$ctrl.items.length"> <div class="col-xs-12 text-right m-t-10"> <button class="btn btn-default btn-sm" ng-click="$ctrl.selectAll($ctrl.selectAllState)"> <span ng-if="!$ctrl.selectAllState">Clear</span> <span ng-if="$ctrl.selectAllState">Select</span> All </button> <button class="btn btn-primary btn-sm" ng-click="$ctrl.addSelected()">Add Selected</button> </div> </div> <div class="row"> <div class="col-xs-12"> <div id="build-configs-{{::$id}}"> <pf-list-view class="list-group list-view-pf list-view-pf-view" id="add-build-groups-{{::$id}}" config="$ctrl.config" items="$ctrl.items" action-buttons="$ctrl.actionButtons" ng-if="$ctrl.items.length > 0"> <div class="list-view-pf-description"> <div class="list-group-item-heading"> {{ item.buildConfig.name }} </div> </div> </pf-list-view> </div> </div> </div> </div> '),e.put("common/select-modals/build-config-multi-select/build-config-multi-select.html",' <div> <div class="modal-header"> <h3 class="modal-title">{{ $ctrl.title }}</h3> </div> <div class="modal-body"> <div class="row"> <div class="col-xs-6"> <h4>Select Build Configs</h4> <add-build-config-widget on-add="$ctrl.onAdd(buildConfig)"></add-build-config-widget> </div> <div class="col-xs-6 border-before"> <h4>Added Build Configs</h4> <span class="help-block">Press <i>Save</i> to submit changes</span> <remove-build-configs-widget build-configs="$ctrl.buildConfigs" on-remove="$ctrl.onRemove(buildConfig)"></remove-build-configs-widget> </div> </div> </div> <div class="modal-footer"> <button class="btn btn-primary" type="button" ng-click="$ctrl.save()">Save</button> <button class="btn btn-default" type="button" ng-click="$ctrl.cancel()">Cancel</button> </div> </div> '),e.put("common/select-modals/build-config-multi-select/remove-build-configs-widget.html",' <div> <pf-list-view class="list-group list-view-pf list-view-pf-view" id="remove-build-groups-{{::$id}}" config="$ctrl.config" items="$ctrl.buildConfigs" action-buttons="$ctrl.actionButtons" ng-if="$ctrl.buildConfigs.length > 0"> <div class="list-view-pf-description"> <div class="list-group-item-heading"> {{ item.name }} </div> </div> </pf-list-view> <p ng-if="$ctrl.buildConfigs.length === 0"><em>No Build Configs selected</em></p> </div> '),e.put("common/select-modals/build-group-multi-select.html",' <div> <div class="modal-header"> <h3 class="modal-title">{{ ctrl.title }}</h3> </div> <div class="modal-body"> <div class="row"> <div class="col-md-12"> <form role="form" class="search-pf has-button"> <div class="form-group has-clear"> <div class="search-pf-input-group"> <label for="search1" class="sr-only">Search</label> <input type="text" name="selectGroup" class="form-control combobox" id="select-build-group" placeholder="Enter build group name to search..." autocomplete="off" ng-model="ctrl.input" uib-typeahead="group as group.name for group in ctrl.fetchGroups($viewValue)" typeahead-on-select="ctrl.onSelect($item, $model, $label)" typeahead-wait-ms="300" typeahead-loading="ctrl.isLoading"> <button type="button" class="clear" aria-hidden="true"><span ng-show="ctrl.isLoading" class="spinner spinner-xs spinner-inline"></span></button> </div> </div> <div class="form-group"> <button class="btn btn-default" type="button"><span class="fa fa-search"></span></button> </div> </form> </div> </div> <div class="row"> <div class="col-md-12"> <pf-list-view class="list-group list-view-pf list-view-pf-view" id="build-group-list" config="ctrl.config" items="ctrl.selected" action-buttons="ctrl.actionButtons"> <div class="list-view-pf-description"> <div class="list-group-item-heading"> {{item.name}} </div> </div> </pf-list-view> </div> </div> </div> <div class="modal-footer"> <button class="btn btn-primary" type="button" ng-click="ctrl.save()">Save</button> <button class="btn btn-default" type="button" ng-click="ctrl.close()">Cancel</button> </div> </div> '),e.put("common/select-modals/product-version-single-select.html",' <div> <div class="modal-header"> <h3 class="modal-title">{{ ctrl.title }}</h3> </div> <div class="modal-body"> <div class="row"> <div class="col-md-12"> <form role="form" class="search-pf has-button"> <div class="form-group has-clear"> <div class="search-pf-input-group"> <label for="search1" class="sr-only">Search</label> <input type="text" name="selectGroup" class="form-control combobox" id="select-build-group" placeholder="Enter product name to start..." autocomplete="off" ng-model="ctrl.input" uib-typeahead="product as product.name for product in ctrl.fetchProducts($viewValue)" typeahead-on-select="ctrl.onSelectProduct($item, $model, $label)" typeahead-wait-ms="300" typeahead-loading="ctrl.isLoading"> <button type="button" class="clear" aria-hidden="true"><span ng-show="ctrl.isLoading" class="spinner spinner-xs spinner-inline"></span></button> </div> </div> <div class="form-group"> <button class="btn btn-default" type="button"><span class="fa fa-search"></span></button> </div> </form> <span id="helpBlock" class="help-block">Begin typing to select a product, then select the desired version from the list below. Note: a build group can be associated with <em>only one</em> product version.</span> </div> </div> <div class="row"> <div class="col-md-12"> <pf-list-view class="list-group list-view-pf list-view-pf-view cursor-pointer" id="build-group-list" config="ctrl.config" items="ctrl.selectedProduct._productVersions" action-buttons="ctrl.actionButtons" ng-if="ctrl.selectedProduct._productVersions"> <div class="list-view-pf-description"> <div class="list-group-item-heading"> {{ item._productName }}: {{ item.version }} </div> </div> </pf-list-view> </div> </div> </div> <div class="modal-footer"> <button class="btn btn-primary" type="button" ng-click="ctrl.save()" ng-disabled="!ctrl.selectedVersion">Save</button> <button class="btn btn-default" type="button" ng-click="ctrl.close()">Cancel</button> </div> </div> '),e.put("common/templates/footer.tmpl.html",' <p> <a href="https://github.com/project-ncl/pnc">PNC</a> <span> (Version: 2.0.0-SNAPSHOT 27 August 2020 Rev: fd45fdb)</span> <span> | </span> Red Hat, Inc. © 2020 </p> '),e.put("common/templates/single-col-center.tmpl.html",' <div class="row"> <div class="col-md-8 col-md-offset-2" ui-view> </div> </div> '),e.put("common/templates/single-col.tmpl.html",' <div class="row"> <div class="col-md-12" ui-view></div> </div> '),e.put("common/templates/two-col-left-sidebar.tmpl.html",' <div class="row"> <div class="col-sm-9 col-md-10 col-sm-push-3 col-md-push-2" ui-view> </div> <div class="col-sm-3 col-md-2 col-sm-pull-9 col-md-pull-10 sidebar-pf sidebar-pf-left" ui-vew="sidebar"> </div> </div> '),e.put("common/templates/two-col-right-sidebar.tmpl.html",' <div class="row flex"> <div class="col-sm-8 col-lg-9" ui-view> </div> <div class="col-sm-4 col-lg-3 sidebar-pf sidebar-pf-right" ui-view="sidebar"> </div> </div>'),e.put("common/templates/uiBreadcrumbs.tpl.html",' <ol class="breadcrumb"> <li ng-repeat="crumb in breadcrumbs" ng-class="{ active: $last }"><a ui-sref="{{ crumb.route }}" ui-sref-opts="{reload: true }" ng-if="!$last">{{ crumb.displayName }}&nbsp;</a><span ng-show="$last">{{ crumb.displayName }}</span> </li> </ol> '),e.put("dashboard/directives/pnc-my-builds-panel/pnc-my-builds-panel.html",' <div class="panel panel-default" ng-if="show()" style=""> <div class="panel-heading"> <div class="spinner spinner-sm pull-right" ng-hide="page.isLoaded"></div> <h3 class="panel-title">My Builds</h3> </div> <pnc-builds-list builds="page.data" display-fields="displayFields"></pnc-builds-list> <pnc-page-controls class="pull-right" pnc-page="page" ng-if="page"></pnc-page-controls> </div> '),e.put("dashboard/directives/pnc-my-group-builds-panel/pnc-my-group-builds-panel.html",' <div class="panel panel-default" ng-if="show()"> <div class="panel-heading"> <div class="spinner spinner-sm pull-right" ng-hide="page.isLoaded"></div> <h3 class="panel-title">My Group Builds</h3> </div> <pnc-builds-list group-builds="page.data" display-fields="displayFields"></pnc-builds-list> <pnc-page-controls class="pull-right" pnc-page="page" ng-if="page"></pnc-page-controls> </div> '),e.put("dashboard/views/dashboard.html",' <div style="margin-top: 8px"> <div class="row"> <div class="col-md-12 col-lg-6"> <pnc-grafana-widget widget-type="TRAFFIC_LIGHTS"></pnc-grafana-widget> </div> <div class="col-md-12 col-lg-6"> <pnc-grafana-widget widget-type="STATUS_MAP"></pnc-grafana-widget> </div> </div> <div class="row"> <div class="col-md-12 col-lg-6"> <pnc-my-builds-panel></pnc-my-builds-panel> </div> <div class="col-md-12 col-lg-6"> <pnc-my-group-builds-panel></pnc-my-group-builds-panel> </div> <div class="col-md-12" ng-hide="ctrl.isAuthenticated()"> <p><a href ng-click="ctrl.login()">Log in</a> to see more widgets.</p> </div> </div> </div> '),e.put("dashboard/widgets/pnc-dashboard-widget/pnc-dashboard-widget.html",' <div class="panel panel-default"> <div class="panel-heading"> <h3 class="panel-title" ng-transclude="title"></h3> </div> <div class="panel-body" ng-transclude="body"></div> </div> '),e.put("dashboard/widgets/pnc-grafana-widget/pnc-grafana-widget-body.html",' <iframe class="grafana-iframe center-block" width="450" height="280" frameborder="0" ng-src="{{ ::$ctrl.iFrameUrl }}"></iframe> '),e.put("dashboard/widgets/pnc-grafana-widget/pnc-grafana-widget.html",' <pnc-dashboard-widget> <widget-title>{{ ::$ctrl.title }}</widget-title> <widget-body> <div class="grafana-widget-body"> <pnc-grafana-widget-body url="$ctrl.url"></pnc-grafana-widget-body> </div> </widget-body> </pnc-dashboard-widget> '),e.put("error.html",' <div class="row"> <div class="col-sm-12 col-md-8 col-lg-6"> <h1>{{ errorCtrl.title }}</h1> <p>{{ errorCtrl.message }}</p> <p><a href ui-sref="dashboard" class="alert-link">Return to dashboard</a>.</p> <hr> </div> </div> '),e.put("group-builds/components/pnc-group-build-link/pnc-group-build-link.html",' <a ui-sref="group-builds.detail({ id: $ctrl.groupBuild.id })" ng-transclude href># {{ ::$ctrl.groupBuild.id }}</a>'),e.put("group-builds/components/pnc-group-build-values-list/pnc-group-build-values-list.html",' <div> <dl class="dl-horizontal"> <dt>Status</dt> <dd>{{ $ctrl.groupBuild.status }}</dd> <dt>Build Group</dt> <dd> <pnc-group-config-link group-config="$ctrl.groupBuild.groupConfig"></pnc-group-config-link> </dd> <dt>User</dt> <dd>{{ $ctrl.groupBuild.user.username }}</dd> <dt>Started</dt> <dd>{{ $ctrl.groupBuild.startTime | date: \'medium\' }}</dd> <dt ng-show="$ctrl.groupBuild.endTime">Finished</dt> <dd ng-show="$ctrl.groupBuild.endTime">{{ $ctrl.groupBuild.endTime | date: \'medium\' }}</dd> </dl> </div> '),e.put("group-builds/components/pnc-group-build-visualization/pnc-group-build-visualization.html",' <div> <div class="btn-group pull-right m-b-20"> <label class="btn btn-default btn-lg" title="List visualization" ng-model="$ctrl.visualization" ng-change="$ctrl.changeVisualization($ctrl.visualization)" uib-btn-radio="\'list\'"> <span class="fa fa-list"></span> </label> <label class="btn btn-default btn-lg" title="Tree visualization" ng-model="$ctrl.visualization" ng-change="$ctrl.changeVisualization($ctrl.visualization)" uib-btn-radio="\'tree\'"> <span class="fa fa-sitemap"></span> </label> </div> <pnc-live-update-builds-list ng-show="$ctrl.visualization === \'list\'" builds="$ctrl.builds" display-fields="$ctrl.buildColumns"></pnc-live-update-builds-list> <pnc-build-tree ng-show="$ctrl.visualization === \'tree\'" group-build="$ctrl.groupBuild" dependency-graph="$ctrl.dependencyGraph"></pnc-build-tree> </div> '),e.put("group-builds/detail/pnc-group-build-detail-page.html",' <div class="row"> <div class="col-md-12"> <div class="page-header"> <div class="btn-group pull-right" role="group" aria-label="Build Actions"> <pnc-brew-push-button group-build="$ctrl.groupBuild"></pnc-brew-push-button> <button ng-if="$ctrl.groupBuild.$isCancelable()" ng-click="$ctrl.groupBuild.$cancel()" type="button" class="btn btn-danger"> <i class="fa fa-ban" aria-hidden="true"></i>&nbsp;Abort </button> </div> <h1> <pnc-build-status-icon build="$ctrl.groupBuild" no-warnings="true"></pnc-build-status-icon> {{ $ctrl.groupBuild.groupConfig.name }} <span class="fa fa-angle-double-right"></span> #{{ $ctrl.groupBuild.id }} <pnc-temporary-build-label group-build="$ctrl.groupBuild" class="label-sm"></pnc-temporary-build-label> </h1> </div> </div> </div> <div class="row"> <div class="col-md-12"> <pnc-group-build-values-list group-build="$ctrl.groupBuild"></pnc-group-build-values-list> </div> </div> <div ng-if="::$ctrl.hasBuilds()"> <div class="row"> <div class="col-md-12"> <div class="page-header"> <h2 class="h4">Builds</h2> </div> </div> </div> <div class="row"> <div class="col-md-12"> <pnc-group-build-visualization group-build="$ctrl.groupBuild" builds="$ctrl.builds" dependency-graph="$ctrl.dependencyGraph"></pnc-group-build-visualization> </div> </div> </div> '),e.put("group-builds/list/pnc-group-builds-list-page.html",' <pnc-header> <pnc-header-title>Group Builds</pnc-header-title> </pnc-header> <div class="row"> <pnc-toolbar filtering-page="$ctrl.groupBuildsFilteringPage" filtering-fields="$ctrl.groupBuildsFilteringFields" sorting-fields="$ctrl.groupBuildsSortingFields" sorting-configs="$ctrl.groupBuildsSortingConfigs"></pnc-toolbar> </div> <div> <pnc-builds-list group-builds="$ctrl.groupBuildsFilteringPage.data" display-fields="$ctrl.displayFields"></pnc-builds-list> <pnc-page-controls class="pull-right m-b-10" pnc-page="$ctrl.groupBuildsFilteringPage" ng-if="$ctrl.groupBuildsFilteringPage"></pnc-page-controls> </div> '),e.put("group-configs/components/pnc-group-config-link/pnc-group-config-link.html",' <a ui-sref="group-configs.detail({ groupConfigId: $ctrl.groupConfig.id })" ng-transclude href>{{ ::$ctrl.groupConfig.name }}</a>'),e.put("group-configs/components/pnc-group-configs-data-table/pnc-group-configs-data-table.html",' <div class="row"> <pnc-toolbar filtering-page="$ctrl.filterPage" filtering-fields="$ctrl.filterFields" sorting-fields="$ctrl.sortingFields" sorting-configs="$ctrl.sortingConfigs" actions-config="$ctrl.toolbarActions"></pnc-toolbar> </div> <div> <pnc-group-configs-list group-configs="$ctrl.filterPage.data"></pnc-group-configs-list> <pnc-page-controls class="pull-right m-t-10 m-b-10" pnc-page="$ctrl.filterPage" ng-if="$ctrl.filterPage"></pnc-page-controls> </div> '),e.put("group-configs/components/pnc-group-configs-list/pnc-group-configs-list.html",' <div> <table class="table table-bordered table-striped table-hover" ng-show="$ctrl.showTable()"> <thead> <th ng-if="::$ctrl.showColumn(\'name\')">Name</th> <th ng-if="::$ctrl.showColumn(\'buildStatus\')">Build Status</th> <th ng-if="::$ctrl.actionsTemplateUrl">Actions</th> </thead> <tbody> <tr ng-repeat="groupConfig in $ctrl.groupConfigs"> <td ng-if="::$ctrl.showColumn(\'name\')"> <pnc-group-config-link group-config="groupConfig"></pnc-group-config-link> </td> <td ng-if="$ctrl.showColumn(\'buildStatus\')"> <pnc-group-config-status-icon group-config="groupConfig"></pnc-group-config-status-icon> </td> <td class="td-actions" ng-if="::$ctrl.actionsTemplateUrl" ng-include="::$ctrl.actionsTemplateUrl"></td> </tr> </tbody> </table> <table ng-hide="$ctrl.showTable()" class="table table-bordered table-striped table-hover build-status-table actions-table"> <tbody> <tr> <td class="text-center p-t-10 p-b-10"><em>There are no Group Configs to display</em></td> </tr> </tbody> </table> </div> '),e.put("group-configs/create/pnc-group-config-create-page.html",' <pnc-header> <pnc-header-title>Create Group Config</pnc-header-title> </pnc-header> <div class="row"> <div class="col-md-11 col-lg-10"> <form name="groupConfigForm" class="form-horizontal" novalidate> <div class="form-group" ng-class="{ \'has-error\': groupConfigForm.name.$invalid && groupConfigForm.name.$touched, \'has-success\': groupConfigForm.name.$valid && groupConfigForm.name.$touched }"> <label for="input-name" class="col-sm-3 col-lg-2 control-label required">Name</label> <div class="col-sm-9 col-lg-7"> <input type="text" id="input-name" class="form-control" name="name" maxlength="255" ng-model="$ctrl.data.groupConfig.name" required> <span class="help-block" ng-show="groupConfigForm.name.$error.required && groupConfigForm.name.$touched">Required field.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': groupConfigForm.product.$invalid && groupConfigForm.product.$touched, \'has-success\': groupConfigForm.product.$touched && groupConfigForm.version.$touched }"> <label class="col-sm-3 col-lg-2 control-label">Product</label> <div class="col-sm-9 col-lg-7"> <pnc-product-combobox name="product" ng-change="$ctrl.checkVersionData($ctrl.data.groupConfig)" ng-model="$ctrl.data.groupConfig.product"> </pnc-product-combobox> </div> </div> <div class="form-group" ng-if="$ctrl.data.groupConfig.product && $ctrl.data.groupConfig.product.id" ng-class="{ \'has-error\' : groupConfigForm.version.$invalid && groupConfigForm.version.$touched, \'has-success\': groupConfigForm.product.$touched && groupConfigForm.version.$touched }"> <label class="col-sm-3 col-lg-2 control-label">Version</label> <div class="col-sm-9 col-lg-7"> <pnc-product-version-combobox name="version" product="$ctrl.data.groupConfig.product" ng-model="$ctrl.data.groupConfig.version"> </pnc-product-version-combobox> <p ng-show="groupConfigForm.version.$invalid && $ctrl.data.groupConfigForm.version.$touched" class="help-block"> Version is a required field if you selected any product.</p> </div> </div> <div class="form-group"> <div class="col-sm-offset-3 col-lg-offset-2 col-sm-9 col-lg-10"> <input type="submit" class="btn btn-primary" value="Create" ng-click="$ctrl.create($ctrl.data.groupConfig)" ng-disabled="groupConfigForm.$invalid"> <input type="reset" class="btn btn-default" value="Clear" ng-click="$ctrl.reset($ctrl.data.groupConfig)"> </div> </div> </form> </div> </div> '),e.put("group-configs/detail/build-configs-tab/pnc-group-config-build-configs-tab.html",' <div> <pnc-build-configs-data-table page="$ctrl.buildConfigs" on-edit="$ctrl.onEdit" on-remove="$ctrl.onRemove" refresh-build-configs="$ctrl.refreshBuildConfigs"></pnc-build-configs-data-table> </div> '),e.put("group-configs/detail/build-history-tab/pnc-group-config-build-history-tab.html",' <div> <pnc-builds-list group-builds="$ctrl.paginator.data"></pnc-builds-list> <pnc-page-controls class="pull-right m-t-10" pnc-page="$ctrl.paginator" ng-if="$ctrl.paginator"></pnc-page-controls> </div> '),e.put("group-configs/detail/pnc-group-config-detail-page.html",' <div class="row m-b-20"> <div class="col-md-12"> <pnc-header> <pnc-header-title>{{ $ctrl.formModel.name }}</pnc-header-title> <pnc-header-buttons> <div class="btn-group" role="group" aria-label="Build controls"> <pnc-build-start group-config="$ctrl.groupConfig"></pnc-build-start> </div> <div class="btn-group" role="group" aria-label="Other controls"> <button type="button" class="btn btn-lg btn-default" uib-tooltip="Edit Group Config" tooltip-popup-delay="2500" tooltip-placement="top" tooltip-append-to-body="true" ng-click="groupConfigEditForm.$show()" ng-class="{ \'active\': groupConfigEditForm.$visible }" pnc-requires-auth> <i class="pficon pficon-edit"></i> Edit </button> <div class="btn-group dropdown dropdown-kebab-pf"> <button class="btn btn-default dropdown-toggle" type="button" id="dropdownKebab" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true" pnc-requires-auth> <span class="fa fa-ellipsis-v"></span> </button> <ul class="dropdown-menu dropdown-menu-right" aria-labelledby="dropdownKebab"> <li><a ng-click="$ctrl.linkWithProductVersion()" ng-hide="$ctrl.groupConfig.productVersion.id" href><i class="fa fa-link" aria-hidden="true"></i> Link With Product Version</a></li> <li><a ng-show="$ctrl.groupConfig.productVersion.id" pnc-confirm-click="$ctrl.unlinkFromProductVersion()" pnc-confirm-message="{{ \'Are you sure you want to unlink \' + $ctrl.formModel.name + \' from its product version?\' }}" href><i class="fa fa-chain-broken" aria-hidden="true"></i> Unlink From Product Version</a></li> </ul> </div> </div> </pnc-header-buttons> </pnc-header> <form editable-form class="form-horizontal" name="groupConfigEditForm" onbeforesave="$ctrl.update($data)" novalidate> <div class="form-group" ng-class="{ \'has-error\': groupConfigEditForm.name.$invalid && !groupConfigEditForm.name.$pristine, \'has-success\': groupConfigEditForm.name.$valid && groupConfigEditForm.name.$touched }"> <label for="input-name" class="col-md-1 control-label" ng-class="{ \'required\': groupConfigEditForm.$visible }">Name</label> <div class="col-md-11"> <p id="input-name" class="form-control-static" e-class="form-control" editable-text="$ctrl.formModel.name" e-name="name" e-maxlength="255" e-required>{{ $ctrl.formModel.name || \'Empty\' }}</p> <span class="help-block" ng-show="groupConfigEditForm.name.$error.required && !groupConfigEditForm.name.$pristine">Required field.</span> </div> </div> <div class="form-group"> <label for="product-version-name" class="col-md-1 control-label">Product Version</label> <div class="col-md-11"> <p id="product-version-name" class="form-control-static"> <span ng-if="$ctrl.productVersion"> <pnc-product-version-link product-version="$ctrl.productVersion"></pnc-product-version-link> </span> <span ng-if="!$ctrl.productVersion"> none </span> </p> </div> </div> <div class="form-group" ng-show="groupConfigEditForm.$visible"> <div class="col-sm-offset-1 col-sm-11"> <button type="submit" class="btn btn-primary" ng-disabled="groupConfigEditForm.$waiting || groupConfigEditForm.name.$invalid"> Save </button> <button type="button" class="btn btn-default" ng-disabled="groupConfigEditForm.$waiting" ng-click="groupConfigEditForm.$cancel(); groupConfigEditForm.$setPristine(); groupConfigEditForm.$setUntouched();"> Cancel </button> </div> </div> </form> </div> </div> <div class="row"> <div class="col-md-12"> <ul class="nav nav-tabs"> <li role="presentation" ui-sref-active="active"> <a href ui-sref="group-configs.detail.build-configs">Build Configs</a> </li> <li role="presentation" ui-sref-active="active"> <a href ui-sref="group-configs.detail.build-history" href>Build History</a> </li> </ul> </div> </div> <div class="row"> <div class="col-md-12"> <div class="m-t-20" ui-view> </div> </div> </div> '),e.put("group-configs/list/pnc-group-configs-list-page.html",' <div> <pnc-header> <pnc-header-title>Group Configs</pnc-header-title> <pnc-header-buttons> <button type="button" class="btn btn-lg btn-default" data-toggle="tooltip" title="Create Group Config" ui-sref="group-configs.create"> <i class="fa fa-file-text-o"></i> Create </button> </pnc-header-buttons> </pnc-header> <div class="row"> <pnc-toolbar filtering-page="$ctrl.paginator" filtering-fields="$ctrl.filterFields" sorting-fields="$ctrl.groupConfigsSortingFields" sorting-configs="$ctrl.groupConfigsSortingConfigs"></pnc-toolbar> </div> <div> <pnc-group-configs-list group-configs="$ctrl.paginator.data"></pnc-group-configs-list> <pnc-page-controls class="pull-right m-b-10" pnc-page="$ctrl.paginator" ng-if="$ctrl.paginator"></pnc-page-controls> </div> </div> '),e.put("product-milestones/close-result/pnc-product-milestone-close-result-page.html",' <div class="page-header"> <h1>Close Result</h1> </div> <dl class="dl-horizontal"> <dt>Id:</dt> <dd>{{ $ctrl.data.id }}</dd> <dt>Status:</dt> <dd><pnc-milestone-close-status-label close-result="$ctrl.data"></pnc-milestone-close-status-label></dd> <dt>Close Started:</dt> <dd>{{ $ctrl.data.startingDate | date:\'medium\' }}</dd> <dt>Close Finished:</dt> <dd>{{ ($ctrl.data.endDate | date:\'medium\') || \'&mdash;\' }}</dd> </dl> <div class="page-header"> <h3>Log</h3> </div> <pnc-bifrost-log-viewer match-filters="$ctrl.matchFilters" prefix-filters="$ctrl.prefixFilters"></pnc-bifrost-log-viewer> '),e.put("product-milestones/close/pnc-product-milestone-close-page.html",' <div> <div class="page-header"> <h1>Close milestone {{ $ctrl.data.version }}</h1> </div> <div class="row"> <div class="col-md-8 col-lg-6"> <form novalidate class="form-horizontal" name="productMilestoneForm" ng-submit="$ctrl.submit()"> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group"> <label for="input-version" class="col-sm-2 control-label">Version</label> <div class="col-sm-10"> <div class="input-group"> <label for="input-version" class="control-label bigger-text">{{$ctrl.data.version}}</label> </div> </div> </div> </div> </div> <div class="form-group"> <div class="col-sm-offset-2 col-sm-10"> <input type="submit" class="btn btn-primary" value="Close" ng-disabled="productMilestoneForm.$invalid"> <input type="reset" class="btn btn-default" value="Clear"> </div> </div> </form> </div> </div> </div> '),e.put("product-milestones/components/pnc-milestone-close-status-label/pnc-milestone-close-status-label.html",' <span ng-if="!$ctrl.closeStatus">&mdash;</span> <span ng-if="$ctrl.closeStatus" ng-class="$ctrl.closeStatus.class">{{ $ctrl.closeStatus.text }}</span> '),e.put("product-milestones/components/pnc-product-milestone-actions/pnc-product-milestone-actions.html",' <div class="btn-group"> <button ng-if="$ctrl.productMilestone.endDate" title="Milestone is already closed. No more modifications allowed." class="btn btn-default btn-{{ $ctrl.size ? $ctrl.size : \'lg\'}}" disabled> <i class="fa fa-clock-o"></i> <span ng-if="!$ctrl.size">Milestone is closed</span> </button> <button ng-if="!$ctrl.productMilestone.endDate" pnc-confirm-click="$ctrl.markMilestoneAsCurrent($ctrl.productMilestone)" pnc-confirm-message="{{ \'Mark Milestone \' + $ctrl.productMilestone.version + \' as current ?\'}}" title="Mark Milestone as current" class="btn btn-default btn-{{ $ctrl.size ? $ctrl.size : \'lg\'}}" pnc-requires-auth> <i class="fa fa-clock-o"></i> <span ng-if="!$ctrl.size">Mark as current</span> </button> <button ui-sref="products.detail.product-versions.detail.milestone.update({ productMilestoneId: $ctrl.productMilestone.id })" title="{{ !$ctrl.productMilestone.endDate ? \'Update Milestone\' : \'Milestone is already closed. No more modifications allowed.\'}}" class="btn btn-default btn-{{ $ctrl.size ? $ctrl.size : \'lg\'}}" ng-show="!$ctrl.productMilestone.endDate" pnc-requires-auth> <i class="pficon pficon-edit"></i> <span ng-if="!$ctrl.size">Update</span> </button> <button ui-sref="products.detail.product-versions.detail.milestone.close({ productMilestoneId: $ctrl.productMilestone.id })" title="{{ !$ctrl.productMilestone.endDate ? \'Close Milestone\' : \'Milestone is already closed. No more modifications allowed.\'}}" class="btn btn-default btn-{{ $ctrl.size ? $ctrl.size : \'lg\'}}" ng-show="!$ctrl.productMilestone.endDate" pnc-requires-auth> <i class="fa fa-lock"></i> <span ng-if="!$ctrl.size">Close</span> </button> </div> '),e.put("product-milestones/components/pnc-product-milestone-builds/pnc-product-milestone-builds.html",' <div class="row"> <pnc-toolbar filtering-page="$ctrl.performedBuildsFilteringPage" filtering-fields="$ctrl.performedBuildsFilteringFields" sorting-fields="$ctrl.performedBuildsSortingFields" sorting-configs="$ctrl.performedBuildsSortingConfigs"></pnc-toolbar> </div> <div> <pnc-builds-list builds="$ctrl.performedBuildsFilteringPage.data" display-fields="$ctrl.displayFields"></pnc-builds-list> <pnc-page-controls class="pull-right m-b-10" pnc-page="$ctrl.performedBuildsFilteringPage" ng-if="$ctrl.performedBuildsFilteringPage"></pnc-page-controls> </div> '),e.put("product-milestones/components/pnc-product-milestone-close-results-data-table/pnc-product-milestone-close-results-data-table.html",' <pnc-product-milestone-close-results-list close-results="$ctrl.closeResults.data" display-fields="$ctrl.displayFields"></pnc-product-milestone-close-results-list> <pnc-page-controls class="pull-right m-b-10" pnc-page="$ctrl.filterPage"></pnc-page-controls> '),e.put("product-milestones/components/pnc-product-milestone-close-results-data-table/pnc-product-milestone-close-results-list.html",' <table class="table table-bordered table-striped table-hover pnc-builds-list" ng-show="$ctrl.showTable()"> <thead> <th ng-if="::$ctrl.showColumn(\'endDate\')">Date</th> <th ng-if="::$ctrl.showColumn(\'status\')">Status</th> </thead> <tbody> <tr ng-repeat="item in $ctrl.items"> <td ng-if="::$ctrl.showColumn(\'endDate\')"> <a href ui-sref="products.detail.product-versions.detail.milestone.detail.close-result({ closeResultId: item.id })">{{ (item.endDate || item.startingDate) | date:\'medium\' }}</a> </td> <td ng-if="::$ctrl.showColumn(\'status\')" class="text-center"> <pnc-milestone-close-status-label close-result="item"></pnc-milestone-close-status-label> </td> </tr> </tbody> </table> <table ng-hide="$ctrl.showTable()" class="table table-bordered table-striped table-hover build-status-table actions-table"> <tbody> <tr> <td class="text-center p-t-10 p-b-10"><em>There are no close results to display</em></td> </tr> </tbody> </table> '),e.put("product-milestones/components/pnc-product-milestone-link/pnc-product-milestone-link.html",' <script type="text/ng-template" id="tooltipTemplateProductMilestone.html"> <strong>Start Date: </strong>{{::$ctrl.productMilestone.startingDate | date:\'mediumDate\'}}<br>\n  <strong>Planned End Date: </strong>{{::$ctrl.productMilestone.plannedEndDate | date:\'mediumDate\'}}<br>\n  <strong>End Date: </strong>{{::$ctrl.productMilestone.endDate | date:\'mediumDate\'}}<br> <\/script> <span class="inline-block m-t-5 m-b-5"> <a class="label label-default" ng-class="{ \'label-primary\' : $ctrl.isCurrentProductMilestone() }" ui-sref="products.detail.product-versions.detail.milestone.detail({  productVersionId: $ctrl.productVersion.id, productMilestoneId: $ctrl.productMilestone.id })" tooltip-placement="right" uib-tooltip-template="\'tooltipTemplateProductMilestone.html\'"> {{ ::$ctrl.productMilestone.version }} </a> </span>'),e.put("product-milestones/components/pnc-product-milestones-list/pnc-product-milestones-list.html",' <table class="table table-bordered table-striped"> <thead> <th>Name</th> <th>Starting date</th> <th>Planned release date</th> <th>Release date</th> <th>Actions</th> </thead> <tbody> <tr ng-repeat="productMilestone in $ctrl.productMilestones | orderBy:\'version\'"> <td> <pnc-product-milestone-link product-version="$ctrl.productVersion" product-milestone="productMilestone"></pnc-product-milestone-link> </td> <td>{{ productMilestone.startingDate | date:\'yyyy/MM/dd\'}}</td> <td>{{ productMilestone.plannedEndDate | date:\'yyyy/MM/dd\'}}</td> <td>{{ productMilestone.endDate | date:\'yyyy/MM/dd\'}}</td> <td ng-if="!productMilestone.endDate" class="text-center"> <pnc-product-milestone-actions product-milestone="productMilestone" product="$ctrl.product" product-version="$ctrl.productVersion" size="md"></pnc-product-milestone-actions> </td> <td ng-if="productMilestone.endDate" class="text-center" title="Milestone is already closed. No more modifications allowed."> Milestone is closed <span class="fa fa-info-circle"></span> </td> </tr> </tbody> </table> '),e.put("product-milestones/create-update/pnc-product-milestone-create-update-page.html",' <div> <div class="page-header"> <h1 ng-if="!$ctrl.isUpdating">Create milestone for {{ $ctrl.product.name }} {{ $ctrl.productVersion.version }}</h1> <h1 ng-if="$ctrl.isUpdating">Update milestone {{ $ctrl.data.version }} of {{ $ctrl.product.name }} {{ $ctrl.productVersion.version }}</h1> </div> <div class="row"> <div class="col-md-8 col-lg-6"> <form novalidate class="form-horizontal" name="productMilestoneForm" ng-submit="$ctrl.submit()"> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : productMilestoneForm.version.$invalid && !productMilestoneForm.version.$pristine }"> <label for="input-version" class="col-sm-2 control-label"> * Version&nbsp;<a uib-popover="Release part of the product version, e.g. \'0.ER1\' for product version \'1.0\'." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <div class="input-group"> <span class="input-group-addon">{{ $ctrl.productVersion.version }}.</span> <div class="input-validation-spinner"> <input required id="input-version" class="form-control" name="version" maxlength="255" ng-model="$ctrl.version" error-messages="$ctrl.productMilestoneVersionErrorMessages" product-milestone-version-validator product-version="{{$ctrl.productVersion.version}}" product-version-id="{{$ctrl.productVersion.id}}"> <span ng-show="productMilestoneForm.version.$pending.productMilestoneVersionValidator" class="spinner spinner-sm"></span> </div> </div> <span class="help-block" ng-show="productMilestoneForm.version.$error.required && !productMilestoneForm.version.$pristine">Required field.</span> <div class="help-block" ng-show="productMilestoneForm.version.$error.productMilestoneVersionValidator"> <div ng-repeat="errorMessage in $ctrl.productMilestoneVersionErrorMessages">{{ errorMessage }}</div> </div> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : productMilestoneForm.startingDate.$invalid && !productMilestoneForm.startingDate.$pristine }"> <label for="input-start-date" class="col-sm-2 control-label"> * Start Date&nbsp;<a uib-popover="Start date, e.g. \'2035/01/15\', time is set to noon UTC." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <div class="input-group"> <input type="text" class="form-control" uib-datepicker-popup="yyyy/MM/dd" ng-model="$ctrl.startingDate" is-open="$ctrl.startingDateOpen" ng-required="true"> <span class="input-group-btn"> <button type="button" class="btn btn-default" ng-click="$ctrl.startingDateOpen = !$ctrl.startingDateOpen"><i class="glyphicon glyphicon-calendar"></i></button> </span> </div> <span class="help-block" ng-show="productMilestoneForm.startingDate.$error.required && !productMilestoneForm.startingDate.$pristine">Required field.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\' : (productMilestoneForm.plannedEndDate.$invalid || $ctrl.invalidStartingPlannedEndDates($ctrl.startingDate, $ctrl.plannedEndDate)) && !productMilestoneForm.plannedEndDate.$pristine }"> <label for="input-end-date" class="col-sm-2 control-label"> * Planned End Date&nbsp;<a uib-popover="Planned handoff date, e.g. \'2035/01/15\', time is set to noon UTC." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <div class="input-group"> <input type="text" class="form-control" uib-datepicker-popup="yyyy/MM/dd" ng-model="$ctrl.plannedEndDate" is-open="$ctrl.plannedEndDateOpen" ng-required="true"> <span class="input-group-btn"> <button type="button" class="btn btn-default" ng-click="$ctrl.plannedEndDateOpen = !$ctrl.plannedEndDateOpen"><i class="glyphicon glyphicon-calendar"></i></button> </span> </div> <span class="help-block" ng-show="productMilestoneForm.plannedEndDate.$error.required && !productMilestoneForm.plannedEndDate.$pristine">Required field.</span> <span class="help-block" ng-show="$ctrl.invalidStartingPlannedEndDates($ctrl.startingDate, $ctrl.plannedEndDate) && !productMilestoneForm.plannedEndDate.$pristine">Planned release date must be after start date.</span> </div> </div> </div> </div> <div class="form-group"> <div class="col-sm-offset-2 col-sm-10"> <div class="checkbox"> <label> <input type="checkbox" id="input-set-current" name="current" ng-disabled="$ctrl.setCurrentMilestoneDisabled" ng-model="$ctrl.setCurrentMilestone"> Set as the current milestone for {{ $ctrl.product.name }} {{ $ctrl.productVersion.version }} </label> </div> </div> </div> <div class="form-group"> <div class="col-sm-offset-2 col-sm-10"> <input ng-if="!$ctrl.isUpdating" type="submit" class="btn btn-primary" value="Create" ng-disabled="productMilestoneForm.$invalid || productMilestoneForm.$pending || (productMilestoneForm.plannedEndDate.$invalid || $ctrl.invalidStartingPlannedEndDates($ctrl.startingDate, $ctrl.plannedEndDate))"> <input ng-if="$ctrl.isUpdating" type="submit" class="btn btn-primary" value="Update" ng-disabled="productMilestoneForm.$invalid || productMilestoneForm.$pending || (productMilestoneForm.plannedEndDate.$invalid || $ctrl.invalidStartingPlannedEndDates($ctrl.startingDate, $ctrl.plannedEndDate))"> <input type="reset" class="btn btn-default" value="Clear"> </div> </div> </form> </div> </div> </div> '),e.put("product-milestones/detail/pnc-product-milestone-detail-page.html",' <div> <pnc-header> <pnc-header-title>Product Milestone {{ $ctrl.productMilestone.version }}</pnc-header-title> <pnc-header-buttons> <pnc-product-milestone-actions product-milestone="$ctrl.productMilestone" product="$ctrl.product" product-version="$ctrl.productVersion"></pnc-product-milestone-actions> </pnc-header-buttons> </pnc-header> <div class="row"> <div class="col-md-12"> <dl class="dl-horizontal"> <dt>Status</dt> <dd>{{ $ctrl.closeStatus }}</dd> <dt>Start Date</dt> <dd>{{ $ctrl.productMilestone.startingDate | date:\'yyyy/MM/dd\' }}</dd> <dt>Planned End Date</dt> <dd>{{ $ctrl.productMilestone.plannedEndDate | date:\'yyyy/MM/dd\' }}</dd> <dt>End Date</dt> <dd>{{ ($ctrl.productMilestone.endDate | date:\'yyyy/MM/dd\') || \'&mdash;\' }}</dd> <dt>Last Close Result</dt> <dd><pnc-milestone-close-status-label close-result="$ctrl.latestCloseResult"></pnc-milestone-close-status-label></dd> </dl> </div> </div> <div class="row"> <div class="col-lg-6"> <pnc-header> <pnc-header-title sub-header="true"> <small>Builds Performed</small> </pnc-header-title> </pnc-header> <pnc-product-milestone-builds product-milestone="$ctrl.productMilestone" performed-builds="$ctrl.performedBuilds"></pnc-product-milestone-builds> </div> <div class="col-lg-6"> <pnc-header> <pnc-header-title sub-header="true"> <small>Close Results</small> </pnc-header-title> </pnc-header> <pnc-product-milestone-close-results-data-table close-results="$ctrl.closeResults"></pnc-product-milestone-close-results-data-table> </div> </div> </div> '),e.put("product-releases/components/pnc-product-release-label/pnc-product-release-label.html",' <script type="text/ng-template" id="tooltipTemplateRelease.html"> <strong>Release Date: </strong>{{::$ctrl.productRelease.releaseDate | date:\'mediumDate\'}}<br>\n  <strong>Milestone: </strong>{{::$ctrl.productRelease.version }}<br>\n  <strong>Support Level: </strong>{{::$ctrl.productRelease.supportLevel }}<br> <\/script> <span class="inline-block m-t-5 m-b-5"> <span class="label label-success" tooltip-placement="right" uib-tooltip-template="\'tooltipTemplateRelease.html\'"> {{ ::$ctrl.productRelease.version }} </span> </span> '),e.put("product-releases/components/pnc-product-releases-list/pnc-product-releases-list.html",' <table class="table table-bordered table-striped"> <thead> <th>Name</th> <th>Release date</th> <th>Info</th> <th>Support Level</th> <th>Actions</th> </thead> <tbody> <tr ng-repeat="productRelease in $ctrl.productReleases | orderBy:\'version\'"> <td> <pnc-product-release-label product-release="productRelease"></pnc-product-release-label> </td> <td>{{ productRelease.releaseDate | date:\'yyyy/MM/dd\'}}</td> <td>Released from milestone <pnc-milestone-label-link product-version="productRelease.productVersion" milestone="productRelease.productMilestone"></pnc-milestone-label-link></td> <td>{{ productRelease.supportLevel }}</td> <td> <button type="button" class="btn btn-sm btn-default" data-toggle="tooltip" title="Edit Release" ui-sref="products.detail.product-versions.detail.release.update({ releaseId: productRelease.id })"> <i class="pficon pficon-edit"></i> </button> <button type="button" class="btn btn-sm btn-danger disabled" data-toggle="tooltip" title="Delete Release"> <i class="pficon pficon-delete"></i> </button> </td> </tr> </tbody> </table> '),e.put("product-releases/create-update/pnc-product-release-create-update-page.html",' <div> <div class="page-header"> <h1 ng-if="!$ctrl.isUpdating">Create release for {{ $ctrl.product.name }} {{ $ctrl.productVersion.version }}</h1> <h1 ng-if="$ctrl.isUpdating">Update release {{ $ctrl.data.version }} of {{ $ctrl.product.name }} {{ $ctrl.productVersion.version }}</h1> </div> <div class="row"> <div class="col-md-8 col-lg-6"> <div class="alert alert-warning" ng-if="$ctrl.isLoaded && !$ctrl.isUpdating && !$ctrl.productMilestonesWithoutProductRelease.length"> <span class="pficon pficon-warning-triangle-o"></span> <strong>New Product Release cannot be created.</strong> No Product Milestone without already assigned Product Release exists. </div> <form class="form-horizontal" name="productReleaseForm" novalidate ng-submit="$ctrl.submit()"><fieldset ng-disabled="!$ctrl.isUpdating && !$ctrl.productMilestonesWithoutProductRelease.length"> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : productReleaseForm.version.$invalid && !productReleaseForm.version.$pristine }"> <label for="input-version" class="col-sm-2 control-label"> * Version&nbsp;<a uib-popover="Release part of the product version, e.g. \'0.GA\' for product version \'1.0\'." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <div class="input-group"> <span class="input-group-addon">{{ $ctrl.productVersion.version }}.</span> <input required id="input-version" class="form-control" name="version" maxlength="255" ng-model="$ctrl.version" pattern="^[0-9]+\\.[\\w]+$"> </div> <span class="help-block" ng-show="productReleaseForm.version.$error.required && !productReleaseForm.version.$pristine">Required field.</span> <span class="help-block" ng-show="productReleaseForm.version.$error.pattern && !productReleaseForm.version.$pristine">Version must start with a number, followed by a dot and then a qualifier (e.g GA)</span> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : productReleaseForm.releaseDate.$invalid && !productReleaseForm.releaseDate.$pristine }"> <label for="input-end-date" class="col-sm-2 control-label"> * Release date&nbsp;<a uib-popover="Release date, e.g. \'2035/01/15\', time is set to noon UTC." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <div class="input-group"> <input type="text" class="form-control" uib-datepicker-popup="yyyy/MM/dd" ng-model="$ctrl.releaseDate" is-open="$ctrl.releaseDateOpen" ng-required="true"> <span class="input-group-btn"> <button type="button" class="btn btn-default" ng-click="$ctrl.releaseDateOpen = !$ctrl.releaseDateOpen"><i class="glyphicon glyphicon-calendar"></i></button> </span> </div> <span class="help-block" ng-show="productReleaseForm.releaseDate.$error.required && !productReleaseForm.releaseDate.$pristine">Required field.</span> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : productReleaseForm.milestone.$invalid && !productReleaseForm.milestone.$pristine }"> <label for="input-milestone" class="col-sm-2 control-label">* From Milestone </label> <div ng-if="!$ctrl.isUpdating" class="col-sm-10"> <span ng-if="!$ctrl.productMilestonesWithoutProductRelease.length">---</span> <select ng-if="$ctrl.productMilestonesWithoutProductRelease.length" id="input-milestone" required name="milestone" ng-model="$ctrl.productMilestoneId"> <option></option> <option ng-repeat="productMilestone in $ctrl.productMilestonesWithoutProductRelease" value="{{ productMilestone.id }}"> {{ productMilestone.version }} </option> </select> <span class="help-block" ng-show="productReleaseForm.milestone.$invalid && !productReleaseForm.milestone.$pristine">Required field.</span> </div> <div ng-if="$ctrl.isUpdating" class="col-sm-10"> <label for="input-milestone" class="control-label bigger-text">{{ $ctrl.data.productMilestone.version }}</label> </div> </div> <div class="form-group" ng-class="{ \'has-error\' : productReleaseForm.supportlevel.$invalid && !productReleaseForm.supportlevel.$pristine }"> <label for="input-supportlevel" class="col-sm-2 control-label">* Support Level </label> <div class="col-sm-10"> <select id="input-supportlevel" required name="supportlevel" ng-model="$ctrl.data.supportLevel" ng-options="supportLevel for supportLevel in $ctrl.supportLevels"> <option></option> </select> <span class="help-block" ng-show="productReleaseForm.supportlevel.$invalid && !productReleaseForm.supportlevel.$pristine">Required field.</span> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : productReleaseForm.commonPlatformEnumeration.$invalid && !productReleaseForm.commonPlatformEnumeration.$pristine }"> <label for="input-common-platform-enumeration" class="col-sm-2 control-label"> Common Platform Enumeration (CPE)&nbsp;<a uib-popover="Common Platform Enumeration associated with the Product Release. CPEs are used to map packages that are security-relevant and delivered via security errata back to products and by the CVE Engine to map errata to containers when grading (e.g. \'cpe:/a:redhat:jboss_data_grid:7.3.5\'). Can be retrieved from the Product Pages." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <div class="input-group"> <input type="text" name="commonPlatformEnumeration" id="input-common-platform-enumeration" class="form-control" name="commonPlatformEnumeration" maxlength="255" ng-model="$ctrl.data.commonPlatformEnumeration"> </div> </div> </div> </div> </div> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : productReleaseForm.productPagesCode.$invalid && !productReleaseForm.productPagesCode.$pristine }"> <label for="input-product-pages-code" class="col-sm-2 control-label"> Product Pages Code&nbsp;<a uib-popover="Code associated with the Product Release in the Product Pages (e.g. \'rhdg-7-3.5\')." popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href><span class="fa fa-info-circle"></span></a> </label> <div class="col-sm-10"> <div class="input-group"> <input type="text" name="productPagesCode" id="input-product-pages-code" class="form-control" name="productPagesCode" maxlength="50" ng-model="$ctrl.data.productPagesCode"> </div> </div> </div> </div> </div> <div class="form-group"> <div class="col-sm-offset-2 col-sm-10"> <input ng-if="!$ctrl.isUpdating" type="submit" class="btn btn-primary" value="Create" ng-disabled="productReleaseForm.$invalid"> <input ng-if="$ctrl.isUpdating" type="submit" class="btn btn-primary" value="Update" ng-disabled="productReleaseForm.$invalid"> <input type="reset" class="btn btn-default" value="Clear"> </div> </div> </fieldset></form> </div> </div> </div> '),e.put("product-versions/components/pnc-product-version-link/pnc-product-version-link.html",' <div ng-if="$ctrl.isProductVersionLoading" class="spinner spinner-sm pull-left"></div> <div ng-if="!$ctrl.isProductVersionLoading"> <a ng-if="$ctrl.productVersionData && $ctrl.productVersionData.id" href ui-sref="products.detail.product-versions.detail({ productVersionId: $ctrl.productVersionData.id, productId: $ctrl.productVersionData.product.id })"> {{$ctrl.productVersionData.product.name}} - {{$ctrl.productVersionData.version}} </a> <span ng-if="!$ctrl.productVersionData || !$ctrl.productVersionData.id"> — </span> </div> '),e.put("product-versions/components/pnc-product-versions-data-table/pnc-product-versions-data-table.html",' <div> <pnc-product-versions-list product-versions="$ctrl.paginator.data" display-fields="$ctrl.displayFields"></pnc-product-versions-list> <pnc-page-controls class="pull-right m-t-10" pnc-page="$ctrl.paginator" ng-if="$ctrl.page"></pnc-page-controls> </div> '),e.put("product-versions/components/pnc-product-versions-data-table/pnc-product-versions-list.html",' <table class="table table-bordered table-striped table-hover" ng-show="$ctrl.showTable()"> <thead> <th ng-if="::$ctrl.showColumn(\'name\')" class="shrink-to-fit">Name</th> <th ng-if="::$ctrl.showColumn(\'version\')">Version</th> <th ng-if="::$ctrl.showColumn(\'milestones\')">Milestones</th> <th ng-if="::$ctrl.showColumn(\'releases\')">Releases</th> <th ng-if="::$ctrl.actionsTemplateUrl">Actions</th> </thead> <tbody> <tr ng-repeat="productVersion in $ctrl.productVersions"> <td ng-if="::$ctrl.showColumn(\'name\')" class="shrink-to-fit"> <a ui-sref="products.detail({ productId: productVersion.product.id })" href> {{ productVersion.product.name }} </a> </td> <td ng-if="::$ctrl.showColumn(\'version\')"> <a ui-sref="products.detail.product-versions.detail({ productId: productVersion.product.id, productVersionId: productVersion.id })" href> {{ productVersion.version }} </a> </td> <td ng-if="::$ctrl.showColumn(\'milestones\')"> <span ng-repeat="productMilestone in productVersion.productMilestones"> <pnc-product-milestone-link product-milestone="productMilestone" product-version="productVersion"></pnc-product-milestone-link> </span> </td> <td ng-if="::$ctrl.showColumn(\'releases\')"> <span ng-repeat="release in productVersion.productReleases"> <pnc-product-release-label product-release="release"></pnc-product-release-label> </span> </td> <td class="td-actions" ng-if="::$ctrl.actionsTemplateUrl" ng-include="::$ctrl.actionsTemplateUrl"></td> </tr> </tbody> </table> <p ng-hide="$ctrl.showTable()" class="text-center"><em>There are no Product Versions to display</em></p> '),e.put("product-versions/create/pnc-create-product-version-form.html",' <form class="form-horizontal" name="productVersionForm" ng-submit="$ctrl.submit($ctrl.formData)" novalidate> <div class="form-group" ng-class="{ \'has-error\' : productVersionForm.version.$invalid && !productVersionForm.version.$pristine, \'has-success\': productVersionForm.version.$valid && productVersionForm.version.$touched }"> <label for="input-version" class="col-sm-3 col-lg-2 control-label required"> Version&nbsp; <a uib-popover="This represents a set of milestones and releases which correspond to a major.minor version of a product, e.g 7.0" popover-placement="right" popover-class="popover-info-tip" popover-append-to-body="true" href> <span class="fa fa-info-circle"></span> </a> </label> <div class="col-sm-9 col-lg-7"> <input id="input-version" class="form-control" name="version" maxlength="255" ng-model="$ctrl.formData.version" required pattern="^[0-9]+\\.[0-9]+$"> <span class="help-block" ng-show="productVersionForm.version.$error.required && !productVersionForm.version.$pristine">Required field.</span> <span class="help-block" ng-show="productVersionForm.version.$error.pattern && !productVersionForm.version.$pristine">The version should consist of two numeric parts separated by a dot (e.g 7.0).</span> </div> </div> <div class="form-group"> <div class="col-sm-offset-3 col-lg-offset-2 col-sm-9 col-lg-10"> <input type="submit" class="btn btn-primary" value="Submit" ng-disabled="productVersionForm.$invalid"> <input type="reset" class="btn btn-default" value="Reset" ng-click="$ctrl.reset(productVersionForm)"> </div> </div> </form> '),e.put("product-versions/create/pnc-create-product-version-page.html",' <div class="page-header"> <h1>Create Product Version</h1> </div> <div class="row"> <div class="col-md-11 col-lg-10"> <pnc-create-product-version-form product="$ctrl.product"></pnc-create-product-version-form> </div> </div> '),e.put("product-versions/detail/pnc-product-version-detail-page.html",' <pnc-header> <pnc-header-title>{{ ::$ctrl.getFullName() }}</pnc-header-title> <pnc-header-buttons> <button type="button" class="btn btn-lg btn-default" data-toggle="tooltip" title="Edit Product Version" ng-click="productVersionForm.$show()" ng-class="{ \'active\': productVersionForm.$visible }" pnc-requires-auth> <i class="pficon pficon-edit"></i> Edit </button> </pnc-header-buttons> </pnc-header> <div class="row"> <div class="col-md-11 col-lg-10"> <form editable-form class="form-horizontal" name="productVersionForm" onbeforesave="$ctrl.save($data)" novalidate> <div class="form-group" ng-class="{ \'has-error\': productVersionForm.version.$invalid && !productVersionForm.version.$pristine, \'has-success\': productVersionForm.version.$valid && productVersionForm.version.$touched }"> <label for="input-version" class="col-sm-3 col-lg-2 control-label" ng-class="{ \'required\': productVersionForm.$visible }">Version</label> <div class="col-sm-9 col-lg-7"> <p id="input-version" edit-disabled="$ctrl.closedMilestone.length" e-pattern="^[0-9]+\\.[0-9]+$" e-class="form-control" editable-text="$ctrl.productVersion.version" e-name="version" e-maxlength="255" e-required>{{ $ctrl.productVersion.version || \'Empty\' }} </p> <span class="help-block" ng-show="productVersionForm.version.$error.required && !productVersionForm.version.$pristine">Required field.</span> <span class="help-block" ng-show="productVersionForm.version.$error.pattern && !productVersionForm.version.$pristine">The version should consist of two numeric parts separated by a dot (e.g 7.0).</span> </div> </div> <div class="form-group"> <label for="input-name" class="col-sm-3 col-lg-2 control-label">Product Name</label> <div class="col-sm-9 col-lg-7"> <a id="input-name" href ui-sref="products.detail({ productId: $ctrl.productVersion.product.id})"> {{ $ctrl.productVersion.product.name || \'Empty\' }} </a> </div> </div> <div class="form-group"> <label for="static-description" class="col-sm-3 col-lg-2 control-label">Product Description</label> <div class="col-sm-9 col-lg-7"> <p id="static-description" class="form-control-static">{{ $ctrl.productVersion.product.description || \'Empty\' }}</p> </div> </div> <div class="form-group" ng-class="{ \'has-error\': productVersionForm.brewTagPrefix.$invalid && !productVersionForm.brewTagPrefix.$pristine, \'has-success\': productVersionForm.brewTagPrefix.$valid && productVersionForm.brewTagPrefix.$touched }"> <label for="brewTagPrefix" class="col-sm-3 col-lg-2 control-label" ng-class="{ \'required\': productVersionForm.$visible }">Brew Tag Prefix</label> <div class="col-sm-9 col-lg-7"> <p id="brewTagPrefix" e-class="form-control" editable-text="$ctrl.productVersion.attributes.BREW_TAG_PREFIX" e-name="brewTagPrefix" e-maxlength="255" e-required>{{ $ctrl.productVersion.attributes.BREW_TAG_PREFIX || \'Empty\' }}</p> <span class="help-block" ng-show="productVersionForm.brewTagPrefix.$error.required && !productVersionForm.brewTagPrefix.$pristine">Required field.</span> </div> </div> <div class="form-group" ng-show="productVersionForm.$visible"> <div class="col-sm-offset-3 col-lg-offset-2 col-sm-9 col-lg-10"> <button type="submit" class="btn btn-primary" ng-disabled="productVersionForm.$waiting || productVersionForm.$invalid"> Save </button> <button type="reset" class="btn btn-default" ng-disabled="productVersionForm.$waiting" ng-click="productVersionForm.$cancel(); productVersionForm.$setPristine(); productVersionForm.$setUntouched();"> Cancel </button> </div> </div> </form> </div> </div> <div class="row"> <div class="col-lg-6 clearfix"> <pnc-header sub-header="true"> <pnc-header-title>Milestones</pnc-header-title> <pnc-header-buttons> <button type="button" class="btn btn btn-default" data-toggle="tooltip" title="Create Milestone" ui-sref="products.detail.product-versions.detail.milestone.create"> <i class="fa fa-file-text-o"></i> Create </button> </pnc-header-buttons> </pnc-header> <pnc-product-milestones-list product-milestones="$ctrl.productMilestonesPage.data" product-version="$ctrl.productVersion" product="$ctrl.productVersion.product"></pnc-product-milestones-list> <pnc-page-controls class="pull-right m-b-10" pnc-page="$ctrl.productMilestonesPage" ng-if="$ctrl.productMilestonesPage"></pnc-page-controls> </div> <div class="col-lg-6"> <pnc-header sub-header="true"> <pnc-header-title>Releases</pnc-header-title> <pnc-header-buttons> <button type="button" class="btn btn-lg btn-default" data-toggle="tooltip" title="Create Release" ui-sref="products.detail.product-versions.detail.release.create" ng-disabled="version.productMilestones.length < 1"> <i class="fa fa-file-text-o"></i> Create </button> </pnc-header-buttons> </pnc-header> <pnc-product-releases-list product-releases="$ctrl.productReleasesPage.data"></pnc-product-releases-list> <pnc-page-controls class="pull-right m-b-10" pnc-page="$ctrl.productReleasesPage" ng-if="$ctrl.productReleasesPage"></pnc-page-controls> </div> </div> <div class="row"> <div class="col-lg-6"> <pnc-header sub-header="true"> <pnc-header-title>Group Configs</pnc-header-title> </pnc-header> <pnc-group-configs-data-table page="$ctrl.groupConfigs" on-edit="$ctrl.editGroupConfigs" fetch-selected="$ctrl.fetchGroupConfigRefs()"></pnc-group-configs-data-table> </div> <div class="col-lg-6"> <pnc-header sub-header="true"> <pnc-header-title>Build Configs</pnc-header-title> </pnc-header> <pnc-build-configs-data-table page="$ctrl.buildConfigs" on-edit="$ctrl.editBuildConfigs" on-remove="$ctrl.removeBuildConfig" refresh-build-configs="$ctrl.refreshBuildConfigs"></pnc-build-configs-data-table> </div> </div> '),e.put("products/components/pnc-product-link/pnc-product-link.html",' <a ui-sref="products.detail({ productId: $ctrl.product.id })" ng-transclude href>{{ ::$ctrl.product.name }}</a> '),e.put("products/components/pnc-products-data-table/pnc-products-data-table.html",' <div class="row"> <pnc-toolbar sorting-fields="$ctrl.productsSortingFields" sorting-configs="$ctrl.productsSortingConfigs" filtering-page="$ctrl.filterPage" filtering-fields="$ctrl.filterFields" actions-config="$ctrl.toolbarActions"> </pnc-toolbar> </div> <pnc-products-list products="$ctrl.filterPage.data"></pnc-products-list> <pnc-page-controls class="pull-right m-t-10 m-b-10" pnc-page="$ctrl.filterPage" ng-if="$ctrl.filterPage"></pnc-page-controls> '),e.put("products/components/pnc-products-data-table/pnc-products-list.html",' <table class="table table-bordered table-striped push-down" ng-show="$ctrl.showTable()"> <thead> <th ng-if="::$ctrl.showColumn(\'name\')">Name</th> <th ng-if="::$ctrl.showColumn(\'abbreviation\')">Abbreviation</th> <th ng-if="::$ctrl.showColumn(\'description\')">Description</th> </thead> <tbody> <tr ng-repeat="product in $ctrl.products"> <td ng-if="::$ctrl.showColumn(\'name\')"><pnc-product-link product="product"></pnc-product-link></td> <td ng-if="::$ctrl.showColumn(\'abbreviation\')">{{ product.abbreviation }}</td> <td ng-if="::$ctrl.showColumn(\'description\')">{{ product.description }}</td> </tr> </tbody> </table> '),e.put("products/create/pnc-create-product-form.html",' <form name="productForm" class="form-horizontal" novalidate> <div class="form-group" ng-class="{ \'has-error\': productForm.name.$invalid && productForm.name.$touched, \'has-success\': productForm.name.$valid && productForm.name.$touched }"> <label for="input-name" class="col-sm-3 col-lg-2 control-label required">Name</label> <div class="col-sm-9 col-lg-7"> <input type="text" id="input-name" class="form-control" name="name" maxlength="255" ng-model="$ctrl.formData.name" required> <span class="help-block" ng-show="productForm.name.$error.required && productForm.name.$touched">Required field.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': productForm.abbreviation.$invalid && productForm.abbreviation.$touched, \'has-success\': productForm.abbreviation.$valid && productForm.abbreviation.$touched }"> <label for="input-abbreviation" class="col-sm-3 col-lg-2 control-label required">Abbreviation</label> <div class="col-sm-9 col-lg-7"> <input type="text" id="input-abbreviation" class="form-control" name="abbreviation" maxlength="255" ng-model="$ctrl.formData.abbreviation" pattern="[a-zA-Z0-9-]+" required> <span class="help-block" ng-show="productForm.abbreviation.$error.required && productForm.abbreviation.$touched">Required field.</span> <span class="help-block" ng-show="productForm.abbreviation.$error.pattern && productForm.abbreviation.$touched">Abbreviation must match pattern: [a-zA-Z0-9-]+</span> </div> </div> <div class="form-group"> <label for="input-description" class="col-sm-3 col-lg-2 control-label">Description</label> <div class="col-sm-9 col-lg-7"> <textarea id="input-description" class="form-control" name="description" ng-model="$ctrl.formData.description"></textarea> </div> </div> <div class="form-group"> <label for="input-product-managers" class="col-sm-3 col-lg-2 control-label">Product Managers</label> <div class="col-sm-9 col-lg-7"> <input type="text" id="input-product-managers" class="form-control" name="productManagers" maxlength="255" ng-model="$ctrl.formData.productManagers"> </div> </div> <div class="form-group"> <label for="input-product-pages-code" class="col-sm-3 col-lg-2 control-label">Product Pages Code</label> <div class="col-sm-9 col-lg-7"> <input type="text" id="input-product-pages-code" class="form-control" name="productPagesCode" maxlength="50" ng-model="$ctrl.productPagesCode.productManagers"> </div> </div> <div class="form-group"> <div class="col-sm-offset-3 col-lg-offset-2 col-sm-9 col-lg-10"> <button type="submit" class="btn btn-primary" ng-click="$ctrl.create($ctrl.formData)" ng-disabled="productForm.$invalid">Submit</button> <button type="reset" class="btn btn-default" ng-click="$ctrl.reset(productForm)">Reset</button> </div> </div> </form> '),e.put("products/create/pnc-create-product-page.html",' <pnc-header> <pnc-header-title>Create Product</pnc-header-title> </pnc-header> <div class="row"> <div class="col-md-11 col-lg-10"> <pnc-create-product-form></pnc-create-product-form> </div> </div> '),e.put("products/detail/pnc-product-detail-page.html",' <pnc-header> <pnc-header-title>{{ $ctrl.product.name }}</pnc-header-title> <pnc-header-buttons> <button type="button" class="btn btn-lg btn-default" data-toggle="tooltip" title="Edit Product" ng-click="productForm.$show()" ng-class="{ \'active\': productForm.$visible }" pnc-requires-auth><i class="pficon pficon-edit"></i> Edit </button> </pnc-header-buttons> </pnc-header> <div class="row"> <div class="col-md-11 col-lg-10"> <form editable-form class="form-horizontal" name="productForm" onbeforesave="$ctrl.update($data)" novalidate> <div class="form-group" ng-class="{ \'has-error\': productForm.name.$invalid && productForm.name.$touched, \'has-success\': productForm.name.$valid && productForm.name.$touched }"> <label for="input-name" class="col-sm-3 col-lg-2 control-label" ng-class="{ \'required\': productForm.$visible }">Name</label> <div class="col-sm-9 col-lg-7"> <p id="input-name" class="form-control-static" e-class="form-control" editable-text="$ctrl.product.name" e-name="name" e-maxlength="255" e-required>{{ $ctrl.product.name || \'Empty\' }}</p> <span class="help-block" ng-show="productForm.name.$error.required && productForm.name.$touched">Required field.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': productForm.abbreviation.$invalid && productForm.abbreviation.$touched, \'has-success\': productForm.abbreviation.$valid && productForm.abbreviation.$touched }"> <label for="input-abbreviation" class="col-sm-3 col-lg-2 control-label" ng-class="{ \'required\': productForm.$visible }">Abbreviation</label> <div class="col-sm-9 col-lg-7"> <p id="input-abbreviation" class="form-control-static" e-class="form-control" editable-text="$ctrl.product.abbreviation" e-name="abbreviation" e-maxlength="255" e-pattern="[a-zA-Z0-9-]*" e-required>{{ $ctrl.product.abbreviation }}</p> <span class="help-block" ng-show="productForm.abbreviation.$error.required && productForm.abbreviation.$touched">Required field.</span> <span class="help-block" ng-show="productForm.abbreviation.$error.pattern && productForm.abbreviation.$touched">Only letters, numbers and dashes (-) are allowed.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': productForm.description.$invalid && productForm.description.$touched, \'has-success\': productForm.description.$valid && productForm.description.$touched }"> <label for="static-description" class="col-sm-3 col-lg-2 control-label">Description</label> <div class="col-sm-9 col-lg-7"> <p id="input-description" class="form-control-static" e-class="form-control" editable-textarea="$ctrl.product.description" e-name="description">{{ $ctrl.product.description }}</p> </div> </div> <div class="form-group" ng-class="{ \'has-error\': productForm.productManagers.$invalid && productForm.productManagers.$touched, \'has-success\': productForm.productManagers.$valid && productForm.productManagers.$touched }"> <label for="input-product-managers" class="col-sm-3 col-lg-2 control-label">Product Managers</label> <div class="col-sm-9 col-lg-7"> <p id="input-product-managers" class="form-control-static" e-class="form-control" editable-text="$ctrl.product.productManagers" e-name="productManagers">{{ $ctrl.product.productManagers }}</p> </div> </div> <div class="form-group" ng-class="{ \'has-error\': productForm.productPagesCode.$invalid && productForm.productPagesCode.$touched, \'has-success\': productForm.productPagesCode.$valid && productForm.productPagesCode.$touched }"> <label for="input-product-pages-code" class="col-sm-3 col-lg-2 control-label">Product Pages Code</label> <div class="col-sm-9 col-lg-7"> <p id="input-product-pages-code" class="form-control-static" e-class="form-control" editable-text="$ctrl.product.productPagesCode" e-name="productPagesCode">{{ $ctrl.product.productPagesCode }}</p> </div> </div> <div class="form-group" ng-show="productForm.$visible"> <div class="col-sm-offset-1 col-sm-11"> <button type="submit" class="btn btn-primary" ng-disabled="productForm.$waiting || productForm.$invalid"> Save </button> <button type="button" class="btn btn-default" ng-disabled="productForm.$waiting" ng-click="productForm.$cancel(); productForm.$setPristine(); productForm.$setUntouched();"> Cancel </button> </div> </div> </form> </div> </div> <pnc-header sub-header="true"> <pnc-header-title>Product Versions</pnc-header-title> <pnc-header-buttons> <div class="p-l-10"> <button type="button" class="btn btn-lg btn-default" data-toggle="tooltip" title="Create Product Version" ui-sref="products.detail.product-versions.create"> <i class="fa fa-file-text-o"></i> Create </button> </div> </pnc-header-buttons> </pnc-header> <pnc-product-versions-data-table page="$ctrl.productVersions" display-fields="$ctrl.displayFields"></pnc-product-versions-data-table> '),e.put("products/list/pnc-products-list-page.html",' <pnc-header> <pnc-header-title>Products</pnc-header-title> <pnc-header-buttons> <pnc-create-product-button></pnc-create-product-button> <button type="button" class="btn btn-lg btn-default" data-toggle="tooltip" title="Create Product" ui-sref="products.create"> <i class="fa fa-file-text-o"></i> Create </button> </pnc-header-buttons> </pnc-header> <pnc-products-data-table products="$ctrl.products"></pnc-products-data-table> '),e.put("projects/components/pnc-project-link/pnc-project-link.html",' <a href ui-sref="projects.detail({ projectId: $ctrl.project.id })" ng-bind="::$ctrl.project.name"></a> '),e.put("projects/components/pnc-projects-list/pnc-projects-list.html",' <table class="table table-bordered table-striped table-hover" ng-show="$ctrl.showTable()"> <thead ng-hide="::$ctrl.hideHead"> <th ng-if="::$ctrl.showColumn(\'name\')">Name</th> <th ng-if="::$ctrl.showColumn(\'description\')">Description</th> </thead> <tbody> <tr ng-repeat="item in $ctrl.items"> <td ng-if="::$ctrl.showColumn(\'name\')"> <pnc-project-link project="item"></pnc-project-link> </td> <td ng-if="::$ctrl.showColumn(\'description\')"> {{ item.description }} </td> </tr> </tbody> </table> <div ng-hide="$ctrl.showTable()" class="text-center clear-both"><em>There are no items to display</em></div> '),e.put("projects/create/pnc-project-create-page.html",' <pnc-header> <pnc-header-title>Create Project</pnc-header-title> </pnc-header> <div class="row"> <div class="col-md-11 col-lg-10"> <form name="projectForm" class="form-horizontal" novalidate> <div class="form-group" ng-class="{ \'has-error\': projectForm.name.$invalid && projectForm.name.$touched, \'has-success\': projectForm.name.$valid && projectForm.name.$touched }"> <label for="input-name" class="col-sm-3 col-lg-2 control-label">* Name</label> <div class="col-sm-9 col-lg-7"> <input type="text" id="input-name" class="form-control" name="name" maxlength="255" ng-model="project.name" required> <span class="help-block" ng-show="projectForm.name.$error.required && projectForm.name.$touched">Required field.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': projectForm.description.$invalid && projectForm.description.$touched, \'has-success\': projectForm.description.$valid && projectForm.description.$touched }"> <label for="input-description" class="col-sm-3 col-lg-2 control-label">Description</label> <div class="col-sm-9 col-lg-7"> <textarea id="input-description" class="form-control" name="description" ng-model="project.description"></textarea> </div> </div> <div class="form-group" ng-class="{ \'has-error\': projectForm.projectUrl.$invalid && projectForm.projectUrl.$touched, \'has-success\': projectForm.projectUrl.$valid && projectForm.projectUrl.$touched }"> <label for="input-url" class="col-sm-3 col-lg-2 control-label">Project URL</label> <div class="col-sm-9 col-lg-7"> <input type="url" id="input-url" class="form-control" name="projectUrl" maxlength="255" ng-model="project.projectUrl"> <span class="help-block" ng-show="projectForm.projectUrl.$invalid && projectForm.projectUrl.$touched">Malformed URL.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': projectForm.issueTrackerUrl.$invalid && projectForm.issueTrackerUrl.$touched, \'has-success\': projectForm.issueTrackerUrl.$valid && projectForm.issueTrackerUrl.$touched }"> <label for="input-issue-tracker" class="col-sm-3 col-lg-2 control-label">Issue Tracker URL</label> <div class="col-sm-9 col-lg-7"> <input type="url" id="input-issue-tracker" class="form-control" name="issueTrackerUrl" maxlength="255" ng-model="project.issueTrackerUrl"> <span class="help-block" ng-show="projectForm.issueTrackerUrl.$invalid && projectForm.issueTrackerUrl.$touched">Malformed URL.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': projectForm.engineeringTeam.$invalid && projectForm.engineeringTeam.$touched, \'has-success\': projectForm.engineeringTeam.$valid && projectForm.engineeringTeam.$touched }"> <label for="input-engineering-team" class="col-sm-3 col-lg-2 control-label">Engineering Team</label> <div class="col-sm-9 col-lg-7"> <input type="text" id="input-engineering-team" class="form-control" name="engineeringTeam" maxlength="255" ng-model="project.engineeringTeam"> </div> </div> <div class="form-group" ng-class="{ \'has-error\': projectForm.technicalLeader.$invalid && projectForm.technicalLeader.$touched, \'has-success\': projectForm.technicalLeader.$valid && projectForm.technicalLeader.$touched }"> <label for="input-technical-leader" class="col-sm-3 col-lg-2 control-label">Technical Leader</label> <div class="col-sm-9 col-lg-7"> <input type="text" id="input-technical-leader" class="form-control" name="technicalLeader" maxlength="255" ng-model="project.technicalLeader"> </div> </div> <div class="form-group"> <div class="col-sm-offset-3 col-lg-offset-2 col-sm-9 col-lg-10"> <input type="submit" class="btn btn-primary" value="Create" ng-click="$ctrl.create(project)" ng-disabled="projectForm.$invalid"> <input type="reset" class="btn btn-default" value="Clear" ng-click="$ctrl.reset(projectForm)"> </div> </div> </form> </div> </div> '),e.put("projects/detail/pnc-project-detail-page.html",' <pnc-header> <pnc-header-title>{{ ::$ctrl.project.name }}</pnc-header-title> <pnc-header-buttons> <button type="button" class="btn btn-lg btn-default" uib-tooltip="Edit Project" tooltip-placement="top" tooltip-append-to-body="true" tooltip-popup-delay="2500" ng-click="projectForm.$show()" ng-class="{ \'active\': projectForm.$visible }" pnc-requires-auth><i class="pficon pficon-edit"></i> Edit</button> </pnc-header-buttons> </pnc-header> <div class="row"> <div class="col-md-11 col-lg-10"> <form editable-form class="form-horizontal" name="projectForm" onbeforesave="$ctrl.update()" novalidate> <div class="form-group" ng-class="{ \'has-error\': projectForm.name.$invalid && projectForm.name.$touched, \'has-success\': projectForm.name.$valid && projectForm.name.$touched }"> <label for="input-name" class="col-sm-3 col-lg-2 control-label" ng-class="{ \'required\': projectForm.$visible }">Name</label> <div class="col-sm-9 col-lg-7"> <p id="input-name" e-class="form-control" editable-text="$ctrl.project.name" e-name="name" e-maxlength="255" e-required>{{ $ctrl.project.name || \'Empty\' }}</p> <span class="help-block" ng-show="projectForm.name.$error.required && projectForm.name.$touched">Required field.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': projectForm.description.$invalid && projectForm.description.$touched, \'has-success\': projectForm.description.$valid && projectForm.description.$touched }"> <label for="input-description" class="col-sm-3 col-lg-2 control-label">Description</label> <div class="col-sm-9 col-lg-7"> <p id="input-description" e-class="form-control" editable-textarea="$ctrl.project.description" e-name="description">{{ $ctrl.project.description || \'Empty\' }}</p> </div> </div> <div class="form-group" ng-class="{ \'has-error\': projectForm.projectUrl.$invalid && projectForm.projectUrl.$touched, \'has-success\': projectForm.projectUrl.$valid && projectForm.projectUrl.$touched }"> <label for="input-url" class="col-sm-3 col-lg-2 control-label">Project URL</label> <div class="col-sm-9 col-lg-7"> <p id="input-url" e-type="url" e-class="form-control" editable-text="$ctrl.project.projectUrl" e-name="projectUrl" e-maxlength="255">{{ $ctrl.project.projectUrl || \'Empty\' }}</p> <span class="help-block" ng-show="projectForm.projectUrl.$invalid && projectForm.projectUrl.$touched">Malformed URL.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': projectForm.issueTrackerUrl.$invalid && projectForm.issueTrackerUrl.$touched, \'has-success\': projectForm.issueTrackerUrl.$valid && projectForm.issueTrackerUrl.$touched }"> <label for="input-issue-tracker" class="col-sm-3 col-lg-2 control-label">Issue Tracker URL</label> <div class="col-sm-9 col-lg-7"> <p id="input-issue-tracker" e-type="url" e-class="form-control" editable-text="$ctrl.project.issueTrackerUrl" e-name="issueTrackerUrl" e-maxlength="255">{{ $ctrl.project.issueTrackerUrl || \'Empty\' }}</p> <span class="help-block" ng-show="projectForm.issueTrackerUrl.$invalid && projectForm.issueTrackerUrl.$touched">Malformed URL.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': projectForm.engineeringTeam.$invalid && projectForm.engineeringTeam.$touched, \'has-success\': projectForm.engineeringTeam.$valid && projectForm.engineeringTeam.$touched }"> <label for="input-engineering-team" class="col-sm-3 col-lg-2 control-label">Engineering Team</label> <div class="col-sm-9 col-lg-7"> <p id="input-engineering-team" e-class="form-control" editable-text="$ctrl.project.engineeringTeam" e-name="engineeringTeam" e-maxlength="255">{{ $ctrl.project.engineeringTeam || \'Empty\' }}</p> </div> </div> <div class="form-group" ng-class="{ \'has-error\': projectForm.technicalLeader.$invalid && projectForm.technicalLeader.$touched, \'has-success\': projectForm.technicalLeader.$valid && projectForm.technicalLeader.$touched }"> <label for="input-technical-leader" class="col-sm-3 col-lg-2 control-label">Technical Leader</label> <div class="col-sm-9 col-lg-7"> <p id="input-technical-leader" e-class="form-control" editable-text="$ctrl.project.technicalLeader" e-name="technicalLeader" e-maxlength="255">{{ $ctrl.project.technicalLeader || \'Empty\' }}</p> </div> </div> <div class="form-group" ng-show="projectForm.$visible"> <div class="col-sm-offset-3 col-lg-offset-2 col-sm-9 col-lg-10"> <button type="submit" class="btn btn-primary" ng-disabled="projectForm.$waiting || projectForm.$invalid"> Save </button> <button type="button" class="btn btn-default" ng-disabled="projectForm.$waiting" ng-click="projectForm.$cancel(); projectForm.$setPristine(); projectForm.$setUntouched();"> Cancel </button> </div> </div> </form> </div> </div> <pnc-header sub-header="true"> <pnc-header-title>Build Configs</pnc-header-title> <pnc-header-buttons> <pnc-create-build-config-button project="$ctrl.project"></pnc-create-build-config-button> </pnc-header-buttons> </pnc-header> <div class="row"> <pnc-toolbar filtering-page="$ctrl.buildConfigsFilteringPage" filtering-fields="$ctrl.buildConfigsFilteringFields"></pnc-toolbar> </div> <div> <pnc-build-configs-list build-configs="$ctrl.buildConfigsFilteringPage.data" display-fields="$ctrl.buildConfigsDisplayFields"></pnc-build-configs-list> <pnc-page-controls class="pull-right m-t-10 m-b-10" pnc-page="$ctrl.buildConfigsFilteringPage" ng-if="$ctrl.buildConfigsFilteringPage"></pnc-page-controls> </div> '),e.put("projects/list/pnc-projects-list-page.html",' <pnc-header> <pnc-header-title>Projects</pnc-header-title> <pnc-header-buttons> <button type="button" class="btn btn-lg btn-default" data-toggle="tooltip" title="Create Project" ui-sref="projects.create"> <i class="fa fa-file-text-o"></i> Create </button> </pnc-header-buttons> </pnc-header> <div class="row"> <pnc-toolbar filtering-page="$ctrl.projectsFilteringPage" filtering-fields="$ctrl.projectsFilteringFields" sorting-fields="$ctrl.projectsSortingFields" sorting-configs="$ctrl.projectsSortingConfigs"></pnc-toolbar> </div> <div> <pnc-projects-list projects="$ctrl.projectsFilteringPage.data"></pnc-projects-list> <pnc-page-controls class="pull-right m-b-10" pnc-page="$ctrl.projectsFilteringPage" ng-if="$ctrl.projectsFilteringPage"></pnc-page-controls> </div> '),e.put("report/directives/pnc-project-repository-form/pnc-project-repository-form.html",' <form class="form-horizontal" name="pncProjectRepositoryForm" novalidate> <div class="panel panel-default"> <div class="panel-body"> <div class="form-group" ng-class="{ \'has-error\' : !scmUrl && pncProjectRepositoryForm.scmUrl.$touched, \'has-success\': scmUrl && pncProjectRepositoryForm.scmUrl.$touched }"> <label for="scmUrl" class="col-sm-2 control-label">* SCM Url:</label> <div class="col-sm-10"> <input id="scmUrl" class="form-control" name="scmUrl" ng-model="scmUrl" maxlength="255" placeholder="" required> <span class="help-block" ng-show="pncProjectRepositoryForm.scmUrl.$error.required && pncProjectRepositoryForm.scmUrl.$touched">Required field.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\' : !revision && pncProjectRepositoryForm.revision.$touched, \'has-success\': revision && pncProjectRepositoryForm.revision.$touched }"> <label for="revision" class="col-sm-2 control-label">* Revision:</label> <div class="col-sm-10"> <input id="revision" class="form-control" name="revision" ng-model="revision" maxlength="255" placeholder="master" required> <span class="help-block" ng-show="pncProjectRepositoryForm.revision.$error.required && pncProjectRepositoryForm.revision.$touched">Required field.</span> </div> </div> <div class="form-group"> <label for="pomPath" class="col-sm-2 control-label">Path to POM:</label> <div class="col-sm-10"> <input id="pomPath" class="form-control" name="pomPath" ng-model="pomPath" maxlength="255" placeholder="./pom.xml"> </div> </div> <div class="form-group"> <label for="additionalRepos" class="col-sm-2 control-label">Additional repos:</label> <div class="col-sm-10"> <pnc-multiple-input selected-items="additionalRepos" placeholder="" select-id="additionalRepos" select-name="additionalRepos"> </pnc-multiple-input> </div> </div> </div> </div> <div class="form-group text-right"> <div class="col-sm-offset-2 col-sm-10"> <input type="submit" class="btn btn-primary" value="Search" ng-disabled="pncProjectRepositoryForm.$invalid" ng-click="search()"> <button type="button" class="btn btn-default" ng-click="reset(pncProjectRepositoryForm)">Clear</button> </div> </div> </form> '),e.put("report/views/blacklisted.artifacts.in.project.html",' <div class="row"> <div class="col-lg-7 col-md-10"> <pnc-header> <pnc-header-title>Show blacklisted artifacts in a project</pnc-header-title> </pnc-header> <pnc-project-repository-form search-callback="blacklistedArtifactsInProjectReportCtrl.search(scmUrl, revision, pomPath, additionalRepos)" reset-callback="blacklistedArtifactsInProjectReportCtrl.reset()"></pnc-project-repository-form> </div> </div> <br><br> <div ng-show="blacklistedArtifactsInProjectReportCtrl.isResultNotEmpty()"> <div class="col-md-12"> <div class="search"> <div class="form-group"> <div class="input-group" role="search"> <label class="sr-only" for="{{ inputId }}">Filter Results</label> <input id="{{ inputId }}" type="search" class="form-control" ng-model="searchText" placeholder="Filter"> <div class="input-group-addon"> <i class="fa fa-search"></i> </div> </div> </div> </div> <table class="table table-bordered table-striped table-hover"> <thead> <th style="cursor: pointer" ng-click="blacklistedArtifactsInProjectReportCtrl.sort(\'groupId\')">GroupId <span class="glyphicon sort-icon" ng-show="blacklistedArtifactsInProjectReportCtrl.sortKey==\'groupId\'" ng-class="{\'glyphicon-chevron-up\':blacklistedArtifactsInProjectReportCtrl.reverse,\'glyphicon-chevron-down\':!blacklistedArtifactsInProjectReportCtrl.reverse}"></span> </th> <th style="cursor: pointer" ng-click="blacklistedArtifactsInProjectReportCtrl.sort(\'artifactId\')">ArtifactId <span class="glyphicon sort-icon" ng-show="blacklistedArtifactsInProjectReportCtrl.sortKey==\'artifactId\'" ng-class="{\'glyphicon-chevron-up\':blacklistedArtifactsInProjectReportCtrl.reverse,\'glyphicon-chevron-down\':!blacklistedArtifactsInProjectReportCtrl.reverse}"></span> </th> <th style="cursor: pointer" ng-click="blacklistedArtifactsInProjectReportCtrl.sort(\'version\')">Version <span class="glyphicon sort-icon" ng-show="blacklistedArtifactsInProjectReportCtrl.sortKey==\'version\'" ng-class="{\'glyphicon-chevron-up\':blacklistedArtifactsInProjectReportCtrl.reverse,\'glyphicon-chevron-down\':!blacklistedArtifactsInProjectReportCtrl.reverse}"></span> </th> </thead> <tbody> <tr ng-repeat="result in blacklistedArtifactsInProjectReportCtrl.reportResults | orderBy:blacklistedArtifactsInProjectReportCtrl.sortKey:blacklistedArtifactsInProjectReportCtrl.reverse | filter:searchText"> <td>{{ result.groupId }}</td> <td>{{ result.artifactId }}</td> <td>{{ result.version }}</td> </tr> </tbody> </table> </div> </div> <div ng-hide="blacklistedArtifactsInProjectReportCtrl.isResultNotEmpty() || !blacklistedArtifactsInProjectReportCtrl.afterSearch"> <div class="col-md-12"> <div class="text-center lead"> There are no results to display. </div> </div> </div> '),e.put("report/views/built.artifacts.in.project.html",' <div class="row"> <div class="col-lg-7 col-md-10"> <pnc-header> <pnc-header-title>Show built artifacts in a project</pnc-header-title> </pnc-header> <pnc-project-repository-form search-callback="builtArtifactsInProjectReportCtrl.search(scmUrl, revision, pomPath, additionalRepos)" reset-callback="builtArtifactsInProjectReportCtrl.reset()"></pnc-project-repository-form> </div> </div> <br><br> <div ng-show="builtArtifactsInProjectReportCtrl.isResultNotEmpty()"> <div class="col-md-12"> <div class="search"> <div class="form-group"> <div class="input-group" role="search"> <label class="sr-only" for="{{ inputId }}">Filter Results</label> <input id="{{ inputId }}" type="search" class="form-control" ng-model="searchText" placeholder="Filter"> <div class="input-group-addon"> <i class="fa fa-search"></i> </div> </div> </div> </div> <table class="table table-bordered table-striped table-hover"> <thead> <th class="cursor-pointer" ng-click="builtArtifactsInProjectReportCtrl.sort(\'groupId\')">GroupId <span class="glyphicon sort-icon" ng-show="builtArtifactsInProjectReportCtrl.sortKey==\'groupId\'" ng-class="{\'glyphicon-chevron-up\':builtArtifactsInProjectReportCtrl.reverse,\'glyphicon-chevron-down\':!builtArtifactsInProjectReportCtrl.reverse}"></span> </th> <th class="cursor-pointer" ng-click="builtArtifactsInProjectReportCtrl.sort(\'artifactId\')">ArtifactId <span class="glyphicon sort-icon" ng-show="builtArtifactsInProjectReportCtrl.sortKey==\'artifactId\'" ng-class="{\'glyphicon-chevron-up\':builtArtifactsInProjectReportCtrl.reverse,\'glyphicon-chevron-down\':!builtArtifactsInProjectReportCtrl.reverse}"></span> </th> <th class="cursor-pointer w-min-150" ng-click="builtArtifactsInProjectReportCtrl.sort(\'version\')">Version <span class="glyphicon sort-icon" ng-show="builtArtifactsInProjectReportCtrl.sortKey==\'version\'" ng-class="{\'glyphicon-chevron-up\':builtArtifactsInProjectReportCtrl.reverse,\'glyphicon-chevron-down\':!builtArtifactsInProjectReportCtrl.reverse}"></span> </th> <th class="cursor-pointer w-min-150" ng-click="builtArtifactsInProjectReportCtrl.sort(\'version\')">Built Version <span class="glyphicon sort-icon" ng-show="builtArtifactsInProjectReportCtrl.sortKey==\'version\'" ng-class="{\'glyphicon-chevron-up\':builtArtifactsInProjectReportCtrl.reverse,\'glyphicon-chevron-down\':!builtArtifactsInProjectReportCtrl.reverse}"></span> </th> <th class="cursor-pointer"> All Available Versions <button ng-click="builtArtifactsInProjectReportCtrl.expandAll()" title="Expand All Available Versions" class="btn btn-default btn-xs m-l-10" type="button">Expand all</button> </th> </thead> <tbody> <tr dir-paginate="result in builtArtifactsInProjectReportCtrl.reportResults | orderBy:builtArtifactsInProjectReportCtrl.sortKey:builtArtifactsInProjectReportCtrl.reverse | filter:searchText | itemsPerPage:builtArtifactsInProjectReportCtrl.defaultPageSize" current-page="builtArtifactsInProjectReportCtrl.pagination.current"> <td class="nowrap">{{ result.groupId }}</td> <td class="nowrap">{{ result.artifactId }}</td> <td>{{ result.version }}</td> <td>{{ result.builtVersion }}</td> <td> <div class="available-versions" ng-init="builtArtifactsInProjectReportCtrl.availableVersionsLimits[$index] = 3"> <span ng-repeat="version in result.availableVersions | limitTo: builtArtifactsInProjectReportCtrl.availableVersionsLimits[$index] as results" class="available-versions-item">{{ version }}</span> <span class="available-versions-item" ng-hide="results.length === result.availableVersions.length"> <button ng-click="builtArtifactsInProjectReportCtrl.availableVersionsLimits[$index] = result.availableVersions.length" title="Show All Available Versions" class="btn btn-default btn-xs" type="button">Show all</button> </span> </div> </td> </tr> </tbody> </table> <dir-pagination-controls max-size="builtArtifactsInProjectReportCtrl.defaultPageSize" direction-links="true" boundary-links="true"></dir-pagination-controls> </div> </div> <div ng-hide="builtArtifactsInProjectReportCtrl.isResultNotEmpty() || !builtArtifactsInProjectReportCtrl.afterSearch"> <div class="col-md-12"> <div class="text-center lead"> There are no results to display. </div> </div> </div> '),e.put("scm-repositories/components/pnc-scm-repositories-list/pnc-scm-repositories-list.html",' <table class="table table-bordered table-striped table-hover" ng-show="$ctrl.showTable()"> <thead ng-hide="::$ctrl.hideHead"> <th ng-if="::$ctrl.showColumn(\'name\')">Name</th> <th ng-if="::$ctrl.showColumn(\'internalScmUrl\')">Internal SCM URL</th> <th ng-if="::$ctrl.showColumn(\'externalScmUrl\')">External SCM URL</th> <th ng-if="::$ctrl.showColumn(\'preBuildSync\')">Pre-build Sync</th> </thead> <tbody> <tr ng-repeat="item in $ctrl.items"> <td ng-if="::$ctrl.showColumn(\'name\')"> <pnc-scm-repository-link scm-repository="item"></pnc-scm-repository-link> </td> <td ng-if="::$ctrl.showColumn(\'internalScmUrl\')"> {{ item.internalUrl }} </td> <td ng-if="::$ctrl.showColumn(\'externalScmUrl\')"> {{ item.externalUrl }} </td> <td ng-if="::$ctrl.showColumn(\'preBuildSync\')"> {{ item.preBuildSyncEnabled }} </td> </tr> </tbody> </table> <div ng-hide="$ctrl.showTable()" class="text-center clear-both"><em>There are no items to display</em></div> '),e.put("scm-repositories/components/pnc-scm-repository-link/pnc-scm-repository-link.html",' <a href ui-sref="scm-repositories.detail({ scmRepositoryId: $ctrl.scmRepository.id })" ng-bind="::$ctrl.scmRepository.getName()"></a> '),e.put("scm-repositories/create/pnc-scm-repository-create-page.html",' <pnc-header> <pnc-header-title>Create SCM Repository</pnc-header-title> </pnc-header> <div class="row"> <div class="col-md-11 col-lg-10"> <form name="scmRepositoryForm" class="form-horizontal" novalidate> <fieldset ng-disabled="$ctrl.isCreatingInProgress"> <div class="form-group" ng-class="{ \'has-error\': scmRepositoryForm.scmUrl.$invalid && scmRepositoryForm.scmUrl.$touched, \'has-success\': scmRepositoryForm.scmUrl.$valid && scmRepositoryForm.scmUrl.$touched }"> <label for="scmUrl" class="col-sm-3 col-lg-2 control-label">SCM Repository URL</label> <div class="col-sm-9 col-lg-7"> <input type="url" id="scmUrl" class="form-control" name="scmUrl" maxlength="255" ng-model="$ctrl.scmRepository.scmUrl"> <span class="help-block" ng-show="scmRepositoryForm.scmUrl.$invalid && scmRepositoryForm.scmUrl.$touched">Malformed URL.</span> </div> </div> <div class="form-group"> <label for="preBuildSyncEnabled" class="col-sm-3 col-lg-2 control-label">Pre-build Sync Enabled</label> <div class="col-sm-9 col-lg-7"> <input type="checkbox" id="preBuildSyncEnabled" name="preBuildSyncEnabled" ng-model="$ctrl.scmRepository.preBuildSyncEnabled"> </div> </div> <div class="form-group"> <div class="col-sm-offset-3 col-lg-offset-2 col-sm-9 col-lg-10"> <button type="submit" class="btn btn-primary" ng-click="$ctrl.startCreating($ctrl.scmRepository)" ng-disabled="scmRepositoryForm.$invalid"> <span class="spinner spinner-xs btn-spinner-xs" ng-show="$ctrl.isCreatingInProgress"></span> Create </button> <input type="reset" class="btn btn-default" value="Clear" ng-click="$ctrl.reset(scmRepositoryForm)"> </div> </div> </fieldset> </form> </div> </div> '),e.put("scm-repositories/detail/pnc-scm-repository-detail-page.html",' <pnc-header> <pnc-header-title>{{ ::$ctrl.scmRepository.getName() }}</pnc-header-title> <pnc-header-buttons> <button type="button" class="btn btn-lg btn-default" uib-tooltip="Edit SCM Repository" tooltip-placement="top" tooltip-append-to-body="true" tooltip-popup-delay="2500" ng-click="repositoryConfigurationForm.$show()" ng-class="{ \'active\': repositoryConfigurationForm.$visible }" pnc-requires-auth><i class="pficon pficon-edit"></i> Edit</button> </pnc-header-buttons> </pnc-header> <div class="row"> <div class="col-md-11 col-lg-10"> <form editable-form class="form-horizontal" name="repositoryConfigurationForm" onbeforesave="$ctrl.update()" novalidate> <div class="form-group"> <label for="internal-url" class="col-sm-3 col-lg-2 control-label">Internal SCM URL</label> <div class="col-sm-9 col-lg-7"> <p id="internal-url" class="form-control-static">{{ $ctrl.scmRepository.internalUrl || \'Empty\' }}</p> </div> </div> <div class="form-group" ng-class="{ \'has-error\': repositoryConfigurationForm.externalUrl.$invalid && repositoryConfigurationForm.externalUrl.$touched, \'has-success\': repositoryConfigurationForm.externalUrl.$valid && repositoryConfigurationForm.externalUrl.$touched }"> <label for="external-url" class="col-sm-3 col-lg-2 control-label" ng-class="{ \'required\': configurationForm.$visible }">External SCM URL</label> <div class="col-sm-9 col-lg-7"> <p id="external-url" class="form-control-static" e-class="form-control" editable-text="$ctrl.scmRepository.externalUrl" e-name="externalUrl" e-maxlength="255" e-ng-required="repositoryConfigurationForm.preBuildSync.$modelValue">{{ $ctrl.scmRepository.externalUrl || \'Empty\' }}</p> <span class="help-block" ng-show="repositoryConfigurationForm.externalUrl.$error.required && repositoryConfigurationForm.externalUrl.$touched">Required field.</span> </div> </div> <div class="form-group" ng-class="{ \'has-error\': repositoryConfigurationForm.preBuildSync.$invalid && repositoryConfigurationForm.preBuildSync.$touched, \'has-success\': repositoryConfigurationForm.preBuildSync.$valid && repositoryConfigurationForm.preBuildSync.$touched }"> <label for="pre-build-sync" class="col-sm-3 col-lg-2 control-label">Pre-build Sync</label> <div class="col-sm-9 col-lg-7"> <p id="pre-build-sync" class="form-control-static" e-class="checkbox" editable-checkbox="$ctrl.scmRepository.preBuildSyncEnabled" e-name="preBuildSync">{{ $ctrl.scmRepository.preBuildSyncEnabled ? \'enabled\' : \'disabled\' }}</p> </div> </div> <div class="form-group" ng-show="repositoryConfigurationForm.$visible"> <div class="col-sm-offset-3 col-lg-offset-2 col-sm-9 col-lg-10"> <button type="submit" class="btn btn-primary" ng-disabled="repositoryConfigurationForm.$waiting || repositoryConfigurationForm.$invalid"> Save </button> <button type="button" class="btn btn-default" ng-disabled="repositoryConfigurationForm.$waiting" ng-click="$ctrl.cancel()"> Cancel </button> </div> </div> </form> </div> </div> <pnc-header sub-header="true"> <pnc-header-title>Usages</pnc-header-title> </pnc-header> <div class="row"> <div class="col-md-12"> <pnc-build-configs-list build-configs="$ctrl.buildConfigurations.page.data" display-fields="$ctrl.buildConfigurations.displayFields"></pnc-build-configs-list> <pnc-page-controls class="pull-right m-t-10 m-b-10" pnc-page="$ctrl.buildConfigurations.page" ng-if="$ctrl.buildConfigurations.page"></pnc-page-controls> </div> </div> '),e.put("scm-repositories/list/pnc-scm-repositories-list-page.html",' <pnc-header> <pnc-header-title>SCM Repositories</pnc-header-title> <pnc-header-buttons> <button type="button" class="btn btn-lg btn-default" data-toggle="tooltip" title="Create SCM Repository" ui-sref="scm-repositories.create"> <i class="fa fa-file-text-o"></i> Create </button> </pnc-header-buttons> </pnc-header> <div class="row"> <pnc-toolbar filtering-page="$ctrl.scmRepositoriesFilteringPage" filtering-fields="$ctrl.scmRepositoriesFilteringFields" sorting-fields="$ctrl.scmRepositoriesSortingFields" sorting-configs="$ctrl.scmRepositoriesSortingConfigs"></pnc-toolbar> </div> <div> <pnc-scm-repositories-list scm-repositories="$ctrl.scmRepositoriesFilteringPage.data"></pnc-scm-repositories-list> <pnc-page-controls class="pull-right m-b-10" pnc-page="$ctrl.scmRepositoriesFilteringPage" ng-if="$ctrl.scmRepositoriesFilteringPage"></pnc-page-controls> </div> ')}]);