/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.web;

import java.io.IOException;
import java.io.PrintWriter;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.pnc.common.Configuration;
import org.jboss.pnc.common.json.ConfigurationParseException;
import org.jboss.pnc.rest.utils.JsonOutputConverterMapper;
import org.jboss.pnc.web.UiConfigRest;
import org.jboss.pnc.web.UiConfigRestBuilder;

@WebServlet(value={"/scripts/config.js"})
public class UIConfigurationServletJs
extends HttpServlet {
    public static final int CACHE_EXPIRES_IN = 0;
    public static final String PNC_GLOBAL_MODULE = "pnc";
    public static final String CONFIG_PROPERTY = "config";
    @Inject
    private Configuration configuration;
    private String uiConfig;

    public void init() throws ServletException {
        try {
            UiConfigRest configRest = UiConfigRestBuilder.build((Configuration)this.configuration);
            String json = JsonOutputConverterMapper.apply((Object)configRest);
            this.uiConfig = this.generateJS(json);
        }
        catch (ConfigurationParseException e) {
            throw new ServletException("Lazy-loading of UI configuration failed because the servlet was not able to fetch the configuration.", (Throwable)e);
        }
    }

    private String generateJS(String configJson) {
        return String.format("var %1$s = %1$s || {}; %1$s.%2$s = %3$s; window.%1$s = %1$s;", PNC_GLOBAL_MODULE, CONFIG_PROPERTY, configJson);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/javascript");
        resp.setHeader("Cache-Control", "max-age=0");
        PrintWriter writer = resp.getWriter();
        writer.println(this.uiConfig);
        writer.flush();
    }
}

