/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.web;

import java.io.IOException;
import java.io.PrintWriter;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.pnc.common.Configuration;
import org.jboss.pnc.common.json.ConfigurationParseException;
import org.jboss.pnc.rest.utils.JsonOutputConverterMapper;
import org.jboss.pnc.web.UiConfigRest;
import org.jboss.pnc.web.UiConfigRestBuilder;

@WebServlet(value={"/configuration/config.json"})
public class UIConfigurationServletJson
extends HttpServlet {
    public static final int CACHE_EXPIRES_IN = 0;
    @Inject
    private Configuration configuration;
    private String uiConfig;

    public void init() throws ServletException {
        try {
            UiConfigRest configRest = UiConfigRestBuilder.build((Configuration)this.configuration);
            this.uiConfig = JsonOutputConverterMapper.apply((Object)configRest);
        }
        catch (ConfigurationParseException e) {
            throw new ServletException("Lazy-loading of UI configuration failed because the servlet was not able to fetch the configuration.", (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("application/json");
        resp.setHeader("Cache-Control", "max-age=0");
        PrintWriter writer = resp.getWriter();
        writer.println(this.uiConfig);
        writer.flush();
    }
}

