/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.test.framework.impl.generic.config;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.portal.common.io.IOTools;
import org.jboss.portal.common.xml.XMLTools;
import org.jboss.portal.test.framework.impl.generic.config.AuthenticationConfig;
import org.jboss.portal.test.framework.impl.generic.config.NodeConfig;
import org.jboss.portal.test.framework.impl.generic.config.RemoteDeployerConfig;
import org.jboss.portal.test.framework.impl.generic.config.ServiceConfig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServerConfig {
    private final String name;
    private final Map nodes;

    public ServerConfig(String serverName) {
        if (serverName == null) {
            throw new IllegalArgumentException();
        }
        this.name = serverName;
        this.nodes = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public void addNode(NodeConfig node) {
        this.nodes.put(node.getId(), node);
    }

    public Map getNodes() {
        return this.nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map createConfigs(URL url) throws Exception {
        LinkedHashMap<String, ServerConfig> configs = new LinkedHashMap<String, ServerConfig>();
        BufferedInputStream in = null;
        try {
            in = IOTools.safeBufferedWrapper((InputStream)url.openStream());
            Document doc = XMLTools.getDocumentBuilderFactory().newDocumentBuilder().parse(in);
            Iterator i = XMLTools.getChildrenIterator((Element)doc.getDocumentElement(), (String)"server");
            while (i.hasNext()) {
                Element serverElt = (Element)i.next();
                ServerConfig serverCfg = ServerConfig.createConfig(serverElt);
                configs.put(serverCfg.getName(), serverCfg);
            }
            LinkedHashMap<String, ServerConfig> linkedHashMap = configs;
            return linkedHashMap;
        }
        finally {
            IOTools.safeClose((InputStream)in);
        }
    }

    public static ServerConfig createConfig(Element serverElt) {
        Element serverNameElt = XMLTools.getUniqueChild((Element)serverElt, (String)"server-name", (boolean)true);
        ServerConfig serverCfg = new ServerConfig(XMLTools.asString((Element)serverNameElt));
        List nodeElts = XMLTools.getChildren((Element)serverElt, (String)"node");
        for (Element nodeElt : nodeElts) {
            Element nodeIdElt = XMLTools.getUniqueChild((Element)nodeElt, (String)"node-id", (boolean)true);
            List serviceElts = XMLTools.getChildren((Element)nodeElt, (String)"service");
            Element deployerElt = XMLTools.getUniqueChild((Element)nodeElt, (String)"deployer", (boolean)true);
            NodeConfig node = new NodeConfig(XMLTools.asString((Element)nodeIdElt));
            for (Element serviceElt : serviceElts) {
                Element serviceNameElt = XMLTools.getUniqueChild((Element)serviceElt, (String)"service-name", (boolean)true);
                Element interfaceElt = XMLTools.getUniqueChild((Element)serviceElt, (String)"interface", (boolean)true);
                Element uriElt = XMLTools.getUniqueChild((Element)serviceElt, (String)"uri", (boolean)true);
                ServiceConfig service = new ServiceConfig(XMLTools.asString((Element)serviceNameElt));
                service.setInterfaceClass(XMLTools.asString((Element)interfaceElt));
                service.setURI(XMLTools.asString((Element)uriElt));
                node.addService(service);
            }
            Element remoteElt = XMLTools.getUniqueChild((Element)deployerElt, (String)"remote", (boolean)true);
            Element authenticationElt = XMLTools.getUniqueChild((Element)deployerElt, (String)"authentication", (boolean)false);
            Element remoteNameElt = XMLTools.getUniqueChild((Element)remoteElt, (String)"name", (boolean)true);
            Element remoteHostElt = XMLTools.getUniqueChild((Element)remoteElt, (String)"host", (boolean)true);
            Element remotePortElt = XMLTools.getUniqueChild((Element)remoteElt, (String)"port", (boolean)true);
            RemoteDeployerConfig cargoCfg = new RemoteDeployerConfig();
            cargoCfg.setName(XMLTools.asString((Element)remoteNameElt));
            cargoCfg.setHost(XMLTools.asString((Element)remoteHostElt));
            cargoCfg.setPort(XMLTools.asString((Element)remotePortElt));
            node.setDeployer(cargoCfg);
            if (authenticationElt != null) {
                Element authenticationUsernameElt = XMLTools.getUniqueChild((Element)authenticationElt, (String)"username", (boolean)true);
                Element authenticationPasswordElt = XMLTools.getUniqueChild((Element)authenticationElt, (String)"password", (boolean)true);
                AuthenticationConfig authenticationCfg = new AuthenticationConfig();
                authenticationCfg.setUsername(XMLTools.asString((Element)authenticationUsernameElt));
                authenticationCfg.setPassword(XMLTools.asString((Element)authenticationPasswordElt));
                node.setAuthentication(authenticationCfg);
            }
            serverCfg.addNode(node);
        }
        return serverCfg;
    }
}

