/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.deployers.spi.management;

import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.vfs.VirtualFile;

/**
 * A DeploymentTemplate is a template for creating a DeploymentContext given
 * a set of ManagedProperty representing the template properties
 * to set in the resulting deployment.
 * 
 * TODO: this needs to be fleshed out in terms of the various pieces, raw deployment
 * files, ManagedObjects, etc. 
 * @author Scott.Stark@jboss.org
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision: 101110 $
 */
public interface DeploymentTemplate
{
   /**
    * Get the exportable representation of the properties that the
    * template supports.
    * 
    * @return the external representation of the template properties.
    */
   DeploymentTemplateInfo getInfo();

   /**
    * Get a deployment name based on the base name, which checks
    * if the name is valid and get the correct suffix for the deployers. 
    * 
    * @param deploymentBaseName the base name.
    * @return the deployment name
    */
   String getDeploymentName(String deploymentBaseName);
   
   /**
    * Create a temporary deployment virtual that can be added to a profile.
    * 
    * @param values - the template ManagedProperty values
    * @return a virtual file, which gets distributed to the server and deleted afterwards
    * @throws Exception - thrown on any failure to create the deployment
    */
   VirtualFile applyTemplate(DeploymentTemplateInfo values)
      throws Exception;

}
