/*
* JBoss, Home of Professional Open Source
* Copyright 2010, Red Hat Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.deployers.spi.management;

import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.values.MetaValue;

/**
 * {@code ManagedComponent} runtime dispatcher, dispatching runtime invocations 
 * to runtime components. 
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
// TODO change componentName to ManagedComponent/Object ?
public interface ManagedComponentRuntimeDispatcher
{

   /**
    * Get a runtime value.
    * 
    * @param componentName the runtime component name
    * @param property the managed property
    * @return the meta value
    */
   MetaValue get(Object componentName, ManagedProperty property);
   
   /**
    * Set a runtime value.
    * 
    * @param componentName the runtime component name
    * @param property the managed property
    * @param value the meta value
    */
   void set(Object componentName, ManagedProperty property, MetaValue value);
   
   /**
    * Invoke a managed operation on a runtime {@code ManagedObject}.
    * 
    * @param componentName the runtime component name
    * @param operation the managed operation
    * @param param the operation parameters
    * @return the invocation's mapped return value
    */
   MetaValue invoke(Object componentName, ManagedOperation operation, MetaValue... param);
   
   /**
    * Map the state of the component.
    * 
    * @param <T> the state enum
    * @param name the component name
    * @param mapper the state mapper
    * @return the mapped state
    */
   <T extends Enum<?>> T mapControllerState(Object name, ContextStateMapper<T> mapper);
   
}

