/*
* JBoss, Home of Professional Open Source
* Copyright 2009, Red Hat Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.spi.action;

import java.util.List;

import org.jboss.profileservice.spi.ProfileKey;

/**
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public interface ProfileModificationRequest
{


   /**
    * Get the type of the action.
    * 
    * @return the modification type
    */
   ProfileModificationType getType();
   
   /**
    * List the profiles affected by the modification.
    * 
    * @return the profiles
    */
   List<ProfileKey> getProfilesKeys();
   
   /**
    * Get the modification actions for a given profile key
    * 
    * @param key the profile key
    * @return the actions
    */
   List<ProfileModificationAction<? extends ProfileModificationContext>> getActions(ProfileKey key);
   
}

