/*
* JBoss, Home of Professional Open Source
* Copyright 2009, Red Hat Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.profileservice.spi.dependency;

import org.jboss.profileservice.spi.ProfileKey;

/**
 * A plugin to resolve specific profile requirements.
 * 
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision$
 */
public interface ProfileRequirementResolverPlugin<T extends ProfileRequirement>
{

   /**
    * The class the resolver plugin handles.
    * 
    * @return the requirement class
    */
   Class<T> getRequirementClass();
   
   /**
    * Try to resolve a requirement. This will return the
    * profile key satisfying this requirement, null if this
    * resolver cannot resolve the requirement.
    * 
    * @param requirement the profile requirement
    * @return the profileKey, null if not resolved
    */
   ProfileKey resolve(T requirement);
   
}

