/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Configuration {
    protected final File directory;
    protected final String host;
    protected final Integer port;
    protected final String username;
    protected final String password;
    protected final String xms;
    protected final String xmx;
    protected final String maxPermSize;
    protected final List<String> params;

    protected Configuration(Builder<?> builder) {
        this.directory = builder.directory;
        this.checkMandatoryProperty("directory", this.directory);
        this.host = builder.host;
        this.checkMandatoryProperty("host", this.host);
        this.port = builder.port;
        this.checkMandatoryProperty("port", this.port);
        this.username = builder.username;
        this.checkMandatoryProperty("username", this.username);
        this.password = builder.password;
        this.checkMandatoryProperty("password", this.password);
        this.xms = builder.xms;
        this.xmx = builder.xmx;
        this.maxPermSize = builder.maxPermSize;
        this.params = builder.params;
    }

    protected void checkMandatoryProperty(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Property '%s' is mandatory", name));
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getXms() {
        return this.xms;
    }

    public String getXmx() {
        return this.xmx;
    }

    public String getMaxPermSize() {
        return this.maxPermSize;
    }

    public List<String> getParams() {
        return this.params;
    }

    public List<String> generateCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        if (System.getProperty("java.home") == null) {
            throw new IllegalStateException("System property 'java.home' is not set");
        }
        File javaHome = new File(System.getProperty("java.home"));
        String javaExec = javaHome + File.separator + "bin" + File.separator + "java";
        cmd.add(javaExec);
        if (this.xms != null) {
            cmd.add("-Xms" + this.xms);
        }
        if (this.xmx != null) {
            cmd.add("-Xmx" + this.xmx);
        }
        if (this.maxPermSize != null) {
            cmd.add("-XX:MaxPermSize=" + this.maxPermSize);
        }
        if (this.params != null) {
            cmd.addAll(this.params);
        }
        return cmd;
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected File directory;
        protected String host = "localhost";
        protected Integer port = 8080;
        protected String username = "admin";
        protected String password = "admin";
        protected String xms = "64m";
        protected String xmx = "256m";
        protected String maxPermSize = "512m";
        protected List<String> params = new ArrayList<String>();

        protected abstract T self();

        public T directory(String directory) {
            this.directory = new File(directory);
            return this.self();
        }

        public T host(String host) {
            this.host = host;
            return this.self();
        }

        public T port(Integer port) {
            this.port = port;
            return this.self();
        }

        public T username(String username) {
            this.username = username;
            return this.self();
        }

        public T password(String password) {
            this.password = password;
            return this.self();
        }

        public T xms(String xms) {
            this.xms = xms;
            return this.self();
        }

        public T xmx(String xmx) {
            this.xmx = xmx;
            return this.self();
        }

        public T maxPermSize(String maxPermSize) {
            this.maxPermSize = maxPermSize;
            return this.self();
        }

        public T params(List<String> params) {
            this.params.addAll(params);
            return this.self();
        }

        public T param(String param) {
            this.params.add(param);
            return this.self();
        }
    }
}

