/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer.jboss;

import java.io.File;
import java.util.List;
import org.jboss.qa.jcontainer.Configuration;

public class JBossConfiguration
extends Configuration {
    protected final int managementPort;
    protected final String profile;
    protected final Mode mode;

    protected JBossConfiguration(Builder<?> builder) {
        super(builder);
        this.managementPort = builder.managementPort;
        this.profile = builder.profile;
        this.mode = builder.mode;
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public String getProfile() {
        return this.profile;
    }

    public int getManagementPort() {
        return this.managementPort;
    }

    public Mode getMode() {
        return this.mode;
    }

    public File getBaseDir() {
        String modeVal = this.mode != null ? this.mode.getValue() : Mode.STANDALONE.getValue();
        return new File(this.directory, modeVal);
    }

    public File getConfigurationFolder() {
        return new File(this.getBaseDir(), "configuration");
    }

    @Override
    public List<String> generateCommand() {
        List<String> cmd = super.generateCommand();
        File jbossModulesJar = new File(this.directory, "jboss-modules.jar");
        if (!jbossModulesJar.exists()) {
            throw new IllegalStateException(String.format("File %s does not exist", jbossModulesJar));
        }
        cmd.add("-jar");
        cmd.add(jbossModulesJar.getAbsolutePath());
        File modulesFolder = new File(this.directory, "modules");
        if (!modulesFolder.exists()) {
            throw new IllegalStateException(String.format("Folder %s does not exist", modulesFolder));
        }
        cmd.add("-mp");
        cmd.add(modulesFolder.getAbsolutePath());
        if (this.mode.equals((Object)Mode.STANDALONE)) {
            cmd.add("-jaxpmodule");
            cmd.add("javax.xml.jaxp-provider");
            cmd.add("org.jboss.as.standalone");
            cmd.add("-c");
            cmd.add(this.profile);
        } else {
            cmd.add("org.jboss.as.process-controller");
            cmd.add("-jboss-home");
            cmd.add(this.directory.getAbsolutePath());
        }
        cmd.add("-Djboss.home.dir=" + this.directory.getAbsolutePath());
        cmd.add("-Djava.net.preferIPv4Stack=true");
        cmd.add("-Djava.awt.headless=true");
        return cmd;
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Configuration.Builder<T> {
        protected int managementPort = 9990;
        protected String profile = "standalone.xml";
        protected Mode mode = Mode.STANDALONE;

        public T managementPort(int managementPort) {
            this.managementPort = managementPort;
            return (T)((Builder)this.self());
        }

        public T profile(String profile) {
            this.profile = profile;
            return (T)((Builder)this.self());
        }

        public T mode(Mode mode) {
            this.mode = mode;
            return (T)((Builder)this.self());
        }

        public JBossConfiguration build() {
            return new JBossConfiguration(this);
        }
    }

    public static enum Mode {
        STANDALONE("standalone"),
        MANAGEMENT("management");

        private final String mode;

        private Mode(String mode) {
            this.mode = mode;
        }

        public String getValue() {
            return this.mode;
        }
    }
}

