/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer.karaf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.KeyPair;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.local.AgentImpl;
import org.apache.sshd.agent.local.LocalAgentFactory;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.fusesource.jansi.AnsiConsole;
import org.jboss.qa.jcontainer.Client;
import org.jboss.qa.jcontainer.karaf.KarafConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafClient<T extends KarafConfiguration>
extends Client<T> {
    private static final Logger logger = LoggerFactory.getLogger(KarafClient.class);
    private static final String NEW_LINE = System.getProperty("line.separator");
    protected SshClient client;
    protected ClientSession session;

    public KarafClient(T configuration) {
        super(configuration);
    }

    @Override
    protected void closeInternal() throws IOException {
        this.session.close(true);
        this.session = null;
        this.client.stop();
        this.client = null;
    }

    @Override
    public boolean isConnected() {
        return this.session != null && !this.session.isClosed();
    }

    @Override
    protected void connectInternal() throws Exception {
        logger.info("Connecting to server {}:{}", (Object)((KarafConfiguration)this.configuration).getHost(), (Object)((KarafConfiguration)this.configuration).getPort());
        this.client = SshClient.setUpDefaultClient();
        this.setupAgent(((KarafConfiguration)this.configuration).getUsername(), ((KarafConfiguration)this.configuration).getKeyFile(), this.client);
        this.client.start();
        this.connect(this.client);
        if (((KarafConfiguration)this.configuration).getPassword() != null) {
            this.session.addPasswordIdentity(((KarafConfiguration)this.configuration).getPassword());
        }
        this.session.auth().verify();
    }

    @Override
    protected boolean executeInternal(String command) throws Exception {
        boolean isError;
        String exceptionMsg = "Command not found";
        String failMsg = "Error executing command";
        boolean success = true;
        ClientChannel channel = this.session.createChannel("exec", command.concat(NEW_LINE));
        channel.setIn((InputStream)new ByteArrayInputStream(new byte[0]));
        ByteArrayOutputStream sout = new ByteArrayOutputStream();
        ByteArrayOutputStream serr = new ByteArrayOutputStream();
        channel.setOut(AnsiConsole.wrapOutputStream((OutputStream)sout));
        channel.setErr(AnsiConsole.wrapOutputStream((OutputStream)serr));
        channel.open();
        channel.waitFor(2, 0L);
        sout.writeTo(System.out);
        serr.writeTo(System.err);
        boolean bl = isError = channel.getExitStatus() != null && channel.getExitStatus() != 0;
        if (isError) {
            logger.error(sout.toString());
            if (sout.toString().contains("Error executing command")) {
                success = false;
            } else {
                throw new UnsupportedOperationException("Unsupported operation: " + command);
            }
        }
        return success;
    }

    protected void setupAgent(String user, File keyFile, SshClient client) {
        URL builtInPrivateKey = KarafClient.class.getClassLoader().getResource("karaf.key");
        SshAgent agent = this.startAgent(user, builtInPrivateKey, keyFile);
        client.setAgentFactory((SshAgentFactory)new LocalAgentFactory(agent));
        client.getProperties().put("SSH_AUTH_SOCK", "local");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SshAgent startAgent(String user, URL privateKeyUrl, File keyFile) {
        try (InputStream is = privateKeyUrl.openStream();){
            AgentImpl agent = new AgentImpl();
            ObjectInputStream r = new ObjectInputStream(is);
            KeyPair keyPair = (KeyPair)r.readObject();
            is.close();
            agent.addIdentity(keyPair, user);
            if (keyFile != null) {
                String[] keyFiles = new String[]{keyFile.getAbsolutePath()};
                FileKeyPairProvider fileKeyPairProvider = new FileKeyPairProvider(keyFiles);
                for (KeyPair key : fileKeyPairProvider.loadKeys()) {
                    agent.addIdentity(key, user);
                }
            }
            AgentImpl agentImpl = agent;
            return agentImpl;
        }
        catch (Throwable e) {
            logger.error("Error starting ssh agent for: " + e.getMessage(), e);
            return null;
        }
    }

    protected void connect(SshClient client) throws IOException, InterruptedException {
        int attempts = 10;
        do {
            ConnectFuture future = client.connect(((KarafConfiguration)this.configuration).getUsername(), ((KarafConfiguration)this.configuration).getHost(), ((KarafConfiguration)this.configuration).getPort().intValue());
            future.await();
            try {
                this.session = future.getSession();
            }
            catch (RuntimeSshException ex) {
                if (--attempts > 0) {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
                    logger.info("Waiting for SSH connection...");
                    continue;
                }
                throw ex;
            }
        } while (this.session == null);
    }
}

