/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer.karaf;

import java.io.File;
import java.util.List;
import org.jboss.qa.jcontainer.Configuration;

public class KarafConfiguration
extends Configuration {
    protected final File keyFile;

    protected KarafConfiguration(Builder<?> builder) {
        super(builder);
        this.keyFile = builder.keyFile;
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public File getKeyFile() {
        return this.keyFile;
    }

    @Override
    public List<String> generateCommand() {
        List<String> cmd = super.generateCommand();
        cmd.add("-server");
        cmd.add("-XX:+UnlockDiagnosticVMOptions");
        cmd.add("-XX:+UnsyncloadClass");
        cmd.add("-Dcom.sun.management.jmxremote");
        cmd.add("-Djava.endorsed.dirs=" + System.getProperty("java.endorsed.dirs") + File.pathSeparator + this.directory + File.separator + "lib" + File.separator + "endorsed");
        cmd.add("-Djava.ext.dirs=" + System.getProperty("java.ext.dirs") + File.pathSeparator + this.directory + File.separator + "lib" + File.separator + "ext");
        cmd.add("-Dkaraf.instances=" + this.directory + File.separator + "instances");
        cmd.add("-Dkaraf.home=" + this.directory);
        cmd.add("-Dkaraf.base=" + this.directory);
        cmd.add("-Dkaraf.etc=" + this.directory + File.separator + "etc");
        cmd.add("-Djava.io.tmpdir=" + this.directory + File.separator + "data" + File.separator + "tmp");
        cmd.add("-Djava.util.logging.config.file=" + this.directory + File.separator + "etc" + File.separator + "java.util.logging.properties");
        cmd.add("-Dkaraf.startLocalConsole=true");
        cmd.add("-Dkaraf.startRemoteShell=true");
        cmd.add("-classpath");
        cmd.add(this.directory + File.separator + "lib" + File.separator + "karaf-jaas-boot.jar" + File.pathSeparator + this.directory + File.separator + "lib" + File.separator + "karaf.jar");
        cmd.add("org.apache.karaf.main.Main");
        return cmd;
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Configuration.Builder<T> {
        protected File keyFile;

        public Builder() {
            this.port = 8101;
            this.username = "karaf";
            this.password = "karaf";
        }

        public T keyFile(String keyFile) {
            this.keyFile = new File(keyFile);
            return (T)((Builder)this.self());
        }

        public KarafConfiguration build() {
            return new KarafConfiguration(this);
        }
    }
}

