/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer;

import java.io.Closeable;
import java.io.IOException;
import org.jboss.qa.jcontainer.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Client<T extends Configuration>
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(Client.class);
    protected T configuration;

    public Client(T configuration) {
        this.configuration = configuration;
    }

    public T getConfiguration() {
        return this.configuration;
    }

    public abstract boolean isConnected();

    protected abstract void connectInternal() throws Exception;

    public void connect() throws Exception {
        if (!this.isConnected()) {
            this.connectInternal();
        }
        logger.info("Client was connected");
    }

    protected abstract boolean executeInternal(String var1) throws Exception;

    public boolean execute(String command) throws Exception {
        logger.info("Execute command: {}", (Object)command);
        if (!this.isConnected()) {
            this.connect();
        }
        return this.executeInternal(command);
    }

    protected abstract void closeInternal() throws IOException;

    @Override
    public void close() throws IOException {
        if (this.isConnected()) {
            this.closeInternal();
        }
        logger.info("Client was disconnected");
    }
}

