/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Configuration {
    protected final File directory;
    protected final String host;
    protected final Integer port;
    protected final String username;
    protected final String password;
    protected final String xms;
    protected final String xmx;
    protected final String maxPermSize;
    protected final List<String> params;
    protected final Map<String, String> envProps;

    protected Configuration(Builder<?> builder) {
        this.directory = builder.directory;
        this.checkMandatoryProperty("directory", this.directory);
        this.host = builder.host;
        this.checkMandatoryProperty("host", this.host);
        this.port = builder.port;
        this.checkMandatoryProperty("port", this.port);
        this.username = builder.username;
        this.checkMandatoryProperty("username", this.username);
        this.password = builder.password;
        this.checkMandatoryProperty("password", this.password);
        this.xms = builder.xms;
        this.xmx = builder.xmx;
        this.maxPermSize = builder.maxPermSize;
        this.params = builder.params;
        this.envProps = builder.envProps;
    }

    protected void checkMandatoryProperty(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Property '%s' is mandatory", name));
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getXms() {
        return this.xms;
    }

    public String getXmx() {
        return this.xmx;
    }

    public String getMaxPermSize() {
        return this.maxPermSize;
    }

    public List<String> getParams() {
        return this.params;
    }

    public Map<String, String> getEnvProps() {
        return this.envProps;
    }

    public abstract List<String> generateCommand();

    public static abstract class Builder<T extends Builder<T>> {
        protected File directory;
        protected String host = "localhost";
        protected Integer port = 8080;
        protected String username = "admin";
        protected String password = "admin";
        protected String xms = "64m";
        protected String xmx = "256m";
        protected String maxPermSize = "512m";
        protected List<String> params = new ArrayList<String>();
        protected Map<String, String> envProps = new HashMap<String, String>();

        protected abstract T self();

        public T directory(String directory) {
            this.directory = new File(directory);
            return this.self();
        }

        public T host(String host) {
            this.host = host;
            return this.self();
        }

        public T port(Integer port) {
            this.port = port;
            return this.self();
        }

        public T username(String username) {
            this.username = username;
            return this.self();
        }

        public T password(String password) {
            this.password = password;
            return this.self();
        }

        public T xms(String xms) {
            this.xms = xms;
            return this.self();
        }

        public T xmx(String xmx) {
            this.xmx = xmx;
            return this.self();
        }

        public T maxPermSize(String maxPermSize) {
            this.maxPermSize = maxPermSize;
            return this.self();
        }

        public T params(List<String> params) {
            this.params.addAll(params);
            return this.self();
        }

        public T param(String param) {
            this.params.add(param);
            return this.self();
        }

        public T envProps(Map<String, String> envProps) {
            this.envProps.putAll(envProps);
            return this.self();
        }

        public T envProp(String key, String value) {
            this.envProps.put(key, value);
            return this.self();
        }
    }
}

