/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.qa.jcontainer.Client;
import org.jboss.qa.jcontainer.Configuration;
import org.jboss.qa.jcontainer.User;
import org.jboss.qa.jcontainer.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Container<T extends Configuration, U extends Client<T>, V extends User>
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(Container.class);
    protected T configuration;
    protected U client;
    private Class<T> confClass = ReflectionUtils.getGenericClass(this.getClass(), 0);
    private Class<U> clientClass = ReflectionUtils.getGenericClass(this.getClass(), 1);
    private volatile Thread shutdownThread;

    public Container(T configuration) {
        this.configuration = configuration;
        this.client = this.createClient(configuration);
    }

    public abstract void addUser(V var1) throws Exception;

    public synchronized void start() throws Exception {
        if (this.isRunning()) {
            logger.warn("Container is already started");
            return;
        }
        if (this.checkSocket()) {
            throw new IllegalStateException(String.format("Another container is already running on %s:%d", ((Configuration)this.configuration).host, ((Configuration)this.configuration).port));
        }
        if (((Configuration)this.configuration).getDirectory() == null && ((Configuration)this.configuration).getDirectory().exists()) {
            throw new IllegalArgumentException("Directory of container must exist");
        }
        List<String> cmd = ((Configuration)this.configuration).generateCommand();
        cmd.addAll(((Configuration)this.configuration).getParams());
        logger.debug("Process arguments: " + cmd.toString());
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        StringBuilder javaOpts = new StringBuilder();
        if (((Configuration)this.configuration).getXms() != null) {
            javaOpts.append(" -Xms" + ((Configuration)this.configuration).getXms());
        }
        if (((Configuration)this.configuration).getXmx() != null) {
            javaOpts.append(" -Xmx" + ((Configuration)this.configuration).getXmx());
        }
        if (((Configuration)this.configuration).getMaxPermSize() != null) {
            javaOpts.append(" -XX:MaxPermSize=" + ((Configuration)this.configuration).getMaxPermSize());
        }
        javaOpts.append(" " + ((Configuration)this.configuration).getEnvProps().get("JAVA_OPTS"));
        javaOpts.append(" " + System.getenv("JAVA_OPTS"));
        processBuilder.environment().putAll(((Configuration)this.configuration).getEnvProps());
        final Process process = processBuilder.start();
        int attempts = 30;
        while (!this.checkSocket()) {
            if (--attempts <= 0) {
                throw new IllegalStateException("Container was not started");
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
            logger.info("Waiting for container...");
        }
        logger.info("Container was started");
        this.shutdownThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (process != null) {
                    process.destroy();
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException("Container was not stopped", e);
                    }
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
    }

    public synchronized void stop() throws Exception {
        if (this.isRunning()) {
            ((Client)this.client).close();
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread.start();
            this.shutdownThread = null;
            logger.info("Container was stopped");
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.stop();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public boolean isRunning() throws Exception {
        return this.shutdownThread != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean checkSocket() {
        try (Socket socket = new Socket(((Configuration)this.configuration).getHost(), (int)((Configuration)this.configuration).getPort());){
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public T getConfiguration() {
        return this.configuration;
    }

    public U getClient() {
        return this.client;
    }

    protected U createClient(T configuration) {
        try {
            return (U)((Client)this.clientClass.getConstructor(this.confClass).newInstance(configuration));
        }
        catch (Exception e) {
            logger.error("Client was not created");
            return null;
        }
    }

    protected void checkMandatoryProperty(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Property '%s' is mandatory", name));
        }
    }
}

