/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer.jboss;

import java.io.IOException;
import java.net.InetAddress;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.qa.jcontainer.Client;
import org.jboss.qa.jcontainer.jboss.JBossConfiguration;

public class JBossClient<T extends JBossConfiguration>
extends Client<T> {
    protected CommandContext context;

    public JBossClient(T configuration) {
        super(configuration);
    }

    @Override
    public boolean isConnected() {
        return this.context != null && this.context.isTerminated();
    }

    @Override
    protected void connectInternal() throws Exception {
        ModelControllerClient client = this.createClient(InetAddress.getByName(((JBossConfiguration)this.configuration).getHost()), ((JBossConfiguration)this.configuration).getManagementPort(), ((JBossConfiguration)this.configuration).getUsername(), ((JBossConfiguration)this.configuration).getPassword());
        this.context = this.createContext(client);
    }

    @Override
    protected boolean executeInternal(String command) throws Exception {
        ModelNode result = this.context.getModelControllerClient().execute(this.context.buildRequest(command));
        return this.isSuccess(result);
    }

    protected boolean isSuccess(ModelNode operationResponse) {
        if (operationResponse != null) {
            return operationResponse.hasDefined("outcome") && "success".equals(operationResponse.get("outcome").asString());
        }
        return false;
    }

    @Override
    protected void closeInternal() throws IOException {
        this.context.terminateSession();
        this.context = null;
    }

    protected ModelControllerClient createClient(InetAddress host, int port, final String username, final String password) {
        CallbackHandler callbackHandler = new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        NameCallback ncb = (NameCallback)current;
                        ncb.setName(username);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        pcb.setPassword(password.toCharArray());
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        RealmCallback rcb = (RealmCallback)current;
                        rcb.setText(rcb.getDefaultText());
                        continue;
                    }
                    throw new UnsupportedCallbackException(current);
                }
            }
        };
        return ModelControllerClient.Factory.create((InetAddress)host, (int)port, (CallbackHandler)callbackHandler);
    }

    protected CommandContext createContext(ModelControllerClient client) {
        CommandContext commandContext;
        try {
            commandContext = CommandContextFactory.getInstance().newCommandContext();
            commandContext.bindClient(client);
        }
        catch (CliInitializationException e) {
            throw new IllegalStateException("Failed to initialize CLI context", e);
        }
        return commandContext;
    }
}

