/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer.jboss;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jboss.qa.jcontainer.Configuration;
import org.jboss.qa.jcontainer.util.OSDetector;

public class JBossConfiguration
extends Configuration {
    protected final int managementPort;
    protected final String profile;
    protected final Mode mode;
    protected final File script;

    protected JBossConfiguration(Builder<?> builder) {
        super(builder);
        this.managementPort = builder.managementPort;
        this.profile = builder.profile;
        this.mode = builder.mode;
        this.script = builder.script;
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public String getProfile() {
        return this.profile;
    }

    public int getManagementPort() {
        return this.managementPort;
    }

    public Mode getMode() {
        return this.mode;
    }

    public File getBaseDir() {
        String modeVal = this.mode != null ? this.mode.getValue() : Mode.STANDALONE.getValue();
        return new File(this.directory, modeVal);
    }

    public File getConfigurationFolder() {
        return new File(this.getBaseDir(), "configuration");
    }

    @Override
    public List<String> generateCommand() {
        if (!this.script.exists()) {
            throw new IllegalStateException(String.format("Script '%s' does not exist", this.script.getAbsolutePath()));
        }
        ArrayList<String> cmd = new ArrayList<String>();
        if (OSDetector.isWindows()) {
            cmd.add("cmd");
            cmd.add("/c");
            cmd.add(this.script.getAbsolutePath());
        } else {
            cmd.add("/bin/bash");
            cmd.add(this.script.getAbsolutePath());
        }
        cmd.add("-c");
        cmd.add(this.profile);
        return cmd;
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Configuration.Builder<T> {
        protected int managementPort = 9990;
        protected String profile = "standalone.xml";
        protected Mode mode = Mode.STANDALONE;
        protected File script;

        public T managementPort(int managementPort) {
            this.managementPort = managementPort;
            return (T)((Builder)this.self());
        }

        public T profile(String profile) {
            this.profile = profile;
            return (T)((Builder)this.self());
        }

        public T mode(Mode mode) {
            this.mode = mode;
            return (T)((Builder)this.self());
        }

        public JBossConfiguration build() {
            this.script = this.mode.equals((Object)Mode.STANDALONE) ? new File(this.directory, "/bin/" + (OSDetector.isWindows() ? "standalone.bat" : "standalone.sh")) : new File(this.directory, "/bin/" + (OSDetector.isWindows() ? "domain.bat" : "domain.sh"));
            return new JBossConfiguration(this);
        }
    }

    public static enum Mode {
        STANDALONE("standalone"),
        MANAGEMENT("management");

        private final String mode;

        private Mode(String mode) {
            this.mode = mode;
        }

        public String getValue() {
            return this.mode;
        }
    }
}

