/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer.karaf;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jboss.qa.jcontainer.Configuration;
import org.jboss.qa.jcontainer.util.OSDetector;

public class KarafConfiguration
extends Configuration {
    protected final File keyFile;
    protected final File script;

    protected KarafConfiguration(Builder<?> builder) {
        super(builder);
        this.script = builder.script;
        this.keyFile = builder.keyFile;
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public File getKeyFile() {
        return this.keyFile;
    }

    @Override
    public List<String> generateCommand() {
        if (!this.script.exists()) {
            throw new IllegalStateException(String.format("Script '%s' does not exist", this.script.getAbsolutePath()));
        }
        ArrayList<String> cmd = new ArrayList<String>();
        if (OSDetector.isWindows()) {
            cmd.add("cmd");
            cmd.add("/c");
            cmd.add(this.script.getAbsolutePath());
        } else {
            cmd.add("/bin/bash");
            cmd.add(this.script.getAbsolutePath());
        }
        return cmd;
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Configuration.Builder<T> {
        protected File keyFile;
        protected File script;

        public Builder() {
            this.port = 8101;
            this.username = "karaf";
            this.password = "karaf";
        }

        public T keyFile(String keyFile) {
            this.keyFile = new File(keyFile);
            return (T)((Builder)this.self());
        }

        public KarafConfiguration build() {
            this.script = new File(this.directory, "/bin/" + (OSDetector.isWindows() ? "karaf.bat" : "karaf"));
            return new KarafConfiguration(this);
        }
    }
}

