/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.qa.jcontainer.karaf;

import java.io.File;
import java.util.HashMap;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.properties.PropertiesBackingEngineFactory;
import org.jboss.qa.jcontainer.Container;
import org.jboss.qa.jcontainer.User;
import org.jboss.qa.jcontainer.karaf.KarafClient;
import org.jboss.qa.jcontainer.karaf.KarafConfiguration;
import org.jboss.qa.jcontainer.karaf.KarafUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafContainer<T extends KarafConfiguration, U extends KarafClient<T>, V extends KarafUser>
extends Container<T, U, V> {
    private static final Logger logger = LoggerFactory.getLogger(KarafContainer.class);

    public KarafContainer(T configuration) {
        super(configuration);
    }

    @Override
    public void addUser(V user) throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        File usersFile = new File(((KarafConfiguration)this.configuration).getDirectory(), "etc" + File.separator + "users.properties");
        options.put("users", usersFile.getAbsolutePath());
        BackingEngine engine = new PropertiesBackingEngineFactory().build(options);
        engine.addUser(((User)user).getUsername(), ((User)user).getPassword());
        for (String role : ((User)user).getRoles()) {
            engine.addRole(((User)user).getUsername(), role);
        }
        for (String group : ((KarafUser)user).getGroups()) {
            engine.addGroup(((User)user).getUsername(), group);
        }
    }
}

